<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}
//use Restserver\Libraries\REST_Controller;
class Ordersadmin extends REST_Controller {
    var $service='orders';
    private $error=0;
    var $currentUser='';
    private $scopes='';
    public function __construct()
    {
        parent::__construct();
        $this->load->library("server");
        $this->server->require_scope("admin payments_usd shukavana","or");
        $this->currentUser=$this->users_model->userDataByEmailorUsername($this->server->access_token_data['user_id']);

        
        $this->scopes=explode(" ",$this->server->access_token_data['scope']);

        /*$this->load->model('oauth_sessions_model');
        $this->oauth_sessions_model->session_check();*/

        $this->load->model("orders/orders_model");
        $this->load->model("ashrams/poojas_model");
        $this->load->model("ashrams/ashrams_model");
        $this->load->model("ashrams/donations_model");
        $this->load->model("ashrams/store_model");

        /*if(!$this->session->userdata('id'))
        {
            $this->response([
                    'status' => FALSE,
                    'message' => 'Access denied'
                ], REST_Controller::HTTP_NOT_FOUND);
            $this->error=1;
        }
        if($this->error==0)
        {
            $this->currentUser=$this->session->userdata("admin_data");
            if(!in_array($this->currentUser->roles,array(1,3,4)))
            {
                $this->response([
                        'status' => FALSE,
                        'message' => 'Access denied'
                    ], REST_Controller::HTTP_NOT_FOUND);
                $this->error=1;
            }
        }*/
    }

    /**
    * @api {post} /ordersadmin Get Orders
    * @apiPermission Super Admin, Ashram Admin, Office Admin
    * @apiName List
    * @apiGroup Orders Admin
    *
    * @apiParam {Integer} [ashram_id] Ashram ID
    * @apiParam {String} [currency] Currency
    * @apiParam {Integer} [order_type] Seva Type<br>
                                            Array(<br>
                                            1=>"Poojas",<br>
                                            2=>"Donations"
                                            )
    * @apiParam {Integer} [created_by] Created By<br>
                                            Array(<br>
                                            0=>"Guest",<br>
                                            1=>"Admin",<br>
                                            2=>"User"
                                            )
    * @apiParam {Integer} [tokens] Token Status<br>
                                            Array(<br>
                                            0=>"Not issued",<br>
                                            1=>"Issued"
                                            )
    * @apiParam {String} [search_text] Search keyword(s)
    * @apiParam {Integer} [start=0] Number of record to start with 
    * @apiParam {Integer=20,50,100} [length]  Number of records to be displayed per page
    * @apiParam {String} [from_date]  From Date in format dd MM YYYY
    * @apiParam {String} [to_date]  To Date in format dd MM YYYY
    * @apiParam {String=name,id} [search_col]  Column name to search in
    * @apiParam {String=contains,starts,ends} [wild]  Wild card pattern
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
    *   [
            "recordsTotal": "29",
            "data": [
                {
                    "id": "131",
                    "order_number": "O-2017-01-100131",
                    "order_type": "1",
                    "date": "27 Jan 2017",
                    "username": "datta",
                    "transaction_id": "A11AA33F56E7",
                    "total_price": "USD 50",
                    "price_in_words": "Fifty",
                    "currency": "usd",
                    "created_by": "1",
                    "ashram_id": "4",
                    "payment_mode": "PayPal",
                    "firstname": "Datta",
                    "middlename": null,
                    "lastname": "Datta",
                    "email": "dattapeetham@dattapeetham.org",
                    "phone": "9009900990",
                    "address1": "D No 301 Rukamani Apartments",
                    "address2": "Road No 13",
                    "address3": "West Marredpally",
                    "city": "Secunderabad",
                    "state": "Telangana",
                    "country": "US",
                    "ip_address": "223.230.117.69",
                    "tokens": "0",
                    "sno": 1
                },
                {
                    "id": "131",
                    "order_number": "O-2017-01-100131",
                    "order_type": "1",
                    "date": "27 Jan 2017",
                    "username": "datta",
                    "transaction_id": "A11AA33F56E7",
                    "total_price": "USD 50",
                    "price_in_words": "Fifty",
                    "currency": "usd",
                    "created_by": "1",
                    "ashram_id": "4",
                    "payment_mode": "PayPal",
                    "firstname": "Datta",
                    "middlename": null,
                    "lastname": "Datta",
                    "email": "dattapeetham@dattapeetham.org",
                    "phone": "9009900990",
                    "address1": "D No 301 Rukamani Apartments",
                    "address2": "Road No 13",
                    "address3": "West Marredpally",
                    "city": "Secunderabad",
                    "state": "Telangana",
                    "country": "US",
                    "ip_address": "223.230.117.69",
                    "tokens": "0",
                    "sno": 1
                }
            ]
        ]
    *
    * @apiSuccess {Integer} recordsTotal Total number of orders
    * @apiSuccess {Object} data Orders object
    * @apiSuccess {Integer} data.id Unique identifier of Order
    * @apiSuccess {String} data.order_number Seva ID
    * @apiSuccess {Integer} data.order_type Type of Order (1=Pooja,2=Donation)
    * @apiSuccess {String} data.date Seva Date in format dd MMM YYYY
    * @apiSuccess {String} data.username User ID of user placed order
    * @apiSuccess {String} data.transaction_id Tx ID
    * @apiSuccess {String} data.total_price Total price
    * @apiSuccess {String} data.price_in_words Price in words
    * @apiSuccess {String} data.currency Currency
    * @apiSuccess {Integer} data.created_by Created By (0=>Guest,1=>Admin,2=>User)
    * @apiSuccess {Integer} data.ashram_id Ashram ID
    * @apiSuccess {String} data.payment_mode Payment mode
    * @apiSuccess {String} data.firstname First name of User
    * @apiSuccess {String}  data.middlename Middle name of User
    * @apiSuccess {String} data.lastname Last name of User
    * @apiSuccess {String} data.email Email ID of User
    * @apiSuccess {String} data.phone Phone number of User
    * @apiSuccess {String} data.address1 Address Line 1
    * @apiSuccess {String} data.address2 Address Line 2
    * @apiSuccess {String} data.address3 Address Line 3
    * @apiSuccess {String} data.city City
    * @apiSuccess {String} data.state State
    * @apiSuccess {String} data.country Country Code
    * @apiSuccess {String} data.ip_address IP Address
    * @apiSuccess {Integer} data.tokens Tokens issued or not (1=>Yes,0=>No)
    * @apiSuccess {Integer} data.sno Serial Number
    **/


    /**
    * @api {post} /ordersadmin/:id Order details
    * @apiPermission Super Admin, Ashram Admin, Office Admin
    * @apiName Order details
    * @apiGroup Orders Admin
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
    *   [
            "status": true,
            "order": {
                "id": "131",
                "order_number": "O-2017-01-100131",
                "order_type": "1",
                "date": "2017-01-27 15:26:48",
                "username": "datta",
                "transaction_id": "A11AA33F56E7",
                "total_price": "50",
                "price_in_words": "Fifty",
                "currency": "usd",
                "created_by": "1",
                "ashram_id": "4",
                "payment_mode": "PayPal",
                "firstname": "Datta",
                "middlename": null,
                "lastname": "Datta",
                "email": "dattapeetham@dattapeetham.org",
                "phone": "9009900990",
                "address1": "Address line 1",
                "address2": "Address line 2",
                "address3": "Address line 3y",
                "city": "Secunderabad",
                "state": "Telangana",
                "country": "US",
                "ip_address": "223.230.117.69",
                "tokens": "0",
                "zipcode": "500026",
                "initials": "sss",
                "trust_name": "Trust Name",
                "trust_address": "Address 1\nAddress 2",
                "ashram_footer": "Office Accounts\nSGS Ashrama\nMysore, India"
            },
            "order_items": [
                {
                    "id": "254",
                    "quantity": "1",
                    "item_name": "Appaji Birthday - Garland Seva",
                    "price": "25",
                    "note": "",
                    "dates": "28 Jan 2017"
                },
                {
                    "id": "255",
                    "quantity": "1",
                    "item_name": "Deepavali Mahalakshmi Puja, Bengaluru Ashrama",
                    "price": "25",
                    "note": "",
                    "dates": "28 Jan 2017"
                }
            ]
        ]
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    * @apiSuccess {Object} order Order object
    * @apiSuccess {Integer} order.id Unique identifier of Order
    * @apiSuccess {String} order.order_number Seva ID
    * @apiSuccess {Integer} order.order_type Type of Order (1=Pooja,2=Donation)
    * @apiSuccess {String} order.date Seva Date
    * @apiSuccess {String} order.username User ID of user placed order
    * @apiSuccess {String} order.transaction_id Tx ID
    * @apiSuccess {String} order.total_price Total price
    * @apiSuccess {String} order.price_in_words Price in words
    * @apiSuccess {String} order.currency Currency
    * @apiSuccess {Integer} order.created_by Created By (0=>Guest,1=>Admin,2=>User)
    * @apiSuccess {Integer} order.ashram_id Ashram ID
    * @apiSuccess {String} order.payment_mode Payment mode
    * @apiSuccess {String} order.firstname First name of User
    * @apiSuccess {String}  order.middlename Middle name of User
    * @apiSuccess {String} order.lastname Last name of User
    * @apiSuccess {String} order.email Email ID of User
    * @apiSuccess {String} order.phone Phone number of User
    * @apiSuccess {String} order.address1 Address Line 1
    * @apiSuccess {String} order.address2 Address Line 2
    * @apiSuccess {String} order.address3 Address Line 3
    * @apiSuccess {String} order.city City
    * @apiSuccess {String} order.state State
    * @apiSuccess {String} order.country Country Code
    * @apiSuccess {String} order.ip_address IP Address
    * @apiSuccess {Integer} order.tokens Tokens issued or not (1=>Yes,0=>No)
    * @apiSuccess {String} order.zipcode ZIP Code
    * @apiSuccess {String} order.initials Initials
    * @apiSuccess {String} order.trust_name Trust Name
    * @apiSuccess {String} order.trust_address Trust Address
    * @apiSuccess {String} order.ashram_footer Footer HTML text (Refer to website view)
    * @apiSuccess {Object} order_items Order items object
    * @apiSuccess {Integer} order_items.id Unique identifier
    * @apiSuccess {Integer} order_items.quantity Quantity
    * @apiSuccess {String} order_items.item_name Name of item
    * @apiSuccess {Integer} order_items.price Price
    * @apiSuccess {String} order_items.note Family details
    * @apiSuccess {String} order_items.dates Dates separated with comma
    **/

    public function index_post($id=0)
    {
        if($this->error)
            return;

        if($id==0)
        {
            $this->server->require_scope("admin payments_usd","or");
            $response['status']=false;

            if(in_array("payments_usd",$this->scopes))
            {
                if(!$this->input->post("currency") || $this->input->post("currency")!='usd')
                {
                    $response['message']="Currency filter is required";
                    goto end;
                }
                if(!$this->input->post("ashram_id") || $this->input->post("ashram_id")!='4')
                {
                    $response['message']="Ashram filter is required";
                    goto end;
                }
                if(!$this->input->post("payment_mode") || $this->input->post("payment_mode")!='paypal')
                {
                    $response['message']="Payment mode filter is required";
                    goto end;
                }
            }

            $list=$this->orders_model->listAdmin();
            unset($list['recordsFiltered']);
            foreach ($list['data'] as $key=>$row)
            {
                unset($list['data'][$key]['data']);
                unset($list['data'][$key]['old_data']);
                unset($list['data'][$key]['need_tax_letter']);
                unset($list['data'][$key]['indian']);
                unset($list['data'][$key]['donation_type']);
                unset($list['data'][$key]['tokens_issued_on']);
                unset($list['data'][$key]['tokens_issued_by']);
                unset($list['data'][$key]['user_id']);
                unset($list['data'][$key]['created_by_user_id']);
                unset($list['data'][$key]['status']);
                unset($list['data'][$key]['payment_status']);
            }
            $response=$list;
            $response['status']=true;

            if ($response['status'])
            {
                $this->response($response, REST_Controller::HTTP_OK);
            }
            else
            {
                end2:
                $this->response($response, REST_Controller::HTTP_NOT_FOUND);
            }
        }
        else
        {
            $this->server->require_scope("admin payments_usd shukavana","or");
            $response['status']=false;

            $orderData=$this->orders_model->orderData($id);

            if(in_array("payments_usd",$this->scopes))
            {
                if($orderData['order']->ashram_id!='4')
                {
                    $response['message']="Invalid Order";
                    goto end;
                }
                if($orderData['order']->currency!='usd')
                {
                    $response['message']="Invalid Order";
                    goto end;
                }
            }

            if(in_array("shukavana",$this->scopes))
            {
                if($orderData['order']->ashram_id!='4')
                {
                    $response['message']="Invalid Order";
                    goto end;
                }
                if(!in_array(shukavana_poojas,$orderData['order']->item_id))
                {
                    $response['message']="Invalid Order";
                    goto end;
                }
            }

            if(empty($orderData['order']))
            {
                $response['message']="Invalid Seva ID";
                goto end;
            }

            unset($orderData['order_items_files']);
            unset($orderData['order']->data);
            unset($orderData['order']->status);
            unset($orderData['order']->tokens_issued_by);
            unset($orderData['order']->old_data);
            unset($orderData['order']->need_tax_letter);
            unset($orderData['order']->indian);
            unset($orderData['order']->donation_type);
            unset($orderData['order']->tokens_issued_on);
            unset($orderData['order']->created_by_user_id);
            unset($orderData['order']->payment_status);
            unset($orderData['order']->user_id);
            
            $orderData['order']->zipcode=$orderData['order']->zipcode;
            $orderData['order']->initials=$orderData['order']->donation_initials;

            $orderData['order']->trust_name=$orderData['order']->trust_name;
            $orderData['order']->trust_address=$orderData['order']->trust_address;
            $orderData['order']->ashram_footer=$orderData['order']->trust_ashram_footer;
            

            foreach ($orderData['order_items'] as $key => $item)
            {
                unset($orderData['order_items'][$key]->options);
                unset($orderData['order_items'][$key]->category);
                unset($orderData['order_items'][$key]->shipping);
                unset($orderData['order_items'][$key]->shipping_price);
                unset($orderData['order_items'][$key]->sequence);
                unset($orderData['order_items'][$key]->order_id);
                unset($orderData['order_items'][$key]->item_id);
                unset($orderData['order_items'][$key]->start_date);
                unset($orderData['order_items'][$key]->end_date);
                unset($orderData['order_items'][$key]->time_from);
                unset($orderData['order_items'][$key]->time_to);
                $orderData['order_items'][$key]->dates=$orderData['order_items'][$key]->schedule_dates;
                unset($orderData['order_items'][$key]->schedule_dates);
            }

            $response['status']=true;
            $response['order']=$orderData['order'];
            $response['order_items']=$orderData['order_items'];

            if ($response['status'])
            {
                $this->response($response, REST_Controller::HTTP_OK);
            }
            else
            {
                end:
                $this->response($response, REST_Controller::HTTP_NOT_FOUND);
            }
        }
    }

    public function poojas_post($id=0)
    {
        if($this->error)
            return;

        $response['status']=false;
        $this->server->require_scope("admin shukavana","or");

        if(in_array("shukavana",$this->scopes))
        {
            if(!$this->input->post("ashram_id") || $this->input->post("ashram_id")!='4')
            {
                $response['message']="Ashram filter is required";
                goto end;
            }
            if($this->input->post("ashram_id")=='4' && !$this->session->userdata("ashramId"))
            {
                $this->session->set_userdata('ashramId',4);
                $this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());
            }
            if(!$this->input->post("pooja_id"))
            {
                $response['message']="Pooja filter is required";
                goto end;
            }
            if(!is_array($this->input->post("pooja_id")))
            {
                $response['message']="Pooja filter must be an array";
                goto end;
            }
            if($this->session->userdata("ashramId"))
            {
                $poojas=$this->poojas_model->getByAshramId($this->session->userdata("ashramId"));
                $poojasArray=array();
                foreach ($poojas as $poojaData)
                {
                    $poojasArray[$poojaData->id]=$poojaData;
                }
            }

            $pooja_error=0;
            foreach ($this->input->post("pooja_id") as $pooja_id)
            {
                if(!in_array($pooja_id,shukavana_poojas) || !isset($poojasArray[$pooja_id]))
                {
                    $pooja_error=1;
                    break;
                }
            }
            if($pooja_error==1)
            {
                $response['message']="Invalid poojas";
                goto end;
            }
        }
        if(!$this->input->post("ashram_id") && $this->session->userdata("ashramId")!='')
        {
            $this->session->unset_userdata('ashramId');
            $this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());
        }

        $list=$this->orders_model->listAdminPoojas();
        unset($list['recordsFiltered']);
        foreach ($list['data'] as $key=>$row)
        {
            unset($list['data'][$key]['data']);
            unset($list['data'][$key]['old_data']);
            unset($list['data'][$key]['need_tax_letter']);
            unset($list['data'][$key]['indian']);
            unset($list['data'][$key]['donation_type']);
            unset($list['data'][$key]['tokens_issued_on']);
            unset($list['data'][$key]['tokens_issued_by']);
            unset($list['data'][$key]['user_id']);
            unset($list['data'][$key]['created_by_user_id']);
            unset($list['data'][$key]['status']);
            unset($list['data'][$key]['payment_status']);
            unset($list['data'][$key]['sequence']);
            unset($list['data'][$key]['schedule_dates']);
            unset($list['data'][$key]['start_date']);
            unset($list['data'][$key]['end_date']);
            unset($list['data'][$key]['time_to']);
            unset($list['data'][$key]['time_from']);
            unset($list['data'][$key]['ip_address']);
            unset($list['data'][$key]['category']);
            unset($list['data'][$key]['options']);
            unset($list['data'][$key]['item_id']);
            unset($list['data'][$key]['order_type']);
        }
        unset($list['from_date']);
        unset($list['to_date']);
        $response=$list;
        $response['status']=true;

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    public function donations_post($id=0)
    {
        if($this->error)
            return;

        $response['status']=false;
        $this->server->require_scope("admin shukavana","or");

        if(in_array("shukavana",$this->scopes))
        {
            if(!$this->input->post("ashram_id") || $this->input->post("ashram_id")!='4')
            {
                $response['message']="Ashram filter is required";
                goto end;
            }
            if($this->input->post("ashram_id")=='4' && !$this->session->userdata("ashramId"))
            {
                $this->session->set_userdata('ashramId',4);
                $this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());
            }
            if(!$this->input->post("donation_id"))
            {
                $response['message']="Donation filter is required";
                goto end;
            }
            if(!is_array($this->input->post("donation_id")))
            {
                $response['message']="Donation filter must be an array";
                goto end;
            }
            if($this->session->userdata("ashramId"))
            {
                $donations=$this->donations_model->getByAshramId($this->session->userdata("ashramId"));
                $donationsArray=array();
                foreach ($donations as $donationData)
                {
                    $donationsArray[$donationData->id]=$donationData;
                }
            }

            $donation_error=0;
            foreach ($this->input->post("donation_id") as $donation_id)
            {
                if(!in_array($donation_id,shukavana_donations) || !isset($donationsArray[$donation_id]))
                {
                    $donation_error=1;
                    break;
                }
            }
            if($donation_error==1)
            {
                $response['message']="Invalid donations";
                goto end;
            }
        }

        if(!$this->input->post("ashram_id") && $this->session->userdata("ashramId")!='')
        {
            $this->session->unset_userdata('ashramId');
            $this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());
        }

        $list=$this->orders_model->listAdminDonations();
        unset($list['recordsFiltered']);
        foreach ($list['data'] as $key=>$row)
        {
            unset($list['data'][$key]['data']);
            unset($list['data'][$key]['old_data']);
            unset($list['data'][$key]['need_tax_letter']);
            unset($list['data'][$key]['indian']);
            unset($list['data'][$key]['donation_type']);
            unset($list['data'][$key]['tokens_issued_on']);
            unset($list['data'][$key]['tokens_issued_by']);
            unset($list['data'][$key]['user_id']);
            unset($list['data'][$key]['created_by_user_id']);
            unset($list['data'][$key]['status']);
            unset($list['data'][$key]['payment_status']);
            unset($list['data'][$key]['sequence']);
            unset($list['data'][$key]['schedule_dates']);
            unset($list['data'][$key]['start_date']);
            unset($list['data'][$key]['end_date']);
            unset($list['data'][$key]['time_to']);
            unset($list['data'][$key]['time_from']);
            unset($list['data'][$key]['ip_address']);
            unset($list['data'][$key]['category']);
            unset($list['data'][$key]['options']);
            unset($list['data'][$key]['item_id']);
            unset($list['data'][$key]['order_type']);
        }
        unset($list['from_date']);
        unset($list['to_date']);
        $response=$list;
        $response['status']=true;

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    public function store_post($id=0)
    {
        if($this->error)
            return;

        $response['status']=false;

        if(!$this->input->post("ashram_id") && $this->session->userdata("ashramId")!='')
        {
            $this->session->unset_userdata('ashramId');
            $this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());
        }

        $list=$this->orders_model->listAdminStore();
        unset($list['recordsFiltered']);
        foreach ($list['data'] as $key=>$row)
        {
            unset($list['data'][$key]['data']);
            unset($list['data'][$key]['old_data']);
            unset($list['data'][$key]['need_tax_letter']);
            unset($list['data'][$key]['indian']);
            unset($list['data'][$key]['donation_type']);
            unset($list['data'][$key]['tokens_issued_on']);
            unset($list['data'][$key]['tokens_issued_by']);
            unset($list['data'][$key]['user_id']);
            unset($list['data'][$key]['created_by_user_id']);
            unset($list['data'][$key]['status']);
            unset($list['data'][$key]['payment_status']);
            unset($list['data'][$key]['sequence']);
            unset($list['data'][$key]['schedule_dates']);
            unset($list['data'][$key]['start_date']);
            unset($list['data'][$key]['end_date']);
            unset($list['data'][$key]['time_to']);
            unset($list['data'][$key]['time_from']);
            unset($list['data'][$key]['ip_address']);
            unset($list['data'][$key]['category']);
            unset($list['data'][$key]['options']);
            unset($list['data'][$key]['item_id']);
            unset($list['data'][$key]['order_type']);
        }
        unset($list['from_date']);
        unset($list['to_date']);
        $response=$list;
        $response['status']=true;

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /ordersadmin/send_order_details_email/:id Order details email
    * @apiPermission Super Admin, Ashram Admin, Office Admin
    * @apiName Order details email
    * @apiGroup Orders Admin
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
        {
            "status": "true"
        }
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    **/

    public function send_order_details_email_post($id=0)
    {
        $this->server->require_scope("admin");
        $response['status']=false;

        if(is_numeric($id) && $id)
        {
            $flag=$this->orders_model->sendOrderDetailsEmail($id);
            if($flag)
            $response['status']=true;
        }

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /ordersadmin/send_order_receipt_email/:id Order receipt email
    * @apiPermission Super Admin, Ashram Admin, Office Admin
    * @apiName Order receipt email
    * @apiGroup Orders Admin
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
        {
            "status": "true"
        }
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    **/

    public function send_order_receipt_email_post($id=0)
    {
        $this->server->require_scope("admin");
        $response['status']=false;

        if(is_numeric($id) && $id)
        {
            $flag=$this->orders_model->sendOrderReceiptEmail($id);
            if($flag)
            $response['status']=true;
        }

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /ordersadmin/issue_tokens/:id Issue Tokens
    * @apiPermission Super Admin, Ashram Admin, Office Admin
    * @apiName Issue tokens
    * @apiGroup Orders Admin
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
        {
            "status": "true"
        }
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    **/

    public function issue_tokens_post($id=0)
    {
        $this->server->require_scope("admin");
        $response['status']=false;

        if(is_numeric($id) && $id)
        {
            $flag=$this->orders_model->tokenIssued($id);
            if($flag)
            $response['status']=true;
        }

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

}
?>