<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}
//use Restserver\Libraries\REST_Controller;
class Orders extends REST_Controller {
    var $service='orders';
    var $currentUser='';
    function __construct()
    {
        parent::__construct();
        $this->load->library("server");
        $this->server->require_scope("user");
        //$this->load->model('oauth_sessions_model');
        //$this->oauth_sessions_model->session_check();

        $this->load->model("orders/orders_model");
        $this->load->model("orders/transaction_model");
        $this->load->model("orders/subscription_payments_model");
        $this->load->model("user/users_model");
        $this->load->model("pets_model");
        $this->load->model("subscriptions/donors_model");
        
        $this->currentUser=$this->users_model->userDataByEmailorUsername($this->server->access_token_data['user_id']);
        /*if($this->session->userdata('id'))
            $this->currentUser=$this->session->userdata("admin_data");
        else
            $this->currentUser=$this->session->userdata("user_data");*/
    }

    /**
    * @api {post} /orders Get Orders
    * @apiPermission User
    * @apiName List
    * @apiGroup Orders
    *
    * @apiParam {String} [search_text] Search keyword(s)
    * @apiParam {Integer} [start=0] Number of record to start with 
    * @apiParam {Integer=20,50,100} [length]  Number of records to be displayed per page
    * @apiParam {String} [from_date]  From Date in format dd MM YYYY
    * @apiParam {String} [to_date]  To Date in format dd MM YYYY
    * @apiParam {String=transaction_id,order_number} [search_col]  Column name to search in
    * @apiParam {String=contains,starts,ends} [wild]  Wild card pattern
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
    *   [
            "recordsTotal": "29",
            "data": [
                {
                    "id": "131",
                    "order_number": "O-2017-01-100131",
                    "order_type": "1",
                    "date": "27 Jan 2017",
                    "username": "datta",
                    "transaction_id": "A11AA33F56E7",
                    "total_price": "USD 50",
                    "price_in_words": "Fifty",
                    "currency": "usd",
                    "created_by": "1",
                    "ashram_id": "4",
                    "payment_mode": "PayPal",
                    "firstname": "Datta",
                    "middlename": null,
                    "lastname": "Datta",
                    "email": "dattapeetham@dattapeetham.org",
                    "phone": "9009900990",
                    "address1": "D No 301 Rukamani Apartments",
                    "address2": "Road No 13",
                    "address3": "West Marredpally",
                    "city": "Secunderabad",
                    "state": "Telangana",
                    "country": "US",
                    "ip_address": "223.230.117.69",
                    "tokens": "0",
                    "sno": 1
                },
                {
                    "id": "131",
                    "order_number": "O-2017-01-100131",
                    "order_type": "1",
                    "date": "27 Jan 2017",
                    "username": "datta",
                    "transaction_id": "A11AA33F56E7",
                    "total_price": "USD 50",
                    "price_in_words": "Fifty",
                    "currency": "usd",
                    "created_by": "1",
                    "ashram_id": "4",
                    "payment_mode": "PayPal",
                    "firstname": "Datta",
                    "middlename": null,
                    "lastname": "Datta",
                    "email": "dattapeetham@dattapeetham.org",
                    "phone": "9009900990",
                    "address1": "D No 301 Rukamani Apartments",
                    "address2": "Road No 13",
                    "address3": "West Marredpally",
                    "city": "Secunderabad",
                    "state": "Telangana",
                    "country": "US",
                    "ip_address": "223.230.117.69",
                    "tokens": "0",
                    "sno": 1
                }
            ]
        ]
    *
    * @apiSuccess {Integer} recordsTotal Total number of orders
    * @apiSuccess {Object} data Orders object
    * @apiSuccess {Integer} data.id Unique identifier of Order
    * @apiSuccess {String} data.order_number Seva ID
    * @apiSuccess {Integer} data.order_type Type of Order (1=Pooja,2=Donation)
    * @apiSuccess {String} data.date Seva Date in format dd MMM YYYY
    * @apiSuccess {String} data.username User ID of user placed order
    * @apiSuccess {String} data.transaction_id Tx ID
    * @apiSuccess {String} data.total_price Total price
    * @apiSuccess {String} data.price_in_words Price in words
    * @apiSuccess {String} data.currency Currency
    * @apiSuccess {Integer} data.created_by Created By (0=>Guest,1=>Admin,2=>User)
    * @apiSuccess {Integer} data.ashram_id Ashram ID
    * @apiSuccess {String} data.payment_mode Payment mode
    * @apiSuccess {String} data.firstname First name of User
    * @apiSuccess {String}  data.middlename Middle name of User
    * @apiSuccess {String} data.lastname Last name of User
    * @apiSuccess {String} data.email Email ID of User
    * @apiSuccess {String} data.phone Phone number of User
    * @apiSuccess {String} data.address1 Address Line 1
    * @apiSuccess {String} data.address2 Address Line 2
    * @apiSuccess {String} data.address3 Address Line 3
    * @apiSuccess {String} data.city City
    * @apiSuccess {String} data.state State
    * @apiSuccess {String} data.country Country Code
    * @apiSuccess {String} data.ip_address IP Address
    * @apiSuccess {Integer} data.tokens Tokens issued or not (1=>Yes,0=>No)
    * @apiSuccess {Integer} data.sno Serial Number
    **/


    /**
    * @api {post} /orders/:id Order details
    * @apiPermission User
    * @apiName Order details
    * @apiGroup Orders
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
    *   [
            "status": true,
            "order": {
                "id": "131",
                "order_number": "O-2017-01-100131",
                "order_type": "1",
                "date": "2017-01-27 15:26:48",
                "username": "datta",
                "transaction_id": "A11AA33F56E7",
                "total_price": "50",
                "price_in_words": "Fifty",
                "currency": "usd",
                "created_by": "1",
                "ashram_id": "4",
                "payment_mode": "PayPal",
                "firstname": "Datta",
                "middlename": null,
                "lastname": "Datta",
                "email": "dattapeetham@dattapeetham.org",
                "phone": "9009900990",
                "address1": "Address line 1",
                "address2": "Address line 2",
                "address3": "Address line 3y",
                "city": "Secunderabad",
                "state": "Telangana",
                "country": "US",
                "ip_address": "223.230.117.69",
                "tokens": "0",
                "zipcode": "500026",
                "initials": "sss",
                "trust_name": "Trust Name",
                "trust_address": "Address 1\nAddress 2",
                "ashram_footer": "Office Accounts\nSGS Ashrama\nMysore, India"
            },
            "order_items": [
                {
                    "id": "254",
                    "quantity": "1",
                    "item_name": "Appaji Birthday - Garland Seva",
                    "price": "25",
                    "note": "",
                    "dates": "28 Jan 2017"
                },
                {
                    "id": "255",
                    "quantity": "1",
                    "item_name": "Deepavali Mahalakshmi Puja, Bengaluru Ashrama",
                    "price": "25",
                    "note": "",
                    "dates": "28 Jan 2017"
                }
            ]
        ]
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    * @apiSuccess {Object} order Order object
    * @apiSuccess {Integer} order.id Unique identifier of Order
    * @apiSuccess {String} order.order_number Seva ID
    * @apiSuccess {Integer} order.order_type Type of Order (1=Pooja,2=Donation)
    * @apiSuccess {String} order.date Seva Date
    * @apiSuccess {String} order.username User ID of user placed order
    * @apiSuccess {String} order.transaction_id Tx ID
    * @apiSuccess {String} order.total_price Total price
    * @apiSuccess {String} order.price_in_words Price in words
    * @apiSuccess {String} order.currency Currency
    * @apiSuccess {Integer} order.created_by Created By (0=>Guest,1=>Admin,2=>User)
    * @apiSuccess {Integer} order.ashram_id Ashram ID
    * @apiSuccess {String} order.payment_mode Payment mode
    * @apiSuccess {String} order.firstname First name of User
    * @apiSuccess {String}  order.middlename Middle name of User
    * @apiSuccess {String} order.lastname Last name of User
    * @apiSuccess {String} order.email Email ID of User
    * @apiSuccess {String} order.phone Phone number of User
    * @apiSuccess {String} order.address1 Address Line 1
    * @apiSuccess {String} order.address2 Address Line 2
    * @apiSuccess {String} order.address3 Address Line 3
    * @apiSuccess {String} order.city City
    * @apiSuccess {String} order.state State
    * @apiSuccess {String} order.country Country Code
    * @apiSuccess {String} order.ip_address IP Address
    * @apiSuccess {Integer} order.tokens Tokens issued or not (1=>Yes,0=>No)
    * @apiSuccess {String} order.zipcode ZIP Code
    * @apiSuccess {String} order.initials Initials
    * @apiSuccess {String} order.trust_name Trust Name
    * @apiSuccess {String} order.trust_address Trust Address
    * @apiSuccess {String} order.ashram_footer Footer HTML text (Refer to website view)
    * @apiSuccess {Object} order_items Order items object
    * @apiSuccess {Integer} order_items.id Unique identifier
    * @apiSuccess {Integer} order_items.quantity Quantity
    * @apiSuccess {String} order_items.item_name Name of item
    * @apiSuccess {Integer} order_items.price Price
    * @apiSuccess {String} order_items.note Family details
    * @apiSuccess {String} order_items.dates Dates separated with comma
    **/

    public function index_post($id=0)
    {
        if($id==0)
        {
            $this->acl_model->app_acl();
            
            $list=$this->orders_model->listUser();
            unset($list['recordsFiltered']);
            foreach ($list['data'] as $key=>$row)
            {
                unset($list['data'][$key]['data']);
                unset($list['data'][$key]['old_data']);
                unset($list['data'][$key]['need_tax_letter']);
                unset($list['data'][$key]['indian']);
                unset($list['data'][$key]['donation_type']);
                unset($list['data'][$key]['tokens_issued_on']);
                unset($list['data'][$key]['tokens_issued_by']);
                unset($list['data'][$key]['user_id']);
                unset($list['data'][$key]['created_by_user_id']);
                unset($list['data'][$key]['status']);
            }
            $this->set_response($list, REST_Controller::HTTP_OK);
        }
        else
        {
            $response['status']=FALSE;
            $response['message']="Mobile app is not working. Please use website only";
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
            return true;
            die();

            $orderData=$this->orders_model->orderData($id);
            
            if(empty($orderData['order']))
            {
                $response['message']="Invalid Seva ID";
                goto end;
            }
            if($orderData['order']->user_id!=$this->currentUser->id)
            {
                $response['message']="Invalid Seva ID";
                goto end;
            }
            
            unset($orderData['order_items_files']);
            unset($orderData['order']->data);
            unset($orderData['order']->status);
            unset($orderData['order']->tokens_issued_by);
            unset($orderData['order']->old_data);
            unset($orderData['order']->need_tax_letter);
            unset($orderData['order']->indian);
            unset($orderData['order']->donation_type);
            unset($orderData['order']->tokens_issued_on);
            unset($orderData['order']->created_by_user_id);
            unset($orderData['order']->payment_status);
            unset($orderData['order']->user_id);

            $orderData['order']->date=date("d M Y h:i A",strtotime($orderData['order']->date));
            
            $orderData['order']->zipcode=$orderData['order']->zipcode;
            $orderData['order']->initials=$orderData['order']->donation_initials;
            $orderData['order']->preferred_name=$orderData['order']->preferred_name;

            $orderData['order']->trust_name=$orderData['order']->trust_name;
            $orderData['order']->trust_address=$orderData['order']->trust_address;
            $orderData['order']->ashram_footer=$orderData['order']->trust_ashram_footer;

            $countryData=$this->locations_model->getCountryByCode($orderData['order']->country);
            $orderData['order']->country=$countryData->country_name;
            
            //Donor details for donations
            if($orderData['order']->order_type==2)
            {
                $donorIds=array();
                foreach ($orderData['order_items'] as $item)
                {
                    if(!in_array($item->donor_id,$donorIds) && $item->donor_id)
                    {
                        $donorIds[]=$item->donor_id;
                    }
                }
                if(!empty($donorIds))
                {
                    $donors=$this->donors_model->donorsByIds($donorIds);
                }
            }
            //Donor details for donations

            $orderData['order']->contains_subscription=0;

            foreach ($orderData['order_items'] as $key => $item)
            {
                if($item->subscription==1 && $orderData['order']->contains_subscription==0)
                {
                    $orderData['order']->contains_subscription=1;
                }

                unset($orderData['order_items'][$key]->options);
                unset($orderData['order_items'][$key]->category);
                unset($orderData['order_items'][$key]->shipping_price);
                unset($orderData['order_items'][$key]->sequence);
                unset($orderData['order_items'][$key]->order_id);
                unset($orderData['order_items'][$key]->item_id);
                unset($orderData['order_items'][$key]->start_date);
                unset($orderData['order_items'][$key]->end_date);
                unset($orderData['order_items'][$key]->time_from);
                unset($orderData['order_items'][$key]->time_to);
                $orderData['order_items'][$key]->dates=$orderData['order_items'][$key]->schedule_dates;
                if($orderData['order']->order_type==3)
                {
                    if($item->shipping==1)
                    {
                        if($item->shipping_address1!='')
                        {
                            $item->shipping_address=htmlentities($item->shipping_address1)."<br>";
                            if($item->shipping_address2!='')
                                $item->shipping_address.=htmlentities($item->shipping_address2)."<br>";
                            if($item->shipping_address3!='')
                                $item->shipping_address.=htmlentities($item->shipping_address3)."<br>";

                            $item->shipping_address.=htmlentities($item->shipping_city)."<br>".
                                htmlentities($item->shipping_state)."<br>".
                                htmlentities($item->shipping_country_name);
                        }
                        else
                        {
                            $item->shipping_address=htmlentities($orderData['order']->address1)."<br>";
                            if($orderData['order']->address2!='')
                                $item->shipping_address.=htmlentities($orderData['order']->address2)."<br>";
                            if($orderData['order']->address3)
                                $item->shipping_address.=htmlentities($orderData['order']->address3)."<br>";
                            $item->shipping_address.=htmlentities($orderData['order']->city).", ".
                                htmlentities($orderData['order']->state);
                            if(isset($orderData['order']->zipcode)!='')
                            {
                                $item->shipping_address.=" - ".$orderData['order']->zipcode;
                            }
                            $item->shipping_address.="<br>".htmlentities($countryData->country_name);
                        }
                    }
                    else
                    {
                        if($item->gift_friend_email!='')
                        {
                            $item->shipping_address=$item->gift_friend_email;
                        }
                        else
                            $item->shipping_address='N/A';
                    }
                }
                

                if($item->subscription==1)
                {
                    $item_payments=$this->subscription_payments_model->getAllByOrderItem($item->order_item_id);

                    $first_date=$item->schedule_dates;

                    foreach ($item_payments as $skey => $spayment)
                    {
                        $item_payments[$skey]->date =date("d M Y h:i A",strtotime($spayment->date));
                        $period=$item->period;
                        $item_payments[$skey]->payment_date=date("d M Y",strtotime("+".($spayment->payment_number-1)." ".$period,strtotime($first_date)));

                        $item_payments[$skey]->transaction_amount=strtoupper($orderData['order']->currency)." ".$spayment->amount;

                        $item_payments[$skey]->transaction_date="-";
                        if($spayment->status!=0)
                        {
                            $item_payments[$skey]->transaction_date=date("d M Y h:i A",strtotime($spayment->created_on));
                        }
                        if($spayment->status==0)
                            $item_payments[$skey]->tx="-";

                        unset($item_payments[$skey]->note);

                        if(in_array(strtolower($spayment->tx_status),array("completed",'success','release payment','Release Payment','approved','captured','paid')))
                        {
                            $item_payments[$skey]->transaction_status='paid';
                        }
                        else if($spayment->tx_status=='pending' || $spayment->tx_status=='cash_pending')
                        {
                            $item_payments[$skey]->transaction_status='pending';
                        }
                        else if($spayment->tx_status=='inprocess')
                        {
                            $item_payments[$skey]->transaction_status='inprocess';
                        }
                        else if($spayment->tx_status=='bounced')
                        {
                            $item_payments[$skey]->transaction_status='bounced';
                        }
                        else
                        {
                            if($spayment->tx_status=='')
                            {
                                $item_payments[$skey]->transaction_status='pending';
                            }
                            else
                            {
                                $item_payments[$skey]->transaction_status='failure';
                            }
                        }

                        if($item_payments[$skey]->transaction_status=='pending')
                        {
                            $item_payments[$skey]->payment_mode="-";
                        }

                    }

                    $orderData['order_items'][$key]->all_payments=$item_payments;
                    $orderData['order_items'][$key]->all_payments_count=count($item_payments);


                    $item_payments=$this->subscription_payments_model->getByOrderItem($item->order_item_id);
                    foreach ($item_payments as $skey => $spayment)
                    {
                        $item_payments[$skey]->date =date("d M Y h:i A",strtotime($spayment->date));
                        $period=$item->period;
                        $item_payments[$skey]->payment_date=date("d M Y",strtotime("+".($spayment->payment_number-1)." ".$period,strtotime($first_date)));

                        $item_payments[$skey]->transaction_amount=strtoupper($orderData['order']->currency)." ".$spayment->amount;

                        $item_payments[$skey]->transaction_date="-";
                        if($spayment->status!=0)
                        {
                            $item_payments[$skey]->transaction_date=date("d M Y h:i A",strtotime($spayment->date));
                        }
                        if($spayment->status==0)
                            $item_payments[$skey]->tx="-";
                        unset($item_payments[$skey]->note);

                        if(in_array(strtolower($spayment->tx_status),array("completed",'success','release payment','Release Payment','approved','captured','paid')))
                        {
                            $item_payments[$skey]->transaction_status='paid';
                        }
                        else if($spayment->tx_status=='pending' || $spayment->tx_status=='cash_pending')
                        {
                            $item_payments[$skey]->transaction_status='pending';
                        }
                        else if($spayment->tx_status=='inprocess')
                        {
                            $item_payments[$skey]->transaction_status='inprocess';
                        }
                        else if($spayment->tx_status=='bounced')
                        {
                            $item_payments[$skey]->transaction_status='bounced';
                        }
                        else
                        {
                            if($spayment->tx_status=='')
                            {
                                $item_payments[$skey]->transaction_status='pending';
                            }
                            else
                            {
                                $item_payments[$skey]->transaction_status='failure';
                            }
                        }

                        if($item_payments[$skey]->transaction_status=='pending')
                        {
                            $item_payments[$skey]->payment_mode="-";
                        }
                    }
                    $orderData['order_items'][$key]->payments=$item_payments;
                    $orderData['order_items'][$key]->payments_count=count($item_payments);
                }
                else
                {
                    $orderData['order_items'][$key]->all_payments_count=0;
                    $orderData['order_items'][$key]->all_payments='';
                }

                //Donor details as family details for subscriptions
                if($item->subscription==1)
                {
                    if(isset($donors))
                    {
                        $item->note=$donors[$item->donor_id]->donor_name;
                        $item->note.="<br>+".$donors[$item->donor_id]->donor_country_isd." ".$donors[$item->donor_id]->donor_phone;
                        if($donors[$item->donor_id]->donor_email!='')
                        {
                            $item->note.="<br>".$donors[$item->donor_id]->donor_email;
                        }
                    }
                    else
                    {
                        $item->note="N/A";
                    }
                }
                else
                {
                    if($item->note!='')
                        $item->note=nl2br(htmlentities($item->note));
                    else
                        $item->note="NA";
                }

                //Price calculations
                $orderData['order_items'][$key]->price_display=strtoupper($orderData['order']->currency)." ".$item->price;
                if($orderData['order']->order_type==3 && $item->shipping==1)
                {
                    $orderData['order_items'][$key]->price_display.="<br><span style='font-weight:normal; font-size:12px;'>Shipping: ".strtoupper($orderData['order']->currency)." ".($item->shipping_price/$item->quantity)."</span>";
                }

                $orderData['order_items'][$key]->total_price_display=strtoupper($orderData['order']->currency)." ".($item->price*$item->quantity);
                if($orderData['order']->order_type==3 && $item->shipping==1)
                {
                    $orderData['order_items'][$key]->total_price_display.="<br><span style='font-weight:normal; font-size:12px;'>Shipping: ".strtoupper($orderData['order']->currency)." ".$item->shipping_price."</span>";
                }
                if($item->onetime_charge)
                {
                    $orderData['order_items'][$key]->total_price_display.="<br><span style='font-weight:bold; font-size:12px;'>".strtoupper($orderData['order']->currency)." ".$item->onetime_charge." (One time fee)</span>";
                }

                unset($orderData['order_items'][$key]->schedule_dates);
            }
            //Onetime transactions
            $total_onetime_tx=0;
            $sno=1;
            $transactions=$this->transaction_model->getTransactionsByOrder($id,0,2,1);
            foreach ($transactions as $tkey=>$transaction)
            {
                if(empty($transaction->amount))
                {
                    unset($transactions[$tkey]);
                    continue;
                }
                $total_onetime_tx++;

                $transactions[$tkey]->sno=$sno;
                $transactions[$tkey]->created_on=date("d M Y h:i A",strtotime($transaction->created_on));
                $transactions[$tkey]->transaction_amount=strtoupper($transaction->currency)." ".$transaction->amount;
                if(in_array($transaction->status,array("pending","cash_pending")))
                    $transactions[$tkey]->payment_mode="-";

                unset($transactions[$tkey]->note);



                if(in_array(strtolower($transaction->status),array("completed",'success','release payment','Release Payment','approved','captured','paid')))
                {
                    $transactions[$tkey]->transaction_status="paid";
                }
                else if(in_array($transaction->status,array("pending","cash_pending")))
                {
                    $transactions[$tkey]->transaction_status="pending";
                }
                else
                {
                    if($transaction->status=='inprocess')
                    {
                        $transactions[$tkey]->transaction_status="inprocess";
                    }
                    else if($transaction->status=='bounced')
                    {
                        $transactions[$tkey]->transaction_status="bounced";
                    }
                    else
                    {
                        $transactions[$tkey]->transaction_status="N/A";
                    }
                }

                $sno++;
            }
            $response['all_one_time_transactions']=$transactions;
            $response['all_one_time_transactions_count']=count($transactions);

            $sno=1;
            $transactions=$this->transaction_model->getTransactionsByOrder($id,0,0,1);
            foreach ($transactions as $tkey=>$transaction)
            {
                if(empty($transaction->amount))
                {
                    unset($transactions[$tkey]);
                    continue;
                }
                $total_onetime_tx++;

                $transactions[$tkey]->sno=$sno;
                $transactions[$tkey]->created_on=date("d M Y h:i A",strtotime($transaction->created_on));
                $transactions[$tkey]->transaction_amount=strtoupper($transaction->currency)." ".$transaction->amount;
                if(in_array($transaction->status,array("pending","cash_pending")))
                    $transactions[$tkey]->payment_mode="-";
                
                unset($transactions[$tkey]->note);

                if(in_array(strtolower($transaction->status),array("completed",'success','release payment','Release Payment','approved','captured','paid')))
                {
                    $transactions[$tkey]->transaction_status="paid";
                }
                else if(in_array($transaction->status,array("pending","cash_pending")))
                {
                    $transactions[$tkey]->transaction_status="pending";
                }
                else
                {
                    if($transaction->status=='inprocess')
                    {
                        $transactions[$tkey]->transaction_status="inprocess";
                    }
                    else if($transaction->status=='bounced')
                    {
                        $transactions[$tkey]->transaction_status="bounced";
                    }
                    else
                    {
                        $transactions[$tkey]->transaction_status="N/A";
                    }
                }

                $sno++;
            }
            $response['one_time_transactions']=$transactions;
            $response['one_time_transactions_count']=count($transactions);

            $response['status']=true;
            $response['order']=$orderData['order'];
            $response['order_items']=$orderData['order_items'];

            if ($response['status'])
            {
                $this->response($response, REST_Controller::HTTP_OK);
            }
            else
            {
                end:
                $this->response($response, REST_Controller::HTTP_NOT_FOUND);
            }
        }
    }

    public function poojas_post()
    {
        $list=$this->orders_model->listUserPoojas();
        unset($list['recordsFiltered']);
        foreach ($list['data'] as $key=>$row)
        {
            unset($list['data'][$key]['data']);
            unset($list['data'][$key]['old_data']);
            unset($list['data'][$key]['options']);
            unset($list['data'][$key]['need_tax_letter']);
            unset($list['data'][$key]['indian']);
            unset($list['data'][$key]['donation_type']);
            unset($list['data'][$key]['tokens_issued_on']);
            unset($list['data'][$key]['tokens_issued_by']);
            unset($list['data'][$key]['user_id']);
            unset($list['data'][$key]['created_by_user_id']);
            unset($list['data'][$key]['status']);
            unset($list['data'][$key]['payment_status']);
            unset($list['data'][$key]['sequence']);
            unset($list['data'][$key]['schedule_dates']);
            unset($list['data'][$key]['start_date']);
            unset($list['data'][$key]['end_date']);
            unset($list['data'][$key]['time_to']);
            unset($list['data'][$key]['time_from']);
            unset($list['data'][$key]['ip_address']);
            unset($list['data'][$key]['category']);
        }
        unset($list['from_date']);
        unset($list['to_date']);
        $this->set_response($list, REST_Controller::HTTP_OK);
    }
    public function donations_post()
    {
        $list=$this->orders_model->listUserDonations();
        unset($list['recordsFiltered']);
        foreach ($list['data'] as $key=>$row)
        {
            unset($list['data'][$key]['data']);
            unset($list['data'][$key]['old_data']);
            unset($list['data'][$key]['options']);
            unset($list['data'][$key]['need_tax_letter']);
            unset($list['data'][$key]['indian']);
            unset($list['data'][$key]['donation_type']);
            unset($list['data'][$key]['tokens_issued_on']);
            unset($list['data'][$key]['tokens_issued_by']);
            unset($list['data'][$key]['user_id']);
            unset($list['data'][$key]['created_by_user_id']);
            unset($list['data'][$key]['status']);
            unset($list['data'][$key]['payment_status']);
            unset($list['data'][$key]['sequence']);
            unset($list['data'][$key]['schedule_dates']);
            unset($list['data'][$key]['start_date']);
            unset($list['data'][$key]['end_date']);
            unset($list['data'][$key]['time_to']);
            unset($list['data'][$key]['time_from']);
            unset($list['data'][$key]['ip_address']);
            unset($list['data'][$key]['category']);
        }
        unset($list['from_date']);
        unset($list['to_date']);
        $this->set_response($list, REST_Controller::HTTP_OK);
    }

    public function store_post()
    {
        $list=$this->orders_model->listUserPoojas();
        unset($list['recordsFiltered']);
        foreach ($list['data'] as $key=>$row)
        {
            unset($list['data'][$key]['data']);
            unset($list['data'][$key]['old_data']);
            unset($list['data'][$key]['options']);
            unset($list['data'][$key]['need_tax_letter']);
            unset($list['data'][$key]['indian']);
            unset($list['data'][$key]['donation_type']);
            unset($list['data'][$key]['tokens_issued_on']);
            unset($list['data'][$key]['tokens_issued_by']);
            unset($list['data'][$key]['user_id']);
            unset($list['data'][$key]['created_by_user_id']);
            unset($list['data'][$key]['status']);
            unset($list['data'][$key]['payment_status']);
            unset($list['data'][$key]['sequence']);
            unset($list['data'][$key]['schedule_dates']);
            unset($list['data'][$key]['start_date']);
            unset($list['data'][$key]['end_date']);
            unset($list['data'][$key]['time_to']);
            unset($list['data'][$key]['time_from']);
            unset($list['data'][$key]['ip_address']);
            unset($list['data'][$key]['category']);
        }
        unset($list['from_date']);
        unset($list['to_date']);
        $this->set_response($list, REST_Controller::HTTP_OK);
    }
}
?>