<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}

//use Restserver\Libraries\REST_Controller;

class Me extends REST_Controller
{
    private $error=0;
    public $currentUser=array();
    function __construct()
    {
        parent::__construct();
        $this->load->library("server");

        $this->server->require_scope("user");
        $this->load->model("user/users_model");
        $this->currentUser=$this->users_model->userDataByEmailorUsername($this->server->access_token_data['user_id']);
        //$this->load->model('oauth_sessions_model');
        //$this->oauth_sessions_model->session_check();

        /*if($this->session->userdata('id'))
            $this->currentUser=$this->session->userdata("admin_data");
        else
            $this->currentUser=$this->session->userdata("user_data");*/

        /*if(!$this->session->userdata('user_id'))
        {
            $this->response([
                    'status' => FALSE,
                    'message' => 'Access denied'
                ], REST_Controller::HTTP_NOT_FOUND);
            $this->error=1;
        }
        if($this->error==0)
        {
            $this->currentUser=$this->session->userdata("user_data");
        }*/
        $this->load->model('subscriptions_email_model');
    }

    /**
    * @api {post} /me Get user's details
    * @apiPermission User
    * @apiName User
    * @apiGroup Me
    *
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *     {
            "username": "exampleusername",
            "firstname": "First Name",
            "middlename": "Middle Name",
            "lastname": "Last Name",
            "email": "email@email.com",
            "phoneno": "9988118811",
            "profilepic": 
                {
                   "original": "https://dev-dattapeetham.s3.amazon.com/ssddd/sdddd.png",
                   "thumb": "https://dev-dattapeetham.s3.amazon.com/ssddd/thumb_sdddd.png",
                   "thumb50": "https://dev-dattapeetham.s3.amazon.com/ssddd/thumb50_sdddd.png"
                },
            "profession": "",
            "gothram": "",
            "birthstar": "",
            "raasi": "",
            "gender": "Male",
            "dob": "1990-10-01",
            "address": "Address line 1",
            "address1": "Address line 2",
            "address2": "Address Line 3",
            "country_id": "IN",
            "city": "Mysore",
            "state": "Karnataka",
            "country": "India",
            "zipcode": "567386",
            "lang_id": "314",
            "admin": "0",
            "email_verified": "1",
            "family_details": "First name\r\nGothram\r\nNakshatram"
        }
    *
    * @apiSuccess {String} username Username
    * @apiSuccess {String} firstname First Name
    * @apiSuccess {String} middlename Middle Name
    * @apiSuccess {String} lastname Last Name
    * @apiSuccess {String} email Email ID
    * @apiSuccess {String} phoneno Phone number
    * @apiSuccess {Object} profilepic Multiple sizes of profile photo
    * @apiSuccess {String} original Original Size
    * @apiSuccess {String} thumb Thumnail of size 150x150
    * @apiSuccess {String} thumb50 Thumbnail of size 50x50
    * @apiSuccess {String} profession Profession
    * @apiSuccess {String} gothram Gothram
    * @apiSuccess {String} birthstar Birth Star
    * @apiSuccess {String} raasi Raasi
    * @apiSuccess {String} gender Gender
    * @apiSuccess {String} dob Date of birth in format DD MMM YYYY
    * @apiSuccess {String} address Address line 1
    * @apiSuccess {String} address1 Address line 2
    * @apiSuccess {String} address2 Address line 3
    * @apiSuccess {String} country_id Country Code
    * @apiSuccess {String} country Country Name
    * @apiSuccess {String} state State Name
    * @apiSuccess {String} city City Name
    * @apiSuccess {String} zipcode ZIP/PIN Code
    * @apiSuccess {Integer} lang_id Language Identifier
    * @apiSuccess {Integer} admin Admin flag
    * @apiSuccess {Integer} email_verified Email verified flag
    * @apiSuccess {String} family_details Family details
    */

    public function index_post($id=null)
    {
        if($this->error)
            return;

        $userData=$this->users_model->userData($this->currentUser->id);
        if($userData->profilepic!='')
        {
            $userData->profilepic=array(
                                'original'=>aws_s3_base_url."users_profiles/".$userData->username[0]."/".md5($userData->id)."/".$userData->profilepic,
                                'thumb'=>aws_s3_base_url."users_profiles/".$userData->username[0]."/".md5($userData->id)."/thumb_".$userData->profilepic,
                                'thumb50'=>aws_s3_base_url."users_profiles/".$userData->username[0]."/".md5($userData->id)."/thumb50_".$userData->profilepic,
                                );
        }
        $userData->dob=date("d M Y",strtotime($userData->dob));
        unset($userData->status);
        unset($userData->id);
        unset($userData->user_title);
        unset($userData->role);
        unset($userData->last_logged_in);
        unset($userData->first_logged_in);
        unset($userData->currency);
        unset($userData->profile_complete);
        unset($userData->suspended);
        unset($userData->deleted);

        $userData->session_id=session_id();

        $this->set_response($userData, REST_Controller::HTTP_OK);
    }

    /**
    * @api {post} /me/update Update profile
    * @apiPermission User
    * @apiName Update
    * @apiGroup Me
    *
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *     {
            "status": true
        }
    *
    * @apiParam {String} user_email Email ID
    * @apiParam {String=[a-z],[A-Z], spaces} first_name First name<br>
    *                             Minlength\:2<br>
    *                             Maxlength\:50
    * @apiParam {String='[a-z]','[A-Z]','spaces'} [middlename] Middle name<br>
    *                             Minlength\:0<br>
    *                             Maxlength\:50
    * @apiParam {String='[a-z]','[A-Z]','spaces'} last_name Last name<br>
    *                             Minlength\:2<br>
    *                             Maxlength\:50
    * @apiParam {String='Priest/Veda Pandit','Doctor','Lawyer','Government Employee','Social Activist','Bussiness Man','Other'} [profession] Profession
    * @apiParam {String='Ashwini','Bharani','Krittika','Rohini','Mrigasira','Arudra','Punarvasu','Pushyami','Aslesha','Magha','P.Phalguni','U.Phalguni','Hasta','Chitra','Swati','Visakha','Anuradha','Jyestha','Moola','P.Ashadha','U.Ashadha','Shravana','Dhanishta','Satabhistha','P.Bhadra','U.Bhadra','Revati'} [star] Birth Star
    * @apiParam {String='Mesha','Vrishuba','Mithuna','Karkataka','Simha','Kanya','Tula','Vruschika','Dhanur','Makara','Kumbha','Meena'} [raasi] Raasi<br>
                        Array(<br>
                            'Mesha'=>'Mesha (Aries)',<br>
                            'Vrishuba'=>'Vrishuba (Taurus)',<br>
                            'Mithuna'=>'Mithuna (Gemini)',<br>
                            'Karkataka'=>'Karkataka (Cancer)',<br>
                            'Simha'=>'Simha (Leo)',<br>
                            'Kanya'=>'Kanya (Virgo)',<br>
                            'Tula'=>'Tula (Libra)',<br>
                            'Vruschika'=>'Vruschika (Scorpio)',<br>
                            'Dhanur'=>'Dhanur (Sagittarius)',<br>
                            'Makara'=>'Makara (Capricorn)',<br>
                            'Kumbha'=>'Kumbha (Aquarius)',<br>
                            'Meena'=>'Meena (Pisces)'<br>
                        )
    * @apiParam {String} gothram Gothram<br>
    *                             Minlength\:3<br>
    *                             Maxlength\:50
    * @apiParam {String='Male','Female','Other'} [gender] Gender
    * @apiParam {String} [dob] Date of Birth in dd MMM YYYY format.<br>Must be at least 15 years old.
    * @apiParam {String} [phone] Phone number<br>
    *                             Minlength\:10<br>
    *                             Maxlength\:10<br>
                                  Digits only
    * @apiParam {String='[a-z]','[A-Z]','[0-9]','[.-_@/]','spaces'} [address] Address line 1<br>
    *                             Minlength\:3<br>
    *                             Maxlength\:50
    * @apiParam {String='[a-z]','[A-Z]','[0-9]','[.-_@/]','spaces'} [address1] Address line 2<br>
    *                             Minlength\:3<br>
    *                             Maxlength\:50
    * @apiParam {String='[a-z]','[A-Z]','[0-9]','[.-_@/]','spaces'} [address2] Address line 3<br>
    *                             Minlength\:3<br>
    *                             Maxlength\:50
    * @apiParam {String} country Country Code
    * @apiParam {String='[a-z]','[A-Z]','[0-9]','[.-_@/]','spaces'} [state] State Name<br>
    *                             Minlength\:2<br>
    *                             Maxlength\:100
    * @apiParam {String='[a-z]','[A-Z]','[0-9]','[.-_@/]','spaces'} [city] City<br>
    *                             Minlength\:2<br>
    *                             Maxlength\:100
    * @apiParam {String='[a-z]','[A-Z]','[0-9]'} [zip] ZIP/PIN Code<br>
                                    Minlength\:3<br>
    *                               Maxlength\:15
    * @apiParam {Integer} [lang] Language Identifier
    * @apiParam {String} [family_details] Family details<br>
                                    Minlength\:10<br>
    *                               Maxlength\:500
    * @apiParam {File} [profile_image] Profile Image<br>
                                    Maxsize: 1 MB
    */

    public function update_post($id=null)
    {
        

        if($this->error)
            return;


        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        $error=0;
        $message='';



        $userId=$this->currentUser->id;
        $this->form_validation->set_rules('user_email', 'Email ID', 'trim|required|valid_email_custom|min_length[6]|max_length[200]|emailCheck['.$this->currentUser->id.']');
        $this->form_validation->set_rules('first_name', 'First Name', 'trim|required|min_length[2]|max_length[50]|lettersonly');
        $this->form_validation->set_rules('middlename', 'Middle Name', 'trim|max_length[50]|lettersonly');
        $this->form_validation->set_rules('last_name', 'Last Name', 'trim|required|min_length[2]|max_length[50]|lettersonly');
        $this->form_validation->set_rules('profession', 'Profession', 'trim|professionCheck');
        $this->form_validation->set_rules('star', 'Birth Star', 'trim|starCheck');
        $this->form_validation->set_rules('raasi', 'Raasi', 'trim|raasiCheck');
        $this->form_validation->set_rules('gothram', 'Gothram', 'trim|min_length[3]|max_length[50]');
        $this->form_validation->set_rules('gender', 'Gender', 'trim|genderCheck');
        $this->form_validation->set_rules('dob', 'Date of Birth', 'trim|dobCheck');
        $this->form_validation->set_rules('phone', 'Phone Number', 'trim|numeric|min_length[8]|max_length[15]|noSpaces');

        $this->form_validation->set_rules('address', 'Address Line 1', 'trim|min_length[3]|max_length[100]');
        $this->form_validation->set_rules('address1', 'Address Line 2', 'trim|min_length[3]|max_length[100]|noSpaces');
        $this->form_validation->set_rules('address2', 'Address Line 3', 'trim|min_length[3]|max_length[100]|noSpaces');

        $this->form_validation->set_rules('country', 'Country', 'trim|countryCheck');
        $this->form_validation->set_rules('state', 'State', 'trim|min_length[2]|max_length[100]|name_validate13');
        $this->form_validation->set_rules('city', 'City', 'trim|min_length[2]|max_length[100]|name_validate13');
        $this->form_validation->set_rules('zip', 'ZIP Code', 'trim|alphabetsnumbers|min_length[3]|max_length[15]');
        $this->form_validation->set_rules('lang', 'Language', 'trim|checkLanguage');
        $this->form_validation->set_rules('family_details', 'Family Details', 'trim|min_length[10]|max_length[500]');

        if($this->form_validation->run() == FALSE)
        {
            $error=1;
            $message=strip_tags(validation_errors());
        }

        if(!isset($_POST['address']))
        {
            if($error) $message.="\n";
            $error=1;
            $message.="Address Line 1 field is required";
        }

        if(!isset($_POST['address1']))
        {
            if($error) $message.="\n";
            $error=1;
            $message.="Address Line 2 field is required";
        }

        if(!isset($_POST['address2']))
        {
            if($error) $message.="\n";
            $error=1;
            $message.="Address Line 3 field is required";
        }

        if(!isset($_POST['gothram']))
        {
            if($error) $message.="\n";
            $error=1;
            $message.="Gothram field is required";
        }

        if(!isset($_POST['gender']))
        {
            if($error) $message.="\n";
            $error=1;
            $message.="Gender field is required";
        }

        if(!isset($_POST['dob']))
        {
            if($error) $message.="\n";
            $error=1;
            $message.="Date of birth field is required";
        }

        if(!isset($_POST['phone']))
        {
            if($error) $message.="\n";
            $error=1;
            $message.="Phone field is required";
        }

        if(!isset($_POST['profession']))
        {
            if($error) $message.="\n";
            $error=1;
            $message.="Profession field is required";
        }

        if(!isset($_POST['star']))
        {
            if($error) $message.="\n";
            $error=1;
            $message.="Star field is required";
        }

        if(!isset($_POST['raasi']))
        {
            if($error) $message.="\n";
            $error=1;
            $message.="Raasi field is required";
        }

        if(!isset($_POST['family_details']))
        {
            if($error) $message.="\n";
            $error=1;
            $message.="Family details field is required";
        }

        if(!isset($_POST['country']))
        {
            if($error) $message.="\n";
            $error=1;
            $message.="Country field is required";
        }

        if(!isset($_POST['state']))
        {
            if($error) $message.="\n";
            $error=1;
            $message.="State field is required";
        }
        if(!isset($_POST['city']))
        {
            if($error) $message.="\n";
            $error=1;
            $message.="City field is required";
        }

        if(!isset($_POST['zip']))
        {
            if($error) $message.="\n";
            $error=1;
            $message.="ZIP Code field is required";
        }
        
        if(!isset($_POST['lang']))
        {
            if($error) $message.="\n";
            $error=1;
            $message.="Language field is required";
        }

        

        /*print_r($_POST);
        //print_r($_FILES);
        echo $error;
        exit;*/

        /*if(isset($_FILES['profile_image']))
        if($_FILES['profile_image']['name']!='')
        {
            if($_FILES['profile_image']['size']==0)
            {
                if($error) $message.="\n";
                $error=1;
                $message.="Invalid profile image.";
            }
            if($_FILES['profile_image']['size']>1*1024*1024)
            {
                if($error) $message.="\n";
                $error=1;
                $message.="Image size exceeded.";
            }
            $ext=pathinfo ($_FILES['profile_image']['name'],PATHINFO_EXTENSION);

            if($ext=='')
            {
                if($error) $message.="\n";
                $error=1;
                $message.="Invalid file.";
            }
            if(!getimagesize($_FILES['profile_image']['tmp_name']))
            {
                if($error) $message.="\n";
                $error=1;
                $message.="Invalid profile image.";
            }
        }*/

        //echo file_get_contents("php://input");
        //echo $error;
        //$response['message']=$message;
        //echo $message;
        //print_r($_POST);
        //print_r($_FILES);
        //var_dump($_POST['phone']);
        //exit;

        if($error==1)
        {
            $response['message']=$message;
            goto end;
        }

        

        $this->users_model->updateProfile($this->currentUser->id,$_POST,1);
        $response['status']=true;

        $this->load->model("user/user_debit_account_model");
        //if($this->session->userdata('user_id'))
        //{
            //$userData=$this->users_model->userData($this->currentUser->id);
            //$this->session->set_userdata("user_data",$userData);
            //$this->session->set_flashdata("profile_updated",1);
            //$this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());
        //}

        $this->user_debit_account_model->setAccount($this->currentUser->id);

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /me/authenticate Authenticate user
    * @apiPermission User
    * @apiName Authenticate
    * @apiGroup Me
    * @apiParam {String} password Password<br>
    *                             Minlength\:5<br>
    *                             Maxlength\:50
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *     {
    *         "status":true
    *    }
    * @apiSuccess {Boolean} status true if success otherwise false
    */
    public function authenticate_post()
    {
        if($this->error)
            return;

        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        $this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[5]|max_length[50]');
        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }

        $flag=$this->users_model->verifyPassword($this->currentUser->id,$_POST['password']);
        if($flag)
            $response['status']=true;

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /me/security_questions_list Get security questions list
    * @apiPermission User
    * @apiDescription Returns list of security questions in two groups
    * @apiName Security questions list
    * @apiGroup Me
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *    {
    *       "status":true,
            "security_questions":
            {
                "group0":
                [
                    {
                        "id": "1",
                        "question": "What was your childhood nickname?",
                        "group": "0"
                    }
                ],
                "group1":
                [
                    {
                        "id": "1",
                        "question": "What was your childhood nickname?",
                        "group": "1"
                    }
                ]
            }
    *    }
    * @apiSuccess {Boolean} status true if success otherwise false
    * @apiSuccess {Object} security_questions Security Questions object
    * @apiSuccess {Object} security_questions.group0 Security Questions object
    */
    public function security_questions_list_post()
    {
        if($this->error)
            return;

        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        $response['security_questions']=$this->users_model->getSecurityQuestionsGroups();
        $response['status']=true;

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /me/security_questions Get user security questions
    * @apiPermission User
    * @apiDescription Returns user security questions
    * @apiName Security questions
    * @apiGroup Me
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *    {
    *       "status":true,
            "question_ids":
            [
                "1",
                "6"
            ]
    *    }
    * @apiSuccess {Boolean} status true if success otherwise false
    * @apiSuccess {Array} question_ids Question IDs
    */
    public function security_questions_post()
    {
        if($this->error)
            return;

        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        $questions=$this->users_model->getUserSecurityQuestions($this->currentUser->id);
        if(!empty($questions))
        {
            $response['question_ids'][]=$questions[0]->question_id;
            $response['question_ids'][]=$questions[1]->question_id;
        }
        else
        {
            $response['message']="Security questions not set";
        }

        $response['status']=true;

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /me/update_security_questions Update user security questions
    * @apiPermission User
    * @apiName Update Security questions
    * @apiGroup Me
    
    * @apiParam {String} password Password<br>
    *                             Minlength\:5<br>
    *                             Maxlength\:50
    * @apiParam {Integer} q1 Unique identifier of Question 1
    * @apiParam {Integer} q2 Unique identifier of Question 2
    * @apiParam {String} ans1 Answer 1<br>
    *                             Maxlength\:100
    * @apiParam {String} ans2 Answer 2<br>
    *                             Maxlength\:100
    *                             
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *    {
    *       "status":true
    *    }
    * @apiSuccess {Boolean} status true if success otherwise false
    */
    public function update_security_questions_post()
    {
        if($this->error)
            return;

        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        $this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[5]|max_length[50]');
        $this->form_validation->set_rules('q1', 'Question 1', 'trim|required|numeric|checkSecurityQuestion[0]');
        $this->form_validation->set_rules('q2', 'Question 2', 'trim|required|numeric|checkSecurityQuestion[1]');
        $this->form_validation->set_rules('ans1', 'Answer 1', 'trim|required|max_length[100]');
        $this->form_validation->set_rules('ans2', 'Answer 2', 'trim|required|max_length[100]');
        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }

        $flag=$this->users_model->verifyPassword($this->currentUser->id,$_POST['password']);
        if(!$flag)
        {
            $response['message']="Invalid password";
            goto end;
        }

        $flag=$this->users_model->updateSecurityQuestions($this->currentUser->id,$_POST);
        if($flag>0)
        {
            //if($this->session->userdata('user_id'))
            //{
                //$userData=$this->users_model->userData($this->currentUser->id);
                //$this->session->set_userdata("user_data",$userData);

                //$this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());
            //}
            $response['status']=true;
        }

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /me/languages_list Get languages list
    * @apiPermission User
    * @apiName Languages list
    * @apiGroup Me
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *    {
    *       "status":true,
            "languages": [
                {
                    "lang_id": "1",
                    "lang_name": "Abaza"
                }
            ]
    *    }
    * @apiSuccess {Boolean} status true if success otherwise false
    * @apiSuccess {Object} languages Languages object
    * @apiSuccess {Integer} languages.lang_id Unique identifier
    * @apiSuccess {Integer} languages.lang_name Language Name
    */
    public function languages_list_post()
    {
        if($this->error)
            return;

        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        $response['languages']=$this->general_model->getLanguages();
        $response['status']=true;

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /me/change_password Change Password
    * @apiPermission User
    * @apiName Change password
    * @apiGroup Me
    * @apiParam {String} current_password Current Password<br>
    *                             Minlength\:5<br>
    *                             Maxlength\:50
    * @apiParam {String} new_password New Password<br>
    *                             Minlength\:5<br>
    *                             Maxlength\:50
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *    {
    *       "status":true
    *    }
    * @apiSuccess {Boolean} status true if success otherwise false
    */
    public function change_password_post()
    {
        if($this->error)
            return;
        
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        $this->form_validation->set_rules('current_password', 'Current Password', 'trim|required|min_length[8]|max_length[50]');
        $this->form_validation->set_rules('new_password', 'New Password', 'trim|required|min_length[8]|max_length[50]');
        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }

        if(trim($_POST['new_password'])==trim($_POST['current_password']))
        {
            $response['message']="New password cannot be same as current password";
            goto end;
        }

        $flag=$this->users_model->updatePassword($this->currentUser->id,$_POST['current_password'],$_POST['new_password']);

        if($flag==1)
        {
            $response['status']=true;
        }

        if($flag==2)
        {
            $response['message']="Invalid current password";
            goto end;
        }

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /me/get_countries Get countries list
    * @apiPermission User
    * @apiDescription Returns list of countries
    * @apiName Countries list
    * @apiGroup Me
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *    {
    *       "status":true,
            "countries":
            {
                {
                    "country_code": "AF",
                    "country_name": "Afghanistan",
                    "isd_code": "93"
                },
                {
                    "country_code": "AX",
                    "country_name": "Aland Islands",
                    "isd_code": "358"
                },
            }
    *    }
    * @apiSuccess {Boolean} status true if success otherwise false
    * @apiSuccess {Object} countries Countries object
    * @apiSuccess {String} countries.country_code Country Code
    * @apiSuccess {String} countries.country_name Country Name
    * @apiSuccess {String} countries.isd_code Country ISD Code
    */
    public function get_countries_post()
    {
        if($this->error)
            return;

        $response['countries']=$this->locations_model->getCountries();
        $response['status']=true;

        $this->response($response, REST_Controller::HTTP_OK);
    }

    public function saved_cards_post()
    {
        if($this->error)
            return;

        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        $this->load->model("credit_cards_model");
        $credit_cards=$this->credit_cards_model->getCards($this->currentUser->id);
        foreach ($credit_cards as $key => $card)
        {
            unset($credit_cards[$key]->payflow_pnref);
            unset($credit_cards[$key]->created_on);
            unset($credit_cards[$key]->modified_on);
            unset($credit_cards[$key]->user_id);
            $credit_cards[$key]->card_expiry_month=substr($credit_cards[$key]->card_expiry,0,2);
            $credit_cards[$key]->card_expiry_year=substr($credit_cards[$key]->card_expiry,-2);
        }

        $response['cards']=$credit_cards;
        $response['status']=true;

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    public function delete_card_post($id=0)
    {
        if($this->error)
            return;

        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        if(is_numeric($id) && $id)
        {
            $this->load->model("credit_cards_model");
            $creditCard=$this->credit_cards_model->getCard($id);
            
            if(empty($creditCard))
            {
                goto end;
            }
            if($creditCard->user_id!=$this->currentUser->id)
            {
                goto end;
            }
            $this->credit_cards_model->delete($id);
            $response['card_number']=$creditCard->card_number;
            $response['status']=true;
        }

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }
    public function device_post($action='add')
    {
        if($this->error)
            return;

        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        if($this->input->post("player_id")!='')
        {
            $this->load->model("user/users_model");
            $this->load->model("user/user_devices_model");
            $this->load->library("one_signal");
            $this->users_model->user_device($this->input->post("player_id"),$action);
            $response['status']=true;
        }

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    public function get_login_token_post()
    {
        if($this->error)
            return;

        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        
        $this->load->model("app_web_tokens_model");
        $token=$this->app_web_tokens_model->create($this->currentUser->id,$this->server->access_token);
        $response['login_token']=$token;
        $response['status']=true;
    

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }
}
?>