<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}

//use Restserver\Libraries\REST_Controller;
class Liveupdatesadmin extends REST_Controller {
    private $error=0;
    function __construct()
    {
        parent::__construct();
        $this->load->library("server");
        $this->server->require_scope("user");
        $this->currentUser=$this->users_model->userDataByEmailorUsername($this->server->access_token_data['user_id']);
        /*$this->load->model('oauth_sessions_model');
        $this->oauth_sessions_model->session_check();*/

       /* if(!$this->session->userdata('id'))
        {
            $this->response([
                    'status' => FALSE,
                    'message' => 'Access denied'
                ], REST_Controller::HTTP_NOT_FOUND);
            $this->error=1;
        }*/
        if($this->error==0)
        {
            //$this->currentUser=$this->session->userdata("admin_data");
            if(!in_array($this->currentUser->roles,array(1,8)))
            {
                $this->response([
                        'status' => FALSE,
                        'message' => 'Access denied'
                    ], REST_Controller::HTTP_NOT_FOUND);
                $this->error=1;
            }
        }
    }

    /**
    * @api {post} /liveupdatesadmin Get Live updates
    * @apiDescription Get liveupdates list. If any dependant fields are missing, error will not be displayed instead result falls back to default.
    * @apiPermission Super Admin, Website Admin
    * @apiName List
    * @apiGroup Live Updates Admin
    *
    * @apiParam {String} [search_text] Search keyword(s)
    * @apiParam {Integer} [start=0] Number of record to start with 
    * @apiParam {Integer=1,2} [type] Type of message<br>
                                        Array(<br>
                                        1=>"Text Message",<br>
                                        2=>"Image"<br>
                                        )
    * @apiParam {Integer=20,50,100} [length]  Number of records to be displayed per page
    * @apiParam {String=message} [search_col]  Column name to search in. Required along with 'search_text'
    * @apiParam {String=contains,starts,ends} [wild]  Wild card pattern. Required along with 'search_text'
    *
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *     {
              "recordsTotal": "1576",
              "data": [
                {
                    "id": "41",
                    "message": "Pujya Sri Swamiji, Sadguru Sookti Sangraha – (Devotion – The Most Difficult Path)",
                    "order": "0",
                    "status": "1",
                    "created_on": "2017-03-13 03:40:20",
                    "sno": 1
                }
        }
    *
    * @apiSuccess {Integer} recordsTotal  Total number of results
    * @apiSuccess {Object} data Live updates Object
    * @apiSuccess {Integer} data.id Unique Identifier
    * @apiSuccess {String} data.message Live update message
    * @apiSuccess {Integer} data.order Order of message
    * @apiSuccess {Integer} data.status Status (default 1)
    * @apiSuccess {Date} data.created_on Date in format YYYY-mm-dd HH:mm:ss
    * @apiSuccess {Integer} data.sno Serial Number
    */
    public function index_post()
    {
        if($this->error)
            return;

        $this->load->model("live_updates_model");
        $list=$this->live_updates_model->listMessages(1);
        unset($list['recordsFiltered']);
        if ($list)
        {
            $this->response($list, REST_Controller::HTTP_OK);
        }
        else
        {
            $this->response([
                'status' => FALSE,
                'message' => 'No updates were found'
            ], REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /liveupdatesadmin/post Post a Live update
    * @apiPermission Super Admin, Website Admin
    * @apiName Post
    * @apiGroup Live Updates Admin
    *
    * @apiParam {String} message Update message
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *     {
              "status": "true"
        }
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    */
    public function post_post()
    {
        if($this->error)
            return;
        $response['status']=false;
        $this->load->model("live_updates_model");
        $this->form_validation->set_rules('message', 'Message', 'trim|required|min_length[3]|max_length[100]');
        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }
        $this->live_updates_model->addMessage($_POST['message']);
        $response['status']=true;
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /liveupdatesadmin/delete/:id Delete a Live update
    * @apiPermission Super Admin, Website Admin
    * @apiName Delete
    * @apiGroup Live Updates Admin
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *     {
              "status": "true"
        }
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    */
    public function delete_post($id=0)
    {
        if($this->error)
            return;
        $response['status']=false;
        if(is_numeric($id) && $id)
        {
            $this->load->model("live_updates_model");
            $messageData=$this->live_updates_model->messageData($id);
            if(empty($messageData))
            {
                $response['message']="Invalid ID";
                goto end;
            }
            $r=$this->live_updates_model->delete($id);
            if($r)
            {
                $response['status']=true;
            }
            
        }
        else
        {
            $response['message']="Invalid ID";
        }
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /liveupdatesadmin/update_order/:id Update order
    * @apiPermission Super Admin, Website Admin
    * @apiName Update Order
    * @apiGroup Live Updates Admin
    *
    * @apiParam {Integer} order Order
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *     {
              "status": "true"
        }
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    */
    public function update_order_post($id=0)
    {
        if($this->error)
            return;
        $response['status']=false;

        if(is_numeric($id) && $id)
        {
            $this->load->model("live_updates_model");
            $messageData=$this->live_updates_model->messageData($id);
            if(empty($messageData))
            {
                $response['message']="Invalid ID";
                goto end;
            }

            $this->load->model("live_updates_model");
            $this->form_validation->set_rules('order', 'Order', 'trim|required|numeric|max_length[3]');
            if($this->form_validation->run() == FALSE)
            {
                $response['message']=strip_tags(validation_errors());
                goto end;
            }
            $this->live_updates_model->updateOrder($id,$_POST['order']);
            $response['status']=true;
        }
        else
        {
            $response['message']="Invalid ID";
        }
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }
}
?>