<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}

//use Restserver\Libraries\REST_Controller;
class Feedback extends REST_Controller {
    private $error=0;
    var $access_token_present=0;
    var $service="feedback";
    var $purposeArray=array(
                                1=>"Office/Billing",
                                2=>"Contact",
                                3=>"Abuse",
                                4=>"Complaint",
                                5=>"Question",
                                6=>"Feedback",
                                7=>"Other"
                                );
    public $currentUser=array();
    function __construct()
    {
        parent::__construct();
    }

    /**
    * @api {post} /feedback/post Post a feedback
    * @apiPermission Logged in User
    * @apiName Post
    * @apiGroup Feedback
    
    * @apiParam {String} feed_name Name (Only as guest)<br>
    *                             Minlength\:3<br>
    *                             Maxlength\:100
    * @apiParam {String} feed_email Email ID (Only as guest)<br>
    *                             Minlength\:6<br>
    *                             Maxlength\:200
    * @apiParam {String} feed_phone Phone Number<br>
    *                             Minlength\:10<br>
    *                             Maxlength\:20
    * @apiParam {Integer=1,2,3,4,5,6,7} purpose Purpose<br>
    *                             Reference\:<br>array(
                                1=>"Office/Billing",<br>
                                2=>"Technical Support",<br>
                                3=>"Abuse",<br>
                                4=>"Complaint",<br>
                                5=>"Question",<br>
                                6=>"Feedback",<br>
                                7=>"Other"<br>
                                )
    * @apiParam {String} feed_msg Message<br>
    *                             Minlength\:1<br>
    *                             Maxlength\:500
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true
        }
    *
    * @apiSuccess {boolean} status True if success otherwise false
    */
   
    public function post_post()
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        
        $this->load->library("server");
        $a=OAuth2\Request::createFromGlobals();
        $headers=$a->headers('AUTHORIZATION');
        if(preg_match('/Bearer\s(\S+)/i', $headers, $matches))
        {
            $this->server->require_scope("user");
            $this->load->model("user/users_model");
        
            $this->currentUser=$this->users_model->userDataByEmailorUsername($this->server->access_token_data['user_id']);
            /*$this->load->model('oauth_sessions_model');
            $this->oauth_sessions_model->session_check();

            if($this->session->userdata('id'))
                $this->currentUser=$this->session->userdata("admin_data");
            else
                $this->currentUser=$this->session->userdata("user_data");*/

            $this->access_token_present=1;
        }
        else
        {
            $this->session->unset_userdata("loggedIn");
            $this->session->unset_userdata("id");
            $this->session->unset_userdata("user_id");
            $this->session->unset_userdata("user_data");
        }
        //=====================================================================
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        if($GLOBALS['site_settings']['feedback_enable']==1)
        {
            $this->load->model('feedback_model');
            if($this->access_token_present==0)
            {
                $this->form_validation->set_rules('feed_name', 'Name', 'trim|required|min_length[3]|max_length[100]');
                $this->form_validation->set_rules('feed_email', 'Email ID', 'trim|required|valid_email|min_length[6]|max_length[200]');
            }
            $this->form_validation->set_rules('feed_phone', 'Phone', 'trim|required|min_length[8]|max_length[20]');
            $this->form_validation->set_rules('purpose', 'Purpose', 'trim|required|checkFeedbackPurpose');
            $this->form_validation->set_rules('feed_msg', 'Message', 'trim|required|max_length[500]');
            $this->form_validation->set_rules('feed_country_code', 'Country code', 'trim|required|countryCheck');
            if($this->form_validation->run() == FALSE)
            {
                $response['message']=strip_tags(validation_errors());
                goto end;
            }
            $GLOBALS['app']=1;
            $this->feedback_model->post($_POST,1);
            $response['status']=true;
        }
        else
        {
            $response['message']="Feedback is disabled";
        }
        
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /feedback Get feedback messages
    * @apiPermission Logged in User
    * @apiName list
    * @apiGroup Feedback
    *
    * @apiParam {String} [search_text] Search keyword(s)
    * @apiParam {Integer} [start=0] Number of record to start with 
    * @apiParam {Integer=20,50,100} [length]  Number of records to be displayed per page
    * @apiParam {Integer=1,2,3,4} [fstatus]  Status<br>
    *                             Reference\:<br>array(
                                1=>"Open",<br>
                                2=>"Waiting Admin",<br>
                                3=>"Waiting User",<br>
                                4=>"Closed"<br>
                                )
    * @apiParam {String} [from_date]  From Date in format dd MM YYYY
    * @apiParam {String} [to_date]  To Date in format dd MM YYYY
    * @apiParam {String=feedback_id,content} [search_col]  Column name to search in
    * @apiParam {String=contains,starts,ends} [wild]  Wild card pattern
    *
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *     {
              "recordsTotal": "1576",
              "data": [
                {
                    "id": "9",
                    "feedback_id": "FB-2017-03-9",
                    "name": "Super Admin",
                    "email": "admin@email.com",
                    "phone": "9988999999",
                    "purpose": "Office/Billing",
                    "content": "message from API",
                    "ip_address": "117.98.217.92",
                    "date": "30 Mar 2017",
                    "fstatus": "1",
                    "count": "0",
                    "read": "1",
                    "read_user": "0",
                    "sno": 1
                }
        }
    *
    * @apiSuccess {Integer} recordsTotal  Total number of results
    * @apiSuccess {Object} data Events Object
    * @apiSuccess {Integer} data.id Unique Identifier
    * @apiSuccess {String} data.feedback_id Feedback ID
    * @apiSuccess {String} data.name Name of user
    * @apiSuccess {String} data.email Email ID of user
    * @apiSuccess {String} data.phone Phone number of user
    * @apiSuccess {String} data.purpose Purpose of feedback
    * @apiSuccess {String} data.content Feedback message
    * @apiSuccess {String} data.ip_address IP Address of user
    * @apiSuccess {String} data.date Date in format dd MMM YYYY
    * @apiSuccess {Integer} data.fstatus Status of feedback message
    * @apiSuccess {Integer} data.count Number of replies
    * @apiSuccess {Integer=0,1} data.read 1 if Admin read the message otherwise 0
    * @apiSuccess {Integer=0,1} data.read_user 1 if User read the message otherwise 0
    * @apiSuccess {Integer} data.sno Serial number
    */
    
    /**
    * @api {post} /feedback/:id Get a feedback message
    * @apiPermission Logged in User
    * @apiName Get
    * @apiGroup Feedback
    *
    * @apiExample {curl} Example usage:
      curl -i /feedback/1561
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
    *   {
            "id": "9",
            "feedback_id": "FB-2017-03-9",
            "name": "Super Admin",
            "email": "admin@admin.com",
            "phone": "9988999999",
            "purpose": "1",
            "content": "message from API",
            "ip_address": "117.98.217.92",
            "user_agent": "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36",
            "url": "",
            "date": "2017-03-30 12:54:37",
            "fstatus": "1",
            "count": "0",
            "replies_data": {
                "replies": [
                    {
                        "id": "17",
                        "feedback_id": "9",
                        "content": "<p>This is a reply message</p>",
                        "date": "2017-03-30 14:11:27",
                        "userid": "308",
                        "admin": "1"
                    }
                ],
                "users": {
                    "308":
                    {
                        "id": "308",
                        "username": "datta2",
                        "firstname": "Super",
                        "lastname": "Admin",
                        "email": "admin@admin.com",
                        "profilepic": "",
                        "phoneno": "9989999899"
                    }
                }
            }
        }
    * 
    * @apiSuccess {Integer} id  Unique Identifier
    * @apiSuccess {String} feedback_id Feedback ID
    * @apiSuccess {String} name Name of user
    * @apiSuccess {String} email Email ID of user
    * @apiSuccess {String} phone Phone number of user
    * @apiSuccess {String} purpose Purpose
    * @apiSuccess {String} content Feedback Message
    * @apiSuccess {String} ip_address IP Address of the user
    * @apiSuccess {String} user_agent User agent string
    * @apiSuccess {String} url URL from where feedback sent. Empty for mobile app.
    * @apiSuccess {String} date Date in format YYYY-mm-dd HH:mm:ss
    * @apiSuccess {Integer} fstatus Status of message
    * @apiSuccess {Integer} count Number of feedback replies
    * @apiSuccess {Object} replies_data Replies object contains replies and corresponding users data
    * @apiSuccess {Object} replies_data.replies Replies object
    * @apiSuccess {Integer} replies_data.replies.id Unique identifier of reply
    * @apiSuccess {Integer} replies_data.replies.feedback_id Unique identifier of feedback message
    * @apiSuccess {Integer} replies_data.replies.content Reply message
    * @apiSuccess {Integer} replies_data.replies.date Date of reply in format YYYY-mm-dd HH:mm:ss
    * @apiSuccess {Integer} replies_data.replies.user_id User ID of replied user
    * @apiSuccess {Integer} replies_data.replies.admin 1 if replied user is admin otherwise false
    * @apiSuccess {Object} replies_data.users Users object (User ID will be key for each user object)
    * @apiSuccess {Integer} replies_data.users.id Unique identifier of user
    * @apiSuccess {Integer} replies_data.users.username Username
    * @apiSuccess {Integer} replies_data.users.firstname First Name
    * @apiSuccess {Integer} replies_data.users.lastname Last Name
    * @apiSuccess {Integer} replies_data.users.email Email iD
    * @apiSuccess {Integer} replies_data.users.profilepic Path of profile picture
    * @apiSuccess {Integer} replies_data.users.phoneno Phone Number
    */
    public function index_post($id=null)
    {
        $this->load->library("server");
        $this->server->require_scope("user");
        $this->load->model("user/users_model");
        
        $this->currentUser=$this->users_model->userDataByEmailorUsername($this->server->access_token_data['user_id']);
        //$this->load->model('oauth_sessions_model');
        //$this->oauth_sessions_model->session_check();

        /*if(!$this->session->userdata('user_id'))
        {
            $this->response([
                    'status' => FALSE,
                    'message' => 'Access denied'
                ], REST_Controller::HTTP_NOT_FOUND);
            $this->error=1;
        }
        if($this->error==0)
        {
            $this->currentUser=$this->session->userdata("user_data");
        }
        else
        {
            return;
        }*/


        /*if($this->session->userdata('id'))
            $this->currentUser=$this->session->userdata("admin_data");
        else
            $this->currentUser=$this->session->userdata("user_data");*/

        $controller=$this->uri->segment(1);
        $method=$this->uri->segment(2);

        if($controller=='restapi')
        {
            if($this->uri->segment(3)!='')
            {
                $method.="/".$this->uri->segment(3);
            }
        }

        if($controller=='') $controller='home';
        if($method=='') $method='index';
        //$this->db->where("active",1);
        $this->db->where("controller",ucwords($controller));
        $this->db->where("method",$method);

        $q=$this->db->get("acl");

        if($q->num_rows())
        {
            $acl=$q->row();
            $GLOBALS['current_acl']['data']=$acl;
            $GLOBALS['current_acl']['search_columns']=explode(",",$acl->search_columns);
            $GLOBALS['current_acl']['sort_columns']=explode(",",$acl->sort_columns);
            $tempCols=array();

            if($acl->excel_columns!='')
            {
                $temp1=explode(",",$acl->excel_columns);
                foreach ($temp1 as $colMaps)
                {
                    $temp2=explode(":",$colMaps);
                    $tempCols[$temp2[0]]=$temp2[1];
                }
            }
            $GLOBALS['current_acl']['excel_columns']=$tempCols;
            $GLOBALS['current_acl']['wild']=array("contains","starts","ends");
            $GLOBALS['current_acl']['dir']=array("asc","desc");
            $GLOBALS['current_acl']['per_page_options_user']=array(10,20);
            $GLOBALS['current_acl']['per_page_options_admin']=array(10,20,50,100);
        }
        //=====================================================================

        $this->load->model('feedback_model');
        $this->load->model('feedback_replies_model');

        if ($id === NULL)
        {
            $list=$this->feedback_model->listMessagesAjaxUser($this->currentUser->id);
            unset($list['recordsFiltered']);
            $users=$list;
            if ($users)
            {
                $this->response($users, REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response([
                    'status' => FALSE,
                    'message' => 'No messages were found'
                ], REST_Controller::HTTP_NOT_FOUND);
            }
        }
        else
        {
            $id = (int) $id;
            if ($id <= 0)
            {
                $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST);
            }
            $feedbackData=$this->feedback_model->feedbackData($id);
            $response=null;
            if (!empty($feedbackData))
            {
                if($feedbackData->user_id!=$this->currentUser->id)
                {
                    goto end;
                }
                unset($feedbackData->modified_on);
                unset($feedbackData->close_status);
                unset($feedbackData->checked_in);
                unset($feedbackData->checked_in_time);
                unset($feedbackData->checked_in_user_id);
                unset($feedbackData->checked_in_username);
                unset($feedbackData->user_id);
                unset($feedbackData->username);
                unset($feedbackData->admin);
                unset($feedbackData->read);
                unset($feedbackData->read_user);
                $feedbackData->date=date("d M Y",strtotime($feedbackData->date));
                if($feedbackData->url=='')
                    $feedbackData->url='N/A';
                $feedbackData->purpose=$this->purposeArray[$feedbackData->purpose];
                $feedbackData->replies_data=$this->feedback_replies_model->getReplies($id);

                foreach ($feedbackData->replies_data['replies'] as $key => $reply)
                {
                    $feedbackData->replies_data['replies'][$key]->date=date("d M Y h:i A",strtotime($reply->date));
                }

                $this->set_response($feedbackData, REST_Controller::HTTP_OK);
            }
            else
            {
                end:
                $this->set_response([
                    'status' => FALSE,
                    'message' => 'Message not found'
                ], REST_Controller::HTTP_NOT_FOUND);
            }
        }
    }
    /**
    * @api {post} /feedback/close/:feedback_id Close a feedback request
    * @apiPermission Logged in User
    * @apiName  Close
    * @apiGroup Feedback
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true,
            "feedback_id": 'FD-0099393'
        }
    *                        
    * @apiSuccess {Boolean} status true if success otherwise false
    * @apiSuccess {String} feedback_id Feedback ID. This is set only if status is true
    */   
    public function close_post($feedbackId=0)
    {
        $this->load->library("server");
        $this->server->require_scope("user");
        $this->load->model("user/users_model");
        
        $this->currentUser=$this->users_model->userDataByEmailorUsername($this->server->access_token_data['user_id']);
        //$this->load->model('oauth_sessions_model');
        //$this->oauth_sessions_model->session_check();

        /*if(!$this->session->userdata('user_id'))
        {
            $this->response([
                    'status' => FALSE,
                    'message' => 'Access denied'
                ], REST_Controller::HTTP_NOT_FOUND);
            $this->error=1;
        }
        if($this->error==0)
        {
            $this->currentUser=$this->session->userdata("user_data");
        }
        else
        {
            return;
        }*/

        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        $this->load->model('feedback_model');

        if(is_numeric($feedbackId) && $feedbackId)
        {
            $feedbackData=$this->feedback_model->feedbackData($feedbackId);
            if(empty($feedbackData))
            {
                $response['message']="Invalid feedback ID";
                goto end;
            }

            if($feedbackData->user_id!=$this->currentUser->id)
            {
                $response['message']="Invalid request";
                goto end;
            }
            
            $currentStatus=$feedbackData->fstatus;
            if(!in_array($currentStatus,array(1,2,3)))
            {
                $response['message']="Invalid request";
                goto end; 
            }

            $this->feedback_model->changeStatus($feedbackId,$feedbackData,4);
            
            $response['feedback_id']=$feedbackData->feedback_id;
            $response['status']=true;        
        }
        else
        {
            $response['message']="Invalid feedback ID";
        }
           
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /feedback/reply/:feedback_id Reply to a feedback request
    * @apiDescription User can reply to a feedback message only when status is "Waiting User".
    * @apiName  Reply
    * @apiGroup Feedback
    * @apiParam {String} reply Reply message
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true,
            "feedback_id": 'FD-0099393'
        }
    *                        
    * @apiSuccess {Boolean} status true if success otherwise false
    * @apiSuccess {String} feedback_id Feedback ID. This is set only if status is true
    */   
    public function reply_post($feedbackId=0)
    {
        $this->load->library("server");
        $this->server->require_scope("user");
        $this->load->model("user/users_model");
        
        $this->currentUser=$this->users_model->userDataByEmailorUsername($this->server->access_token_data['user_id']);
        /*$this->load->model('oauth_sessions_model');
        $this->oauth_sessions_model->session_check();
        
        if(!$this->session->userdata('user_id'))
        {
            $this->response([
                    'status' => FALSE,
                    'message' => 'Access denied'
                ], REST_Controller::HTTP_NOT_FOUND);
            $this->error=1;
        }
        if($this->error==0)
        {
            $this->currentUser=$this->session->userdata("user_data");
        }
        else
        {
            return;
        }*/
        
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        $this->load->model('feedback_model');
        $this->load->model('feedback_replies_model');

        if(is_numeric($feedbackId) && $feedbackId)
        {
            $feedbackData=$this->feedback_model->feedbackData($feedbackId);
            if(empty($feedbackData))
            {
                $response['message']="Invalid feedback ID";
                goto end;
            }
            
            if($feedbackData->fstatus!=3)
            {
                $response['message']="Invalid status";
                goto end;
            }
            if($feedbackData->user_id!=$this->currentUser->id)
            {
                $response['message']="Invalid request";
                goto end;
            }
            $this->form_validation->set_rules('reply', 'Reply message', 'trim|required');

            if($this->form_validation->run() == FALSE)
            {
                $response['message']=strip_tags(validation_errors());
                goto end;
            }
            $GLOBALS['app']=1;
            $this->feedback_replies_model->captureReply($feedbackId,$_POST['reply'],$feedbackData,0);
            $response['status']=true;
            $response['date']=date("d M Y h:i A");
        }
        else
        {
            $response['message']="Invalid feedback ID";
        }
           
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }
}
?>