<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}

//use Restserver\Libraries\REST_Controller;
class Eventsadmin extends REST_Controller {
    private $error=0;
    function __construct()
    {
        parent::__construct();
        $this->load->library("server");
        $this->server->require_scope("user");
        $this->currentUser=$this->users_model->userDataByEmailorUsername($this->server->access_token_data['user_id']);
        /*$this->load->model('oauth_sessions_model');
        $this->oauth_sessions_model->session_check();*/

        /*if(!$this->session->userdata('id'))
        {
            $this->response([
                    'status' => FALSE,
                    'message' => 'Access denied'
                ], REST_Controller::HTTP_NOT_FOUND);
            $this->error=1;
        }*/
        if($this->error==0)
        {
            //$this->currentUser=$this->session->userdata("admin_data");
            if(!in_array($this->currentUser->roles,array(1,7)))
            {
                $this->response([
                        'status' => FALSE,
                        'message' => 'Access denied'
                    ], REST_Controller::HTTP_NOT_FOUND);
                $this->error=1;
            }
        }
    }

    /**
    * @api {post} /eventsadmin Get events
    * @apiPermission Super Admin, Content Admin
    * @apiName Events list
    * @apiGroup Events Admin
    *
    * @apiParam {String} [search_text] Search keyword(s)
    * @apiParam {Integer} [start=0] Number of record to start with 
    * @apiParam {Integer=20,50,100} [length]  Number of records to be displayed per page
    * @apiParam {Integer} [category]  Category ID
    * @apiParam {String} [from_date]  From Date in format dd MM YYYY
    * @apiParam {String} [to_date]  To Date in format dd MM YYYY
    * @apiParam {String=name,id} [search_col]  Column name to search in
    * @apiParam {String=contains,starts,ends} [wild]  Wild card pattern
    *
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *     {
              "recordsTotal": "1576",
              "data": [
                {
                    "id": "1561",
                    "name": "October 23, 2016",
                    "description": "October 23",
                    "start_date": "07 Mar 2016 (Mon)",
                    "end_date": "08 Mar 2016 (Tue)",
                    "location": "Mysore, India",
                    "month": "3",
                    "year": "2016",
                    "categories":"",
                    "slug": "maha-shivaratri-at-datta-peetham-2016",
                    "status": "1",
                    "sno": "1"
                }
        }
    *
    * @apiSuccess {Integer} recordsTotal  Total number of results
    * @apiSuccess {Object} data Events Object
    * @apiSuccess {Integer} data.id Unique Identifier
    * @apiSuccess {String} data.name Name
    * @apiSuccess {String} data.description Description in HTML format/code
    * @apiSuccess {String} data.start_date Start Date in format dd MMM YYYY
    * @apiSuccess {String} data.end_date End Date in format dd MMM YYYY
    * @apiSuccess {String} data.location Location of event
    * @apiSuccess {String} data.slug Slug
    * @apiSuccess {String} data.categories Category ID(s) separated with comma(,)
    * @apiSuccess {Integer} data.year Year
    * @apiSuccess {Integer} data.month Month
    * @apiSuccess {Integer} data.sno Serial Number
    * @apiSuccess {Integer} data.status Status (1=Visible,0=Hidden)
    */
    
    /**
    * @api {post} /eventsadmin/:id Get an event
    * @apiPermission Super Admin, Content Admin
    * @apiName Get
    * @apiGroup Events Admin
    *
    * @apiExample {curl} Example usage:
      curl -i /eventsadmin/1561
    *
    * @apiSuccessExample {json} Success-Response:
    *     HTTP/1.1 200 OK
    *     {
            "event":
            {
                "id": "3348",
                "name": "Maha Shivaratri at Datta Peetham - 2016",
                "start_date": "2016-03-07 00:00:00",
                "end_date": "2016-03-08 00:00:00",
                "description": "<p>The annual festival, Maha Shivaratri</p>",
                "location": "Mysore, India",
                "month": "3",
                "year": "2016",
                "slug": "maha-shivaratri-at-datta-peetham-2016",
                "image_count": "0",
                "categories": "",
                "parent_link": "0",
                "reads": "474",
                "status": "1"
            },
            "images":
            [
                {
                    "id": "29036",
                    "event_id": "3348",
                    "filename": "dattapeetham_911317e244187b4e1e70d7f852da3bac.jpg",
                    "description": null,
                    "order": "0",
                    "width": "500",
                    "height": "353"
                }
            ]
            "attachments":
            [
                {
                    "id": "2309",
                    "event_id": "3334",
                    "filename": "dattapeetham_60a4849888accefcd639be5a4a765fee.jpg",
                    "description": null,
                    "order": "0",
                    "size": "226051",
                    "groupstring": null
                }
            ]
        }
    * 
    * @apiSuccess {Object} event  Event object
    * @apiSuccess {Integer} event.id  Unique Identifier
    * @apiSuccess {String} event.name Event Name
    * @apiSuccess {String} event.description Description in HTML format/code
    * @apiSuccess {String} event.categories Category IDs with comma(,) separated
    * @apiSuccess {String} event.slug Slug value
    * @apiSuccess {String} event.location Location
    * @apiSuccess {String} event.parent_link Parent event Unique identifier
    * @apiSuccess {Date} event.start_date Start Date in YYYY-mm-dd HH:ii:ss
    * @apiSuccess {Date} event.end_date End Date in YYYY-mm-dd HH:ii:ss
    * @apiSuccess {Integer} event.year Year
    * @apiSuccess {Integer} event.month Month
    * @apiSuccess {Integer} event.reads Number of reads/views
    * @apiSuccess {Integer} event.status Status (Default 1)
    * @apiSuccess {Object} images Images object (Empty if no images exist)<br>Image URL to be formed - "{aws_s3_base_url}/content/event_images/{event_id}/thumb_{filename}"
    * @apiSuccess {Integer} images.id Unique identifier
    * @apiSuccess {Integer} images.event_id Event ID
    * @apiSuccess {Integer} images.filename Image file name
    * @apiSuccess {Integer} images.description Description
    * @apiSuccess {Integer} images.order Order
    * @apiSuccess {Integer} images.width Width of image
    * @apiSuccess {Integer} images.height Height of image
    * @apiSuccess {Object} attachments Attachments object (Empty if no attachments exist)<br>Attachment URL to be formed - "{aws_s3_base_url}/content/event_attachments/{event_id}/{filename}
    * @apiSuccess {Integer} attachments.id Unique identifier
    * @apiSuccess {Integer} attachments.event_id Event ID
    * @apiSuccess {Integer} attachments.filename Attachment file name
    * @apiSuccess {Integer} attachments.description Description
    * @apiSuccess {Integer} attachments.order Order
    * @apiSuccess {Integer} attachments.size Size of file in bytes
    * @apiSuccess {Integer} attachments.groupstring Attachments with same 'groupstring' must be grouped with 'groupstring' as subheading
    */

    public function index_post($id=null)
    {
        if($this->error)
            return;

        $this->load->model('content/events_model');
        $this->load->model('content/events_images_model');
        $this->load->model('content/event_attachments_model');
        $this->load->model('category/categories_model');

        if ($id === NULL)
        {
            $list=$this->events_model->listAdmin();
            unset($list['recordsFiltered']);
            $users=$list;
            if ($users)
            {
                $this->response($users, REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response([
                    'status' => FALSE,
                    'message' => 'No events were found'
                ], REST_Controller::HTTP_NOT_FOUND);
            }
        }
        else
        {
            $id = (int) $id;
            if ($id <= 0)
            {
                $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST);
            }
            $user = NULL;
            $eventData=$this->events_model->eventData($id);

            if (!empty($eventData))
            {
                unset($eventData['event']->wp_id);
                unset($eventData['event']->created_on);
                unset($eventData['event']->created_by);
                unset($eventData['event']->modified_on);
                unset($eventData['event']->modified_by);
                unset($eventData['event']->seo_keywords);
                unset($eventData['event']->seo_description);
                unset($eventData['event']->fb_link);
                unset($eventData['event']->fb_status_type);
                unset($eventData['event']->fb_data);
                unset($eventData['event']->import_from_fb);
                unset($eventData['event']->fb_id);
                unset($eventData['event']->facebook_post_id);
                $user=$eventData;
            }

            if (!empty($user))
            {
                $this->set_response($user, REST_Controller::HTTP_OK);
            }
            else
            {
                $this->set_response([
                    'status' => FALSE,
                    'message' => 'Event not found'
                ], REST_Controller::HTTP_NOT_FOUND);
            }
        }
    }

    /**
    * @api {post} /eventsadmin/post Create/Post a new Event
    * @apiPermission Super Admin, Content Admin
    * @apiName Post event
    * @apiGroup Events Admin
    
    * @apiParam {String} name Event name<br>
    *                             Minlength\:6<br>
    *                             Maxlength\:200<br>
     *                             Must be unique
    * @apiParam {String} location Location<br>
    *                             Minlength\:3<br>
    *                             Maxlength\:100
    * @apiParam {Array} categories Category ID(s)
    * @apiParam {String} seo_keywords SEO Keywords<br>
    *                             Minlength\:10<br>
    *                             Maxlength\:500
    * @apiParam {String} seo_description SEO Description<br>
    *                             Minlength\:10<br>
    *                             Maxlength\:500
    * @apiParam {String} description Description
    * @apiParam {String} start_date Start date in format dd MMM YYYY
    * @apiParam {String} end_date End date in format dd MMM YYYY
    * @apiParam {Integer} [parent_id] Unique identifier of Parent event
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true,
            "event_id": 4148
        }
    *
    * @apiSuccess {boolean} status True if success otherwise false
    * @apiSuccess {Integer} event_id Event ID of created event
    */
    public function post_post()
    {
        if($this->error)
            return;

        $this->load->model('content/events_model');
        $this->load->model('content/events_category_model');
        $this->load->model('content/events_images_model');
        $this->load->model('content/event_attachments_model');
        $this->load->model('category/categories_model');

        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        if(!isset($_POST['description']))
        {
            $response['message']="Description field required";
            goto end;
        }
        if(!isset($_POST['seo_keywords']))
        {
            $response['message']="SEO Keywords field is required";
            goto end;
        }
        if(!isset($_POST['seo_description']))
        {
            $response['message']="SEO Description field is required";
            goto end;
        }
        if(!isset($_POST['categories']))
        {
            $response['message']="Categories field is required";
            goto end;
        }

        $this->form_validation->set_rules('name', 'Event Title', 'trim|required|min_length[6]|max_length[200]|eventNameCheck[0]');
        $this->form_validation->set_rules('location', 'Event Location', 'trim|required|min_length[3]|max_length[100]');
        $this->form_validation->set_rules('categories[]', 'Categories', 'checkCategories');
        $this->form_validation->set_rules('start_date', 'Start Date', 'trim|required|valid_date');
        if(isset($_POST['start_date']))
            $this->form_validation->set_rules('end_date', 'End Date', 'trim|required|valid_date|eventDateRangeCheck['.$_POST['start_date'].']');
        $this->form_validation->set_rules('seo_keywords', 'SEO Keywords', 'trim|min_length[10]|max_length[500]');
        $this->form_validation->set_rules('seo_description', 'SEO Description', 'trim|min_length[10]|max_length[500]');
        $this->form_validation->set_rules('parent_id', 'Parent Event', 'trim|numeric|validate_event_parent[0]');
        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }

        $saved=$this->events_model->save(0,array());
        $response['event_id']=$saved;
        $response['status']=true;
        if ($saved)
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /eventsadmin/update/:id Update an Event
    * @apiPermission Super Admin, Content Admin
    * @apiName Update
    * @apiGroup Events Admin
    
    * @apiParam {String} name Event name<br>
    *                             Minlength\:6<br>
    *                             Maxlength\:200<br>
     *                             Must be unique
    * @apiParam {String} location Location<br>
    *                             Minlength\:3<br>
    *                             Maxlength\:100
    * @apiParam {Array} categories Category ID(s)
    * @apiParam {String} seo_keywords SEO Keywords<br>
    *                             Minlength\:10<br>
    *                             Maxlength\:500
    * @apiParam {String} seo_description SEO Description<br>
    *                             Minlength\:10<br>
    *                             Maxlength\:500
    * @apiParam {String} description Description
    * @apiParam {String} start_date Start date in format dd MMM YYYY
    * @apiParam {String} end_date End date in format dd MMM YYYY
    * @apiParam {Integer} [parent_id] Unique identifier of Parent event
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true
        }
    *
    * @apiSuccess {boolean} status True if success otherwise false
    */
    public function update_post($eventId=0)
    {
        if($this->error)
            return;


        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        if(!is_numeric($eventId) || !$eventId)
        {
            $response['mmessage']="Invalid Event ID";
            goto end;
        }
        else
        {
            $this->load->model('content/events_model');
            $this->load->model('content/events_category_model');
            $this->load->model('content/events_images_model');
            $this->load->model('content/event_attachments_model');
            $this->load->model('category/categories_model');
            $eventData=$this->events_model->eventData($eventId);
            if(empty($eventData['event']))
            {
                $response['mmessage']="Invalid Event ID";
                goto end;
            }
        }

        if(!isset($_POST['description']))
        {
            $response['message']="Description field required";
            goto end;
        }
        if(!isset($_POST['seo_keywords']))
        {
            $response['message']="SEO Keywords field is required";
            goto end;
        }
        if(!isset($_POST['seo_description']))
        {
            $response['message']="SEO Description field is required";
            goto end;
        }
        if(!isset($_POST['categories']))
        {
            $response['message']="Categories field is required";
            goto end;
        }

        $this->form_validation->set_rules('name', 'Event Title', 'trim|required|min_length[6]|max_length[200]|eventNameCheck['.$eventId.']');
        $this->form_validation->set_rules('location', 'Event Location', 'trim|required|min_length[3]|max_length[100]');
        $this->form_validation->set_rules('categories[]', 'Categories', 'checkCategories');
        $this->form_validation->set_rules('start_date', 'Start Date', 'trim|required|valid_date');
        if(isset($_POST['start_date']))
            $this->form_validation->set_rules('end_date', 'End Date', 'trim|required|valid_date|eventDateRangeCheck['.$_POST['start_date'].']');
        $this->form_validation->set_rules('seo_keywords', 'SEO Keywords', 'trim|min_length[10]|max_length[500]');
        $this->form_validation->set_rules('seo_description', 'SEO Description', 'trim|min_length[10]|max_length[500]');
        $this->form_validation->set_rules('parent_id', 'Parent Event', 'trim|numeric|validate_event_parent['.$eventId.']');
        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }

        $this->events_model->save($eventId,$eventData);
        $response['status']=true;
        if ($saved)
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /eventsadmin/delete/:id Delete an Event
     * @apiPermission Super Admin, Content Admin
    * @apiName Delete event
    * @apiGroup Events Admin
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true,
            "name": "Event Name"
        }
    *
    * @apiSuccess {boolean} status True if success otherwise false
    * @apiSuccess {String} name Event name
    */
   
    public function delete_post($eventId=0)
    {
        if($this->error)
            return;
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        if(is_numeric($eventId) && $eventId)
        {
            $this->load->model('content/events_model');
            $this->load->model('content/events_category_model');
            $this->load->model('content/events_images_model');
            $this->load->model('content/event_attachments_model');
            $this->load->model('category/categories_model');

            $eventData=$this->events_model->eventData($eventId);
            if(empty($eventData['event']))
            {
                $response['message']="Invalid Event ID";
                goto end;
            }
            $children=$this->events_model->getChildren($eventId);
            if(!empty($children))
            {
                $response['message']="Event cannot be deleted. It is associated with other events.";
                goto end;
            }

            $r=$this->events_model->delete($eventId,$eventData);
            if($r)
            {
                $response['status']=true;
                $response['name']=$eventData['event']->name;
            }
        }
        else
        {
            $response['message']="Invalid Event ID";
        }
        


        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /eventsadmin/upload_image/:event_id Upload an image
    * @apiPermission Super Admin, Content Admin
    * @apiName Upload image
    * @apiGroup Events Admin
    * @apiParam {File} files[] Image files<br>
    *                             Allowed image types\:jpeg/png/jpg<br>
    *                             Maxsize\:5 MB
    *                             
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true,
            "files": [
                {
                    "fileid": 29194,
                    "filename": "dattapeetham_d4648ec5514d4f97c50fba1e14ae2c78.jpg",
                    "title": "2015_audi_a3_29_1920x1080.jpg",
                    "name": "2015_audi_a3_29_1920x1080.jpg",
                    "type": "image/jpeg",
                    "size": 831974,
                    "status": 1
                }
            ]
        }
    *
    * @apiSuccess {boolean} status True if success otherwise false
    * @apiSuccess {Object} files Files object
    * @apiSuccess {Integer} files.fileid Unique identifier of uploaded file
    * @apiSuccess {String} files.filename File name
    * @apiSuccess {String} files.title Title
    * @apiSuccess {String} files.name Name
    * @apiSuccess {String} files.type MIME Type of file
    * @apiSuccess {Integer} files.size Size in bytes
    * @apiSuccess {Integer} files.status 1 if success otherwise 0.<br> Please note that this status varies for multiple files.
    */
   
    public function upload_image_post($eventId=0)
    {
        if($this->error)
            return;

        $this->load->model('content/events_model');
        $this->load->model('content/events_category_model');
        $this->load->model('content/events_images_model');
        $this->load->model('content/event_attachments_model');
        $this->load->model('category/categories_model');

        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        $allowed_file_types =   array('image/jpeg','image/jpg','image/png');
        $json['files']=[];
        if(is_numeric($eventId) && $eventId)
        {
            $eventData=$this->events_model->eventData($eventId);
            if(!empty($eventData) && isset($_FILES['files']))
            {
                foreach ($_FILES['files']['name'] as $key => $file)
                {
                    $ext=pathinfo ($_FILES['files']['name'][$key],PATHINFO_EXTENSION);
                    if($ext=='' || !in_array($_FILES['files']['type'][$key],$allowed_file_types))
                    {
                        $json['files'][] = array(
                        'name' => $file,
                        'size' => $_FILES['files']['size'][$key],
                        'type' => $_FILES['files']['type'][$key],
                        'error' => "Extension not allowed",
                        'status'=>0
                        );
                    }
                    else if($_FILES['files']['size'][$key]==0)
                    {
                        $json['files'][] = array(
                        'name' => $file,
                        'size' => $_FILES['files']['size'][$key],
                        'type' => $_FILES['files']['type'][$key],
                        'error' => "Invalid File Size",
                        'status'=>0
                        );
                    }
                    else if($_FILES['files']['size'][$key]>(5*1024*1024))
                    {
                        $json['files'][] = array(
                        'name' => $file,
                        'size' => $_FILES['files']['size'][$key],
                        'type' => $_FILES['files']['type'][$key],
                        'error' => "File Size exceeded 5 MB",
                        'status'=>0
                        );
                    }
                    else
                    {   
                        $json['files'][0]=$this->events_images_model->uploadFile($eventData);
                        $json['files'][0]['name']=$file;
                        $json['files'][0]['type']=$_FILES['files']['type'][$key];
                        $json['files'][0]['size']=$_FILES['files']['size'][$key];
                        $json['files'][0]['status']=1;
                    }
                }
                $response['files']=$json['files'];
                $response['status']=true;
            }
            else
            {
                if(isset($_FILES['files']))
                {
                    foreach ($_FILES['files']['name'] as $key => $file) 
                    {
                        $json['files'][] = array(
                        'name' => $file,
                        'size' => $_FILES['files']['size'][$key],
                        'type' => $_FILES['files']['type'][$key],
                        'error' => "Invalid Event ID",
                        'status'=>0
                        );
                    }
                
                    $response['files']=$json['files'];
                }
                $response['message']="Invalid ID or file(s) does not present";
                goto end;
            }
        }
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }
    /**
    * @api {post} /eventsadmin/image_update_description Update description for image
    * @apiPermission Super Admin, Content Admin
    * @apiName  Image description
    * @apiGroup Events Admin
    * @apiParam {Integer} event_id Unique identifier of Event
    * @apiParam {Integer} image_id Unique identifier of image
    * @apiParam {String} description Description<br>
    *                             Minlength\:0
    *                             Maxlength\:200
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true
        }
    *                        
    * @apiSuccess {Boolean} status true if success otherwise false
    */   

    public function image_update_description_post()
    {
        if($this->error)
            return;

        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        if(!isset($_POST['description']))
        {
            $response['message']="Description field is required";
            goto end;
        }
        $this->form_validation->set_rules('event_id', 'Event ID', 'trim|required|numeric');
        $this->form_validation->set_rules('image_id', 'Image ID', 'trim|required|numeric');
        $this->form_validation->set_rules('description', 'Description', 'trim|max_length[200]');

        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }

        if($_POST['event_id'] && $_POST['image_id'])
        {
            $this->load->model('content/events_model');
            $this->load->model('content/events_category_model');
            $this->load->model('content/events_images_model');
            $this->load->model('content/event_attachments_model');
            $this->load->model('category/categories_model');

            $eventData=$this->events_model->eventData($_POST['event_id']);
            if(!empty($eventData['event']))
            {
                $imageData=$this->events_images_model->imageData($_POST['image_id'],$_POST['event_id']);
                if(!empty($imageData))
                {
                    $this->events_images_model->updateInfo($_POST['image_id'],'description',$_POST['description']);
                    $response['status']=true;
                }
                else
                {
                    $response['message']="Invalid Image ID";
                }
            }
            else
            {
                $response['message']="Invalid Event ID";
            }
        }
        else
        {
            $response['message']="Event ID or Image ID is invalid";
        }
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }
    /**
    * @api {post} /eventsadmin/image_update_order Update description for image
    * @apiPermission Super Admin, Content Admin
    * @apiName  Image description
    * @apiGroup Events Admin
    * @apiParam {Integer} event_id Unique identifier of Event
    * @apiParam {Integer} image_id Unique identifier of image
    * @apiParam {Integer} order Order of image<br>
    *                             Minlength\:1
    *                             Maxlength\:3
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true
        }
    *                        
    * @apiSuccess {Boolean} status true if success otherwise false
    */   
    public function image_update_order_post()
    {
        if($this->error)
            return;

        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        $this->form_validation->set_rules('event_id', 'Event ID', 'trim|required|numeric');
        $this->form_validation->set_rules('image_id', 'Image ID', 'trim|required|numeric');
        $this->form_validation->set_rules('order', 'Order', 'trim|required|numeric|max_length[3]');

        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }

        if($_POST['event_id'] && $_POST['image_id'])
        {
            $this->load->model('content/events_model');
            $this->load->model('content/events_category_model');
            $this->load->model('content/events_images_model');
            $this->load->model('content/event_attachments_model');
            $this->load->model('category/categories_model');

            $eventData=$this->events_model->eventData($_POST['event_id']);
            if(!empty($eventData['event']))
            {
                $imageData=$this->events_images_model->imageData($_POST['image_id'],$_POST['event_id']);
                if(!empty($imageData))
                {
                    $this->events_images_model->updateInfo($_POST['image_id'],'order',$_POST['order']);
                    $response['status']=true;
                }
                else
                {
                    $response['message']="Invalid Image ID";
                }
            }
            else
            {
                $response['message']="Invalid Event ID";
            }
        }
        else
        {
            $response['message']="Event ID or Image ID is invalid";
        }
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }
    /**
    * @api {post} /eventsadmin/delete_image Delete an image
    * @apiPermission Super Admin, Content Admin
    * @apiName  Delete image
    * @apiGroup Events Admin
    * @apiParam {Integer} event_id Unique identifier of Event
    * @apiParam {Integer} image_id Unique identifier of image
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true,
            "filename": 'filename.jpg'
        }
    *                        
    * @apiSuccess {Boolean} status true if success otherwise false
    * @apiSuccess {String} filename File name of deleted image. This is set only if status is true
    */   
    public function delete_image_post()
    {
        if($this->error)
            return;

        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        $this->form_validation->set_rules('event_id', 'Event ID', 'trim|required|numeric');
        $this->form_validation->set_rules('image_id', 'Image ID', 'trim|required|numeric');

        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }

        if($_POST['event_id'] && $_POST['image_id'])
        {
            $this->load->model('content/events_model');
            $this->load->model('content/events_category_model');
            $this->load->model('content/events_images_model');
            $this->load->model('content/event_attachments_model');
            $this->load->model('category/categories_model');

            $eventData=$this->events_model->eventData($_POST['event_id']);
            if(!empty($eventData['event']))
            {
                $imageData=$this->events_images_model->imageData($_POST['image_id'],$_POST['event_id']);
                if(!empty($imageData))
                {
                    $r=$this->events_images_model->delete($eventData,$imageData);
                    if($r)
                    {
                        $response['status']=true;
                        $response['filename']=$imageData->filename;
                    }
                }
                else
                {
                    $response['message']="Invalid Image ID";
                }
            }
            else
            {
                $response['message']="Invalid Event ID";
            }
        }
        else
        {
            $response['message']="Event ID or Image ID is invalid";
        }
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /eventsadmin/upload_attachement/:event_id Upload a file/attachment
    * @apiPermission Super Admin, Content Admin
    * @apiName Upload attachment
    * @apiGroup Events Admin
    * @apiParam {File} files[] Image files<br>
    *                             Excluded extensions\: To be updated<br>
    *                             Maxsize\:5 MB
    *                             
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true,
            "files": [
                {
                    "fileid": 29194,
                    "filename": "dattapeetham_d4648ec5514d4f97c50fba1e14ae2c78.jpg",
                    "title": "2015_audi_a3_29_1920x1080.jpg",
                    "name": "2015_audi_a3_29_1920x1080.jpg",
                    "type": "image/jpeg",
                    "size": 831974,
                    "status": 1
                }
            ]
        }
    *
    * @apiSuccess {boolean} status True if success otherwise false
    * @apiSuccess {Object} files Files object
    * @apiSuccess {Integer} files.fileid Unique identifier of uploaded file
    * @apiSuccess {String} files.filename File name
    * @apiSuccess {String} files.title Title
    * @apiSuccess {String} files.name Name
    * @apiSuccess {String} files.type MIME Type of file
    * @apiSuccess {Integer} files.size Size in bytes
    * @apiSuccess {Integer} files.status 1 if success otherwise 0.<br> Please note that this status varies for multiple files.
    */
   
    public function upload_attachment_post($eventId=0)
    {
        if($this->error)
            return;

        $this->load->model('content/events_model');
        $this->load->model('content/events_category_model');
        $this->load->model('content/events_images_model');
        $this->load->model('content/event_attachments_model');
        $this->load->model('category/categories_model');

        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        $exts=$GLOBALS['site_settings']['blocked_file_types'];
        $excludedExtensions=explode("|",$exts);
        $json['files']=[];
        if(is_numeric($eventId) && $eventId)
        {
            $eventData=$this->events_model->eventData($eventId);
            if(!empty($eventData) && isset($_FILES['files']))
            {
                foreach ($_FILES['files']['name'] as $key => $file) 
                {
                    $ext=pathinfo ($_FILES['files']['name'][0],PATHINFO_EXTENSION);

                    
                    if($ext=='' || in_array($ext,$excludedExtensions))
                    {
                        $json['files'][] = array(
                        'name' => $file,
                        'size' => $_FILES['files']['size'][$key],
                        'type' => $_FILES['files']['type'][$key],
                        'error' => "Extension not allowed",
                        'status'=>0
                        );
                    }
                    else if($_FILES['files']['size'][$key]==0)
                    {
                        $json['files'][] = array(
                        'name' => $file,
                        'size' => $_FILES['files']['size'][$key],
                        'type' => $_FILES['files']['type'][$key],
                        'error' => "Invalid File Size",
                        'status'=>0
                        );
                    }
                    else if($_FILES['files']['size'][$key]>(5*1024*1024))
                    {
                        $json['files'][] = array(
                        'name' => $file,
                        'size' => $_FILES['files']['size'][$key],
                        'type' => $_FILES['files']['type'][$key],
                        'error' => "File Size exceeded 5 MB",
                        'status'=>0
                        );
                    }
                    else
                    {   
                        $json['files'][0]=$this->event_attachments_model->uploadFile($eventData);
                        $json['files'][0]['name']=$file;
                        $json['files'][0]['type']=$_FILES['files']['type'][$key];
                        $json['files'][0]['size']=$_FILES['files']['size'][$key];
                        $json['files'][0]['status']=1;
                    }
                }
                $response['files']=$json['files'];
                $response['status']=true;
            }
            else
            {
                if(isset($_FILES['files']))
                {
                    foreach ($_FILES['files']['name'] as $key => $file) 
                    {
                        $json['files'][] = array(
                        'name' => $file,
                        'size' => $_FILES['files']['size'][$key],
                        'type' => $_FILES['files']['type'][$key],
                        'error' => "Invalid Event ID",
                        'status'=>0
                        );
                    }
                    $response['files']=$json['files'];
                }
                $response['message']="Invalid Event ID or files(s) does not present";
                goto end;
            }
        }
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }
    /**
    * @api {post} /eventsadmin/attachment_update_description Update description for attachment
    * @apiPermission Super Admin, Content Admin
    * @apiName  Attachment description
    * @apiGroup Events Admin
    * @apiParam {Integer} event_id Unique identifier of Event
    * @apiParam {Integer} attachment_id Unique identifier of attachment
    * @apiParam {String} description Description<br>
    *                             Minlength\:0
    *                             Maxlength\:200
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true
        }
    *                        
    * @apiSuccess {Boolean} status true if success otherwise false
    */   
    public function attachment_update_description_post()
    {
        if($this->error)
            return;

        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        if(!isset($_POST['description']))
        {
            $response['message']="Description field is required";
            goto end;
        }
        $this->form_validation->set_rules('event_id', 'Event ID', 'trim|required|numeric');
        $this->form_validation->set_rules('attachment_id', 'Attachment ID', 'trim|required|numeric');
        $this->form_validation->set_rules('description', 'Description', 'trim|max_length[200]');

        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }

        if($_POST['event_id'] && $_POST['attachment_id'])
        {
            $this->load->model('content/events_model');
            $this->load->model('content/events_category_model');
            $this->load->model('content/events_images_model');
            $this->load->model('content/event_attachments_model');
            $this->load->model('category/categories_model');

            $eventData=$this->events_model->eventData($_POST['event_id']);
            if(!empty($eventData['event']))
            {
                $attachmentData=$this->event_attachments_model->attachmentData($_POST['attachment_id'],$_POST['event_id']);
                if(!empty($attachmentData))
                {
                    $this->event_attachments_model->updateInfo($_POST['attachment_id'],'description',$_POST['description']);
                    $response['status']=true;
                }
                else
                {
                    $response['message']="Invalid Attachment ID";
                }
            }
            else
            {
                $response['message']="Invalid Event ID";
            }
        }
        else
        {
            $response['message']="Event ID or Attachment ID is invalid";
        }
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /eventsadmin/attachment_update_order Update description for attachment
    * @apiPermission Super Admin, Content Admin
    * @apiName  Attachment description
    * @apiGroup Events Admin
    * @apiParam {Integer} event_id Unique identifier of Event
    * @apiParam {Integer} attachment_id Unique identifier of attachment
    * @apiParam {Integer} order Order of attachment<br>
    *                             Minlength\:1
    *                             Maxlength\:3
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true
        }
    *                        
    * @apiSuccess {Boolean} status true if success otherwise false
    */   
    public function attachment_update_order_post()
    {
        if($this->error)
            return;

        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        $this->form_validation->set_rules('event_id', 'Event ID', 'trim|required|numeric');
        $this->form_validation->set_rules('attachment_id', 'Attachment ID', 'trim|required|numeric');
        $this->form_validation->set_rules('order', 'Order', 'trim|required|numeric|max_length[3]');

        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }

        if($_POST['event_id'] && $_POST['attachment_id'])
        {
            $this->load->model('content/events_model');
            $this->load->model('content/events_category_model');
            $this->load->model('content/events_images_model');
            $this->load->model('content/event_attachments_model');
            $this->load->model('category/categories_model');

            $eventData=$this->events_model->eventData($_POST['event_id']);
            if(!empty($eventData['event']))
            {
                $attachmentData=$this->event_attachments_model->attachmentData($_POST['attachment_id'],$_POST['event_id']);
                if(!empty($attachmentData))
                {
                    $this->event_attachments_model->updateInfo($_POST['attachment_id'],'order',$_POST['order']);
                    $response['status']=true;
                }
                else
                {
                    $response['message']="Invalid Attachment ID";
                }
            }
            else
            {
                $response['message']="Invalid Event ID";
            }
        }
        else
        {
            $response['message']="Event ID or Attachment ID is invalid";
        }
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }
    /**
    * @api {post} /eventsadmin/delete_attachment Delete an attachment
    * @apiPermission Super Admin, Content Admin
    * @apiName  Delete attachment
    * @apiGroup Events Admin
    * @apiParam {Integer} event_id Unique identifier of Event
    * @apiParam {Integer} attachment_id Unique identifier of attachment
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true,
            "filename": 'filename.jpg'
        }
    *                        
    * @apiSuccess {Boolean} status true if success otherwise false
    * @apiSuccess {String} filename File name of deleted attachment. This is set only if status is true
    */   
    public function delete_attachment_post()
    {
        if($this->error)
            return;

        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        $this->form_validation->set_rules('event_id', 'Event ID', 'trim|required|numeric');
        $this->form_validation->set_rules('attachment_id', 'Attachment ID', 'trim|required|numeric');

        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }

        if($_POST['event_id'] && $_POST['attachment_id'])
        {
            $this->load->model('content/events_model');
            $this->load->model('content/events_category_model');
            $this->load->model('content/events_images_model');
            $this->load->model('content/event_attachments_model');
            $this->load->model('category/categories_model');

            $eventData=$this->events_model->eventData($_POST['event_id']);
            if(!empty($eventData['event']))
            {
                $attachmentData=$this->event_attachments_model->attachmentData($_POST['attachment_id'],$_POST['event_id']);
                if(!empty($attachmentData))
                {
                    $r=$this->event_attachments_model->delete($eventData,$attachmentData);
                    if($r)
                    {
                        $response['status']=true;
                        $response['filename']=$attachmentData->filename;
                    }
                }
                else
                {
                    $response['message']="Invalid Attachment ID";
                }
            }
            else
            {
                $response['message']="Invalid Event ID";
            }
        }
        else
        {
            $response['message']="Event ID or Attachment ID is invalid";
        }
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /eventsadmin/check_name/:id Check event name
    * @apiDescription Check whether event name forms a valid slug and does not exist
    * @apiPermission Super Admin, Content Admin
    * @apiName  Check name
    * @apiGroup Events Admin
    * @apiParam {String} name Event name<br>
    *                             Minlength\:6
    *                             Maxlength\:200
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true
        }
    *                        
    * @apiSuccess {Boolean} status true if success otherwise false
    */   

    public function check_name_post($eventId=0)
    {
        if($this->error)
            return;

        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        $this->form_validation->set_rules('name', 'Event Name', 'trim|required|min_length[6]|max_length[200]');

        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }

        $slug=url_title($this->general_model->filtertext($_POST['name']));

        if(strlen($slug)<6)
        {
            $response['message']="Invalid slug";
            goto end;
        }
        else
        {
            if(is_numeric($eventId))
            {
                $flag=$this->events_model->checkEventName($this->general_model->filtertext(trim($_POST['name'])),$eventId);
                if($flag==1)
                {
                    $response['message']="Event name already exists";
                    goto end;
                }
                else
                {
                    $response['status']=true;
                }
            }
            else
            {
                $response['message']="Invalid Event ID";
                goto end;
            }
        }

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }
}
?>