<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}

//use Restserver\Libraries\REST_Controller;
class Events extends REST_Controller {

    function __construct()
    {
        parent::__construct();
        $this->load->library("server");
        $this->server->require_scope("user");
    }

    /**
    * @api {post} /events Get events
    * @apiPermission Logged in User
    * @apiName Events
    * @apiGroup Events
    *
    * @apiParam {String} [search_text] Searches speeches
    * @apiParam {String} [per_page]  Page Number
    * @apiParam {Integer} [year]  Year
    * @apiParam {Integer} [month]  Month (Valid only if year is set)
    *
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *     {
              "num": "1576",
              "res": [
                {
                    "id": "1561",
                    "name": "October 23, 2016",
                    "description": "October 23",
                    "start_date": "07 Mar 2016 (Mon)",
                    "end_date": "08 Mar 2016 (Tue)",
                    "location": "Mysore, India",
                    "month": "3",
                    "year": "2016",
                    "slug": "maha-shivaratri-at-datta-peetham-2016",
                    "start_date_raw": "07 Mar 2016",
                    "end_date_raw": "08 Mar 2016",
                    "color": "red",
                    "thumb": "dattapeetham_911317e244187b4e1e70d7f852da3bac.jpg",
                    "thumb_url": "https://dev-dattapeetham.s3.amazonaws.com/..//..//dattapeetham_911317e244187b4e1e70d7f852da3bac.jpg",
                    "aws_s3_base_url": "https://dev-dattapeetham.s3.amazonaws.com/"
                }
        }
    *
    * @apiSuccess {Integer} num  Total number of results
    * @apiSuccess {Object} res Events Object
    * @apiSuccess {Integer} res.id Unique Identifier
    * @apiSuccess {String} res.name Name
    * @apiSuccess {String} res.description Description in HTML format/code
    * @apiSuccess {String} res.start_date Start Date in format dd MMM YYYY (D)
    * @apiSuccess {String} res.end_date End Date in format dd MMM YYYY (D)
    * @apiSuccess {String} res.location Location of event
    * @apiSuccess {String} res.slug Slug
    * @apiSuccess {Date} res.published_on Published Date in format dd MMM YYYY
    * @apiSuccess {Integer} res.year Year
    * @apiSuccess {Integer} res.month Month
    * @apiSuccess {String} res.start_date_raw Start Date in format dd MMM YYYY
    * @apiSuccess {String} res.end_date_raw End Date in format dd MMM YYYY
    * @apiSuccess {String} res.thumb Thumbnail file name
    * @apiSuccess {String} res.thumb_url Thumbnail URL
    * @apiSuccess {String} res.aws_s3_base_url CDN Base url for files
    */
    
    /**
    * @api {post} /events/:id Get an event
    * @apiPermission Logged in User
    * @apiName Get
    * @apiGroup Events
    *
    * @apiExample {curl} Example usage:
      curl -i /events/1561
    *
    * @apiSuccessExample {json} Success-Response:
    *     HTTP/1.1 200 OK
    *     {
            "event":
            {
                "id": "3348",
                "name": "Maha Shivaratri at Datta Peetham - 2016",
                "start_date": "2016-03-07 00:00:00",
                "end_date": "2016-03-08 00:00:00",
                "description": "<p>The annual festival, Maha Shivaratri</p>",
                "location": "Mysore, India",
                "month": "3",
                "year": "2016",
                "slug": "maha-shivaratri-at-datta-peetham-2016",
                "image_count": "0",
                "categories": "",
                "parent_link": "0",
                "reads": "474",
                "status": "1"
            },
            "images":
            [
                {
                    "id": "29036",
                    "event_id": "3348",
                    "filename": "dattapeetham_911317e244187b4e1e70d7f852da3bac.jpg",
                    "description": null,
                    "order": "0",
                    "width": "500",
                    "height": "353"
                }
            ]
            "attachments":
            [
                {
                    "id": "2309",
                    "event_id": "3334",
                    "filename": "dattapeetham_60a4849888accefcd639be5a4a765fee.jpg",
                    "description": null,
                    "order": "0",
                    "size": "226051",
                    "groupstring": null
                }
            ]
        }
    * 
    * @apiSuccess {Object} event  Event object
    * @apiSuccess {Integer} event.id  Unique Identifier
    * @apiSuccess {String} event.name Event Name
    * @apiSuccess {String} event.description Description in HTML format/code
    * @apiSuccess {String} event.categories Category IDs with comma(,) separated
    * @apiSuccess {String} event.slug Slug value
    * @apiSuccess {String} event.location Location
    * @apiSuccess {String} event.parent_link Parent event Unique identifier
    * @apiSuccess {Date} event.start_date Start Date in YYYY-mm-dd HH:ii:ss
    * @apiSuccess {Date} event.end_date End Date in YYYY-mm-dd HH:ii:ss
    * @apiSuccess {Integer} event.year Year
    * @apiSuccess {Integer} event.month Month
    * @apiSuccess {Integer} event.reads Number of reads/views
    * @apiSuccess {Integer} event.status Status (Default 1)
    * @apiSuccess {Object} images Images object (Empty if no images exist)<br>Image URL to be formed - "{aws_s3_base_url}/content/event_images/{event_id}/thumb_{filename}"
    * @apiSuccess {Integer} images.id Unique identifier
    * @apiSuccess {Integer} images.event_id Event ID
    * @apiSuccess {Integer} images.filename Image file name
    * @apiSuccess {Integer} images.description Description
    * @apiSuccess {Integer} images.order Order
    * @apiSuccess {Integer} images.width Width of image
    * @apiSuccess {Integer} images.height Height of image
    * @apiSuccess {Object} attachments Attachments object (Empty if no attachments exist)<br>Attachment URL to be formed - "{aws_s3_base_url}/content/event_attachments/{event_id}/{filename}
    * @apiSuccess {Integer} attachments.id Unique identifier
    * @apiSuccess {Integer} attachments.event_id Event ID
    * @apiSuccess {Integer} attachments.filename Attachment file name
    * @apiSuccess {Integer} attachments.description Description
    * @apiSuccess {Integer} attachments.order Order
    * @apiSuccess {Integer} attachments.size Size of file in bytes
    * @apiSuccess {Integer} attachments.groupstring Attachments with same 'groupstring' must be grouped with 'groupstring' as subheading
    */

    public function index_post($id=null)
    {
        $this->load->model('content/events_model');
        $this->load->model('content/events_images_model');
        $this->load->model('content/event_attachments_model');
        $this->load->model('category/categories_model');

        if ($id === NULL)
        {
            $list=$this->events_model->listPublic();
            unset($list['links']);
            $users=$list;
            if ($users)
            {
                $this->response($users, REST_Controller::HTTP_OK);
            }
            else
            {
                $this->response([
                    'status' => FALSE,
                    'message' => 'No events were found'
                ], REST_Controller::HTTP_NOT_FOUND);
            }
        }
        else
        {
            $id = (int) $id;
            if ($id <= 0)
            {
                $this->response(NULL, REST_Controller::HTTP_BAD_REQUEST);
            }
            $user = NULL;
            $eventData=$this->events_model->eventData($id);

            if (!empty($eventData))
            {
                unset($eventData['event']->wp_id);
                unset($eventData['event']->created_on);
                unset($eventData['event']->created_by);
                unset($eventData['event']->modified_on);
                unset($eventData['event']->modified_by);
                unset($eventData['event']->seo_keywords);
                unset($eventData['event']->seo_description);
                unset($eventData['event']->fb_link);
                unset($eventData['event']->fb_status_type);
                unset($eventData['event']->fb_data);
                unset($eventData['event']->import_from_fb);
                unset($eventData['event']->fb_id);
                unset($eventData['event']->facebook_post_id);
                $eventData['event']->aws_s3_base_url=aws_s3_base_url;
                $eventData['event']->base_url=base_url;
                $eventData['event']->start_date=date("d M Y",strtotime($eventData['event']->start_date));
                $eventData['event']->end_date=date("d M Y",strtotime($eventData['event']->end_date));
                $parentInfo=$this->events_model->eventData($eventData['event']->parent_link);
                if(!empty($parentInfo['event']))
                {
                    $eventData['event']->parent_info['id']=$parentInfo['event']->id;
                    $eventData['event']->parent_info['name']=$parentInfo['event']->name;
                }

                $childLinks=array();
                $child_events=$this->events_model->getChildren($id);

                foreach ($child_events as $child_event)
                {
                    $childLinks[]=array(
                                    "id"=>$child_event->id,
                                    "name"=>$child_event->name
                                    );
                }

                $eventData['event']->child_events=$childLinks;
                $description=$eventData['event']->description;
                $description=str_replace('src="/images/event_images/','src="'.base_url.'images/event_images/',$description);

                $eventData['event']->description=$description;
                $user=$eventData;
            }

            if (!empty($user))
            {
                $this->set_response($user, REST_Controller::HTTP_OK);
            }
            else
            {
                $this->set_response([
                    'status' => FALSE,
                    'message' => 'Event not found'
                ], REST_Controller::HTTP_NOT_FOUND);
            }
        }
    }

    /**
    * @api {post} /events/get_years_months Get possible years and months
    * @apiPermission Logged in User
    * @apiName Years and months list
    * @apiGroup Events
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *     {
              "years": [
                {
                    "2016",
                    "2015"
                },
                "months": {
                    "1996":
                    [
                        "12"
                    ]
                ],
        }
    *
    * @apiSuccess {Array} years List of years
    * @apiSuccess {Object} months Months Object (Keys will be years)
    * @apiSuccess {Array} res['year'] List of months for that year
    */
    public function get_years_months_post()
    {
        $this->load->model('content/events_model');
        $years=$this->events_model->getYearMonths();
        if ($years)
        {
            $this->response($years, REST_Controller::HTTP_OK);
        }
        else
        {
            $this->response([
                'status' => FALSE,
                'message' => 'No records found'
            ], REST_Controller::HTTP_NOT_FOUND);
        }
    }

    public function get_categories_post()
    {
        $this->load->model('category/categories_model');
        $this->categories_model->fetchCategories();
        $this->categories_model->sorted(0,1);
        //if ($years)
        //{
            $this->response($this->categories_model->sorted, REST_Controller::HTTP_OK);
        //}
    }
}
?>