<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}
//use Restserver\Libraries\REST_Controller;
class Donations extends REST_Controller {
    var $service='cart';
    var $currentUser='';
    function __construct()
    {
        parent::__construct();
        $this->load->library("server");
        $this->server->require_scope("user");
        $this->load->model('currencies_model');
        $this->load->model('ashrams/donations_model');
        $this->load->model('ashrams/ashrams_trust_accounts_model');
        $this->currentUser=$this->users_model->userDataByEmailorUsername($this->server->access_token_data['user_id']);
        //$this->load->model('oauth_sessions_model');
        //$this->oauth_sessions_model->session_check();

        /*if(!$this->session->userdata("donationCartAshramId"))
        {
            $this->session->set_userdata("donationCartAshramId",default_ashram_id);
        }
        if(!$this->session->userdata("donationCartAshramIdSelection"))
        {
            $this->session->set_userdata("donationCartAshramIdSelection",default_ashram_id);
        }*/

        /*if($this->session->userdata('id'))
            $this->currentUser=$this->session->userdata("admin_data");
        else
            $this->currentUser=$this->session->userdata("user_data");
        $this->currencies=$this->currencies_model->getByAshram($this->session->userdata("donationCartAshramIdSelection"));
        if(!$this->session->userdata("defaultCurrency"))
        {
            if(empty($this->currencies))
                $this->session->set_userdata("defaultCurrency",default_currency);
            else
            {
                $currency_keys=array_keys($this->currencies);
                $currency=$this->currencies[$currency_keys[0]];
                $this->session->set_userdata("defaultCurrency",$currency['currency']);
            }
        }
        else
        {
            $currency_valid=0;
            foreach($this->currencies as $temp_currency)
            {
                if($this->session->userdata("defaultCurrency")==$temp_currency['currency'])
                {
                    $currency_valid=1;
                    break;
                }
            }
            if($currency_valid==0)
            {
                $currency_keys=array_keys($this->currencies);
                $currency=$this->currencies[$currency_keys[0]];
                $this->session->set_userdata("defaultCurrency",$currency['currency']);
            }
        }
        $this->load->library('donationscart');
        $this->load->model('cart_model');
        $this->cart_model->validateCart($this->donationscart);

        $this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());*/
    }

    /**
    * @api {post} /donations Get Donations
    * @apiPermission User
    * @apiName List
    * @apiGroup Donations
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
    *   [
            {
                "id": "430",
                "donation_name": "Shashvata Seva (Life time membership)",
                "description": "Devotee Life time membership with Datta Peetham to support all activities of the Ashram",
                "image": "https://dev.dattapeetham.org/images/donation_images/49.jpg",
                "price_inr": "100000",
                "price_usd": "2001",
                "price": "INR 100000"
            }
        ]
    *
    * @apiSuccess {Integer} id  Unique identifier of Donation
    * @apiSuccess {String} donation_name Donation Name
    * @apiSuccess {String} description Description
    * @apiSuccess {String} image Donation Image
    * @apiSuccess {Integer} price_inr Price in INR
    * @apiSuccess {Integer} price_usd Price in USD
    * @apiSuccess {String} price Price with default Currency
    **/

    public function index_post()
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        if($GLOBALS['site_settings']['donations']==0)
        {
            goto end;
        }
        $ashram_id=default_ashram_id;
        if($this->input->post("ashram_id")!='')
        {
            $ashramData=$this->ashrams_model->ashramData($this->input->post("ashram_id"));
            if(!empty($ashramData))
                $ashram_id=$this->input->post("ashram_id");
        }
        $currency=default_currency;
        if($this->input->post("currency")!='')
        {
            $currencies=$this->currencies_model->getByAshram($ashram_id);
            if(isset($currencies[$this->input->post("currency")]))
            {
                $currency=$this->input->post("currency");
            }
        }

        $response['currency']=strtoupper($currency);
        $response['ashram_id']=$ashram_id;
        $donations=$this->donations_model->listPublicApi($ashram_id,$currency);

        //print_r($donations['categories_donations']);
        foreach ($donations['categories_donations'] as $did => $drow)
        {
            $drow=$drow[0];
            if($donations['categories_donations'][$did][0]['frequency']>1)
            {
                $donations['categories_donations'][$did][0]['frequency_text']="Every ".$donations['categories_donations'][$did][0]['frequency'];
                if($donations['categories_donations'][$did][0]['period']=='days')
                    $donations['categories_donations'][$did][0]['frequency_text'].=" days";
                if($donations['categories_donations'][$did][0]['period']=='weeks')
                    $donations['categories_donations'][$did][0]['frequency_text'].=" weeks";
                if($donations['categories_donations'][$did][0]['period']=='months')
                    $donations['categories_donations'][$did][0]['frequency_text'].=" months";
                if($donations['categories_donations'][$did][0]['period']=='years')
                    $donations['categories_donations'][$did][0]['frequency_text'].=" years";
            }
            else
            {
                $donations['categories_donations'][$did][0]['frequency_text']="Every ";
                if($donations['categories_donations'][$did][0]['period']=='days')
                    $donations['categories_donations'][$did][0]['frequency_text'].="day";
                if($donations['categories_donations'][$did][0]['period']=='weeks')
                    $donations['categories_donations'][$did][0]['frequency_text'].="week";
                if($donations['categories_donations'][$did][0]['period']=='months')
                    $donations['categories_donations'][$did][0]['frequency_text'].="month";
                if($donations['categories_donations'][$did][0]['period']=='years')
                    $donations['categories_donations'][$did][0]['frequency_text'].="year";
            }

            if($donations['categories_donations'][$did][0]['expiration_method']==0)
            {
                $donations['categories_donations'][$did][0]['expires_on']="Never";
            }
            else if($donations['categories_donations'][$did][0]['expiration_method']==1)
            {
                $donations['categories_donations'][$did][0]['expires_on']="After ".$drow['num_of_payments']." payment(s)";
            }
            else if($donations['categories_donations'][$did][0]['expiration_method']==2)
            {
                $donations['categories_donations'][$did][0]['expires_on']="On ".date("d M Y",strtotime($drow['expiry_date']));
            }

            if($donations['categories_donations'][$did][0]['subscription']==1 && $donations['categories_donations'][$did][0]['assign_pet']==1)
            {
                $donations['categories_donations'][$did][0]['assign_pet_text']='Yes';
            }
            else
                $donations['categories_donations'][$did][0]['assign_pet_text']='N/A';

            if($donations['categories_donations'][$did][0]['subscription']==1 || $donations['categories_donations'][$did][0]['is_price_fixed']==1)
            {
                $donations['categories_donations'][$did][0]['price']=$drow['price'];
            }
            else
                $donations['categories_donations'][$did][0]['price']='N/A';
        }

        $donations_sorted=array();
        foreach ($donations['categories'] as $key=> $category)
        {
            $donations_sorted[$key]['category']=$category['category'];
            $donations_sorted[$key]['donations']=$donations['categories_donations'][$category['id']];
        }

        $response['categories']=$donations_sorted;
        //$this->cart_log_model->log("App: Donations page opened",$ashram_id,2);
        $response['status']=true;
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /donations/add_to_cart/:donation_id Add donation to cart
    * @apiPermission User
    * @apiDescription
    * Rules:<br>
    * 1. Can add same ashram donations.<br>
    * 2. Maximum amounts are defined in currencies. Cart total cannot be greater than the specified amount.<br>
    * 3. Admin cannot add items to cart
    * @apiPermission User
    * @apiName Add to cart
    * @apiGroup Donations
    * @apiParam [Integer] amount Amount
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
        {
            "status": "true"
        }
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    **/

    public function add_to_cart_post($id=0)
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        if($GLOBALS['site_settings']['enable_orders']==0)
        {
            $response['message']="Sevas are disabled currently";
            goto end;
        }
        if($GLOBALS['site_settings']['donations']==0 && (!$this->session->userdata("id") || $this->session->userdata("admin_data")->roles!=1))
        {
            $response['message']="Donations are disabled";
            goto end;
        }

        if($this->session->userdata("loggedIn"))
        {
            if($this->currentUser->admin==0)
            {
                if($this->currentUser->email_verified==0)
                {
                    $response['message']="Email ID is not verified for User";
                    goto end;
                }
            }
            else
            {
                $response['message']="You are admin! Cannot add items to cart.";
                goto end;
            }
        }

        if($GLOBALS['donationCartLocked']==1)
        {
            $response['message']="Sorry, cannot add item, a transaction is already in progress";
            goto end;
        }

        if(is_numeric($id) && $id)
        {
            $cart=$this->donationscart->contents();
            $amount=$this->cart_model->getTotalPrice($this->donationscart);
            $donationData=$this->donations_model->donationData($id);
            $col="price_".strtolower($this->session->userdata("defaultCurrency"));

            if(empty($donationData))
            {
                $response['message']="Invalid Donation ID";
                goto end;
            }
            if($donationData->is_price_fixed==1)
                $_POST['amount']=$donationData->$col;

            if(isset($_POST['amount']))
            {
                if($_POST['amount']=='')
                {
                    $response['message']='Enter Amount';
                    goto end;
                }
                if(!preg_match("/^\d+$/",$_POST['amount']))
                {
                    $response['message']='Enter only digits';
                    goto end;
                }

                if(strlen($_POST['amount'])!=strlen(abs($_POST['amount'])))
                {
                    $response['message']='Enter valid amount';
                    goto end;
                }
            }
            else
            {
                $response['message']="Amount field is required";
                goto end;
            }

            
            $netAmount=$amount+$_POST['amount'];
            if(strtolower($this->session->userdata("defaultCurrency"))=='inr' && $netAmount>$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
            {
               $response['message']='Sorry! Maximum allowed amount for checkout is INR '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
                goto end;
            }
            if(strtolower($this->session->userdata("defaultCurrency"))=='usd' && $netAmount>$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
            {
                $response['message']='Sorry! Maximum allowed amount for checkout is USD '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
                goto end;
            }
            
            if(strtolower($this->session->userdata("defaultCurrency"))=='inr')
            {
                $minAmount=$this->currencies[$this->session->userdata("defaultCurrency")]['min'];
                $maxAmount=$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
            }
            if(strtolower($this->session->userdata("defaultCurrency"))=='usd')
            {
                $minAmount=$this->currencies[$this->session->userdata("defaultCurrency")]['min'];
                $maxAmount=$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
            }

            if(trim(abs($_POST['amount']))<$minAmount)
            {
                $response['message']='Minimum amount is '.strtoupper($this->session->userdata("defaultCurrency"))." ".$minAmount;
                goto end;
            }
            if(trim(abs($_POST['amount']))>$maxAmount)
            {
                $response['message']='Maximum amount is '.strtoupper($this->session->userdata("defaultCurrency"))." ".$maxAmount;
                goto end;
            }


            $data['item']=$donationData;
            $data['type']='donation';
            $data['amount']=$_POST['amount'];

            $data['note']='';
            if($this->session->userdata("loggedIn"))
            {
                if($this->currentUser->admin==0)
                {
                    $data['note']=$this->currentUser->family_details;
                }
                else
                {
                    if($this->session->userdata('temp_checkout_user'))
                    {
                        $data['note']=$this->session->userdata('temp_checkout_user')->family_details;
                    }
                }
            }

            if(!$this->session->userdata('donationCartAshramId') || $donationData->ashram_id==$this->session->userdata('donationCartAshramId') || count($cart)==0)
            {
                $r=$this->cart_model->addItem($data,2,$this->donationscart);
                $flag=$r['flag'];
                if($flag==-2)
                {
                    $this->logaction->log($this->service,"Donation added to cart _ Donation ID:".$id." _ ".$donationData->donation_name." _ Row ID: ".$r['rowid']);
                    $this->cart_log_model->log("App: Item added - Name:".$donationData->donation_name.", Amount:".strtoupper($this->session->userdata("defaultCurrency"))." ".$data['amount'],$this->session->userdata("donationCartAshramId"),2);
                    $this->session->set_userdata('donationCartAshramId',$donationData->ashram_id);
                    $response['status']=true;
                }
                else
                {
                    $response['message']="Invalid message";
                }
            }
            else
            {
                $this->load->model('ashrams/ashrams_model');
                $ashramData=$this->ashrams_model->ashramData($this->session->userdata('donationCartAshramId'));
                $response['message']="You can add donations from ".$ashramData->name." only. If you want to add items from other ashram, delete the items and then add again.";
            }
        }

        $this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /donations/update_family_details/:row_id Update family details
    * @apiPermission User
    * @apiName Update family details
    * @apiGroup Donations
    * @apiParam [String] family_details Family Details<br>
                                        Minlength:6<br>
                                        Maxlength:500
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
        {
            "status": "true"
        }
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    **/

    public function update_family_details_post($key='')
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        if($GLOBALS['donationCartLocked']==1)
        {
            $response['message']="Sorry, cannot add item, a transaction is already in progress";
            goto end;
        }

        if($key=='')
        {
            $response['message']="Invalid Row ID";
            goto end;
        }
        $item=$this->donationscart->get_item($key);
        $options=$this->donationscart->product_options($key);
        if(empty($options))
        {
            $response['message']="Invalid Row ID";
            goto end;
        }

        if(!isset($_POST['value']))
        {
            $response['message']="Family Details field is required";
            goto end;
        }

        $this->form_validation->set_rules('value', 'Family Details', 'trim|min_length[6]|max_length[500]');
        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }
        
        $options['note']=$_POST['value'];
        $updateArray= array(
                   'rowid' => $key,
                       'options'   => $options
                    );

        foreach ($options as $key => $val)
        {
            $temp[$key] = $val;
        }
        $this->cart_log_model->log("App: Family details updated - Name:".$item['name'],$this->session->userdata("donationCartAshramId"),2);
        $this->donationscart->update($updateArray);
        $this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());
        $response['status']=true;

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }


    /**
    * @api {post} /donations/dates_validate/:row_id Validate and save dates
    * @apiPermission User
    * @apiName Validate Dates
    * @apiGroup Donations
    * @apiParam {String} selected_dates User selected dates comma separated in format dd MMM YYYY 
    * @apiParam {Boolean} [save] If this is passed, dates are saved to cart else only returns valid dates  
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
        {
            "status": "true",
            "dates": [
                "09 Apr 2017 (Sunday)",
                "10 Apr 2017 (Monday)"
              ]
        }
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    * @apiSuccess {Array} dates Array of resulting dates
    **/

    public function dates_validate_post($key='')
    {
        $row_id=$key;
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        if($GLOBALS['donationCartLocked']==1)
        {
            $response['message']="Sorry, cannot add item, a transaction is already in progress";
            goto end;
        }

        if($row_id=='')
        {
            $response['message']="Invalid Row ID";
            goto end;
        }

        $item_data=$this->donationscart->get_item($row_id);
        if(empty($item_data))
        {
            $response['message']="Invalid Row ID";
            goto end;
        }

        if(!isset($_POST['selected_dates']))
        {
            $response['message']="Selected dates field required";
            goto end;
        }

        if($_POST['selected_dates']=='')
        {
            $response['message']="Selected dates field is empty";
            goto end;
        }

        $donationData=$this->donations_model->donationData($item_data['id']);
        if(!empty($donationData) && $donationData->status==1)
        {
            $final=array();
            if($_POST['selected_dates']!='')
                $selected=explode(",",$_POST['selected_dates']);
            else
                $selected=array();
            
            $startDate=date("d M Y 00:00:00");
            $endDate=date("d M Y 23:59:00",strtotime("+5 Months"));

            $startTime=strtotime($startDate);
            $endTime=strtotime($endDate);
            if(!empty($selected))
            {
                foreach($selected as $selectedDate)
                {
                    $tempTime=strtotime($selectedDate);
                    if($startTime<=$tempTime && $tempTime<=$endTime)
                    {
                        $final[]=$selectedDate;
                    }
                }
            }
            
            foreach($final as $key=>$tms)
            {
                $final[$key]=strtotime($tms);
            }
            
            asort($final);
            
            $store_array=array();
            
            $cnt=0;
            $first='';
            
            
            foreach($final as $key=>$tms)
            {
                if($cnt==0)
                $first=date("d M Y",$tms);
                
                $final[$key]=date("d M Y (D)",$tms);
                $store_array[]=date("d M Y",$tms);
                $cnt++;
            }
            
            if(isset($_POST['save']) && $_POST['save']==1)
            {
                $options=$item_data['options'];
                $options['result_date']=implode(",",$store_array);
                $options['user_date']=$first;
                $upd= array(
                         'rowid' => $row_id,
                         'options'   => $options,
                         'qty'=>$cnt
                         );

                $this->donationscart->update($upd);
                $this->cart_log_model->log("App: Dates changed - Name:".$donationData->donation_name,$this->session->userdata("donationCartAshramId"),2);
                $this->cart_model->validateCart($this->donationscart);
                $this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());
            }
            $response['status']=true;
            $response['dates']=$final;
        }

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /donations/remove_from_cart/:row_id Remove donation from cart
    * @apiPermission User
    * @apiName Remove from cart
    * @apiGroup Donations
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
        {
            "status": "true",
            "cart_count": 1
        }
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    * @apiSuccess {Integer} cart_count Number of items remaining in cart. Set only if status is true
    **/

    public function remove_from_cart_post($key='')
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        if($GLOBALS['donationCartLocked']==1)
        {
            $response['message']="Cannot remove item, a transaction is already in progress";
            goto end;
        }
        if(isset($key) && $key!='')
        {
            $item=$this->donationscart->get_item($key);
            if(!empty($item))
            {
                $upd= array(
                           'rowid' => $key,
                            'qty'   => 0
                            );
                $this->donationscart->update($upd);
                $this->logaction->log($this->service,"Donation removed from cart _ Donation ID:".$item['id']." _ ".$item['name']." _ Row ID: ".$key);
                $this->cart_log_model->log("App: Item removed - Name:".$item['name'],$this->session->userdata("donationCartAshramId"),2);
                $cc=$this->donationscart->contents();
                if(count($cc)==0)
                {
                    $this->session->unset_userdata('donationCartAshramId');
                }
                $response['status']=true;
                $response['cart_count']=count($cc);
                $this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());
            }
            else
            {
                $response['message']="Invalid request";
            }
        }
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /donations/get_cart Donations cart
    * @apiPermission User
    * @apiName Cart
    * @apiGroup Donations
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
        {
            "7cbb43d3185e4e822ba1ecbc35612b22":
            {
                "id": "430",
                "qty": 1,
                "price": 10,
                "name": "Some Donation",
                "options": {
                    "checksum": "060c341cb3c23793ffca39a249494fe2",
                    "type": "donation",
                    "note": "First name\r\nGothram\r\nNakshatram",
                    "ashram_id": "4",
                    "description": "Some Donation",
                    "first_date": "10 Apr 2017",
                    "user_date": "10 Apr 2017",
                    "status": 1,
                    "result_date": "31 Mar 2017",
                    "price_inr": "1116",
                    "price_suggested_inr": "100000",
                    "price_usd": "2001",
                    "price_suggested_usd": "2001",
                },
                "rowid": "7cbb43d3185e4e822ba1ecbc35612b22",
                "subtotal": 10
            }
        }
    *
    * @apiSuccess {Object} row_id Cart item object, row id will be the key
    * @apiSuccess {Integer} row_id.id Unique identifier of Donation
    * @apiSuccess {Integer} row_id.qty Quantity
    * @apiSuccess {Integer} row_id.price Price (IGNORE)
    * @apiSuccess {String} row_id.name Donation name
    * @apiSuccess {Object} row_id.options Donation item options object
    * @apiSuccess {String} row_id.options.checksum Checksum value for current cart item
    * @apiSuccess {String} row_id.options.type=donation Item type
    * @apiSuccess {String} row_id.options.note Family details
    * @apiSuccess {String} row_id.options.ashram_id Unique identifier of Ashram to which donation belong
    * @apiSuccess {String} row_id.options.description Description of donation
    * @apiSuccess {String} row_id.options.first_date First occurance date of current donation in format dd MMM YYYY
    * @apiSuccess {String} row_id.options.user_date First occurance date of current donation in format dd MMM YYYY based on user selection
    * @apiSuccess {String} row_id.options.status Status of donation in cart (To checkout, all items must have status=1)
    * @apiSuccess {String} row_id.options.result_date List of result dates separated with comma
    * @apiSuccess {String} row_id.options.price_inr Price in INR
    * @apiSuccess {String} row_id.options.price_suggested_inr Suggested price in INR
    * @apiSuccess {String} row_id.options.price_usd Price in USD
    * @apiSuccess {String} row_id.options.price_suggested_usd Suggested price in USD
    * @apiSuccess {String} row_id.rowid Row id of item in cart
    * @apiSuccess {String} row_id.subtotal Subtotal of items (IGNORE)
    **/
    public function get_cart_post()
    {
        $list['currency']=strtoupper($this->session->userdata("defaultCurrency"));
        $this->load->model("credit_cards_model");
        $trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($this->session->userdata("donationCartAshramId"),2);
        $trustsArray=array();
        foreach ($trusts as $trustData)
        {
            $trustsArray[$trustData->currency]=$trustData;
        }
        if($this->session->userdata("defaultCurrency")=='inr' && !empty($trustsArray))
        {
            $list['trust_data']=$trustsArray['inr'];
        }
        if($this->session->userdata("defaultCurrency")=='usd' && !empty($trustsArray))
        {
            $list['trust_data']=$trustsArray['usd'];
        }
        $credit_cards=$this->credit_cards_model->getCards($this->currentUser->id);
        foreach ($credit_cards as $key => $credit_card)
        {
            unset($credit_cards[$key]->user_id);
            unset($credit_cards[$key]->payflow_pnref);
            unset($credit_cards[$key]->created_on);
            unset($credit_cards[$key]->modified_on);
            $credit_cards[$key]->card_expiry_month=substr($credit_cards[$key]->card_expiry,0,2);
            $credit_cards[$key]->card_expiry_year=substr($credit_cards[$key]->card_expiry,-2);
        }
        $list['credit_cards']=$credit_cards;
        $list['ip_address']=$_SERVER["REMOTE_ADDR"];
        $list['cart']=$this->donationscart->contents();
        $this->set_response($list, REST_Controller::HTTP_OK);
    }

    public function get_cart_item_post($key='')
    {
        if($key=='')
        {
            $response['message']="Invalid Row ID";
            goto end;
        }

        $options=$this->donationscart->product_options($key);
        if(empty($options))
        {
            $response['message']="Invalid Row ID";
            goto end;
        }

        $item=$this->donationscart->get_item($key);
        $donation=$this->donations_model->donationData($item['id']);

        $response['status']=true;
        $response['item']=$item;
        $response['donation']=$donation;
        
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    public function checkout_notify_post($tab_index=null)
    {
        if($tab_index!=null && in_array($tab_index,array(0,1,2)))
        {
            $data='';
            if($tab_index==2)
            {
                $countryData=$this->locations_model->getCountryByCode($this->input->post("country"));
                $data="<br>Data:<br>".$this->input->post("firstname")." ".$this->input->post("lastname")."<br>".
                    $this->input->post("city").", ".$this->input->post("state").", ".$this->input->post("country")."<br>".
                    "+".$countryData->isd_code." ".$this->input->post("phone")."<br>".
                    $this->input->post("email");
            }
            $this->cart_log_model->log("App: Checkout - navigated to tab ".($tab_index+1).$data,$this->session->userdata("donationCartAshramId"),2);
        }
    }

    /**
    * @api {post} /donations/pay Make Payment
    * @apiPermission User
    * @apiName Pay
    * @apiGroup Donations
    * @apiParam {String=a-z,A-Z,spaces} firstname First Name<br>
    *                             Minlength\:2<br>
    *                             Maxlength\:50
    * @apiParam {String=a-z,A-Z,spaces} lastname Last Name<br>
    *                             Minlength\:2<br>
    *                             Maxlength\:50
    * @apiParam email Email ID<br>
    *                             Minlength\:6<br>
    *                             Maxlength\:100
    * @apiParam phone Phone Number<br>
    *                             Minlength\:10<br>
    *                             Maxlength\:10<br>
     *                            Digits only
    * @apiParam {String='[a-z]','[A-Z]','[0-9]','[.-_@/]','spaces'} address1 Address line 1<br>
    *                             Minlength\:3<br>
    *                             Maxlength\:50
    * @apiParam {String='[a-z]','[A-Z]','[0-9]','[.-_@/]','spaces'} address2 Address line 2<br>
    *                             Minlength\:3<br>
    *                             Maxlength\:50
    * @apiParam {String='[a-z]','[A-Z]','[0-9]','[.-_@/]','spaces'} address3 Address line 3<br>
    *                             Minlength\:3<br>
    *                             Maxlength\:50
    * @apiParam {String='[a-z]','[A-Z]','[0-9]','[.-_@/]','spaces'} state State Name<br>
    *                             Minlength\:2<br>
    *                             Maxlength\:100
    * @apiParam {String='[a-z]','[A-Z]','[0-9]','[.-_@/]','spaces'} city City<br>
    *                             Minlength\:2<br>
    *                             Maxlength\:100
    * @apiParam {String='[a-z]','[A-Z]','[0-9]'} zipcode ZIP/PIN Code<br>
                                    Minlength\:3<br>
    *                               Maxlength\:15
    * @apiParam {String} country Country Code
    * @apiParam {String} donation_initials Donation Initials<br>
                                    Minlength\:3<br>
    *                               Maxlength\:25
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
        {
            "status":true,
            "payment_status": 1,
            "order_id":100
        }
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    * @apiSuccess {Integer} payment_status 1 if success otherwise 0 (Set only for USD/Paypal)
    * @apiSuccess {Integer} order_id Seva ID (Set only for USD/Paypal)
    * @apiSuccess {Integer} payment_status 1 if success otherwise 0 (Set only for USD/Paypal)
    * @apiSuccess {String} redirect_to URL to redirect to (Set only for INR/PayU)
    * @apiSuccess {Integer} time_exceed 1 Sets only when transaction is already in process and initiated more than 5 minutes ago 
    *
    */
    public function pay_post()
    {
        //Check site settings
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        if($GLOBALS['site_settings']['enable_orders']==0)
        {
            $response['message']='Sevas are disabled.';
            goto end;
        }

        if($this->session->userdata("loggedIn") && $this->currentUser->admin==0)
        {
            if($this->currentUser->email_verified==0)
            {
                $response['message']='Email ID not verified.';
                goto end;
            }  
        }

        //Get cart DB record
        if($GLOBALS['donationCartLocked']==1)
        {
            $startedOn=strtotime($GLOBALS['donationCartStartedOn']." +5 Minutes");
            if(time()>=$startedOn)
            {
                $response['time_exceed']=1;
            }
            $response['message']='Transaction already in progress.';
            goto end;
        }

        //Validate form data
        if(!isset($_POST["firstname"]) || !isset($_POST["lastname"]) ||
                !isset($_POST["preferred_name"]) ||
                !isset($_POST["email"]) || !isset($_POST["phone"]) ||
                !isset($_POST["address1"]) || !isset($_POST["address2"]) || !isset($_POST["address3"]) ||
                !isset($_POST["city"]) || !isset($_POST["state"]) || !isset($_POST["country"]) ||
                !isset($_POST["donation_initials"]))
        {
            $response['message']='Some parameters are missing.';
            goto end;
        }

        if($this->session->userdata("defaultCurrency")=='usd')
        {
            if(!isset($_POST["credit_card_id"]))
            {
                $response['message']='Some parameters are missing.';
                goto end;
            }
        }

        $this->form_validation->set_rules('firstname', 'First Name','trim|required|min_length[2]|max_length[50]|lettersonly');
        $this->form_validation->set_rules('lastname', 'Last Name','trim|required|min_length[2]|max_length[50]|lettersonly');
        $this->form_validation->set_rules('preferred_name', 'Preferred Name','trim|required|min_length[2]|max_length[50]');
        $this->form_validation->set_rules('email', 'Email ID','trim|required|valid_email_custom|min_length[6]|max_length[100]');
        $this->form_validation->set_rules('phone', 'Phone Number','trim|required|numeric|min_length[8]|max_length[15]');
        //$this->form_validation->set_rules('phone2', 'Phone Number 2','trim|min_length[10]|max_length[100]');
        $this->form_validation->set_rules('address1', 'Address Line 1','trim|required|min_length[3]|max_length[100]');
        $this->form_validation->set_rules('address2', 'Address Line 2','trim|min_length[3]|max_length[100]');
        $this->form_validation->set_rules('address3', 'Address Line 3','trim|min_length[3]|max_length[100]');
        $this->form_validation->set_rules('city', 'City','trim|required|min_length[2]|max_length[100]|name_validate13');
        $this->form_validation->set_rules('state', 'State','trim|required|min_length[2]|max_length[100]|name_validate13');
        $this->form_validation->set_rules('country', 'Country','trim|required|checkoutCountry['.$this->session->userdata("defaultCurrency").']');
        $this->form_validation->set_rules('zipcode', 'ZIP Code','trim|required|alphabetsnumbers|min_length[3]|max_length[15]');
        $this->form_validation->set_rules('donation_initials', 'Initials','trim|required|min_length[3]|max_length[25]');

        if($this->session->userdata("defaultCurrency")=='usd')
        {
            if($_POST["credit_card_id"]=='')
            {
                $this->form_validation->set_rules('card_number', 'Card Number','trim|required|min_length[15]|max_length[19]');
                $this->form_validation->set_rules('card_name', 'Card Name','trim|required|min_length[2]|max_length[100]');
                $this->form_validation->set_rules('card_expiry', 'Expiry Date','trim|required|cardExpiry');
                $this->form_validation->set_rules('card_cvv', 'CVV Number','trim|required|numeric|min_length[3]|max_length[4]');
            }
            else
            {
                $this->form_validation->set_rules('credit_card_id', 'Save Card ID','trim|required|numeric|max_length[20]');
            }
        }

        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }

        //Validate Cart items
        $this->cart_model->validateCart($this->donationscart);

        //Check cart items count
        $cartContents=$this->donationscart->contents();
        if(empty($cartContents)) //If cart is empty
        {
            //$response['flag']=2;
            $response['message']='Cart is empty';
            goto end;
        }

        $totalItems=count($cartContents);
        $validItems=0;
        foreach ($cartContents as $cartItem)
        {
            if($cartItem['options']['status']==1)
            {
                $validItems++;
            }
        }

        //Check all items in cart are valid
        if($validItems!=$totalItems)
        {
            //$response['flag']=4;
            $response['message']='Some cart items are not valid.';
            goto end;
        }

        //Capture User ID
        $userId=0;

        if($this->session->userdata("loggedIn"))
        {
            if($this->currentUser->admin==1)
            {
                if($this->session->userdata('temp_checkout_user'))
                {
                    $tData=$this->session->userdata('temp_checkout_user');
                    $userId=$tData->id;
                }
            }
            else
            {
                $userId=$this->currentUser->id;
            }
        }

        //Get trust accounts for Ashram and Currency defined
        $trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($this->session->userdata("donationCartAshramId"),2);
        $trustsArray=array();
        foreach ($trusts as $trustData)
        {
            $trustsArray[$trustData->currency]=$trustData;
        }

        $amount=$this->cart_model->getTotalPrice($this->donationscart);

        //Decide trust based on Currency
        if($this->session->userdata("defaultCurrency")=='inr')
        {
            $customData['trustData']=$trustsArray['inr'];
            if($amount>$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
            {
                $response['error_msg']='Sorry! Maximum allowed amount for checkout is INR '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
                goto end;
            }
        }
        if($this->session->userdata("defaultCurrency")=='usd')
        {
            $customData['trustData']=$trustsArray['usd'];
            if($amount>$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
            {
                $response['error_msg']='Sorry! Maximum allowed amount for checkout is USD '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
                goto end;
            }
        }

        $this->load->model('ashrams/ashrams_model');


        //Define custom data before initializing transaction
        $created_by_user_id=0;
        $created_by=0;
        $userData=array();
        if($this->session->userdata('id'))
        {
            if($this->session->userdata('temp_checkout_user'))
            {
                $userData=$this->session->userdata('temp_checkout_user');
                $userId=$userData->id;
            }
            $created_by=1;
        }
        else if($this->session->userdata('user_id'))
        {
            $userId=$this->session->userdata('user_id');
            $userData=$this->currentUser;
            $created_by=2;
        }

        if($this->session->userdata("defaultCurrency")=='usd')
        {
            $creditCardData=array();
            if($_POST["credit_card_id"]!='')
            {
                $this->load->model("credit_cards_model");
                $creditCardData=$this->credit_cards_model->getCard($_POST['credit_card_id']);
                if(empty($creditCardData))
                {
                    goto end;
                }
                if($creditCardData->user_id!=$userId)
                {
                    goto end;
                }
            }
        }

        $this->cart_log_model->log("App: Payment initiated",$this->session->userdata("donationCartAshramId"),2);

        $paymentMode=$customData['trustData']->payment_mode;

        if($this->session->userdata('loggedIn'))
            $created_by_user_id=$this->currentUser->id;

        $customData['cartData']=$cartContents;
        $customData['formData']=$_POST;
        $customData['formData']['app']=1;
        $customData['ashramData']=$this->ashrams_model->ashramData($this->session->userdata("donationCartAshramId"));
        $customData['cart_type']=2;
        $customData['paymentMode']=$paymentMode;
        $customData['created_by']=$created_by;
        $customData['created_by_user_id']=$created_by_user_id;
        $customData['model']="orders/orders_model";
        $customData['model_name']="orders_model";
        $customData['ip_address']=$_SERVER['REMOTE_ADDR'];
        
        $customData['amount_in_words']=$this->general_model->amountToWords($amount);
        //Load payment model
        $this->load->model("payment_model");
        $reference=$this->payment_model->setTempInfo(
            $userId,
            $userData,
            $amount,
            base_url."donations/",
            base_url."donations/checkout/",
            $customData,
            $this->session->userdata("defaultCurrency")
            );
        //$response['flag']=1;
        $response['status']=true;
        $response['reference']=$reference;
        $this->cart_model->updateReferenceId($reference,2);

        $response['payment_mode']=$paymentMode;
        if($this->session->userdata("defaultCurrency")=='usd')
        {
            $response['currency']="USD";
            if($paymentMode=='paypal')
            {
                $this->load->model("paypal_model");
                $paypalResponse=$this->paypal_model->processOneTimePayment($reference,$creditCardData);
                if($paypalResponse['flag']==1)
                {
                    $response['order_id']=$paypalResponse['order_id'];
                    $response['payment_status']=1;
                    $this->cart_log_model->log("App: Payment success:".$paymentMode,$this->session->userdata("donationCartAshramId"),2);
                }
                else
                {
                    $response['payment_status']=0;
                    $response['message']=$paypalResponse['error_msg'];
                    $this->cart_model->updateReferenceId('',2);
                    $this->cart_log_model->log("App: Payment failure:".$paymentMode.", Reason:".$paypalResponse['error_msg'],$this->session->userdata("donationCartAshramId"),2);
                }
            }
            else
            {
                $response['amount']=$amount*100;
                $response['currency']="USD";
                $response['prefill_name']=$this->input->post("firstname")." ".$this->input->post("lastname");
                $response['prefill_email']=$this->input->post("email");
                $response['prefill_contact']=$this->input->post("phone");
            }
        }
        else
        {
            $response['currency']="INR";
            if($paymentMode=='payu')
            {
                $response['redirect_to']=base_url.'payment/direct/'.$reference."?app=1&type=2";
                $this->cart_log_model->log("App: Redirected to payment gateway:".$paymentMode,$this->session->userdata("donationCartAshramId"),2);
            }
            if($paymentMode=='razorpay')
            {
                $response['amount']=$amount*100;
                $response['prefill_name']=$this->input->post("firstname")." ".$this->input->post("lastname");
                $response['prefill_email']=$this->input->post("email");
                $response['prefill_contact']=$this->input->post("phone");
                $response['key']=$customData['trustData']->razorpay_key;
            }
        }


        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /donations/cancel_previous Cancel previous transaction
    * @apiPermission User
    * @apiName Cancel transaction
    * @apiGroup Donations
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
        {
            "status":true
        }
    *
    * @apiSuccess {Boolean} status true if success otherwise false
    *
    */
   
    public function cancel_previous_post()
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        if($GLOBALS['donationCartLocked']==1)
        {
            $startedOn=strtotime($GLOBALS['donationCartStartedOn']." +5 Minutes");
            if(time()>=$startedOn)
            {
                $this->cart_model->regenerateSession(2);
                $this->oauth_sessions_model->update_session_id($this->server->access_token,session_id());
                $this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());
                $response['status']=true;
            }
        }

        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }
}
?>