<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}

//use Restserver\Libraries\REST_Controller;
class Contact extends REST_Controller {
    private $error=0;
    var $access_token_present=0;
    var $service="contact";
    var $purposeArray=array(
                                1=>"Office/Billing",
                                2=>"Contact",
                                3=>"Abuse",
                                4=>"Complaint",
                                5=>"Question",
                                6=>"Feedback",
                                7=>"Other"
                                );
    function __construct()
    {
        parent::__construct();
    }

    /**
    * @api {post} /contact Post a Contact
    * @apiPermission Logged in User
    * @apiName Contact
    * @apiGroup Contact
    
    * @apiParam {String} name Name<br>
    *                             Minlength\:3<br>
    *                             Maxlength\:100
    * @apiParam {String} email Email ID<br>
    *                             Minlength\:6<br>
    *                             Maxlength\:200
    * @apiParam {String} message Message<br>
    *                             Minlength\:1<br>
    *                             Maxlength\:1000
    * @apiParam {String='Personal Request','Abuse','Complaint','Others'} purpose Purpose
    * @apiParam {String} phone Phone number<br>
    *                             Minlength\:5<br>
    *                             Maxlength\:100
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   {
            "status": true
        }
    *
    * @apiSuccess {boolean} status True if success otherwise false
    */
   
    public function index_post()
    {
        /*$this->load->library("server");
        $this->server->require_scope("user");
        $this->load->model('oauth_sessions_model');
        $this->oauth_sessions_model->session_check();

        if($this->session->userdata('id'))
            $this->currentUser=$this->session->userdata("admin_data");
        else
            $this->currentUser=$this->session->userdata("user_data");*/

        $this->load->library("server");
        $a=OAuth2\Request::createFromGlobals();
        $headers=$a->headers('AUTHORIZATION');
        if(preg_match('/Bearer\s(\S+)/i', $headers, $matches))
        {
            $this->server->require_scope("user");
            $this->load->model('oauth_sessions_model');
            $this->oauth_sessions_model->session_check();

            if($this->session->userdata('id'))
                $this->currentUser=$this->session->userdata("admin_data");
            else
                $this->currentUser=$this->session->userdata("user_data");

            $this->access_token_present=1;
        }
        else
        {
            $this->session->unset_userdata("loggedIn");
            $this->session->unset_userdata("id");
            $this->session->unset_userdata("user_id");
            $this->session->unset_userdata("user_data");
        }

        //=====================================================================
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        
        if(!isset($_POST["phone"]))
        {
            $response['message']="Phone field is required";
            goto end;
        }

        if($this->access_token_present==0)
        {
            $this->form_validation->set_rules('name', 'Name', 'trim|required|min_length[3]|max_length[100]');
            $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|min_length[6]|max_length[200]');
        }
        $this->form_validation->set_rules('message', 'Message', 'trim|required|max_length[1000]');
        $this->form_validation->set_rules('purpose', 'Purpose', 'trim|required|contactPurpose');
        $this->form_validation->set_rules('phone', 'Phone', 'trim|noSpaces|min_length[5]|max_length[100]');
        $this->form_validation->set_rules('c_country_code', 'Country code', 'trim|required|countryCheck');

        if ($this->form_validation->run() == FALSE)
        {
            $response['error']=validation_errors();
            goto end;
        }
        if($this->session->userdata('user_id'))
        {
            $uid=$this->session->userdata('user_id');
            $uData=$this->session->userdata("user_data");
            $name=$uData->firstname." ".$uData->lastname;
            $email=$uData->email;
        }
        else
        {
            $uid=0;
            $name=$_POST['name'];
            $email=$_POST['email'];
        }
        $countryData=$this->locations_model->getCountryByCode($this->input->post("c_country_code"));

        $this->load->model("email_extension_model");
        $settings=$this->email_extension_model->getSettingsByService('contact');
        $config['protocol']="smtp";
        $config['mailtype'] = 'html';
        $config['smtp_host'] = $settings->smtp_host;
        $config['smtp_user'] = $settings->smtp_user;
        $config['smtp_pass'] =  $settings->smtp_password;
        $this->email->initialize($config);
        $this->email->from($settings->from_email.email_domain, $settings->from_name);
        $this->email->to(contact_admin_email);
        $this->email->bcc(contact_admin_email_cc);
        $this->email->subject(short_ashram_name." - New Contact message - ".$name);
        $tempdata['name']=$name;
        $tempdata['email']=$email;
        $tempdata['phone']="+".$countryData->isd_code." ".$this->input->post("phone");
        $tempdata['purpose']=$_POST['purpose'];
        $tempdata['content']=$_POST['message'];
        $tempdata['app']=1;
        $content=$this->load->view("common/public/_contact_email",$tempdata,true);

        $viewData['name']="Admin";
        $viewData['body']=$content;
        $viewData['signature']=nl2br($settings->signature);
        $viewData['ashram_name']=default_ashram_name;
        $content=$this->load->view("common/templates/email_template",$viewData,true);

        $this->email->message($content);
        $this->email->send(false);

        $response['status']=true;
        
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }
}
?>