<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}

//use Restserver\Libraries\REST_Controller;
class Categories extends REST_Controller
{
    public $newcats=array();
    function __construct()
    {
        parent::__construct();
        $this->load->library("server");
        $this->server->require_scope("user");
        $this->currentUser=$this->users_model->userDataByEmailorUsername($this->server->access_token_data['user_id']);
        
        /*$this->load->model('oauth_sessions_model');
        $this->oauth_sessions_model->session_check();

        if($this->session->userdata('id'))
            $this->currentUser=$this->session->userdata("admin_data");
        else
            $this->currentUser=$this->session->userdata("user_data");*/
    }

    /**
    * @api {post} /categories List of Categories
    * @apiPermission User
    * @apiName Categories
    * @apiGroup Categories
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   [
            {
                "id": "4",
                "category": "Category 1",
                "parent":0
            },
            {
                "id": "10",
                "category": "Category 2",
                "parent":1
            }
        ]
    */
    public function index_post()
    {
        $this->load->model('category/categories_model');
        $this->categories_model->fetchCategories();
        $this->catform(0,1);
        $categories=$this->newcats;
        $result=array();
        $c=0;
        foreach($categories as $category)
        {
            $result[$c]['id']=$category->id;
            $result[$c]['category']=$category->category;
            $result[$c]['parent']=$category->parent;
            $c++;
        }
        $this->response($result, REST_Controller::HTTP_OK);
    }

    private function catform($parent,$level)
    {
        if (isset($this->categories_model->categoriesList['parent_cats'][$parent]))
        {
            foreach ($this->categories_model->categoriesList['parent_cats'][$parent] as $cat_id)
            {
                $tempcat=$this->categories_model->categoriesList['categories'][$cat_id];
                $tempcat->category=str_repeat("- ",$level-1).$tempcat->category;
                $this->newcats[]=$tempcat;
                if (isset($this->categories_model->categoriesList['parent_cats'][$cat_id])) 
                {
                    $nl=$level+1;
                    $this->catform($cat_id,$nl);
                }
            }
        }
    }
}
?>