<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}

//use Restserver\Libraries\REST_Controller;
class Calendar extends REST_Controller {

    function __construct()
    {
        parent::__construct();
        $this->load->library("server");
        $this->server->require_scope("user");
    }

    /**
    * @api {post} /calendar Get Calendar
    * @apiName Calendar list
    * @apiGroup Calendar
    * @apiPermission Logged in User
    *
    * @apiParam {String} [search_text] Searches speeches
    * @apiParam {Integer} [year]  Year
    * @apiParam {Integer} [month]  Month (Valid only if year is set)
    * @apiParam {Integer=1,2,3} [calendar]  Calendar Type (1-Swamiji Calendar, 2-Bala Swamiji Calendar, 3- DattaPeetham Calendar)
    *
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *     {
              "num": "100",
              "res": [
                {
                    "start_date": "01 Jan 2016",
                    "end_date": "02 Jan 2016",
                    "event_name": "Programs in Bengaluru Ashrama & Vagdevi school function",
                    "swamiji": "0",
                    "balaswamiji": "1",
                    "dattapeetham": "0",
                    "description": "<p>Sri Datta Vijayananda Teertha Swamiji in SGS Ashrama, Bengaluru</p>",
                    "start_day": "Friday",
                    "end_day": "Saturday"
                }
        }
    *
    * @apiSuccess {Integer} num  Total number of results
    * @apiSuccess {Object} res Speech Object
    * @apiSuccess {Date} res.start_date Start Date in format dd MMM YYYY
    * @apiSuccess {Date} res.end_date End Date in format dd MMM YYYY
    * @apiSuccess {String} res.event_name Name
    * @apiSuccess {Integer} res.swamiji Swamiji Calendar flag (0-No, 1-Yes)
    * @apiSuccess {Integer} res.balaswamiji Bala Swamiji Calendar flag (0-No, 1-Yes)
    * @apiSuccess {Integer} res.dattapeetham Dattapeetham Calendar flag (0-No, 1-Yes)
    * @apiSuccess {String} res.description Description
    * @apiSuccess {String} res.start_day Day of the start date
    * @apiSuccess {String} res.end_day Day of the end date
    */

    public function index_post()
    {
        $this->load->model('content/calendar_model');
        $list=$this->calendar_model->listPublic();
        $list['res']=$list['data'];
        unset($list['data']);
        unset($list["recordsTotal"]);
        unset($list['recordsFiltered']);
        unset($list['links']);
        if ($list)
        {
            $this->response($list, REST_Controller::HTTP_OK);
        }
        else
        {
            $this->response([
                'status' => FALSE,
                'message' => 'No records were found'
            ], REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /calendar/get_years_months Get possible years and months
    * @apiPermission Logged in User
    * @apiName Years and months list
    * @apiGroup Calendar
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *     {
              "years": [
                {
                    "2016",
                    "2015"
                },
                "months": {
                    "2016":
                    [
                        "12"
                    ]
                ],
        }
    *
    * @apiSuccess {Array} years List of years
    * @apiSuccess {Object} months Months Object (Keys will be years)
    * @apiSuccess {Array} res['year'] List of months for that year
    */
   
    public function get_years_months_post()
    {
        $this->load->model('content/calendar_model');
        $years=$this->calendar_model->getYearMonths();
        if ($years)
        {
            $this->response($years, REST_Controller::HTTP_OK);
        }
        else
        {
            $this->response([
                'status' => FALSE,
                'message' => 'No speeches were found'
            ], REST_Controller::HTTP_NOT_FOUND);
        }
    }
}
?>