<?php

defined('BASEPATH') OR exit('No direct script access allowed');

// This can be removed if you use __autoload() in config.php OR use Modular Extensions
/** @noinspection PhpIncludeInspection */
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}

// use namespace
//use Restserver\Libraries\REST_Controller;

/**
 * This is an example of a few basic user interaction methods you could use
 * all done with a hardcoded array
 *
 * @category        Api
 * @author          Manoj
 * @license         MIT
 */
class Authenticate extends REST_Controller {

    function __construct()
    {
        // Construct the parent class
        parent::__construct();

        // Configure limits on our controller methods
        // Ensure you have created the 'limits' table and enabled 'limits' within application/config/rest.php
        $this->methods['users_get']['limit'] = 500; // 500 requests per hour per user/key
        $this->methods['users_post']['limit'] = 100; // 100 requests per hour per user/key
        $this->methods['users_delete']['limit'] = 50; // 50 requests per hour per user/key
        $this->load->model('subscriptions_email_model');
    }

    /**
    * @api {post} /authenticate Get access token
    * @apiName Authenticate
    * @apiGroup OAuth2
    *
    * @apiParam {String} client_id Client ID
    * @apiParam {String} client_secret  Client Secret
    * @apiParam {String} grant_type Grant type or scope. Default - 'password'
    * @apiParam {String} username  Username of logging in user
    * @apiParam {String} password  Password of logging in user
    *
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
    *   {
            "access_token": "545814da22216",
            "expires_in": 31536000,
            "token_type": "Bearer",
            "scope": 'password user',
            "refresh_token": "b6ef7d37d9c0d34e8bfaf8d0"
        }
    *
    * @apiSuccess {String} access_token  Access token
    * @apiSuccess {Integer} expired_in Expires in time (in seconds)
    * @apiSuccess {String} token_type Default 'Bearer' 
    * @apiSuccess {String} scope Default 'password user'
    * @apiSuccess {String} refresh_token Token used to get new token
    **/

    public function index_post()
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        $this->form_validation->set_rules('username', 'Username', 'required');
        $this->form_validation->set_rules('password', 'Password', 'required');
        $this->form_validation->set_rules('client_id', 'Client ID', 'required');
        $this->form_validation->set_rules('client_secret', 'Client Secret', 'required');
        $this->form_validation->set_rules('grant_type', 'Grant Type', 'required');
        $this->form_validation->set_rules('scope', 'Scope', 'required');

        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }
        $this->load->library("server");
        $response=json_decode($this->server->password_credentials());
        if(!isset($response->error))
        {
            $response->token_id=session_id();
            //Loggedin
            $this->load->model('login_validate');
            $this->load->model('user/users_model');
            $userData=$this->users_model->userDataByEmailorUsername($this->input->post("username"));
            $this->login_validate->loggedInTrack($userData,1);
        }
        end:
        
        if(is_array($response) && $response['status']==false)
        {
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
        else
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
    }

    /**
    * @api {post} /authenticate/refresh Refresh an access token
    * @apiName Refresh
    * @apiGroup OAuth2
    *
    * @apiParam {String} client_id Client ID
    * @apiParam {String} client_secret  Client Secret
    * @apiParam {String} grant_type Grant type - 'refresh_token'
    * @apiParam {String} refresh_token  Refresh token
    *
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
    *   {
            "access_token": "545814da22216",
            "expires_in": 31536000,
            "token_type": "Bearer",
            "scope": 'password user',
            "refresh_token": "b6ef7d37d9c0d34e8bfaf8d0"
        }
    *
    * @apiSuccess {String} access_token  Access token
    * @apiSuccess {Integer} expired_in Expires in time (in seconds)
    * @apiSuccess {String} token_type Default 'Bearer' 
    * @apiSuccess {String} scope Default 'password user'
    * @apiSuccess {String} refresh_token Token used to get new token
    */
   
    public function refresh_post()
    {
        $this->load->library("server");
        $this->server->refresh_token();
    }

    /**
    * @api {post} /authenticate/register Register a new User
    * @apiName Register
    * @apiGroup OAuth2
    *
    * @apiParam {String=a-z,0-9} username User ID<br>
    *                             Minlength\:6<br>
    *                             Maxlength\:60
    * @apiParam {String} password Password<br>
    *                             Minlength\:5<br>
    *                             Maxlength\:50
    * @apiParam {String} rpassword Retype Password
    * @apiParam {String} email Email ID<br>
    *                             Minlength\:6<br>
    *                             Maxlength\:100
    * @apiParam {String=a-z,A-Z,spaces} firstname First Name<br>
    *                             Minlength\:2<br>
    *                             Maxlength\:50
    * @apiParam {String=a-z,A-Z,spaces} middlename Middle Name<br>
     *                                             Minlength\:0<br>
     *                                             Maxlength\:50
    * @apiParam {String=a-z,A-Z,spaces} lastname Last Name<br>
    *                             Minlength\:2<br>
    *                             Maxlength\:50
    * @apiParam {String} dob Date of Birth in format dd MMM YYYY
    * @apiParam {String=Male,Female} gender Gender
    * @apiParam {boolean} tnc Terms and Conditions accepted
    *
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
    *   {
            "status":true
        }
    *
    * @apiSuccess {Boolean} status Status of action
    */
    public function register_post()
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();
        if(!isset($_POST["middlename"]) || !isset($_POST["phone"]) || !isset($_POST["country"]) || !isset($_POST["zip"]))
        {
            $response['message']="Middle Name field is required";
            goto end;
        }

        $this->form_validation->set_rules('firstname', 'First Name', 'trim|required|min_length[2]|max_length[50]|lettersonly');
        $this->form_validation->set_rules('middlename', 'Middle Name', 'trim|max_length[50]|lettersonly');
        $this->form_validation->set_rules('lastname', 'Last Name', 'trim|required|min_length[2]|max_length[50]|lettersonly');
        $this->form_validation->set_rules('email', 'Email ID', 'trim|required|min_length[6]|max_length[100]|valid_email_custom|emailCheck[0]|emailBounceCheck');
        $this->form_validation->set_rules('username', 'User ID', 'trim|required|min_length[6]|max_length[60]|alphabetsnumbers2|usernameCheck');
        $this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[5]|max_length[50]');
        $this->form_validation->set_rules('rpassword', 'Retype Password', 'trim|required|matches[password]');
        $this->form_validation->set_rules('phone', 'Phone Number', 'trim|numeric|min_length[8]|max_length[15]|noSpaces');
        $this->form_validation->set_rules('country', 'Country', 'trim|countryCheck');
        $this->form_validation->set_rules('zip', 'ZIP Code', 'trim|alphabetsnumbers|min_length[3]|max_length[15]');
        $this->form_validation->set_rules('tnc', 'Terms and Conditions', 'required');

        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }

        $this->load->library('userutil');
        
        $data=$this->userutil->register($_POST);
        
        if($data['flag']==1)
        {
            $response['status']=true;
        }

        end:
        if($response['status']==true)
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    /**
    * @api {post} /authenticate/forgot_password Forgot Password
    * @apiName Forgot Password
    * @apiGroup OAuth2
    *
    * @apiParam {String} username_email User ID or Email ID<br>
    *                             Minlength\:6<br>
    *                             Maxlength\:100
    *
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
    *   {
            "status":true,
            "username": "datta",
            "questions": [
                {
                    "id": 1,
                    "question": "What was your childhood nickname?"
                },
                {
                    "id": 2,
                    "question": "In what city or town was your first job?"
                }
            ]
        }
    *
    * @apiSuccess {Boolean} status Status of action
    * @apiSuccess {String} username User ID
    * @apiSuccess {Object} questions List of questions
    * @apiSuccess {Integer} questions.id Serial number
    * @apiSuccess {String} questions.question Question
    */
    public function forgot_password_post()
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        $this->form_validation->set_rules('username_email', 'User ID / Email ID', 'trim|required|min_length[6]|max_length[100]');
        
        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }

        $this->load->model('user/users_model');
        $userData=$this->users_model->userDataByEmailorUsername($_POST['username_email']);
        if(!empty($userData))
        {
            $questions=$this->users_model->getSecurityQuestions($userData->id);
            if(empty($questions))
            {
                $response['message']="Security questions not set. Request support.";
                goto end;
            }
            else
            {
                $response['status']=true;
                $response['username']=$userData->username;
                $response['questions'][]=array("id"=>1,"question"=>$questions[0]->question);
                $response['questions'][]=array("id"=>2,"question"=>$questions[1]->question);
                goto end;
            }
        }
        else
        {
            $response['message']="Invalid Username / Email ID";
            goto end;
        }

        end:
        if($response['status']==true)
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }
    
    /**
    * @api {post} /authenticate/security_check Security questions validate
    * @apiName security check
    * @apiGroup OAuth2
    *
    * @apiParam {String} username_email User ID or Email ID<br>
    *                             Minlength\:6<br>
    *                             Maxlength\:100
    * @apiParam {String} answer1 Answer to first question<br>
    *                             Minlength\:1<br>
    *                             Maxlength\:100
    * @apiParam {String} answer2 Answer to second question<br>
    *                             Minlength\:1<br>
    *                             Maxlength\:100
    *
    *
    * @apiSuccessExample {json} Success-Response:
    *   HTTP/1.1 200 OK
    *   {
            "status":true
        }
    *
    * @apiSuccess {Boolean} status Status of action
    */
    public function security_check_post()
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        $this->form_validation->set_rules('username_email', 'User ID / Email ID', 'trim|required|min_length[6]|max_length[100]');
        $this->form_validation->set_rules('answer1', 'Answer 1', 'trim|required|max_length[100]');
        $this->form_validation->set_rules('answer2', 'Answer 2', 'trim|required|max_length[100]');
        
        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }

        $this->load->model('user/users_model');
        $userData=$this->users_model->userDataByEmailorUsername($_POST['username_email']);
        if(!empty($userData))
        {
            $questions=$this->users_model->getSecurityQuestions($userData->id);
            if(empty($questions))
            {
                $response['message']="Invalid request";
                goto end;
            }
            $q1_a1=$questions[0]->answer;
            $q2_a2=$questions[1]->answer;
            if($q1_a1==$_POST['answer1'] && $q2_a2==$_POST['answer2'])
            {
                $this->load->model("user/login_record_model");
                $this->login_record_model->insert("Password Reset email sent","password_reset_sent",$userData->username,$userData->email);
                $this->users_model->sendResetPasswordLink($userData->id);
                $response['status']=true;
                $response['message']="Password reset email sent to your Email ID";
            }
            else
            {
                $response['message']="Invalid answers";
                goto end;
            }
        }
        else
        {
            $response['message']="Invalid request";
            goto end;
        }

        end:
        if($response['status']==true)
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    } 
}
?>
