<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}

//use Restserver\Libraries\REST_Controller;
class Ashrams extends REST_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->library("server");
        $this->server->require_scope("user");
        /*$this->load->model('oauth_sessions_model');
        $this->oauth_sessions_model->session_check();*/

        $this->currentUser=$this->users_model->userDataByEmailorUsername($this->server->access_token_data['user_id']);
    }
    /**
    * @api {post} /ashrams List of ashrams
    * @apiPermission Logged in User
    * @apiName Ashrams
    * @apiGroup Ashrams
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   [
            {
                "id": "4",
                "name": "Avadhoota Datta Peetham (Main)"
            },
            {
                "id": "10",
                "name": "Sri Ganapati Sachchidananda Gnana Bodha Sabha Trust, Jaya Lakshmi Puram (Bommeparthy)"
            }
        ]
    */
    public function index_post()
    {
        $this->load->model('ashrams/ashrams_model');
        $ashramsList=$this->ashrams_model->getList();
        $result=array();
        $c=0;
        foreach($ashramsList as $ashram)
        {
            $result[$c]['id']=$ashram->id;
            $result[$c]['name']=$ashram->name;
            $c++;
        }
        $this->response($result, REST_Controller::HTTP_OK);
    }

    /**
    * @api {post} /ashrams/get Get current Ashram
    * @apiPermission Logged in User
    * @apiName Get
    * @apiGroup Ashrams
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   
            {
                "id": "4",
                "name": "Avadhoota Datta Peetham (Main)"
            }
    */
    public function get_post()
    {
        $this->load->model('ashrams/ashrams_model');
        $ashramData=$this->ashrams_model->ashramData($this->session->userdata("cartAshramId"));
        $result=array();
        $result['id']=$ashramData->id;
        $result['name']=$ashramData->name;
        $this->response($result, REST_Controller::HTTP_OK);
    }

    /**
    * @api {post} /ashrams/change Change current Ashram
    * @apiPermission Logged in User
    * @apiName Change
    * @apiGroup Ashrams
    *
    * @apiSuccessExample {json} Success-Response:
    *    HTTP/1.1 200 OK
    *   
            {
                "status": true
            }
    */
    public function change_post($ashramId=0)
    {
        $response['status']=FALSE;
        $response['message']="Mobile app is not working. Please use website only";
        $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        return true;
        die();

        if(!is_numeric($ashramId) || !$ashramId)
        {
            goto end;
        }

        $this->load->model('ashrams/ashrams_model');
        $ashramData=$this->ashrams_model->ashramData($ashramId);
        if(empty($ashramData))
        {
            $response['message']="Invalid Ashram ID";
            goto end;
        }

        if($this->input->get("cart_type")==1)
        {
            $this->cart_log_model->log("App: Changed ashram to :".$ashramData->name,$this->session->userdata("poojasCartAshramIdSelection"),1);
            $this->session->set_userdata("poojasCartAshramIdSelection",$ashramId);
        }
        else if($this->input->get("cart_type")==2)
        {
            $this->cart_log_model->log("App: Changed ashram to :".$ashramData->name,$this->session->userdata("donationCartAshramIdSelection"),2);
            $this->session->set_userdata("donationCartAshramIdSelection",$ashramId);
        }
        else if($this->input->get("cart_type")==3)
        {
            $this->cart_log_model->log("App: Changed ashram to :".$ashramData->name,$this->session->userdata("storeCartAshramIdSelection"),3);
            $this->session->set_userdata("storeCartAshramIdSelection",$ashramId);
        }
        

        $this->oauth_sessions_model->update($this->server->access_token,$this->session->all_userdata());
        $response['status']=true;
        
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }
}
?>