<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}

//use Restserver\Libraries\REST_Controller;
class Anaghavrata extends REST_Controller {
    private $error=0;
    var $service="";
    function __construct()
    {
        parent::__construct();
        $this->load->model('anaghavrata/anaghavrata_count_model');
        $this->service = "anaghavrata";

        if(1==1)
        {
            $accept = 0;
            $headers = [];
            foreach ($_SERVER as $name => $value) {
                if (substr($name, 0, 5) == 'HTTP_') {
                    $headers[str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($name, 5)))))] = $value;
                }
            }
            if(!empty($headers['Anaghavrataapiuser']) && $headers['Anaghavrataapiuser'] == "SDAwcTVxZWxJbmhORWc9PQ")
            {
                $accept = 1;
            }
            if( !$accept)
            {
                $this->response([
                    'status' => FALSE,
                    'message' => 'Access denied'
                ], REST_Controller::HTTP_NOT_FOUND);
                $this->error=1;
            }
        }
    }

    public function index_get()
    {

    }
    public function allsummaries_get()
    {
        $response['status']=FALSE;

        if($this->error)
            return;

        $records=$this->anaghavrata_count_model->listAllsummaries();
        if($records)
        {
            $response['status']=true;
            $response['data'] = $records;
        }
        
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }
    public function stats_get()
    {
        $response['status']=FALSE;

        if($this->error)
            return;

        $offset = 0;
        $limit = 0;
        if(!empty($_GET['offset']) && ($_GET['offset'] >= 0))
            $offset = $_GET['offset'];

        if(!empty($_GET['limit']) && $_GET['limit'] > 0)
            $limit = $_GET['limit'];
            
        $records=$this->anaghavrata_count_model->getTotalRecords($limit,$offset);
        if($records)
        {
            $response['status']=true;
            $response['data'] = $records;
        }
        
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    public function sendsms_post()
    {
        $response['status']=FALSE;

        if($this->error)
            return;

        $this->form_validation->set_rules('phone', 'Phone', 'trim|required|min_length[8]|max_length[20]');
        $this->form_validation->set_rules('message', 'Message', 'trim|required|max_length[2500]');
        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }
        $this->load->library("sms");
        $message=
                "Message from Sri Swamiji for Anagha Vratam: "."\n".
                $_POST['message']."\n".
                ""
                ;
        $exists = $this->anaghavrata_count_model->phoneCheck($_POST['phone']);
        if($exists)
        {
            $ex_data = $this->anaghavrata_count_model->getDatabyPhone($_POST['phone']);
            $countryData=$this->locations_model->getCountryByCode($ex_data->country);
            $this->sms->sendSMSGuest(
                                    'anaghavrata',
                                    $countryData->isd_code,
                                    $countryData->isd_code.$_POST['phone'],
                                    $message
                                );
            $response['status'] = TRUE;
            $response['message']="SMS Sent Successfully";
        }
        else
        {
            $response['message']="User Not Available";
            goto end;
        }
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    public function sendvoicesms_post()
    {
        $response['status']=FALSE;
        $response['message']="SMS Sent Successfully";
        $this->response($response, REST_Controller::HTTP_OK);
        $this->form_validation->set_rules('phone', 'Phone', 'trim|required|min_length[8]|max_length[20]');
        $this->form_validation->set_rules('message', 'Message', 'trim|required|max_length[2500]');
        if($this->form_validation->run() == FALSE)
        {
            $response['message']=strip_tags(validation_errors());
            goto end;
        }
        $this->load->library("s3",array("accessKey"=>aws_s3_access_key,
                                            "secretKey"=>aws_s3_secret_key,
                                            "useSSL"=>false,
                                            "endpoint"=>"s3.amazonaws.com"));
        if(isset($_FILES['voice_attachment']))
            if($_FILES['voice_attachment']['name']!='')
            {
                $name=$_FILES['voice_attachment']['name'];
                $pre=explode(".",$name);
                $ncnt=count($pre);
                $ext=$pre[$ncnt-1];
                $filename=time().".".$ext;
                
                $basePath=$_SERVER['DOCUMENT_ROOT']."/misc_services/anaghavrata/".date("Y")."/";
                if(!is_dir($basePath))
                {
                    mkdir($basePath,0777,true);
                }
                
                $path=$_SERVER['DOCUMENT_ROOT']."/misc_services/anaghavrata/".date("Y")."/".$filename;

                move_uploaded_file($_FILES['voice_attachment']['tmp_name'],$path);

                /*if(!$this->checkFile($path))
                {
                    $response['message']="File is corrupted, please try again.";
                    goto end;
                }*/
                $amazonUri="anaghavrata/".date("Y")."/".$filename;
                $this->s3->putObjectFile($path,aws_s3_bucket_name,$amazonUri,S3::ACL_PUBLIC_READ, array(), array());

                unlink($path);
            }
            else
            {
                $response['message']="Attachment Required";
                goto end;
            }
        $this->load->library("sms");
        $message=
                "You received a message from Sri Swamiji: "."\n".
                $_POST['message']."\n".
                "Please click on the link below to listen to Sri Swamiji's voice message."."\n".
                "".aws_s3_base_url.$amazonUri."\n".
                ""
                ;
        $exists = $this->anaghavrata_count_model->phoneCheck($_POST['phone']);
        if($exists)
        {
            $ex_data = $this->anaghavrata_count_model->getDatabyPhone($_POST['phone']);
            $countryData=$this->locations_model->getCountryByCode($ex_data->country);
            $this->sms->sendSMSGuest(
                                    'anaghavrata',
                                    $countryData->isd_code,
                                    $countryData->isd_code.$_POST['phone'],
                                    $message
                                );
            $response['status'] = TRUE;
            $response['message']="SMS Sent Successfully";
        }
        else
        {
            $response['message']="User Not Available";
            goto end;
        }
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    private function checkFile(Song $song)
    {
        $allowed = array(
            'audio/mp4', 'audio/mp3', 'audio/mpeg3', 'audio/x-mpeg-3', 'audio/mpeg', 'audio/*'
        );

        $finfo = finfo_open(FILEINFO_MIME_TYPE);
        $info = finfo_file($finfo, $song->getSelectedSongPath());

        if (!in_array($info, $allowed)) 
        {
            return false;
        }
        return $song;
    }

    public function citystats_get()
    {
        $response['status']=FALSE;

        if($this->error)
            return;

        $offset = 0;
        $limit = 0;
        if(!empty($_GET['offset']) && ($_GET['offset'] >= 0))
            $offset = $_GET['offset'];

        if(!empty($_GET['limit']) && $_GET['limit'] > 0)
            $limit = $_GET['limit'];

        $records=$this->anaghavrata_count_model->getTotalRecordsByCity($limit,$offset);
        if($records)
        {
            $response['status']=true;
            $response['data'] = $records;
        }
        
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    public function countrystats_get()
    {
        $response['status']=FALSE;

        if($this->error)
            return;

        $offset = 0;
        $limit = 0;
        if(!empty($_GET['offset']) && ($_GET['offset'] >= 0))
            $offset = $_GET['offset'];

        if(!empty($_GET['limit']) && $_GET['limit'] > 0)
            $limit = $_GET['limit'];
        
        $records=$this->anaghavrata_count_model->getTotalRecordsByCountry($limit,$offset);
        if($records)
        {
            $response['status']=true;
            $response['data'] = $records;
        }
        
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    public function top10_get()
    {
        $response['status']=FALSE;
        $records=$this->anaghavrata_count_model->gettodaysTotalRecords();
        if($records)
        {
            $response['status']=true;
            $response['data'] = $records;
        }
        
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }

    public function daycounts_get()
    {
        $response['status']=FALSE;

        if($this->error)
            return;

        $records=$this->anaghavrata_count_model->getTotalRecordsbyDate();
        if($records)
        {
            $response['status']=true;
            $response['data'] = $records;
        }
        
        if ($response['status'])
        {
            $this->response($response, REST_Controller::HTTP_OK);
        }
        else
        {
            end:
            $this->response($response, REST_Controller::HTTP_NOT_FOUND);
        }
    }
    
}
?>