<?php
defined('BASEPATH') OR exit('No direct script access allowed');
$included_files = get_included_files();
if(!in_array(APPPATH . '/libraries/REST_Controller.php', $included_files))
{
    require APPPATH . '/libraries/REST_Controller.php';
}

//use Restserver\Libraries\REST_Controller;
class Appji extends REST_Controller
{
    private $error=0;
    var $currencies;
    function __construct()
    {
        parent::__construct();
        $this->load->model('appji/appji_model');
        $this->load->library("Checktoken");
        $this->load->model('currencies_model');
        $this->currencies=$this->currencies_model->getByAshram(appji_ashram_id);
    }

    public function index_get()
    {
        $response['status']=true;
        $this->response($response, REST_Controller::HTTP_OK);
    }

    public function generate_token_post()
    {
        exit;
        $this->db->where("client_name","Appji");
        $appjiClientDetails = $this->db->get('app_clients')->row_array();
        $tokenData = array(
                            'client_id' => $appjiClientDetails['client_id'],
                            'nonce' => md5(date('Y-m-d H:i:s')),
                        );
        $this->checktoken->generate_token($tokenData, $appjiClientDetails['secret_key']);
    }

    /* 
        In Header: AuthToken and ClientId are required

        AuthToken: is a jwt token create using below data encode with secret key
                {
                    "client_id": "Client Id From DB",
                    "nonce": "md5 of current data and time"
                }
        ClientId: Client Id From DB "app_clients" table

        Parameters should be json raw data like below
        {
          "expiryTime": 1638297000,
          "donationCurrency": "INR",
          "donationAmount": "135",
          "appjiEmail": "chandrasekhar@gmail.com",
          "appjiUserFullName": "Chandra Sekhar"
        }
    */
    public function donationlink_post()
    {
        $this->checktoken->authenticate();

        $_POST = (array) json_decode($this->security->xss_clean($this->input->raw_input_stream));
        $this->form_validation->set_rules('appjiEmail','Appji User Email','trim|required|valid_email_custom');
        $this->form_validation->set_rules('appjiUserFullName', 'Appji User Full Name', 'trim|required|min_length[2]|max_length[120]|checkSpecialCharactersName');
        $this->form_validation->set_rules('donationCurrency','Donation Currency','trim|required|checkAppjiCurrency');
        $this->form_validation->set_rules('donationAmount','Donation Amount','trim|required|is_natural_no_zero');
        $this->form_validation->set_rules('expiryTime','Link Expiry Date','trim|required|checkAppjiDonationExpiryTimestamp');

        if($this->form_validation->run() === FALSE) {
            $this->failResponse(strip_tags(validation_errors()),  self::HTTP_PARTIAL_CONTENT);
            goto end;
        }

        if(!defined('appji_ashram_id'))
        {
            $this->failResponse("Ashram is not mapped",  self::HTTP_ACCEPTED);
            goto end;
        }

        if(!defined('appji_donation_id'))
        {
            $this->failResponse("Donation is not mapped",  self::HTTP_ACCEPTED);
            goto end;
        }

        $checkAppjiAshramExists = $this->appji_model->checkAppjiAshramExists(appji_ashram_id);
        if($checkAppjiAshramExists==0)
        {
            $this->failResponse("Ashram is not mapped",  self::HTTP_ACCEPTED);
            goto end;
        }

        $checkAppjiDonationExists = $this->appji_model->checkAppjiDonationExists(appji_ashram_id, appji_donation_id);
        if($checkAppjiDonationExists==0)
        {
            $this->failResponse("Donation is not mapped",  self::HTTP_ACCEPTED);
            goto end;
        }

        if(strtolower($_POST['donationCurrency'])=='inr' && $_POST['donationAmount']>$this->currencies[strtolower($_POST['donationCurrency'])]['max'])
        {
            $this->failResponse("Sorry! Maximum allowed amount for checkout is INR ".$this->currencies[strtolower($_POST['donationCurrency'])]['max'],  self::HTTP_ACCEPTED);
            goto end;
        }
        if(strtolower($_POST['donationCurrency'])=='usd' && $_POST['donationAmount']>$this->currencies[strtolower($_POST['donationCurrency'])]['max'])
        {
            $this->failResponse("Sorry! Maximum allowed amount for checkout is USD ".$this->currencies[strtolower($_POST['donationCurrency'])]['max'],  self::HTTP_ACCEPTED);
            goto end;
        }
        
        $this->load->helper('string');
        $linkToken = md5(date('Y-m-d H:i:s').random_string('alnum',32));

        $donationLink = $this->appji_model->createdonationLink($_POST,$linkToken);

        $result = array('donationLink' => $donationLink,'linkToken' => $linkToken);
        $this->successResponse($result);

        end:

    }



    /* 
        In Header: AuthToken and ClientId are required

        AuthToken: is a jwt token create using below data encode with secret key
                {
                    "client_id": "Client Id From DB",
                    "nonce": "md5 of current data and time"
                }
        ClientId: Client Id From DB "app_clients" table

        Parameters should be json raw data like below
        {
          "expiryTime": 1638297000,
          "subscriptionCurrency": "INR",
          "subscriptionAmount": "135",
          "appjiEmail": "chandrasekhar@gmail.com",
          "appjiUserFullName": "Chandra Sekhar",
          "subscriptionPeriod": "years" // years/months
        }
    */
    public function subscriptionlink_post()
    {
        $this->checktoken->authenticate();

        $_POST = (array) json_decode($this->security->xss_clean($this->input->raw_input_stream));
        $this->form_validation->set_rules('appjiEmail','Appji User Email','trim|required|valid_email_custom');
        $this->form_validation->set_rules('appjiUserFullName', 'Appji User Full Name', 'trim|required|min_length[2]|max_length[120]|checkSpecialCharactersName');
        $this->form_validation->set_rules('subscriptionCurrency','Subscription Currency','trim|required|checkAppjiCurrency');
        $this->form_validation->set_rules('subscriptionAmount','Subscription Amount','trim|required|is_natural_no_zero');
        $this->form_validation->set_rules('subscriptionPeriod','Subscription Period','trim|required|checkAppjiSubscriptionPeriod');
        $this->form_validation->set_rules('expiryTime','Link Expiry Date','trim|required|checkAppjiSubscriptionExpiryTimestamp');

        if($this->form_validation->run() === FALSE) {
            $this->failResponse(strip_tags(validation_errors()),  self::HTTP_PARTIAL_CONTENT);
            goto end;
        }

        if(!defined('appji_ashram_id'))
        {
            $this->failResponse("Ashram is not mapped",  self::HTTP_ACCEPTED);
            goto end;
        }

        if(!defined('appji_subscription_id'))
        {
            $this->failResponse("Subscription is not mapped",  self::HTTP_ACCEPTED);
            goto end;
        }

        $checkAppjiAshramExists = $this->appji_model->checkAppjiAshramExists(appji_ashram_id);
        if($checkAppjiAshramExists==0)
        {
            $this->failResponse("Ashram is not mapped",  self::HTTP_ACCEPTED);
            goto end;
        }

        $checkAppjiSubscriptionExists = $this->appji_model->checkAppjiSubscriptionExists(appji_ashram_id, appji_subscription_id);
        if($checkAppjiSubscriptionExists==0)
        {
            $this->failResponse("Subscription is not mapped",  self::HTTP_ACCEPTED);
            goto end;
        }

        if(strtolower($_POST['subscriptionCurrency'])=='inr' && $_POST['subscriptionAmount']>$this->currencies[strtolower($_POST['subscriptionCurrency'])]['max'])
        {
            $this->failResponse("Sorry! Maximum allowed amount for checkout is INR ".$this->currencies[strtolower($_POST['subscriptionCurrency'])]['max'],  self::HTTP_ACCEPTED);
            goto end;
        }
        if(strtolower($_POST['subscriptionCurrency'])=='usd' && $_POST['subscriptionAmount']>$this->currencies[strtolower($_POST['subscriptionCurrency'])]['max'])
        {
            $this->failResponse("Sorry! Maximum allowed amount for checkout is USD ".$this->currencies[strtolower($_POST['subscriptionCurrency'])]['max'],  self::HTTP_ACCEPTED);
            goto end;
        }
        
        $this->load->helper('string');
        $linkToken = md5(date('Y-m-d H:i:s').random_string('alnum',32));

        $subscriptionLink = $this->appji_model->createsubscriptionLink($_POST,$linkToken);

        $result = array('subscriptionLink' => $subscriptionLink,'linkToken' => $linkToken);
        $this->successResponse($result);

        end:

    }


    /* 
        In Header: AuthToken and ClientId are required

        AuthToken: is a jwt token create using below data encode with secret key
                {
                    "client_id": "Client Id From DB",
                    "nonce": "md5 of current data and time"
                }
        ClientId: Client Id From DB "app_clients" table

        Parameters should be json raw data like below
        {
          "linkToken": "linkToken",
          "linkType": "subscription" // donation/subscription
        }
    */
    public function makelinkexpiry_post()
    {
        $this->checktoken->authenticate();

        $_POST = (array) json_decode($this->security->xss_clean($this->input->raw_input_stream));
        $this->form_validation->set_rules('linkToken','Link Token','trim|required');
        $this->form_validation->set_rules('linkType', 'Link Type', 'trim|required|checkAppjiLinkType');

        if($this->form_validation->run() === FALSE) {
            $this->failResponse(strip_tags(validation_errors()),  self::HTTP_PARTIAL_CONTENT);
            goto end;
        }

        $linkDetails = [];
        if(isset($_POST['linkType']) && $_POST['linkType']=='donation')
        {
            $linkDetails = $this->appji_model->donationLinkDetailsByLinkToken($_POST['linkToken']);
        }
        if(isset($_POST['linkType']) && $_POST['linkType']=='subscription')
        {
            $linkDetails = $this->appji_model->subscriptionLinkDetailsByLinkToken($_POST['linkToken']);
        }

        if(!isset($linkDetails['id']))
        {
            $this->failResponse("There is no ".$_POST['linkType']." link found with given link token.",  self::HTTP_ACCEPTED);
            goto end;
        }

        if(isset($linkDetails['isLinkExpired']) && $linkDetails['isLinkExpired']=='1')
        {
            $this->failResponse("This ".$_POST['linkType']." link is already expired.",  self::HTTP_ACCEPTED);
            goto end;
        }

        if(isset($_POST['linkType']) && $_POST['linkType']=='donation')
        {
            $this->db->where("linkToken",$_POST['linkToken']);
            $this->db->update("appji_donations_links",array('isLinkExpired'=>'1'));
            $this->successResponse("Donation link status updated to expired");
            goto end;
        }
        if(isset($_POST['linkType']) && $_POST['linkType']=='subscription')
        {
            $this->db->where("linkToken",$_POST['linkToken']);
            $this->db->update("appji_subscriptions_links",array('isLinkExpired'=>'1'));
            $this->successResponse("Subscription link status updated to expired");
            goto end;
        }

        end:

    }
    


    /* 
        In Header: AuthToken and ClientId are required

        AuthToken: is a jwt token create using below data encode with secret key
                {
                    "client_id": "Client Id From DB",
                    "nonce": "md5 of current data and time"
                }
        ClientId: Client Id From DB "app_clients" table

        Parameters should be json raw data like below
        {
          "linkToken": "linkToken",
          "linkType": "subscription" // donation/subscription
        }
    */
    public function linktokendetails_post()
    {
        $this->checktoken->authenticate();

        $_POST = (array) json_decode($this->security->xss_clean($this->input->raw_input_stream));
        $this->form_validation->set_rules('linkToken','Link Token','trim|required');
        $this->form_validation->set_rules('linkType', 'Link Type', 'trim|required|checkAppjiLinkType');

        if($this->form_validation->run() === FALSE) {
            $this->failResponse(strip_tags(validation_errors()),  self::HTTP_PARTIAL_CONTENT);
            goto end;
        }

        $linkDetails = [];
        if(isset($_POST['linkType']) && $_POST['linkType']=='donation')
        {
            $linkDetails = $this->appji_model->donationLinkDetailsByLinkToken($_POST['linkToken']);
        }
        if(isset($_POST['linkType']) && $_POST['linkType']=='subscription')
        {
            $linkDetails = $this->appji_model->subscriptionLinkDetailsByLinkToken($_POST['linkToken']);
        }

        if(!isset($linkDetails['id']))
        {
            $this->failResponse("There is no ".$_POST['linkType']." link found with given link token.",  self::HTTP_ACCEPTED);
            goto end;
        }

        $result = array('linkDetails' => $linkDetails);
        $this->successResponse($result);

        end:

    }


    public function linktoken_details_get()
    {
        $this->checktoken->authenticate();
        echo 'Test'; exit;
        // $linktoken = $this->input->get('linktoken', TRUE);
        // echo $linktoken;
    }
    
}
?>