<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Website_settings extends CI_Controller 
{
	var $service='websiteadmin';
	var $currentUser='';
	var $poojaCategories=array(
							1=>"Shivaratri",
							2=>"Appaji Birthday",
							3=>"Navaratri",
							4=>"Datta Jayanti",
							5=>"Guru Purnima",
							6=>"Vinayaka Chavithi",
							7=>"Subrahmanya Sashthi",
							8=>"Krishna Janmashtami"
						);
    function __construct()
    {
        parent::__construct();
		if($this->session->userdata('id'))
		{
			$this->currentUser=$this->session->userdata("admin_data");
		}
		$this->load->model("email_settings_model");
		$this->load->model("ashrams/ashrams_model");
		$this->load->model("website_admin/website_settings_model");
    }
    function crons()
	{
		$views = array( 'website_settings/admin/list_crons' );
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function index()
	{
		$site_data=$this->website_settings_model->getData();
		$views = array( 'website_settings/admin/website_settings');
		$data = array('views'=>$views,'site_data'=>$site_data);
		$this->load->view(ADMIN_TEMPLATE,$data);  
	}
	public function email_settings($slug=null)
	{
		$data['satsangs']=array();
		$data['ashrams']= array();
		if(!empty($slug) && $slug=="satsangs")
		{
			$views = array( 'website_settings/admin/satsangs_settings');
			$data = array('views'=>$views);
			$this->load->model('satsangs/satsangs_model');
			$data['satsangs']=$this->satsangs_model->getList();
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
		else if(!empty($slug) && $slug=="ashrams")
		{
			$views = array( 'website_settings/admin/email_settings');
			$data = array('views'=>$views);
			$data['ashrams']=$this->ashrams_model->getList();
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
		else
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
		}
		
	}
	public function currencies()
	{
		$views = array( 'website_settings/admin/currencies');
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function listcurrencies()
	{
		$this->load->model("currencies_model");
		$list=$this->currencies_model->getList();
		echo json_encode($list);
	}
	public function listemailsettings($excel=0)
	{
		$list=$this->email_settings_model->getList($excel);
		echo json_encode($list);
	}
	public function listsatsangemailsettings($excel=0)
	{
		$list=$this->email_settings_model->getSatsangsList($excel);
		echo json_encode($list);
	}

	public function checkEmailValidation($email)
	{
		if(preg_match_all('/^(?!(?:(?:\x22?\x5C[\x00-\x7E]\x22?)|(?:\x22?[^\x5C\x22]\x22?)){255,})(?!(?:(?:\x22?\x5C[\x00-\x7E]\x22?)|(?:\x22?[^\x5C\x22]\x22?)){65,}@)(?:(?:[\x21\x23-\x27\x2A\x2B\x2D\x2F-\x39\x3D\x3F\x5E-\x7E]+)|(?:\x22(?:[\x01-\x08\x0B\x0C\x0E-\x1F\x21\x23-\x5B\x5D-\x7F]|(?:\x5C[\x00-\x7F]))*\x22))(?:\.(?:(?:[\x21\x23-\x27\x2A\x2B\x2D\x2F-\x39\x3D\x3F\x5E-\x7E]+)|(?:\x22(?:[\x01-\x08\x0B\x0C\x0E-\x1F\x21\x23-\x5B\x5D-\x7F]|(?:\x5C[\x00-\x7F]))*\x22)))*@(?:(?:(?!.*[^.]{64,})(?:(?:(?:xn--)?[a-z0-9]+(?:-[a-z0-9]+)*\.){1,126}){1,}(?:(?:[a-z][a-z0-9]*)|(?:(?:xn--)[a-z0-9]+))(?:-[a-z0-9]+)*)|(?:\[(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){7})|(?:(?!(?:.*[a-f0-9][:\]]){7,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?)))|(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){5}:)|(?:(?!(?:.*[a-f0-9]:){5,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3}:)?)))?(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))(?:\.(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))){3}))\]))$/i', $email))
		{
		    return TRUE;
		}
		else
		{
		  return FALSE;
		}
	}
	public function updateemailsettings()
	{
		if(isset($_POST['name']) && $_POST['value'])
		{
			if($_POST["name"] == "report_emails")
			{
				if (strpos($_POST['value'], ',') !== false) 
				{
					$emails = explode(",", $_POST["value"]);
					if(count(array_unique($emails))<count($emails))
					{
					    echo "Duplicate Emails are not allowed";
						exit();
					}
					$email_error = 0;
					foreach ($emails as $key1 => $value1) 
					{
						if(!$this->checkEmailValidation($value1))
						{
							$email_validation = $value1;
							$email_error++;
							$email_validation.= $email_validation." is not a valid Email<br>";
						}
					}
					if($email_error > 0)
					{
						echo $email_validation;
						exit();
					}
				}
				else
				{
					if(!$this->checkEmailValidation($_POST['value']))
					{
						echo "Email is not valid please enter valid Email";
						exit();
					}
				}
				
			}
			$this->email_settings_model->updateSettings($_POST['pk'],$_POST['name'],$_POST['value']);
			echo 1;
		}
	}
	public function updatesettings()
	{
		if(isset($_POST['name']) && isset($_POST['value']) && isset($_POST['pk']))
		{
			$this->website_settings_model->updateSettings($_POST['pk'],$_POST['value']);
		}
	}

	public function updatecurrencysettings()
	{
		if(isset($_POST['name']) && $_POST['value'] && in_array($_POST['name'],array('min','max','color')))
		{
			$this->load->model("currencies_model");
			$this->currencies_model->updateSettings($_POST['pk'],$_POST['name'],$_POST['value']);
		}
	}



	/**
	 * Loads the Ashram email settings add/edit Page
	 *
	 * @return  void
	 */
	public function add_edit_ashram_email_setting($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$emailSettingsData=$this->email_settings_model->getAshramEmailSettingsByID($id);
			if(empty($emailSettingsData))
			{
				$this->session->set_flashdata("trust_error",1);
				redirect('website_settings/email_settings/ashrams');
			}
		} else {
			$emailSettingsData=array();
			redirect('website_settings/email_settings/ashrams');
		}
		if(isset($_POST["email_setting_from_email"]) || isset($_POST["email_setting_from_name"]))
		{
			if(!$id)
			{
				$this->form_validation->set_rules('email_setting_ashram_id', 'Ashram', 'trim|required');
				$this->form_validation->set_rules('email_setting_service_slug', 'Service Slug', 'trim|required|min_length[2]|max_length[200]');
			}
			$this->form_validation->set_rules('email_setting_from_email', 'From Email', 'trim|required|min_length[2]|max_length[200]');
			$this->form_validation->set_rules('email_setting_from_name', 'From Name', 'trim|required|min_length[2]|max_length[120]');
			$this->form_validation->set_rules('email_setting_report_emails', 'Report Emails ', 'trim|valid_emails_custom');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("ashram_email_setting_error",1);
				redirect('website_settings/add_edit_ashram_email_setting/'.$id);
				return;
			}

			$saved=$this->email_settings_model->saveAshramEmailSettings($id);
			if($id==0)
			{
				$this->session->set_flashdata("ashram_email_setting_created",1);
			}
			else
				$this->session->set_flashdata("ashram_email_setting_saved",1);
			redirect('website_settings/add_edit_ashram_email_setting/'.$saved);
		} else {
			if($id!='' && (empty($emailSettingsData)) )
			{
				redirect('website_settings/email_settings/ashrams');
			}
			$views = array('ashrams/admin/add_edit_ashram_email_setting');
			$data = array('views'=>$views,'id'=>$id);
			if(is_numeric($id) && $id)
			{
				$data['emailSettingsData']=$emailSettingsData;
			}
			else
			{
				$data['ashrams']=$this->ashrams_model->getList();
			}
			$this->load->view(ADMIN_TEMPLATE,$data); 
		}
	}


	/**
	 * Loads the Satsang email settings add/edit Page
	 *
	 * @return  void
	 */
	public function add_edit_satsang_email_setting($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$emailSettingsData=$this->email_settings_model->getSatsangEmailSettingsByID($id);
			if(empty($emailSettingsData))
			{
				$this->session->set_flashdata("trust_error",1);
				redirect('website_settings/email_settings/satsangs');
			}
		} else {
			$emailSettingsData=array();
			redirect('website_settings/email_settings/satsangs');
		}
		if(isset($_POST["email_setting_from_email"]) || isset($_POST["email_setting_from_name"]))
		{
			if(!$id)
			{
				$this->form_validation->set_rules('email_setting_satsang_id', 'Satsang', 'trim|required');
				$this->form_validation->set_rules('email_setting_service_slug', 'Service Slug', 'trim|required|min_length[2]|max_length[200]');
			}
			$this->form_validation->set_rules('email_setting_from_email', 'From Email', 'trim|required|min_length[2]|max_length[200]');
			$this->form_validation->set_rules('email_setting_from_name', 'From Name', 'trim|required|min_length[2]|max_length[120]');
			$this->form_validation->set_rules('email_setting_report_emails', 'Report Emails ', 'trim|valid_emails_custom');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("satsang_email_setting_error",1);
				redirect('website_settings/add_edit_satsang_email_setting/'.$id);
				return;
			}

			$saved=$this->email_settings_model->saveSatsangEmailSettings($id);
			if($id==0)
			{
				$this->session->set_flashdata("satsang_email_setting_created",1);
			}
			else
				$this->session->set_flashdata("satsang_email_setting_saved",1);
			redirect('website_settings/add_edit_satsang_email_setting/'.$saved);
		} else {
			if($id!='' && (empty($emailSettingsData)) )
			{
				redirect('website_settings/email_settings/satsangs');
			}
			$views = array('ashrams/admin/add_edit_satsang_email_setting');
			$data = array('views'=>$views,'id'=>$id);
			if(is_numeric($id) && $id)
			{
				$data['emailSettingsData']=$emailSettingsData;
				if(isset($emailSettingsData->satsang_id) && $emailSettingsData->satsang_id>0)
				{
					$data['satsangData']=$this->satsangs_model->satsangData($emailSettingsData->satsang_id);
				}
			}
			else
			{
				$data['ashrams']=$this->ashrams_model->getList();
			}
			$data['satsangs']=$this->satsangs_model->getList();
			$this->load->view(ADMIN_TEMPLATE,$data); 
		}
	}

	public function updatewebsitesettings()
	{
		if(isset($_POST['techsupport_enable']))
		{
			$this->website_settings_model->updateSettings('techsupport_enable',$_POST['techsupport_enable']);
		}
		if(isset($_POST['user_login']))
		{
			$this->website_settings_model->updateSettings('user_login',$_POST['user_login']);
		}
		if(isset($_POST['admin_login']))
		{
			$this->website_settings_model->updateSettings('admin_login',$_POST['admin_login']);
		}
		if(isset($_POST['user_signup']))
		{
			$this->website_settings_model->updateSettings('user_signup',$_POST['user_signup']);
		}
		if(isset($_POST['enable_orders']))
		{
			$this->website_settings_model->updateSettings('enable_orders',$_POST['enable_orders']);
		}
		if(isset($_POST['live_updates']))
		{
			$this->website_settings_model->updateSettings('live_updates',$_POST['live_updates']);
		}
		if(isset($_POST['facebook_link']))
		{
			$this->website_settings_model->updateSettings('facebook_link',$_POST['facebook_link']);
		}
		if(isset($_POST['youtube_link']))
		{
			$this->website_settings_model->updateSettings('youtube_link',$_POST['youtube_link']);
		}
		if(isset($_POST['vimeo_link']))
		{
			$this->website_settings_model->updateSettings('vimeo_link',$_POST['vimeo_link']);
		}
		if(isset($_POST['twitter_link']))
		{
			$this->website_settings_model->updateSettings('twitter_link',$_POST['twitter_link']);
		}
		if(isset($_POST['poojas']))
		{
			$this->website_settings_model->updateSettings('poojas',$_POST['poojas']);
		}
		if(isset($_POST['donations']))
		{
			$this->website_settings_model->updateSettings('donations',$_POST['donations']);
		}
		if(isset($_POST['subscriptions']))
		{
			$this->website_settings_model->updateSettings('subscriptions',$_POST['subscriptions']);
		}
		if(isset($_POST['store']))
		{
			$this->website_settings_model->updateSettings('store',$_POST['store']);
		}
		if(isset($_POST['pledge_form']))
		{
			$this->website_settings_model->updateSettings('pledge_form',$_POST['pledge_form']);
		}
		if(isset($_POST['registration_form']))
		{
			$this->website_settings_model->updateSettings('registration_form',$_POST['registration_form']);
		}
		if(isset($_POST['email_service']))
		{
			$this->website_settings_model->updateSettings('email_service',$_POST['email_service']);
		}
		if(isset($_POST['sms_service']))
		{
			$this->website_settings_model->updateSettings('sms_service',$_POST['sms_service']);
		}
		if(isset($_POST['shukavana_voting_enable']))
		{
			$this->website_settings_model->updateSettings('shukavana_voting_enable',$_POST['shukavana_voting_enable']);
		}
		if(isset($_POST['banned_emails_contact_techsupport']))
		{
			$this->website_settings_model->updateSettings('banned_emails_contact_techsupport',$_POST['banned_emails_contact_techsupport']);
		}
		if(isset($_POST['blocked_file_types']))
		{
			$this->website_settings_model->updateSettings('blocked_file_types',$_POST['blocked_file_types']);
		}
		if(isset($_POST['abusive_words']))
		{
			$this->website_settings_model->updateSettings('abusive_words',$_POST['abusive_words']);
		}
		$this->session->set_flashdata("website_settings_saved_success",1);
	}
}
?>