<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Vishwashantipadayatra2022form extends CI_Controller 
{
	var $service='';
	function __construct()
	{
        parent::__construct();
        if($this->session->userdata('id'))
        	$this->currentUser=$this->session->userdata("admin_data");
       	else
       		$this->currentUser=$this->session->userdata("user_data");

		//==========Load encryption library=============//
    	$this->load->library('encryption');
    	//==========Load encryption library=============//
       	$this->load->model("vishwashantipadayatra2022/vishwashantipadayatra2022_count_model");
       	$this->load->model("user/users_model");
       	$this->service = "vishwashantipadayatra2022";
    }
	public function index()
	{
		$data['views'] = array('common/public/error');
		$this->load->view(FRONTEND_TEMPLATE,$data);
		return;
		if($this->session->userdata("user_data"))
		{

			$this->load->model("subscriptions/donors_model");
			$data ['family_donors'] = $this->donors_model->getUserUnhideDonors($this->currentUser->sso_user_id);
			$data['paidOrders'] = $this->vishwashantipadayatra2022_count_model->getVishwashantiOrderItems(vishwashantipadayatra2022_donation_ids);
			// echo '<pre>'; print_r($data['paidOrders']); die();
			if(empty($data['paidOrders']))
			{
				$data['views'] = array('vishwashantipadayatra2022/public/form');
			}
			else
			{
				$isDateExists = 0;
				$participantDateOpensOn = "";
				$participantDates = vishwashantipadayatra2022_form_days;
            	if(isset($participantDates) && count($participantDates)>0)
            	{
            		$participantDateOpensOn = $participantDates[0];
            		foreach($participantDates as $participantDate)
            		{
            			if($participantDate<=date("Y-m-d"))
            			{
            				$isDateExists = 1;
            			}
            		}
            	}

            	if($isDateExists)
            	{
					$data['views'] = array('vishwashantipadayatra2022/public/user_form');
            	}
            	else
            	{
            		$data['participantDateOpensOn'] = $participantDateOpensOn;
            		$data['views'] = array('vishwashantipadayatra2022/public/form');
            	}
			}
		}
		else
		{
			$data['views'] = array('vishwashantipadayatra2022/public/form');
		}
		
		$data['topcities'] = $this->vishwashantipadayatra2022_count_model->getTopCities();
		$this->load->view(FRONTEND_TEMPLATE,$data);
	}

	public function getOrderItemDetails()
	{
		$data['itemDetails'] = [];
		if(isset($_POST['order_item_id']) && $_POST['order_item_id']>0)
		{
			$data['itemDetails'] = $this->vishwashantipadayatra2022_count_model->getVishwashantiOrderItemDetails($_POST['order_item_id']);
		}
		echo json_encode($data);
	}

	public function send()
	{
		$data['flag']=0;
		if($GLOBALS['site_settings']['vishwashantipadayatra2022_form']==0)
		{
			$data['flag']=2;
			goto end;
		}
		$exists = 0;
		$this->form_validation->set_rules('name', 'Name', 'trim|required|min_length[3]|max_length[250]');
		$this->form_validation->set_rules('participant_name', 'Participant Name', 'trim|required|min_length[3]|max_length[250]');
		
		if(!empty($this->session->userdata("user_data")))
		{
			$userData = $this->users_model->userData($this->currentUser->id);
			if(empty($userData->address))
				$this->form_validation->set_rules('address1', 'Address Line 1','trim|min_length[3]|max_length[100]');
			else
				$_POST['address1'] 	= $userData->address;

			if(empty($userData->address1))
				$this->form_validation->set_rules('address2', 'Address Line 2','trim|min_length[3]|max_length[100]');
			else
				$_POST['address2'] 	= $userData->address1;

			if(empty($userData->address2))
				$this->form_validation->set_rules('address3', 'Address Line 3','trim|min_length[3]|max_length[100]');
			else
				$_POST['address3'] 	= $userData->address2;

			if(empty($userData->zipcode))
				$this->form_validation->set_rules('zipcode', 'ZIP Code','trim|alphabetsnumbers|min_length[3]|max_length[15]');
			else
				$_POST['zipcode'] 	= $userData->zipcode;

			if(empty($userData->city))
				$this->form_validation->set_rules('city', 'City','trim|required|min_length[2]|max_length[100]|name_validate13');
			else
				$_POST['city'] 	= $userData->city;

			if(empty($userData->state))
				$this->form_validation->set_rules('state', 'State','trim|required|min_length[2]|max_length[100]|name_validate13');
			else
				$_POST['state'] 	= $userData->state;

			if(empty($userData->country))
				$this->form_validation->set_rules('country_code', 'Country','trim|required|checkCountry');
			else
				$_POST['country_code'] 	= $userData->country_id;

			if(empty($userData->phoneno))
			{
				$this->form_validation->set_rules('phone', 'Phone Number','trim|required|numeric|min_length[8]|max_length[15]');
			}
			else
				$_POST['phone'] 	= $userData->phoneno;

			$_POST['email']			= $userData->email;
		}
		else
		{
			$this->form_validation->set_rules('phone', 'Phone Number','trim|required|numeric|min_length[8]|max_length[15]');
			if(!empty($_POST['phone']) && trim($_POST['phone']) != "")
			{
				$exists = $this->vishwashantipadayatra2022_count_model->phoneCheck($_POST['phone']);
				if($exists)
				{
					$ex_data = $this->vishwashantipadayatra2022_count_model->getDatabyPhone($_POST['phone']);
					$_POST['address1'] 		= $ex_data->address_1;
					$_POST['address2'] 		= $ex_data->address_2;
					$_POST['address3'] 		= $ex_data->address_3;
					$_POST['country_code'] 	= $ex_data->country;
					$_POST['country_name'] 	= $ex_data->country_name;
					$_POST['city'] 			= $ex_data->city;
					$_POST['state'] 		= $ex_data->state;
					$_POST['zipcode'] 		= $ex_data->zipcode;
					$_POST['email']			= $ex_data->email;
				}
			}
			if($exists==0)
			{
				$this->form_validation->set_rules('email', 'Email ID','trim|required|valid_email_custom|min_length[6]|max_length[100]');
				$this->form_validation->set_rules('address1', 'Address Line 1','trim|min_length[3]|max_length[100]');
				$this->form_validation->set_rules('address2', 'Address Line 2','trim|min_length[3]|max_length[100]');
				$this->form_validation->set_rules('address3', 'Address Line 3','trim|min_length[3]|max_length[100]');
				$this->form_validation->set_rules('city', 'City','trim|required|min_length[2]|max_length[100]|name_validate13');
				$this->form_validation->set_rules('state', 'State','trim|required|min_length[2]|max_length[100]|name_validate13');
				$this->form_validation->set_rules('country_code', 'Country','trim|required|checkCountry');
				$this->form_validation->set_rules('zipcode', 'ZIP Code','trim|alphabetsnumbers|min_length[3]|max_length[15]');
			}
		}
		$this->form_validation->set_rules('order_item_id', 'Seva Name','trim|required|numeric');
		$this->form_validation->set_rules('steps_count', 'Steps Count','trim|required|numeric|min_length[1]|max_length[5]');
		$this->form_validation->set_rules('yatra_date', 'Vishwashanti Yatra 2022 Date','trim|required');
		if ($this->form_validation->run() == FALSE)
		{
			$data['errors']=validation_errors();
			goto end;
		}
		$this->vishwashantipadayatra2022_count_model->save($_POST);
		if(!empty($this->session->userdata("user_data")))
		{
			$this->session->set_flashdata('vishwashantipadayatra2022_success',1);
			$this->updateUser($this->currentUser->id,$_POST);
		}
		
        $data['flag']=1;

		end:
		echo json_encode($data);
	}

	private function updateUser($userId=0,$data)
	{
		if(!empty($userId) && !empty($this->currentUser->id))
		{
			$this->load->model("user/users_model");
			$userData = $this->users_model->userData($userId);
			$updateData = array();

			if(!empty($data['address1']) && empty($userData->address))
				$updateData['address'] = $data['address1'];

			if(!empty($data['address2']) && empty($userData->address1))
				$updateData['address1'] = $data['address2'];

			if(!empty($data['address3']) && empty($userData->address2))
				$updateData['address2'] = $data['address3'];

			if(!empty($data['zipcode']) && empty($userData->zipcode))
				$updateData['zipcode'] = $data['zipcode'];

			if(!empty($data['phone']) && empty($userData->phoneno))
				$updateData['phoneno'] = $data['phone'];

			if(!empty($data['city']) && empty($userData->city))
				$updateData['city'] = $data['city'];

			if(!empty($data['state']) && empty($userData->state))
				$updateData['state'] = $data['state'];

			if(!empty($data['country_code']) && (empty($userData->country) || empty($userData->country_id)))
			{
				$countryData=$this->locations_model->getCountryByCode($data['country_code']);
				$updateData['country_id'] = $data['country_code'];
				$updateData['country'] = $countryData->country_name;
			}
			if(!empty($updateData) && count($updateData) > 0)
				$this->users_model->updateProfileaddress($userId,$updateData);
		}
	}

	function phoneCheck()
	{
		$exists=$this->vishwashantipadayatra2022_count_model->phoneCheck($_POST['phone']);
		if(!$exists)
		{
			echo 'true';
		}
		else echo 'false';
	}

	function publicphoneCheck()
	{
		$exists=$this->vishwashantipadayatra2022_count_model->publicphoneCheck($_POST['phone']);
		if(!$exists)
		{
			echo 'true';
		}
		else
		{
			$exists->sjunfhh = $this->encdycstring($_POST['phone'],"encrypt");
			echo json_encode($exists);
		}
	}

	public function updateNote()
	{
		if($GLOBALS['site_settings']['vishwashantipadayatra2022_form']==0)
		{
			echo 2;
			return;
		}
    	$this->form_validation->set_rules('value', 'Value', 'trim|min_length[6]|max_length[500]');
    	if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$array_merge['vishwashantipadayatra2022_family'] = $_POST['value'];
   		$this->session->set_userdata($array_merge);
		if(!empty($array_merge))
		{
			echo 1;
		}
		else
		{
			echo 0;
		}	
	}

	public function encdycstring($string,$enctype = "encrypt")
	{
		// Store a string into the variable which 
		// need to be Encrypted 
		// https://www.geeksforgeeks.org/how-to-encrypt-and-decrypt-a-php-string/ (Reference)
		// https://stackoverflow.com/questions/40110470/php-opensll-encryption-to-prevent-special-characters(This is for avoid slashes last answer)
		// Store the cipher method 
		$ciphering = "AES-128-CTR"; 
		  
		// Use OpenSSl Encryption method 
		$iv_length = openssl_cipher_iv_length($ciphering); 
		$options = 0; 
		  
		// Non-NULL Initialization Vector for encryption 
		$encryption_iv = '1234567891011121'; 
		  
		// Store the encryption key 
		$encryption_key = "Dattapeetham"; 
		
		if($enctype == "encrypt")
		{
			// Use openssl_encrypt() function to encrypt the data 
			$encryption = openssl_encrypt($string, $ciphering, $encryption_key, $options, $encryption_iv); 
			$encryption = base64_encode($encryption);

			return $encryption;
		}
		else
		{
			// Non-NULL Initialization Vector for decryption 
			$decryption_iv = '1234567891011121'; 
			  
			// Store the decryption key 
			$decryption_key = "Dattapeetham"; 
			  
			// Use openssl_decrypt() function to decrypt the data 
			$decryption=openssl_decrypt (base64_decode($encryption), $ciphering, $decryption_key, $options, $decryption_iv);

			return $decryption;
		}
	}
	

	public function vishwashantipadayatra2022OnFamilyTypeChange()
	{
		$vishwashantipadayatra2022onFamilyType = $this->input->post('vishwashantipadayatra2022onFamilyType');
		if($vishwashantipadayatra2022onFamilyType)
		{
			$this->session->set_userdata('vishwashantipadayatra2022onFamilyType', $vishwashantipadayatra2022onFamilyType);
		}	
	}

	public function vishwashantipadayatra2022OnFamilyMemberChange()
	{
		$vishwashantipadayatra2022onFamilyMembers = $this->input->post('vishwashantipadayatra2022onFamilyMembers');
		if($vishwashantipadayatra2022onFamilyMembers)
		{
			$this->session->set_userdata('vishwashantipadayatra2022onFamilyMembers', $vishwashantipadayatra2022onFamilyMembers);
		}
	}

	
}
?>