<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Videos extends CI_Controller
{
	var $service='content';
	var $currentUser='';
    public function __construct() 
	{
        parent::__construct();
        $this->load->model('content/videos_model');
        $this->load->model('content/videos_albums_model');
		if($this->session->userdata('id'))
        	$this->currentUser=$this->session->userdata("admin_data");
       	else
       		$this->currentUser=$this->session->userdata("user_data");
    }
	public function index()
	{
		$views = array( 'videos/public/list');
		$data = array('views'=>$views);
		$this->load->view(FRONTEND_TEMPLATE,$data);
	}
	public function listc($type=1)
	{
		$list=$this->videos_model->listPublic($type);
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='')
		{
			$this->search_log_model->log(trim($_POST['search_text']),'videos');
		}
		echo json_encode($list);
	}
	public function albums()
	{
		$views = array( 'videos/public/list_albums');
		$data = array('views'=>$views);
		$this->load->view(FRONTEND_TEMPLATE,$data);
	}
	public function album_view($albumId=0)
	{
		if(is_numeric($albumId) && $albumId)
		{
			$albumData=$this->videos_albums_model->albumData($albumId);
			if(!empty($albumData['album']))
			{
				$views = array( 'videos/public/list_album_videos');
				$data = array('views'=>$views);
				if($albumData['album']->ashram_id)
					$data['ashramData']=$this->ashrams_model->ashramData($albumData['album']->ashram_id);
				if($albumData['album']->satsang_id)
					$data['satsangData']=$this->satsangs_model->satsangData($albumData['album']->satsang_id);
				$data['albumData']=$albumData['album'];
				$this->load->view(FRONTEND_TEMPLATE,$data);
			}
			else
			{
				$data['views'] = array('common/public/error');
				$this->load->view(FRONTEND_TEMPLATE,$data);
			}
		}
		else
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
		
	}
	public function lista()
	{
		$list=$this->videos_albums_model->listPublic();
		echo json_encode($list);
	}
	public function listv($albumId=0,$flag=1)
	{
		if(is_numeric($albumId) && $albumId)
		{
			$albumData=$this->videos_albums_model->albumData($albumId);
			if(!empty($albumData['album']))
			{
				$list=$this->videos_model->listPublic($flag,$albumId);
				echo json_encode($list);
			}
		}
	}
	public function view($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$videoData=$this->videos_model->videoData($id);
			if(!empty($videoData))
			{
				$views = array( 'videos/public/view');
				$data = array('views'=>$views);
				if($videoData->ashram_id)
					$data['ashramData']=$this->ashrams_model->ashramData($videoData->ashram_id);
				if($videoData->satsang_id)
					$data['satsangData']=$this->satsangs_model->satsangData($videoData->satsang_id);
				$data['videoData']=$videoData;
				$data['albumData']=$this->videos_albums_model->albumData($videoData->album_id);
				$this->load->view(FRONTEND_TEMPLATE,$data);
			}
			else
			{
				$data['views'] = array('common/public/error');
				$this->load->view(FRONTEND_TEMPLATE,$data);
			}
		}
		else
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}
}
?>