<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Vedoktashantiadmin extends CI_Controller 
{
	var $currentUser='';
	var $service="vedoktashanti";
	var $statusArray=array(1=>"Open",
							2=>"Waiting Admin",
							3=>"Waiting User",
							4=>"Closed");
	var $statusResponse=array(
								1=>array('color'=>'lime',
										'info'=>"has been Approved"),
								2=>array('color'=>'ruby',
										'info'=>"has been Closed"),
								3=>array(
										'color'=>'lime',
										'info'=>"has been Re-Opened"),
								4=>array('color'=>'ruby',
										'info'=>"has been Closed"));
	var $purposeArray=array(
								1=>"Office/Billing",
								2=>"Contact",
								3=>"Abuse",
								4=>"Complaint",
								5=>"Question",
								6=>"Technical Support",
								7=>"Other"
								);
    function __construct()
    {
        parent::__construct();
		$this->load->model('vedoktashanti/vedoktashanti_model');
		$this->load->model('vedoktashanti/vedoktashanti_admin_user_replies_model');
		$this->load->model('vedoktashanti/vedoktashanti_standard_replies_model');
		$this->load->model('vedoktashanti/vedoktashanti_standard_replies_category_model');
		$this->load->model('user/users_model');
		$this->currentUser=$this->session->userdata("admin_data");
    }
	public function listusers($excel='')
	{
		$list=$this->vedoktashanti_model->listUsersAjax($excel);
		echo json_encode($list);
	}

	public function capture()
    {
        $data['flag']=0;
        if($GLOBALS['site_settings']['vedoktashanti_enable']==1)
        {
            $this->load->model('vedoktashanti/vedoktashanti_model');
            if(isset($GLOBALS['site_settings']['banned_emails_vedoktashanti']) && ($GLOBALS['site_settings']['banned_emails_vedoktashanti']!=''))
            {
                $banned_emails=array_filter(explode(",",$GLOBALS['site_settings']['banned_emails_vedoktashanti']));
                if(!empty($banned_emails) && in_array($this->input->post("request_email"),$banned_emails))
                {
                    goto success;
                }
            }
            if(isset($_FILES['file1']) && $_FILES['file1']['name']!='')
            {
                if($_FILES['file1']['size']==0 || $_FILES['file1']['size']>(1*1024*1024))
                    goto end;
            }
            if(isset($_FILES['file2']) && $_FILES['file2']['name']!='')
            {
                if($_FILES['file2']['size']==0 || $_FILES['file2']['size']>(1*1024*1024))
                    goto end;
            }
            if(isset($_FILES['file3']) && $_FILES['file3']['name']!='')
            {
                if($_FILES['file3']['size']==0 || $_FILES['file3']['size']>(1*1024*1024))
                    goto end;
            }
            if(!$this->session->userdata('loggedIn'))
            {
                $this->form_validation->set_rules('request_name', 'Name', 'trim|required|min_length[3]|max_length[100]');
                $this->form_validation->set_rules('request_email', 'Email ID', 'trim|required|no_uppercase|valid_email_custom|min_length[6]|max_length[200]');
            }
            $this->form_validation->set_rules('request_phone', 'Phone', 'trim|required|min_length[8]|max_length[20]');
            $this->form_validation->set_rules('purpose', 'Purpose', 'trim|required|checkTechsupportPurpose');
            $this->form_validation->set_rules('request_msg', 'Message', 'trim|required|strip_tags|max_length[12000]');
            $this->form_validation->set_rules('country_code', 'Country', 'trim|required|countryCheck');

            if($this->form_validation->run() == FALSE)
            {
                $data['msg']="Something wrong, please refresh the page and try again.";
                $data['error_data']=validation_errors();
                echo json_encode($data);
                return;
            }
            if(!empty($this->currentUser) && $this->currentUser->admin == 1)
            {
                if($_POST["request_email"] != $this->currentUser->email)
                {
                    $this->form_validation->set_rules('request_user_id', 'Request User', 'trim|required');
                    if($_POST["request_user_name"] == "undefined")
                    {
                        $data['msg']="Something wrong, please refresh the page and try again.";
                        $data['error_data']="Please select user";
                        echo json_encode($data);
                        return;
                    }
                }
            }
            $this->vedoktashanti_model->post($_POST);
            success:
            {
                $data['flag']=1;
            }
            $this->session->set_flashdata("ticket_captured",1);
        }
        end:
        echo json_encode($data);
    }
	
	public function index()
	{
		$views = array( 'vedoktashanti/admin/list_messages');
		$data = array('views'=>$views,'user_data'=>array());
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function listmessages($excel=0)
	{
		$list=$this->vedoktashanti_model->listMessagesAjax(1,$excel);
		echo json_encode($list);
	}
	public function changestatus($id=0,$status=0)
	{
		$result['flag']=0;
		if(is_numeric($id) && is_numeric($status) && $id && $status)//Is ID and status are numeric value
		{
			$result['data']=array();
			//Retrieve Blog with that ID
			$vedoktashantiData=$this->vedoktashanti_model->vedoktashantiData($id);

			if(empty($vedoktashantiData))
			{
				$this->logaction->log($this->service,"Change status - Invalid ID - ".$id);
				$result['error']='Invalid request';
				echo json_encode($result);
				return;
			}
			
			$currentStatus=$vedoktashantiData->fstatus;

			$granted=$this->checkStatus($currentStatus,$status);
			if(!$granted)
			{
				$this->logaction->log($this->service,"Change status - Invalid request - ".$vedoktashantiData->vedoktashanti_id);
				$result['error']='Invalid request';
				echo json_encode($result);
				return;
			}

			$flag=$this->vedoktashanti_model->changeStatus($id,$vedoktashantiData,$status);
			
			$result['data']=$vedoktashantiData;
			$result['flag']=1;
			$result['message']=$this->statusResponse[$status];
			echo json_encode($result);

			$this->logaction->log($this->service,"Status changed from ".$this->statusArray[$currentStatus]." -> ".$this->statusArray[$status].
				" - ".$vedoktashantiData->vedoktashanti_id);
			return;
			
		}
		else
			$this->logaction->log($this->service,"Change Status - Invalid ID - ".$id);
		
		echo json_encode($result);
	}
	
	private function checkStatus($currentStatus,$newStatus)
	{
		if(in_array($currentStatus,array(1,2,3))) //Close
		{
			if($newStatus==4)
			{
				return 1;
			}
		}
		return 0;
	}

	public function view($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$vedoktashantiData=$this->vedoktashanti_model->vedoktashantiData($id);
			if(empty($vedoktashantiData))
			{
				$this->logaction->log($this->service,"Admin View - Invalid ID - ".$id);
				redirect('vedoktashantiadmin');
			}
			$repliesData=$this->vedoktashanti_admin_user_replies_model->getReplies($id);
			$views = array( 'vedoktashanti/admin/view');
			$data = array('views'=>$views,'vedoktashantiData'=>$vedoktashantiData,'id'=>$id,'repliesData'=>$repliesData);

			$this->load->view(ADMIN_TEMPLATE,$data);
			$this->vedoktashanti_model->messageRead($id);
			$this->vedoktashanti_model->checkIn($id);
		}
		else
		{
			$this->logaction->log($this->service,"Admin View - Invalid ID format - ".$id);
			redirect('vedoktashantiadmin');
		}
	}
	public function checkout($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$vedoktashantiData=$this->vedoktashanti_model->vedoktashantiData($id);
			if(empty($vedoktashantiData))
			{
				$this->logaction->log($this->service,"Admin Checkout - Invalid ID - ".$id);
				redirect('vedoktashantiadmin');
			}
			
			$this->vedoktashanti_model->checkOut($id);
			redirect('vedoktashantiadmin');
		}
		else
		{
			$this->logaction->log($this->service,"Admin View - Invalid ID format - ".$id);
			redirect('vedoktashantiadmin');
		}
	}

	public function checkout_close($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$vedoktashantiData=$this->vedoktashanti_model->vedoktashantiData($id);
			if(empty($vedoktashantiData))
			{
				$this->logaction->log($this->service,"Admin Checkout - Invalid ID - ".$id);
				redirect('vedoktashantiadmin');
			}
			
			$this->vedoktashanti_model->checkOut($id);
			ob_start();
			$this->changestatus($id,4);
			$v=ob_get_clean();
			redirect('vedoktashantiadmin');
		}
		else
		{
			$this->logaction->log($this->service,"Admin View - Invalid ID format - ".$id);
			redirect('vedoktashantiadmin');
		}
	}
	public function vedoktashanti_reply($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$vedoktashantiData=$this->vedoktashanti_model->vedoktashantiData($id);
			if(empty($vedoktashantiData))
			{
				$this->logaction->log($this->service,"Reply page - Invalid ID - ".$id);
				$this->session->set_flashdata("vedoktashanti_error",1);
				redirect('vedoktashantiadmin');
			}
			if($vedoktashantiData->fstatus!=1 || $vedoktashantiData->user_id)
			{
				$this->logaction->log($this->service,"Reply Page - Invalid Status or state - ".$id);
				$this->session->set_flashdata("vedoktashanti_error",1);
				redirect('vedoktashantiadmin');
			}
			if($vedoktashantiData->checked_in==0)
			{
				$this->logaction->log($this->service,"Reply Page - Invalid Status or state - ".$id);
				$this->session->set_flashdata("vedoktashanti_error",1);
				redirect('vedoktashantiadmin');
			}

			if($this->currentUser->id!=$vedoktashantiData->checked_in_user_id)
			{
				$this->logaction->log($this->service,"Reply Page - Invalid Status or state - ".$id);
				$this->session->set_flashdata("vedoktashanti_error",1);
				redirect('vedoktashantiadmin');
			}

			$views = array( 'vedoktashanti/admin/reply');
			$data = array('views'=>$views,'vedoktashantiData'=>$vedoktashantiData,'id'=>$id);

			$this->load->view(ADMIN_TEMPLATE,$data);
		}
		else
		{
			$this->logaction->log($this->service,"Reply - Invalid ID format - ".$id);
			redirect('vedoktashantiadmin');
		}
	}

	public function reply_ts($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$vedoktashantiData=$this->vedoktashanti_model->vedoktashantiData($id);
			if(empty($vedoktashantiData))
			{
				$this->logaction->log($this->service,"VedoktaShanti Request Reply - Invalid ID - ".$id);
				goto end;
			}
			if($vedoktashantiData->fstatus==4)
			{
				$this->logaction->log($this->service,"VedoktaShanti Request Reply - Invalid Status - ".$id);
				goto end;
			}
			if($vedoktashantiData->checked_in==0)
			{
				$this->logaction->log($this->service,"VedoktaShanti Request Reply - Invalid checkin - ".$id);
				goto end;
			}

			if($this->currentUser->id!=$vedoktashantiData->checked_in_user_id)
			{
				$this->logaction->log($this->service,"VedoktaShanti Request Reply - Not checkedin user - ".$id);
				goto end;
			}

			$this->form_validation->set_rules('reply', 'Reply', 'trim|max_length[10000]');
			if($this->form_validation->run() == FALSE)
			{
				goto end;
			}

			$data['date']=$this->vedoktashanti_admin_user_replies_model->captureReply($id,$_POST['reply'],$vedoktashantiData,1);
			$data['flag']=1;
		}
		end:
		echo json_encode($data);
	}
	
	public function reply_mail($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$vedoktashantiData=$this->vedoktashanti_model->vedoktashantiData($id);
			if(empty($vedoktashantiData))
			{
				$this->logaction->log($this->service,"Reply page - Invalid ID - ".$id);
				$this->session->set_flashdata("vedoktashanti_error",1);
				redirect('vedoktashantiadmin');
			}
			if($vedoktashantiData->fstatus!=1 || $vedoktashantiData->user_id)
			{
				$this->logaction->log($this->service,"Reply Page - Invalid Status or state - ".$id);
				$this->session->set_flashdata("vedoktashanti_error",1);
				redirect('vedoktashantiadmin');	
			}

			if($vedoktashantiData->checked_in==0)
			{
				$this->logaction->log($this->service,"Reply Page - Invalid checkedin - ".$id);
				$this->session->set_flashdata("vedoktashanti_error",1);
				redirect('vedoktashantiadmin');
			}

			if($this->currentUser->id!=$vedoktashantiData->checked_in_user_id)
			{
				$this->logaction->log($this->service,"Reply Page - Invalid not checkedin user - ".$id);
				$this->session->set_flashdata("vedoktashanti_error",1);
				redirect('vedoktashantiadmin');
			}

			if(!isset($_POST['content']))
			{
				$this->session->set_flashdata("vedoktashanti_error",1);
				redirect('vedoktashantiadmin/vedoktashanti_reply/'.$id);
			}
			// $this->form_validation->set_rules('subject', 'Subject', 'trim|min_length[6]|max_length[200]');
			// if($this->form_validation->run() == FALSE)
			// {
			// 	$this->session->set_flashdata("vedoktashanti_error",1);
			// 	redirect('vedoktashantiadmin/vedoktashanti_reply/'.$id);
			// }

			if(isset($_FILES['file1']) && $_FILES['file1']['name']!='')
			{
				if($_FILES['file1']['size']==0 || $_FILES['file1']['size']>(1*1024*1024))
				{
					$this->session->set_flashdata("vedoktashanti_error",1);
					redirect('vedoktashantiadmin/vedoktashanti_reply/'.$id);
				}
			}
			if(isset($_FILES['file2']) && $_FILES['file2']['name']!='')
			{
				if($_FILES['file2']['size']==0 || $_FILES['file2']['size']>(1*1024*1024))
				{
					$this->session->set_flashdata("vedoktashanti_error",1);
					redirect('vedoktashantiadmin/vedoktashanti_reply/'.$id);
				}
			}
			if(isset($_FILES['file3']) && $_FILES['file3']['name']!='')
			{
				if($_FILES['file3']['size']==0 || $_FILES['file3']['size']>(1*1024*1024))
				{
					$this->session->set_flashdata("vedoktashanti_error",1);
					redirect('vedoktashantiadmin/vedoktashanti_reply/'.$id);
				}
			}

			$res=$this->vedoktashanti_admin_user_replies_model->captureMailReply($id,$vedoktashantiData, site_name_string1." -  Update to VedoktaShanti request: ".$vedoktashantiData->vedoktashanti_id,$_POST['content']);
			$this->session->set_flashdata("email_sent",1);
			redirect("vedoktashanti/view/".$id);
		}
		else
		{
			$this->logaction->log($this->service,"Reply - Invalid ID format - ".$id);
			redirect('vedoktashantiadmin');
		}
	}

	public function send_to($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$vedoktashantiData=$this->vedoktashanti_model->vedoktashantiData($id);
			if(empty($vedoktashantiData))
			{
				$this->logaction->log($this->service,"VedoktaShanti Reply - Invalid ID - ".$id);
				goto end;
			}
			
			$this->form_validation->set_rules('send_to', 'Email ID', 'trim|min_length[6]|max_length[100]|valid_email_custom');
			if($this->form_validation->run() == FALSE)
			{
				goto end;
			}

			$this->vedoktashanti_model->sendTo($id,$_POST['send_to'],$vedoktashantiData);
			$data['flag']=1;
		}
		end:
		header("Content-Type:application/json");
		echo json_encode($data);
	}

	public function attachment($id=0,$no="")
	{
		$flag=0;
		if(is_numeric($id) && $id)
		{
			$vedoktashantiData=$this->vedoktashanti_model->vedoktashantiData($id);
			if(empty($vedoktashantiData))
			{
				goto end;
			}
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key, "secretKey"=>aws_s3_secret_key, "useSSL"=>false, "endpoint"=>"s3.amazonaws.com"));
			$filename = $vedoktashantiData->file;
			if($no==2)
				$filename = $vedoktashantiData->file2;
			if($no==3)
				$filename = $vedoktashantiData->file3;
			$amazonUri="vedoktashanti/".date("Y",strtotime($vedoktashantiData->date))."/".$filename;
			header("Cache-Control: public");
	        header("Content-Disposition: attachment; filename=".$filename);
			$obj=$this->s3->getObject(aws_s3_bucket_name,$amazonUri);
			echo $obj->body;
			return;
		}
		end:
		if($flag==0)
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	public function replyattachment($id=0,$no="")
	{
		$flag=0;
		if(is_numeric($id) && $id)
		{
			$replyData=$this->vedoktashanti_admin_user_replies_model->replyData($id);
			if(empty($replyData))
			{
				goto end;
			}
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key, "secretKey"=>aws_s3_secret_key, "useSSL"=>false, "endpoint"=>"s3.amazonaws.com"));
			$filename = $replyData->file;
			if($no==2)
				$filename = $replyData->file2;
			if($no==3)
				$filename = $replyData->file3;
			$amazonUri="vedokta_replies/".date("Y",strtotime($replyData->date))."/".$filename;
			header("Cache-Control: public");
	        header("Content-Disposition: attachment; filename=".$filename);
			$obj=$this->s3->getObject(aws_s3_bucket_name,$amazonUri);
			echo $obj->body;
			return;
		}
		end:
		if($flag==0)
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	public function uploadthreadattachments($id=0)
	{
		$flag=0;
		if(is_numeric($id) && $id)
		{
			$vedoktashantiData=$this->vedoktashanti_model->vedoktashantiData($id);
			if(empty($vedoktashantiData))
			{
				goto end;
			}
			if(empty($_FILES['file1']) && empty($_FILES['file2']) && empty($_FILES['file3']))
			{
				goto end;
			}
			if(isset($_FILES['file1']) && $_FILES['file1']['name']!='')
			{
				if($_FILES['file1']['size']==0 || $_FILES['file1']['size']>(1*1024*1024))
					goto end;
			}
			if(isset($_FILES['file2']) && $_FILES['file2']['name']!='')
			{
				if($_FILES['file2']['size']==0 || $_FILES['file2']['size']>(1*1024*1024))
					goto end;
			}
			if(isset($_FILES['file3']) && $_FILES['file3']['name']!='')
			{
				if($_FILES['file3']['size']==0 || $_FILES['file3']['size']>(1*1024*1024))
					goto end;
			}
			$uploaded = $this->vedoktashanti_model->uploadthreadattachments($id);
			if($uploaded == 1)
			{
				$this->session->set_flashdata("upload_success",1);
			}
			else
			{
				$this->session->set_flashdata("upload_error",1);
			}
			redirect('vedoktashantiadmin/view/'.$id);
			return;
		}
		end:
		if($flag==0)
		{
			$this->session->set_flashdata("upload_error",1);
			redirect('vedoktashantiadmin/view/'.$id);
		}
	}

	public function createticket()
	{
		$views = array( 'vedoktashanti/admin/add_edit_vedoktashanti');
		$data = array('views'=>$views);
		$countries=$this->locations_model->getCountries();
        $data["country"]=$countries;
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function standardreplies()
	{
		$views = array( 'vedoktashanti/admin/standardreplieslist');
		$data = array('views'=>$views);
		$data['categories']=$this->vedoktashanti_standard_replies_category_model->getCategories();
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function liststandardreplies($excel=0)
	{
		$list=$this->vedoktashanti_standard_replies_model->listStandardRepliesAjaxAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Standard Replies listing ajax request");
	}

	public function add_edit_standardreply($id=0)
	{
		if(isset($_POST["add_standardreply"]))
		{	
			$this->form_validation->set_rules('standardreply', 'Standard Reply', 'trim|required|min_length[3]|max_length[100]');
			$this->form_validation->set_rules('answer', 'Answer', 'trim|required|min_length[10]|max_length[5000]');
			$this->form_validation->set_rules('standardreply_category', 'Standard Reply Category', 'trim|required|checkStandardReplyCategory');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("standardreply_error",1);
				redirect('vedoktashantiadmin/add_edit_standardreply/'.$id);
				return;
			}
			if($id)
			{
				$standardreplyData=$this->vedoktashanti_standard_replies_model->standardreplyData($id);
				if(empty($standardreplyData))
				{
					$this->session->set_flashdata("standardreply_error",1);
					redirect("/vedoktashantiadmin");
				}
			}

			$saved=$this->vedoktashanti_standard_replies_model->save($id);
			if($saved)
			{
				if($id)
						$this->session->set_flashdata("standardreply_saved",1);
				else
				{
					$this->session->set_flashdata("standardreply_created",1);
				}
			}
			redirect('vedoktashantiadmin/add_edit_standardreply/'.$saved);
			
		}
		else
		{
			
		 	$views = array( 'vedoktashanti/admin/add_edit_standardreply' );
		 	$data = array('views'=>$views,'id'=>$id);
		 	$data['categories']=$this->vedoktashanti_standard_replies_category_model->getCategories();
			if($id)
			{
				$data['standardreply_data']=$this->vedoktashanti_standard_replies_model->standardreplyData($id);
				if(empty($data['standardreply_data']))
				{
					$this->session->set_flashdata("standardreply_error",1);
					redirect("/vedoktashantiadmin");
				}
			}
		 	$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	function deletestandardreply($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$standardreplyData=$this->vedoktashanti_standard_replies_model->standardreplyData($id);
			if(!empty($standardreplyData))
			{
				$r=$this->vedoktashanti_standard_replies_model->delete($id,$standardreplyData);
				if($r)
				{
					$data['flag']=1;
					$data['id']=$standardreplyData->fid;
				}
			}
		}
		echo json_encode($data);
	}

	public function standardreplycategories()
	{
		$views = array( 'vedoktashanti/admin/standardreplycategorieslist' );
		$data = array('views'=>$views);
	 	$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function liststandardreplycategories($excel=0)
	{
		$list=$this->vedoktashanti_standard_replies_category_model->listCatsAjaxAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Standard Reply Categories listing ajax request");
		
	}

	public function add_edit_standardreply_category($id=0)
	{
		if(isset($_POST["add_standardreplycat"]))
		{	
			$this->form_validation->set_rules('category', 'Category', 'trim|required|min_length[3]|max_length[20]|checkStandardReplyCategoryExist['.$id.']');

			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("standardreplycat_error",1);
				redirect('vedoktashantiadmin/add_edit_standardreply_category/'.$id);
				return;
			}
			if($id)
			{
				$catData=$this->vedoktashanti_standard_replies_category_model->catData($id);
				if(empty($catData))
				{
					$this->session->set_flashdata("standardreplycat_error",1);
					redirect("/vedoktashantiadmin/standardreplycategories");
				}
			}

			$saved=$this->vedoktashanti_standard_replies_category_model->save($id);
			if($saved)
			{
				if($id)
						$this->session->set_flashdata("category_saved",1);
				else
				{
					$this->session->set_flashdata("category_created",1);
				}
			}
			redirect('vedoktashantiadmin/add_edit_standardreply_category/'.$saved);
			
		}
		else
		{
			
		 	$views = array( 'vedoktashanti/admin/add_edit_standardreply_category' );
		 	$data = array('views'=>$views,'id'=>$id);
			if($id)
			{
				$data['cat_data']=$this->vedoktashanti_standard_replies_category_model->catData($id);
				if(empty($data['cat_data']))
				{
					$this->session->set_flashdata("standardreplycat_error",1);
					redirect("/vedoktashantiadmin/standardreplycategories");
				}
			}
		 	$this->load->view(ADMIN_TEMPLATE,$data);  
		}
	}

	public function updatestandardreplycategoryorder()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric|checkStandardReplyCategory');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->vedoktashanti_standard_replies_category_model->updateOrder($_POST['pk'],$_POST['value']);
		echo 1;
	}
	
	function deletestandardreplycategory($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$catData=$this->vedoktashanti_standard_replies_category_model->catData($id);
			if(!empty($catData))
			{
				$standardreplies=$this->vedoktashanti_standard_replies_model->getStandardRepliesByCategory($id);
				if(empty($standardreplies))
				{
					$r=$this->vedoktashanti_standard_replies_category_model->delete($id,$catData);
					if($r)
					{
						$data['flag']=1;
						$data['category']=$catData->category;
					}
				}
				else
				{
					$data['flag']=2;
					$data['category']=$catData->category;
				}
			}
		}
		echo json_encode($data);
	}

	public function standardreplycategory_check()
	{
		$exist=$this->vedoktashanti_standard_replies_category_model->standardreplycat_exist($_POST['id'],$_POST['category']);
		if($exist) echo 0;
		else echo 1;
	}

	public function listemails(){}
	public function email_data(){}
	public function email_resend(){}
	public function bulk_resend(){}
}
?>