<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Timeline extends CI_Controller 
{
    function __construct() 
	{
        parent::__construct();
		
		if($this->session->userdata('id'))
        	$this->currentUser=$this->session->userdata("admin_data");
       	else
       		$this->currentUser=$this->session->userdata("user_data");
       	$this->load->model("timeline_model");

		/*if(!$this->session->userdata('username') && $this->uri->segment(2)!='')
		{
			redirect('/');
		}
		else
		{
			if($this->uri->segment(2)!='' && $this->session->userdata('admin')!=1)
			{
					redirect('myaccount');
			}
		}*/
    }
    
    public function index() 
	{
		if($this->session->userdata("role")==1 && $this->session->userdata("admin")==1 && 0)
		{
		   $views = array( 'timeline');
		   $data = array('views'=>$views);
		   $this->load->view('admin/admin_template',$data);
		}
		else
		{
			$views = array( 'timeline/public/timeline');
		   	$data = array('views'=>$views);
		   	$data['timeline_entries']=$this->timeline_model->get_list();
		   	$this->load->view(FRONTEND_TEMPLATE,$data);
		}
    }
    
	public function add_edit_timeline($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$timelineEntry=$this->timeline_model->getEntry($id);
			if(empty($timelineEntry))
			{
				$this->session->set_flashdata("timeline_error",1);
				redirect('timeline');
			}

		}
		else
		{
			$timelineEntry=array();
		}

		if(isset($_POST["save_timeline"]))
		{
			if(!isset($_POST['content']))
			{
				$this->session->set_flashdata('timeline_error',1);
				redirect("timeline/add_edit_timeline/".$id);
			}

			if(isset($_FILES['timeline_image']['name']) && $_FILES['timeline_image']['name']!='')
			{
				$allowed_file_types =   array('image/jpeg','image/jpg','image/png');
				$ext=pathinfo ($_FILES['timeline_image']['name'],PATHINFO_EXTENSION);
				if($_FILES['timeline_image']['size']==0 || $ext=='' || !in_array($_FILES['timeline_image']['type'],$allowed_file_types) ||
						$_FILES['timeline_image']['size']>(1024*1024))
				{
					$this->session->set_flashdata("timeline_error",1);
					redirect('timeline/add_edit_timeline/'.$id);
				}
			}

			$this->form_validation->set_rules('title', 'Title', 'trim|required|min_length[6]|max_length[200]');
			$this->form_validation->set_rules('location', 'Location', 'trim|required|min_length[6]|max_length[200]');
			$this->form_validation->set_rules('date', 'Date', 'trim|required|valid_date');


			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("timeline_error",1);
				redirect("timeline/add_edit_timeline/".$id);
				return;
			}

			$saved=$this->timeline_model->save($id,$timelineEntry);
			if($id==0)
			{
				$this->session->set_flashdata("timeline_created",1);
			}
			else
				$this->session->set_flashdata("timeline_saved",1);

			redirect("timeline/add_edit_timeline/".$saved);
		}
		else
		{
			if($id!='' && (empty($timelineEntry)) )
			{
				redirect('timeline');
			}
			$views = array('timeline/admin/add_edit_timeline');
			$data = array('views'=>$views,'id'=>$id);
			if(is_numeric($id) && $id)
			{
				$data['timelineEntry']=$timelineEntry;
			}
			$this->load->view(ADMIN_TEMPLATE,$data); 
		}
	}
	
	public function remove($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$timelineEntry=$this->timeline_model->getEntry($id);
			if(!empty($timelineEntry))
			{
				$this->timeline_model->delete($id);
				echo 1;
			}
		}
		else echo 0;
	}
	
	public function save()
	{
		if($this->session->userdata("role")==1 && $this->session->userdata("admin")==1)
		{
		}
		else
		{
			exit(0);
		}
		$date=date("Y:m:d H:i:s",strtotime($_POST['date']));
		if($_POST['id'])
		{
			$this->db->where('id',$_POST['id']);
			
			$q=$this->db->update('timeline',
                                array('title' =>trim($_POST["title"]),
									'content' => trim($_POST["content"]),
									'date' => $date,
									'display_year'=>$_POST['display_year'],
									'modified_on' => date("Y:m:d H:i:s"),
									'modified_by' => $this->session->userdata('id'),
									'location' => trim($_POST["location"])
								)
								);
			$idd=$_POST['id'];
		}
		else
		{
			
			 $q=$this->db->insert('timeline',
                                array('title' =>trim($_POST["title"]),
									'content' => trim($_POST["content"]),
									'created_on' => date("Y:m:d H:i:s"),
									'date' => $date,
									'display_year'=>$_POST['display_year'],
									'created_by' => $this->session->userdata('id'),
									'modified_on' => date("Y:m:d H:i:s"),
									'modified_by' => $this->session->userdata('id'),
									'location' => trim($_POST["location"])
								)
								);
			$idd=$this->db->insert_id();
		}
		
		echo $idd;
	}
}
?>