<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Subscriptionsadmin extends CI_Controller 
{
	var $service='subscriptions';
    function __construct() 
	{
        parent::__construct();
        $this->load->model('ashrams/ashrams_model');
		$this->load->model('ashrams/subscriptions_model');
		$this->load->model('ashrams/subscriptions_bundle_model');
		$this->load->model('ashrams/subscriptions_categories_model');
		$this->currentUser=$this->session->userdata("admin_data");
		if(is_single_ashram_site)
        { 
            $this->session->set_userdata("ashramId",default_ashram_id); 
		}
		if(!$this->session->userdata("ashramId"))
		{
			$this->session->set_userdata("ashramId",0);
		}
		$ft="+12 months";
		$d=date("d M Y",strtotime($ft,strtotime("25 Aug 2018"))+(60*60*24));
		//echo $d;

		//exit;
    }

	function index()
	{
		$views = array( 'ashrams/admin/list_subscriptions' );
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		if($this->session->userdata("ashramId")>0)
			$subscriptionsCategories=$this->subscriptions_categories_model->getCategoriesListByAshramId($this->session->userdata("ashramId"));
		else
			$subscriptionsCategories=$this->subscriptions_categories_model->getList();
		$data['categories']=$subscriptionsCategories;
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Subscriptions Listing");
	}

	public function listc($excel=0)
	{
		if($this->session->userdata("ashramId"))
		{
			$list=$this->subscriptions_model->listAdmin($this->session->userdata("ashramId"),$excel);
			echo json_encode($list);
			$this->logaction->log($this->service,"Admin - Viewed Subscriptions Listing ajax request");
		}
	}

	public function categories()
	{
		$views = array( 'ashrams/admin/list_subscriptions_categories');
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function listcats($excel=0)
	{
		if($this->session->userdata("ashramId"))
		{
			$list=$this->subscriptions_categories_model->listAdmin($this->session->userdata("ashramId"),$excel);
			echo json_encode($list);
			$this->logaction->log($this->service,"Admin - Viewed Subscriptions categories listing ajax request");
		}
	}

	public function add_edit_category($id=0)
	{
		if($id)
		{
			$categoryData=$this->subscriptions_categories_model->categoryData($id);
			if(empty($categoryData))
			{
				$this->session->set_flashdata("cat_error",1);
				redirect("/subscriptionsadmin/categories");
			}
			if($this->currentUser->roles!=1 && ($categoryData->category_ashram_id!=$this->session->userdata("ashramId")))
        	{
        		$this->session->set_flashdata("cat_error",1);
				redirect("/subscriptionsadmin/categories");
        	}
		}
		else
			$categoryData=array();

		if(isset($_POST["add_category"]))
		{
			$this->form_validation->set_rules('name', 'Category name', 'trim|required|min_length[3]|max_length[200]|check_subscriptions_category['.$id.']');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("cat_error",1);
				redirect('subscriptionsadmin/add_edit_category/'.$id);
				return;
			}
			
			$saved=$this->subscriptions_categories_model->save($id,$categoryData);
			if($saved)
			{
				if($id)
						$this->session->set_flashdata("cat_saved",1);
				else
				{
					$this->session->set_flashdata("cat_created",1);
				}
			}
			redirect('subscriptionsadmin/add_edit_category/'.$saved);
		}
		else
		{	
		 	$views = array( 'ashrams/admin/add_edit_subscription_category' );
		 	$data = array('views'=>$views,'id'=>$id);
		 	if($this->currentUser->roles==1)
        	{
        		$data['ashrams']=$this->ashrams_model->getList();
        	}
        	$data['ashramData']=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
			if($id)
			{
				$data['categoryData']=$categoryData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	function delete_category($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$categoryData=$this->subscriptions_categories_model->categoryData($id);
			if(empty($categoryData))
			{
				goto end;
			}
			if($categoryData->in_use>0)
			{
				$data['flag']=2;
				$data['name']=$categoryData->name;
				goto end;
			}

			$r=$this->subscriptions_categories_model->delete($id,$categoryData);
			if($r)
			{
				$data['flag']=1;
				$data['name']=$categoryData->name;
				$this->logaction->log($this->service,"Admin - Category '".$categoryData->name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}
	public function category_updateorder()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->subscriptions_categories_model->updateOrder($_POST['pk'],$_POST['value']);
		echo 1;
	}
	
	function add_edit_subscription($id=0)
	{
		if(!$this->session->userdata("ashramId"))
		{
			$this->session->set_flashdata("subscription_error",1);
			redirect('subscriptionsadmin');
		}

		if(is_numeric($id) && $id)
		{
			$subscriptionData=$this->subscriptions_model->subscriptionData($id);
			if(empty($subscriptionData))
			{
				$this->session->set_flashdata("subscription_error",1);
				redirect('subscriptionsadmin');
			}
			if($subscriptionData->ashram_id!=$this->session->userdata("ashramId"))
        	{
        		$this->session->set_flashdata("subscription_error",1);
				redirect("subscriptionsadmin");
        	}
		}
		else
		{
			$subscriptionData=array();
		}

		$this->load->model('currencies_model');
		$ashramCurrencies = $this->currencies_model->getByAshram($this->session->userdata("ashramId"));

		if(isset($_POST["subscription_name"]))
		{
			if(isset($_FILES['subscription_image']['name']) && $_FILES['subscription_image']['name']!='')
			{
				$allowed_file_types =   array('image/jpeg','image/jpg','image/png');
				$ext=pathinfo ($_FILES['subscription_image']['name'],PATHINFO_EXTENSION);
				if($_FILES['subscription_image']['size']==0 || $ext=='' || !in_array($_FILES['subscription_image']['type'],$allowed_file_types) ||
						$_FILES['subscription_image']['size']>(1024*1024))
				{
					$this->session->set_flashdata("subscription_error",1);
					redirect('subscriptionsadmin/add_edit_subscription/'.$id);
				}
			}

			$this->form_validation->set_rules('subscription_name', 'Subscription Name', 'trim|required|min_length[3]|max_length[100]|checkSubscriptionName['.$id.']');
			$this->form_validation->set_rules('category', 'Category', 'trim|required|numeric|checkSubscriptionCategory');
			$this->form_validation->set_rules('description', 'Description', 'trim|required|min_length[3]|max_length[2000]');
			foreach ($ashramCurrencies as $currencyData)
			{
				$currencyparameters = strtolower($currencyData['currency']).' || '.$this->session->userdata("ashramId");
				$this->form_validation->set_rules('price_'.strtolower($currencyData['currency']), 'Price ('.$currencyData['currency'].')', 'trim|required|checkCurrencyValuesByAshram['.$currencyparameters.']');
			}
			$this->form_validation->set_rules('is_public_display', 'Is Public Diaply? ', 'trim|required|numeric|checkPublicDisplay');
			$this->form_validation->set_rules('have_personal_note', 'Have Personal Note? ', 'trim|required|numeric|checkPersonalNote');
			$this->form_validation->set_rules('is_external_link', 'Is external link? ', 'trim|required|checkExternalLinkFlag');
			$this->form_validation->set_rules('is_price_fixed', 'Is price fixed? ', 'trim|required|checkPriceFixedFlag');
			$this->form_validation->set_rules('shipping', 'Shipping', 'trim|required|numeric|checkItemShipping');
			if($this->input->post("is_external_link")==1)
				$this->form_validation->set_rules('external_link', 'External link', 'trim|required|valid_url');

			if($this->input->post("is_price_fixed")==0)
			{
				foreach ($ashramCurrencies as $currencyData)
				{
					$minPriceCurrencyparameters = strtolower($currencyData['currency']).' || '.$this->session->userdata("ashramId");
					$this->form_validation->set_rules('min_price_'.strtolower($currencyData['currency']), 'Min. Price ('.$currencyData['currency'].')', 'trim|required|checkCurrencyValuesByAshram['.$minPriceCurrencyparameters.']');
				}
				if($this->input->post("display_suggested_text")==1)
				{
					$this->form_validation->set_rules('suggested_text', 'Suggested text', 'trim|required|min_length[3]|max_length[100]');
				}


			}

			$this->form_validation->set_rules('partial_payments_allowed', 'Partial payments', 'trim|required|numeric|checkPartialPaymentOption');

			if($this->input->post("shipping")==1)
			{
				foreach ($GLOBALS['currencies'] as $currencyData)
				{
					$this->form_validation->set_rules('shipping_domestic_'.strtolower($currencyData['currency']), 'Shipping domestic Price ('.$currencyData['currency'].')', 'trim|required|numeric|max_length[4]');
					$this->form_validation->set_rules('shipping_international_'.strtolower($currencyData['currency']), 'Shipping international Price ('.$currencyData['currency'].')', 'trim|required|numeric|max_length[4]');
				}
			}
			
			foreach ($GLOBALS['currencies'] as $currencyData)
			{
				$this->form_validation->set_rules('onetime_charge_'.strtolower($currencyData['currency']), 'One time charge ('.$currencyData['currency'].')', 'trim|checkOneTimeChargeValues['.strtolower($currencyData['currency']).']');
			}

			$this->form_validation->set_rules('period', 'Period', 'trim|required|checkSubscriptionPeriods');
			$this->form_validation->set_rules('subscription_payment_type', 'Subscription Payments ', 'trim|required|checkSubscriptionsubscriptionPaymentType');
			$this->form_validation->set_rules('frequency', 'Frequency', 'trim|required|numeric|checkSubscriptionFrequency['.$this->input->post("period").']');
			$this->form_validation->set_rules('expiration_method', 'Expiration type', 'trim|required|numeric|checkSubscriptionExpirationType');
			if($this->input->post("expiration_method")==1)
			{
				$this->form_validation->set_rules('num_of_payments', 'Num of payments', 'trim|required|numeric|checkSubscriptionNumPayments');
			}
			if($this->input->post("expiration_method")==2)
			{
				$this->form_validation->set_rules('expiry_date', 'Expiry date', 'trim|required|valid_date');
			}

			if($this->input->post("is_bundle")=='on')
			{
				$this->form_validation->set_rules('subscription_ids', 'Subscriptions', 'trim|required|checkSubscriptions['.$id.']');
			}

			$this->form_validation->set_rules('only_for_admin', 'Only for Admin? ', 'trim|required|checkSubscriptionIsOnlyForAdmin');
			$this->form_validation->set_rules('is_secret', 'Is Secret? ', 'trim|required|checkIsSecretSubscription');
			if($this->input->post("is_secret")==1)
			{
				$this->form_validation->set_rules('s_key', 'Secret Key', 'trim|min_length[2]|max_length[64]|checkAlphaNumericUnderscoreDashOnly|checkSubscriptionSecretKeyExists['.$id.']');
			}
			$this->form_validation->set_rules('item_key', 'Item Key', 'trim|min_length[2]|max_length[64]|checkAlphaNumericUnderscoreDashOnly|checkSubscriptionItemKeyExists['.$id.']');

			$this->form_validation->set_rules('display_only_popup', 'Display Only Popup? ', 'trim|required|checkSubscriptionDisplayOnlyPopup');
			if($this->input->post("display_only_popup")==1)
			{
				$this->form_validation->set_rules('popup_content', 'Popup Content', 'trim|required|min_length[3]|max_length[1000]');
			}

			$this->form_validation->set_rules('having_custom_email', 'Custom Email? ', 'trim|required|checkSubscriptionHavingCustomEmail');
			if($this->input->post("having_custom_email")==1)
			{
				$this->form_validation->set_rules('custom_email_text', 'Custom Email Text', 'trim|required|min_length[3]|max_length[10000]');
			}

			$this->form_validation->set_rules('having_custom_sms', 'Custom SMS? ', 'trim|required|checkSubscriptionHavingCustomSms');
			if($this->input->post("having_custom_sms")==1)
			{
				$this->form_validation->set_rules('custom_sms_text', 'Custom SMS Text', 'trim|required|min_length[6]|max_length[320]');
			}

			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("subscription_error",1);
				redirect('subscriptionsadmin/add_edit_subscription/'.$id);
				return;
			}
			$saved=$this->subscriptions_model->save($id,$subscriptionData);
			if($id==0)
			{
				$this->session->set_flashdata("subscription_created",1);
			}
			else
			{
				$this->session->set_flashdata("subscription_saved",1);
			}
			redirect('subscriptionsadmin/add_edit_subscription/'.$saved);
		}
		else
		{
			if($id>0 && (empty($subscriptionData)) )
			{
				redirect('subscriptionsadmin');
			}
			$views = array('ashrams/admin/add_edit_subscription');
			$data = array('views'=>$views,'id'=>$id);
			if($this->currentUser->roles==1)
        	{
        		$data['ashrams']=$this->ashrams_model->getList();
        	}
			$data['ashramData']=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
			if(is_numeric($id) && $id)
			{
				$data['subscriptionData']=$subscriptionData;
				$data['bundle']=$this->subscriptions_bundle_model->getBySubscription($id);
			}
			$data['categories']=$this->subscriptions_categories_model->getCategoriesListByAshramId($this->session->userdata("ashramId"));
			$data['ashramCurrencies'] = $ashramCurrencies;
			// $data['categories']=$this->subscriptions_categories_model->getList();
			$this->load->view(ADMIN_TEMPLATE,$data); 
		}
	}

	function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id && $this->session->userdata("ashramId"))
		{
			$subscriptionData=$this->subscriptions_model->subscriptionData($id);
			if(empty($subscriptionData))
			{
				goto end;
			}
			$r=$this->subscriptions_model->delete($id,$subscriptionData);
			if($r)
			{
				$data['flag']=1;
				$data['subscription_name']=$subscriptionData->subscription_name;
				$this->logaction->log($this->service,"Admin - Subscription '".$subscriptionData->subscription_name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}

	public function changestatus($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id && $this->session->userdata("ashramId") && isset($_POST['status']) && is_numeric($_POST['status']) && in_array($_POST['status'],array(0,1)))
		{
			$subscriptionData=$this->subscriptions_model->subscriptionData($id);
			if(empty($subscriptionData))
			{
				goto end;
			}
			$data['subscription_name']=$subscriptionData->subscription_name;
			if($subscriptionData->status==$_POST['status'])
			{
				$data['flag']=2;
				goto end;
			}
			$this->subscriptions_model->changeStatus($id,$_POST['status']);
			
			$data['flag']=1;
			
			if($_POST['status']==1)
				$this->logaction->log($this->service,"Admin - Subscription '".$subscriptionData->subscription_name."' activated - ".$id);
			else
				$this->logaction->log($this->service,"Admin - Subscription '".$subscriptionData->subscription_name."' deactivated - ".$id);
		}
		end:
		echo json_encode($data);
	}

	public function namecheck($id=0)
	{
		if(!$this->session->userdata("ashramId"))
		{
			echo 'false';
			return;
		}
		if(isset($_POST['subscription_name']) && $_POST['subscription_name']!='')
		{
			if(is_numeric($id))
			{
				$flag=$this->subscriptions_model->checkSubscriptionName($this->general_model->filtertext(trim($_POST['subscription_name'])),$id);
				if($flag==1)
					echo 'false';
				else
					echo 'true';
			}
			else
				echo 'false';
		}
	}

	public function categorycheckname($id=0)
	{
		if($this->input->post('name')!='')
		{
			$slug=url_title($this->general_model->filtertext($this->input->post('name')));
			
			if(is_numeric($id))
			{
				$flag=$this->subscriptions_categories_model->checkName($this->general_model->filtertext(trim($this->input->post('name'))),$id);
				if($flag==1)
					echo 2;
				else
					echo 1;
			}
			else
				echo 0;
		}
	}

	public function searchsubscription($id=0)
	{
		$query = (!empty($_GET['q'])) ? strtolower($_GET['q']) : null;
		if (!isset($query)) {
		    die('Invalid query.');
		}
		$status = true;
		$subscriptionsData=$this->subscriptions_model->searchSubscriptions($query,2);
		$resultSubscriptions = [];
		$c=0;
		foreach ($subscriptionsData as $subscriptionItem)
		{
			if($subscriptionItem->id==$id)
				continue;
			$resultSubscriptions[$c]['id'] = $subscriptionItem->id;
			$resultSubscriptions[$c]['name'] = $subscriptionItem->subscription_name;
			$c++;
		}
		echo json_encode($resultSubscriptions);
	}
	public function subscription_updateorder()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->subscriptions_model->updateOrder($_POST['pk'],$_POST['value']);
		echo 1;
	}

	public function adminUpdateSubscriptionFamilyDonor()
	{
		$this->form_validation->set_rules('orderItemId', 'orderItemId', 'trim|required|numeric');
		$this->form_validation->set_rules('familyType', 'Condition', 'trim|required');
		$this->form_validation->set_rules('userId', 'User Id', 'trim|required|numeric');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$update = $this->subscriptions_model->updateOrderFamilyMemberDonorDetails($_POST);
		if($update)
			echo 1;
		else
			echo 0;
	}
}
?>