<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Subscriptions extends CI_Controller 
{
	var $service="cart";
	var $currentUser='';
	var $pageName="Subscriptions";
	var $currencies;
    function __construct() 
	{
        parent::__construct();
        $this->load->model('ashrams/ashrams_model');
		$this->load->model('ashrams/subscriptions_model');
		$this->load->model('ashrams/ashrams_trust_accounts_model');
		$this->load->model('currencies_model');
		$this->load->model('orders/order_log_model');
		$this->load->model('orders/transaction_model');
		$this->load->model('orders/payflow_logs_model');
		$this->load->model("subscriptions/donors_model");
		$this->load->model("orders/subscription_payments_model");
		$this->load->model("offline_model");
        $this->load->model("credit_cards_model");
        
        if($this->session->userdata('id'))
        	$this->currentUser=$this->session->userdata("admin_data");
       	else
       	{
       		if($this->session->userdata("force_change_password")==1)
			{
				$this->session->set_flashdata("reset_password_force",1);
				redirect("myaccount/change_password");
			}
       		$this->currentUser=$this->session->userdata("user_data");
       	}
       	if(empty($this->session->userdata("subscriptionCartAshramIdSelection")))
       	{
       		$this->session->unset_userdata("defaultCurrency");
       	}
        if(in_array(global_site_flag, [2]) && ($this->uri->segment(2)=='') && ($this->input->get("ashram_id")=='' || $this->input->get("currency")==''))
        {
            redirect("subscriptions?ashram_id=1&currency=inr");
        }
        if(in_array(global_site_flag, [4,7]) && ($this->uri->segment(2)=='') && ($this->input->get("ashram_id")=='' || $this->input->get("currency")==''))
        {
            redirect("subscriptions?ashram_id=1&currency=usd");
        }
        if(is_single_currency_site==1 && $this->input->get("currency")!='' && default_currency!=strtolower($this->input->get("currency")))
        {
            if(in_array(global_site_flag, [2,4]))
            {
                redirect("subscriptions?ashram_id=".default_ashram_id."&currency=".default_currency);
            }
            else
            {
                $this->session->unset_userdata("subscriptionCartAshramIdSelection");
	    		$this->session->unset_userdata("defaultCurrency");
	    		redirect("subscriptions");
            }
        }
        if(in_array(global_site_flag, [1]) && isset($_GET['ashram_id']) && $_GET['ashram_id']==4 && isset($_GET['currency']) && $_GET['currency']=='usd')
        {
        	redirect('https://sevas.yogasangeeta.org/subscriptions?ashram_id=1&currency=usd');
        }
       	if($this->input->get("ashram_id")!='')
       	{
       		$ashramData=$this->ashrams_model->ashramData($this->input->get("ashram_id"));
       		if(!empty($ashramData) && (is_numeric($this->input->get("ashram_id")) && $this->input->get("ashram_id") > 0) )
            {
       			$this->session->set_userdata("subscriptionCartAshramIdSelection",$this->input->get("ashram_id"));
                $this->session->set_userdata("subscriptionCartAshramId",$this->input->get("ashram_id"));
            }
            else
            {
            	$this->session->unset_userdata("subscriptionCartAshramIdSelection");
	    		$this->session->unset_userdata("defaultCurrency");
	    		redirect("subscriptions");
            }
       	}
       	if($this->session->userdata("subscriptionCartAshramIdSelection"))
       	{
	       	$this->currencies=$this->currencies_model->getByAshram($this->session->userdata("subscriptionCartAshramIdSelection"));
	    }

       	if($this->input->get("currency")!='')
       	{
       		if(isset($this->currencies[$this->input->get("currency")]))
       			$this->session->set_userdata("defaultCurrency",$this->input->get("currency"));
       	}
       	if($this->input->get("view")!='')
       	{
       		if(in_array($this->input->get("view"),array("itemView","listView")))
       			$this->session->set_userdata('subscriptionviewType', $this->input->get("view"));
       	}
       	$this->load->library('subscriptionscart');
	    $this->load->model('cart_model');
       	if(!empty($this->session->userdata("subscriptionCartAshramIdSelection")) && !empty($this->session->userdata("defaultCurrency")))
       	{
	       	$this->cart_model->validateCart($this->subscriptionscart);
       	}
    }
    public function index()
    {
    	if($GLOBALS['site_settings']['subscriptions']==0 && (!$this->session->userdata("id") || $this->session->userdata("admin_data")->roles!=1))
    	{
    		$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
    	}
    	if( appji_ashram_id>0 && ( ($this->session->userdata("subscriptionCartAshramIdSelection") == appji_ashram_id) || ($this->input->get("ashram_id") == appji_ashram_id)) )
        {
            $this->session->unset_userdata("subscriptionCartAshramIdSelection");
            $this->session->unset_userdata("defaultCurrency");
            redirect("subscriptions");
        }
    	if(empty($this->input->get("ashram_id")) && !empty($this->session->userdata("subscriptionCartAshramIdSelection")) && !empty($this->session->userdata("defaultCurrency")))
    	{
    		$this->session->unset_userdata("subscriptionCartAshramIdSelection");
    		$this->session->unset_userdata("defaultCurrency");
    		redirect("subscriptions");
    	}
    	if(!empty($this->session->userdata("subscriptionCartAshramIdSelection")) && empty($this->input->get("ashram_id")))
    	{
    		redirect("subscriptions?ashram_id=".$this->session->userdata("subscriptionCartAshramIdSelection"));
    	}
    	if(!empty($this->session->userdata("defaultCurrency")) && empty($this->input->get("currency")))
    	{
    		redirect("subscriptions?ashram_id=".$this->session->userdata("subscriptionCartAshramIdSelection")."&currency=".$this->session->userdata("defaultCurrency"));
    	}
    	if(!empty($this->session->userdata("defaultCurrency")) && !empty($this->session->userdata("subscriptionCartAshramIdSelection")) && !empty($this->session->userdata("subscriptionviewType")) && empty($this->input->get("view")))
    	{
    		redirect("subscriptions?ashram_id=".$this->session->userdata("subscriptionCartAshramIdSelection")."&currency=".$this->session->userdata("defaultCurrency")."&view=".$this->session->userdata('subscriptionviewType'));
    	}
    	if(!empty($this->session->userdata("subscriptionCartAshramIdSelection")))
       	{
	    	if($this->checkpublicdisplay()=="0")
	    	{
	    		$data['views'] = array('common/public/error');
				$this->load->view(FRONTEND_TEMPLATE,$data);
				return;
	    	}
    	}
    	$this->load->model('ashrams/ashrams_model');
    	$data['slug']="subscriptions";
    	if(empty($this->session->userdata("subscriptionCartAshramIdSelection")) || empty($this->session->userdata("defaultCurrency")))
		{
			$data['views'] = array('ashrams/public/cart_ashram_selection');
    		$data['ashramData']=$this->ashrams_model->ashramData($this->session->userdata("subscriptionCartAshramIdSelection"));
		}
		else
		{
			$data['cartObject']=$this->subscriptionscart;
    		$data['views'] = array('ashrams/public/list_subscriptions');
		}

        $cart=$this->subscriptionscart->contents();
        $cartCount = count($cart);
        if($cartCount>0)
        {
            foreach($cart as $thiscartitem)
            {
                if($this->session->userdata('subscriptionCartAshramId')!=$thiscartitem['options']['ashram_id'] && ($this->input->get("ashram_id")!=''))
                {
                    $ashramData=$this->ashrams_model->ashramData($thiscartitem['options']['ashram_id']);
                    $data['alertMessage'] = '<div class="alert alert-danger">
                                                <button class="close" data-dismiss="alert"></button>
                                                <strong>JGD. You cart has items from "'.$ashramData->name.'" ashram / event. If you wish to add items from another ashram / event, empty the cart and try again.</strong>
                                                <a href="#clearCartModal" class="btn btn-danger btn-xs" data-toggle="modal" style="margin-left: 10px;"><i class="fa fa-times"></i> Clear Cart</a>
                                            </div>';
                }
            }
        }
    	
    	// $data['ashrams']=$this->ashrams_model->getList();
    	$data['ashrams']=$this->ashrams_model->getOnlyActiveSubscriptionItemsAshramList();
	    $ashramids = array_column($data['ashrams'], 'id');
	    if($this->session->userdata("subscriptionCartAshramIdSelection")>0 && !in_array($this->session->userdata("subscriptionCartAshramIdSelection"),$ashramids))
	    {
	    	redirect("subscriptions");
	    }
		$this->load->view(FRONTEND_TEMPLATE,$data);
		if(!empty($this->session->userdata("subscriptionCartAshramIdSelection")))
			$this->cart_log_model->log("Navigated to subscriptions page :".current_url(),$this->session->userdata("subscriptionCartAshramIdSelection"),4);
    }
    public function checkpublicdisplay()
    {
    	$ashramData=$this->ashrams_model->ashramData($this->session->userdata('subscriptionCartAshramIdSelection'));
        if($ashramData->is_public_display==0)
        {
            if(empty($this->currentUser))
                return "0";
            if(!empty($this->currentUser) && $this->currentUser->roles !=1 && $this->currentUser->roles !=4 && $this->currentUser->roles !=3)
				return "0";
        }
        else
        {
            return $this->session->userdata('subscriptionCartAshramIdSelection');
        }
    }
    public function changecurrency()
    {
    	if(isset($_POST['currency']) && $_POST['currency']!='')
    	{
    		if((($_POST['currency'] == 'inr' && $this->getPaymentMode($_POST['currency']) == 'razorpay') || ($_POST['currency'] == 'usd' && $this->getPaymentMode($_POST['currency']) == 'paypal')) && ( !empty($this->currentUser->admin) && $this->currentUser->admin != 1))
            {
    			$cart=$this->subscriptionscart->contents();
    			if(empty($cart))
		    	{
		    		foreach ($this->currencies as $currencyData)
	    			{
		    			if(strtolower($currencyData['currency'])==strtolower($_POST['currency']))
		    			{
		    				$this->session->set_userdata("defaultCurrency",strtolower($currencyData['currency']));
		    				$this->cart_log_model->log("Changed currency to :".strtoupper($currencyData['currency']),$this->session->userdata("subscriptionCartAshramIdSelection"),4);
		    				echo 1;
		    				return;
		    			}
	    			}
		    	}
                else if(count($cart) == 1)
                {
		    		foreach ($this->currencies as $currencyData)
	    			{
		    			if(strtolower($currencyData['currency'])==strtolower($_POST['currency']))
		    			{
		    				$this->session->set_userdata("defaultCurrency",strtolower($currencyData['currency']));
		    				$this->cart_log_model->log("Changed currency to :".strtoupper($currencyData['currency']),$this->session->userdata("subscriptionCartAshramIdSelection"),4);
		    				echo 1;
		    				return;
		    			}
	    			}
		    	}
                else if(count($cart) > 1)
                {
		    		$subcheck = "";
		    		foreach($cart as $key=>$val)
                    {
		            	$dd = $val['options']['subscription'];
		            	if($dd == 1)
		            		$subcheck = "true";
		        	}
		        	if($subcheck =="true")
                    {
		        		echo 2;
		        		return;
		        	}
                    else
                    {
		        		foreach ($this->currencies as $currencyData)
		    			{
			    			if(strtolower($currencyData['currency'])==strtolower($_POST['currency']))
			    			{
			    				$this->session->set_userdata("defaultCurrency",strtolower($currencyData['currency']));
			    				$this->cart_log_model->log("Changed currency to :".strtoupper($currencyData['currency']),$this->session->userdata("subscriptionCartAshramIdSelection"),4);
			    				echo 1;
			    				return;
			    			}
		    			}
		        	}
		    	}
    		} 
            else 
            {
                if(empty($this->currencies))
                {
                    echo 0;
                    return;
                }
	    		foreach ($this->currencies as $currencyData)
	    		{
	    			if(strtolower($currencyData['currency'])==strtolower($_POST['currency']))
	    			{
	    				$this->session->set_userdata("defaultCurrency",strtolower($currencyData['currency']));
	    				$this->cart_log_model->log("Changed currency to :".strtoupper($currencyData['currency']),$this->session->userdata("subscriptionCartAshramIdSelection"),4);
	    				if(!empty($this->session->userdata("subscriptionCartAshramIdSelection")) && !empty($this->session->userdata("defaultCurrency")))
	    					$this->cart_model->validateCart($this->subscriptionscart);
	    				echo 1;
	    				return;
	    			}
	    		}
	    	}
	    	echo 0;
	    }
    }
    public function getPaymentMode($currency = "")
    {
        if($currency == "")
        {
            $currency = $this->session->userdata("defaultCurrency");
        }
    	$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($this->session->userdata("subscriptionCartAshramIdSelection"),4);
        $trustsArray=array();
        foreach ($trusts as $trustData)
        {
            $trustsArray[$trustData->currency]=$trustData;
        }
        $trustData=$trustsArray[strtolower($currency)];
        $mode = $trustData->payment_mode;
        return $mode;
    }
    public function changeashram()
    {
    	if(!empty($this->subscriptionscart->contents()))
    	foreach($this->subscriptionscart->contents() as $key=>$val)
    	{
    		$subscriptionData=$this->subscriptions_model->subscriptionData($val['id']);
    		break;
    	}
    	if(isset($_POST['ashram_id']) && $_POST['ashram_id']!='' && (empty($this->subscriptionscart->contents()) || isset($subscriptionData) && $subscriptionData->ashram_id == $_POST['ashram_id']))
    	{
    		$this->load->model('ashrams/ashrams_model');
    		$ashramData=$this->ashrams_model->ashramData($_POST['ashram_id']);
    		if(!empty($ashramData))
    		{
    			$this->session->set_userdata("subscriptionCartAshramIdSelection",$_POST['ashram_id']);
                $this->session->set_userdata("subscriptionCartAshramId",$_POST['ashram_id']);
    			$this->cart_log_model->log("Changed ashram to :".$ashramData->name,$this->session->userdata("subscriptionCartAshramIdSelection"),4);
    			$data['flag']=1;
    			echo json_encode($data);
    			return;
    		}
    	}
    	else
    	{
    		$data['flag']=2;
    		if($subscriptionData->ashram_id)
    		{	
    			$ashramData=$this->ashrams_model->ashramData($subscriptionData->ashram_id);
    			$data['ashram_name']=$ashramData->name;
    		}
    		echo json_encode($data);
    		return;
    	}
    	$data['flag']=0;
    	echo json_encode($data);
    }

    public function removeAshramSession()
    {
    	$this->session->unset_userdata("subscriptionCartAshramIdSelection");
    	echo 1;
    }
    public function checkout()
    {
        if(empty($this->input->get("ashram_id")) || empty($this->input->get("currency")))
        {
            redirect("subscriptions");
        }
    	$cart=$this->subscriptionscart->contents();
    	if(empty($cart))
    	{
    		if( ($this->session->userdata("subscriptionCartAshramIdSelection") == appji_ashram_id) || ($this->input->get("ashram_id") == appji_ashram_id) )
            {
                redirect("");
            }
            else if(!empty($this->session->userdata("subscriptionCartAshramId")) && !empty($this->session->userdata("defaultCurrency")))
            {
                redirect("subscriptions?ashram_id=".$this->session->userdata("subscriptionCartAshramId")."&currency=".$this->session->userdata("defaultCurrency"));
            }
            else
            {
                redirect("subscriptions");
            }
    	}

    	if( ($this->session->userdata("subscriptionCartAshramIdSelection") == appji_ashram_id) || ($this->input->get("ashram_id") == appji_ashram_id) )
        {
            foreach($cart as $thiscart)
            {
                if($this->input->get("currency") != $thiscart['options']['appji_currency'])
                {
                    redirect("subscriptions/checkout?ashram_id=".$this->session->userdata("subscriptionCartAshramIdSelection")."&currency=".$thiscart['options']['appji_currency']);
                }
            }
        }

        $cartCount = count($cart);
		if( (($this->session->userdata("subscriptionCartAshramIdSelection") == appji_ashram_id) || ($this->input->get("ashram_id") == appji_ashram_id)) && $cartCount>1)
        {
			$data['alertMessage'] = '<div class="alert alert-danger">
										<button class="close" data-dismiss="alert"></button>
										<strong>JGD. You already have a subscription in your cart, only one item allowed at a time. If you wish to add this item, empty the cart and try again.</strong>
										<a href="#clearCartModal" class="btn btn-danger btn-xs" data-toggle="modal" style="margin-left: 10px;"><i class="fa fa-times"></i> Clear Cart</a>
									</div>';
		}
        if($cartCount>0)
        {
            foreach($cart as $thiscartitem)
            {
                if($this->session->userdata('subscriptionCartAshramId')!=$thiscartitem['options']['ashram_id'] && ($this->input->get("ashram_id")!=''))
                {
                    $ashramData=$this->ashrams_model->ashramData($thiscartitem['options']['ashram_id']);
                    $data['alertMessage'] = '<div class="alert alert-danger">
                                                <button class="close" data-dismiss="alert"></button>
                                                <strong>JGD. You cart has items from "'.$ashramData->name.'" ashram / event. If you wish to add items from another ashram / event, empty the cart and try again.</strong>
                                                <a href="#clearCartModal" class="btn btn-danger btn-xs" data-toggle="modal" style="margin-left: 10px;"><i class="fa fa-times"></i> Clear Cart</a>
                                            </div>';
                }
            }
        }

    	$this->load->model("credit_cards_model");

    	$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($this->session->userdata("subscriptionCartAshramId"),4);
        $data['ashramData'] = $this->ashrams_model->ashramData($this->session->userdata("subscriptionCartAshramId"));
    	$trustsArray=array();
    	foreach ($trusts as $trustData)
    	{
    		$trustsArray[$trustData->currency]=$trustData;
    	}
    	if($this->session->userdata("defaultCurrency")=='inr')
    	{
    		$data['trustData'] = isset($trustsArray['inr']) ? $trustsArray['inr'] : "";
    	}
    	if($this->session->userdata("defaultCurrency")=='usd')
    	{
    		$data['trustData'] = isset($trustsArray['usd']) ? $trustsArray['usd'] : "";
    	}

    	// If trust data is not available then redirect to back
        if(empty($data['trustData']))
        {
        	if( ($this->session->userdata("subscriptionCartAshramIdSelection") == appji_ashram_id) || ($this->input->get("ashram_id") == appji_ashram_id) )
            {
                redirect("");
            }
            else if(!empty($this->session->userdata("subscriptionCartAshramId")) && !empty($this->session->userdata("defaultCurrency")))
            {
                redirect("subscriptions?ashram_id=".$this->session->userdata("subscriptionCartAshramId")."&currency=".$this->session->userdata("defaultCurrency"));
            }
            else
            {
                redirect("subscriptions");
            }
        }

        $temp_reference = substr(hash('sha256', mt_rand() . microtime()), 0, 25);
        $this->session->set_userdata("subscriptions_temp_reference",$temp_reference);

    	$total=$this->cart_model->getTotalPrice($this->subscriptionscart);
    	$data['total_price']=strtoupper($this->session->userdata("defaultCurrency"))." ".$total;
    	$data['amount_in_words']=$this->general_model->amountToWords($total);
    	$data ['family_donors'] = [];
    	if($this->session->userdata("loggedIn"))
        {
            if($this->currentUser->admin==1)
            {
                if($this->session->userdata('temp_checkout_user'))
                {
                    $cUserId=$this->session->userdata('temp_checkout_user')->id;
                    $checkoutUserId = $this->session->userdata('temp_checkout_user')->sso_user_id;
                    $data['credit_cards']=$this->credit_cards_model->getCards($cUserId);
                }
            }
            else
            {
                $checkoutUserId = $this->currentUser->sso_user_id;
                $data['credit_cards']=$this->credit_cards_model->getCards($this->currentUser->id);
            }
            $this->load->model("subscriptions/donors_model");
            $data ['family_donors'] = $this->donors_model->getUserUnhideDonors($checkoutUserId);
        }
    	$data['views'] = array('ashrams/public/checkout_subscriptions');
		$this->load->view(FRONTEND_TEMPLATE,$data);
		$this->cart_log_model->log("Navigated to subscriptions checkout page :".current_url(),$this->session->userdata("subscriptionCartAshramId"),4);
    }
    public function getcart()
    {
    	$userData=array();
		if($this->session->userdata("loggedIn") && $this->currentUser->admin==1)
			$userData=$this->session->userdata('temp_checkout_user');
		else
			$userData=$this->currentUser;

		$family_donors = [];
		if($this->session->userdata("loggedIn"))
    	{
    		if($this->currentUser->admin==1)
			{
				if($this->session->userdata('temp_checkout_user'))
				{
					$checkoutUserId = $this->session->userdata('temp_checkout_user')->sso_user_id;
				}
			}
			else
			{
				$checkoutUserId = $this->currentUser->sso_user_id;
			}
			$this->load->model("subscriptions/donors_model");
			$family_donors = $this->donors_model->getUserUnhideDonors($checkoutUserId);
    	}
        $trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($this->session->userdata("subscriptionCartAshramIdSelection"),4);
        $trustsArray=array();
        foreach ($trusts as $trustData)
        {
            $trustsArray[$trustData->currency]=$trustData;
        }
        $trustData=$trustsArray[strtolower($this->session->userdata("defaultCurrency"))];
    	$data['cart_template']=$this->load->view("ashrams/public/_cart_template_subscriptions",array('userData'=>$userData, 'family_donors'=> $family_donors,"trustData"=>$trustData),true);
    	$total=$this->cart_model->getTotalPrice($this->subscriptionscart);
    	$data['total_price']=strtoupper($this->session->userdata("defaultCurrency"))." ".$total;
    	$data['amount_in_words']=$this->general_model->amountToWords($total);
    	echo json_encode($data);
    }
    public function listitems()
	{
		$list=$this->subscriptions_model->listPublicS($this->session->userdata("subscriptionCartAshramIdSelection"),$this->session->userdata("admin_data"),$this->session->userdata("user_data"));
		echo json_encode($list);
	}
	public function carttoptemplate()
	{
		$data['cartObject']=$this->subscriptionscart;
		$data['slug']="subscriptions";
		$response_data['cart_template']=$this->load->view("ashrams/public/_cart_top_template",$data,true);
		$response_data['count']=count($this->subscriptionscart->contents());
		echo json_encode($response_data);
	}

	public function additem($id=0)
	{
		$data['flag']=0;
		//Check whether Orders are enabled or not
		if($GLOBALS['site_settings']['enable_orders']==0)
		{
			$data['flag']=55;
			goto end;
		}
		//Check whether Subscriptions are enabled or not
		if($GLOBALS['site_settings']['subscriptions']==0 && (!$this->session->userdata("id") || $this->session->userdata("admin_data")->roles!=1))
    	{
    		$data['flag']=12;
    		$data['error_msg']="Subscriptions are disabled";
			goto end;
    	}
    	//Check wheather user/admin is logged in or not
		if($this->session->userdata("loggedIn") && $this->currentUser->admin==0)
		{
			if($this->currentUser->email_verified==0)
			{
				$data['flag']=51;
				goto end;
			}
		}
		//If admin logged in check wheather user is selected or not
		if($this->session->userdata("loggedIn") && $this->currentUser->admin==1)
		{
			if(!$this->session->userdata('temp_checkout_user'))
			{
				$data['flag']=12;
				$data['msg']='Please select user before adding Donation to cart.';
				goto end;
			}
		}

		//Check subscription period is days, If currency is INR and payment gateway is razorpay then throw error Daily subscriptions are unavailable for this currency
		if($this->session->userdata("loggedIn") && $this->session->userdata("defaultCurrency") == "inr" && $this->getPaymentMode() == 'razorpay')
		{
			$subscriptionData=$this->subscriptions_model->subscriptionData($id);
			if($subscriptionData->period == 'days')
            {
				$data['flag']=133;
				$data['msg']='Daily subscriptions are unavailable for this currency.';
				goto end;
			}
			if($this->currentUser->admin != 1)
            {
			    $cart=$this->subscriptionscart->contents();
    			if($cart)
                {
    				foreach($cart as $key=>$val){
    	            	$subcheck = $val['options']['subscription'];
    	            	if($subscriptionData->subscription != $subcheck)
                        {
    	            		$data['flag']=133;
    						$data['msg']='Jaya Guru Datta. Only one Subscription item is allowed per Seva.<br>To pay for another Subscription please complete this Seva and add the item in a new Seva.';
    						goto end;
    	            	}
    	        	}
    	    	}
    			if($subscriptionData->subscription ==1)
                {
    				if($cart)
                    {
    					$data['flag']=133;
    					$data['msg']='Jaya Guru Datta. Only one Subscription item is allowed per Seva.<br>To pay for another Subscription please complete this Seva and add the item in a new Seva.';
    					goto end;
    				}
    			}
			}
		}
        if($this->session->userdata("loggedIn") && $this->session->userdata("defaultCurrency") == "usd" && $this->getPaymentMode() == 'paypal')
        {
            $subscriptionData=$this->subscriptions_model->subscriptionData($id);
            if($this->currentUser->admin != 1)
            {
                $cart=$this->subscriptionscart->contents();
                if($cart)
                {
                    foreach($cart as $key=>$val){
                        $subcheck = $val['options']['subscription'];
                        if($subscriptionData->subscription != $subcheck)
                        {
                            $data['flag']=133;
                            $data['msg']='Jaya Guru Datta. Only one Subscription item is allowed per Seva.<br>To pay for another Subscription please complete this Seva and add the item in a new Seva.';
                            goto end;
                        }
                    }
                }
                if($subscriptionData->subscription ==1)
                {
                    if($cart)
                    {
                        $data['flag']=133;
                        $data['msg']='Jaya Guru Datta. Only one Subscription item is allowed per Seva.<br>To pay for another Subscription please complete this Seva and add the item in a new Seva.';
                        goto end;
                    }
                }
            }
        }
        // Check wheather cart is locked
		if($GLOBALS['subscriptionCartLocked']==1)
		{
			$data['flag']=11;
			goto end;
		}
		if(is_numeric($id) && $id)
		{
			// Get Subscription cart content if any
			$cart=$this->subscriptionscart->contents();
			// Get total amount of Subscription cart
			$amount=$this->cart_model->getTotalPrice($this->subscriptionscart);
			// Get Subscription data of currently adding subscription
			$subscriptionData=$this->subscriptions_model->subscriptionData($id);
			$col="price_".strtolower($this->session->userdata("defaultCurrency"));
			$minPriceCol="min_price_".strtolower($this->session->userdata("defaultCurrency"));
			// If Subscription is not found send subscription not found error
			if(empty($subscriptionData))
			{
				$data['flag']=10;
				goto end;
			}
            $cartCount = count($cart);
            if($cartCount>0)
            {
                foreach($cart as $thiscartitem)
                {
                	// Check wheather all subscription items from same Ashram or not
                    if($this->session->userdata('subscriptionCartAshramId')!=$thiscartitem['options']['ashram_id'])
                    {
                        $this->load->model('ashrams/ashrams_model');
                        $ashramData=$this->ashrams_model->ashramData($thiscartitem['options']['ashram_id']);
                        $data['ashram_name']=$ashramData->name;
                        $data['flag']=2;
                        goto end;
                    }
                }
            }
			// Check amount for the selected currency is > 0  or not
			$displayCol=strtolower($this->session->userdata("defaultCurrency"))."_display";
			if($subscriptionData->$displayCol==0)
			{
				$data['flag']=10;
				goto end;
			}
			// Get user Data (User data / Temp user data for admin)
			if($subscriptionData->subscription==1)
            {
                $tempUserId=0;
                if($this->session->userdata("loggedIn") && $this->currentUser->admin==1)
                {
                    $tempUserId=$this->session->userdata('temp_checkout_user')->sso_user_id;
                }
                else
                {
                    if(isset($this->currentUser->sso_user_id))
                        $tempUserId=$this->currentUser->sso_user_id;
                }

                if($tempUserId == 0)
                {
                    echo 'login';
                    exit;
                }
                // Get Donor details, if donor is not there create default(self) donor
                $donorsCount=$this->donors_model->getCountByUser($tempUserId);
                if($donorsCount==0)
                {
                    $this->donors_model->createDefault($tempUserId);
                }
            }
            // Check wheather Subscription is fixed price or not, if fixed amount then set amount from subscription based on currency
			if($subscriptionData->is_price_fixed==1)
				$_POST['amount']=$subscriptionData->$col;

			// Check amount is valid amount or not
			if(isset($_POST['amount']))
			{
				if($_POST['amount']=='')
				{
					$data['flag']=12;
					$data['msg']='Enter Amount';
					goto end;
				}
				if(!preg_match("/^\d+$/",$_POST['amount']))
				{
					$data['flag']=12;
					$data['msg']='Enter only digits';
					goto end;
				}

				if(strlen($_POST['amount'])!=strlen(abs($_POST['amount'])))
				{
					$data['flag']=12;
					$data['msg']='Enter valid amount';
					goto end;
				}
				if($subscriptionData->is_price_fixed==0)
                {
                    if(isset($subscriptionData->$minPriceCol) && abs($_POST['amount'])<$subscriptionData->$minPriceCol)
                    {
                        $data['flag']=12;
                        $data['msg']='Minimum Subscription amount is '.$subscriptionData->$minPriceCol;
                        goto end;
                    }
                }
			}
			else
			{
				goto end;
			}
			// Calculate net amount = previous cart amount and current adding subscription amount
			$netAmount=$amount+$_POST['amount'];

			// Check Total net amount is below allowed maximum amount for the selected currency
			if(strtolower($this->session->userdata("defaultCurrency"))=='inr' &&
				$netAmount>$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
			{
				$data['flag']=13;
				$data['msg']='Sorry! Maximum allowed amount for checkout is INR '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
				goto end;
			}
			if(strtolower($this->session->userdata("defaultCurrency"))=='usd' &&
				$netAmount>$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
			{
				$data['flag']=13;
				$data['msg']='Sorry! Maximum allowed amount for checkout is USD '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
				goto end;
			}
			//Check Total net amount is atleast allowed minimum amount for the selected currency
			if(strtolower($this->session->userdata("defaultCurrency"))=='inr')
			{
				$minAmount=$this->currencies[$this->session->userdata("defaultCurrency")]['min'];
				$maxAmount=$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
			}
			if(strtolower($this->session->userdata("defaultCurrency"))=='usd')
			{
				$minAmount=$this->currencies[$this->session->userdata("defaultCurrency")]['min'];
				$maxAmount=$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
			}

			if(trim(abs($_POST['amount']))<$minAmount)
			{
				$data['flag']=12;
				$data['msg']='Minimum amount is '.strtoupper($this->session->userdata("defaultCurrency"))." ".$minAmount;
				goto end;
			}
			if(trim(abs($_POST['amount']))>$maxAmount)
			{
				$data['flag']=12;
				$data['msg']='Maximum amount is '.strtoupper($this->session->userdata("defaultCurrency"))." ".$maxAmount;
				goto end;
			}
			// Check wheather adding subscription is only popup subscription or not
            if($subscriptionData->display_only_popup==1)
            {
                $data['flag']=112;
                goto end;
            }

            // Setting subscription cart data with item, cart type, amount, personal note, note, other_name1 and is_appji_subscription
			$data['item']=$subscriptionData;
			$data['type']='subscription';
			$data['amount']=$_POST['amount'];
			$data['personal_note']='';
			$data['note']='';
            $data['other_name1']='';
            $data['is_appji_subscription']=0;
            // Set note column by default current user family details
			if($this->session->userdata("loggedIn"))
			{
				if($this->currentUser->admin==0)
				{
					$data['note']=$this->currentUser->family_details;
				}
				else
				{
					if($this->session->userdata('temp_checkout_user'))
					{
						$data['note']=$this->session->userdata('temp_checkout_user')->family_details;
					}
				}
			}
			// Check subscriptionCartAshramId and subscription ashram is same or not 
			if(!$this->session->userdata('subscriptionCartAshramId') || $subscriptionData->ashram_id==$this->session->userdata('subscriptionCartAshramId') || count($cart)==0)
			{
				// Validate cart and Proceed to add item to cart 
				$response=$this->cart_model->addItem($data,1,$this->subscriptionscart);
				$flag=$response['flag'];
				if($flag==-2)
				{
					$this->logaction->log($this->service,"Subscription added to cart _ Subscription ID:".$id." _ ".$subscriptionData->subscription_name." _ Row ID: ".$response['rowid']);
					$data['flag']=1;
					$this->session->set_userdata('subscriptionCartAshramId',$subscriptionData->ashram_id);
					$this->cart_log_model->log("Item added - Name:".$subscriptionData->subscription_name.", Amount:".strtoupper($this->session->userdata("defaultCurrency"))." ".$data['amount'],$this->session->userdata("subscriptionCartAshramId"),4);
				}
				else
				{
					$data['flag']=$flag;
				}
			}
			else
			{
				$this->load->model('ashrams/ashrams_model');
				$ashramData=$this->ashrams_model->ashramData($this->session->userdata('subscriptionCartAshramId'));
				$data['ashram_name']=$ashramData->name;
				$data['flag']=2;
			}
		}
		end:
		ob_start();
		$cdata['cartObject']=$this->subscriptionscart;
		$cdata['slug']="subscriptions";
		// Load cart templete
		$this->load->view("ashrams/public/_cart_top_template",$cdata);
		$data['cart_template']=ob_get_clean();
		echo json_encode($data);
	}

	public function removeitem()
	{
		$result['flag']=0;
		if($GLOBALS['subscriptionCartLocked']==1)
		{
			$result['flag']=11;
			goto end;
		}
		$cart=$this->subscriptionscart->contents();
        if(empty($cart))
        {
            $result['flag']=3;
            goto end;
        }
		if(isset($_POST['key']) && $_POST['key']!='')
		{
			$item=$this->subscriptionscart->get_item($_POST['key']);
			if(!empty($item))
			{
				$upd= array(
			               'rowid' => $_POST['key'],
               				'qty'   => 0
				            );
				$this->subscriptionscart->update($upd);
				$this->logaction->log($this->service,"Subscription removed from cart _ Subscription ID:".$item['id']." _ ".$item['name']." _ Row ID: ".$_POST['key']);
				$this->cart_log_model->log("Item removed - Name:".$item['name'],$this->session->userdata("subscriptionCartAshramId"),4);
				$cc=$this->subscriptionscart->contents();
				if(count($cc)==0)
				{
					$this->session->unset_userdata('subscriptionCartAshramId');
				}
				$result['flag']=1;
				$result['cart_count']=count($cc);
                $result['currency'] = '';
                $result['ashram_id'] = '';
                if($this->session->userdata('subscriptionCartAshramIdSelection')>0)
                {
                    $result['ashram_id'] = $this->session->userdata('subscriptionCartAshramIdSelection');
                }
                if($this->session->userdata("defaultCurrency"))
                {
                    $result['currency'] = $this->session->userdata("defaultCurrency");
                }
			}
			else
			{
				$result['flag']=2;
			}
		}
		end:
		echo json_encode($result);
	}

	public function change_dates()
	{
		$result['flag']=0;
		if($GLOBALS['subscriptionCartLocked']==1)
		{
			$result['flag']=11;
			goto end;
		}
		if(isset($_POST['subscriptionid']) && is_numeric($_POST['subscriptionid']) && $_POST['subscriptionid'] && 
			isset($_POST['rowid']) && $_POST['rowid']!='')
		{
			$subscriptionData=$this->subscriptions_model->subscriptionData($_POST['subscriptionid']);
			if(!empty($subscriptionData) && $subscriptionData->status==1)
			{
				$data['item']=$subscriptionData;
				$data['options']=$this->subscriptionscart->product_options($_POST['rowid']);
				$result['template']=$this->load->view('ashrams/public/_select_dates_subscriptions',$data,true);
				$result['flag']=1;
			}
		}
		end:
		echo json_encode($result,JSON_HEX_APOS);
	}

	public function dates_validate()
	{
		if($GLOBALS['subscriptionCartLocked']==1)
		{
            echo 'cartLocked';
			exit;
		}
		if(isset($_POST['subscriptionid']) && is_numeric($_POST['subscriptionid']) && $_POST['subscriptionid'])
		{
			$subscriptionData=$this->subscriptions_model->subscriptionData($_POST['subscriptionid']);
			if(!empty($subscriptionData) && $subscriptionData->status==1)
			{
				//$dates_set=$this->cart_model->getDonationValidDates($subscriptionData);
				$final=array();
				if($_POST['selected_dates']!='')
					$selected=array_filter(explode(",",$_POST['selected_dates']));
				else
					$selected=array();

				$startDate=date("d M Y 00:00:00");
				$endDate=date("d M Y 23:59:00",strtotime("+5 Months"));

				if(isset($subscriptionData->subscription) && $subscriptionData->subscription==1)
				{
					if(count($selected)>1)
					{
						echo '10';
						exit;
					}
					$tomorrow=date("d M Y 00:00:00",strtotime("+1 day"));
					if(strtotime($selected[0])<strtotime($tomorrow))
					{
						echo "11";
						exit;
					}
				}
				

				$startTime=strtotime($startDate);
				$endTime=strtotime($endDate);
				if(!empty($selected))
				{
					foreach($selected as $selectedDate)
					{
						$tempTime=strtotime($selectedDate);
						if($startTime<=$tempTime && $tempTime<=$endTime)
						{
							$final[]=$selectedDate;
						}
					}
				}
				
				foreach($final as $key=>$tms)
				{
					$final[$key]=strtotime($tms);
				}
				
				asort($final);
				
				$store_array=array();
				
				$cnt=0;
				$first='';
				
				
				foreach($final as $key=>$tms)
				{
					if($cnt==0)
					$first=date("d M Y",$tms);
					
					$final[$key]=date("d M Y (D)",$tms);
					$store_array[]=date("d M Y",$tms);
					$cnt++;
				}
				
				if($_POST['save']==1)
				{
					$opt=$this->subscriptionscart->product_options($_POST['rowid']);

					$opt['result_date']=implode(",",$store_array);
					$opt['schedule_options']=$_POST;
					$opt['user_date']=$first;

					$upd= array(
							 'rowid' => $_POST['rowid'],
							 'options'   => $opt,
							 'qty'=>$cnt					);

					$this->subscriptionscart->update($upd);
					$this->cart_log_model->log("Dates changed - Name:".$subscriptionData->subscription_name,$this->session->userdata("subscriptionCartAshramId"),4);
					$this->cart_model->validateCart($this->subscriptionscart);
				}
				echo implode("<br>",$final);
			}
		}
	}

	public function update_payment_count($key)
    {
		if($GLOBALS['subscriptionCartLocked']==1)
		{
            $data['flag']=2;
			$data['msg']="Sorry! A transaction initiated by you, is already in progress.";
			goto end;
		}

    	$this->form_validation->set_rules('num_of_payments', 'Number of payments', 'trim|numeric');
    	if($this->form_validation->run() == FALSE)
		{
			$data['msg']="Invalid request";
			goto end;
		}
		$item=$this->subscriptionscart->get_item($key);
		$options=$this->subscriptionscart->product_options($key);
		if(empty($options) || $options['subscription']==0)
		{
			$data['msg']="Invalid item";
			goto end;
		}
		$total_payments=$this->subscriptions_model->getSubscriptionsCount($options['result_date'],$item['id']);
		if($this->input->post("num_of_payments") > $total_payments)
		{
			$data['msg']="Invalid request";
			goto end;
		}

		$options['num_of_payments']=$this->input->post("num_of_payments");
        if(!empty($this->input->post("pay_till_cancelled_not_checked")) && $this->input->post("pay_till_cancelled_not_checked") == 1)
        {
            $options['pay_till_cancelled_not_checked']=1;
        }
        else
        {
            $options['pay_till_cancelled_not_checked']=0;
        }
		$options['expiration_method']=1;
		$updateArray= array(
	               'rowid' => $key,
       			       'options'   => $options
		            );
		

		$this->subscriptionscart->update($updateArray);
		$this->cart_log_model->log("Number of payments updated - Name:".$item['name'],$this->session->userdata("subscriptionCartAshramId"),4);
		$data['flag']=1;

		end:
		echo json_encode($data);
    }

    public function update_stripe_pay_till_cancel($key)
    {
        $data['flag']=0;
        if($GLOBALS['subscriptionCartLocked']==1)
        {
            $data['flag']=2;
            $data['msg']="Sorry! A transaction initiated by you, is already in progress.";
            goto end;
        }

        $this->form_validation->set_rules('pay_till_cancel', 'Pay till cancel', 'trim|numeric');
        if($this->form_validation->run() == FALSE)
        {
            $data['msg']="Invalid request";
            goto end;
        }
        $item=$this->subscriptionscart->get_item($key);
        $options=$this->subscriptionscart->product_options($key);
        if(empty($options) || $options['subscription']==0)
        {
            $data['msg']="Invalid item";
            goto end;
        }
        $total_payments=$this->subscriptions_model->getSubscriptionsCount($options['result_date'],$item['id']);

        $options['pay_till_cancel']=$this->input->post("pay_till_cancel");
        $options['pay_till_cancelled_not_checked']=0;
        $updateArray= array(
                   'rowid' => $key,
                       'options'   => $options
                    );
        

        $this->subscriptionscart->update($updateArray);
        $this->cart_log_model->log("Pay till cancel updated - Name:".$item['name'],$this->session->userdata("subscriptionCartAshramId"),4);
        $data['flag']=1;

        end:
        echo json_encode($data);
    }

	public function updatenote()
    {
		if($GLOBALS['subscriptionCartLocked']==1)
		{
			echo 2;
			return;
		}

    	$this->form_validation->set_rules('value', 'Value', 'trim|min_length[6]|max_length[500]');
    	$this->form_validation->set_rules('pk', 'ID', 'trim|required');
    	if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$item=$this->subscriptionscart->get_item($_POST['pk']);
		$options=$this->subscriptionscart->product_options($_POST['pk']);
		if(!empty($options))
		{
			$options['note']=$_POST['value'];
			$updateArray= array(
		               'rowid' => $_POST['pk'],
           			       'options'   => $options
			            );

	        foreach ($options as $key => $val)
			{
				$temp[$key] = $val;
			}

			$this->subscriptionscart->update($updateArray);
			$this->cart_log_model->log("Family details updated - Name:".$item['name'],$this->session->userdata("subscriptionCartAshramId"),4);
			echo 1;
		}
		else
		{
			echo 0;
		}
    }

    public function updatePersonalnote()
    {
		if($GLOBALS['subscriptionCartLocked']==1)
		{
			echo 2;
			return;
		}

    	$this->form_validation->set_rules('value', 'Value', 'trim|min_length[6]|max_length[500]');
    	$this->form_validation->set_rules('pk', 'ID', 'trim|required');
    	if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$item=$this->subscriptionscart->get_item($_POST['pk']);
		$options=$this->subscriptionscart->product_options($_POST['pk']);
		if(!empty($options))
		{
			$options['personal_note']=$_POST['value'];
			$updateArray= array(
		               'rowid' => $_POST['pk'],
           			       'options'   => $options
			            );

	        foreach ($options as $key => $val)
			{
				$temp[$key] = $val;
			}

			$this->subscriptionscart->update($updateArray);
			$this->cart_log_model->log("Personal Note updated - Name:".$item['name'],$this->session->userdata("subscriptionCartAshramId"),4);
			echo 1;
		}
		else
		{
			echo 0;
		}
    }

    public function updateamount()
    {
    	$data['flag']=0;
		if($GLOBALS['subscriptionCartLocked']==1)
		{
			$data['flag']=2;
			goto end;
		}

    	//$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric');
    	$this->form_validation->set_rules('pk', 'ID', 'trim|required');
    	if($this->form_validation->run() == FALSE)
		{
			goto end;
		}

		if(isset($_POST['value']))
		{
			if($_POST['value']=='')
			{
				$data['flag']=3;
				$data['msg']='Enter Amount';
				goto end;
			}
			if(!preg_match("/^\d+$/",$_POST['value']))
			{
				$data['flag']=3;
				$data['msg']='Enter only digits';
				goto end;
			}

			if(strlen($_POST['value'])!=strlen(abs($_POST['value'])))
			{
				$data['flag']=3;
				$data['msg']='Enter valid amount';
				goto end;
			}
		}
		else
		{
			goto end;
		}
		$item=$this->subscriptionscart->get_item($_POST['pk']);
		$options=$this->subscriptionscart->product_options($_POST['pk']);
		if(!empty($options) && $options['is_price_fixed']==0)
		{
			$priceCol='price_'.strtolower($this->session->userdata("defaultCurrency"));

			$subscriptionData=$this->subscriptions_model->subscriptionData($item['id']);
            $minPriceAmount=0;
			
			if(strtolower($this->session->userdata("defaultCurrency"))=='inr')
			{
				if(isset($subscriptionData->min_price_inr) && $subscriptionData->min_price_inr>0)
                {
                    $minPriceAmount = $subscriptionData->min_price_inr;
                }
				$minAmount=$this->currencies[$this->session->userdata("defaultCurrency")]['min'];
				$maxAmount=$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
			}
			if(strtolower($this->session->userdata("defaultCurrency"))=='usd')
			{
				if(isset($subscriptionData->min_price_usd) && $subscriptionData->min_price_usd>0)
                {
                    $minPriceAmount = $subscriptionData->min_price_usd;
                }
				$minAmount=$this->currencies[$this->session->userdata("defaultCurrency")]['min'];
				$maxAmount=$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
			}

			if(trim(abs($_POST['value']))<$minPriceAmount)
            {
                $data['flag']=3;
                $data['msg']='Minimum amount is '.strtoupper($this->session->userdata("defaultCurrency"))." ".$minPriceAmount;
                goto end;
            }

			if(trim(abs($_POST['value']))<$minAmount)
			{
				$data['flag']=3;
				$data['msg']='Minimum amount is '.strtoupper($this->session->userdata("defaultCurrency"))." ".$minAmount;
				goto end;
			}
			if(trim(abs($_POST['value']))>$maxAmount)
			{
				$data['flag']=3;
				$data['msg']='Maximum amount is '.strtoupper($this->session->userdata("defaultCurrency"))." ".$maxAmount;
				goto end;
			}
			$options[$priceCol]=$_POST['value'];
			$updateArray= array(
		               		'rowid' => $_POST['pk'],
           			       	'options'   => $options
			            );
			$this->subscriptionscart->update($updateArray);
			$this->cart_log_model->log("Amount updated - Name:".$item['name'].", Amount:".strtoupper($this->session->userdata("defaultCurrency"))." ".$_POST['value'],$this->session->userdata("subscriptionCartAshramId"),4);
			$data['flag']=1;
		}
		end:
		echo json_encode($data);
    }

    public function cancelprevious()
    {
    	$result['flag']=0;
    	if($GLOBALS['subscriptionCartLocked']==1)
		{
            $startedOn=strtotime($GLOBALS['subscriptionCartStartedOn']);
			if(time()>=$startedOn)
			{
				$this->cart_model->regenerateSession(4);
				$result['flag']=1;
				goto end;
			}
		}
		end:
		echo json_encode($result);
    }
    public function checkout_notify($tab_index=null)
    {
    	if($tab_index!=null && in_array($tab_index,array(0,1,2)))
    	{
    		$data='';
    		if($tab_index==2)
    		{
    			$countryData=$this->locations_model->getCountryByCode($this->input->post("country"));
    			$data="<br>Data:<br>".$this->input->post("firstname")." ".$this->input->post("lastname")."<br>".
    				$this->input->post("city").", ".$this->input->post("state").", ".$this->input->post("country")."<br>".
    				"+".$countryData->isd_code." ".$this->input->post("phone")."<br>".
    				$this->input->post("email");
    		}
    		$this->cart_log_model->log("Checkout - navigated to tab ".($tab_index+1).$data,$this->session->userdata("subscriptionCartAshramId"),4);
    	}
    }

    public function check_subscription_modifications()
    {
        $result['flag']=1;
        //Validate Cart items
        $this->cart_model->validateCart($this->subscriptionscart);

        //Check cart items count
        $cartContents=$this->subscriptionscart->contents();
        if(empty($cartContents)) //If cart is empty
        {
            $result['flag']=0;
            goto end;
        }
        if(is_single_currency_site==1 && default_currency!=strtolower($this->session->userdata("defaultCurrency")))
        {
            $result['flag']=5;
            $result['alertMessage'] = '<strong>JGD. You cart not supporting the currency.</strong>';
            goto end;
        }

        $totalItems=count($cartContents);
        $validItems=0;
        foreach ($cartContents as $cartItem)
        {
            if($cartItem['options']['status']==1)
            {
                $validItems++;
            }

            if($this->session->userdata('subscriptionCartAshramId')!=$cartItem['options']['ashram_id'])
            {
                $ashramData=$this->ashrams_model->ashramData($cartItem['options']['ashram_id']);
                $result['flag']=5;
                $result['alertMessage'] = '<strong>JGD. You cart has items from "'.$ashramData->name.'" ashram / event. If you wish to add items from another ashram / event, empty the cart and try again.</strong><a href="#clearCartModal" class="btn btn-danger btn-xs" data-toggle="modal" style="margin-left: 10px;"><i class="fa fa-times"></i> Clear Cart</a>';
                goto end;
            }
        }

        //Check all items in cart are valid
        if($validItems!=$totalItems)
        {
            $result['flag']=4;
            goto end;
        }

        end:
        echo json_encode($result);

    }
    
    public function pay()
    {
    	//Check site settings
    	$result['flag']=0;
    	//Check whether Orders are enabled or not
    	if($GLOBALS['site_settings']['enable_orders']==0)
		{
			$data['flag']=3;
			goto end;
		}
		// Check wheather cart user email is verified or not
    	if($this->session->userdata("loggedIn") && $this->currentUser->admin==0)
		{
			if($this->currentUser->email_verified==0)
			{
				$data['flag']=51;
				goto end;
			}
		}

		//Get trust accounts for Ashram and Currency defined
		$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($this->session->userdata("subscriptionCartAshramId"),4);
    	$trustsArray=array();
    	foreach ($trusts as $trustData)
    	{
    		$trustsArray[$trustData->currency]=$trustData;
    	}
    	$customData['trustData']=$trustsArray[strtolower($this->session->userdata("defaultCurrency"))];
    	$customData['trustData']=$this->ashrams_trust_accounts_model->removeCredentials($customData['trustData']);

    	// If payment gateway is razorpay and currency is inr then check Daily subscriptions are not allowed and only one subscription item is allowed in cart
		if($this->currentUser->admin==1 && $customData['trustData']->payment_mode=='razorpay' && $this->session->userdata("defaultCurrency")=='inr' && $this->input->post("payment_mode")=='default'){
    		$verify = $this->checkadminDonationPayments();
    		if($verify == 0 || $verify == 3){
    			$result['flag']=501;
				goto end;
    		}
    		if($verify == 4){
    			$result['flag']=502;
				goto end;
    		}
    	}

    	// If payment gateway is paypal and currency is usd then only one subscription item is allowed in cart
        if($this->currentUser->admin==1 && $customData['trustData']->payment_mode=='paypal' && $this->session->userdata("defaultCurrency")=='usd' && $this->input->post("payment_mode")=='default')
        {
            $verify = $this->checkadminDonationPayments();
            if($verify == 0 || $verify == 3)
            {
                $result['flag']=501;
                goto end;
            }
        }

        // If payment gateway is stripe then only one subscription item is allowed in cart
        if($customData['trustData']->payment_mode=='stripe')
        {
            if($this->currentUser->admin==1 && $this->input->post("payment_mode")=='default')
            {
                $verify = $this->checkadminDonationPayments();
                if($verify == 0 || $verify == 3)
                {
                    $result['flag']=501;
                    goto end;
                }
            }
            else
            {
                $verify = $this->checkadminDonationPayments();
                if($verify == 0 || $verify == 3)
                {
                    $result['flag']=501;
                    goto end;
                }
            }
        }

        // If trust payment mode is stripe and going with cash payment mode check paytill cancel not allowed
        if($customData['trustData']->payment_mode=='stripe' && $this->input->post("payment_mode")=='cash')
        {
            $verify = $this->check_stripe_paytill_cancel();
            if($verify == 1)
            {
                $result['flag']=505;
                goto end;
            }
        }

        // If user is paying through razorpay and currency inr Daily subscriptions are not allowed for inr currency 
    	if($this->currentUser->admin!=1 && $customData['trustData']->payment_mode=='razorpay' && $this->session->userdata("defaultCurrency")=='inr')
        {
    		$verify = $this->checkuserDonationPayments();
    		if($verify == 1)
            {
    			$result['flag']=502;
				goto end;
    		}
    	}

		//Check wheather Subscription cart is locked or not
		if($GLOBALS['subscriptionCartLocked']==1)
		{
            $startedOn=strtotime($GLOBALS['subscriptionCartStartedOn']);
			if(time()>=$startedOn)
			{
				$result['time_exceed']=1;
			}
			$result['flag']=5;
			goto end;
		}
		
	 	//Validate form data
	 	if(!isset($_POST["firstname"]) || !isset($_POST["lastname"]) ||
	 			!isset($_POST["preferred_name"]) ||
				!isset($_POST["email"]) || !isset($_POST["phone"]) ||
				!isset($_POST["address1"]) || !isset($_POST["address2"]) || !isset($_POST["address3"]) ||
				!isset($_POST["city"]) || !isset($_POST["state"]) || !isset($_POST["country"]) ||
				!isset($_POST["donation_initials"]))
		{
	 		goto end;
		}

		$this->form_validation->set_rules('firstname', 'First Name','trim|required|min_length[2]|max_length[50]|lettersonly');
		$this->form_validation->set_rules('lastname', 'Last Name','trim|required|min_length[2]|max_length[50]|lettersonly');
		$this->form_validation->set_rules('preferred_name', 'Preferred Name','trim|required|min_length[2]|max_length[50]');
		$this->form_validation->set_rules('email', 'Email ID','trim|required|no_uppercase|valid_email_custom|min_length[6]|max_length[100]');
		$this->form_validation->set_rules('phone', 'Phone Number','trim|required|numeric|min_length[8]|max_length[15]');
		$this->form_validation->set_rules('address1', 'Address Line 1','trim|required|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('address2', 'Address Line 2','trim|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('address3', 'Address Line 3','trim|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('city', 'City','trim|required|min_length[2]|max_length[100]|name_validate13');
		$this->form_validation->set_rules('state', 'State','trim|required|min_length[2]|max_length[100]|name_validate13');
		$this->form_validation->set_rules('country', 'Country','trim|required|checkCountry');
		$this->form_validation->set_rules('zipcode', 'ZIP Code','trim|required|alphabetsnumbers|min_length[3]|max_length[15]');
		$this->form_validation->set_rules('donation_initials', 'Initials','trim|required|min_length[3]|max_length[25]');
		// If admin placing order validate payment_mode(cash/payment gateway)
		if($this->currentUser->admin==1)
		{
			$this->form_validation->set_rules('payment_mode', 'Payment Mode','trim|required|checkAdminPaymentMode');
			$paymentMode=$this->input->post("payment_mode");
		}
		else
		{
			$paymentMode=$customData['trustData']->payment_mode;
		}
		// If payment gateway is paypal an currency is USD Then validate card
        if($this->session->userdata("defaultCurrency")=='usd' && $customData['trustData']->payment_mode=='paypal')
        {
        	// If existing card id is passed then validate card
            if(isset($_POST["credit_card_id"]) && $_POST["credit_card_id"] !='')
            {
                $creditCardData=$this->credit_cards_model->getCard($_POST["credit_card_id"]);
                if(empty($creditCardData))
                {
                    goto end;
                }
            }
            else
            {
            	// If currency usd and payment mode not in (paypal, stripe, cash) then ask card details
                if($this->session->userdata("defaultCurrency")=='usd' && $customData['trustData']->payment_mode!='stripe' && $paymentMode!='cash')
                {
                    $this->form_validation->set_rules('card_number', 'Card Number','trim|required|min_length[15]|max_length[19]');
                    $this->form_validation->set_rules('card_name', 'Card Name','trim|required|min_length[2]|max_length[100]');
                    $this->form_validation->set_rules('card_expiry', 'Expiry Date','trim|required|cardExpiry');
                    $this->form_validation->set_rules('card_cvv', 'CVV Number','trim|required|numeric|min_length[3]|max_length[4]');
                }
            }
        }

        // If any form data errors then return form errors
		if($this->form_validation->run() == FALSE)
		{
			$result['error']=validation_errors();
	 		goto end;
		}
		//Validate Cart items
		$this->cart_model->validateCart($this->subscriptionscart);

		//Check cart items count
		$cartContents=$this->subscriptionscart->contents();
		if(empty($cartContents)) //If cart is empty
		{
			$result['flag']=2;
	 		goto end;
		}

		$totalItems=count($cartContents);
		$validItems=0;
		foreach ($cartContents as $cartItem)
		{
			if($cartItem['options']['status']==1)
			{
				$validItems++;
			}
		}

		//Check all items in cart are valid
		if($validItems!=$totalItems)
		{
			$result['flag']=4;
	 		goto end;
		}


		//Check for subscription items and number of payments
		$subscription_error=0;
		foreach ($cartContents as $cartItem)
		{
			if($cartItem['options']['subscription']==1 && $cartItem['options']['num_of_payments']==0)
			{
				$subscription_error=1;
				break;
			}
		}
		if($subscription_error==1)
		{
			$this->session->set_flashdata("donation_error","Please select number of payments for all subscription items");
			$result['flag']=9999;
			$result['reload']=true;
	 		goto end;
		}
		//Check for subscription items

		

		//Capture User ID
		$userId=0;
		if($this->session->userdata("loggedIn"))
		{
			if($this->currentUser->admin==1)
			{
				if($this->session->userdata('temp_checkout_user'))
				{
					$tData=$this->session->userdata('temp_checkout_user');
					$userId=$tData->id;
				}
			}
			else
			{
				$userId=$this->currentUser->id;
			}
		}

		// Calculate Total price of the cart
    	$amount=$this->cart_model->getTotalPrice($this->subscriptionscart);

    	//Check total maximum amount allowed for trust based on Currency
    	if($this->session->userdata("defaultCurrency")=='inr')
    	{
    		if($amount>$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
    		{
    			$result['flag']=10;
    			$result['error_msg']='Sorry! Maximum allowed amount for checkout is INR '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
    			goto end;
    		}
    	}
    	if($this->session->userdata("defaultCurrency")=='usd')
    	{
    		if($amount>$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
    		{
    			$result['flag']=10;
    			$result['error_msg']='Sorry! Maximum allowed amount for checkout is USD '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
    			goto end;
    		}
    	}

    	$this->load->model('ashrams/ashrams_model');

    	//Define custom data before initializing transaction
    	$created_by_user_id=0;
    	$created_by=0;
		$userData=array();
		if($this->session->userdata('id'))
		{
			if($this->session->userdata('temp_checkout_user'))
			{
				$userData=$this->session->userdata('temp_checkout_user');
				$userId=$userData->id;
			}
			$created_by=1;
		}
		else if($this->session->userdata('user_id'))
		{
			$userId=$this->session->userdata('user_id');
			$userData=$this->currentUser;
			$created_by=2;
		}

		$this->cart_log_model->log("Payment initiated",$this->session->userdata("subscriptionCartAshramId"),4);

		//If payment mode not set or payment mode is default
		if(!isset($paymentMode) || $paymentMode=='default')
		{
			$paymentMode=$customData['trustData']->payment_mode;
		}

		if($this->session->userdata('loggedIn'))
			$created_by_user_id=$this->currentUser->id;

		$customData['cartData']=$cartContents;
		$customData['formData']=$_POST;
		$customData['ashramData']=$this->ashrams_model->ashramData($this->session->userdata("subscriptionCartAshramId"));
		$customData['cart_type']=4;
		$customData['paymentMode']=$paymentMode;
		$customData['created_by']=$created_by;
		$customData['created_by_user_id']=$created_by_user_id;
		$customData['model']="orders/orders_model";
		$customData['model_name']="orders_model";
		$customData['ip_address']=$_SERVER['REMOTE_ADDR'];
		$customData['formData']['ashram_id']=$this->session->userdata("subscriptionCartAshramId");

		$customData['formData']['is_manual_payment']=0;
		if($this->input->post("is_manual_payment"))
		{
			$customData['formData']['is_manual_payment']=1;
		}

        #--------------------------------------------------------------------------------------#
        //Which will validate Item Ashram ID and Seva Ashram ID if any item mismatch with seva Ashram ID It will returns flag 4 (Item modified warning and stop creating seva).
        $this->load->helper("validate_order_ashram");
        $ashramCheck = validate_order_ashram(4,$cartContents,$this->session->userdata("subscriptionCartAshramId"),$this->session->userdata("subscriptionCartAshramIdSelection"));
        if($ashramCheck)
        {
            $result['flag']=4;
            goto end;
        }
        #--------------------------------------------------------------------------------------#
        
		$amount=$this->cart_model->getTotalPrice($this->subscriptionscart);
		$customData['amount_in_words']=$this->general_model->amountToWords($amount);
		//Load payment model
		$this->load->model("payment_model");
		//Load Temp payments model
		$this->load->model("temp_payments_model");
		//Create temp payment info
		$reference=$this->payment_model->setTempInfo(
			$userId,
			$userData,
			$amount,
			base_url."subscriptions/",
			base_url."subscriptions/checkout/",
			$customData,
			$this->session->userdata("defaultCurrency")
			);
		$result['flag']=1;
		$result['reference']=$reference;
		// Update reference number to cart and update started on column with current date and time
		$this->cart_model->updateReferenceId($reference,4);

		$result['payment_mode']=$paymentMode;

        $tempOrderId = 0;
        $tempPaymentId = "";
        //If payment mode is razorpay then create Temp Order
        if($paymentMode=='razorpay')
        {
            $this->load->model("razorpay_webhook_model");
            $tempData = $this->razorpay_webhook_model->createTempOrders($reference,$this->session->userdata("subscriptions_temp_reference"));
            $tempOrderId = $tempData["order_id"];
            $tempPaymentId = $tempData["payment_id"];
        }

        //If payment mode is stripe then create Temp Order and create Stripe Session 
        if($paymentMode=='stripe')
        {
        	//Generate temp reference number for stripe
            $temp_reference = substr(hash('sha256', mt_rand() . microtime()), 0, 25);
            $result['temp_reference']=$temp_reference;

            $this->load->model("stripe_webhook_model");
            $str_amount = $amount*100;
            //Create Temp Order
            $tempData = $this->stripe_webhook_model->createTempOrders($reference,$temp_reference);
            //Create stripe session
            $checkoutSession = $this->stripe_webhook_model->createStripeSession($this->session->userdata("defaultCurrency"),$this->input->post("email"),$customData['trustData'],4,$cartContents,$str_amount,$reference,$customData,$userId,$this->session->userdata("subscriptionCartAshramIdSelection"));
            if($checkoutSession["status"] == "error")
            {
                $result['flag']=10023;
                $result['error_msg']=$checkoutSession['status_message'];
                goto end;
            }
        }

		if($this->session->userdata("defaultCurrency")=='usd')
		{
			$result['currency']="USD";
			if($paymentMode=='paypal')
			{
				$result['flag']=101;
				$this->load->model("paypal_model");
                $creditCardData = array();
				$paypalResponse=$this->paypal_model->processOneTimePayment($reference,$creditCardData);
				if($paypalResponse['flag']==1)
				{
					$result['redirect_to']=$paypalResponse['redirect_url'];
					$result['payment_status']=1;
					$this->session->set_flashdata("order_placed",1);
					$this->session->set_userdata("order_placed",1);
					$this->cart_log_model->log("Payment success:".$paymentMode,$this->session->userdata("subscriptionCartAshramId"),4);
				}
				else
				{
					$result['payment_status']=0;
					$result['error_msg']=$paypalResponse['error_msg'];
					$this->cart_model->updateReferenceId('',4);
					$this->cart_log_model->log("Payment failure:".$paymentMode.", Reason:".$paypalResponse['error_msg'],$this->session->userdata("subscriptionCartAshramId"),4);
				}
			}
			if($paymentMode=='authorize.net')
			{
				$this->load->model("authorizenet_model");
				$authnetResponse=$this->authorizenet_model->processOneTimePayment($reference);
				if($authnetResponse['flag']==1)
				{
					$result['redirect_to']=$authnetResponse['redirect_url'];
					$result['payment_status']=1;
					$this->cart_log_model->log("Payment success:".$paymentMode,$this->session->userdata("subscriptionCartAshramId"),4);
					$this->session->set_flashdata("order_placed",1);
				}
				else
				{
					$result['payment_status']=0;
					$result['error']="Error making payment";//$authnetResponse['error_msg'];
					$this->cart_model->updateReferenceId('',4);
					$this->cart_log_model->log("Payment failure:".$paymentMode,$this->session->userdata("subscriptionCartAshramId"),4);
				}
			}
			if($paymentMode=='razorpay')
			{
				$result['amount']=$amount*100;
				$result['prefill_name']=$this->input->post("firstname")." ".$this->input->post("lastname");
				$result['prefill_email']=$this->input->post("email");
				$result['prefill_contact']=$this->input->post("phone");
				$this->load->model('razorpay_subscriptions_model','razorpaysubscriptions');
				$subscription_id = $this->razorpaysubscriptions->createSubscription($reference);
                $this->razorpaysubscriptions->updateTempOrder($subscription_id,$tempOrderId);
				if($subscription_id=="0")
				{
					$result['flag'] =0;
					$result['payment_status']=0;
					$result['error']="Error making payment";//$authnetResponse['error_msg'];
					$this->cart_model->updateReferenceId('',4);
					$this->cart_log_model->log("Payment failure:".$paymentMode,$this->session->userdata("subscriptionCartAshramId"),4);
				}
				else if($subscription_id=="2")
                {
					$result['subcheck'] = 1;
				}
                else
                {
					$result['subscription_id']= $subscription_id;
				}
				$result['reference_no'] = $reference;
				$result['ashram_id'] = $this->session->userdata("subscriptionCartAshramIdSelection");
                $result['tempOrderId'] = $tempOrderId;
                $result['tempPaymentId'] = $tempPaymentId;
                $result['application_reference'] = $reference;
			}
			if($paymentMode=='cash')
			{
				$offlineResponse=$this->offline_model->processPayment($reference);
				$result['redirect_to']=$offlineResponse['redirect_url'];
				$result['payment_status']=1;
				$this->session->set_flashdata("order_placed",1);
				$this->session->set_userdata("order_placed",1);
				$this->cart_log_model->log("Payment pending:".$paymentMode,$this->session->userdata("subscriptionCartAshramId"),4);
			}

			if($paymentMode=='stripe')
			{
				$result['amount']=$amount*100;
                $result['prefill_name']=$this->input->post("firstname")." ".$this->input->post("lastname");
                $result['prefill_email']=$this->input->post("email");
                $result['prefill_contact']=$this->input->post("phone");
                $result['currency']=$this->session->userdata("defaultCurrency");
                $result["session_id"]=$checkoutSession["session"]->id;
			}
		}
		else
		{
			$result['currency']="INR";
			if($paymentMode=='payu')
			{
				$result['redirect_to']='/payment/direct/'.$reference;
				$this->cart_log_model->log("Redirected to payment gateway:".$paymentMode,$this->session->userdata("subscriptionCartAshramId"),4);
			}
			if($paymentMode=='razorpay')
			{
				$result['amount']=$amount*100;
				$result['prefill_name']=$this->input->post("firstname")." ".$this->input->post("lastname");
				$result['prefill_email']=$this->input->post("email");
				$result['prefill_contact']=$this->input->post("phone");
				$this->load->model('razorpay_subscriptions_model','razorpaysubscriptions');
				$subscription_id = $this->razorpaysubscriptions->createSubscription($reference);
                $this->razorpaysubscriptions->updateTempOrder($subscription_id,$tempOrderId);
				if($subscription_id=="0")
				{
					$result['flag'] =0;
					$result['payment_status']=0;
					$result['error']="Error making payment";//$authnetResponse['error_msg'];
					$this->cart_model->updateReferenceId('',4);
					$this->cart_log_model->log("Payment failure:".$paymentMode,$this->session->userdata("subscriptionCartAshramId"),4);
				}
				else if($subscription_id=="2")
                {
					$result['subcheck'] = 1;
				}
                else
                {
					$result['subscription_id']= $subscription_id;
				}
				$result['reference_no'] = $reference;
				$result['ashram_id'] = $this->session->userdata("subscriptionCartAshramIdSelection");
                $result['tempOrderId'] = $tempOrderId;
                $result['tempPaymentId'] = $tempPaymentId;
                $result['application_reference'] = $reference;
			}
			if($paymentMode=='cash')
			{
				$offlineResponse=$this->offline_model->processPayment($reference);
				$result['redirect_to']=$offlineResponse['redirect_url'];
				$result['payment_status']=1;
				$this->session->set_flashdata("order_placed",1);
				$this->session->set_userdata("order_placed",1);
				$this->cart_log_model->log("Payment pending:".$paymentMode,$this->session->userdata("subscriptionCartAshramId"),4);
			}
			if($paymentMode=='stripe')
			{
				$result['amount']=$amount*100;
                $result['prefill_name']=$this->input->post("firstname")." ".$this->input->post("lastname");
                $result['prefill_email']=$this->input->post("email");
                $result['prefill_contact']=$this->input->post("phone");
                $result['currency']=$this->session->userdata("defaultCurrency");
                $result["session_id"]=$checkoutSession["session"]->id;
			}
		}

		end:
		echo json_encode($result);
    }

    public function changeListItemView()
	{
		$listType = $this->input->post('listType');
		if($listType)
		{
       		$this->session->set_userdata('subscriptionviewType', $listType);
		}
	}

	public function donor_modal($key='')
    {
		if($GLOBALS['subscriptionCartLocked']==1)
		{
			echo 2;
			return;
		}

		$options=$this->subscriptionscart->product_options($key);
		if(!empty($options))
		{
			echo $this->load->view("donors/public/_donor_lookup",array("row_key"=>$key),true);
		}
    }

    public function donor_update($key='',$donorId=0)
    {
    	$result['flag']=0;
		if($GLOBALS['subscriptionCartLocked']==1)
		{
			goto end;
		}

		if($this->session->userdata("loggedIn") && $this->currentUser->admin==1)
			$userId=$this->session->userdata('temp_checkout_user')->sso_user_id;
		else
			$userId=$this->currentUser->sso_user_id;

		$options=$this->subscriptionscart->product_options($key);
		if(!empty($options) && $options['subscription']==1)
		{
			$donorData=$this->donors_model->donorData($donorId);
			if(empty($donorData) || $userId!=$donorData->user_id)
			{
				goto end;
			}
			$options['donor_id']=$donorId;
			$updateArray= array(
		               'rowid' => $key,
           			       'options'   => $options
			            );

			$this->subscriptionscart->update($updateArray);
			$this->cart_log_model->log("Donor updated - ID:".$donorId,$this->session->userdata("subscriptionCartAshramId"),4);
			$result['flag']=1;

		}
		end:
		header("Content-Type:application/json");
		echo json_encode($result);
    }

    public function list_donors()
	{
		$userData=array();
		if($this->session->userdata("loggedIn") && $this->currentUser->admin==1)
			$userData=$this->session->userdata('temp_checkout_user');
		else
			$userData=$this->currentUser;

		$list=$this->donors_model->getMyDonors($userData,0);
		echo json_encode($list);
		$this->logaction->log($this->service,"Public - Donors listing ajax request");
	}

	public function load_user_temp($uid=0)
	{
		$data['flag']=0;
		if(is_numeric($uid) && $uid)
		{
			$userData=$this->users_model->userData($uid);
			if(!empty($userData))
			{
				if($userData->status==1 && $userData->deleted==0 && $userData->email_verified==1)
				{
					unset($userData->pin);
					unset($userData->pass);
					unset($userData->conf_key);
					unset($userData->forgot_key);
					unset($userData->pin_copy);
					unset($userData->first_logged_in);
					unset($userData->security_complete);
					unset($userData->pin_set);
					unset($userData->role);
					unset($userData->roles);
					unset($userData->last_logged_in);
					$this->session->set_userdata('temp_checkout_user',$userData);
					$data['flag']=1;
					$data['userdata']=$userData;

					$this->load->library('poojascart');
					$this->load->library('storecart');
					$this->load->library('subscriptionscart');
					$this->load->library('donationscart');
					// $this->cart_model->emptyAllCarts();
				}
				else
				{
					$data['flag']=2;
				}
			}
			else
			{
				$data['flag']=2;
			}
		}
		header("Content-Type:application/json");
		echo json_encode($data);
	}

	public function checkadminPayments()
    {
		$cartContents=$this->subscriptionscart->contents();
		if(count($cartContents) > 1)
        {
			$subcheck = null;
			$d = "";
			foreach($cartContents as $key=>$val)
            {
				if($subcheck != $val['options']['subscription'])
                {
					$d .= "false-";
				}
				if('days' == $val['options']['period'] && $val['options']['subscription'] ==1)
                {
					$dayscheck = "true";
				}
				$subcheck = $val['options']['subscription'];
			}
			$d = explode("-", $d);
			if($d[1] == "false")
            {
				echo 0;
			} else if($d[1] != "false" && $subcheck == 1) {
				echo 3;
			} else if($d[1] != "false" && $subcheck == 1 && $dayscheck == "true") {
				echo 4;
			} else {
				echo 1;
			}

		} else {
			foreach($cartContents as $key=>$val){
				if('days' == $val['options']['period'] && $val['options']['subscription'] ==1){
					$dayscheck = "true";
				}
				$subcheck = $val['options']['subscription'];
			}
			if($subcheck == 1 && $dayscheck == "true") {
				echo 4;
			} else {
				echo 1;
			}
		}
	}

	public function checkadminDonationPayments(){
		$cartContents=$this->subscriptionscart->contents();
		if(count($cartContents) > 1){
			$subcheck = null;
			$d = "";
			foreach($cartContents as $key=>$val){
				if($subcheck != $val['options']['subscription']){
					$d .= "false-";
				}
				if('days' == $val['options']['period'] && $val['options']['subscription'] ==1){
					$dayscheck = "true";
				}
				$subcheck = $val['options']['subscription'];
			}
			$d = explode("-", $d);
			if($d[1] == "false"){
				return 0;
			} else if($d[1] != "false" && $subcheck == 1) {
				return 3;
			} else if($d[1] != "false" && $subcheck == 1 && $dayscheck == "true") {
				return 4;
			} else {
				return 1;
			}

		} else {
			foreach($cartContents as $key=>$val){
				$dayscheck = "";
				if('days' == $val['options']['period'] && $val['options']['subscription'] ==1){
					$dayscheck = "true";
				}
				$subcheck = $val['options']['subscription'];
			}
			if($subcheck == 1 && $dayscheck == "true") {
				return 4;
			} else {
				return 1;
			}
		}
	}

	public function checkuserPayments(){
		$cartContents=$this->subscriptionscart->contents();
		foreach($cartContents as $key=>$val){
			if('days' == $val['options']['period']){
				echo 1;
			}
		}
	}

	public function checkuserDonationPayments(){
		$cartContents=$this->subscriptionscart->contents();
		foreach($cartContents as $key=>$val){
			if('days' == $val['options']['period']){
				return 1;
			}
		}
	}

    public function check_stripe_paytill_cancel()
    {
        $cartContents=$this->subscriptionscart->contents();
        foreach($cartContents as $key=>$val)
        {
            if($val['options']['pay_till_cancel'] == 1)
            {
                return 1;
            }
        }
    }

    public function subscriptionOnFamilyTypeChange()
	{
        $result['flag']=1;
        if($GLOBALS['subscriptionCartLocked']==1)
        {
           echo 11;
            goto end;
        }
		//Get Subscription Item Key
        $subscriptionItemRowKey = "";
        $subscriptionItemRowKey = ($this->input->post('item_row_key')) ? $this->input->post('item_row_key'): '';
        if(!$subscriptionItemRowKey || $subscriptionItemRowKey=='' )
        {
            echo 12;
            goto end;
        }
        $this->form_validation->set_rules('subscription_on_family_type', 'Subscription on Family Type', 'trim|required|checkSubscriptionOnFamilyType');
         if($this->form_validation->run() == FALSE)
        {
            echo 12;
            goto end;
        }
        //Get cart item options
        $itemOpt=$this->subscriptionscart->product_options($subscriptionItemRowKey);
        if(empty($itemOpt))
        {
            echo 13;
            goto end;
        }
        //Update subscription on family type to cart
        $itemOpt['subscription_on_family_type']=$this->input->post('subscription_on_family_type');
        $upd= array(
                 'rowid' => $subscriptionItemRowKey,
                 'options'   => $itemOpt);
        $this->subscriptionscart->update($upd);
        end:
        return $result;
	}

	/*
	public function subscriptionOnFamilyTypeChange_old()
	{
        $result['flag']=1;
        if($GLOBALS['subscriptionCartLocked']==1)
        {
           echo 11;
            goto end;
        }
		$cartId = $this->input->post('cartId');
		$subscriptiononFamilyType = $this->input->post('subscriptiononFamilyType');
		$cartsessId = $this->input->post('cartsessId');
		if($cartId && $subscriptiononFamilyType && $cartsessId)
		{
			$subscriptionFamilySession = $this->session->userdata('subscriptiononFamilyType');
			$subscriptionFamilySessionArr = isset($subscriptionFamilySession)?$subscriptionFamilySession:array();
			$array_merge['subscriptiononFamilyType'] = array_merge($subscriptionFamilySessionArr,array($cartsessId=>$subscriptiononFamilyType));
       		$this->session->set_userdata($array_merge);
		}

        end:
        return $result;
	}
	*/

	public function subscriptionOnFamilyMemberChange()
	{
        $result['flag']=1;
        if($GLOBALS['subscriptionCartLocked']==1)
        {
           	echo 11;
            goto end;
        }
        //Get Subscription item row key
        $subscriptionItemRowKey = ($this->input->post('item_row_key')) ? $this->input->post('item_row_key'): '';
        //Get Subscription on family members
        $subscriptiononFamilyMember = ($this->input->post('subscription_on_family_members')) ? $this->input->post('subscription_on_family_members'): "";
        //Get cart item options
        $itemOpt=$this->subscriptionscart->product_options($subscriptionItemRowKey);
        if(empty($itemOpt))
        {
            echo 13;
            goto end;
        }
        if($subscriptionItemRowKey && $subscriptiononFamilyMember && isset($itemOpt['subscription_on_family_type']) && in_array($itemOpt['subscription_on_family_type'], array('10')))
        {
	        if(!$subscriptionItemRowKey || $subscriptionItemRowKey=='' || !$subscriptiononFamilyMember || $subscriptiononFamilyMember=='')
	        {
	            echo 12;
	            goto end;
	        }

	        if($this->currentUser->admin==1)
	        {
	            if($this->session->userdata('temp_checkout_user'))
	            {
	                $checkoutUserId = $this->session->userdata('temp_checkout_user')->sso_user_id;
	            }
	        }
	        else
	        {
	            $checkoutUserId = $this->currentUser->sso_user_id;
	        }
	        $donors = $this->donors_model->getUserDonorIds($checkoutUserId);
            if($subscriptiononFamilyMember=='' || !is_numeric($subscriptiononFamilyMember) || $subscriptiononFamilyMember==0 || !in_array($subscriptiononFamilyMember, $donors))
            {
                echo 14;
                goto end;
            }
	        //Update subscription on family member to cart
	        $itemOpt['subscription_on_family_member']=$subscriptiononFamilyMember;

	        $upd= array(
	                 'rowid' => $subscriptionItemRowKey,
	                 'options'   => $itemOpt);

	        $this->subscriptionscart->update($upd);
	    }
        end:
        return $result;
	}

	/*
	public function subscriptionOnFamilyMemberChange_old()
	{
        $result['flag']=1;
        if($GLOBALS['subscriptionCartLocked']==1)
        {
           echo 11;
            goto end;
        }
		$cartId = $this->input->post('cartId');
		$subscriptiononFamilyMember = $this->input->post('subscriptiononFamilyMember');
		$cartsessId = $this->input->post('cartsessId');
		if($cartId && $subscriptiononFamilyMember && $cartsessId)
		{
			$subscriptionFamilySession = $this->session->userdata('subscriptiononFamilyMember');
			$subscriptionFamilySessionArr = isset($subscriptionFamilySession)?$subscriptionFamilySession:array();
			$array_merge['subscriptiononFamilyMember'] = array_merge($subscriptionFamilySessionArr,array($cartsessId=>$subscriptiononFamilyMember));
       		$this->session->set_userdata($array_merge);
		}
        
        end:
        return $result;
	}
	*/

    public function clearCart()
    {
        $result['flag']=0;
        if($GLOBALS['subscriptionCartLocked']==1)
        {
            $result['flag']=11;
            goto end;
        }
        $cart=$this->subscriptionscart->contents();
        if(empty($cart))
        {
            $result['flag']=2;
        }
        else 
        {
            foreach ($cart as $key => $value)
            {
                if(isset($key) && $key!='')
                {
                    $item=$this->subscriptionscart->get_item($key);
                    if(!empty($item))
                    {
                        $upd= array(
                                   'rowid' => $key,
                                    'qty'   => 0
                                    );
                        $this->subscriptionscart->update($upd);
                        $this->logaction->log($this->service,"Subscription removed from cart _ Subscription ID:".$item['id']." _ ".$item['name']." _ Row ID: ".$key);
                        $this->cart_log_model->log("Item removed - Name:".$item['name'],$this->session->userdata("subscriptionCartAshramId"),4);
                    }
                }
            }
            $cc=$this->subscriptionscart->contents();
            if(count($cc)==0)
            {
                $this->session->unset_userdata('subscriptionCartAshramId');
                $result['flag']=1;
                $result['cart_count']=count($cc);
                $result['currency'] = '';
                $result['ashram_id'] = '';
                if($this->session->userdata('subscriptionCartAshramIdSelection')>0)
                {
                    $result['ashram_id'] = $this->session->userdata('subscriptionCartAshramIdSelection');
                }
                if($this->session->userdata("defaultCurrency"))
                {
                    $result['currency'] = $this->session->userdata("defaultCurrency");
                }
            } else {
                $result['flag']=3;
                $result['cart_count']=count($cc);
            }
            $this->cart_model->regenerateSession(1);
        }
        end:
        echo json_encode($result);
    }

    public function updateOtherName($othernamefor=0)
    {
        if($GLOBALS['subscriptionCartLocked']==1)
        {
            echo 2;
            return;
        }
        if(!in_array($othernamefor, [1]))
        {
            echo 0;
            return;
        }

        $this->form_validation->set_rules('value', 'Name','trim|required|min_length[2]|max_length[60]');
        $this->form_validation->set_rules('pk', 'ID', 'trim|required');
        if($this->form_validation->run() == FALSE)
        {
            echo 0;
            return;
        }
        $item=$this->subscriptionscart->get_item($_POST['pk']);
        $options=$this->subscriptionscart->product_options($_POST['pk']);
        if(!empty($options))
        {
            $options['other_name'.$othernamefor]=$_POST['value'];
            $updateArray= array(
                       'rowid' => $_POST['pk'],
                           'options'   => $options
                        );
            $this->subscriptionscart->update($updateArray);
            $this->cart_log_model->log("Other name updated, Item name:".$item['name'],$this->session->userdata("subscriptionCartAshramId"),1);
            echo 1;
        }
        else
        {
            echo 0;
        }
    }

    public function appji_subscription($linkToken = '')
    {
        $data['slug']="subscriptions";
        $data['is_this_appji_subscription']=1;
        if($GLOBALS['site_settings']['enable_orders']==0)
        {
            $data['showErrorMessage'] = '<h4 style="margin:0px;">Website is under maintenance, please try after some time.</h4>';
            $data['views'] = array('ashrams/public/appji_subscriptions');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }
        if($linkToken == '')
        {
            $data['views'] = array('common/public/error');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }
        $this->load->model('appji/appji_model');
        $subscriptionLinkDetails=$this->appji_model->subscriptionLinkDetailsByLinkToken($linkToken);
        if(empty($subscriptionLinkDetails))
        {
            $data['views'] = array('common/public/error');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }
        if( (isset($subscriptionLinkDetails['isLinkExpired']) && $subscriptionLinkDetails['isLinkExpired']==1) )
        {
            $data['showErrorMessage'] = '<h4 style="margin:0px;">This Subscription has already been paid or no longer valid.</h4>';
            $data['views'] = array('ashrams/public/appji_subscriptions');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }
        $expiryDate = '';
        if(isset($subscriptionLinkDetails['linkExpiryTime']) && $subscriptionLinkDetails['linkExpiryTime']!='')
        {
            $expiryDate = date("Y-m-d H:i:s", $subscriptionLinkDetails['linkExpiryTime']);
        }

        if( $expiryDate!='' && $expiryDate<date('Y-m-d H:i:s'))
        {
            $data['showErrorMessage'] = '<h4 style="margin:0px;">Sorry, the link has expired. Please contact Appji support: <a href = "mailto: support@appji.org">support@appji.org</a> </h4>';
            $data['views'] = array('ashrams/public/appji_subscriptions');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }

        if($this->session->userdata("loggedIn") && $this->currentUser->admin==0)
        {
            if($this->currentUser->email_verified==0)
            {
                $data['showErrorMessage'] = '<h4 style="margin:0px;">Please verify your email and try again.</h4>';
                $data['views'] = array('ashrams/public/appji_subscriptions');
                $this->load->view(FRONTEND_TEMPLATE,$data);
                return;
            }
        }
        if($this->session->userdata("loggedIn") && $this->currentUser->admin==1)
        {
            if(!$this->session->userdata('temp_checkout_user'))
            {
                $data['showErrorMessage'] = '<h4 style="margin:0px;">Please select user before adding subscription to cart.</h4>';
                $data['views'] = array('ashrams/public/appji_subscriptions');
                $this->load->view(FRONTEND_TEMPLATE,$data);
                return;
            }
        }

        if(!empty($this->subscriptionscart->contents()))
        foreach($this->subscriptionscart->contents() as $key=>$val)
        {
            $subscriptionData=$this->subscriptions_model->subscriptionData($val['id']);
            break;
        }

        if($this->session->userdata('subscriptionCartAshramId')=="" && (isset($subscriptionData->ashram_id) && $subscriptionData->ashram_id>0))
        {
        	$this->session->set_userdata('subscriptionCartAshramId',$subscriptionData->ashram_id);
        }
		
        if(isset($subscriptionData->subscriptionCurrency) && in_array(strtolower($subscriptionData->subscriptionCurrency), array('inr','usd')))
        {
        	$this->session->set_userdata('defaultCurrency',strtolower($subscriptionData->subscriptionCurrency));
        }

        if(isset($subscriptionData->ashram_id) && $subscriptionData->ashram_id!=appji_ashram_id)
        {
            $ashramData=$this->ashrams_model->ashramData($subscriptionData->ashram_id);
            $ashramName=$ashramData->name;
            $data['showErrorMessage'] = '<h5 style="margin:0px;"><strong>Jaya Guru Datta. You already have items from "'.$ashramName.'" ashram in your cart. If you wish to add items from another ashram/event, empty the cart and try again.</strong><a href="#clearCartModal" class="btn btn-danger btn-xs" data-toggle="modal" style="margin-left: 10px;"><i class="fa fa-times"></i> Clear Cart</a></h5>';
            $data['views'] = array('ashrams/public/appji_subscriptions');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }

        if($GLOBALS['subscriptionCartLocked']==1)
        {
            $data['showErrorMessage'] = '<h4 style="margin:0px;">Subscription cart is locked. Please clear your cart to add this item. <a href="#clearCartModal" class="btn btn-danger btn-xs" data-toggle="modal" style="margin-left: 10px;"><i class="fa fa-times"></i> Clear Cart</a></h4>';
            $data['views'] = array('ashrams/public/appji_subscriptions');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }

        $cart=$this->subscriptionscart->contents();
        foreach($cart as $thiscartitem)
        {
			if(count($cart)>=1 && (isset($thiscartitem['options']['appji_link_token']) && $linkToken != $thiscartitem['options']['appji_link_token']))
			{
				$data['showErrorMessage'] = '<h5 style="margin:0px;"><strong>Jaya Guru Datta. You already have a subscription added to your cart. Only one item is allowed per checkout at a time. If you wish to add this item, empty the cart and try again.</strong><a href="#clearCartModal" class="btn btn-danger btn-xs" data-toggle="modal" style="margin-left: 10px;"><i class="fa fa-times"></i> Clear Cart</a></h5>';
				$data['views'] = array('ashrams/public/appji_subscriptions');
				$this->load->view(FRONTEND_TEMPLATE,$data);
				return;
			}
            if(isset($thiscartitem['options']['appji_link_token']) && $linkToken == $thiscartitem['options']['appji_link_token'])
            {
            	if($thiscartitem['options']['result_date'] != date("d M Y"))
            	{
            		$cart=$this->subscriptionscart->contents();
			        if(empty($cart))
			        {
			            
			        }
			        else 
			        {
			            foreach ($cart as $key => $value)
			            {
			                if(isset($key) && $key!='')
			                {
			                    $item=$this->subscriptionscart->get_item($key);
			                    if(!empty($item))
			                    {
			                        $upd= array(
			                                   'rowid' => $key,
			                                    'qty'   => 0
			                                    );
			                        $this->subscriptionscart->update($upd);
			                        $this->logaction->log($this->service,"Subscription removed from cart _ Subscription ID:".$item['id']." _ ".$item['name']." _ Row ID: ".$key);
			                        $this->cart_log_model->log("Item removed - Name:".$item['name'],$this->session->userdata("subscriptionCartAshramId"),4);
			                    }
			                }
			            }
			            $this->cart_model->regenerateSession(4);
			        } 
            	}
            	else
            	{
                	redirect("subscriptions/checkout?ashram_id=".$subscriptionData->ashram_id."&currency=".strtolower($subscriptionLinkDetails['subscriptionCurrency']));
            	}
            }

            if(isset($thiscartitem['options']['appji_currency']) && $subscriptionLinkDetails['subscriptionCurrency'] != $thiscartitem['options']['appji_currency'])
            {
                $data['showErrorMessage'] = '<h5 style="margin:0px;"><strong>Jaya Guru Datta. You already have items in your cart with a different currency. If you wish to add this item, empty the cart and try again.<br><br><strong>Clear previous cart and proceed.</strong><a href="#clearCartModal" class="btn btn-danger btn-xs" data-toggle="modal" style="margin-left: 10px;"><i class="fa fa-times"></i> Clear Previous Cart</a><br><br><strong>Proceed with previous cart.</strong><a href="'.base_url().'subscriptions/checkout?ashram_id='.$subscriptionData->ashram_id.'&currency='.strtolower($thiscartitem['options']['appji_currency']).'" class="btn btn-primary btn-xs" style="margin-left: 10px;"><i class="fa fa-times"></i> Proceed with Previous Cart</a></h5>';
                $data['views'] = array('ashrams/public/appji_subscriptions');
                $this->load->view(FRONTEND_TEMPLATE,$data);
                return;
            }
        }
        $cartCount = count($cart);
        if($cartCount >= 50)
        {
            $data['showErrorMessage']='<h4 style="margin:0px;">MAX 50 items are allowed to cart.</h4>';
            $data['views'] = array('ashrams/public/appji_subscriptions');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }
        $amount=$this->cart_model->getTotalPrice($this->subscriptionscart, $linkToken, 'subscription');
        $subscriptionData=$this->subscriptions_model->subscriptionData(appji_subscription_id);
        $col="price_".strtolower($subscriptionLinkDetails['subscriptionCurrency']);
        if(empty($subscriptionData))
        {
            $data['showErrorMessage']='subscription item is unavailable';
            $data['views'] = array('ashrams/public/appji_subscriptions');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }
        
        $displayCol=strtolower($subscriptionLinkDetails['subscriptionCurrency'])."_display";
        if($subscriptionData->$displayCol==0)
        {
            $data['showErrorMessage']='subscription item is unavailable';
            $data['views'] = array('ashrams/public/appji_subscriptions');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }

        if($subscriptionData->display_only_popup==1)
        {
            $data['showErrorMessage']='You can not add this Item, Display only Popup Item';
            $data['views'] = array('ashrams/public/appji_subscriptions');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }

        if($subscriptionData->subscription==1)
        {
            $tempUserId=0;
            if($this->session->userdata("loggedIn") && $this->currentUser->admin==1)
                $tempUserId=$this->session->userdata('temp_checkout_user')->sso_user_id;
            else
                $tempUserId=$this->currentUser->sso_user_id;

            $donorsCount=$this->donors_model->getCountByUser($tempUserId);
            if($donorsCount==0)
            {
                $this->donors_model->createDefault($tempUserId);
            }
        }

        if(isset($subscriptionLinkDetails['subscriptionAmount']))
        {
            if($subscriptionLinkDetails['subscriptionAmount']=='')
            {
                $data['showErrorMessage']='subscription amount is required';
                $data['views'] = array('ashrams/public/appji_subscriptions');
                $this->load->view(FRONTEND_TEMPLATE,$data);
                return;
            }
            if(!preg_match("/^\d+$/",$subscriptionLinkDetails['subscriptionAmount']))
            {
                $data['showErrorMessage']='subscription amount should contains only digits';
                $data['views'] = array('ashrams/public/appji_subscriptions');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
            }

            if(strlen($subscriptionLinkDetails['subscriptionAmount'])!=strlen(abs($subscriptionLinkDetails['subscriptionAmount'])))
            {
                $data['showErrorMessage']='subscription amount should be valid amount';
                $data['views'] = array('ashrams/public/appji_subscriptions');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
            }
        }
        else
        {
            $data['showErrorMessage']='subscription amount is required';
            $data['views'] = array('ashrams/public/appji_subscriptions');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }
        
        $netAmount=$amount+$subscriptionLinkDetails['subscriptionAmount'];

        if(empty($this->currencies))
        {
            $this->currencies=$this->currencies_model->getByAshram(appji_ashram_id);
        }

        if(strtolower($subscriptionLinkDetails['subscriptionCurrency'])=='inr' &&
            $netAmount>$this->currencies[$subscriptionLinkDetails['subscriptionCurrency']]['max'])
        {
            $data['showErrorMessage']='Sorry! Maximum allowed amount for checkout is INR '.$this->currencies[$subscriptionLinkDetails['subscriptionCurrency']]['max'];
            $data['views'] = array('ashrams/public/appji_subscriptions');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }
        if(strtolower($subscriptionLinkDetails['subscriptionCurrency'])=='usd' &&
            $netAmount>$this->currencies[$subscriptionLinkDetails['subscriptionCurrency']]['max'])
        {
            $data['showErrorMessage']='Sorry! Maximum allowed amount for checkout is USD '.$this->currencies[$subscriptionLinkDetails['subscriptionCurrency']]['max'];
            $data['views'] = array('ashrams/public/appji_subscriptions');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }

        if(strtolower($subscriptionLinkDetails['subscriptionCurrency'])=='inr')
        {
            $minAmount=$this->currencies[$subscriptionLinkDetails['subscriptionCurrency']]['min'];
            $maxAmount=$this->currencies[$subscriptionLinkDetails['subscriptionCurrency']]['max'];
        }
        if(strtolower($subscriptionLinkDetails['subscriptionCurrency'])=='usd')
        {
            $minAmount=$this->currencies[$subscriptionLinkDetails['subscriptionCurrency']]['min'];
            $maxAmount=$this->currencies[$subscriptionLinkDetails['subscriptionCurrency']]['max'];
        }

        if(trim(abs($subscriptionLinkDetails['subscriptionAmount']))<$minAmount)
        {
            $data['showErrorMessage']='Minimum amount is '.strtoupper($subscriptionLinkDetails['subscriptionCurrency'])." ".$minAmount;
            $data['views'] = array('ashrams/public/appji_subscriptions');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }
        if(trim(abs($subscriptionLinkDetails['subscriptionAmount']))>$maxAmount)
        {
            $data['showErrorMessage']='Maximum amount is '.strtoupper($subscriptionLinkDetails['subscriptionCurrency'])." ".$maxAmount;
            $data['views'] = array('ashrams/public/appji_subscriptions');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return;
        }

        $data['item']=$subscriptionData;
        $data['type']='subscription';
        $data['amount']=$subscriptionLinkDetails['subscriptionAmount'];
        $data['personal_note']='';
        $data['note']='';
        $data['other_name1']='';
        $data['other_name2']='';
        $data['other_name3']='';
        $data['other_name4']='';
        $data['other_name5']='';
        $data['other_name6']='';
        $data['is_appji_subscription']=1;
        $data['appji_subscription_date']=$subscriptionLinkDetails['subscriptionDate'];
        $data['appji_currency']=$subscriptionLinkDetails['subscriptionCurrency'];
        $data['appji_subscription_amount']=$subscriptionLinkDetails['subscriptionAmount'];
        $data['appji_link_token']=$subscriptionLinkDetails['linkToken'];
        $data['appji_email']=$subscriptionLinkDetails['appjiEmail'];
        $data['appji_user_full_name']=$subscriptionLinkDetails['appjiUserFullName'];
        $data['period']=$subscriptionLinkDetails['subscriptionPeriod'];
        if($this->session->userdata("loggedIn"))
        {
            if($this->currentUser->admin==0)
            {
                $data['note']=$this->currentUser->family_details;
            }
            else
            {
                if($this->session->userdata('temp_checkout_user'))
                {
                    $data['note']=$this->session->userdata('temp_checkout_user')->family_details;
                }
            }
        }

        if($subscriptionData->ashram_id==appji_ashram_id || count($cart)==0)
        {
            $response=$this->cart_model->addItem($data,1,$this->subscriptionscart);
            $flag=$response['flag'];
            if(isset($response['rowid']) && $response['rowid']!='')
            {
                $data['rowKey'] = $response['rowid'];
            }
            if($flag==-2)
            {
                $this->logaction->log($this->service,"subscription added to cart _ subscription ID:".$subscriptionData->id." _ ".$subscriptionData->subscription_name." _ Row ID: ".$response['rowid']);
                $data['flag']=1;
                $this->session->set_userdata('subscriptionCartAshramId',$subscriptionData->ashram_id);
                $this->cart_log_model->log("Item added - Name:".$subscriptionData->subscription_name.", Amount:".strtoupper($data['appji_currency'])." ".$data['amount'],appji_ashram_id,2);
                redirect("subscriptions/checkout?ashram_id=".$subscriptionData->ashram_id."&currency=".strtolower($data['appji_currency']));
            }
            else
            {
                $data['showErrorMessage']='Something went wrong while adding item to cart please try again later';
                $data['views'] = array('ashrams/public/appji_subscriptions');
                $this->load->view(FRONTEND_TEMPLATE,$data);
                return;
            }
        }
    }

    public function clear_cart_and_temp_user()
    {
        $cart=$this->subscriptionscart->contents();
        if(!empty($cart))
        {
            foreach ($cart as $key => $value)
            {
                if(isset($key) && $key!='')
                {
                    $item=$this->subscriptionscart->get_item($key);
                    if(!empty($item))
                    {
                        $upd= array(
                                   'rowid' => $key,
                                    'qty'   => 0
                                    );
                        $this->subscriptionscart->update($upd);
                        $this->logaction->log($this->service,"subscription removed from cart _ subscription ID:".$item['id']." _ ".$item['name']." _ Row ID: ".$key);
                        $this->cart_log_model->log("Item removed - Name:".$item['name'],$this->session->userdata("subscriptionCartAshramId"),4);
                    }
                }
            }
            
        }

        $this->session->unset_userdata('subscriptionCartAshramId');
        $this->session->unset_userdata('subscriptionCartAshramIdSelection');
        $this->session->unset_userdata('defaultCurrency');
        $this->session->unset_userdata('temp_checkout_user');
        $data['flag']=1;
        header("Content-Type:application/json");
        echo json_encode($data);
    }
    
}
?>