<?php 
#Author : Baji shaik
#Created On : 20th Oct 2018
#Reason : To save/update the data when application get the responce from Stripe Gateway(Technically Webhook Url). Stripe call this url when an event occured from stripe

require 'vendor/autoload.php';
class Stripewebhook extends CI_Controller 
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('payment_model');
		$this->load->model('orders/orders_model');
		//Model Added by Baji To save subscription ids
		$this->load->model('stripe_subscriptions_model','stripesubscriptions');
		$this->load->model('orders/subscription_payments_model');
		$this->load->model('stripe_logs_model','stripelogs');
		$this->load->model("stripe_webhook_model");
		$this->load->model("subscriptions/donors_model");
		//Done by Baji's newly Added models
		$this->load->model('orders/transaction_model');
		$this->load->model('orders/order_log_model');
		$this->load->model('ashrams/ashrams_trust_accounts_model');
	}

	public function inr()
	{
		$body = @file_get_contents('php://input');
		$event_json = json_decode($body);
		/*
		$endpoint_secret = stripe_webhook_secret_key_inr;

		$sig_header = $_SERVER['HTTP_STRIPE_SIGNATURE'];

		try 
		{
		    $event = \Stripe\Webhook::constructEvent(
		        $body, $sig_header, $endpoint_secret
		    );
		}
		catch(\UnexpectedValueException $e)
		{
		    // Invalid payload
		    http_response_code(400);
		    exit();
		}
		catch(\Stripe\Exception\SignatureVerificationException $e) 
		{
		    // Invalid signature
		    http_response_code(400);
		    exit();
		}
		*/
		$stripestatusarray = ["charge.updated",
						    "charge.pending",
						    "customer.subscription.updated",
						    "customer.subscription.trial_will_end",
						    "customer.subscription.pending_update_expired",
						    "customer.subscription.pending_update_applied",
						    "customer.subscription.deleted",
						    "customer.subscription.created",
						    "invoice.payment_succeeded",
						    "invoice.payment_failed",
						    "checkout.session.async_payment_failed",
						    "checkout.session.async_payment_succeeded",
						    "checkout.session.completed",
						    "charge.refund.updated",
						    "charge.succeeded",
						    "charge.refunded",
						    "charge.failed",
						    "charge.captured"
							];

		$sub = "";
		if(in_array($event_json->type,$stripestatusarray))
		{
			$k = $event_json->data;
			$customer = "";
			$amount = 0;
			$r = new stdclass();
			$r->amount = "";
			$r->customer = "";
			foreach($k as $r)
			{
				$subscription = isset($r->subscription)?$r->subscription:"";
				$cust = isset($r->customer)?$r->customer:"";
				$charg = isset($r->charge)?$r->charge:"";
				$money = isset($r->amount_paid)?($r->amount_paid/100):"";

				$sub = $subscription;
				$customer = $cust;
				$currency = isset($r->currency)?$r->currency:"";
				// $currency = $r->currency;
				$amount =  $money;
				$tx = $charg;
				$status = $event_json->type;
			}

			if(empty($sub))
			{
				$charg = isset($k->object->id)?$k->object->id:"";
				$tx = $charg;
				$money = isset($k->object->amount)?($k->object->amount/100):"";
				$amount =  $money;
			}

			if($event_json->type == "charge.refunded")
			{
				$money = isset($k->object->amount_refunded)?($k->object->amount_refunded/100):"";
				$amount =  $money;
			}

			if($sub && $status == 'invoice.payment_succeeded')
			{
				$data = array('log_event'=>'this is in hook now '.$sub. ' and customer is '.$customer,'created_on'=>date('Y-m-d H:i:s'),'module'=>'stripe web hook');

				$this->stripelogs->savelogs($data);
				
				$query = $this->stripesubscriptions->getSubscription($sub);

				if($query->num_rows() > 0)
				{
					$data = array('log_event'=>'this is in hook now in num rows'.$sub. ' and customer is '.$customer,'created_on'=>date('Y-m-d H:i:s'),'module'=>'stripe web hook');

					$this->stripelogs->savelogs($data);

					$itemData=$this->orders_model->itemData($query->result()[0]->order_item_id);
					$invoice_date = date("Y-m-d",$event_json->data->object->created);

					$query1 = $this->stripesubscriptions->getSubPaymentNumber($query->result()[0]->order_item_id,$invoice_date);

					if($query1->num_rows() > 0 && empty($query1->result()[0]->tx))
					{
						$completed_count = $query->result()[0]->completed_payments_count;
						$completed_count = isset($completed_count) ? $completed_count : 0;
						$total_count = $query->result()[0]->total_payments_count;

						if($completed_count != $total_count && $total_count >= $completed_count)
						{
							$data = array('log_event'=>'this is in hook now in satisfying'.$sub. ' and customer is '.$customer,'created_on'=>date('Y-m-d H:i:s'),'module'=>'stripe web hook');

							$this->stripelogs->savelogs($data);
							$updateData = array('completed_payments_count'=>$completed_count+1);
							if($itemData->pay_till_cancel == 1)
							{
								$this->load->model("orders/subscription_payments_model");
								$paymentRow = $this->subscription_payments_model->getPrevRow($query->result()[0]->order_item_id);
								$start = strtotime($itemData->schedule_dates);
								$start=strtotime("+".$itemData->frequency." ".$itemData->period,$start);
								$this->createduplicateRecord($paymentRow,$itemData,$query->result()[0]->order_item_id,$itemData->order_id,$start);
							}
							$accuratecount = $completed_count+1;
							$this->stripesubscriptions->updatesubscriptions($query1->result()[0]->payment_number,$tx,$query->result()[0]->order_item_id,$amount,$currency,$sub,$event_json);
							$this->stripesubscriptions->updateStripesubId($updateData,$sub);
						}
						else
						{
							$orderData=$this->orders_model->orderData($query->result()[0]->order_id);

							$trustData = $this->getStripeTrustDetails($orderData['order']->ashram_id,$orderData['order']->currency,$orderData['order']->order_type);

							\Stripe\Stripe::setApiKey($trustData->stripe_secret_key);
							$subscription = \Stripe\Subscription::retrieve($sub);
							$subscription->cancel();

							$updateData = array('status'=>'Completed','completed_on'=>date('Y-m-d'));
							$this->stripesubscriptions->updateStripesubId($updateData,$sub);
						}
					}
				}
			}
			if($sub && $status == 'invoice.payment_failed')
			{
				$data = array('log_event'=>'this is in hook now '.$sub. ' and customer is '.$customer,'created_on'=>date('Y-m-d H:i:s'),'module'=>'stripe web hook');

				$this->stripelogs->savelogs($data);
				
				$query = $this->stripesubscriptions->getSubscription($sub);

				if($query->num_rows() > 0)
				{
					$invoice_date = date("Y-m-d",$event_json->data->object->created);
					$query1 = $this->stripesubscriptions->getSubPaymentNumber($query->result()[0]->order_item_id,$invoice_date);
					if($query1->num_rows() > 0)
					{
						$data = array('log_event'=>'this is in hook now in num rows'.$sub. ' and customer is '.$customer,'created_on'=>date('Y-m-d H:i:s'),'module'=>'stripe web hook');

						$this->stripelogs->savelogs($data);

						$this->razorpay_webhook_model->paymentFail($tx,$sub,$query->result()[0]->order_item_id,$query->result()[0]->order_id,$amount,$currency,$body,$invoice_date);
					}
				}
			}
			
			$endoce_event = json_encode($event_json);
			$data = array('transaction_id'=>$tx,'customer_id'=>$customer,'subscription_id'=>$sub,'data'=>$endoce_event,'amount'=>$amount,'created_on'=>date('Y-m-d H:i:s'),'status'=>$status);
			$this->stripe_webhook_model->savehookData($data);
		}
		http_response_code(200);
	}
	
	public function usd()
	{
		$body = @file_get_contents('php://input');
		$event_json = json_decode($body);
		/*
		$endpoint_secret = stripe_webhook_secret_key_usd;
		$sig_header = $_SERVER['HTTP_STRIPE_SIGNATURE'];

		try 
		{
		    $event = \Stripe\Webhook::constructEvent(
		        $body, $sig_header, $endpoint_secret
		    );
		}
		catch(\UnexpectedValueException $e)
		{
		    // Invalid payload
		    http_response_code(400);
		    exit();
		}
		catch(\Stripe\Exception\SignatureVerificationException $e) 
		{
		    // Invalid signature
		    http_response_code(400);
		    exit();
		}
		*/
		$stripestatusarray = ["charge.updated",
						    "charge.pending",
						    "customer.subscription.updated",
						    "customer.subscription.trial_will_end",
						    "customer.subscription.pending_update_expired",
						    "customer.subscription.pending_update_applied",
						    "customer.subscription.deleted",
						    "customer.subscription.created",
						    "invoice.payment_succeeded",
						    "invoice.payment_failed",
						    "checkout.session.async_payment_failed",
						    "checkout.session.async_payment_succeeded",
						    "checkout.session.completed",
						    "charge.refund.updated",
						    "charge.succeeded",
						    "charge.refunded",
						    "charge.failed",
						    "charge.captured"
							];

		$sub = "";
		if(in_array($event_json->type,$stripestatusarray))
		{
			// log_message('error', "**********STripe USD Webhook Response Starts************");
			// log_message('error', $r);
			// log_message('error', "**********STripe USD Webhook Response Ends************");
			$k = $event_json->data;
			$customer = "";
			$amount = 0;
			$r = new stdclass();
			$r->amount = "";
			$r->customer = "";
			foreach($k as $r)
			{
				// log_message('debug',$r);
				$subscription = isset($r->subscription)?$r->subscription:"";
				$cust = isset($r->customer)?$r->customer:"";
				$charg = isset($r->charge)?$r->charge:"";
				$money = isset($r->amount_paid)?($r->amount_paid/100):"";

				$sub = $subscription;
				$customer = $cust;
				$currency = isset($r->currency)?$r->currency:"";
				// $currency = $r->currency;
				$amount =  $money;
				$tx = $charg;
				$status = $event_json->type;
			}

			if(empty($sub))
			{
				$charg = isset($k->object->id)?$k->object->id:"";
				$tx = $charg;
				$money = isset($k->object->amount)?($k->object->amount/100):"";
				$amount =  $money;
			}

			if($event_json->type == "charge.refunded")
			{
				$money = isset($k->object->amount_refunded)?($k->object->amount_refunded/100):"";
				$amount =  $money;
			}

			if($sub && $status == 'invoice.payment_succeeded')
			{
				$data = array('log_event'=>'this is in hook now '.$sub. ' and customer is '.$customer,'created_on'=>date('Y-m-d H:i:s'),'module'=>'stripe web hook');

				$this->stripelogs->savelogs($data);
				
				$query = $this->stripesubscriptions->getSubscription($sub);

				if($query->num_rows() > 0)
				{
					$data = array('log_event'=>'this is in hook now in num rows'.$sub. ' and customer is '.$customer,'created_on'=>date('Y-m-d H:i:s'),'module'=>'stripe web hook');

					$this->stripelogs->savelogs($data);

					$itemData=$this->orders_model->itemData($query->result()[0]->order_item_id);
					$invoice_date = date("Y-m-d",$event_json->data->object->created);

					$query1 = $this->stripesubscriptions->getSubPaymentNumber($query->result()[0]->order_item_id,$invoice_date);

					if($query1->num_rows() > 0 && empty($query1->result()[0]->tx))
					{
						$completed_count = $query->result()[0]->completed_payments_count;
						$completed_count = isset($completed_count) ? $completed_count : 0;
						$total_count = $query->result()[0]->total_payments_count;

						if($completed_count != $total_count && $total_count >= $completed_count)
						{
							$data = array('log_event'=>'this is in hook now in satisfying'.$sub. ' and customer is '.$customer,'created_on'=>date('Y-m-d H:i:s'),'module'=>'stripe web hook');

							$this->stripelogs->savelogs($data);
							$updateData = array('completed_payments_count'=>$completed_count+1);
							if($itemData->pay_till_cancel == 1)
							{
								$this->load->model("orders/subscription_payments_model");
								$paymentRow = $this->subscription_payments_model->getPrevRow($query->result()[0]->order_item_id);
								$start = strtotime($itemData->schedule_dates);
								$start=strtotime("+".$itemData->frequency." ".$itemData->period,$start);
								$this->createduplicateRecord($paymentRow,$itemData,$query->result()[0]->order_item_id,$itemData->order_id,$start);
							}
							$accuratecount = $completed_count+1;
							$this->stripesubscriptions->updatesubscriptions($query1->result()[0]->payment_number,$tx,$query->result()[0]->order_item_id,$amount,$currency,$sub,$event_json);
							$this->stripesubscriptions->updateStripesubId($updateData,$sub);
						}
						else
						{
							$orderData=$this->orders_model->orderData($query->result()[0]->order_id);

							$trustData = $this->getStripeTrustDetails($orderData['order']->ashram_id,$orderData['order']->currency,$orderData['order']->order_type);

							\Stripe\Stripe::setApiKey($trustData->stripe_secret_key);
							$subscription = \Stripe\Subscription::retrieve($sub);
							$subscription->cancel();

							$updateData = array('status'=>'Completed','completed_on'=>date('Y-m-d'));
							$this->stripesubscriptions->updateStripesubId($updateData,$sub);
						}
					}
				}
			}
			if($sub && $status == 'invoice.payment_failed')
			{
				$data = array('log_event'=>'this is in hook now '.$sub. ' and customer is '.$customer,'created_on'=>date('Y-m-d H:i:s'),'module'=>'stripe web hook');

				$this->stripelogs->savelogs($data);
				
				$query = $this->stripesubscriptions->getSubscription($sub);

				if($query->num_rows() > 0)
				{
					$invoice_date = date("Y-m-d",$event_json->data->object->created);
					$query1 = $this->stripesubscriptions->getSubPaymentNumber($query->result()[0]->order_item_id,$invoice_date);
					if($query1->num_rows() > 0)
					{
						$data = array('log_event'=>'this is in hook now in num rows'.$sub. ' and customer is '.$customer,'created_on'=>date('Y-m-d H:i:s'),'module'=>'stripe web hook');

						$this->stripelogs->savelogs($data);

						$this->razorpay_webhook_model->paymentFail($tx,$sub,$query->result()[0]->order_item_id,$query->result()[0]->order_id,$amount,$currency,$body,$invoice_date);
					}
				}
			}
			
			$endoce_event = json_encode($event_json);
			$data = array('transaction_id'=>$tx,'customer_id'=>$customer,'subscription_id'=>$sub,'data'=>$endoce_event,'amount'=>$amount,'created_on'=>date('Y-m-d H:i:s'),'status'=>$status);
			$this->stripe_webhook_model->savehookData($data);
		}
		http_response_code(200);
	}

	public function createduplicateRecord($subData,$itemData,$itemId,$orderId,$paymentDate)
	{
		$paymentnumber = $subData->payment_number+1;
		$dataArray = array(
            "order_item_id"=>$itemId,
            "order_id"=>$orderId,
            "payment_date"=>date("Y:m:d",$paymentDate),
            "amount"=>$itemData->price,
            "payment_number"=>$paymentnumber,
            "created_on"=>date("Y:m:d H:i:s")
        );
        $this->stripe_webhook_model->createSubRow($dataArray);
        $this->stripe_webhook_model->updateNumPayments($itemId,$paymentnumber);
	}

	public function getStripeTrustDetails($ashramId,$currency,$orderType)
	{
		if($ashramId)
		{
			$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($ashramId,$orderType);
	    	$trustsArray=array();
	    	foreach ($trusts as $trustData)
	    	{
	    		$trustsArray[$trustData->currency]=$trustData;
	    	}
	    	$trustData=$trustsArray[$currency];
	    	return $trustData;
		}
		return false;
	}

	public function getUniqueTrustStripeSecretKeys()
	{

		$trusts=$this->ashrams_trust_accounts_model->getAllTrustsByPaymentGateway('stripe');
		$trustSecreatKeys = [];
		if(!empty($trusts))
		{
			$trustSecreatKeys = array_column($trusts, 'stripe_secret_key');
			if(!empty($trustSecreatKeys))
			{
				$trustSecreatKeys = array_unique($trustSecreatKeys);
			}
		}
		return $trustSecreatKeys;
	}

	public function listAllSubscriptions()
	{
		$allSubscriptions = [];
		// $trustSecreatKeys = $this->getUniqueTrustStripeSecretKeys();
		// if(!empty($trustSecreatKeys))
		// {
		// 	foreach($trustSecreatKeys as $thisTrustSecreatKey)
		// 	{
		// 		if($thisTrustSecreatKey!='')
		// 		{
		// 	        \Stripe\Stripe::setApiKey($thisTrustSecreatKey);
		// 	        $subscriptions = \Stripe\Subscription::all();
		// 	    }
		// 	    if(isset($subscriptions) && !empty($subscriptions))
		// 	    {
		// 	    	foreach($subscriptions as $thisSubscription)
		// 	    	{
		// 				$allSubscriptions[] = $thisSubscription->id;
		// 	    	}
		// 	    }
		// 	}
		// }



		$trustData = $this->getStripeTrustDetails(16,'inr',4);
		if(isset($trustData->stripe_secret_key) && $trustData->stripe_secret_key!='')
		{
	        \Stripe\Stripe::setApiKey($trustData->stripe_secret_key);
	        $subscriptions = \Stripe\Subscription::all();
	    }
	    if(isset($subscriptions) && !empty($subscriptions))
	    {
	    	foreach($subscriptions as $thisSubscription)
	    	{
				$allSubscriptions[] = $thisSubscription->id;
	    	}
	    }

	    
	    echo '<pre>'; print_r($allSubscriptions); die();
	}


	public function listWebhookEndPoints()
	{
		$trustData = $this->getStripeTrustDetails(16,'inr',4);

		if(isset($trustData->stripe_secret_key) && $trustData->stripe_secret_key!='')
		{
	        \Stripe\Stripe::setApiKey($trustData->stripe_secret_key);
	        $webHookEndPoints = \Stripe\WebhookEndpoint::all();
	        echo '<pre>'; print_r($webHookEndPoints)."<br>"; die();
	    }
	    if(isset($webHookEndPoints) && !empty($webHookEndPoints))
	    {
	    	foreach($webHookEndPoints as $thiswebHookEndPoint)
	    	{
				echo '<pre>'; print_r($thiswebHookEndPoint)."<br>";
	    	}
	    }
	}
}