<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Storeadmin extends CI_Controller 
{
	var $service='store';
    function __construct() 
	{
        parent::__construct();
        $this->load->model('ashrams/ashrams_model');
		$this->load->model('ashrams/store_model');
		$this->load->model('ashrams/store_cover_photos_model');
		$this->load->model('ashrams/store_files_model');
		$this->load->model('ashrams/store_categories_model');
		$this->load->model('ashrams/store_types_model');
		$this->currentUser=$this->session->userdata("admin_data");
		if(is_single_ashram_site)
        { 
            $this->session->set_userdata("ashramId",default_ashram_id); 
		}
		if(!$this->session->userdata("ashramId"))
		{
			$this->session->set_userdata("ashramId",0);
		}
    }
	function index()
	{
		$views = array( 'ashrams/admin/list_store' );
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		if($this->session->userdata("ashramId")>0)
			$storeCategories=$this->store_categories_model->getCategoriesListByAshramId($this->session->userdata("ashramId"));
		else
			$storeCategories=$this->store_categories_model->getList();
		$data['categories']=$storeCategories;
		$data['types']=$this->store_types_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Store Listing");
	}

	public function listc($excel=0)
	{
		if($this->session->userdata("ashramId"))
		{
			$list=$this->store_model->listAdmin($this->session->userdata("ashramId"),$excel);
			echo json_encode($list);
			$this->logaction->log($this->service,"Admin - Viewed Store Listing ajax request");
		}
	}

	public function categories()
	{
		$views = array( 'ashrams/admin/list_store_categories');
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function listcats($excel=0)
	{
		if($this->session->userdata("ashramId"))
		{
			$list=$this->store_categories_model->listAdmin($this->session->userdata("ashramId"),$excel);
			echo json_encode($list);
			$this->logaction->log($this->service,"Admin - Viewed store categories listing ajax request");
		}
	}

	public function add_edit_category($id=0)
	{
		if($id)
		{
			$categoryData=$this->store_categories_model->categoryData($id);
			if(empty($categoryData))
			{
				$this->session->set_flashdata("cat_error",1);
				redirect("/storeadmin/categories");
			}
			if($this->currentUser->roles!=1 && ($categoryData->category_ashram_id!=$this->session->userdata("ashramId")))
        	{
        		$this->session->set_flashdata("cat_error",1);
				redirect("/storeadmin/categories");
        	}
		}
		else
			$categoryData=array();

		if(isset($_POST["add_category"]))
		{
			$this->form_validation->set_rules('name', 'Category name', 'trim|required|min_length[3]|max_length[200]|check_store_category['.$id.']');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("cat_error",1);
				echo validation_errors();
				exit;
				redirect('storeadmin/add_edit_category/'.$id);
				return;
			}
			
			$saved=$this->store_categories_model->save($id,$categoryData);
			if($saved)
			{
				if($id)
						$this->session->set_flashdata("cat_saved",1);
				else
				{
					$this->session->set_flashdata("cat_created",1);
				}
			}
			redirect('storeadmin/add_edit_category/'.$saved);
		}
		else
		{	
		 	$views = array( 'ashrams/admin/add_edit_store_category' );
		 	$data = array('views'=>$views,'id'=>$id);
		 	if($this->currentUser->roles==1)
        	{
        		$data['ashrams']=$this->ashrams_model->getList();
        	}
        	$data['ashramData']=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
			if($id)
			{
				$data['categoryData']=$categoryData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	function delete_category($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$categoryData=$this->store_categories_model->categoryData($id);
			if(empty($categoryData))
			{
				goto end;
			}
			if($categoryData->in_use>0)
			{
				$data['flag']=2;
				$data['name']=$categoryData->name;
				goto end;
			}
			
			$r=$this->store_categories_model->delete($id,$categoryData);
			if($r)
			{
				$data['flag']=1;
				$data['name']=$categoryData->name;
				$this->logaction->log($this->service,"Admin - Category '".$categoryData->name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}
	public function category_updateorder()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->store_categories_model->updateOrder($_POST['pk'],$_POST['value']);
		echo 1;
	}
	
	public function add_edit_item($id=0)
	{
		if(!$this->session->userdata("ashramId"))
		{
			$this->session->set_flashdata("item_error",1);
			redirect('storeadmin');
		}

		if(is_numeric($id) && $id)
		{
			$itemData=$this->store_model->itemData($id);
			if(empty($itemData['item']))
			{
				$this->session->set_flashdata("item_error",1);
				redirect('storeadmin');
			}
			if($itemData['item']->ashram_id!=$this->session->userdata("ashramId"))
        	{
        		$this->session->set_flashdata("item_error",1);
				redirect("storeadmin");
        	}
		}
		else
		{
			$itemData=array();
		}

		$this->load->model('currencies_model');
		$ashramCurrencies = $this->currencies_model->getByAshram($this->session->userdata("ashramId"));

		if(isset($_POST["item_name"]))
		{
			$this->form_validation->set_rules('item_name', 'Store Name', 'trim|required|min_length[3]|max_length[100]|checkItemName['.$id.']');
			$this->form_validation->set_rules('description', 'Description', 'trim|required|min_length[3]|max_length[2000]');
			$this->form_validation->set_rules('item_type', 'Type', 'trim|required|numeric|checkItemType');
			$this->form_validation->set_rules('category', 'Category', 'trim|required|numeric|checkStoreCategory');

			$this->form_validation->set_rules('shipping', 'Shipping', 'trim|required|numeric|checkItemShipping');
			$this->form_validation->set_rules('is_external_link', 'Is external link? ', 'trim|required|checkExternalLinkFlag');
			$this->form_validation->set_rules('is_public_display', 'Is Public Diaply? ', 'trim|required|numeric|checkPublicDisplay');
			$this->form_validation->set_rules('have_personal_note', 'Have Personal Note? ', 'trim|required|numeric|checkPersonalNote');
			foreach ($ashramCurrencies as $currencyData)
			{
				$currencyparameters = strtolower($currencyData['currency']).' || '.$this->session->userdata("ashramId");
				$this->form_validation->set_rules('price_'.strtolower($currencyData['currency']), 'Price ('.$currencyData['currency'].')', 'trim|required|checkCurrencyValuesByAshram['.$currencyparameters.']');
			}

			if($this->input->post("is_external_link")==1)
				$this->form_validation->set_rules('external_link', 'External link', 'trim|required|valid_url');
			if($this->input->post("shipping")==1)
			{
				foreach ($GLOBALS['currencies'] as $currencyData)
				{
					$this->form_validation->set_rules('shipping_domestic_'.strtolower($currencyData['currency']), 'Shipping domestic Price ('.$currencyData['currency'].')', 'trim|required|numeric|max_length[4]');
					$this->form_validation->set_rules('shipping_international_'.strtolower($currencyData['currency']), 'Shipping international Price ('.$currencyData['currency'].')', 'trim|required|numeric|max_length[4]');
				}
			}
			$this->form_validation->set_rules('partial_payments_allowed', 'Partial payments', 'trim|required|numeric|checkPartialPaymentOption');

			$this->form_validation->set_rules('only_for_admin', 'Only for Admin? ', 'trim|required|checkStoreIsOnlyForAdmin');
			$this->form_validation->set_rules('is_secret', 'Is Secret? ', 'trim|required|checkIsSecretStore');
			if($this->input->post("is_secret")==1)
			{
				$this->form_validation->set_rules('s_key', 'Secret Key', 'trim|min_length[2]|max_length[64]|checkAlphaNumericUnderscoreDashOnly|checkStoreSecretKeyExists['.$id.']');
			}
			$this->form_validation->set_rules('item_key', 'Item Key', 'trim|min_length[2]|max_length[64]|checkAlphaNumericUnderscoreDashOnly|checkStoreItemKeyExists['.$id.']');

			$this->form_validation->set_rules('display_only_popup', 'Display Only Popup? ', 'trim|required|checkStoreDisplayOnlyPopup');
			if($this->input->post("display_only_popup")==1)
			{
				$this->form_validation->set_rules('popup_content', 'Popup Content', 'trim|required|min_length[3]|max_length[1000]');
			}

			$this->form_validation->set_rules('having_custom_email', 'Custom Email? ', 'trim|required|checkStoreItemHavingCustomEmail');
			if($this->input->post("having_custom_email")==1)
			{
				$this->form_validation->set_rules('custom_email_text', 'Custom Email Text', 'trim|required|min_length[3]|max_length[10000]');
			}

			$this->form_validation->set_rules('having_custom_sms', 'Custom SMS? ', 'trim|required|checkStoreItemHavingCustomSms');
			if($this->input->post("having_custom_sms")==1)
			{
				$this->form_validation->set_rules('custom_sms_text', 'Custom SMS Text', 'trim|required|min_length[6]|max_length[320]');
			}

			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("item_error",1);
				redirect('storeadmin/add_edit_item/'.$id);
				return;
			}


			$saved=$this->store_model->save($id,$itemData);
			if($id==0)
			{
				$this->session->set_flashdata("item_created",1);
			}
			else
			{
				$this->session->set_flashdata("item_saved",1);
			}
			redirect('storeadmin/add_edit_item/'.$saved);
		}
		else
		{
			if($id>0 && (empty($itemData)) )
			{
				redirect('storeadmin');
			}
			$views = array('ashrams/admin/add_edit_item');
			$data = array('views'=>$views,'id'=>$id);
			if($this->currentUser->roles==1)
        	{
        		$data['ashrams']=$this->ashrams_model->getList();
        	}
			$data['ashramData']=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
			$data['itemData']=$itemData;
			$data['categories']=$this->store_categories_model->getCategoriesListByAshramId($this->session->userdata("ashramId"));
			// $data['categories']=$this->store_categories_model->getList();
			$data['types']=$this->store_types_model->getList();
			$data['ashramCurrencies'] = $ashramCurrencies;
			$this->load->view(ADMIN_TEMPLATE,$data); 
		}
	}

	function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id && $this->session->userdata("ashramId"))
		{
			$itemData=$this->store_model->itemData($id);
			if(empty($itemData['item']))
			{
				goto end;
			}
			$this->load->model("orders/orders_model");
			$hasUsedFiles=0;
			foreach ($itemData['files'] as $fileData)
			{
				$fileUsage=$this->orders_model->fileUsage($fileData->id);
				if($fileUsage>0)
				{
					$hasUsedFiles=1;
					break;
				}
			}
			if($hasUsedFiles==1)
			{
				$data['flag']=2;
				$data['item_name']=$itemData['item']->item_name;
				goto end;
			}
			$r=$this->store_model->delete($id,$itemData);
			if($r)
			{
				$data['flag']=1;
				$data['item_name']=$itemData['item']->item_name;
				$this->logaction->log($this->service,"Admin - Store '".$itemData['item']->item_name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}

	public function changestatus($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id && $this->session->userdata("ashramId") && isset($_POST['status']) && is_numeric($_POST['status']) && in_array($_POST['status'],array(0,1)))
		{
			$itemData=$this->store_model->itemData($id);
			if(empty($itemData['item']))
			{
				goto end;
			}
			$data['item_name']=$itemData['item']->item_name;
			if($itemData['item']->status==$_POST['status'])
			{
				$data['flag']=2;
				goto end;
			}

			if($this->input->post("status")==1)
			{
				if($itemData['item']->shipping==0)
				{
					if(empty($itemData['files']) || empty($itemData['photos']))
					{
						$data['flag']=3;
						$data['error']="Please add at least one cover photo and file to activate.";
						goto end;
					}
				}
				else
				{
					if(empty($itemData['photos']))
					{
						$data['flag']=3;
						$data['error']="Please add at least one cover photo to activate.";
						goto end;
					}
				}
			}

			$this->store_model->changeStatus($id,$_POST['status']);
			
			$data['flag']=1;
			
			if($_POST['status']==1)
				$this->logaction->log($this->service,"Admin - Store '".$itemData['item']->item_name."' activated - ".$id);
			else
				$this->logaction->log($this->service,"Admin - Store '".$itemData['item']->item_name."' deactivated - ".$id);
		}
		end:
		echo json_encode($data);
	}

	public function types()
	{
		$views = array( 'ashrams/admin/list_store_types');
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function listtypes($excel=0)
	{
		$list=$this->store_types_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed store types listing ajax request");
	}

	public function add_edit_type($id=0)
	{
		if($id)
		{
			$typeData=$this->store_types_model->typeData($id);
			if(empty($typeData))
			{
				$this->session->set_flashdata("type_error",1);
				redirect("/storeadmin/types");
			}
		}
		else
			$typeData=array();

		if(isset($_POST["add_type"]))
		{
			$this->form_validation->set_rules('name', 'Category name', 'trim|required|min_length[3]|max_length[200]|check_store_type['.$id.']');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("type_error",1);
				redirect('storeadmin/add_edit_type/'.$id);
				return;
			}
			
			$saved=$this->store_types_model->save($id,$typeData);
			if($saved)
			{
				if($id)
						$this->session->set_flashdata("type_saved",1);
				else
				{
					$this->session->set_flashdata("type_created",1);
				}
			}
			redirect('storeadmin/add_edit_type/'.$saved);
		}
		else
		{	
		 	$views = array( 'ashrams/admin/add_edit_store_type' );
		 	$data = array('views'=>$views,'id'=>$id);
			if($id)
			{
				$data['typeData']=$typeData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	function delete_type($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$typeData=$this->store_types_model->typeData($id);
			if(empty($typeData))
			{
				goto end;
			}
			if($typeData->in_use>0)
			{
				$data['flag']=2;
				$data['name']=$typeData->name;
				goto end;
			}
			
			$r=$this->store_types_model->delete($id,$typeData);
			if($r)
			{
				$data['flag']=1;
				$data['name']=$typeData->name;
				$this->logaction->log($this->service,"Admin - Type '".$typeData->name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}
	public function type_updateorder()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->store_types_model->updateOrder($_POST['pk'],$_POST['value']);
		echo 1;
	}

	public function namecheck($id=0)
	{
		if(!$this->session->userdata("ashramId"))
		{
			echo 'false';
			return;
		}
		if(isset($_POST['item_name']) && $_POST['item_name']!='')
		{
			if(is_numeric($id))
			{
				$flag=$this->store_model->checkItemName($this->general_model->filtertext(trim($_POST['item_name'])),$id);
				if($flag==1)
					echo 'false';
				else
					echo 'true';
			}
			else
				echo 'false';
		}
	}

	function uploadphotos($itemId=0)
	{
		$allowed_file_types =   array('image/jpeg','image/jpg','image/png');
		$json['files']=[];
		if(is_numeric($itemId) && $itemId)
		{
			$itemData=$this->store_model->itemData($itemId);
			if(!empty($itemData['item']) && isset($_FILES['files']))
			{
				foreach ($_FILES['files']['name'] as $key => $file)
				{
					$ext=pathinfo ($_FILES['files']['name'][$key],PATHINFO_EXTENSION);
					if($_FILES['files']['size'][$key]==0)
					{
						$json['files'][] = array(
			            'name' => $file,
			            'size' => $_FILES['files']['size'][$key],
			            'type' => $_FILES['files']['type'][$key],
			            'error' => "Invalid File Size",
			            'status'=>0
			        	);
					}
					else if($_FILES['files']['size'][$key]>(5*1024*1024))
					{
						$json['files'][] = array(
			            'name' => $file,
			            'size' => $_FILES['files']['size'][$key],
			            'type' => $_FILES['files']['type'][$key],
			            'error' => "File Size exceeded 5 MB",
			            'status'=>0
			        	);
					}
					else if($ext=='' || !in_array($_FILES['files']['type'][$key],$allowed_file_types))
					{
						$json['files'][] = array(
			            'name' => $file,
			            'size' => $_FILES['files']['size'][$key],
			            'type' => $_FILES['files']['type'][$key],
			            'error' => "Extension not allowed",
			            'status'=>0
			        	);
					}
					else
					{	
		        		$json['files'][0]=$this->store_cover_photos_model->uploadFile($itemData);
		        		if(empty($itemData['photos']))
		        		{
		        			$newStatus=$this->store_model->checkstatus($itemId);
		        			$json['files'][0]['reload']=1;
		        			if($itemData['item']->status!=$newStatus)
		        			{
		        				if($newStatus==1)
		        					$this->session->set_flashdata("item_activated",1);
		        				if($newStatus==0)
		        					$this->session->set_flashdata("item_deactivated",1);
		        			}
		        		}
		        		$json['files'][0]['name']=$file;
		        		$json['files'][0]['type']=$_FILES['files']['type'][$key];
		        		$json['files'][0]['size']=$_FILES['files']['size'][$key];
		        		$json['files'][0]['status']=1;
		        	}
				}
				echo json_encode($json);
			}
			else
			{
				foreach ($_FILES['files']['name'] as $key => $file) 
				{
					$json['files'][] = array(
		            'name' => $file,
		            'size' => $_FILES['files']['size'][$key],
		            'type' => $_FILES['files']['type'][$key],
		            'error' => "Invalid Event ID",
		            'status'=>0
		        	);
				}
				echo json_encode($json);
			}
		}
	}

	function uploadfiles($itemId=0)
	{
		$exts=$GLOBALS['site_settings']['blocked_file_types'];
		$excludedExtensions=explode("|",$exts);
		
		$json['files']=[];
		if(is_numeric($itemId) && $itemId)
		{
			$itemData=$this->store_model->itemData($itemId);
			if(!empty($itemData['item']) && isset($_FILES['files']))
			{
				foreach ($_FILES['files']['name'] as $key => $file) 
				{
					$ext=pathinfo ($_FILES['files']['name'][0],PATHINFO_EXTENSION);

					if($_FILES['files']['size'][$key]==0)
					{
						$json['files'][] = array(
			            'name' => $file,
			            'size' => $_FILES['files']['size'][$key],
			            'type' => $_FILES['files']['type'][$key],
			            'error' => "Invalid File Size",
			            'status'=>0
			        	);
					}
					else if($_FILES['files']['size'][$key]>(50*1024*1024))
					{
						$json['files'][] = array(
			            'name' => $file,
			            'size' => $_FILES['files']['size'][$key],
			            'type' => $_FILES['files']['type'][$key],
			            'error' => "File Size exceeded 50 MB",
			            'status'=>0
			        	);
					}
					else if($ext=='' || in_array($ext,$excludedExtensions))
					{
						$json['files'][] = array(
			            'name' => $file,
			            'size' => $_FILES['files']['size'][$key],
			            'type' => $_FILES['files']['type'][$key],
			            'error' => "Extension not allowed",
			            'status'=>0
			        	);
					}
					else
					{	
		        		$json['files'][0]=$this->store_files_model->uploadFile($itemData);
		        		if(empty($itemData['files']))
		        		{
		        			$newStatus=$this->store_model->checkstatus($itemId);
		        			$json['files'][0]['reload']=1;
		        			if($itemData['item']->status!=$newStatus)
		        			{
		        				if($newStatus==1)
		        					$this->session->set_flashdata("item_activated",1);
		        				if($newStatus==0)
		        					$this->session->set_flashdata("item_deactivated",1);
		        			}
		        		}
		        		$json['files'][0]['name']=$file;
		        		$json['files'][0]['type']=$_FILES['files']['type'][$key];
		        		$json['files'][0]['size']=$this->general_model->fileSizeConvert($_FILES['files']['size'][$key]);
		        		$json['files'][0]['status']=1;
		        	}
				}
				echo json_encode($json);
			}
			else
			{
				foreach ($_FILES['files']['name'] as $key => $file)
				{
					$json['files'][] = array(
		            'name' => $file,
		            'size' => $_FILES['files']['size'][$key],
		            'type' => $_FILES['files']['type'][$key],
		            'error' => "Invalid Event ID",
		            'status'=>0
		        	);
				}
				echo json_encode($json);
			}
		}
	}

	function deletephoto($itemId=0,$imageId=0)
	{
		$data['flag']=0;
		if(is_numeric($itemId) && $itemId && is_numeric($imageId) && $imageId)
		{
			$itemData=$this->store_model->itemData($itemId);
			if(!empty($itemData['item']))
			{
				$imageData=$this->store_cover_photos_model->imageData($imageId,$itemId);
				if(!empty($imageData))
				{
					$r=$this->store_cover_photos_model->delete($imageData);
					if($r)
					{
						if(count($itemData['photos'])==1)
		        		{
		        			$this->store_model->checkstatus($itemId);
		        			$data['reload']=1;
		        			$this->session->set_flashdata("item_deactivated",1);
		        		}
						$data['flag']=1;
						$data['filename']=$imageData->filename;
					}
				}
			}
		}
		echo json_encode($data);
	}

	function deletefile($itemId=0,$fileId=0)
	{
		$data['flag']=0;
		if(is_numeric($itemId) && $itemId && is_numeric($fileId) && $fileId)
		{
			$itemData=$this->store_model->itemData($itemId);
			if(!empty($itemData['item']))
			{
				$fileData=$this->store_files_model->fileData($fileId,$itemId);
				if(!empty($fileData))
				{
					$this->load->model("orders/orders_model");
					$fileUsage=$this->orders_model->fileUsage($fileId);
					$data['filename']=$fileData->filename;
					if($fileUsage>0)
					{
						$data['flag']=2;
						goto end;
					}
					$r=$this->store_files_model->delete($fileData);

					if(count($itemData['files'])==1)
	        		{
	        			$this->store_model->checkstatus($itemId);
	        			$data['reload']=1;
	        			$this->session->set_flashdata("item_deactivated",1);
	        		}

					$this->store_model->checkstatus($itemId);
					if($r)
					{
						$data['flag']=1;
					}
				}
			}
		}
		end:
		echo json_encode($data);
	}

	public function bulk_delete($itemId=0)
	{
		$data['flag']=0;
		$data['count']=0;
		$data['ids']=array();
		if(is_numeric($itemId) && $itemId && isset($_POST['ids']) && !empty($_POST['ids']))
		{
			$itemData=$this->store_model->itemData($itemId);
			if(!empty($itemData['item']))
			{
				foreach ($_POST['ids'] as $imageId)
				{
					$imageData=$this->store_cover_photos_model->imageData($imageId,$itemId);
					if(!empty($imageData))
					{
						$r=$this->store_cover_photos_model->delete($imageData);
						if($r)
						{
							$data['count']++;
							$data['ids'][]=$imageId;
						}
					}
					$data['flag']=1;
				}
			}
		}
		echo json_encode($data);
	}

	public function bulk_delete_files($itemId=0)
	{
		$data['flag']=0;
		$data['count']=0;
		$data['idsa']=array();
		if(is_numeric($itemId) && $itemId && isset($_POST['idsa']) && !empty($_POST['idsa']))
		{
			$itemData=$this->store_model->itemData($itemId);
			if(!empty($itemData['item']))
			{
				foreach ($_POST['idsa'] as $fileId)
				{
					$fileData=$this->store_files_model->fileData($fileId,$itemId);
					if(!empty($fileData))
					{
						$r=$this->store_files_model->delete($fileData);
						if($r)
						{
							$data['count']++;
							$data['idsa'][]=$fileId;
						}
					}
					$data['flag']=1;
				}
			}
		}
		echo json_encode($data);
	}

	public function updatefileinfophotos($itemId=0)
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->store_cover_photos_model->updateInfo($_POST['pk'],'description',$_POST['value']);

		/*if(is_numeric($itemId) && $itemId)
		{
			$itemData=$this->store_model->itemData($itemId);
			if(!empty($itemData['item']))
			{
				if(isset($_POST['name']) && isset($_POST['value']) && $_POST['value']!='' && $_POST['name']!='')
				{
					$this->store_cover_photos_model->updateInfo($_POST['pk'],$_POST['name'],$_POST['value']);
				}
			}
		}*/
	}
	public function updateorderphotos($itemId=0)
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
		if($this->form_validation->run() == FALSE)
		{
			goto end;
		}
		if(is_numeric($itemId) && $itemId)
		{
			$itemData=$this->store_model->itemData($itemId);
			if(!empty($itemData['item']))
			{
				$this->store_cover_photos_model->updateInfo($_POST['pk'],'order',$_POST['value']);
				echo 1;
				return;
			}
		}
		end:
		echo 0;
		
	}
	public function updateorderfiles($itemId=0)
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
		if($this->form_validation->run() == FALSE)
		{
			goto end;
		}
		if(is_numeric($itemId) && $itemId)
		{
			$itemData=$this->store_model->itemData($itemId);
			if(!empty($itemData['item']))
			{
				$this->store_files_model->updateInfo($_POST['pk'],'order',$_POST['value']);
				echo 1;
				return;
			}
		}
		end:
		echo 0;
	}
	public function updatefileinfofiles($itemId=0)
	{
		if(is_numeric($itemId) && $itemId)
		{
			$this->form_validation->set_rules('value', 'Value', 'trim|required|min_length[3]|max_length[200]');
	    	$this->form_validation->set_rules('pk', 'ID', 'trim|required');
	    	$this->form_validation->set_rules('name', 'Name', 'trim|required');
	    	if($this->form_validation->run() == FALSE)
			{
				echo 0;
				return;
			}

			$itemData=$this->store_model->itemData($itemId);
			if(!empty($itemData['item']))
			{
				if(in_array($_POST['name'],array("title","description")))
				{
					$this->store_files_model->updateInfo($_POST['pk'],$_POST['name'],$_POST['value']);
					echo 1;
					return;
				}
				else
				{
					echo 0;
					return;
				}
			}
			else
			{
				echo 0;
				return;
			}
		}
		else
		{
			echo 0;
				return;
		}
	}

	public function download($itemId=0,$fileId=0)
	{
		$flag=0;
		if(is_numeric($fileId) && $fileId && is_numeric($itemId) && $itemId)
		{
			$itemData=$this->store_model->itemData($itemId);
			if(empty($itemData['item']))
			{
				goto end;
			}

			$fileData=$this->store_files_model->fileData($fileId,$itemId);
			if(empty($fileData))
			{
				goto end;
			}

			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
			
			$amazonUri="private_files/store/".$itemId."/".$fileData->filename;
			header("Cache-Control: public");
	        header("Content-Disposition: attachment; filename=".$fileData->filename);
			$obj=$this->s3->getObject(aws_s3_bucket_name,$amazonUri);
			echo $obj->body;
			return;
		}
		end:
		if($flag==0)
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	public function categorycheckname($id=0)
	{
		if($this->input->post('name')!='')
		{
			if(is_numeric($id))
			{
				$flag=$this->store_categories_model->checkName($this->general_model->filtertext(trim($this->input->post('name'))),$id);
				if($flag==1)
					echo 2;
				else
					echo 1;
			}
			else
				echo 0;
		}
	}
	public function typecheckname($id=0)
	{
		if($this->input->post('name')!='')
		{	
			if(is_numeric($id))
			{
				$flag=$this->store_types_model->checkName($this->general_model->filtertext(trim($this->input->post('name'))),$id);
				if($flag==1)
					echo 2;
				else
					echo 1;
			}
			else
				echo 0;
		}
	}
}
?>