<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Store extends CI_Controller 
{
	var $service="cart";
	var $currentUser='';
	var $pageName="Store";
	var $currencies;
    function __construct()
	{
        parent::__construct();
		$this->load->model('ashrams/store_model');
		$this->load->model('ashrams/store_cover_photos_model');
		$this->load->model('ashrams/store_files_model');
		$this->load->model('ashrams/store_types_model');
		$this->load->model('ashrams/ashrams_trust_accounts_model');
		$this->load->model('currencies_model');
		$this->load->model('orders/order_log_model');
		$this->load->model('orders/transaction_model');
		$this->load->model('orders/payflow_logs_model');
		$this->load->model("offline_model");
        $this->load->model("subscriptions/donors_model");
        $this->load->model("credit_cards_model");
        
        if($this->session->userdata('id'))
        	$this->currentUser=$this->session->userdata("admin_data");
       	else
       	{
       		if($this->session->userdata("force_change_password")==1)
			{
				$this->session->set_flashdata("reset_password_force",1);
				redirect("myaccount/change_password");
			}
       		$this->currentUser=$this->session->userdata("user_data");
       	}
       	if(empty($this->session->userdata("storeCartAshramIdSelection")))
       	{
       		$this->session->unset_userdata("defaultCurrency");
       	}
        if(in_array(global_site_flag, [2]) && ($this->uri->segment(2)=='') && ($this->input->get("ashram_id")=='' || $this->input->get("currency")==''))
        {
            redirect("store?ashram_id=1&currency=inr");
        }
        if(in_array(global_site_flag, [4,7]) && ($this->uri->segment(2)=='') && ($this->input->get("ashram_id")=='' || $this->input->get("currency")==''))
        {
            redirect("store?ashram_id=1&currency=usd");
        }
        if(is_single_currency_site==1 && $this->input->get("currency")!='' && default_currency!=strtolower($this->input->get("currency")))
        {
            if(in_array(global_site_flag, [2,4]))
            {
                redirect("store?ashram_id=".default_ashram_id."&currency=".default_currency);
            }
            else
            {
                $this->session->unset_userdata("storeCartAshramIdSelection");
                $this->session->unset_userdata("defaultCurrency");
                redirect("store");
            }
        }
       	if($this->input->get("ashram_id")!='')
       	{
       		$ashramData = $this->ashrams_model->ashramData($this->input->get("ashram_id"));
       		if(empty($ashramData))
       		{
       			redirect("store");
       			exit;
       		}
       		$this->session->set_userdata("storeCartAshramIdSelection",$this->input->get("ashram_id"));
            $this->session->set_userdata("storeCartAshramId",$this->input->get("ashram_id"));
       	}
       	if($this->session->userdata("storeCartAshramIdSelection"))
       	{
	       	$this->currencies=$this->currencies_model->getByAshram($this->session->userdata("storeCartAshramIdSelection"));
	    }
	    if($this->input->get("currency")!='')
       	{
       		if(isset($this->currencies[$this->input->get("currency")]))
       			$this->session->set_userdata("defaultCurrency",$this->input->get("currency"));
       	}
       	if($this->input->get("type")!='')
       	{
       		$this->session->set_userdata('store_item_type', $this->input->get("type"));
       	}
        if(empty($_GET['type']))
            $this->session->unset_userdata("store_item_type");
        
	    if($this->input->get("view")!='')
       	{
       		if(in_array($this->input->get("view"),array("itemView","listView")))
       			$this->session->set_userdata('storeviewType', $this->input->get("view"));
       	}
	    $this->load->library('storecart');
	    $this->load->model('cart_model');
	    if(!empty($this->session->userdata("storeCartAshramIdSelection")) && !empty($this->session->userdata("defaultCurrency")))
	    {
	       	$this->cart_model->validateCart($this->storecart);
	    }
       	
    }
    public function index()
    {
        if(empty($this->input->get("ashram_id")) && !empty($this->session->userdata("storeCartAshramIdSelection")) && !empty($this->session->userdata("defaultCurrency")))
        {
            $this->session->unset_userdata("storeCartAshramIdSelection");
            $this->session->unset_userdata("defaultCurrency");
            redirect("store");
        }
    	if(!empty($this->session->userdata("storeCartAshramIdSelection")) && empty($this->input->get("ashram_id")))
    	{
    		redirect("store?ashram_id=".$this->session->userdata("storeCartAshramIdSelection"));
    	}
    	if(!empty($this->session->userdata("defaultCurrency")) && empty($this->input->get("currency")))
    	{
    		redirect("store?ashram_id=".$this->session->userdata("storeCartAshramIdSelection")."&currency=".$this->session->userdata("defaultCurrency"));
    	}
    	if(!empty($this->session->userdata("store_item_type")) && empty($this->input->get("type")))
    	{
    		redirect("store?ashram_id=".$this->session->userdata("storeCartAshramIdSelection")."&currency=".$this->session->userdata("defaultCurrency")."&type=".$this->session->userdata("store_item_type"));
    	}
    	if(!empty($this->session->userdata("defaultCurrency")) && !empty($this->session->userdata("storeCartAshramIdSelection")) && !empty($this->session->userdata("storeviewType")) && empty($this->input->get("view")))
    	{
    		redirect("store?ashram_id=".$this->session->userdata("storeCartAshramIdSelection")."&currency=".$this->session->userdata("defaultCurrency")."&view=".$this->session->userdata('storeviewType')."&type=".$this->session->userdata("store_item_type"));
    	}
    	if($GLOBALS['site_settings']['store']==0 && (!$this->session->userdata("id") || $this->session->userdata("admin_data")->roles!=1))
    	{
    		$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
    	}
    	if(!empty($this->session->userdata("storeCartAshramIdSelection")))
    	{
    		if($this->checkpublicdisplay()=="0")
	    	{
	    		$data['views'] = array('common/public/error');
				$this->load->view(FRONTEND_TEMPLATE,$data);
				return;
	    	}
    	}
    	$this->load->model('ashrams/ashrams_model');
    	$this->load->model('ashrams/store_types_model');
    	if(empty($this->session->userdata("storeCartAshramIdSelection")) || empty($this->session->userdata("defaultCurrency")))
		{
			$data['views'] = array('ashrams/public/cart_ashram_selection');
    		$data['ashramData']=$this->ashrams_model->ashramData($this->session->userdata("storeCartAshramIdSelection"));
		}
		else
		{
			$data['cartObject']=$this->storecart;
	    	$data['views'] = array('ashrams/public/list_store');
	    	$data['types']=$this->store_types_model->getList();
		}
	    // $data['ashrams']=$this->ashrams_model->getList();
	    $data['ashrams']=$this->ashrams_model->getOnlyActiveStoreItemsAshramList();
	    $ashramids = array_column($data['ashrams'], 'id');
	    if($this->session->userdata("storeCartAshramIdSelection")>0 && !in_array($this->session->userdata("storeCartAshramIdSelection"),$ashramids))
	    {
	    	redirect("store");
	    }
		$data['slug']="store";

        $cart=$this->storecart->contents();
        $cartCount = count($cart);
        if($cartCount>0)
        {
            foreach($cart as $thiscartitem)
            {
                if($this->session->userdata('storeCartAshramId')!=$thiscartitem['options']['ashram_id'] && ($this->input->get("ashram_id")!=''))
                {
                    $ashramData=$this->ashrams_model->ashramData($thiscartitem['options']['ashram_id']);
                    $data['alertMessage'] = '<div class="alert alert-danger">
                                                <button class="close" data-dismiss="alert"></button>
                                                <strong>JGD. You cart has items from "'.$ashramData->name.'" ashram / event. If you wish to add items from another ashram / event, empty the cart and try again.</strong>
                                                <a href="#clearCartModal" class="btn btn-danger btn-xs" data-toggle="modal" style="margin-left: 10px;"><i class="fa fa-times"></i> Clear Cart</a>
                                            </div>';
                }
            }
        }
    	
		$this->load->view(FRONTEND_TEMPLATE,$data);
		if($this->session->userdata("storeCartAshramIdSelection"))
			$this->cart_log_model->log("Navigated to store page :".current_url(),$this->session->userdata("storeCartAshramIdSelection"),3);
    }
    public function changecurrency()
    {
    	if(isset($_POST['currency']) && $_POST['currency']!='')
    	{
            if(empty($GLOBALS['currencies']))
            {
                echo 0;
                return;
            }
    		foreach ($GLOBALS['currencies'] as $currencyData)
    		{
    			if(strtolower($currencyData['currency'])==strtolower($_POST['currency']))
    			{
    				$this->session->set_userdata("defaultCurrency",strtolower($currencyData['currency']));
    				$this->cart_log_model->log("Changed currency to :".strtoupper($currencyData['currency']),$this->session->userdata("storeCartAshramIdSelection"),3);
    				if(!empty($this->session->userdata("storeCartAshramIdSelection")) && !empty($this->session->userdata("defaultCurrency")))
    					$this->cart_model->validateCart($this->storecart);
    				echo 1;
    				return;
    			}
    		}
    	}
    	echo 0;
    }
    public function changeashram()
    {
    	if(!empty($this->storecart->contents()))
    	foreach($this->storecart->contents() as $key=>$val)
    	{
    		$storeData=$this->store_model->itemData($val['id']);
    		break;
    	}
    	if(isset($_POST['ashram_id']) && $_POST['ashram_id']!='' && (empty($this->storecart->contents()) || isset($storeData) && $storeData['item']->ashram_id == $_POST['ashram_id']))
    	{
    		$this->load->model('ashrams/ashrams_model');
    		$ashramData=$this->ashrams_model->ashramData($_POST['ashram_id']);
    		if(!empty($ashramData))
    		{
    			$this->session->set_userdata("storeCartAshramIdSelection",$_POST['ashram_id']);
                $this->session->set_userdata("storeCartAshramId",$_POST['ashram_id']);
    			$this->cart_log_model->log("Changed ashram to :".$ashramData->name,$this->session->userdata("storeCartAshramIdSelection"),3);
    			$data['flag']=1;
    			echo json_encode($data);
    			return;
    		}
    	}else
    	{
    		$data['flag']=2;
    		if($storeData['item']->ashram_id)
    		{	
    			$ashramData=$this->ashrams_model->ashramData($storeData['item']->ashram_id);
    			$data['ashram_name']=$ashramData->name;
    		}
    		echo json_encode($data);
    		return;
    	}
    	$data['flag']=0;
    	echo json_encode($data);
    }

    public function removeAshramSession()
    {
    	$this->session->unset_userdata("storeCartAshramIdSelection");
    	echo 1;
    }

    public function view($id=0)
    {
        if(!empty($this->session->userdata("defaultCurrency")) && empty($this->input->get("currency")))
        {
            redirect("store/view/".$id."?ashram_id=".$this->session->userdata("storeCartAshramIdSelection")."&currency=".$this->session->userdata("defaultCurrency"));
        }
    	if(empty($this->input->get("ashram_id")) || empty($this->input->get("currency")))
    	{
    		$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
    	}
    	if(is_numeric($id) && $id)
    	{
    		$itemData=$this->store_model->itemData($id);
    		if(!empty($itemData['item']) && $this->session->userdata("storeCartAshramIdSelection")==$itemData['item']->ashram_id)
    		{
    			$data['cartObject']=$this->storecart;
				$data['slug']="store";
    			$data['itemData']=$itemData;
    			$data['views'] = array('ashrams/public/view_item');
    			$data['suggested']=$this->store_model->getRandomItems($itemData['item']->category);
				$this->load->view(FRONTEND_TEMPLATE,$data);
    		}
    	}
    	else
    	{
    		$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
    	}
    }
    public function checkout()
    {
        if(empty($this->input->get("ashram_id")) || empty($this->input->get("currency")))
        {
            redirect("store");
        }
    	$cart=$this->storecart->contents();
    	if(empty($cart))
    	{
    		redirect("store");
    	}

        $cartCount = count($cart);
        if($cartCount>0)
        {
            foreach($cart as $thiscartitem)
            {
                if($this->session->userdata('storeCartAshramId')!=$thiscartitem['options']['ashram_id'] && ($this->input->get("ashram_id")!=''))
                {
                    $ashramData=$this->ashrams_model->ashramData($thiscartitem['options']['ashram_id']);
                    $data['alertMessage'] = '<div class="alert alert-danger">
                                                <button class="close" data-dismiss="alert"></button>
                                                <strong>JGD. You cart has items from "'.$ashramData->name.'" ashram / event. If you wish to add items from another ashram / event, empty the cart and try again.</strong>
                                                <a href="#clearCartModal" class="btn btn-danger btn-xs" data-toggle="modal" style="margin-left: 10px;"><i class="fa fa-times"></i> Clear Cart</a>
                                            </div>';
                }
            }
        }

    	$this->load->model("credit_cards_model");
    	$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($this->session->userdata("storeCartAshramId"),3);
        $data['ashramData'] = $this->ashrams_model->ashramData($this->session->userdata("storeCartAshramId"));
    	$trustsArray=array();
    	foreach ($trusts as $trustData)
    	{
    		$trustsArray[$trustData->currency]=$trustData;
    	}
    	if($this->session->userdata("defaultCurrency")=='inr')
    	{
    		$data['trustData'] = isset($trustsArray['inr']) ? $trustsArray['inr'] : "";
    	}
    	if($this->session->userdata("defaultCurrency")=='usd')
    	{
    		$data['trustData'] = isset($trustsArray['usd']) ? $trustsArray['usd'] : "";
    	}

        // If trust data is not available then redirect to back
        if(empty($data['trustData']))
        {
            if(!empty($this->session->userdata("storeCartAshramId")) && !empty($this->session->userdata("defaultCurrency")))
            {
                redirect("store?ashram_id=".$this->session->userdata("storeCartAshramId")."&currency=".$this->session->userdata("defaultCurrency"));
            }
            else
            {
                redirect("store");
            }
        }

        $temp_reference = substr(hash('sha256', mt_rand() . microtime()), 0, 25);
        $this->session->set_userdata("store_items_temp_reference",$temp_reference);

    	$total=$this->cart_model->getTotalPrice($this->storecart);
    	$data['total_price']=strtoupper($this->session->userdata("defaultCurrency"))." ".$total;
    	$data['amount_in_words']=$this->general_model->amountToWords($total);
    	if($this->session->userdata("loggedIn"))
    	{
    		if($this->currentUser->admin==1)
			{
				if($this->session->userdata('temp_checkout_user'))
				{
					$cUserId=$this->session->userdata('temp_checkout_user')->id;
					$data['credit_cards']=$this->credit_cards_model->getCards($cUserId);
				}
			}
			else
			{
				$data['credit_cards']=$this->credit_cards_model->getCards($this->currentUser->id);
			}
    	}
    	$data['countries']=$this->locations_model->getCountries();
    	$data['views'] = array('ashrams/public/checkout_store');
		$this->load->view(FRONTEND_TEMPLATE,$data);
		$this->cart_log_model->log("Navigated to store checkout page :".current_url(),$this->session->userdata("storeCartAshramIdSelection"),3);
    }
    public function getcart()
    {
    	ob_start();
    	$this->load->view("ashrams/public/_cart_template_store");
    	$data['cart_template']=ob_get_clean();
    	$total=$this->cart_model->getTotalPrice($this->storecart);
    	$data['total_price']=strtoupper($this->session->userdata("defaultCurrency"))." ".$total;
    	$data['amount_in_words']=$this->general_model->amountToWords($total);
    	echo json_encode($data);
    }

    public function getcartfinal()
    {
    	ob_start();
    	$this->load->view("ashrams/public/_cart_template_store_final");
    	$data['cart_template']=ob_get_clean();
    	$total=$this->cart_model->getTotalPrice($this->storecart);
    	$data['total_price']=strtoupper($this->session->userdata("defaultCurrency"))." ".$total;
    	$data['amount_in_words']=$this->general_model->amountToWords($total);
    	echo json_encode($data);
    }

    public function checkpublicdisplay()
    {
    	$ashramData=$this->ashrams_model->ashramData($this->session->userdata('storeCartAshramIdSelection'));
        if($ashramData->is_public_display==0)
        {
            if(empty($this->currentUser))
                return "0";
            if(!empty($this->currentUser) && $this->currentUser->roles !=1 && $this->currentUser->roles !=3 && $this->currentUser->roles !=4)
				return "0";
        }
        else
        {
            return $this->session->userdata('storeCartAshramIdSelection');
        }
    }

    public function listitems()
	{
		$list=$this->store_model->listPublic($this->session->userdata("storeCartAshramIdSelection"),$this->session->userdata("admin_data"),$this->session->userdata("user_data"));
		echo json_encode($list);
	}
	public function carttoptemplate()
	{
		$data['cartObject']=$this->storecart;
		$data['slug']="store";
		$response_data['cart_template']=$this->load->view("ashrams/public/_cart_top_template",$data,true);
		$response_data['count']=count($this->storecart->contents());
		echo json_encode($response_data);
	}

	public function additem($id=0, $row_key='')
	{
		$data['flag']=0;
		if($GLOBALS['site_settings']['enable_orders']==0)
		{
			$data['flag']=55;
			goto end;
		}
		if($GLOBALS['site_settings']['store']==0 && (!$this->session->userdata("id") || $this->session->userdata("admin_data")->roles!=1))
    	{
    		$data['flag']=12;
    		$data['error_msg']="Store items are disabled";
			goto end;
    	}
		if($this->session->userdata("loggedIn") && $this->currentUser->admin==0)
		{
			if($this->currentUser->email_verified==0)
			{
				$data['flag']=51;
				goto end;
			}
		}
		if($this->session->userdata("loggedIn") && $this->currentUser->admin==1)
		{
			if(!$this->session->userdata('temp_checkout_user'))
			{
				$data['flag']=12;
				$data['error_msg']='Please select user before adding item to cart.';
				goto end;
			}
		}
		if($GLOBALS['storeCartLocked']==1)
		{
			$data['flag']=11;
			goto end;
		}
		if(is_numeric($id) && $id)
		{
			$cart=$this->storecart->contents();
            $cartCount = count($cart);
            if($cartCount>0)
            {
                foreach($cart as $thiscartitem)
                {
                    if($this->session->userdata('storeCartAshramId')!=$thiscartitem['options']['ashram_id'])
                    {
                        $this->load->model('ashrams/ashrams_model');
                        $ashramData=$this->ashrams_model->ashramData($thiscartitem['options']['ashram_id']);
                        $data['ashram_name']=$ashramData->name;
                        $data['flag']=2;
                        goto end;
                    }
                }
            }
            if($cartCount >= 50)
            {
                $data['flag']=111;
                $data['error_msg']='MAX 50 items are allowed to cart.';
                goto end;
            }
			$itemData=$this->store_model->itemData($id);
			$amount=$this->cart_model->getTotalPrice($this->storecart);
			$col="price_".strtolower($this->session->userdata("defaultCurrency"));
			if(empty($itemData['item']))
			{
				$data['flag']=10;
				goto end;
			}

            if($itemData['item']->display_only_popup==1)
            {
                $data['flag']=112;
                goto end;
            }

			$displayCol=strtolower($this->session->userdata("defaultCurrency"))."_display";
			if($itemData['item']->$displayCol==0)
			{
				$data['flag']=10;
				goto end;
			}

			$data['item']=$itemData;
			$data['type']='store';
			$data['personal_note']='';
			if(!$this->session->userdata('storeCartAshramId') || $itemData['item']->ashram_id==$this->session->userdata('storeCartAshramId') || count($cart) == 0)
			{
				$qty=1;
				$response=$this->cart_model->addItem($data,$qty,$this->storecart,$row_key);
				$flag=$response['flag'];
				if($flag==-2)
				{
					$this->logaction->log($this->service,"Store Item added to cart _ Item ID:".$id." _ ".$itemData['item']->item_name." _ Row ID: ".$response['rowid']);
					$data['flag']=1;
					$this->session->set_userdata('storeCartAshramId',$itemData['item']->ashram_id);
					$this->cart_log_model->log("Item added - Name:".$itemData['item']->item_name,$this->session->userdata("storeCartAshramId"),3);
				}
				else
				{
					$data['flag']=$flag;
				}
			}
			else
			{
				$this->load->model('ashrams/ashrams_model');
				$ashramData=$this->ashrams_model->ashramData($this->session->userdata('storeCartAshramId'));
				$data['ashram_name']=$ashramData->name;
				$data['flag']=2;
			}
		}
		end:
		ob_start();
		$cdata['cartObject']=$this->storecart;
		$cdata['slug']="store";
		$this->load->view("ashrams/public/_cart_top_template",$cdata);
		$data['cart_template']=ob_get_clean();
		echo json_encode($data);
	}

	public function changeqty()
	{
		$result['flag']=0;
		if($GLOBALS['storeCartLocked']==1)
		{
			$result['flag']=11;
			goto end;
		}
		if(isset($_POST['key']) && $_POST['key']!='')
		{
			$item=$this->storecart->get_item($_POST['key']);
			if(!empty($item) && $item['options']['shipping']==1)
			{
				$qty=1;
				if(isset($_POST['qty']) && in_array($_POST['qty'],array(1,-1)))
				{
					$qty=$_POST['qty'];
				}

				$upd= array(
			               'rowid' => $_POST['key'],
               				'qty'   => $item['qty']+$qty
				            );
				$this->storecart->update($upd);
				$this->logaction->log($this->service,"Qty changed for item _ Item ID:".$item['id']." _ ".$item['name']." _ Row ID: ".$_POST['key']);
				$cc=$this->storecart->contents();
				
				$this->cart_log_model->log("Qty changed to ".($item['qty']+$qty).", Item name:".$item['name'],$this->session->userdata("storeCartAshramId"),3);

				if(count($cc)==0)
				{
					$this->session->unset_userdata('storeCartAshramId');
				}

				$result['flag']=1;
				$result['cart_count']=count($cc);
			}
			else
			{
				$result['flag']=2;
			}
		}
		end:
		echo json_encode($result);
	}

	public function removeitem()
	{
		$result['flag']=0;
		if($GLOBALS['storeCartLocked']==1)
		{
			$result['flag']=11;
			goto end;
		}
		$cart=$this->storecart->contents();
        if(empty($cart))
        {
            $result['flag']=3;
            goto end;
        }
		if(isset($_POST['key']) && $_POST['key']!='')
		{
			$item=$this->storecart->get_item($_POST['key']);
			if(!empty($item))
			{
				$upd= array(
			               'rowid' => $_POST['key'],
               				'qty'   => 0
				            );
				$this->storecart->update($upd);
				$this->logaction->log($this->service,"Item removed from cart _ Item ID:".$item['id']." _ ".$item['name']." _ Row ID: ".$_POST['key']);
				$this->cart_log_model->log("Item removed - Name:".$item['name'],$this->session->userdata("storeCartAshramId"),3);
				$cc=$this->storecart->contents();
				if(count($cc)==0)
				{
					$this->session->unset_userdata('storeCartAshramId');
				}
				$result['flag']=1;
				$result['cart_count']=count($cc);
                $result['currency'] = '';
                $result['ashram_id'] = '';
                if($this->session->userdata('storeCartAshramIdSelection')>0)
                {
                    $result['ashram_id'] = $this->session->userdata('storeCartAshramIdSelection');
                }
                if($this->session->userdata("defaultCurrency"))
                {
                    $result['currency'] = $this->session->userdata("defaultCurrency");
                }
			}
			else
			{
				$result['flag']=2;
			}
		}
		end:
		echo json_encode($result);
	}

    public function cancelprevious()
    {
    	$result['flag']=0;
    	if($GLOBALS['storeCartLocked']==1)
		{
            $startedOn=strtotime($GLOBALS['storeCartStartedOn']);
			if(time()>=$startedOn)
			{
				$this->cart_model->regenerateSession(1);
				$result['flag']=1;
				goto end;
			}
		}
		end:
		echo json_encode($result);
    }
    public function checkout_notify($tab_index=null)
    {
    	if($tab_index!=null && in_array($tab_index,array(0,1,2)))
    	{
    		$data='';
    		if($tab_index==2)
    		{
    			$countryData=$this->locations_model->getCountryByCode($this->input->post("country"));
    			$data="<br>Data:<br>".$this->input->post("firstname")." ".$this->input->post("lastname")."<br>".
    				$this->input->post("city").", ".$this->input->post("state").", ".$this->input->post("country")."<br>".
    				"+".$countryData->isd_code." ".$this->input->post("phone")."<br>".
    				$this->input->post("email");
    		}
    		$this->cart_log_model->log("Checkout - navigated to tab ".($tab_index+1).$data,$this->session->userdata("storeCartAshramId"),3);
    	}
    }

    public function check_item_modifications()
    {
        $result['flag']=1;
        //Validate Cart items
        $this->cart_model->validateCart($this->storecart);

        //Check cart items count
        $cartContents=$this->storecart->contents();
        if(empty($cartContents)) //If cart is empty
        {
            $result['flag']=0;
            goto end;
        }
        if(is_single_currency_site==1 && default_currency!=strtolower($this->session->userdata("defaultCurrency")))
        {
            $result['flag']=5;
            $result['alertMessage'] = '<strong>JGD. You cart not supporting the currency.</strong>';
            goto end;
        }

        $totalItems=count($cartContents);
        $validItems=0;
        foreach ($cartContents as $cartItem)
        {
            if($cartItem['options']['status']==1)
            {
                $validItems++;
            }

            if($this->session->userdata('storeCartAshramId')!=$cartItem['options']['ashram_id'])
            {
                $ashramData=$this->ashrams_model->ashramData($cartItem['options']['ashram_id']);
                $result['flag']=5;
                $result['alertMessage'] = '<strong>JGD. You cart has items from "'.$ashramData->name.'" ashram / event. If you wish to add items from another ashram / event, empty the cart and try again.</strong><a href="#clearCartModal" class="btn btn-danger btn-xs" data-toggle="modal" style="margin-left: 10px;"><i class="fa fa-times"></i> Clear Cart</a>';
                goto end;
            }
        }

        //Check all items in cart are valid
        if($validItems!=$totalItems)
        {
            $result['flag']=4;
            goto end;
        }

        end:
        echo json_encode($result);

    }

    public function pay()
    {
    	//Check site settings
    	$result['flag']=0;
    	if($GLOBALS['site_settings']['enable_orders']==0)
		{
			$data['flag']=3;
			goto end;
		}
    	if($this->session->userdata("loggedIn") && $this->currentUser->admin==0)
		{
			if($this->currentUser->email_verified==0)
			{
				$data['flag']=51;
				goto end;
			}
		}

		//Get cart DB record
		if($GLOBALS['storeCartLocked']==1)
		{
            $startedOn=strtotime($GLOBALS['storeCartStartedOn']);
			if(time()>=$startedOn)
			{
				$result['time_exceed']=1;
			}
			$result['flag']=5;
			goto end;
		}

	 	//Validate form data
	 	if(!isset($_POST["firstname"]) || !isset($_POST["lastname"]) ||
	 			!isset($_POST["preferred_name"]) ||
				!isset($_POST["email"]) || !isset($_POST["phone"]) ||
				!isset($_POST["address1"]) || !isset($_POST["address2"]) || !isset($_POST["address3"]) ||
				!isset($_POST["city"]) || !isset($_POST["state"]) || !isset($_POST["country"]) ||
				!isset($_POST["donation_initials"]))
		{
	 		goto end;
		}
		//Get trust accounts for Ashram and Currency defined
		$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($this->session->userdata("storeCartAshramId"),3);
    	$trustsArray=array();
    	foreach ($trusts as $trustData)
    	{
    		$trustsArray[$trustData->currency]=$trustData;
    	}
    	$customData['trustData']=$trustsArray[strtolower($this->session->userdata("defaultCurrency"))];

		$this->form_validation->set_rules('firstname', 'First Name','trim|required|min_length[2]|max_length[50]|lettersonly');
		$this->form_validation->set_rules('lastname', 'Last Name','trim|required|min_length[2]|max_length[50]|lettersonly');
		$this->form_validation->set_rules('preferred_name', 'Preferred Name','trim|required|min_length[2]|max_length[50]');
		$this->form_validation->set_rules('email', 'Email ID','trim|required|no_uppercase|valid_email_custom|min_length[6]|max_length[100]');
		$this->form_validation->set_rules('phone', 'Phone Number','trim|required|numeric|min_length[8]|max_length[15]');
		$this->form_validation->set_rules('address1', 'Address Line 1','trim|required|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('address2', 'Address Line 2','trim|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('address3', 'Address Line 3','trim|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('city', 'City','trim|required|min_length[2]|max_length[100]|name_validate13');
		$this->form_validation->set_rules('state', 'State','trim|required|min_length[2]|max_length[100]|name_validate13');
		$this->form_validation->set_rules('country', 'Country','trim|required|checkCountry');
		$this->form_validation->set_rules('zipcode', 'ZIP Code','trim|required|alphabetsnumbers|min_length[3]|max_length[15]');
		$this->form_validation->set_rules('donation_initials', 'Initials','trim|required|min_length[3]|max_length[25]');
		if($this->currentUser->admin==1)
		{
			$this->form_validation->set_rules('payment_mode', 'Payment Mode','trim|required|checkAdminPaymentMode');
			$paymentMode=$this->input->post("payment_mode");
		}
		else
		{
			$paymentMode=$customData['trustData']->payment_mode;
		}

        if($this->session->userdata("defaultCurrency")=='usd' && $customData['trustData']->payment_mode=='paypal')
        {
            if(isset($_POST["credit_card_id"]) && $_POST["credit_card_id"] !='')
            {
                $creditCardData=$this->credit_cards_model->getCard($_POST["credit_card_id"]);
                if(empty($creditCardData))
                {
                    goto end;
                }
            }
            else
            {
                if($this->session->userdata("defaultCurrency")=='usd' && $customData['trustData']->payment_mode!='stripe' && $paymentMode!='cash')
                {
                    $this->form_validation->set_rules('card_number', 'Card Number','trim|required|min_length[15]|max_length[19]');
                    $this->form_validation->set_rules('card_name', 'Card Name','trim|required|min_length[2]|max_length[100]');
                    $this->form_validation->set_rules('card_expiry', 'Expiry Date','trim|required|cardExpiry');
                    $this->form_validation->set_rules('card_cvv', 'CVV Number','trim|required|numeric|min_length[3]|max_length[4]');
                }
            }
        }

		if($this->form_validation->run() == FALSE)
		{
			$result['error']=validation_errors();
	 		goto end;
		}

		//Validate Cart items
		$this->cart_model->validateCart($this->storecart);

		//Check cart items count
		$cartContents=$this->storecart->contents();
		if(empty($cartContents)) //If cart is empty
		{
			$result['flag']=2;
	 		goto end;
		}

		$totalItems=count($cartContents);
		$validItems=0;
		foreach ($cartContents as $cartItem)
		{
			if($cartItem['options']['status']==1)
			{
				$validItems++;
			}
		}

		//Check all items in cart are valid
		if($validItems!=$totalItems)
		{
			$result['flag']=4;
	 		goto end;
		}

		//Capture User ID
		$userId=0;
		if($this->session->userdata("loggedIn"))
		{
			if($this->currentUser->admin==1)
			{
				if($this->session->userdata('temp_checkout_user'))
				{
					$tData=$this->session->userdata('temp_checkout_user');
					$userId=$tData->id;
				}
			}
			else
			{
				$userId=$this->currentUser->id;
			}
		}

    	$amount=$this->cart_model->getTotalPrice($this->storecart);

    	//Decide trust based on Currency
    	if($this->session->userdata("defaultCurrency")=='inr')
    	{
    		if($amount>$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
    		{
    			$result['flag']=10;
    			$result['error_msg']='Sorry! Maximum allowed amount for checkout is INR '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
    			goto end;
    		}
    	}
    	if($this->session->userdata("defaultCurrency")=='usd')
    	{
    		if($amount>$this->currencies[$this->session->userdata("defaultCurrency")]['max'])
    		{
    			$result['flag']=10;
    			$result['error_msg']='Sorry! Maximum allowed amount for checkout is USD '.$this->currencies[$this->session->userdata("defaultCurrency")]['max'];
    			goto end;
    		}
    	}

    	$this->load->model('ashrams/ashrams_model');

    	//Define custom data before initializing transaction
    	$created_by_user_id=0;
    	$created_by=0;
		$userData=array();
		if($this->session->userdata('id'))
		{
			if($this->session->userdata('temp_checkout_user'))
			{
				$userData=$this->session->userdata('temp_checkout_user');
				$userId=$userData->id;
			}
			$created_by=1;
		}
		else if($this->session->userdata('user_id'))
		{
			$userId=$this->session->userdata('user_id');
			$userData=$this->currentUser;
			$created_by=2;
		}

		if($this->session->userdata("defaultCurrency")=='usd' && $customData['trustData']->payment_mode=='paypal')
		{
			$creditCardData=array();
			/*if($_POST["credit_card_id"]!='')
			{
				$this->load->model("credit_cards_model");
				$creditCardData=$this->credit_cards_model->getCard($_POST['credit_card_id']);
				if(empty($creditCardData))
				{
					goto end;
				}
				if($creditCardData->user_id!=$userId)
				{
					goto end;
				}
			}*/
		}
		$this->cart_log_model->log("Payment initiated",$this->session->userdata("storeCartAshramId"),3);

		//If payment mode not set or payment mode is default
		if(!isset($paymentMode) || $paymentMode=='default')
		{
			$paymentMode=$customData['trustData']->payment_mode;
		}

		if($this->session->userdata('loggedIn'))
			$created_by_user_id=$this->currentUser->id;

		$customData['cartData']=$cartContents;
		$customData['formData']=$_POST;
		$customData['ashramData']=$this->ashrams_model->ashramData($this->session->userdata("storeCartAshramId"));
		$customData['cart_type']=3;
		$customData['paymentMode']=$paymentMode;
		$customData['created_by']=$created_by;
		$customData['created_by_user_id']=$created_by_user_id;
		$customData['model']="orders/orders_model";
		$customData['model_name']="orders_model";
		$customData['ip_address']=$_SERVER['REMOTE_ADDR'];
		$customData['formData']['ashram_id']=$this->session->userdata("storeCartAshramId");

		$customData['formData']['is_manual_payment']=0;
		if($this->input->post("is_manual_payment"))
		{
			$customData['formData']['is_manual_payment']=1;
		}

        #--------------------------------------------------------------------------------------#
        //Which will validate Item Ashram ID and Order Ashram ID if any item mismatch with order Ashram ID It will returns flag 4 (Item modified warning and stop creating order).
        $this->load->helper("validate_order_ashram");
        $ashramCheck = validate_order_ashram(3,$cartContents,$this->session->userdata("storeCartAshramId"),$this->session->userdata("storeCartAshramIdSelection"));
        if($ashramCheck)
        {
            $result['flag']=4;
            goto end;
        }
        #--------------------------------------------------------------------------------------#
        
		$amount=$this->cart_model->getTotalPrice($this->storecart);
		$customData['amount_in_words']=$this->general_model->amountToWords($amount);
		//Load payment model
		$this->load->model("payment_model");
		//Load Temp payments model
		$this->load->model("temp_payments_model");
		$reference=$this->payment_model->setTempInfo(
			$userId,
			$userData,
			$amount,
			base_url."store/",
			base_url."store/checkout?ashram_id=".$this->session->userdata("storeCartAshramIdSelection")."&currency=".$this->session->userdata("defaultCurrency"),
			$customData,
			$this->session->userdata("defaultCurrency")
			);
		$result['flag']=1;
		$result['reference']=$reference;
		$this->cart_model->updateReferenceId($reference,3);

		$result['payment_mode']=$paymentMode;

        $tempOrderId = 0;
        $tempPaymentId = "";
        if($paymentMode=='razorpay')
        {
            $this->load->model("razorpay_webhook_model");
            $tempData = $this->razorpay_webhook_model->createTempOrders($reference,$this->session->userdata("store_items_temp_reference"));

            $tempOrderId = $tempData["order_id"];
            $tempPaymentId = $tempData["payment_id"];
        }

        if($paymentMode=='stripe')
        {
            $temp_reference = substr(hash('sha256', mt_rand() . microtime()), 0, 25);
            $result['temp_reference']=$temp_reference;

            $this->load->model("stripe_webhook_model");
            $str_amount = $amount*100;
            $tempData = $this->stripe_webhook_model->createTempOrders($reference,$temp_reference);
            $checkoutSession = $this->stripe_webhook_model->createStripeSession($this->session->userdata("defaultCurrency"),$this->input->post("email"),$customData['trustData'],3,$cartContents,$str_amount,$reference,$customData,$userId,$this->session->userdata("storeCartAshramIdSelection"));
            if($checkoutSession["status"] == "error")
            {
                $result['flag']=10023;
                $result['error_msg']=$checkoutSession['status_message'];
                goto end;
            }
        }

		if($this->session->userdata("defaultCurrency")=='usd')
		{
			$result['currency']="USD";
			if($paymentMode=='paypal')
			{
				$result['flag']=101;
				$this->load->model("paypal_model");
                $creditCardData = array();
				$paypalResponse=$this->paypal_model->processOneTimePayment($reference,$creditCardData);
				if($paypalResponse['flag']==1)
				{
					$result['redirect_to']=$paypalResponse['redirect_url'];
					$result['payment_status']=1;
					$this->session->set_flashdata("order_placed",1);
					$this->session->set_userdata("order_placed",1);
					$this->cart_log_model->log("Payment success:".$paymentMode,$this->session->userdata("storeCartAshramId"),3);
				}
				else
				{
					$result['payment_status']=0;
					$result['error_msg']=$paypalResponse['error_msg'];
					$this->cart_model->updateReferenceId('',1);
					$this->cart_log_model->log("Payment failure:".$paymentMode.", Reason:".$paypalResponse['error_msg'],$this->session->userdata("storeCartAshramId"),3);
				}
			}
			if($paymentMode=='authorize.net')
			{
				$this->load->model("authorizenet_model");
				$authnetResponse=$this->authorizenet_model->processOneTimePayment($reference);
				if($authnetResponse['flag']==1)
				{
					$result['redirect_to']=$authnetResponse['redirect_url'];
					$result['payment_status']=1;
					$this->cart_log_model->log("Payment success:".$paymentMode,$this->session->userdata("storeCartAshramId"),3);
					$this->session->set_flashdata("order_placed",1);
				}
				else
				{
					$result['payment_status']=0;
					$result['error']="Error making payment";//$authnetResponse['error_msg'];
					$this->cart_model->updateReferenceId('',3);
					$this->cart_log_model->log("Payment failure:".$paymentMode,$this->session->userdata("storeCartAshramId"),3);
				}
			}
			if($paymentMode=='razorpay')
			{
				$result['amount']=$amount*100;
				$result['payment_mode']="razorpay";
				$result['prefill_name']=$this->input->post("firstname")." ".$this->input->post("lastname");
				$result['prefill_email']=$this->input->post("email");
				$result['prefill_contact']=$this->input->post("phone");
                $result['tempOrderId'] = $tempOrderId;
                $result['tempPaymentId'] = $tempPaymentId;
                $result['application_reference'] = $reference;
			}
			if($paymentMode=='cash')
			{
				$offlineResponse=$this->offline_model->processPayment($reference);
				$result['redirect_to']=$offlineResponse['redirect_url'];
				$result['payment_status']=1;
				$this->session->set_flashdata("order_placed",1);
				$this->session->set_userdata("order_placed",1);
				$this->cart_log_model->log("Payment pending:".$paymentMode,$this->session->userdata("storeCartAshramId"),3);

				/*$tempIpn=new stdClass();
				$tempIpn->status='cash_pending';
				$tempIpn->amount=$amount;
				$tempInfo=$this->payment_model->getTempInfo($reference);
				$transaction=new stdClass();
				$transaction->tx='';
				$purchaseResponse=$this->payment_model->processPurchase($reference,$transaction,$tempInfo,$tempIpn);
				$result['payment_status']=1;
				$result['redirect_to']=$purchaseResponse['redirect_to'];*/
			}

			if($paymentMode=='stripe')
			{
				$result['amount']=$amount*100;
                $result['prefill_name']=$this->input->post("firstname")." ".$this->input->post("lastname");
                $result['prefill_email']=$this->input->post("email");
                $result['prefill_contact']=$this->input->post("phone");
                $result['currency']=$this->session->userdata("defaultCurrency");
                $result["session_id"]=$checkoutSession["session"]->id;
			}
		}
		else
		{
			$result['currency']="INR";
			if($paymentMode=='payu')
			{
				$result['redirect_to']='/payment/direct/'.$reference;
				$this->cart_log_model->log("Redirected to payment gateway:".$paymentMode,$this->session->userdata("storeCartAshramId"),3);
			}
			if($paymentMode=='razorpay')
			{
				$result['amount']=$amount*100;
				$result['prefill_name']=$this->input->post("firstname")." ".$this->input->post("lastname");
				$result['prefill_email']=$this->input->post("email");
				$result['prefill_contact']=$this->input->post("phone");
                $result['tempOrderId'] = $tempOrderId;
                $result['tempPaymentId'] = $tempPaymentId;
                $result['application_reference'] = $reference;
			}
			if($paymentMode=='cash')
			{
				$offlineResponse=$this->offline_model->processPayment($reference);
				$result['redirect_to']=$offlineResponse['redirect_url'];
				$result['payment_status']=1;
				$this->session->set_flashdata("order_placed",1);
				$this->session->set_userdata("order_placed",1);
				$this->cart_log_model->log("Payment pending:".$paymentMode,$this->session->userdata("storeCartAshramId"),3);
			}
			if($paymentMode=='stripe')
			{
				$result['amount']=$amount*100;
                $result['prefill_name']=$this->input->post("firstname")." ".$this->input->post("lastname");
                $result['prefill_email']=$this->input->post("email");
                $result['prefill_contact']=$this->input->post("phone");
                $result['currency']=$this->session->userdata("defaultCurrency");
                $result["session_id"]=$checkoutSession["session"]->id;
			}
		}
		
		end:
		echo json_encode($result);
    }

    /*public function receipt($tx='')
	{
		if($tx!='')
		{
			$this->load->model('orders/orders_model');
			$orderData=$this->orders_model->orderDataByTx($tx);
			if(!empty($orderData))
			{
				$this->load->model('locations_model');
				$data = array('orderData'=>$orderData,"tx"=>$tx);
				$data['views'] = array('orders/public/receipt');
				$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);
				$this->load->view(FRONTEND_TEMPLATE,$data);
			}
			else
			{
				$data['views'] = array('common/public/error');
				$this->load->view(FRONTEND_TEMPLATE,$data);
			}
		}
		else
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}*/

	public function download()
	{
		$flag=0;
		if(isset($_GET['key']) && $_GET['key']!='')
		{
			$token=base64_decode(urldecode($_GET['key']));
            $encKey=openssl_decrypt($token, open_ssl_encrypt_method, open_ssl_key, 0, open_ssl_iv);

            if(preg_match("/-/",$encKey))
            {
            	$keys=array_filter(explode("-",$encKey));
            	if(count($keys)==2)
            	{
            		$orderId=$keys[0];
            		$fileId=$keys[1];
            		$flag=1;
            	}
            }

            if($flag==1)
            {
            	$this->load->model("orders/orders_model");
				$orderData=$this->orders_model->orderData($orderId);
				if(!empty($orderData['order'])  && isset($orderData['order']->payment_status) && $orderData['order']->payment_status == 1 && isset($orderData['order']->fully_refunded) && $orderData['order']->fully_refunded == 0)
				{
					$orderItemsArray=array();
					foreach ($orderData['order_items'] as $itemData)
					{
						$orderItemsArray[$itemData->id]=$itemData;
					}
					if(!empty($orderData['order_items_files']))
					{
						$dFileData=array();
						$dItemData=array();
						foreach ($orderData['order_items_files'] as $fileData)
						{
							if((int)$fileId==$fileData->id)
							{
								$dFileData=$fileData;
								$dItemData=$orderItemsArray[$fileData->order_item_id];
								break;
							}
						}

						if(!empty($dFileData))
						{
							if($dFileData->downloads<max_order_file_downloads)
							{
								$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
						
								$amazonUri="private_files/store/".$dItemData->item_id."/".$dFileData->filename;
								$ext=pathinfo ($dFileData->filename,PATHINFO_EXTENSION);
								header("Cache-Control: public");
						        header("Content-Disposition: attachment; filename=".url_title($dFileData->title).".".$ext);
								$obj=$this->s3->getObject(aws_s3_bucket_name,$amazonUri);
								echo $obj->body;
                                $downloadCount = $dFileData->downloads+1;
                                $f_download_count = $dFileData->downloads+1;
								$this->logaction->log($this->service,"Guest - File Downloaded - Seva ID: ".$orderId." - File ID: ".$dFileData->id.
									" - File name: ".$dFileData->filename." - Download Count: ".$downloadCount);

								$this->orders_model->updateDownloadCount($dFileData->id,$f_download_count);
								return;
							}
							else
							{
								$this->logaction->log($this->service,"Guest - File Download limit reached - Seva ID: ".$orderId." - File ID: ".$dFileData->id." - File name: ".$dFileData->filename);
								$this->session->set_flashdata("file_download_limit_reached",1);
								$this->session->set_flashdata("status_message","File download limit exceeded, you cannot download this file anymore.");
								redirect("status");
							}
						}
					}
				}
			}
		}
		
		$data['views'] = array('common/public/error');
		$this->load->view(FRONTEND_TEMPLATE,$data);
	}

	public function updateaddress()
    {
		if($GLOBALS['storeCartLocked']==1)
		{
			echo 2;
			return;
		}

    	$this->form_validation->set_rules('value[address1]', 'Address 1', 'trim|required|min_length[3]|max_length[200]');
    	$this->form_validation->set_rules('value[address2]', 'Address 2', 'trim|min_length[3]|max_length[200]');
    	$this->form_validation->set_rules('value[address3]', 'Address 3', 'trim|min_length[3]|max_length[200]');
    	$this->form_validation->set_rules('value[city]', 'City', 'trim|required|min_length[2]|max_length[100]');
    	$this->form_validation->set_rules('value[state]', 'State', 'trim|required|min_length[2]|max_length[100]');
    	$this->form_validation->set_rules('value[country]', 'Country', 'trim|required|countryCheck');
    	$this->form_validation->set_rules('pk', 'ID', 'trim|required');
    	if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$item=$this->storecart->get_item($_POST['pk']);
		$options=$this->storecart->product_options($_POST['pk']);
		if(!empty($options))
		{
			$options['shipping_address']['address1']=$_POST['value']['address1'];
			$options['shipping_address']['address2']=$_POST['value']['address2'];
			$options['shipping_address']['address3']=$_POST['value']['address3'];
			$options['shipping_address']['city']=$_POST['value']['city'];
			$options['shipping_address']['state']=$_POST['value']['state'];
			$options['shipping_address']['country']=$_POST['value']['country'];
			$countryData=$this->locations_model->getCountryByCode($_POST['value']['country']);
			$options['shipping_address']['country_name']=$countryData->country_name;
			$updateArray= array(
		               'rowid' => $_POST['pk'],
           			       'options'   => $options
			            );

	        foreach ($options as $key => $val)
			{
				$temp[$key] = $val;
			}

			$this->storecart->update($updateArray);
			$this->cart_log_model->log("Shipping address updated, Item name:".$item['name'],$this->session->userdata("storeCartAshramId"),3);
			echo 1;
		}
		else
		{
			echo 0;
		}
    }


    public function updatename()
    {
		if($GLOBALS['storeCartLocked']==1)
		{
			echo 2;
			return;
		}

		$this->form_validation->set_rules('value', 'Name','trim|required|min_length[2]|max_length[60]');
    	$this->form_validation->set_rules('pk', 'ID', 'trim|required');
    	if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$item=$this->storecart->get_item($_POST['pk']);
		$options=$this->storecart->product_options($_POST['pk']);
		if(!empty($options))
		{
			$options['gift_friend_name']=$_POST['value'];
			$updateArray= array(
		               'rowid' => $_POST['pk'],
           			       'options'   => $options
			            );
			$this->storecart->update($updateArray);
			$this->cart_log_model->log("Gift name updated, Item name:".$item['name'],$this->session->userdata("storeCartAshramId"),3);
			echo 1;
		}
		else
		{
			echo 0;
		}
    }

    public function updateemail()
    {
		if($GLOBALS['storeCartLocked']==1)
		{
			echo 2;
			return;
		}

		$this->form_validation->set_rules('value', 'Email ID','trim|required|no_uppercase|valid_email_custom|min_length[6]|max_length[100]');
    	$this->form_validation->set_rules('pk', 'ID', 'trim|required');
    	if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$item=$this->storecart->get_item($_POST['pk']);
		$options=$this->storecart->product_options($_POST['pk']);
		if(!empty($options))
		{
			$options['gift_friend_email']=$_POST['value'];
			$updateArray= array(
		               'rowid' => $_POST['pk'],
           			       'options'   => $options
			            );
			$this->storecart->update($updateArray);
			$this->cart_log_model->log("Gift email updated, Item name:".$item['name'],$this->session->userdata("storeCartAshramId"),3);
			echo 1;
		}
		else
		{
			echo 0;
		}
    }

    public function updatePersonalnote()
    {
		if($GLOBALS['storeCartLocked']==1)
		{
			echo 2;
			return;
		}

		$this->form_validation->set_rules('value', 'Personal Note','trim|min_length[6]|max_length[500]');
    	$this->form_validation->set_rules('pk', 'ID', 'trim|required');
    	if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$item=$this->storecart->get_item($_POST['pk']);
		$options=$this->storecart->product_options($_POST['pk']);
		if(!empty($options))
		{
			$options['personal_note']=$_POST['value'];
			$updateArray= array(
		               'rowid' => $_POST['pk'],
           			       'options'   => $options
			            );
			$this->storecart->update($updateArray);
			$this->cart_log_model->log("Personal Note updated, Item name:".$item['name'],$this->session->userdata("storeCartAshramId"),3);
			echo 1;
		}
		else
		{
			echo 0;
		}
    }

    public function checkitemsemail()
    {
    	$data['flag']=1;
    	foreach ($this->storecart->contents() as $rowKey => $itemData)
    	{
    		if($itemData['options']['shipping']==0)
    		{
    			if($itemData['options']['gift_friend_email']=='')
    			{
    				$data['flag']=0;
    				$data['token'][]=$rowKey;
    			}
    		}
    	}
    	echo json_encode($data);
    }

    public function load_user_temp($uid=0)
	{
		$data['flag']=0;
		if(is_numeric($uid) && $uid)
		{
			$userData=$this->users_model->userData($uid);
			if(!empty($userData))
			{
				if($userData->status==1 && $userData->deleted==0 && $userData->email_verified==1)
				{
					unset($userData->pin);
					unset($userData->pass);
					unset($userData->conf_key);
					unset($userData->forgot_key);
					unset($userData->pin_copy);
					unset($userData->first_logged_in);
					unset($userData->security_complete);
					unset($userData->pin_set);
					unset($userData->role);
					unset($userData->roles);
					unset($userData->last_logged_in);
					$this->session->set_userdata('temp_checkout_user',$userData);
					$data['flag']=1;
					$data['userdata']=$userData;

					$this->load->library('poojascart');
					$this->load->library('donationscart');
					$this->load->library('subscriptionscart');
					//Empty the cart
					// $this->cart_model->emptyAllCarts();
				}
				else
				{
					$data['flag']=2;
				}
			}
			else
			{
				$data['flag']=2;
			}
		}
		header("Content-Type:application/json");
		echo json_encode($data);
	}


	public function changeListItemView()
	{
		$listType = $this->input->post('listType');
		if($listType)
		{
       		$this->session->set_userdata('storeviewType', $listType);
		}
	}


	public function clearCart()
	{
		$result['flag']=0;
		$cart=$this->storecart->contents();
		if(empty($cart))
    	{
    		$result['flag']=2;
    	} else {
    		foreach ($cart as $key => $value)
    		{
    			if(isset($key) && $key!='')
				{
					$item=$this->storecart->get_item($key);
					if(!empty($item))
					{
						$upd= array(
					               'rowid' => $key,
		               				'qty'   => 0
						            );
						$this->storecart->update($upd);
						$this->logaction->log($this->service,"Item removed from cart _ Item ID:".$item['id']." _ ".$item['name']." _ Row ID: ".$key);
                        $cc=$this->storecart->contents();
						$this->cart_log_model->log("Item removed - Name:".$item['name'],$this->session->userdata("storeCartAshramId"),3);
					}
				}
    		}
    		$cc=$this->storecart->contents();
			if(count($cc)==0)
			{
				$this->session->unset_userdata('storeCartAshramId');
				$result['flag']=1;
				$result['cart_count']=count($cc);
                $result['currency'] = '';
                $result['ashram_id'] = '';
                if($this->session->userdata('storeCartAshramIdSelection')>0)
                {
                    $result['ashram_id'] = $this->session->userdata('storeCartAshramIdSelection');
                }
                if($this->session->userdata("defaultCurrency"))
                {
                    $result['currency'] = $this->session->userdata("defaultCurrency");
                }
			} else {
				$result['flag']=3;
				$result['cart_count']=count($cc);
			}
			
    		$this->cart_model->regenerateSession(1);
    	}
		
		end:
		echo json_encode($result);
	}

    public function addItemAgain()
    {
        $result['flag']=0;
        if($GLOBALS['site_settings']['enable_orders']==0)
        {
            $result['flag']=55;
            goto end;
        }
        if($GLOBALS['site_settings']['store']==0 && (!$this->session->userdata("id") || $this->session->userdata("admin_data")->roles!=1))
        {
            $result['flag']=12;
            $result['error_msg']="Store items are disabled";
            goto end;
        }
        if($this->session->userdata("loggedIn") && $this->currentUser->admin==0)
        {
            if($this->currentUser->email_verified==0)
            {
                $result['flag']=51;
                goto end;
            }
        }
        if($this->session->userdata("loggedIn") && $this->currentUser->admin==1)
        {
            if(!$this->session->userdata('temp_checkout_user'))
            {
                $result['flag']=12;
                $result['error_msg']='Please select user before adding item to cart.';
                goto end;
            }
        }
        if($GLOBALS['storeCartLocked']==1)
        {
            $result['flag']=11;
            goto end;
        }

        //Check cart items count
        $cartContents=$this->storecart->contents();
        if(empty($cartContents)) //If cart is empty
        {
            $result['flag']=56;
            goto end;
        }

        if(isset($_POST['key']) && $_POST['key']!='')
        {
            $item=$this->storecart->get_item($_POST['key']);
            if(!empty($item))
            {
                $result = $this->addItem($item['id'],$_POST['key']);
                exit;
            }
            else
            {
                $result['flag']=2;
            }
        }
        end:
        echo json_encode($result);
    }


}
?>
