<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Speechesadmin extends CI_Controller 
{
	var $service='content';
    function __construct() 
	{
        parent::__construct();
		$this->load->model('content/speeches_model');
		$this->load->model('content/speeches_images_model');
		$this->load->model('content/speeches_category_model');
		$this->load->model('category/categories_model');
		$this->load->model('ashrams/ashrams_model');
		$this->load->model("mobile/mobileNotifications_model");

		if($this->session->userdata('id'))
		{
			$this->currentUser=$this->session->userdata("admin_data");
			if($this->currentUser->roles!=1)
			{
				if($this->currentUser->roles==7 || $this->currentUser->roles==9 ||  $this->currentUser->roles==3)
					$this->categories_model->fetchCategories(1);
				else
					$this->categories_model->fetchCategories(0,$this->currentUser->ashram_id);
			}
			else
			{
				$this->categories_model->fetchCategories(1);
			}
		}
		else
		{
			$this->categories_model->fetchCategories(1);
		}
    }
	public function index()
	{
		$views = array( 'speeches/admin/list' );
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Speeches Listing");
	}

	public function listc($excel=0)
	{
		$ashramId = $this->session->userdata("ashramId");
		if($this->currentUser->roles!=1 && $this->currentUser->roles!=7 && $this->currentUser->roles!=9)
		{
			if($this->currentUser->ashram_id)
				$ashramId=$this->currentUser->ashram_id;
			else if($this->currentUser->satsang_id)
				$ashramId=$this->currentUser->satsang_id;
		}
		$ashramId = isset($ashramId)?$ashramId:0;
		$list=$this->speeches_model->listAdmin($ashramId,$excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Speeches Listing ajax request");
	}
	
	public function add_edit_speech ($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$speechData=$this->speeches_model->speechData($id);
			if(empty($speechData))
			{
				$this->session->set_flashdata("speech_error",1);
				redirect('speechesadmin');
			}
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7 && $this->currentUser->roles!=9)
			{
				if($speechData->ashram_id!=$this->currentUser->ashram_id)
				{
					$data['views'] = array('common/public/error');
                	$this->load->view(FRONTEND_TEMPLATE,$data);
                	return;
				}
			}
		}
		else
		{
			$speechData=array();
		}

		if(isset($_POST["save_speech"]))
		{
			if(!isset($_POST['description']))
			{
				$this->session->set_flashdata("speech_error",1);
				redirect('speechesadmin/add_edit_speech/'.$id);
			}

			$this->form_validation->set_rules('name', 'Speech Title', 'trim|required|min_length[6]|max_length[200]|speechNameCheck');
			$this->form_validation->set_rules('categories[]', 'Categories', 'checkCategories');
			$this->form_validation->set_rules('published_on', 'Publish Date', 'trim|required');
			$this->form_validation->set_rules('seo_keywords', 'SEO Keywords', 'trim|min_length[10]|max_length[500]');
			$this->form_validation->set_rules('seo_description', 'SEO Description', 'trim|min_length[10]|max_length[500]');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("speech_error",1);
				redirect('speechesadmin/add_edit_speech/'.$id);
				return;
			}
			$this->load->library("one_signal");
			$saved=$this->speeches_model->save($id,$speechData);
			if($id==0)
			{
				$this->session->set_flashdata("speech_created",1);
			}
			else
				$this->session->set_flashdata("speech_saved",1);
			redirect('speechesadmin/add_edit_speech/'.$saved);
			
		}
		else
		{
			if($id!='' && (empty($speechData)) )
			{
				redirect('speechesadmin');
			}
			$views = array('speeches/admin/add_edit_speech');
			$data = array('views'=>$views,'id'=>$id);
			$data['ashrams']=$this->ashrams_model->getList();
			if(is_numeric($id) && $id)
			{
				$data['speechData']=$speechData;
				if($speechData->ashram_id)
					$data['ashramData']=$this->ashrams_model->ashramData($speechData->ashram_id);
			}
			$this->load->view(ADMIN_TEMPLATE,$data); 
		}
	}

	function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$speechData=$this->speeches_model->speechData($id);
			if(empty($speechData))
			{
				goto end;
			}

			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7 && $this->currentUser->roles!=9)
			{
				if($speechData->ashram_id!=$this->currentUser->ashram_id)
				{
					goto end;
				}
			}
			
			$r=$this->speeches_model->delete($id,$speechData);
			if($r)
			{
				//deleting related notification data also
				$this->mobileNotifications_model->remove($id,'speeches');
				$data['flag']=1;
				$data['name']=$speechData->name;
				$this->logaction->log($this->service,"Admin - Speech '".$speechData->name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}
	public function titlecheck($id=0)
	{
		if(isset($_POST['title']) && $_POST['title']!='')
		{
			$slug=url_title($this->general_model->filtertext($_POST['title']));
			if(strlen($slug)<6)
				echo 0;
			else
			{
				echo 1;
			}
		}
	}

	public function speech_validate($sid=0,$pid=0)
	{
		if(is_numeric($sid) && is_numeric($pid) && $pid)
		{
			if($sid==$pid)
			{
				echo 2;
			}
			else
			{
				$ashramId = $this->session->userdata("ashramId");
				if($this->currentUser->roles!=1 && $this->currentUser->roles!=7 && $this->currentUser->roles!=9)
				{
					if($this->currentUser->ashram_id)
						$ashramId=$this->currentUser->ashram_id;
				}
				$ashramId = isset($ashramId)?$ashramId:0;
				$parentSpeechData=$this->speeches_model->checkSpeechId($pid,$ashramId);
				if(!empty($parentSpeechData))
				{
					echo $parentSpeechData->name."<br>".date("d M Y",strtotime($parentSpeechData->published_on));
				}
				else
					echo 0;
			}
		}
		else
			echo 0;
	}

	/*public function wpimport()
	{
		ini_set('max_execution_time', 0);
		include(APPPATH.'config/database.php');

		$config['hostname'] = "localhost";
		$config['username'] = $db['default']['username'];
		$config['password'] = $db['default']['password'];
		$config['database'] = "dev_external";
		$config['dbdriver'] = "mysqli";
		$config['dbprefix'] = "";
		$config['pconnect'] = FALSE;
		$config['db_debug'] = TRUE;
		$config['cache_on'] = FALSE;
		$config['cachedir'] = "";
		$config['char_set'] = "utf8mb4";
		$config['dbcollat'] = "utf8mb4_general_ci";

		$this->blogDbExternal=$this->load->database($config,true,false);


		$this->blogDbExternal->select("ID,post_title,post_parent,post_name");
		$this->blogDbExternal->where("post_type",'page');
		//$this->blogDbExternal->order_by("parent, order, category");
		$q=$this->blogDbExternal->get("wp_posts");

        $categoriesList = array(
            'categories' => array(),
            'parent_cats' => array()
        );
 
        foreach ($q->result() as $row)
        {
            $categoriesList['categories'][$row->ID] = $row;
            $categoriesList['parent_cats'][$row->post_parent][] = $row;
        }


		$this->blogDbExternal->where("post_type",'page');
		$this->blogDbExternal->where("post_status",'publish');
		//$this->blogDbExternal->order_by("ID","desc");
		//$this->blogDbExternal->limit(10);
		$q=$this->blogDbExternal->get('wp_posts');

		foreach ($q->result() as $wppost)
		{
			echo $wppost->post_title.' - '.$wppost->ID.'<br>';

			$speecheslug=strtolower(url_title($wppost->post_title));

			$publishDate=date("Y:m:d",strtotime($wppost->post_date));
			$cnt=0;
			while(1)
			{
				$this->db->where("slug",$speecheslug);
				//$this->db->where("id !=",0);
				$this->db->where("date(published_on)",$publishDate);
				$chk=$this->db->get('speeches');
				if($chk->num_rows())
				{
					$cnt++;
					$speecheslug=$speecheslug."-".$cnt;
					continue;
				}
				else
				break;
			}

			$category=$wppost->ID;
			//echo $category;
			$speechCatId='';
	        if(isset($categoriesList['categories'][$category]))
			{
				$cid=$categoriesList['categories'][$category]->ID;
				$parent=$categoriesList['categories'][$category]->post_parent;

				$temp=$parent;
				$parentsArray=array();

				if($parent)
				while(1)
				{
					$parentData=$categoriesList['categories'][$temp];
					$parentsArray[]=$parentData;
					if($parentData->post_parent)
					{
						$temp=$parentData->post_parent;
						continue;
					}
					else
					{
						break;
					}
				}
				
				if(!empty($parentsArray))
				{
					$catLen=count($parentsArray);
					unset($parentsArray[$catLen-1]);

					if(!empty($parentsArray))
					{
						$catLen=count($parentsArray);

						if(isset($parentsArray[$catLen-1]))
						{
							if($parentsArray[$catLen-1]->post_name=='datta-vaakya')
							{
								$speechCatId=560;
							}
							else
							{
								$speechCatId=561;
							}
						}
						else
						{
							if($parentsArray[0]->post_name=='datta-vaakya')
							{
								$speechCatId=560;
							}
							else
							{
								$speechCatId=561;
							}
						}
					}
				}
				
			}

			$q=$this->db->insert('speeches',
	                    array(
	                    	'name' => $wppost->post_title,
	                    	'slug'=>$speecheslug,
							'description' => $wppost->post_content,
							'published_on' => date("Y:m:d 00:00:00",strtotime($wppost->post_date)),
							'seo_keywords' => $wppost->post_title,
							'seo_description' => $wppost->post_title,
							'year'=>date("Y",strtotime($wppost->post_date)),
							'month'=>abs(date("m",strtotime($wppost->post_date))),
							'day'=>abs(date("d",strtotime($wppost->post_date))),
							'categories'=>'',
							'created_on'=>date("Y:m:d H:i:s"),
							'created_by'=>1,
							'wp_id'=>$wppost->ID,
							'categories'=>$speechCatId
						)
					);

			$speechId=$this->db->insert_id();

			

			if(isset($speechCatId) && $speechCatId>0)
			{
				$this->db->insert('speeches_category',
									array(
											'speech_id'=>$speechId,
											'category_id'=>'560'
										)
								);
			}


				

			echo "<hr>";
			//break;
		}
	}

	public function cats()
	{
		ini_set('max_execution_time', 0);
		include(APPPATH.'config/database.php');

		$config['hostname'] = "localhost";
		$config['username'] = $db['default']['username'];
		$config['password'] = $db['default']['password'];
		$config['database'] = "dev_external";
		$config['dbdriver'] = "mysqli";
		$config['dbprefix'] = "";
		$config['pconnect'] = FALSE;
		$config['db_debug'] = TRUE;
		$config['cache_on'] = FALSE;
		$config['cachedir'] = "";
		$config['char_set'] = "utf8mb4";
		$config['dbcollat'] = "utf8mb4_general_ci";

		$this->blogDbExternal=$this->load->database($config,true,false);


		$this->blogDbExternal->select("ID,post_title,post_parent,post_name");
		$this->blogDbExternal->where("post_type",'page');
		$this->blogDbExternal->where("post_status",'publish');
		//$this->blogDbExternal->order_by("parent, order, category");
		$q=$this->blogDbExternal->get("wp_posts");

        $categoriesList = array(
            'categories' => array(),
            'parent_cats' => array()
        );
 
        //build the array lists with data from the category table
        foreach ($q->result() as $row)
        {
            //creates entry into categories array with current category id ie. $categories['categories'][1]
            $categoriesList['categories'][$row->ID] = $row;
            //$categoriesList['categories'][$row->slug] = $row;
            //creates entry into parent_cats array. parent_cats array contains a list of all categories with children
            $categoriesList['parent_cats'][$row->post_parent][] = $row;
        }

        $this->updateParent(0,1,0,$categoriesList);
        //print_r($categoriesList['parent_cats'][0]);
        exit;
        $category=2158;
        if(isset($categoriesList['categories'][$category]))
		{
			$cid=$categoriesList['categories'][$category]->ID;
			$parent=$categoriesList['categories'][$category]->post_parent;

			$temp=$parent;
			$parentsArray=array();

			if($parent)
			while(1)
			{
				$parentData=$categoriesList['categories'][$temp];
				$parentsArray[]=$parentData;
				if($parentData->post_parent)
				{
					$temp=$parentData->post_parent;
					continue;
				}
				else
				{
					break;
				}
			}
			
			$catLen=count($parentsArray);
			unset($parentsArray[$catLen-1]);

			$catLen=count($parentsArray);
			echo $parentsArray[$catLen-1]->post_name;
		}
	}

	private function updateParent($parent,$level,$currentID=0,$categoriesList)
	{
        if (isset($categoriesList['parent_cats'][$parent]))
        {
            foreach ($categoriesList['parent_cats'][$parent] as $catData)
            {
            	echo str_repeat("&#8210; ",$level-1);
            	echo $categoriesList['categories'][$catData->ID]->post_name." - ".$catData->ID." - ".$parent."<br>";

            	$this->db->where("wp_id",$parent);
            	$q1=$this->db->get("speeches")->row();

            	if(!empty($q1))
            	{
            		$this->db->where("wp_id",$catData->ID);
            		$this->db->update("speeches",array("parent_link"=>$q1->id));
            	}
            	
                if (isset($categoriesList['parent_cats'][$catData->ID]))
                {
	                $nl=$level+1;
	                $this->updateParent($catData->ID,$nl,$currentID,$categoriesList);
            	}
            }
        }
    }*/

    /*public function imgtest()
    {
    	$this->db->like("description",'<img');
        $q1=$this->db->get("speeches")->result();

        $this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

        foreach ($q1 as $row)
        {
        	//echo $row->description;
        	$this->load->helper("simple_html_dom");
			$dom=new simple_html_dom();
			$content=$dom->load($row->description);
			$images=$content->find('img');
			foreach ($images as $imgData)
			{
				echo $imgData->src." - ".$row->id;
				$amazonUri="content/speeches/".$row->id."/";

				$ext=pathinfo ($imgData->src,PATHINFO_EXTENSION);
				$newFileName=md5(mt_rand() . microtime()).".".$ext;
				$tempPath=$_SERVER['DOCUMENT_ROOT']."/temp/".$newFileName;
				file_put_contents($tempPath,file_get_contents($imgData->src));

				$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newFileName,S3::ACL_PUBLIC_READ, array(), array());
				unlink($tempPath);
				$imageData=array('filename' => $newFileName,
									'speech_id' =>$row->id
									);
				$this->speeches_images_model->insert($imageData);

				$newImagePath=aws_s3_base_url.$amazonUri.$newFileName;

				$newDescription=str_replace($imgData->src,$newImagePath,$row->description);

			}

			$this->db->where("id",$row->id);
			$this->db->update("speeches",array("description"=>$newDescription));
        	echo "<hr>";
        }
    }*/
}
?>