<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Speeches extends CI_Controller 
{
	var $currentUser='';
	var $months=array(1=>"January",2=>"February",3=>"March",4=>"April",5=>"May",6=>"June",7=>"July",8=>"August",9=>"September",10=>"October",11=>"November",12=>"December");
    function __construct() 
	{
        parent::__construct();
		$this->load->model('content/speeches_model');
        $this->load->model('category/categories_model');
        $this->load->model('content/album_model');
        $this->load->model('content/album_images_model');
        $this->categories_model->fetchCategories(1);
        if($this->session->userdata('id'))
        	$this->currentUser=$this->session->userdata("admin_data");
       	else
       		$this->currentUser=$this->session->userdata("user_data");
    }
    public function index($year=0,$month=0,$day=0)
    {
    	$data = array('year'=>$year,'month'=>$month,'day'=>$day);
    	$yearmonths=$this->speeches_model->getYearMonths();
    	$data['yearmonths']=$yearmonths;
    	$data['views'] = array('speeches/public/list');
		$this->load->view(FRONTEND_TEMPLATE,$data);
    }
    public function listc()
	{
		$list=$this->speeches_model->listPublic();
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='')
		{
			$this->search_log_model->log(trim($_POST['search_text']),'speeches');
		}
		echo json_encode($list);
	}
	
   	public function view($year=0,$month=0,$day=0,$slug='')
	{
		if($slug!='')
		{
			$speechData=$this->speeches_model->speechDataBySlugDate($slug,$year,$month,$day);
			if(!empty($speechData))
			{
				/*if($speechData->year!=$year || $speechData->month!=$month || $speechData->day!=$day)
				{
					goto end;
				}*/
				/*$countUpdate=1;
				if($this->session->userdata("loggedIn") && $this->currentUser->role==1)
				{
					$countUpdate=0;
				}*/
				//if($countUpdate==1)
				//$this->speeches_model->updateReadCount($speechData->id,($speechData->reads+1));
				$data = array('speechData'=>$speechData);
				if($speechData->ashram_id)
				{
					$data['ashramData']=$this->ashrams_model->ashramData($speechData->ashram_id);
					redirect('ashrams/'.$data['ashramData']->slug.'/speeches/'.$speechData->year.'/'.$speechData->month.'/'.$speechData->day.'/'.$speechData->slug);
				}
				if($speechData->satsang_id)
					$data['satsangData']=$this->satsangs_model->satsangData($speechData->satsang_id);
				$data['children']=$this->speeches_model->getChildren($speechData->id);
				$data['views'] = array('speeches/public/view');
				$this->load->view(FRONTEND_TEMPLATE,$data);
				return;
			}
		}
		end:

		//print_r($speechData);
		//exit;

		$data['views'] = array('common/public/error');
		$this->load->view(FRONTEND_TEMPLATE,$data);
	}
	public function category($category='') 
	{
		$data = array('category'=>$category);
		if(isset($this->categories_model->categoriesList['categories'][$category]))
		{
			$data['categoryExist']=1;
			$data['categoryName']=htmlentities($this->categories_model->categoriesList['categories'][$category]->category);
			$data['categoryId']=$this->categories_model->categoriesList['categories'][$category]->id;
		}
		else
		{
			$data['categoryName']="All Categories";
			$data['categoryId']=0;
		}
		$data['views'] = array('speeches/public/category_view');
		$this->load->view(FRONTEND_TEMPLATE,$data);
    }
    public function listbycategory($categorySlug='')
	{
		$categoryId=0;
		if(isset($_POST['category']))
		{
			$category=$_POST['category'];
			if(isset($this->categories_model->categoriesList['categories'][$category]))
			{
				$categoryId=$this->categories_model->categoriesList['categories'][$category]->id;
			}
		}
		$list=$this->speeches_model->listPublicByCategory($categoryId);
		echo json_encode($list);
	}
}
?>
