<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
/**
 * Controls the Admin dashbaord operations for SMS Service
 * 
 * @version   1.1
 * @author    Manoj MS <manoj@agilonconsulting.com>
 */

class Smsadmin extends CI_Controller
{
	var $breadcrumb=array(
						"users"=>array("link"=>"usersadmin",
												"slugpart"=>"users",
												"titlepart"=>"Users",
												"main_model"=>"user/users_model",
												"module_links_path"=>"users/admin/users_nav_buttons",
												"name"=>"All Users"),
						"ashrams"=>array("link"=>"ashramadmin",
												"slugpart"=>"ashram",
												"titlepart"=>"Ashrams",
												"main_model"=>"ashrams/ashrams_model",
												"module_links_path"=>"ashrams/admin/nav_buttons",
												"name"=>"All Ashrams"),
						"satsangs"=>array("link"=>"satsangsadmin",
												"slugpart"=>"satsangs",
												"titlepart"=>"Satsangs",
												"main_model"=>"satsangs/satsangs_model",
												"module_links_path"=>"satsangs/admin/nav_buttons",
												"name"=>"All Satsangs"),
						"subscribe"=>array("link"=>"subscriptions",
												"slugfullpart"=>"emailsmssubscriptionsadmin",
												"slugpart"=>"subscriptions",
												"titlepart"=>"Subscriptions",
												"module_links_path"=>"subscriptions/admin/nav_buttons",
												"name"=>"SMS Subscriptions"),
						"techsupport"=>array("link"=>"techsupport",
												"slugpart"=>"techsupport",
												"titlepart"=>"Support Tickets",
												"name"=>"Support Tickets"),
						"greetings"=>array("link"=>"greetings",
												"slugpart"=>"greetings",
												"titlepart"=>"Greetings",
												"name"=>"All Greetings"),
						"email"=>array("link"=>"email",
												"slugpart"=>"email",
												"titlepart"=>"Email Queue",
												"name"=>"Email Queue"),
						"orders"=>array("link"=>"orders",
												"slugpart"=>"orders",
												"slugfullpart"=>"orders",
												"titlepart"=>"Sevas",
												"module_links_path"=>"orders/admin/nav_buttons",
												"name"=>"All Sevas"),
						"anaghavrata"=>array("link"=>"anaghavrata",
												"slugpart"=>"anaghavrata",
												"slugfullpart"=>"anaghavrataadmin",
												"titlepart"=>"Anaghavrata Counts",
												"module_links_path"=>"anaghavrata/admin/nav_buttons",
												"name"=>"All Anaghavrata Counts"),
						"ramamantra"=>array("link"=>"ramamantra",
												"slugpart"=>"ramamantra",
												"slugfullpart"=>"ramamantraadmin",
												"titlepart"=>"Rama Mantra Japa Counts",
												"module_links_path"=>"ramamantra/admin/nav_buttons",
												"name"=>"All Rama Mantra Japa Counts"),
						"hanumanchalisa"=>array("link"=>"hanumanchalisa",
												"slugpart"=>"hanumanchalisa",
												"slugfullpart"=>"hanumanchalisaadmin",
												"titlepart"=>"Hanumanchalisa Counts",
												"module_links_path"=>"hanumanchalisa/admin/nav_buttons",
												"name"=>"All Hanumanchalisa Counts"),
						"vishwashantipadayatra2022"=>array("link"=>"vishwashantipadayatra2022",
												"slugpart"=>"vishwashantipadayatra2022",
												"slugfullpart"=>"vishwashantipadayatra2022admin",
												"titlepart"=>"Vishwashantipadayatra2022 Counts",
												"module_links_path"=>"vishwashantipadayatra2022/admin/nav_buttons",
												"name"=>"All Vishwashantipadayatra2022 Counts"),
						"vishwashantipadayatra"=>array("link"=>"vishwashantipadayatra",
												"slugpart"=>"vishwashantipadayatra",
												"slugfullpart"=>"vishwashantipadayatraadmin",
												"titlepart"=>"Vishwashantipadayatra Counts",
												"module_links_path"=>"vishwashantipadayatra/admin/nav_buttons",
												"name"=>"All Vishwashantipadayatra Counts"),
						"shodashadattakshetrapadayatra"=>array("link"=>"shodashadattakshetrapadayatra",
												"slugpart"=>"shodashadattakshetrapadayatra",
												"slugfullpart"=>"shodashadattakshetrapadayatraadmin",
												"titlepart"=>"Shodasha Datta Kshetra Pada Yatra Counts",
												"module_links_path"=>"shodashadattakshetrapadayatra/admin/nav_buttons",
												"name"=>"All Shodasha Datta Kshetra Pada Yatra Counts"),
						);
	var $service='';
	var $status=array(0,1,2);
	var $status_values=array(0=>"Pending",1=>"Sent",2=>"Failed");
	var $bools=array(0=>"No",1=>"Yes");
	function __construct() 
    {
        parent::__construct();
		$this->load->model("sms_model");
		$this->load->model('ashrams/ashrams_model');
		$this->currentUser=$this->session->userdata("admin_data");
		if(is_single_ashram_site)
        { 
            $this->session->set_userdata("ashramId",default_ashram_id); 
		}
	}
	public function listsms($serviceSlug='')
	{
		//if($this->checkService($serviceSlug))
		//{
			$views = array( 'sms/admin/list');
			$data = array('views'=>$views,"service"=>$serviceSlug);
			$this->load->view(ADMIN_TEMPLATE,$data);
		//}
	}
	public function sms_data($serviceSlug='',$excel=0)
	{
		//if($this->checkService($serviceSlug))
		//{
		if($this->input->post("service_slug")!='')
			$serviceSlug=$this->input->post("service_slug");
		$data=$this->sms_model->listsms($serviceSlug,$excel);
		echo json_encode($data);
		//}
	}
	private function checkService($serviceSlug='')
	{
		$this->load->model("services_model");
		$result=$this->services_model->getBySlug($serviceSlug);
		if(!empty($result))
		{
			$this->service=$serviceSlug;
			return 1;
		}
		else
			return 0;
	}
	public function resend($serviceSlug='',$id=0)
	{
		if($this->input->post("service_slug")!='')
			$serviceSlug=$this->input->post("service_slug");
		$data=$this->sms_model->resendSMS($serviceSlug,$id);
		echo json_encode($data);
	}
	public function sms_bulk_resend($serviceSlug='')
	{
		$result['flag']=0;
		$result['msg']="Invalid request";
		if(isset($_POST['bulk_actions']) && $_POST['bulk_actions']=="resend")
		{
			$ex='';
			$count=0;
			if(isset($_POST['ids']))
			foreach($_POST['ids'] as $id)
			{
				if($this->input->post("service_slug")!='')
					$serviceSlug=$this->input->post("service_slug");
				$data=$this->sms_model->resendSMS($serviceSlug,$id);
				if($data['flag']==1)
				{
					$count++;
				}
			}
			$result['flag']=1;
			$result['msg']="'".$count."' SMS(s) have been resent successfully.";
			$result['num']=$count;
		}
		echo json_encode($result);
	}
}