<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Sevas extends CI_Controller 
{
	var $currentUser='';
	var $service='orders';
	var $currencies;
	var $payment_success_statuses=array("completed",'success','Success','release payment','Release Payment','approved','captured','paid');
    function __construct()
	{
        parent::__construct();
		$this->load->model("orders/orders_model");
		$this->load->model("orders/sevas_model");
		if($this->session->userdata('id'))
		{
			$this->currentUser=$this->session->userdata("admin_data");
		}
		else if($this->session->userdata('user_id'))
		{
			$this->currentUser=$this->session->userdata("user_data");
		}
		if(is_single_ashram_site)
        { 
            $this->session->set_userdata("ashramId",default_ashram_id); 
		}
		$this->load->model('ashrams/ashrams_model');
		$this->load->model('ashrams/poojas_model');
		$this->load->model('ashrams/donations_model');
		$this->load->model('ashrams/store_cover_photos_model');
		$this->load->model('ashrams/store_files_model');
		$this->load->model('ashrams/subscriptions_model');
		$this->load->model('ashrams/store_model');
		$this->load->model('currencies_model');
		$this->load->model('pets_model');
		$this->load->model('orders/order_log_model');
		$this->load->model("user/users_model");
		$this->load->model("orders/sevas_report_access_users_model");
		$this->load->model("foreign_currencies_model");
		$this->currencies=$this->currencies_model->getByAshram(0);

		//==========Load encryption library=============//

    	$this->load->library('encryption');

		$this->encryption->initialize(
		        array(
		                'cipher' => 'aes-256',
		                'mode' => 'cbc',
		                'key' => file_get_contents("../app_configs/aes_key")
		        )
		);

    	//==========Load encryption library=============//
    }

    public function user_grant_access_reports()
    {
    	$views = array( 'sevas/admin/list_report_access_users' );
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Sevas Listing");
    }

    public function listugar($excel=0)
	{
		$list=$this->sevas_report_access_users_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Sevas Listing ajax request");
	}

	public function delete_access_report($id=0)
	{
		$result['flag']=0;
		if(is_numeric($id) && $id)
		{
			$accessData=$this->sevas_report_access_users_model->getData($id);
			if(empty($accessData))
			{
				goto end;
			}
			$this->sevas_report_access_users_model->delete($id);
			$result['flag']=1;
			$result['user_name']=$accessData->user_name;
		}
		end:
		echo json_encode($result);
	}

	public function getItemString($sevaType,$itemsString)
	{
		$itemsArray = explode(",", $itemsString);

		$itemNameString = "<ol>";
		if($sevaType == 1)
		{
			foreach ($itemsArray as $poojaId)
			{
				$poojaData=$this->poojas_model->poojaData($poojaId);
				$itemNameString.= "<li>".$poojaData->pooja_name."</li>";
			}
			$itemNameString.="</ol>";
		}
		if($sevaType == 2)
		{
			foreach ($itemsArray as $donId)
			{
				$donationData=$this->donations_model->donationData($donId);
				$itemNameString.= "<li>".$donationData->donation_name."</li>";
			}
			$itemNameString.="</ol>";
		}
		if($sevaType == 3)
		{
			foreach ($itemsArray as $storeId)
			{
				$storeData=$this->store_model->itemData($storeId);
				$itemNameString.= "<li>".$storeData["item"]->item_name."</li>";
			}
			$itemNameString.="</ol>";
		}
		if($sevaType == 4)
		{
			foreach ($itemsArray as $subId)
			{
				$subscriptionData=$this->subscriptions_model->subscriptionData($subId);
				$itemNameString.= "<li>".$subscriptionData->subscription_name."</li>";
			}
			$itemNameString.="</ol>";
		}
		return $itemNameString;
	}

	public function grant_report_access()
	{
		$data['flag']=0;
		if(!empty($this->input->post("seva_type")) && !empty($this->input->post("ashram_id")) && is_numeric($this->input->post("seva_type")) && $this->input->post("seva_type") && in_array($this->input->post("seva_type"),array(1,2,3,4)) )
		{
			$postedItemIds = "all";
			if(!empty($this->input->post("item_ids")))
			{
				$postedItemIds = $this->input->post("item_ids");
			}
			if(!empty($this->input->post("currency")))
			{
				$currencies = $this->currencies_model->getByAshram($this->input->post("ashram_id"),$this->input->post("currency"));
				$currencies_str = $this->input->post("currency");
			}
			if(empty($this->input->post("currency")))
			{
				$currencies = $this->currencies_model->getByAshram($this->input->post("ashram_id"));
				foreach($currencies as $key=>$value)
				{
					$string_cc[] = $key;
				}
				$currencies_str = implode(",", $string_cc);
			}

			if(empty($currencies))
				goto end;

			$ashramData=$this->ashrams_model->ashramData($this->input->post("ashram_id"));
			if(empty($ashramData))
				goto end;

			if(strtotime($this->input->post("access_validity")) < strtotime(date("Y-m-d")))
				goto end;


		    $reportId = $this->sevas_report_access_users_model->getMaxReportId();
			$reportNumber = "GAR-".date("Y")."-".$reportId;
			$enc_reportNumber = md5($reportNumber);

			$users = explode(",", $this->input->post("grant_user"));

			if(empty($this->input->post("item_ids")))
			{
				$itemsArray = array();
			}
			else
			{
				$itemsArray = explode(",", $this->input->post("item_ids"));
			}
			//Poojas
			$itemNameString = "<ul>";
			if($this->input->post("seva_type") == 1)
			{	
				if(count($itemsArray)==0)
				{
					$itemNameString.= "<li>All Poojas</li>";
				}
				else
				{
					foreach ($itemsArray as $poojaId)
					{
						$poojaData=$this->poojas_model->poojaData($poojaId);
						if(empty($poojaData))
							goto end;

						$itemNameString.= "<li>".$poojaData->pooja_name."</li>";
					}
				}
				$itemNameString.="</ul>";
				foreach($users as $value)
				{
					$userData = $this->users_model->userData($value);
					if($userData->roles <= 0)
					{
						goto end;
					}
					$access_key = substr(md5(time().mt_rand()), 0, 18);
					$report_url = base_url."sevas/pooja_reports?access_key=".$access_key;
					
					$saveData = array(
						"user_id"=>$value,
						"user_name"=>$userData->username,
						"role"=>$userData->roles,
						"report_id"=>$reportId,
						"report_number"=>$reportNumber,
						"currency"=>$currencies_str,
						"access_key"=>$access_key,
						"ashram_id"=>$this->input->post("ashram_id"),
						"seva_type"=>$this->input->post("seva_type"),
						"item_ids_string"=>$postedItemIds,
						"item_names_string"=>$itemNameString,
						"report_url"=>$report_url,
						"report_key"=>$enc_reportNumber,
						"report_end_time"=>date("Y-m-d 23:59:59",strtotime($this->input->post("access_validity"))),
						"status"=>1,
						"created_on"=>date("Y-m-d H:i:s")
								);
					$success = $this->sevas_report_access_users_model->save($saveData);
					if($success)
					{
						$data['flag']=1;
					}
				}
			}
			//Donations
			if($this->input->post("seva_type") == 2)
			{
				if(count($itemsArray)==0)
				{
					$itemNameString.= "<li>All Donations</li>";
				}
				else
				{
					foreach ($itemsArray as $donId)
					{
						$donationData=$this->donations_model->donationData($donId);
						if(empty($donationData))
							goto end;

						$itemNameString.= "<li>".$donationData->donation_name."</li>";
					}
				}
				$itemNameString.="</ul>";
				foreach($users as $value)
				{
					$userData = $this->users_model->userData($value);
					if($userData->roles <= 0)
					{
						goto end;
					}

					$access_key = substr(md5(time().mt_rand()), 0, 18);
					$report_url = base_url."sevas/donation_reports?access_key=".$access_key;
					
					$saveData = array(
						"user_id"=>$value,
						"role"=>$userData->roles,
						"report_id"=>$reportId,
						"report_number"=>$reportNumber,
						"currency"=>$currencies_str,
						"user_name"=>$userData->username,
						"access_key"=>$access_key,
						"ashram_id"=>$this->input->post("ashram_id"),
						"seva_type"=>$this->input->post("seva_type"),
						"item_ids_string"=>$postedItemIds,
						"item_names_string"=>$itemNameString,
						"report_url"=>$report_url,
						"report_key"=>$enc_reportNumber,
						"report_end_time"=>date("Y-m-d 23:59:59",strtotime($this->input->post("access_validity"))),
						"status"=>1,
						"created_on"=>date("Y-m-d H:i:s")
								);
					$success = $this->sevas_report_access_users_model->save($saveData);
					if($success)
					{
						$data['flag']=1;
					}
				}
			}
			//Store
			if($this->input->post("seva_type") == 3)
			{
				if(count($itemsArray)==0)
				{
					$itemNameString.= "<li>All Store Items</li>";
				}
				else
				{
					foreach ($itemsArray as $storeId)
					{
						$storeData=$this->store_model->itemData($storeId);
						if(empty($storeData))
							goto end;

						$itemNameString.= "<li>".$storeData["item"]->item_name."</li>";
					}
				}
				$itemNameString.="</ul>";
				foreach($users as $value)
				{
					$userData = $this->users_model->userData($value);
					if($userData->roles <= 0)
					{
						goto end;
					}
					$access_key = substr(md5(time().mt_rand()), 0, 18);
					$report_url = base_url."sevas/store_reports?access_key=".$access_key;
					
					$saveData = array(
						"user_id"=>$value,
						"user_name"=>$userData->username,
						"currency"=>$currencies_str,
						"role"=>$userData->roles,
						"report_id"=>$reportId,
						"report_number"=>$reportNumber,
						"access_key"=>$access_key,
						"ashram_id"=>$this->input->post("ashram_id"),
						"seva_type"=>$this->input->post("seva_type"),
						"item_ids_string"=>$postedItemIds,
						"item_names_string"=>$itemNameString,
						"report_url"=>$report_url,
						"report_key"=>$enc_reportNumber,
						"report_end_time"=>date("Y-m-d 23:59:59",strtotime($this->input->post("access_validity"))),
						"status"=>1,
						"created_on"=>date("Y-m-d H:i:s")
								);
					$success = $this->sevas_report_access_users_model->save($saveData);
					if($success)
					{
						$data['flag']=1;
					}
				}
			}
			//Subscriptions
			if($this->input->post("seva_type") == 4)
			{
				if(count($itemsArray)==0)
				{
					$itemNameString.= "<li>All Subscriptions</li>";
				}
				else
				{
					foreach ($itemsArray as $subId)
					{
						$subscriptionData=$this->subscriptions_model->subscriptionData($subId);
						if(empty($subscriptionData))
							goto end;

						$itemNameString.= "<li>".$subscriptionData->subscription_name."</li>";
					}
				}
				$itemNameString.="</ul>";
				foreach($users as $value)
				{
					$userData = $this->users_model->userData($value);
					if($userData->roles <= 0)
					{
						goto end;
					}
					$access_key = substr(md5(time().mt_rand().mt_rand()), 0, 18);
					$report_url = base_url."sevas/subscription_reports?access_key=".$access_key;
					
					$saveData = array(
						"user_id"=>$value,
						"user_name"=>$userData->username,
						"role"=>$userData->roles,
						"report_id"=>$reportId,
						"report_number"=>$reportNumber,
						"access_key"=>$access_key,
						"currency"=>$currencies_str,
						"ashram_id"=>$this->input->post("ashram_id"),
						"seva_type"=>$this->input->post("seva_type"),
						"item_ids_string"=>$postedItemIds,
						"item_names_string"=>$itemNameString,
						"report_url"=>$report_url,
						"report_key"=>$enc_reportNumber,
						"report_end_time"=>date("Y-m-d 23:59:59",strtotime($this->input->post("access_validity"))),
						"status"=>1,
						"created_on"=>date("Y-m-d H:i:s")
								);
					$success = $this->sevas_report_access_users_model->save($saveData);
					if($success)
					{
						$data['flag']=1;
					}
				}
			}
		}
		end:
		echo json_encode($data);
	}

	public function pooja_reports()
	{
		if(empty($_GET) || empty($_GET["access_key"]))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		else
		{
			$ulrValidation = $this->validateReportUrl($_GET);
			if($ulrValidation == "0")
			{
				$data['views'] = array('common/public/error');
				$this->load->view(FRONTEND_TEMPLATE,$data);
				return true;
			}
		}
		$views = array( 'sevas/admin/list_poojas' );
		$reportData = $this->sevas_report_access_users_model->getReportDataByAccessKey($_GET["access_key"]);
		if(empty($reportData))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$ashramData=$this->ashrams_model->ashramData($reportData->ashram_id);
		$data = array('views'=>$views,"ashram_name"=>$ashramData->name);
		$data['reportData'] = $reportData;
		if($reportData->item_ids_string=='all')
		{
			$data['permitted_item_names'] = "All Poojas";
			$data['poojas']=$this->poojas_model->getByAshramId($reportData->ashram_id);
		}
		else
		{
			$data['permitted_item_names'] = $this->getItemString($reportData->seva_type,$reportData->item_ids_string);
			$data['poojas']=$this->poojas_model->getmultiPoojas(explode(",",$reportData->item_ids_string));
		}
		$this->load->view(ACCESS_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Pooja Sevas Listing");
	}

	public function donation_reports()
	{
		
		if(empty($_GET) || empty($_GET["access_key"]))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		else
		{
			$ulrValidation = $this->validateReportUrl($_GET);
			if($ulrValidation == "0")
			{
				$data['views'] = array('common/public/error');
				$this->load->view(FRONTEND_TEMPLATE,$data);
				return true;
			}
		}
		$views = array( 'sevas/admin/list_donations' );
		$reportData = $this->sevas_report_access_users_model->getReportDataByAccessKey($_GET["access_key"]);
		if(empty($reportData))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$ashramData=$this->ashrams_model->ashramData($reportData->ashram_id);
		$data = array('views'=>$views,"ashram_name"=>$ashramData->name);
		$data['reportData'] = $reportData;
		if($reportData->item_ids_string=='all')
		{
			$data['permitted_item_names'] = "All Donations";
			$data['donations']=$this->donations_model->getByAshramId($reportData->ashram_id);
		}
		else
		{
			$data['permitted_item_names'] = $this->getItemString($reportData->seva_type,$reportData->item_ids_string);
			$data['donations']=$this->donations_model->getmultiDonations(explode(",",$reportData->item_ids_string));
		}
		$this->load->view(ACCESS_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Donation Sevas Listing");
	}

	public function store_reports()
	{
		if(empty($_GET) || empty($_GET["access_key"]))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		else
		{
			$ulrValidation = $this->validateReportUrl($_GET);
			if($ulrValidation == "0")
			{
				$data['views'] = array('common/public/error');
				$this->load->view(FRONTEND_TEMPLATE,$data);
				return true;
			}
		}
		$views = array( 'sevas/admin/list_store' );
		$reportData = $this->sevas_report_access_users_model->getReportDataByAccessKey($_GET["access_key"]);
		if(empty($reportData))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$ashramData=$this->ashrams_model->ashramData($reportData->ashram_id);
		$data = array('views'=>$views,"ashram_name"=>$ashramData->name);
		$data['reportData'] = $reportData;
		if($reportData->item_ids_string=='all')
		{
			$data['permitted_item_names'] = "All Store Items";
			$data['items']=$this->store_model->getByAshramId($reportData->ashram_id);
		}
		else
		{
			$data['permitted_item_names'] = $this->getItemString($reportData->seva_type,$reportData->item_ids_string);
			$data['items']=$this->store_model->getmultistoreItems(explode(",",$reportData->item_ids_string));
		}
		$this->load->view(ACCESS_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed store Orders Listing");
	}

	public function subscription_reports()
	{
		if(is_single_currency_site)
        { 
            $_GET["currency"] = default_currency;
        }
		if(empty($_GET) || empty($_GET["access_key"]))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		else
		{
			$ulrValidation = $this->validateReportUrl($_GET);
			if($ulrValidation == "0")
			{
				$data['views'] = array('common/public/error');
				$this->load->view(FRONTEND_TEMPLATE,$data);
				return true;
			}
		}
		$views = array( 'sevas/admin/list_subscriptions' );
		$reportData = $this->sevas_report_access_users_model->getReportDataByAccessKey($_GET["access_key"]);
		if(empty($reportData))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$ashramData=$this->ashrams_model->ashramData($reportData->ashram_id);
		$data = array('views'=>$views,"ashram_name"=>$ashramData->name);
		$data['reportData'] = $reportData;
		if($reportData->item_ids_string=='all')
		{
			$data['permitted_item_names'] = "All Subscriptions";
			$data['subscriptions']=$this->subscriptions_model->getByAshramId($reportData->ashram_id);
		}
		else
		{
			$data['permitted_item_names'] = $this->getItemString($reportData->seva_type,$reportData->item_ids_string);
			$data['subscriptions']=$this->subscriptions_model->getmultiSubscriptions(explode(",",$reportData->item_ids_string));
		}
		$this->load->view(ACCESS_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Subscriptions Sevas Listing");
	}

	public function listp($excel=0)
	{
		$list=$this->sevas_model->listAdminPoojas($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Pooja Sevas Listing ajax request");
	}
	public function listd($excel=0)
	{
		$list=$this->sevas_model->listAdminDonations($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Donation Sevas Listing ajax request");
	}
	public function lists($excel=0)
	{
		$list=$this->sevas_model->listAdminStore($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Store Orders Listing ajax request");
	}

	public function listsubs($excel=0)
	{
		$list=$this->sevas_model->listAdminSubscriptions($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Subscriptions Sevas Listing ajax request");
	}

	public function validateReportUrl($data)
	{
		$reportData = $this->sevas_report_access_users_model->getReportDataByAccessKey($data["access_key"]);
		if(empty($reportData))
		{
			return "0";
		}
		$method=$this->uri->segment(2);
		if(time() > strtotime($reportData->report_end_time))
		{
			$this->sevas_report_access_users_model->updateExpireFlag($reportData->id);
			return "0";
		}
		if(in_array($method,array("pooja_reports","donation_reports","store_reports","subscription_reports")))
		{
			if($reportData->seva_type == 1 && $method != "pooja_reports")
				return "0";

			if($reportData->seva_type == 2 && $method != "donation_reports")
				return "0";

			if($reportData->seva_type == 3 && $method != "store_reports")
				return "0";

			if($reportData->seva_type == 4 && $method != "subscription_reports")
				return "0";
		}
		else
		{
			return "0";
		}
		if($this->currentUser->roles != 1)
		{
			if($reportData->user_id != $this->currentUser->id)
			{
				return "0";
			}
			$this->sevas_report_access_users_model->updateAccessLogs($reportData->id,$reportData->hits);
		}
	}

	public function download($downloadId=0)
	{
		$flag=0;
		if(is_numeric($downloadId) && $downloadId)
		{
			$reportData=$this->excel_exports_model->getRequestById($downloadId);
			if(empty($reportData))
			{
				goto end;
			}
			if($reportData->user_id==$this->currentUser->id)
			{
				header("Cache-Control: public");
		        header("Content-Disposition: attachment; filename=".$reportData->filename);
				readfile(excel_reports_path.$reportData->filename);
				return;
			}
		}
		end:
		if($flag==0)
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	public function transactionmisseddatacheck()
	{
		$views = array( 'orders/admin/transactionmisseddatacheck' );
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed transaction missed data check");
	}


	public function listMissedTransactionsData($excel=0)
	{
		$list=$this->sevas_model->listMissedTransactionsData($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Missed Transactions Data Listing ajax request");
	}

	public function ordermisseddatacheck()
	{
		$views = array( 'orders/admin/ordermisseddatacheck' );
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed transaction missed data check");
	}


	public function listMissedOrdersData($excel=0)
	{
		$list=$this->sevas_model->listMissedOrdersData($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Missed Orders Data Listing ajax request");
	}

	public function validateSevaKartaReportUrl($data)
	{
		$reportData = $this->sevas_report_access_users_model->getReportDataByAccessKeyAshramIdSevaType($data["access_key"],$data["ashram_id"],$data["seva_type"]);
		
		if(empty($reportData))
		{
			return "0";
		}
		$method=$this->uri->segment(2);
		if($data["currency"] !="all")
		{
			$currencies = explode(",", $data["currency"]);
			foreach ($currencies as $key => $value) 
			{
				$currencies = $this->currencies_model->getByAshram($data["ashram_id"],$value);
				if(empty($currencies))
					return "0";
			}
		}

		if(time() > strtotime($reportData->report_end_time))
		{
			$this->sevas_report_access_users_model->updateExpireFlag($reportData->id);
			return "0";
		}

		if($reportData->seva_type != $data["seva_type"])
		{
			return "0";
		}

		if($reportData->item_ids_string!='all')
		{
			if($data["items"] == 'all')
			{
				return "0";
			}

			$reportItemTds = explode(",", $reportData->item_ids_string);
			$itemTds = explode(",", $data["items"]);
			foreach($itemTds as $thisItem)
			{
				if(!in_array($thisItem, $reportItemTds))
				{
					return "0";
				}
			}
		}

		if(in_array($method,array("poojas_seva_karta_report","donations_seva_karta_report","store_seva_karta_report","subscriptions_seva_karta_report")))
		{
			if($reportData->seva_type == 1 && $method != "poojas_seva_karta_report")
				return "0";

			if($reportData->seva_type == 2 && $method != "donations_seva_karta_report")
				return "0";

			if($reportData->seva_type == 3 && $method != "store_seva_karta_report")
				return "0";

			if($reportData->seva_type == 4 && $method != "subscriptions_seva_karta_report")
				return "0";
		}
		else
		{
			return "0";
		}
	}

	public function validateSevaKartaPdfReportUrl($data)
	{
		$reportData = $this->sevas_report_access_users_model->getReportDataByAccessKeyAshramIdSevaType($data["access_key"],$data["ashram_id"],$data["seva_type"]);
		if(empty($reportData))
		{
			return "0";
		}
		$method=$this->uri->segment(2);
		if($data["currency"] !="all")
		{
			$currencies = explode(",", $data["currency"]);
			foreach ($currencies as $key => $value) 
			{
				$currencies = $this->currencies_model->getByAshram($data["ashram_id"],$value);
				if(empty($currencies))
					return "0";
			}
		}

		if(time() > strtotime($reportData->report_end_time))
		{
			$this->sevas_report_access_users_model->updateExpireFlag($reportData->id);
			return "0";
		}

		if($reportData->seva_type != $data["seva_type"])
		{
			return "0";
		}

		if($reportData->item_ids_string!='all')
		{
			if($data["items"] == 'all')
			{
				return "0";
			}

			$reportItemTds = explode(",", $reportData->item_ids_string);
			$itemTds = explode(",", $data["items"]);
			foreach($itemTds as $thisItem)
			{
				if(!in_array($thisItem, $reportItemTds))
				{
					return "0";
				}
			}
		}

		if(in_array($method,array("poojas_seva_karta_pdf_report","donations_seva_karta_pdf_report","store_seva_karta_pdf_report","subscriptions_seva_karta_pdf_report")))
		{
			if($reportData->seva_type == 1 && $method != "poojas_seva_karta_pdf_report")
				return "0";

			if($reportData->seva_type == 2 && $method != "donations_seva_karta_pdf_report")
				return "0";

			if($reportData->seva_type == 3 && $method != "store_seva_karta_pdf_report")
				return "0";

			if($reportData->seva_type == 4 && $method != "subscriptions_seva_karta_pdf_report")
				return "0";
		}
		else
		{
			return "0";
		}
	}

	public function poojas_seva_karta_report()
	{
		if(is_single_currency_site)
        { 
            $_GET["currency"] = default_currency;
        }
        if(empty($_GET) || empty($_GET["ashram_id"]) || empty($_GET["currency"]) || empty($_GET["pooja_id"]) || empty($_GET["access_key"]))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$reportData = $this->sevas_report_access_users_model->getReportDataByAccessKey($_GET["access_key"]);
		if(empty($reportData))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$_GET["items"] = $_GET["pooja_id"];
		$_GET["seva_type"] = 1;
		$ulrValidation = $this->validateSevaKartaReportUrl($_GET);
		if($ulrValidation == "0")
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$reports=$this->sevas_model->listAdminPoojasSevaKarta();
		$views = array( 'sevas/admin/poojas_seva_karta_report');
		$data = array('views'=>$views,'reports'=>$reports);
		$this->load->view(ACCESS_TEMPLATE,$data);
	}

	public function poojas_seva_karta_pdf_report()
	{
		if(is_single_currency_site)
        { 
            $_GET["currency"] = default_currency;
        }
		if(empty($_GET) || empty($_GET["ashram_id"]) || empty($_GET["currency"]) || empty($_GET["pooja_id"]) || empty($_GET["access_key"]))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$reportData = $this->sevas_report_access_users_model->getReportDataByAccessKey($_GET["access_key"]);
		if(empty($reportData))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$_GET["items"] = $_GET["pooja_id"];
		$_GET["seva_type"] = 1;
		$ulrValidation = $this->validateSevaKartaPdfReportUrl($_GET);
		if($ulrValidation == "0")
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$reports=$this->sevas_model->listAdminPoojasSevaKarta();
		$data = array('reports'=>$reports);
		$this->load->view('sevas/admin/poojas_seva_karta_pdf_report',$data);
	}

	public function donations_seva_karta_report()
	{
		if(is_single_currency_site)
        { 
            $_GET["currency"] = default_currency;
        }
		if(empty($_GET) || empty($_GET["ashram_id"]) || empty($_GET["currency"]) || empty($_GET["donation_id"]) || empty($_GET["access_key"]))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$reportData = $this->sevas_report_access_users_model->getReportDataByAccessKey($_GET["access_key"]);
		if(empty($reportData))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$_GET["items"] = $_GET["donation_id"];
		$_GET["seva_type"] = 2;
		$ulrValidation = $this->validateSevaKartaReportUrl($_GET);
		if($ulrValidation == "0")
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$reports=$this->sevas_model->listAdminDonationsSevaKarta();
		$views = array( 'sevas/admin/donations_seva_karta_report');
		$data = array('views'=>$views,'reports'=>$reports);
		$this->load->view(ACCESS_TEMPLATE,$data);
	}

	public function donations_seva_karta_pdf_report()
	{
		if(is_single_currency_site)
        { 
            $_GET["currency"] = default_currency;
        }
		if(empty($_GET) || empty($_GET["ashram_id"]) || empty($_GET["currency"]) || empty($_GET["donation_id"]) || empty($_GET["access_key"]))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$reportData = $this->sevas_report_access_users_model->getReportDataByAccessKey($_GET["access_key"]);
		if(empty($reportData))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$_GET["items"] = $_GET["donation_id"];
		$_GET["seva_type"] = 2;
		$ulrValidation = $this->validateSevaKartaPdfReportUrl($_GET);
		if($ulrValidation == "0")
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$reports=$this->sevas_model->listAdminDonationsSevaKarta();
		$data = array('reports'=>$reports);
		$this->load->view('sevas/admin/donations_seva_karta_pdf_report',$data);
	}

	public function subscriptions_seva_karta_report()
	{
		if(is_single_currency_site)
        { 
            $_GET["currency"] = default_currency;
        }
		if(empty($_GET) || empty($_GET["ashram_id"]) || empty($_GET["currency"]) || empty($_GET["subscription_id"]) || empty($_GET["access_key"]))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$reportData = $this->sevas_report_access_users_model->getReportDataByAccessKey($_GET["access_key"]);
		if(empty($reportData))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$_GET["items"] = $_GET["subscription_id"];
		$_GET["seva_type"] = 4;
		$ulrValidation = $this->validateSevaKartaReportUrl($_GET);
		if($ulrValidation == "0")
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$reports=$this->sevas_model->listAdminSubscriptionsSevaKarta();
		$views = array( 'sevas/admin/subscriptions_seva_karta_report');
		$data = array('views'=>$views,'reports'=>$reports);
		$this->load->view(ACCESS_TEMPLATE,$data);
	}

	public function subscriptions_seva_karta_pdf_report()
	{
		if(is_single_currency_site)
        { 
            $_GET["currency"] = default_currency;
        }
		if(empty($_GET) || empty($_GET["ashram_id"]) || empty($_GET["currency"]) || empty($_GET["subscription_id"]) || empty($_GET["access_key"]))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$reportData = $this->sevas_report_access_users_model->getReportDataByAccessKey($_GET["access_key"]);
		if(empty($reportData))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$_GET["items"] = $_GET["subscription_id"];
		$_GET["seva_type"] = 4;
		$ulrValidation = $this->validateSevaKartaPdfReportUrl($_GET);
		if($ulrValidation == "0")
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$reports=$this->sevas_model->listAdminSubscriptionsSevaKarta();
		$data = array('reports'=>$reports);
		$this->load->view('sevas/admin/subscriptions_seva_karta_pdf_report',$data);
	}

	public function poojas_prasadam()
	{
		if(is_single_currency_site)
        { 
            $_GET["currency"] = default_currency;
        }
		if(empty($_GET) || empty($_GET["ashram_id"]) || empty($_GET["currency"]) || empty($_GET["pooja_id"]) || empty($_GET["access_key"]))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$reportData = $this->sevas_report_access_users_model->getReportDataByAccessKey($_GET["access_key"]);
		if(empty($reportData))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$ulrValidation = 1;
		$_GET["items"] = $_GET["pooja_id"];
		$reportData = $this->sevas_report_access_users_model->getReportDataByAccessKeyAshramIdSevaType($_GET["access_key"],$_GET["ashram_id"],$_GET["seva_type"]);
	
		if(empty($reportData))
		{
			$ulrValidation = "0";
			goto endstep;
		}
		$method=$this->uri->segment(2);
		if($_GET["currency"] !="all")
		{
			$currencies = explode(",", $_GET["currency"]);
			foreach ($currencies as $key => $value) 
			{
				$currencies = $this->currencies_model->getByAshram($_GET["ashram_id"],$value);
				if(empty($currencies))
				{
					$ulrValidation = "0";
					goto endstep;
				}
			}
		}

		if(time() > strtotime($reportData->report_end_time))
		{
			$this->sevas_report_access_users_model->updateExpireFlag($reportData->id);
			$ulrValidation = "0";
			goto endstep;
		}

		if($reportData->seva_type != $_GET["seva_type"])
		{
			$ulrValidation = "0";
			goto endstep;
		}

		if($reportData->item_ids_string!='all')
		{
			if($_GET["items"] == 'all')
			{
				$ulrValidation = "0";
				goto endstep;
			}

			$reportItemTds = explode(",", $reportData->item_ids_string);
			$itemTds = explode(",", $_GET["items"]);
			foreach($itemTds as $thisItem)
			{
				if(!in_array($thisItem, $reportItemTds))
				{
					$ulrValidation = "0";
					goto endstep;
				}
			}
		}
		if($reportData->seva_type == 1 && $method != "poojas_prasadam")
			$ulrValidation = "0";

		endstep:
		if($ulrValidation == "0")
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$views = array( 'sevas/admin/list_poojas_prasadam' );
		$data = array('views'=>$views);
		
		if($_GET["ashram_id"])
		{
			$data['poojas'] = $this->poojas_model->getByAshramId($_GET["ashram_id"]);
			$data['ashramData'] = $this->ashrams_model->ashramData($_GET["ashram_id"]);
			if($_GET["items"]=='all')
			{
				$data['permitted_item_names'] = "All Poojas";
			}
			else
			{
				$data['permitted_item_names'] = $this->getItemString($_GET["seva_type"],$_GET["items"]);
			}
		}
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ACCESS_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Poojas prasadam report");
	}

	public function listpreport($excel=0)
	{
		$list=$this->sevas_model->listAdminPoojasPrasadam($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Poojas prasadam report ajax request");
	}

	public function poorna_phala_pooja_orders()
	{
		if(is_single_currency_site)
        { 
            $_GET["currency"] = default_currency;
        }
		if(empty($_GET) || empty($_GET["ashram_id"]) || empty($_GET["currency"]) || empty($_GET["pooja_id"]) || empty($_GET["access_key"]))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$reportData = $this->sevas_report_access_users_model->getReportDataByAccessKey($_GET["access_key"]);
		if(empty($reportData))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$ulrValidation = 1;
		$_GET["items"] = $_GET["pooja_id"];
		$reportData = $this->sevas_report_access_users_model->getReportDataByAccessKeyAshramIdSevaType($_GET["access_key"],$_GET["ashram_id"],$_GET["seva_type"]);
	
		if(empty($reportData))
		{
			$ulrValidation = "0";
			goto endstep;
		}
		$method=$this->uri->segment(2);
		if($_GET["currency"] !="all")
		{
			$currencies = explode(",", $_GET["currency"]);
			foreach ($currencies as $key => $value) 
			{
				$currencies = $this->currencies_model->getByAshram($_GET["ashram_id"],$value);
				if(empty($currencies))
				{
					$ulrValidation = "0";
					goto endstep;
				}
			}
		}

		if(time() > strtotime($reportData->report_end_time))
		{
			$this->sevas_report_access_users_model->updateExpireFlag($reportData->id);
			$ulrValidation = "0";
			goto endstep;
		}

		if($reportData->seva_type != $_GET["seva_type"])
		{
			$ulrValidation = "0";
			goto endstep;
		}

		if($reportData->item_ids_string!='all')
		{
			if($_GET["items"] == 'all')
			{
				$ulrValidation = "0";
				goto endstep;
			}

			$reportItemTds = explode(",", $reportData->item_ids_string);
			$itemTds = explode(",", $_GET["items"]);
			foreach($itemTds as $thisItem)
			{
				if(!in_array($thisItem, $reportItemTds))
				{
					$ulrValidation = "0";
					goto endstep;
				}
			}
		}
		if($reportData->seva_type == 1 && $method != "poorna_phala_pooja_orders")
			$ulrValidation = "0";

		endstep:
		if($ulrValidation == "0")
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return true;
		}
		$views = array( 'sevas/admin/list_poorna_phala_pooja_orders' );
		$data = array('views'=>$views);
		
		if($_GET["ashram_id"])
		{
			$data['poojas'] = $this->poojas_model->getPoornaPhalaPoojasByAshramId($_GET["ashram_id"]);
			$data['ashramData'] = $this->ashrams_model->ashramData($_GET["ashram_id"]);
			if($_GET["items"]=='all')
			{
				$data['permitted_item_names'] = "All Poojas";
			}
			else
			{
				$data['permitted_item_names'] = $this->getItemString($_GET["seva_type"],$_GET["items"]);
			}
		}
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ACCESS_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Poornaphala report");
	}

	public function listPoornaPhalaReport($excel=0)
	{
		$list=$this->sevas_model->listAdminPoornaPhalaPoojaOrders($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Poorna Phala Poojas report ajax request");
	}

}