<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Search extends CI_Controller 
{
	function __construct()
	{
        parent::__construct();
        if($this->session->userdata('id'))
        	$this->currentUser=$this->session->userdata("admin_data");
       	else
       		$this->currentUser=$this->session->userdata("user_data");

       	$this->load->model('content/pages_model');
       	$this->load->model('content/events_model');
       	$this->load->model('content/speeches_model');
       	// $this->load->model('content/articles_model');
       	$this->load->model('content/dailyposts_model');
       	$this->load->model('content/dailypost_types_model');
       	$this->load->model('ashrams/poojas_model');
       	$this->load->model('ashrams/donations_model');
       	$this->load->model('ashrams/subscriptions_model');
       	$this->load->model('ashrams/store_model');
       	$this->load->model('content/bhajans_model');
       	$this->load->model('content/calendar_model');
       	$this->load->model('content/ashramcenters_model');
       	$this->load->model('quick_links_model');
    }
	public function index()
	{
		$search_type_arr = ['pages','events','sri_swamiji_says','speeches','articles','poojas','donations','subscriptions','store_items','calendar','bhajans','ashram_centers','quick_links'];
		if((isset($_GET['search_type']) && !in_array($_GET['search_type'], $search_type_arr)))
		{
			if(isset($_GET['search_text']) && $_GET['search_text']!='')
			{
				redirect('search?search_text='.$_GET['search_text']);
			}
			else
			{
				redirect('search');
			}
		}
		$data['views'] = array('common/public/search');
		$this->load->view(FRONTEND_TEMPLATE,$data);
	}
	public function listresults()
	{
		$listPages=$this->pages_model->listPublicByCategory(0);
		$listEvents=$this->events_model->listPublicSearchEvents();
		$listDailyPosts=$this->dailyposts_model->listPublicDt();
		$listSpeeches=$this->speeches_model->listPublicByCategory(0);
		// $listArticles=$this->articles_model->listPublicByCategory(0);
		$listPoojas=$this->poojas_model->listPublicSearchPoojas();
		$listDonations=$this->donations_model->listPublicSearchDonations();
		$listSubscriptions=$this->subscriptions_model->listPublicSearchSubscriptions();
		$listStoreItems=$this->store_model->listPublicSearchStoreItems();
		$listBhajans=$this->bhajans_model->listPublicSearchBhajans();
		$listCalendars=$this->calendar_model->listPublicSearchCalendars();
		$listAshramcenters=$this->ashramcenters_model->listPublicSearchAshramcenters();
		$listQuickLinks=$this->quick_links_model->listPublicSearchQuickLinks();
		if(isset($_POST['search_type']) && $_POST['search_type']=='pages')
		{
			$list=$listPages;
		}
		if(isset($_POST['search_type']) && $_POST['search_type']=='events')
		{
			$list=$listEvents;
		}
		if(isset($_POST['search_type']) && $_POST['search_type']=='sri_swamiji_says')
		{
			$list=$listDailyPosts;
		}
		if(isset($_POST['search_type']) && $_POST['search_type']=='speeches')
		{
			$list=$listSpeeches;
		}
		// if(isset($_POST['search_type']) && $_POST['search_type']=='articles')
		// {
		// 	$list=$listArticles;
		// }
		if(isset($_POST['search_type']) && $_POST['search_type']=='poojas')
		{
			$list=$listPoojas;
		}
		if(isset($_POST['search_type']) && $_POST['search_type']=='donations')
		{
			$list=$listDonations;
		}
		if(isset($_POST['search_type']) && $_POST['search_type']=='subscriptions')
		{
			$list=$listSubscriptions;
		}
		if(isset($_POST['search_type']) && $_POST['search_type']=='store_items')
		{
			$list=$listStoreItems;
		}
		if(isset($_POST['search_type']) && $_POST['search_type']=='calendar')
		{
			$list=$listCalendars;
		}
		if(isset($_POST['search_type']) && $_POST['search_type']=='bhajans')
		{
			$list=$listBhajans;
		}
		if(isset($_POST['search_type']) && $_POST['search_type']=='ashram_centers')
		{
			$list=$listAshramcenters;
		}
		if(isset($_POST['search_type']) && $_POST['search_type']=='quick_links')
		{
			$list=$listQuickLinks;
		}
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='')
		{
			$this->search_log_model->log(trim($_POST['search_text']));
		}
		$list['total_pages']=$listPages['recordsTotal'];
		$list['total_events']=$listEvents['recordsTotal'];
		$list['total_posts']=$listDailyPosts['recordsTotal'];
		$list['total_speeches']=$listSpeeches['recordsTotal'];
		// $list['total_articles']=$listArticles['recordsTotal'];
		$list['total_poojas']=$listPoojas['recordsTotal'];
		$list['total_donations']=$listDonations['recordsTotal'];
		$list['total_subscriptions']=$listSubscriptions['recordsTotal'];
		$list['total_store_items']=$listStoreItems['recordsTotal'];
		$list['total_bhajans']=$listBhajans['recordsTotal'];
		$list['total_calendars']=$listCalendars['recordsTotal'];
		$list['total_ashramcenters']=$listAshramcenters['recordsTotal'];
		$list['total_quick_links']=$listQuickLinks['recordsTotal'];
		echo json_encode($list);
	}
}
?>