<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Satsangsadmin extends CI_Controller 
{
	var $service='satsangs';
    function __construct() 
	{
        parent::__construct();
		$this->load->model('satsangs/satsangs_model');
		$this->load->model('satsangs/satsang_members_model');
		$this->load->model('satsangs/satsang_newsletters_model');
		$this->load->model("satsangs/satsang_newsletter_images_model");
		$this->load->model("satsangs/newsletters_que_model");
		$this->load->model("satsangs/satsang_calendar_model");
		$this->load->model('satsangs/satsangpage_images_model');
		
		$this->currentUser=$this->session->userdata("admin_data");
    }
	public function index()
	{
		$views = array( 'satsangs/admin/list' );
		$data = array('views'=>$views);
		$data['satsangs_countries']=$this->satsangs_model->getCountries();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Satsangs Listing");
	}

	public function listc($excel=0)
	{
		$list=$this->satsangs_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Satsangs Listing ajax request");
	}
	
	public function add_edit_satsang($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$satsangData=$this->satsangs_model->satsangData($id);
			if(empty($satsangData))
			{
				$this->session->set_flashdata("satsang_error",1);
				redirect('satsangsadmin');
			}
		}
		else
		{
			$satsangData=array();
		}

		if(isset($_POST["name"]))
		{
			if(!isset($_POST['description']))
			{
				$this->session->set_flashdata("satsang_error",1);
				redirect('satsangsadmin/add_edit_satsang/'.$id);
			}

			$this->form_validation->set_rules('name', 'Satsang Name', 'trim|required|min_length[6]|max_length[100]|checkSatsangName['.$id.']');
			$this->form_validation->set_rules('address', 'Address', 'trim|required|min_length[6]|max_length[500]');
			$this->form_validation->set_rules('country_id', 'Country', 'trim|required|checkCountry');
			$this->form_validation->set_rules('state_name', 'State', 'trim|required|min_length[2]|max_length[100]');
			$this->form_validation->set_rules('city', 'City', 'trim|required|min_length[2]|max_length[100]');
			$this->form_validation->set_rules('contact_person', 'Contact Person', 'trim|required|min_length[3]|max_length[100]');
			$this->form_validation->set_rules('contact_phone', 'Contact Phone', 'trim|required|min_length[8]|max_length[100]');
			$this->form_validation->set_rules('contact_email', 'Contact Email', 'trim|required|min_length[6]|max_length[100]|valid_email_custom');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("satsang_error",1);
				redirect('satsangsadmin/add_edit_satsang/'.$id);
				return;
			}
			$this->load->model("user/users_model");
			$saved=$this->satsangs_model->save($id,$satsangData);
			if($id==0)
			{
				$this->session->set_flashdata("satsang_created",1);
			}
			else
				$this->session->set_flashdata("satsang_saved",1);
			redirect('satsangsadmin/add_edit_satsang/'.$saved);
			
		}
		else
		{
			if($id!='' && (empty($satsangData)) )
			{
				redirect('satsangsadmin');
			}
			$views = array('satsangs/admin/add_edit_satsang');
			$data = array('views'=>$views,'id'=>$id);
			$data['countries']=$this->locations_model->getCountries();
			if(is_numeric($id) && $id)
			{
				$data['satsangData']=$satsangData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data); 
		}
	}

	/*public function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$satsangData=$this->satsangs_model->satsangData($id);
			if(empty($satsangData))
			{
				goto end;
			}
			$this->load->model("user/users_model");
			$r=$this->satsangs_model->delete($id,$satsangData);
			if($r)
			{
				$data['flag']=1;
				$data['name']=$satsangData->name;
				$this->logaction->log($this->service,"Admin - Satsang '".$satsangData->name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}*/

	public function switchsatsang($satsangId=0)
	{
		if(is_numeric($satsangId))
			$this->session->set_userdata("satsangId",$satsangId);
	}

	public function members()
	{
		$views = array( 'satsangs/admin/list_members' );
		$data = array('views'=>$views);
		$data['satsangs']=$this->satsangs_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Satsang Members Listing");
	}
	public function listm($excel=0)
	{
		if($this->session->userdata("satsangId"))
		{
			$list=$this->satsang_members_model->listAdmin($excel);
			echo json_encode($list);
			$this->logaction->log($this->service,"Admin - Viewed Satsangs Members Listing ajax request");
		}
	}
	public function add_members()
	{
		$this->load->model('user/users_model');
		$views = array( 'satsangs/admin/add_members' );
		$data = array('views'=>$views);
		$data['satsangs']=$this->satsangs_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Add Satsang Members Page");
	}
	public function memberadd()
	{
		if(!$this->session->userdata("satsangId"))
		{
			redirect("satsangsadmin/members");
		}
		if(isset($_POST['invite_button']))
		{
			$this->load->model('user/users_model');

			$this->form_validation->set_rules('emailids[]', 'Email ID', 'trim|required|min_length[6]|max_length[200]|valid_email_custom');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("satsang_error",1);
				redirect('satsangsadmin/add_members');
				return;
			}

			$satsangData=$this->satsangs_model->satsangData($this->session->userdata("satsangId"));
			$cnt=0;
			$fail=0;
			$skipped=0;
			foreach($_POST['emailids'] as $email)
			{
				$tempUser=$this->users_model->userDataByEmail($email);
				if(empty($tempUser))
				{
					$skipped++;
					continue;
				}
				if($tempUser->email_verified==0 || $tempUser->status==0 || $tempUser->deleted==1)
				{
					$skipped++;
					continue;
				}
				$memberData=$this->satsang_members_model->getMember($this->session->userdata("satsangId"),$tempUser->id);
				if(!empty($memberData))
				{
					$skipped++;
					continue;
				}

				$subject="You are invited to join ".$satsangData->name;
				$emailData['satsangData']=$satsangData;
				$content=$this->load->view("satsangs/admin/_email_invite",$emailData,true);
				$this->email_extension->sendMail("satsang_".$satsangData->id,$tempUser->id,$subject,$content,1);

				$this->satsang_members_model->addMember($this->session->userdata("satsangId"),$tempUser->id);

				$cnt++;
			}
			
			$this->session->set_flashdata("invites_skipped",$skipped);
			$this->session->set_flashdata("invites_sent",$cnt);
			$this->session->set_flashdata("invites_fail",$fail);
			$this->session->set_flashdata("invites_status",1);
			redirect("satsangsadmin/add_members");
		}
	}

	public function accept_member($memberId=0)
	{
		$data['flag']=0;
		if(is_numeric($memberId) && $memberId)
		{
			if(!$this->session->userdata("satsangId"))
			{
				goto end;
			}
			$memberData=$this->satsang_members_model->getMemberById($memberId);
			if(empty($memberData))
			{
				goto end;
			}
			if($memberData->satsang_id!=$this->session->userdata("satsangId"))
			{
				goto end;
			}
			$this->load->model('user/users_model');
			$userData=$this->users_model->userData($memberData->user_id);
			$this->satsang_members_model->acceptInvite($this->session->userdata("satsangId"),$memberData->user_id);
			$data['flag']=1;
			$data['name']=$userData->firstname." ".$userData->lastname;

		}
		end:
		echo json_encode($data);
	}

	public function delete_member($memberId=0)
	{
		$data['flag']=0;
		if(is_numeric($memberId) && $memberId)
		{
			if(!$this->session->userdata("satsangId"))
			{
				goto end;
			}
			$memberData=$this->satsang_members_model->getMemberById($memberId);
			if(empty($memberData))
			{
				goto end;
			}
			if($memberData->satsang_id!=$this->session->userdata("satsangId"))
			{
				goto end;
			}
			$this->load->model('user/users_model');
			$userData=$this->users_model->userData($memberData->user_id);
			$this->satsang_members_model->deleteMember($memberData,$userData);
			$data['flag']=1;
			$data['name']=$userData->firstname." ".$userData->lastname;

		}
		end:
		echo json_encode($data);
	}

	//============================NEWSLETTERS===========================

	public function newsletters()
	{
		$views = array( 'satsangs/admin/list_newsletters' );
		$data = array('views'=>$views);
		$data['satsangs']=$this->satsangs_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"User - Viewed newsletters page");
	}
	public function listn($excel=0)
	{
		$list=$this->satsang_newsletters_model->listNewsletters($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"User - Viewed newsletters ajax request");
	}

	public function add_edit_newsletter($id=0)
	{
		if(!$this->session->userdata("satsangId"))
		{
			redirect("satsangsadmin/newsletters");
		}
		if(isset($_POST["add_newsletter"]) || isset($_POST["send_newsletter"]))
		{

			if(!isset($_POST['country']) || !isset($_POST['content']) || !isset($_POST['age_from']) || !isset($_POST['age_to']))
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect('satsangsadmin/add_edit_newsletter/'.$id);
			}
			$this->form_validation->set_rules('subject', 'Newsletter Subject', 'trim|required|min_length[6]|max_length[200]');

			$this->form_validation->set_rules('age_from', 'By Age', 'trim|numeric|checkAgeLimit|newsletterAgeFilter');
			$this->form_validation->set_rules('age_to', 'By Age', 'trim|numeric|checkAgeLimit|newsletterAgeFilter');

			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect('satsangsadmin/add_edit_newsletter/'.$id);
				return;
			}
			if($id)
			{
				$newsletterData=$this->satsang_newsletters_model->newsletterData($id);

				if(empty($newsletterData))
				{
					$this->session->set_flashdata("newsletter_error",1);
					redirect("satsangsadmin/newsletters");
				}
				if($newsletterData->satsang_id!=$this->session->userdata("satsangId"))
				{
					$this->session->set_flashdata("newsletter_error",1);
					redirect("satsangsadmin/newsletters");
				}
				if($newsletterData->status!=1)
				{
					$this->session->set_flashdata("newsletter_error",1);
					redirect("satsangsadmin/newsletters");
				}
			}
			$saved=$this->satsang_newsletters_model->save($id);
			
			if($saved)
			{
				if($id)
				{
					$this->session->set_flashdata("newsletter_saved",1);
				}
				else
				{
					$this->session->set_flashdata("newsletter_created",1);
				}
				if(isset($_POST['send_newsletter']))
				{
					$this->satsang_newsletters_model->sendNewsletter($saved);
					redirect('satsangsadmin/view_newsletter/'.$saved);
					return;
				}
			}
			redirect('satsangsadmin/add_edit_newsletter/'.$saved);
		}
		else
		{
		 	$views = array( 'satsangs/admin/add_edit_newsletter' );
		 	$data = array('views'=>$views,'id'=>$id);
		 	$data['countries']=$this->locations_model->getCountries();
		 	if($this->currentUser->roles==1)
        	{
        		$data['satsangs']=$this->satsangs_model->getList();
        	}
		 	$data['satsangData']=$this->satsangs_model->satsangData($this->session->userdata("satsangId"));
			if($id)
			{
				$data['newsletterData']=$this->satsang_newsletters_model->newsletterData($id);
				if(empty($data['newsletterData']))
				{
					$this->session->set_flashdata("newsletter_error",1);
					redirect("satsangsadmin/newsletters");
				}
				if($data['newsletterData']->field_userids!='')
			 	{
			 		$data['users']=$this->users_model->getUsersByIds(explode(",",$data['newsletterData']->field_userids));
			 	}
				if($data['newsletterData']->satsang_id!=$this->session->userdata("satsangId"))
				{
					$this->session->set_flashdata("newsletter_error",1);
					redirect("satsangsadmin/newsletters");
				}
				if($data['newsletterData']->status==2)
				{
					redirect("satsangsadmin/view_newsletter/".$id);
				}
			}
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	public function view_newsletter($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$newsletterData=$this->satsang_newsletters_model->newsletterData($id);
			if(empty($newsletterData))
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect("satsangsadmin/newsletters");
			}
			if($newsletterData->satsang_id!=$this->session->userdata("satsangId"))
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect("satsangsadmin/newsletters");
			}
			if($newsletterData->status!=2)
			{
				redirect("satsangsadmin/add_edit_newsletter/".$id);
			}
		 	$views = array('satsangs/admin/view_newsletter');
		 	$data = array('views'=>$views,'id'=>$id);
		 	if($newsletterData->field_country!='')
		 		$data['countryData']=$this->locations_model->getCountryByCode($newsletterData->field_country);
		 	if($newsletterData->field_userids!='')
		 	{
		 		$data['users']=$this->users_model->getUsersByIds(explode(",",$newsletterData->field_userids));
		 	}
			$data['newsletterData']=$newsletterData;
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
		else
		{
			$this->session->set_flashdata("newsletter_error",1);
			redirect("satsangsadmin");
		}
	}

	public function delete_newsletter($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$newsletterData=$this->satsang_newsletters_model->newsletterData($id);
			if(!empty($newsletterData) && $newsletterData->status==1 && $newsletterData->satsang_id==$this->session->userdata("satsangId"))
			{
				$r=$this->satsang_newsletters_model->delete($id,$newsletterData);
				if($r)
				{
					$data['flag']=1;
					$data['unique_id']=$newsletterData->unique_id;
				}
			}
		}
		echo json_encode($data);
	}

	public function resend($id=0,$qid=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id && is_numeric($qid) && $qid)
		{
			$newsletterData=$this->satsang_newsletters_model->newsletterData($id);
			if(empty($newsletterData))
			{
				goto end;
			}
			if($newsletterData->satsang_id!=$this->session->userdata("satsangId"))
			{
				goto end;
			}
			$mailData=$this->newsletters_que_model->mailData($qid);
			if(empty($mailData) || $mailData->newsletter_id!=$id || $mailData->status==0)
			{
				goto end;
			}
			$r=$this->newsletters_que_model->resend($qid,$mailData);
			if($r)
			{
				$data['flag']=1;
				$data['email']=$mailData->mail_to;
			}
		}
		end:
		echo json_encode($data);
	}

	public function mail_queue($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$views = array( 'satsangs/admin/list_newsletter_queue' );
			$data = array('views'=>$views);
			$newsletterData=$this->satsang_newsletters_model->newsletterData($id);
			if(empty($newsletterData))
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect("satsangsadmin/newsletters");
			}
			if($newsletterData->satsang_id!=$this->session->userdata("satsangId"))
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect("satsangsadmin/newsletters");
			}
			$data['newsletterData']=$newsletterData;
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
		else
		{
			$this->session->set_flashdata("newsletter_error",1);
			redirect('satsangsadmin/newsletters');
		}
	}
	public function listqueue($id=0,$excel=0)
	{
		if(is_numeric($id) && $id)
		{
			$newsletterData=$this->satsang_newsletters_model->newsletterData($id);
			if(empty($newsletterData))
			{
				return;
			}
			if($newsletterData->satsang_id!=$this->session->userdata("satsangId"))
			{
				return;
			}
			$list=$this->newsletters_que_model->listQueue($newsletterData,$excel);
			echo json_encode($list);
		}
	}

	//============================CALENDAR===========================
	public function calendar()
	{
		$views = array( 'satsangs/admin/list_calendar' );
		$data = array('views'=>$views);
		$data['satsangs']=$this->satsangs_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Calendar Listing");
	}

	public function listcalendar($excel=0)
	{
		if($this->session->userdata("satsangId"))
		{
			$list=$this->satsang_calendar_model->listAdmin($excel);
			echo json_encode($list);
			$this->logaction->log($this->service,"Admin - Viewed Calendar Listing ajax request");
		}
	}

	function add_edit_calendar($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$calendarData=$this->satsang_calendar_model->calendarData($id);
			if(empty($calendarData))
			{
				$this->session->set_flashdata("calendar_error",1);
				redirect('satsangsadmin/calendar');
			}
			if($calendarData->satsang_id!=$this->session->userdata("satsangId"))
			{
				$this->session->set_flashdata("calendar_error",1);
				redirect('satsangsadmin/calendar');
			}
		}
		

		if(isset($_POST["save_calendar"]))
		{
			if(!isset($_POST['description']))
			{
				$this->session->set_flashdata("calendar_error",1);
				redirect('satsangsadmin/add_edit_calendar/'.$id);
			}

			$this->form_validation->set_rules('event_name', 'Calendar Event', 'trim|required|min_length[6]|max_length[200]');
			$this->form_validation->set_rules('start_date', 'Start Date', 'trim|required');
			if(isset($_POST['start_date']))
				$this->form_validation->set_rules('end_date', 'End Date', 'trim|required|calendarDateRangeCheck');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("calendar_error",1);
				redirect('satsangsadmin/add_edit_calendar/'.$id);
				return;
			}

			$saved=$this->satsang_calendar_model->save($id);
			if($id==0)
			{
				$this->session->set_flashdata("calendar_created",1);
			}
			else
				$this->session->set_flashdata("calendar_saved",1);
			redirect('satsangsadmin/add_edit_calendar/'.$saved);
			
		}
		else
		{
			if($id!='' && (empty($calendarData)) )
			{
				redirect('satsangsadmin/calendar');
			}
			$views = array('satsangs/admin/add_edit_calendar');
			$data = array('views'=>$views,'id'=>$id);
			if($this->currentUser->roles==1)
        	{
        		$data['satsangs']=$this->satsangs_model->getList();
        	}
			$data['satsangData']=$this->satsangs_model->satsangData($this->session->userdata("satsangId"));
			if(is_numeric($id) && $id)
			{
				$data['calendarData']=$calendarData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data); 
		}
	}

	function delete_calendar($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$calendarData=$this->satsang_calendar_model->calendarData($id);
			if(empty($calendarData))
			{
				goto end;
			}
			if($calendarData->satsang_id!=$this->session->userdata("satsangId"))
			{
				goto end;
			}
			$r=$this->satsang_calendar_model->delete($id);
			if($r)
			{
				$data['flag']=1;
				$data['event_name']=$calendarData->event_name;
				$this->logaction->log($this->service,"Admin - Calendar event '".$calendarData->event_name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}

	public function page()
	{
		$satsangData=array();
		if($this->session->userdata("satsangId"))
		{
			$satsangData=$this->satsangs_model->satsangData($this->session->userdata("satsangId"));
			if(empty($satsangData))
			{
				redirect("satsangsadmin");
			}
		}

		if(isset($_POST['save_page']))	
		{
			if(!isset($_POST['content']))
			{
				redirect("satsangsadmin/page");
			}
			$this->satsangs_model->savePage();
			$this->session->set_flashdata("saved_page",1);
			redirect("satsangsadmin/page");
		}
		else
		{
			$views = array( 'satsangs/admin/page' );
			$data = array('views'=>$views);
			$data['satsangs']=$this->satsangs_model->getList();
			$data['satsangData']=$satsangData;
			$this->load->view(ADMIN_TEMPLATE,$data);
		}

	}

	public function namecheck($id=0)
	{
		if(isset($_POST['name']) && $_POST['name']!='' && is_numeric($id))
		{
			$slug=url_title($this->general_model->filtertext($_POST['name']));
			if(strlen($slug)<6)
			{
				echo "false";
			}
			else
			{
				if(is_numeric($id))
				{
					$flag=$this->satsangs_model->checkName($this->general_model->filtertext(trim($_POST['name'])),$id);

					if($flag==0)
						echo "true";
					else
						echo "false";
				}
				else
					echo "false";
			}
		}
		else
		{
			echo "false";
		}
	}

	public function validate_users()
	{
		if($this->input->post("users_string")!='')
		{
			$users=$this->satsang_members_model->validateUsers($this->input->post("users_string"));
			header("Content-Type:application/json");
			echo json_encode($users);
		}
		else
		{
			header("Content-Type:application/json");
			json_encode(array());
		}
	}

	public function searchuser()
	{
		$query = (!empty($_POST['q'])) ? strtolower($_POST['q']) : null;
		 
		if (!isset($query)) {
		    die('Invalid query.');
		}
		 
		$status = true;
		$this->logaction->log($this->service,"Searched users with - ".$query);
		$usersData=$this->satsang_members_model->searchUsers($query);
		$resultUsers = [];
		foreach ($usersData as $oneUser)
		{
		    $oneUser['avatar']='';
		    if($oneUser['profilepic']!='')
		    {
			    $uname=$oneUser['uusername'];
			    $fletter=strtolower($uname[0]);
			    $path=sso_aws_s3_base_url."users_profiles/".$fletter."/".md5($oneUser['sso_user_id'])."/thumb50_".$oneUser['profilepic'];
			    if(file_get_contents($path))
			    {
			    	$oneUser['avatar']='<span class="avatar"><img src="'.$path.'"></span>';
			    }
			}
			if($this->input->post("type")=='users_newsletters')
			{
				$resultUsers[]=array("id"=>$oneUser['uid'],"text"=>$oneUser['firstname']." ".$oneUser['lastname']." (".$oneUser['uusername'].")");
			}
			else
				$resultUsers[] = $oneUser;
		}
		// Means no result were found
		if (empty($resultUsers)) 
		{
		    $status = false;
		}
		 
		header('Content-Type: application/json');
		 
		echo json_encode(array(
		    "status" => $status,
		    "error"  => null,
		    "data"   => array(
		        "user"      => $resultUsers
		    )
		));
	}


	public function subscribe_unsubscribe_satsang_user($id=0,$status=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$memberData=$this->satsang_members_model->getMemberById($id);
			if(empty($memberData))
			{
				goto end;
			}
			$this->satsang_members_model->updateReceiveNewslettersStatus($id, $status);
			$data['flag']=1;
			$data['username']='';
			$memberFulldata = $this->satsang_members_model->getMemberDetailsById($id);
			if(isset($memberFulldata->username) && $memberFulldata->username!='')
			{
				$data['username']=$memberFulldata->username;
			}
		}
		end:
		echo json_encode($data);
	}

	public function listemails(){}
	public function email_data(){}
	public function email_resend(){}
	public function bulk_resend(){}
}
?>