<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Releasesadmin extends CI_Controller 
{
	var $service='content';
	var $types=array("MP3 Music Track","PDF Document","Image","Book","MP3 Album","MP3 CD","Audio CD","Video CD","Video DVD","Store Item");
    function __construct() 
	{
        parent::__construct();
		$this->load->model('content/releases_model');
		$this->currentUser=$this->session->userdata("admin_data");
    }
	public function index()
	{
		$views = array( 'releases/admin/list' );
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Releases Listing");
	}

	public function listc($excel=0)
	{
		$list=$this->releases_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Releases Listing ajax request");
	}
	
	public function add_edit_release($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$releaseData=$this->releases_model->releaseData($id);
			if(empty($releaseData))
			{
				$this->session->set_flashdata("release_error",1);
				redirect('releasesadmin');
			}
		}
		else
		{
			$releaseData=array();
		}

		if(isset($_POST["save_release"]))
		{
			if(!isset($_POST['description']))
			{
				$this->session->set_flashdata("release_error",1);
				redirect('releasesadmin/add_edit_release/'.$id);
			}

			$this->form_validation->set_rules('name', 'Release Name', 'trim|required|min_length[6]|max_length[200]');
			$this->form_validation->set_rules('type', 'Type', 'trim|required|checkReleaseType');
			$this->form_validation->set_rules('date', 'Date', 'trim|required|valid_date');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("release_error",1);
				redirect('releasesadmin/add_edit_release/'.$id);
				return;
			}
			$saved=$this->releases_model->save($id,$releaseData);
			if($id==0)
			{
				$this->session->set_flashdata("release_created",1);
			}
			else
				$this->session->set_flashdata("release_saved",1);
			redirect('releasesadmin/add_edit_release/'.$saved);
			
		}
		else
		{
			if($id!='' && (empty($releaseData)) )
			{
				redirect('releasesadmin');
			}
			$views = array('releases/admin/add_edit_release');
			$data = array('views'=>$views,'id'=>$id);
			if(is_numeric($id) && $id)
			{
				$data['releaseData']=$releaseData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data); 
		}
	}

	function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$releaseData=$this->releases_model->releaseData($id);
			if(empty($releaseData))
			{
				goto end;
			}
			$r=$this->releases_model->delete($id,$releaseData);
			if($r)
			{
				$data['flag']=1;
				$data['name']=$releaseData->name;
				$this->logaction->log($this->service,"Admin - Release '".$releaseData->name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}
}
?>