<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once APPPATH. '/third_party/razorpay/Razorpay.php';
use Razorpay\Api\Api;
class Razorpay extends CI_Controller 
{
	var $currentUser='';
	var $service="payments";
	function __construct()
	{
		parent::__construct();
		$this->load->model('payment_model');
		$this->load->model('orders/orders_model');
		$this->load->model('orders/transaction_model');
		$this->load->model('orders/order_log_model');
		$this->load->model('ashrams/ashrams_trust_accounts_model');

		$this->load->model("orders/subscription_payments_model");
		$this->load->model("subscriptions/donors_model");
		$this->load->library("userutil");

		$this->load->model('Razorpay_subscriptions_model','razorpaysubscriptions');
		$this->load->model('Razorpay_customers_model','razorpaycustomers');

		if(isset($_GET['app']))
		{
			$this->load->library("server");
	        $this->server->require_scope("user");
	        $this->load->model('currencies_model');
	        $this->load->model('oauth_sessions_model');
	        $this->oauth_sessions_model->session_check();
		}
		if($this->session->userdata('loggedIn'))
		{
			if($this->session->userdata('id'))
				$this->currentUser=$this->session->userdata('admin_data');
			else
				$this->currentUser=$this->session->userdata('user_data');
		}
	}

	public function capture($payment_id=null)
	{
		$reference=$this->input->post('reference');
		$subscription_id=$this->input->post('subscription_id');
		$isTranresponseUpdate = false;
        if($reference)
        {
            if(!$reference || $reference=='')
            {
                exit;
            }
            if(!$payment_id || $payment_id=='')
            {
                exit;
            }
            $tempInfo=$this->payment_model->getTempInfo($reference);
            if(!empty($tempInfo))
            {
                $customData=unserialize($tempInfo->data);

                //Get trust data
                $trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($customData['formData']['ashram_id'],$customData['cart_type']);
                $trustsArray=array();
                foreach ($trusts as $trustData)
                {
                    $trustsArray[$trustData->currency]=$trustData;
                }
                $trustData=$trustsArray[$tempInfo->currency];
                //Get trust data

                $api = new Api($trustData->razorpay_key, $trustData->razorpay_secret);
				try
				{
					if(empty($this->input->post('subscription_id')))
						$payment  = $api->payment->fetch($payment_id)->capture(array('amount'=>($tempInfo->amount*100)));
					else
						$payment  = $api->payment->fetch($payment_id);
				}
				catch(Exception $e)
				{
					exit;
				}
				
				if($payment['status']=='failed')
				{
					$return['redirect_url']='/donations/checkout';
                    $return['f_flag']=1;
				} 
				else 
				{

					if($payment['status']=='refunded')
					{
						$amount = 0;
					}
					else
					{
						$amount = $payment['amount']/100;
						if($payment['status']=='authorized' && $amount == 5)
							$amount = 0;
					}
					$txnid=$payment_id;

	                $orderId=0;
	                if(isset($customData['order_id']))
	                    $orderId=$customData['order_id'];

	                $transaction=new stdClass();
	                $transaction->tx=$payment_id;
	                $payment_id = $payment_id;
	                $tempIpn=new stdClass();
	                $tempIpn->status='captured';
	                $tempIpn->amount=$amount;

	                $tData = $this->payment_model->createTransaction($payment_id,$tempInfo->user_id,$reference,'captured',null,$orderId);
	                $tData = $this->payment_model->tempInfoUpdateTx($reference,$payment_id,$amount,$tData);
					//saving transaction table 
					$this->payment_model->saveTransaction($tData);
					//saving payment response into archives database
					$this->payment_model->savingPaymentResponse($payment_id,$payment,$tempInfo->user_id,"razorpay",$orderId);
					$isTranresponseUpdate = true;

	                if(isset($customData['cartData']))
	                {
						//saving payment response into archives database
						if(!$isTranresponseUpdate)
							$this->payment_model->savingPaymentResponse($payment_id,$payment,$tempInfo->user_id,"razorpay",$orderId);

	                    $orderId=$this->payment_model->processPurchase($reference,$transaction,$tempInfo,$tempIpn);
	                    if(empty($subscription_id))
	                    {
	                    	$this->order_log_model->log($orderId,
							"Paid amount: ".strtoupper($tempInfo->currency)." ".$tempInfo->amount."\nRazorpay\nTx ID:".$txnid);
	                    	$this->orders_model->sendTransactionReceiptEmail($orderId,$transaction->tx);
	                    	//$this->orders_model->sendTransactionReceiptEmailBcc($orderId,$transaction->tx);
	                    }
	                    else
	                    {
	                    	if($amount>0)
	                    	{
	                    		if(empty($this->input->post('subscription_id')))
	                    			$this->order_log_model->log($orderId,"One time payment item(s) charged.");
	                    		else
	                    			$this->order_log_model->log($orderId,"Subscription One time payment charged.");

	                    		$this->orders_model->calculateDue($orderId);
	                    	}
	                    }
	                }
	                else
	                {
	                	$this->orders_model->calculateDue($orderId);
	                    $this->orders_model->sendTransactionReceiptEmail($orderId,$payment_id);
	                    $this->payment_model->updateOrderTotalPaid($orderId,$amount,$payment_id);
	                    //$this->orders_model->sendTransactionReceiptEmailBcc($orderId,$payment_id);
	                }

	                $transactionRecord=$this->payment_model->getTransaction($payment_id);
	                if($subscription_id)
	                {
		                $transactionAmounts=array();
		                //$amount=0;
		                $has_subscription=0;
		                $orderId = $transactionRecord->order_id;
		                $orderData=$this->orders_model->orderData($orderId);
		                foreach ($orderData['order_items'] as $itemData) 
		                {
		                    if($orderData['order']->order_type==4 && $itemData->subscription==1)
		                    {
		                        $transactionAmounts[]=array(
		                            "amount"=>$itemData->price*$itemData->quantity,
		                            "onetime_charge"=>$itemData->onetime_charge,
		                            "num_of_payments"=>$itemData->num_of_payments,
		                            "subscription"=>1,
		                            "itemData"=>$itemData,
		                            "startDate"=>$itemData->schedule_dates,
		                            "user_id"=>$orderData['order']->user_id
		                        );
		                        $has_subscription=1;
		                    }
		                    else
		                    {
		                        $amount+=$itemData->quantity*($itemData->price+$itemData->shipping_price);
		                        $transactionAmounts[]=array(
		                            "amount"=>$amount,
		                            "subscription"=>0
		                        );
		                    }
		                }

		                foreach ($transactionAmounts as $transactionDetail)
		                {
		                    if(isset($transactionDetail['subscription']) && $transactionDetail['subscription']==1)
		                    {

		                    	$this->transaction_model->updateDetails($payment_id,array("order_item_id"=>$transactionDetail['itemData']->id));
		                    	
		                        $this->razorpaysubscriptions->updatesubscription($subscription_id,$orderId,$transactionDetail['itemData']->order_item_id,$transactionDetail['itemData']->item_id);
		                        
		                        $this->razorpaysubscriptions->updateOrderItemSubscription($transactionDetail['itemData']->order_item_id,$subscription_id,$transactionDetail['itemData'],1);
		                        $return['redirect_url']=$transactionRecord->redirect_url;
		                        $return['subscription_id']=$subscription_id;
		                        $return['reference']=$reference;
		                        $return['order_id']=$transactionRecord->order_id;
		                        $return['f_flag']=0;
		                    }
		                }
		                if($amount > 0 && $transactionRecord->amount > 0)
		                {
		                	$this->orders_model->sendTransactionReceiptEmail($return['order_id'],$payment_id);
		                	$this->orders_model->sendTransactionReceiptEmailBcc($orderId,$payment_id);
		            	}
		            }

		            else
			        {
			        	$return['redirect_url']=$transactionRecord->redirect_url;
	                    $return['reference']=$reference;
	                    $return['order_id']=$transactionRecord->order_id;
	                    $return['f_flag']=0;
			        }
		        }

                if(isset($customData['cartData']))
                {
                    $this->session->set_flashdata("order_placed",1);
                    if($this->input->post("order_type")==1)
                    {
                    	$this->session->unset_userdata("poojas_temp_reference");
                        $this->cart_log_model->log("Payment success:Razorpay",$this->session->userdata("poojasCartAshramId"),$this->input->post("order_type"));
                    }
                    if($this->input->post("order_type")==2)
                    {
                    	$this->session->unset_userdata("donations_temp_reference");
                    	$this->cart_log_model->log("Payment success:Razorpay",$this->session->userdata("donationCartAshramId"),$this->input->post("order_type"));
                    }
                    if($this->input->post("order_type")==4)
                    {
                    	$this->session->unset_userdata("subscriptions_temp_reference");
                    	$this->cart_log_model->log("Payment success:Razorpay",$this->session->userdata("subscriptionCartAshramId"),$this->input->post("order_type"));
                    }
                    if($this->input->post("order_type")==3)
                    {
                    	$this->session->unset_userdata("store_items_temp_reference");
                        $this->cart_log_model->log("Payment success:Razorpay",$this->session->userdata("storeCartAshramId"),$this->input->post("order_type"));
                    }
                }
                else
                {
                	$this->session->set_flashdata("order_placed",1);
                    //$this->orders_model->sendTransactionReceiptEmail($orderId,$payment_id);
                    $this->session->set_userdata("payment_success","Payment processed successfully.");
                }
                header('Content-Type: application/json');
				echo json_encode($return);
            }
        }
	}

	public function createFailedOrderRazorpay()
	{
		if(!empty($this->input->post("temp_order_id")))
		{
			$orderData = $this->temp_payments_model->getOrderDataTemp($this->input->post("temp_order_id"));
			$orderData["response_message"] = "Gateway Failed";
	        $this->temp_payments_model->createFailedOrder($orderData);
	    }
	}

	public function redirecttoorders()
	{
		$temp_order_id = "";
		$temp_payment_id = "";
		$redirect_url = "";
		
		if(!empty($_GET["t_o_i"]))
			$temp_order_id = $_GET["t_o_i"];
		if(!empty($_GET["t_p_i"]))
			$temp_payment_id = $_GET["t_p_i"];
		if(!empty($_GET["redirect_url"]))
			$redirect_url = $_GET["redirect_url"];

		if(!empty($temp_order_id) && !empty($temp_payment_id))
		{
			$this->temp_payments_model->deleteTempOrder($temp_order_id);
			$this->temp_payments_model->deleteTempOrderItems($temp_order_id);
			$this->temp_payments_model->deleteTempTransaction($temp_payment_id);
		}
		redirect($redirect_url);
	}
}
?>