<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Quicklinksadmin extends CI_Controller 
{
	public $service="websiteadmin";
    function __construct() 
	{
        parent::__construct();
		$this->currentUser=$this->session->userdata("admin_data");
		$this->load->model('quick_links_model');
    }

    public function index()
	{
		$views = array( 'quicklinks/admin/list' );
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed quick links Listing");
	}

	public function listc($excel=0)
	{
		$list=$this->quick_links_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed quick links ajax request");
	}

	public function add_edit_link($id=0)
	{
		if(isset($_POST["save_link"]))
		{	
			if(!isset($_POST['description']))
			{
				$this->session->set_flashdata('link_error',1);
				redirect("quicklinksadmin/add_edit_link".$id);
			}
			$this->form_validation->set_rules('title', 'Title', 'trim|required|min_length[3]|max_length[100]');
			$this->form_validation->set_rules('description', 'Description', 'trim|min_length[3]|max_length[200]');
			$this->form_validation->set_rules('link', 'Link', 'trim|required|min_length[3]|max_length[100]');
	        if($this->form_validation->run() == FALSE)
	        {
	        	$this->session->set_flashdata('link_error',1);
				redirect("quicklinksadmin/add_edit_link/".$id);
	        }

	        if($id)
			{
				$result = $this->quick_links_model->linkData($id);

				if(empty($result))
				{
					$this->session->set_flashdata("link_error",1);
					redirect("quicklinksadmin");
				}
			}
			$saved=$this->quick_links_model->save($id);
			if($saved)
			{

				if($id)
					$this->session->set_flashdata('link_added',1);
				else
					$this->session->set_flashdata('link_added',1);
			}
			else
				$this->session->set_flashdata('devotee_error',1);
			redirect('quicklinksadmin/add_edit_link/'.$saved);
		}
		else
		{
			$result = $this->quick_links_model->linkData($id);
			if(empty($result) && $id)
			{
				$this->session->set_flashdata("link_error",1);
				redirect("quicklinksadmin");
			}
		 	$views = array( 'quicklinks/admin/add_link' );
		 	$data = array('views'=>$views,'id'=>$id);
		 	$data['result']=$result;
		 	$this->load->view(ADMIN_TEMPLATE,$data);  
		}
	}
	public function updateorder()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->quick_links_model->updateOrder($_POST['pk'],$_POST['value']);
		echo 1;
	}

	function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$linkData=$this->quick_links_model->linkData($id);
			if(!empty($linkData))
			{
				$r=$this->quick_links_model->delete($id,$linkData);
				if($r)
				{
					$data['flag']=1;
				}
			}
		}
		echo json_encode($data);
	}
	
	public function bulk()
	{
		$result['flag']=0;
		if(isset($_POST['bulk_actions']) && $_POST['bulk_actions']=="delete")
		{
			$ex='';
			$count=0;
			if(isset($_POST['ids']))
			foreach($_POST['ids'] as $id)
			{
				$linkData=$this->quick_links_model->linkData($id);
				if(!empty($linkData))
				{
					$this->quick_links_model->delete($id,$linkData);
					$count++;
				}
			}
			$result['flag']=1;
			$result['num']=$count;
		}
		echo json_encode($result);
	}
}
?>