<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Poojasadmin extends CI_Controller 
{
	var $service='poojas';
	var $categories=array(
							1=>"Shivaratri",
							2=>"Appaji Birthday",
							3=>"Navaratri",
							4=>"Datta Jayanti",
							5=>"Guru Poornima",
							6=>"Vinayaka Chavithi",
							7=>"Subrahmanya Sashthi",
							8=>"Krishna Janmashtami",
							9=>"Other Poojas",
							10=>"Vaikuntha Ekadashi",
							11=>"Deepavali",
							12=>"Other Ashrams",
							13=>"Hanuman Jayanti",
							14=>"Lakshmi Narasimha Jayanti"
						);
    function __construct() 
	{
        parent::__construct();
        $this->load->model('ashrams/ashrams_model');
		$this->load->model('ashrams/poojas_model');
		$this->load->model('ashrams/poojas_categories_model');
		$this->load->model("mobile/mobileNotifications_model");
		$this->currentUser=$this->session->userdata("admin_data");
		if(is_single_ashram_site)
        { 
            $this->session->set_userdata("ashramId",default_ashram_id); 
		}
		if(!$this->session->userdata("ashramId"))
		{
			$this->session->set_userdata("ashramId",0);
		}
    }

	function index()
	{
		$views = array( 'ashrams/admin/list_poojas' );
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		if($this->session->userdata("ashramId")>0)
			$poojasCategories=$this->poojas_categories_model->getCategoriesListByAshramId($this->session->userdata("ashramId"));
		else
			$poojasCategories=$this->poojas_categories_model->getList();
		$data['categories']=$poojasCategories;
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Poojas Listing");
	}

	public function listc($excel=0)
	{
		if($this->session->userdata("ashramId"))
		{
			$list=$this->poojas_model->listAdmin($this->session->userdata("ashramId"),$excel);
			echo json_encode($list);
			$this->logaction->log($this->service,"Admin - Viewed Poojas Listing ajax request");
		}
	}

	public function categories()
	{
		$views = array( 'ashrams/admin/list_poojas_categories');
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function listcats($excel=0)
	{
		if($this->session->userdata("ashramId"))
		{
			$list=$this->poojas_categories_model->listAdmin($this->session->userdata("ashramId"),$excel);
			echo json_encode($list);
			$this->logaction->log($this->service,"Admin - Viewed Poojas categories listing ajax request");
		}
	}

	public function add_edit_category($id=0)
	{
		if($id)
		{
			$categoryData=$this->poojas_categories_model->categoryData($id);
			if(empty($categoryData))
			{
				$this->session->set_flashdata("cat_error",1);
				redirect("/poojasadmin/categories");
			}
			if($this->currentUser->roles!=1 && ($categoryData->category_ashram_id!=$this->session->userdata("ashramId")))
        	{
        		$this->session->set_flashdata("cat_error",1);
				redirect("/poojasadmin/categories");
        	}
		}
		else
			$categoryData=array();

		if(isset($_POST["add_category"]))
		{
			$this->form_validation->set_rules('name', 'Category name', 'trim|required|min_length[3]|max_length[200]|check_poojas_category['.$id.']');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("cat_error",1);
				redirect('poojasadmin/add_edit_category/'.$id);
				return;
			}
			
			$saved=$this->poojas_categories_model->save($id,$categoryData);
			if($saved)
			{
				if($id)
						$this->session->set_flashdata("cat_saved",1);
				else
				{
					$this->session->set_flashdata("cat_created",1);
				}
			}
			redirect('poojasadmin/add_edit_category/'.$saved);
		}
		else
		{	
		 	$views = array( 'ashrams/admin/add_edit_pooja_category' );
		 	$data = array('views'=>$views,'id'=>$id);
		 	if($this->currentUser->roles==1)
        	{
        		$data['ashrams']=$this->ashrams_model->getList();
        	}
        	$data['ashramData']=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
			if($id)
			{
				$data['categoryData']=$categoryData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	function delete_category($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$categoryData=$this->poojas_categories_model->categoryData($id);
			if(empty($categoryData))
			{
				goto end;
			}
			if($categoryData->in_use>0)
			{
				$data['flag']=2;
				$data['name']=$categoryData->name;
				goto end;
			}
			$r=$this->poojas_categories_model->delete($id,$categoryData);
			if($r)
			{
				$data['flag']=1;
				$data['name']=$categoryData->name;
				$this->logaction->log($this->service,"Admin - Category '".$categoryData->name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}
	public function category_updateorder()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->poojas_categories_model->updateOrder($_POST['pk'],$_POST['value']);
		echo 1;
	}

	public function add_edit_pooja($id=0)
	{
		if(!$this->session->userdata("ashramId"))
		{
			$this->session->set_flashdata("pooja_error",1);
			redirect('poojasadmin');
		}

		if(is_numeric($id) && $id)
		{
			$poojaData=$this->poojas_model->poojaData($id);
			if(empty($poojaData))
			{
				$this->session->set_flashdata("pooja_error",1);
				redirect('poojasadmin');
			}
			if($poojaData->ashram_id!=$this->session->userdata("ashramId"))
        	{
        		$this->session->set_flashdata("pooja_error",1);
				redirect("poojasadmin");
        	}
		}
		else
		{
			$poojaData=array();
		}

		$this->load->model('currencies_model');
		$ashramCurrencies = $this->currencies_model->getByAshram($this->session->userdata("ashramId"));

		if(isset($_POST["pooja_name"]))
		{
			if(!isset($_POST['start_date']) || !isset($_POST['end_date']) || !isset($_POST['visible_from']) || !isset($_POST['visible_to']) ||
				!isset($_POST['exclude_dates']) || !isset($_POST['include_dates']) || !isset($_POST['include_exclude_dates']) || !isset($_POST['time_from']) || !isset($_POST['time_to']))
			{
				$this->session->set_flashdata("pooja_error",1);
				redirect('poojasadmin/add_edit_pooja/'.$id);
			}

			if(isset($_FILES['pooja_image']['name']) && $_FILES['pooja_image']['name']!='')
			{
				$allowed_file_types =   array('image/jpeg','image/jpg','image/png');
				$ext=pathinfo ($_FILES['pooja_image']['name'],PATHINFO_EXTENSION);
				if($_FILES['pooja_image']['size']==0 || $ext=='' || !in_array($_FILES['pooja_image']['type'],$allowed_file_types) ||
						$_FILES['pooja_image']['size']>(1024*1024))
				{
					$this->session->set_flashdata("pooja_error",1);
					redirect('poojasadmin/add_edit_pooja/'.$id);
				}
			}

			$this->form_validation->set_rules('pooja_name', 'Pooja Name', 'trim|required|min_length[3]|max_length[100]|checkPoojaName['.$id.']');
			$this->form_validation->set_rules('category', 'Category', 'trim|required|numeric|checkPoojaCategory');
			$this->form_validation->set_rules('description', 'Description', 'trim|required|min_length[3]|max_length[2000]');
			foreach ($ashramCurrencies as $currencyData)
			{
				$currencyparameters = strtolower($currencyData['currency']).' || '.$this->session->userdata("ashramId");
				$this->form_validation->set_rules('price_'.strtolower($currencyData['currency']), 'Price ('.$currencyData['currency'].')', 'trim|required|checkCurrencyValuesByAshram['.$currencyparameters.']');
			}
			$this->form_validation->set_rules('is_public_display', 'Is Public Diaply? ', 'trim|required|numeric|checkPublicDisplay');
			$this->form_validation->set_rules('pitru_paksha_pooja', 'Pitru Paksha Pooja? ', 'trim|required|numeric|checkPitruPakshaPooja');
			if(in_array(global_site_flag, [2]))
		    {
				$this->form_validation->set_rules('is_poornaphala_seva', 'Poornaphala Seva? ', 'trim|required|numeric|checkPoornaphalaSeva');
			}
			$this->form_validation->set_rules('max_family_members', 'Pooja in the name of ', 'trim|required|checkMaxFamilyMembers');
			$this->form_validation->set_rules('have_personal_note', 'Have Personal Note? ', 'trim|required|numeric|checkPersonalNote');
			$this->form_validation->set_rules('visible_from', 'Visible From', 'trim|required|valid_date');
			$this->form_validation->set_rules('visible_to', 'Visible To', 'trim|required|valid_date|checkPoojaVisibleDates');
			$this->form_validation->set_rules('start_date', 'Start Date', 'trim|required|valid_date|checkPoojaStartDate');
			$this->form_validation->set_rules('end_date', 'End Date', 'trim|required|valid_date|checkPoojaDates|checkPoojaEndDate');
			$this->form_validation->set_rules('days[]', 'Days', 'trim|checkPoojaIncludedDays');
			$this->form_validation->set_rules('include_exclude_dates', 'Include / Excluded Dates', 'trim');
			$this->form_validation->set_rules('exclude_dates', 'Excluded Dates', 'trim|checkPoojaExcludedDates');
			$this->form_validation->set_rules('include_dates', 'Included Dates', 'trim|checkPoojaIncludedDates');
			$this->form_validation->set_rules('time_from', 'Time From', 'trim|required|valid_time');
			$this->form_validation->set_rules('time_to', 'Time To', 'trim|required|valid_time|checkPoojaTimes');
			// $this->form_validation->set_rules('close_before', 'Close Before', 'trim|required|numeric|checkPoojaCloseBefore');
			$this->form_validation->set_rules('cutoff_type', 'Cutoff Type', 'trim|required|checkPoojaCutoffType');
			$this->form_validation->set_rules('cutoff_hour', 'Cutoff Hour', 'trim|required|numeric|checkPoojaCutoffHour');
			$this->form_validation->set_rules('cutoff_minutes', 'Cutoff Minutes', 'trim|required|numeric|checkPoojaCutoffMinutes');
			$this->form_validation->set_rules('is_external_link', 'Is external link? ', 'trim|required|checkExternalLinkFlag');
			$this->form_validation->set_rules('shipping', 'Shipping', 'trim|required|numeric|checkItemShipping');
			$this->form_validation->set_rules('partial_payments_allowed', 'Partial payments', 'trim|required|numeric|checkPartialPaymentOption');
			$this->form_validation->set_rules('in_person_note', 'Attend Pooja In Person Note', 'trim|min_length[5]|max_length[250]');
			
			if($this->input->post("is_external_link")==1)
				$this->form_validation->set_rules('external_link', 'External link', 'trim|required|valid_url');

			if($this->input->post("shipping")==1)
			{
				foreach ($GLOBALS['currencies'] as $currencyData)
				{
					$this->form_validation->set_rules('shipping_domestic_'.strtolower($currencyData['currency']), 'Shipping domestic Price ('.$currencyData['currency'].')', 'trim|required|numeric|max_length[4]');
					$this->form_validation->set_rules('shipping_international_'.strtolower($currencyData['currency']), 'Shipping international Price ('.$currencyData['currency'].')', 'trim|required|numeric|max_length[4]');
				}
			}

			$this->form_validation->set_rules('only_for_admin', 'Only for Admin? ', 'trim|required|checkPoojaIsOnlyForAdmin');
			$this->form_validation->set_rules('is_secret', 'Is Secret? ', 'trim|required|checkIsSecretPooja');
			if($this->input->post("is_secret")==1)
			{
				$this->form_validation->set_rules('s_key', 'Secret Key', 'trim|min_length[2]|max_length[64]|checkAlphaNumericUnderscoreDashOnly|checkPoojaSecretKeyExists['.$id.']');
			}
			$this->form_validation->set_rules('item_key', 'Item Key', 'trim|min_length[2]|max_length[64]|checkAlphaNumericUnderscoreDashOnly|checkPoojaItemKeyExists['.$id.']');

			$this->form_validation->set_rules('display_only_popup', 'Display Only Popup? ', 'trim|required|checkPoojaDisplayOnlyPopup');
			if($this->input->post("display_only_popup")==1)
			{
				$this->form_validation->set_rules('popup_content', 'Popup Content', 'trim|required|min_length[3]|max_length[1000]');
			}

			$this->form_validation->set_rules('having_custom_email', 'Custom Email? ', 'trim|required|checkPoojaHavingCustomEmail');
			if($this->input->post("having_custom_email")==1)
			{
				$this->form_validation->set_rules('custom_email_text', 'Custom Email Text', 'trim|required|min_length[3]|max_length[10000]');
			}

			$this->form_validation->set_rules('having_custom_sms', 'Custom SMS? ', 'trim|required|checkPoojaHavingCustomSms');
			if($this->input->post("having_custom_sms")==1)
			{
				$this->form_validation->set_rules('custom_sms_text', 'Custom SMS Text', 'trim|required|min_length[6]|max_length[320]');
			}

			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("pooja_error",1);
				redirect('poojasadmin/add_edit_pooja/'.$id);
				return;
			}
			$saved=$this->poojas_model->save($id,$poojaData);
			if($id==0)
			{
				$this->session->set_flashdata("pooja_created",1);
			}
			else
			{
				$this->session->set_flashdata("pooja_saved",1);
			}
			redirect('poojasadmin/add_edit_pooja/'.$saved);
		}
		else
		{
			$views = array('ashrams/admin/add_edit_pooja');
			$data = array('views'=>$views,'id'=>$id);
			if($this->currentUser->roles==1)
        	{
        		$data['ashrams']=$this->ashrams_model->getList();
        	}
			$data['ashramData']=$this->ashrams_model->ashramData($this->session->userdata("ashramId"));
			if(is_numeric($id) && $id)
			{
				$data['poojaData']=$poojaData;
			}
			$data['categories']=$this->poojas_categories_model->getCategoriesListByAshramId($this->session->userdata("ashramId"));
			$data['ashramCurrencies'] = $ashramCurrencies;
			$this->load->view(ADMIN_TEMPLATE,$data); 
		}
	}

	function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id && $this->session->userdata("ashramId"))
		{
			$poojaData=$this->poojas_model->poojaData($id);
			if(empty($poojaData))
			{
				goto end;
			}
			$r=$this->poojas_model->delete($id,$poojaData);
			if($r)
			{
				//deleting related notification data also
				$this->mobileNotifications_model->remove($id,'poojas');
				$data['flag']=1;
				$data['pooja_name']=$poojaData->pooja_name;
				$this->logaction->log($this->service,"Admin - Pooja '".$poojaData->pooja_name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}

	public function namecheck($id=0)
	{
		if(!$this->session->userdata("ashramId"))
		{
			echo 'false';
			return;
		}
		if(isset($_POST['pooja_name']) && $_POST['pooja_name']!='')
		{
			if(is_numeric($id))
			{
				$flag=$this->poojas_model->checkPoojaName($this->general_model->filtertext(trim($_POST['pooja_name'])),$id);
				if($flag==1)
					echo 'false';
				else
					echo 'true';
			}
			else
				echo 'false';
		}
	}

	public function categorycheckname($id=0)
	{
		if($this->input->post('name')!='')
		{
			$slug=url_title($this->general_model->filtertext($this->input->post('name')));
			
			if(is_numeric($id))
			{
				$flag=$this->poojas_categories_model->checkName($this->general_model->filtertext(trim($this->input->post('name'))),$id);
				if($flag==1)
					echo 2;
				else
					echo 1;
			}
			else
				echo 0;
		}
	}
	public function pooja_updateorder()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->poojas_model->updateOrder($_POST['pk'],$_POST['value']);
		echo 1;
	}

	public function updateSwamijipoojaNote()
	{
		$this->form_validation->set_rules('orderItemId', 'orderItemId', 'trim|required|numeric');
		$this->form_validation->set_rules('check_status', 'Condition', 'trim|required|numeric');
		$this->form_validation->set_rules('userId', 'User Id', 'trim|required|numeric');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$update = $this->poojas_model->updateSwamijipooja($_POST['check_status'],$_POST['orderItemId'],$_POST['userId']);
		if($update)
			echo 1;
		else
			echo 0;
	}

}
?>