<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Pledgeadmin extends CI_Controller 
{
	var $service='content';
	var $currentUser='';
    function __construct() 
    {
    	parent::__construct();
		$this->load->model("pledge/pledge_model");
       	$this->load->model("pledge/pledge_categories_model");
       	$this->load->model("currencies_model");
		$this->currentUser=$this->session->userdata("admin_data");
    }
	public function index()
	{
		$views = array( 'pledge/admin/list');
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	
	public function categories()
	{
		$views = array( 'pledge/admin/list_categories' );
		$data = array('views'=>$views);
	 	$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function listc($excel=0)
	{
		$list=$this->pledge_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Pledges listing ajax request");
		
	}
	public function listcats($excel=0)
	{
		$list=$this->pledge_categories_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Pledge Categories listing ajax request");
		
	}

	public function view($id=0)
	{
	 	$views = array( 'pledge/admin/view' );
	 	$data = array('views'=>$views,'id'=>$id);
		if($id)
		{
			$data['pledgeData']=$this->pledge_model->pledgeData($id);
			if(empty($data['pledgeData']))
			{
				$this->session->set_flashdata("pledge_error",1);
				redirect("/pledgeadmin");
			}
		}
		else
		{
			$this->session->set_flashdata("pledge_error",1);
			redirect("/pledgeadmin");
		}
	 	$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function add_edit_category($id=0)
	{
		if(isset($_POST["add_cat"]))
		{	
			$this->form_validation->set_rules('category', 'Category', 'trim|required|min_length[3]|max_length[50]|checkPledgeCategoryExist['.$id.']');

			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("cat_error",1);
				redirect('pledgeadmin/add_edit_category/'.$id);
				return;
			}
			if($id)
			{
				$catData=$this->pledge_categories_model->catData($id);
				if(empty($catData))
				{
					$this->session->set_flashdata("cat_error",1);
					redirect("/pledgeadmin/categories");
				}
			}


			$saved=$this->pledge_categories_model->save($id);
			if($saved)
			{
				if($id)
						$this->session->set_flashdata("category_saved",1);
				else
				{
					$this->session->set_flashdata("category_created",1);
				}
			}
			redirect('pledgeadmin/add_edit_category/'.$saved);
			
		}
		else
		{
			
		 	$views = array( 'pledge/admin/add_edit_category' );
		 	$data = array('views'=>$views,'id'=>$id);
			if($id)
			{
				$data['cat_data']=$this->pledge_categories_model->catData($id);
				if(empty($data['cat_data']))
				{
					$this->session->set_flashdata("cat_error",1);
					redirect("/pledgeadmin/categories");
				}
			}
		 	$this->load->view(ADMIN_TEMPLATE,$data);  
		}
	}

	public function deletecategory($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$catData=$this->pledge_categories_model->catData($id);
			if(!empty($catData))
			{
				$pledges=$this->pledge_model->getPledgesByCategory($id);
				if(empty($pledges))
				{
					$r=$this->pledge_categories_model->delete($id,$catData);
					if($r)
					{
						$data['flag']=1;
						$data['category']=$catData->name;
					}
				}
				else
				{
					$data['flag']=2;
					$data['category']=$catData->name;
				}
			}
		}
		echo json_encode($data);
	}

	public function hidecategory($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$catData=$this->pledge_categories_model->catData($id);
			if(!empty($catData))
			{
				$data['category']=$catData->name;
				if($catData->status==0)
				{
					$data['flag']=2;	
					goto end;
				}
				$r=$this->pledge_categories_model->hide($id,$catData);
				$data['flag']=1;
			}
		}
		end:
		echo json_encode($data);
	}

	public function unhidecategory($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$catData=$this->pledge_categories_model->catData($id);
			if(!empty($catData))
			{
				$data['category']=$catData->name;
				if($catData->status==1)
				{
					$data['flag']=2;	
					goto end;
				}
				$r=$this->pledge_categories_model->unhide($id,$catData);
				$data['flag']=1;
			}
		}
		end:
		echo json_encode($data);
	}

	public function updateorder()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric|pledgePurpose');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->pledge_categories_model->updateOrder($_POST['pk'],$_POST['value']);
		echo 1;
	}

	public function update_admin_notes()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|max_length[2000]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric|pledgeExist');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->pledge_model->updateAdminNotes($_POST['pk'],$_POST['value']);
		echo 1;
	}

	public function category_check()
	{
		$exist=$this->pledge_categories_model->cat_exist($_POST['id'],$_POST['category']);
		if($exist) echo 0;
		else echo 1;
	}

	public function changestatus($id=0,$status=0)
	{
		$result['status']=0;
		if(is_numeric($id) && is_numeric($status) && in_array($status,array(0,1,2)))
		{
			$pledgeData=$this->pledge_model->pledgeData($id);
			if(empty($pledgeData))
				goto end;
			if($pledgeData->pstatus==$status)
			{
				$result['status']=2;
				goto end;
			}
			$this->pledge_model->changeStatus($id,$status);
			$result['pledge_id']=$pledgeData->pledge_id;
			$result['status']=1;
		}
		end:
		echo json_encode($result);
	}
}
?>