<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Photoalbumsadmin extends CI_Controller
{
	var $service='content';
	var $currentUser='';
    public function __construct() 
	{
        parent::__construct();
        $this->load->model('content/album_model');
        $this->load->model('content/album_images_model');
        $this->load->model('ashrams/ashrams_model');
		$this->currentUser=$this->session->userdata("admin_data");
		if(is_single_ashram_site)
        { 
            $this->session->set_userdata("ashramId",default_ashram_id); 
		}
    }
	public function index()
	{
		$views = array( 'photoalbums/admin/list');
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function listalbums()
	{
		$ashramId = $this->session->userdata("ashramId");
		if($this->currentUser->roles!=1)
		{
			if($this->currentUser->ashram_id)
				$ashramId=$this->currentUser->ashram_id;
			else if($this->currentUser->satsang_id)
				$ashramId=$this->currentUser->satsang_id;

		}
		$ashramId = isset($ashramId)?$ashramId:0;
		$list=$this->album_model->listAlbumsAjax($ashramId);
		echo json_encode($list);
	}
	public function add_edit_album($id=0)
	{
		if(isset($_POST['album_name']))
		{
			if($id)
			{
				$albumData=$this->album_model->albumData($id);
				if(empty($albumData['album']))
				{
					$this->session->set_flashdata("album_error",1);
					redirect('photoalbumsadmin');
				}
				if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
				{
					if($albumData['album']->ashram_id!=$this->currentUser->ashram_id)
					{
						$data['views'] = array('common/public/error');
	                	$this->load->view(FRONTEND_TEMPLATE,$data);
	                	return;
					}
				}
			}
			$this->form_validation->set_rules('album_name', 'Album Name', 'trim|required|min_length[6]|max_length[100]|checkTitleSlug');
			$this->form_validation->set_rules('description', 'Description', 'trim|required|min_length[10]|max_length[1000]');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("album_error",1);
				redirect("photoalbumsadmin/add_edit_album/".$id);
			}
			$r=$this->album_model->saveAlbum($id);
			if($r)
			{
				if($id)
				{
					$this->session->set_flashdata("album_saved",1);
				}
				else
				{
					$this->session->set_flashdata("album_created",1);
				}
				redirect("photoalbumsadmin/add_edit_album/".$r);
			}
			else
			{
				$this->session->set_flashdata("page_error",1);	
				redirect("photoalbumsadmin/add_edit_album/".$id);
			}
		}
		else
		{

			$views = array( 'photoalbums/admin/add_edit_album');
			$data = array('views'=>$views,'id'=>$id);
			$data['ashrams']=$this->ashrams_model->getList();
			if($id)
			{
				$albumData=$this->album_model->albumData($id);
				if($albumData['album']->ashram_id)
					$data['ashramData']=$this->ashrams_model->ashramData($albumData['album']->ashram_id);
				if(empty($albumData['album']))
				{
					$this->session->set_flashdata("album_error",1);
					redirect('photoalbumsadmin');
				}
				$data['albumData']=$albumData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}
	public function deletealbum($albumId=0)
	{
		$data['flag']=0;
		if(is_numeric($albumId) && $albumId)
		{
			$albumData=$this->album_model->albumData($albumId);
			if(empty($albumData['album']))
			{
				goto end;
			}
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($albumData['album']->ashram_id!=$this->currentUser->ashram_id)
				{
					goto end;
				}
			}
			$r=$this->album_model->delete($albumData);
			if($r)
			{
				$data['flag']=1;
				$data['unique_id']=$albumData['album']->name;
			}
		}
		end:
		echo json_encode($data);
	}
	public function uploadimages($albumId=0)
	{
		$allowed_file_types =   array('image/jpeg','image/jpg','image/png');
		$json['files']=[];
		if(is_numeric($albumId) && $albumId)
		{
			$albumData=$this->album_model->albumData($albumId);
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($albumData['album']->ashram_id!=$this->currentUser->ashram_id)
				{
					goto end;
				}
			}
			if(!empty($albumData['album']) && isset($_FILES['files']))
			{
				foreach ($_FILES['files']['name'] as $key => $file) 
				{
					if($_FILES['files']['size'][$key]==0)
					{
						$json['files'][] = array(
			            'name' => $file,
			            'size' => $_FILES['files']['size'][$key],
			            'type' => $_FILES['files']['type'][$key],
			            'error' => "Invalid File Size",
			            'status'=>0
			        	);
					}
					else if(!in_array($_FILES['files']['type'][$key],$allowed_file_types))
					{
						$json['files'][] = array(
			            'name' => $file,
			            'size' => $_FILES['files']['size'][$key],
			            'type' => $_FILES['files']['type'][$key],
			            'error' => "Extension not allowed",
			            'status'=>0
			        	);
					}
					else
					{	
		        		$json['files'][0]=$this->album_images_model->uploadFile($albumData);
		        		$json['files'][0]['name']=$file;
		        		$json['files'][0]['status']=1;
		        		$json['files'][0]['type']=$_FILES['files']['type'][$key];
		        		$json['files'][0]['size']=$_FILES['files']['size'][$key];
		        	}
				}
				echo json_encode($json);
			}
			else
			{
				foreach ($_FILES['files']['name'] as $key => $file) 
				{
					$json['files'][] = array(
		            'name' => $file,
		            'size' => $_FILES['files']['size'][$key],
		            'type' => $_FILES['files']['type'][$key],
		            'error' => "Invalid ALbum ID",
		            'status'=>0
		        	);
				}
				end:
				echo json_encode($json);
			}
		}
	}
	function deleteimage($albumId=0,$imageId=0)
	{
		$data['flag']=0;
		if(is_numeric($albumId) && $albumId && is_numeric($imageId) && $imageId)
		{
			$albumData=$this->album_model->albumData($albumId);
			if(empty($albumData['album']))
			{
				goto end;
			}
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($albumData['album']->ashram_id!=$this->currentUser->ashram_id)
				{
					goto end;
				}
			}
			$imageData=$this->album_images_model->imageData($imageId,$albumId);
			if(!empty($imageData))
			{
				$r=$this->album_images_model->delete($albumData,$imageData);
				if($r)
				{
					$data['flag']=1;
					$data['filename']=$imageData->filename;
				}
			}
		}
		end:
		echo json_encode($data);
	}
	public function updatefileinfo($albumId=0)
	{
		if(is_numeric($albumId) && $albumId)
		{
			$albumData=$this->album_model->albumData($albumId);
			if(empty($albumData['album']))
			{
				echo 0;
				exit;
			}
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($albumData['album']->ashram_id!=$this->currentUser->ashram_id)
				{
					echo 0;
					return;
				}
			}
			$this->form_validation->set_rules('value', 'Value', 'trim|max_length[200]');
	    	$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
	    	if($this->form_validation->run() == FALSE)
			{
				echo 0;
				return;
			}
			$this->album_images_model->updateInfo($_POST['pk'],'description',$_POST['value']);
		}
	}
	public function updatefileinfoorder($albumId=0)
	{
		if(is_numeric($albumId) && $albumId)
		{
			$albumData=$this->album_model->albumData($albumId);
			if(empty($albumData['album']))
			{
				echo 0;
				exit;
			}
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($albumData['album']->ashram_id!=$this->currentUser->ashram_id)
				{
					echo 0;
					exit;
				}
			}
			$this->form_validation->set_rules('value', 'Value', 'trim|numeric|max_length[3]');
	    	$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
	    	if($this->form_validation->run() == FALSE)
			{
				echo 0;
				return;
			}
			$this->album_images_model->updateInfo($_POST['pk'],'order',$_POST['value']);
		}
	}
	public function titlecheck()
	{
		if(isset($_POST['title']) && $_POST['title']!='')
		{
			$slug=url_title($_POST['title']);
			if(strlen($slug)<6)
				echo 0;
			else
				echo 1;
		}
	}
	public function bulk_delete($albumId=0)
	{
		$data['flag']=0;
		$data['count']=0;
		$data['ids']=array();
		if(is_numeric($albumId) && $albumId && isset($_POST['ids']) && !empty($_POST['ids']))
		{
			$albumData=$this->album_model->albumData($albumId);
			if(empty($albumData['album']))
			{
				goto end;
			}
			if($this->currentUser->roles!=1 && $this->currentUser->roles!=7)
			{
				if($albumData['album']->ashram_id!=$this->currentUser->ashram_id)
				{
					goto end;
				}
			}
			foreach ($_POST['ids'] as $imageId)
			{
				$imageData=$this->album_images_model->imageData($imageId,$albumId);
				if(!empty($imageData))
				{
					$r=$this->album_images_model->delete($albumData,$imageData);
					if($r)
					{
						$data['count']++;
						$data['ids'][]=$imageId;
					}
				}
				$data['flag']=1;
			}
		}
		end:
		echo json_encode($data);
	}
}
?>