<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Payu extends CI_Controller 
{
	var $currentUser='';
	var $service="payments";
	function __construct() 
	{
		parent::__construct();
		$this->load->model('payment_model');
		$this->load->library("userutil");
		$this->load->model('orders/orders_model');
		$this->load->model('orders/transaction_model');
		$this->load->model('orders/order_log_model');
		if($this->session->userdata('loggedIn'))
		{
			if($this->session->userdata('id'))
				$this->currentUser=$this->session->userdata('admin_data');
			else
				$this->currentUser=$this->session->userdata('user_data');
		}
	}

	public function add_funds()
	{
		if(isset($_POST['mihpayid']))
		{
			$app_vars=array("status"=>0,"order_id"=>0,"msg"=>'');
			$this->logaction->log($this->service,"PayU - Browser redirect - Transaction data - ".serialize($_POST));
			sleep(10);
			$this->logaction->log($this->service,"PayU - Browser redirect - Payment info recieved - Tx: ".$_POST['txnid']);
			$tx=$_POST['txnid'];
			$transaction=$this->payment_model->getTransaction($tx);

			$trans_status=$this->input->post("status");
			if(!empty($transaction) && $transaction->status!='initiated')
				$trans_status=$transaction->status;

			$tempInfo=$this->payment_model->getTempInfo($this->input->post("udf4"));
			$cdata['customData']=unserialize($tempInfo->data);
			if(isset($cdata['customData']['cartData']))
			{
				$this->cart_log_model->log("PayU browser redirect.<br>Tx ID:".$this->input->post("txnid")."<br>Status:".
					$trans_status,$cdata['customData']['ashramData']->id,$cdata['customData']['cart_type']);
			}

			if(!empty($transaction) && $transaction->t_status==1) //Transaction valid and hook received
			{
				//saving payment response into archives database
				$this->payment_model->savingPaymentResponse($tx,$_POST,$transaction->userid,"payu",$transaction->order_id);

				$this->logaction->log($this->service,"PayU - Browser redirect - Transaction valid - Tx: ".$_POST['txnid']);
				if(strtolower($transaction->status)=='success' || strtolower($transaction->status)=='release payment')
				{
					$this->session->set_flashdata("transaction_ok",1);
					$this->session->set_flashdata("transaction_currency",strtoupper($transaction->payu_currency));
					$this->session->set_flashdata("transaction_amount",round($transaction->amount,0));
					$app_vars['status']=1;//Success
					$app_vars['order_id']=$transaction->order_id;//Seva ID
					$tempFlashvars=array_filter(explode(",",$transaction->flashvars));
					foreach ($tempFlashvars as $flashvar)
					{
						$splitVar=array_filter(explode(":",$flashvar));
						if(count($splitVar)==2)
						{
							$varName=$splitVar[0];
							$varValue=$splitVar[1];
							$this->session->set_flashdata($varName,$varValue);
						}
					}

					if($transaction->userid!=0)
					{
						if($this->session->userdata("loggedIn"))
						{
							if(isset($cdata['customData']['cartData']))
								$redirectTo=$transaction->redirect_url."?order_placed=1";
							else
								$redirectTo=$transaction->redirect_url;
						}
						else
						{
							$redirectTo=base_url."status";
						}
					}
					else
					{
						$redirectTo=$transaction->redirect_url;
						$this->logaction->log($this->service,"PayU Browser redirect - Payment received - Session expired - Redirected to Status page - Txnid: ".$_POST['txnid']." - Status: ".$_POST['status']);
						goto end;
					}
				}
				else if(strtolower($transaction->status)=='failed' || strtolower($transaction->status)=='user cancelled' || strtolower($transaction->status)=='failure')
				{
					$this->session->set_flashdata("transaction_failed",'1');
					$redirectTo=$transaction->redirect_url;
					$app_vars['status']=0;//Failure
					$app_vars['msg']="Your transaction has been failed.";
					goto end;
				}
			}
			else if(!empty($transaction) && $transaction->t_status==0) //Transaction valid and hook not received
			{
				if(isset($_POST['status']) && (strtolower($_POST['status'])=='success' || strtolower($_POST['status'])=='release payment'))
				{
					$this->session->set_flashdata("transaction_pending",'1');
					$redirectTo="status";
					$app_vars['status']=2;//Transaction success but no response on hook
					$app_vars['msg']="Your transaction is successful. We are getting delay in payment gateway response.
					You will get an email confirmation once the transaction is processed.";
				}
				else
				{
					$this->session->set_flashdata("transaction_failed",'1');
					$this->payment_model->transactionFailed($_POST['udf4']);
					$app_vars['status']=0;//Failure
					$app_vars['msg']="Your transaction has been failed.";
					if($transaction->redirect_url=='')
	                    $redirectTo="status";
	                else
					$redirectTo=$transaction->redirect_url;
				}
				$this->logaction->log($this->service,"PayU Browser redirect - Payment not yet received - Redirected to Status page - Txnid: ".$_POST['txnid']." - Status: ".$_POST['status']);
				
				goto end;
				
			}
			else if(empty($transaction)) //Tx ID invalid, does not exist
			{
				$this->logaction->log($this->service,"PayU - Browser redirect - Transaction invalid - Tx: ".$_POST['txnid']);
				$data['views'] = array('common/public/error');
				$this->load->view(FRONTEND_TEMPLATE,$data);
				return;
			}

			end:
			if(!empty($transaction))
			{
				$this->payment_model->updatePayuTransaction($_POST);
			}
			if(isset($_GET['app']))
			{
				$type=1;
				if(isset($_GET['type']) && $_GET['type']==2)
					$type=2;
				?>
				<script type="text/javascript">
					var getsomething = function(){
			            var arr=new Array();
			            arr[0]="<?PHP echo $app_vars['status']; ?>";
			            arr[1]="<?PHP echo $app_vars['order_id']; ?>";
			            arr[2]="<?PHP echo $app_vars['msg']; ?>";
			            return arr;
			        };
				</script>
				<?PHP
			}
			else
			{
				if(!isset($cdata['customData']['cartData']))
				{
					$this->session->set_userdata("payment_success","Payment processed successfully.");
				}
				$this->session->unset_userdata("transaction_process_online");
				redirect($redirectTo);
			}
		}
	}

	public function hook()
	{
		$data=json_decode(file_get_contents("php://input"));
		if(isset($data->notificationId) && $data->notificationId!='')
		{
			$ipn=$this->payment_model->getPayUIpn($data->merchantTransactionId,$data->notificationId);
			if(empty($ipn))
			{
				$error_message='';
				if(isset($data->error_message))
					$error_message=$data->error_message;

				$archivesDb = $this->load->database("data_archives",true,false);
				$archivesDb->insert("payu_ipn",array(
											"data"=>serialize($data),
											'date'=>date("Y:m:d H:i:s"),
											'merchantTransactionId'=>$data->merchantTransactionId,
											'paymentId'=>$data->paymentId,
											'amount'=>$data->amount,
											'status'=>strtolower($data->status),
											'paymentMode'=>$data->paymentMode,
											'customerEmail'=>$data->customerEmail,
											'customerName'=>$data->customerName,
											'customerPhone'=>$data->customerPhone,
											'udf1'=>$data->udf1,
											'udf2'=>$data->udf2,
											'udf3'=>$data->udf3,
											'udf4'=>$data->udf4,
											'udf5'=>$data->udf5,
											'productInfo'=>$data->productInfo,
											'additionalCharges'=>$data->additionalCharges,
											'notificationId'=>$data->notificationId,
											'error_message'=>$error_message
										));
				$this->logaction->log($this->service,"PayU IPN - IPN received - Txnid:".$data->merchantTransactionId." - Amount: ".$data->amount.
				" | Status: ".$data->status);
				
				$transaction=$this->payment_model->getTransaction($data->merchantTransactionId,'payu');
				if(!empty($transaction) && $transaction->t_status==0)
				{
					$tempIpn=$data;
					$reference=$data->udf4;
					//$tempInfo=$this->payment_model->getTempInfo($reference,1);
					$tempInfo=$this->payment_model->getTempInfo($reference);
					if(!empty($tempInfo) && $tempInfo->status==0)
					{
						$customData=unserialize($tempInfo->data);
						$orderId=0;
			    		if(isset($customData['order_id']))
			    			$orderId=$customData['order_id'];
						/*
						$this->cart_log_model->log("PayU hook recieved.<br>Tx ID:".$data->merchantTransactionId."<br>Status:".$data->status,
							$cdata['customData']['ashramData']->id,$cdata['customData']['cart_type']);*/
						$transaction=$this->payment_model->getTransaction($data->merchantTransactionId);
						if(isset($customData['cartData']))
						{
							$orderId=$this->payment_model->processPurchase($reference,$transaction,$tempInfo,$tempIpn);
							if($orderId)
							$this->orders_model->sendTransactionReceiptEmail($orderId,$data->merchantTransactionId);
							//$this->orders_model->sendTransactionReceiptEmailBcc($orderId,$data->merchantTransactionId);
						}
						else
						{
							$this->db->where("reference_id",$reference);
    						$this->db->update("temp_payment_info",array("status"=>1));
							$this->payment_model->tempInfoUpdateTx($reference,$data->merchantTransactionId);

							if($customData['created_by']==1)//Admin
								$sUrl=base_url.'orders/view/'.$orderId;
							else//User
								$sUrl=base_url.'myorders/view/'.$orderId;

							$flashvars='payment_success:1';
							$tData=array(
											"redirect_url"=>$sUrl,
											'flashvars'=>$flashvars,
											't_status'=>$t_status,
											'order_id'=>$orderId,
											'status'=>strtolower($data->status),
											'amount'=>$tempInfo->amount,
											'payu_mode'=>strtolower($data->paymentMode),
											'currency'=>$tempInfo->currency,
											'created_on'=>date("Y:m:d H:i:s"),
											't_status'=>1
										);
							
							
							$this->db->where("tx",$data->merchantTransactionId);
							$this->db->update("transaction",$tData);


							$this->orders_model->calculateDue($orderId);
							$this->logaction->log($this->service,"PayU receive payments - Partial payment - Ref:".$reference." | Txnid: ".$data->merchantTransactionId);
							$userData=unserialize($tempInfo->user_data);
							$this->order_log_model->log($orderId,
								"Paid amount: ".strtoupper($tempInfo->currency)." ".$tempInfo->amount."\nPayU\nTx ID:".$data->merchantTransactionId,$userData->id,$userData->username);
						}
					}
					else
					{
						$this->logaction->log($this->service,"PayU receive payments - Error: Direct payment reference invalid - Ref:".$reference." | Txnid: ".$data->merchantTransactionId);
						goto end;
					}
				}
				else
				{
					goto end;
				}

			}
			else
			{
				goto end;
			}
		}
		else
		{
			goto end;
		}
		if(0)
		{
			end:
			$vdata['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$vdata);
		}
	}

	/*public function hook_test()
	{
		$referer='none';
		if(isset($_SERVER['HTTP_REFERER']))
		{
			$referer=$_SERVER['HTTP_REFERER'];
		}

		$data=json_decode(file_get_contents("php://input"));
		$this->db->insert("payu_ipn",array('data'=>serialize($data),
										"customerName"=>$referer,
										"customerPhone"=>$_SERVER['REMOTE_ADDR']
									)
						);
		echo "Request captured";
	}*/
}
?>