<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Pagesadmin extends CI_Controller 
{
	var $service='content';
    function __construct() 
	{
        parent::__construct();
		$this->load->model('content/pages_model');
		$this->load->model('content/pages_category_model');
		$this->load->model('content/page_images_model');
		$this->load->model('content/page_attachments_model');
		$this->load->model('category/categories_model');
		$this->currentUser=$this->session->userdata("admin_data");
		$this->categories_model->fetchCategories();
    }
	function index()
	{
		$views = array( 'pages/admin/list' );
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Pages Listing");
	}

	public function listc($excel=0)
	{
		$list=$this->pages_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Pages Listing ajax request");
	}
	
	function add_edit_page($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$pageData=$this->pages_model->pageData($id);
			if(empty($pageData['page']))
			{
				$this->session->set_flashdata("page_error",1);
				redirect('pagesadmin');
			}
		}
		else
		{
			$pageData=array();
		}

		/*$rawinput=file_get_contents('php://input');
        echo $rawinput;
        exit;*/

		if(isset($_POST["save_page"]))
		{
			if(!isset($_POST['description']))
			{
				$this->session->set_flashdata("page_error",1);
				redirect('pagesadmin/add_edit_page/'.$id);
			}

			$this->form_validation->set_rules('name', 'Page Title', 'trim|required|min_length[6]|max_length[200]|pageNameCheck['.$id.']');
			$this->form_validation->set_rules('categories[]', 'Categories', 'checkCategories');
			$this->form_validation->set_rules('published_on', 'Publish Date', 'trim|required');
			$this->form_validation->set_rules('seo_keywords', 'SEO Keywords', 'trim|min_length[10]|max_length[500]');
			$this->form_validation->set_rules('seo_description', 'SEO Description', 'trim|min_length[10]|max_length[500]');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("page_error",1);
				redirect('pagesadmin/add_edit_page/'.$id);
				return;
			}
			$saved=$this->pages_model->save($id,$pageData);
			if($id==0)
			{
				$this->session->set_flashdata("page_created",1);
			}
			else
				$this->session->set_flashdata("page_saved",1);
			redirect('pagesadmin/add_edit_page/'.$saved);
			
		}
		else
		{
			if($id!='' && (empty($pageData['page'])) )
			{
				redirect('pagesadmin');
			}
			$views = array('pages/admin/add_edit_page');
			$data = array('views'=>$views,'id'=>$id);
			if(is_numeric($id) && $id)
			{
				$data['pageData']=$pageData;
			}
			$this->load->view(ADMIN_TEMPLATE,$data); 
		}
	}

	function uploadattachments($pageId=0)
	{
		$exts=$GLOBALS['site_settings']['blocked_file_types'];
		$excludedExtensions=explode("|",$exts);
		
		$json['files']=[];
		if(is_numeric($pageId) && $pageId)
		{
			$pageData=$this->pages_model->pageData($pageId);
			if(!empty($pageData) && isset($_FILES['files']))
			{
				foreach ($_FILES['files']['name'] as $key => $file) 
				{
					$ext=pathinfo ($_FILES['files']['name'][$key],PATHINFO_EXTENSION);

					if($_FILES['files']['size'][$key]==0)
					{
						$json['files'][] = array(
			            'name' => $file,
			            'size' => $_FILES['files']['size'][$key],
			            'type' => $_FILES['files']['type'][$key],
			            'error' => "Invalid File Size",
			            'status'=>0
			        	);
					}
					else if($ext=='' || in_array($ext,$excludedExtensions))
					{
						$json['files'][] = array(
			            'name' => $file,
			            'size' => $_FILES['files']['size'][$key],
			            'type' => $_FILES['files']['type'][$key],
			            'error' => "Extension not allowed",
			            'status'=>0
			        	);
					}
					else
					{	
		        		$json['files'][0]=$this->page_attachments_model->uploadFile($pageData);
		        		$json['files'][0]['name']=$file;
		        		$json['files'][0]['type']=$_FILES['files']['type'][$key];
		        		$json['files'][0]['size']=$_FILES['files']['size'][$key];
		        		$json['files'][0]['status']=1;
		        	}
				}
				echo json_encode($json);
			}
			else
			{
				foreach ($_FILES['files']['name'] as $key => $file) 
				{
					$json['files'][] = array(
		            'name' => $file,
		            'size' => $_FILES['files']['size'][$key],
		            'type' => $_FILES['files']['type'][$key],
		            'error' => "Invalid Page ID",
		            'status'=>0
		        	);
				}
				echo json_encode($json);
			}
		}
	}

	function deleteattachment($pageId=0,$attachmentId=0)
	{
		$data['flag']=0;
		if(is_numeric($pageId) && $pageId && is_numeric($attachmentId) && $attachmentId)
		{
			$pageData=$this->pages_model->pageData($pageId);
			if(!empty($pageData['page']))
			{
				$attachmentData=$this->page_attachments_model->attachmentData($attachmentId,$pageId);
				if(!empty($attachmentData))
				{
					$r=$this->page_attachments_model->delete($pageData,$attachmentData);
					if($r)
					{
						$data['flag']=1;
						$data['filename']=$attachmentData->filename;
					}
				}
			}
		}
		echo json_encode($data);
	}

	public function bulk_delete_attachments($pageId=0)
	{
		$data['flag']=0;
		$data['count']=0;
		$data['idsa']=array();
		if(is_numeric($pageId) && $pageId && isset($_POST['idsa']) && !empty($_POST['idsa']))
		{
			$pageData=$this->pages_model->pageData($pageId);
			if(!empty($pageData['page']))
			{
				foreach ($_POST['idsa'] as $attachmentId)
				{
					$attachmentData=$this->page_attachments_model->attachmentData($attachmentId,$pageId);
					if(!empty($attachmentData))
					{
						$r=$this->page_attachments_model->delete($pageData,$attachmentData);
						if($r)
						{
							$data['count']++;
							$data['idsa'][]=$attachmentId;
						}
					}
					$data['flag']=1;
				}
			}
		}
		echo json_encode($data);
	}

	public function updatefileinfoattachments($eventId=0)
	{
		if(is_numeric($eventId) && $eventId)
		{
			$eventData=$this->events_model->eventData($eventId);
			if(!empty($eventData['event']))
			{
				$this->form_validation->set_rules('value', 'Value', 'trim|max_length[200]');
		    	$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
		    	if($this->form_validation->run() == FALSE)
				{
					echo 0;
					return;
				}
				$this->event_attachments_model->updateInfo($_POST['pk'],'description',$_POST['value']);
			}
		}
	}
	public function updatefileinfoattachmentsorder($eventId=0)
	{
		if(is_numeric($eventId) && $eventId)
		{
			$eventData=$this->events_model->eventData($eventId);
			if(!empty($eventData['event']))
			{
				$this->form_validation->set_rules('value', 'Value', 'trim|numeric|max_length[3]');
		    	$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
		    	if($this->form_validation->run() == FALSE)
				{
					echo 0;
					return;
				}
				$this->event_attachments_model->updateInfo($_POST['pk'],'order',$_POST['value']);
			}
		}
	}

	/*public function updatefileinfoattachments($pageId=0)
	{
		if(is_numeric($pageId) && $pageId)
		{
			$pageData=$this->pages_model->pageData($pageId);
			if(!empty($pageData['page']))
			{
				if(isset($_POST['name']) && isset($_POST['value']) && $_POST['value']!='' && $_POST['name']!='')
				{
					$this->page_attachments_model->updateInfo($_POST['pk'],$_POST['name'],$_POST['value']);
				}
			}
		}
	}*/

	function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$pageData=$this->pages_model->pageData($id);
			if(empty($pageData['page']))
			{
				goto end;
			}
			$children=$this->pages_model->getChildren($id);
			if(!empty($children))
			{
				$data['flag']=2;
				goto end;
			}
			$r=$this->pages_model->delete($id,$pageData);
			if($r)
			{
				$data['flag']=1;
				$data['name']=$pageData['page']->name;
				$this->logaction->log($this->service,"Admin - Page '".$pageData['page']->name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}
	public function page_validate($eid=0,$pid=0)
	{
		if(is_numeric($eid) && is_numeric($pid) && $pid)
		{
			if($eid==$pid)
			{
				echo 2;
			}
			else
			{
				$parentPageData=$this->pages_model->pageData($pid);
				if(!empty($parentPageData['page']))
				{
					echo $parentPageData['page']->name."<br>".date("d M Y",strtotime($parentPageData['page']->published_on));
				}
				else
					echo 0;
			}
		}
		else
			echo 0;
	}
	public function titlecheck($id=0)
	{
		if(isset($_POST['title']) && $_POST['title']!='')
		{
			$slug=url_title($this->general_model->filtertext($_POST['title']));
			if(strlen($slug)<6)
				echo 0;
			else
			{
				if(is_numeric($id))
				{
					$flag=$this->pages_model->checkPageName($this->general_model->filtertext(trim($_POST['title'])),$id);
					if($flag==1)
						echo 2;
					else
						echo 1;
				}
				else
					echo 0;
			}
		}
	}

	public function report()
	{
		$views = array( 'pages/admin/report' );
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Pages Report");
	}

	public function listreport($excel=0)
	{
		$list=$this->pages_model->listReport($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Pages Report ajax request");
	}
}
?>