<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Orders extends CI_Controller 
{
	var $currentUser='';
	var $service='orders';
	var $currencies;
	var $payment_success_statuses=array("completed",'success','Success','release payment','Release Payment','approved','captured','paid');
    function __construct()
	{
        parent::__construct();
		$this->load->model("orders/orders_model");
		if($this->session->userdata('id'))
		{
			$this->currentUser=$this->session->userdata("admin_data");
		}
		if(is_single_ashram_site)
        { 
            $this->session->set_userdata("ashramId",default_ashram_id); 
		}
		$this->load->model('ashrams/ashrams_model');
		$this->load->model('ashrams/poojas_model');
		$this->load->model('ashrams/donations_model');
		$this->load->model('ashrams/subscriptions_model');
		$this->load->model('ashrams/store_model');
		$this->load->model('currencies_model');
		$this->load->model('orders/order_log_model');
		$this->load->model('payment_model');
		$this->load->model("orders/transaction_model");
		$this->load->model("orders/subscription_payments_model");
		$this->load->model('ashrams/ashrams_trust_accounts_model');
		$this->load->model('orders/payflow_logs_model');
		$this->load->model('paypal_model');
		$this->load->model("subscriptions/donors_model");
		$this->load->model("pets_model");
		$this->load->model("foreign_currencies_model");
		$this->load->model("refunds_history_model");
		$this->load->model('ashrams/poojas_categories_model');
		$this->load->model('ashrams/subscriptions_categories_model');
		$this->load->model('ashrams/subscriptions_categories_model');
		$this->load->model('ashrams/store_categories_model');
		$this->load->model('ashrams/donations_categories_model');
		$this->load->model('ashrams/donations_groups_model');
		$this->currencies=$this->currencies_model->getByAshram(0);

		//==========Load encryption library=============//

    	$this->load->library('encryption');

		$this->encryption->initialize(
		        array(
		                'cipher' => 'aes-256',
		                'mode' => 'cbc',
		                'key' => file_get_contents("../app_configs/aes_key")
		        )
		);

    	//==========Load encryption library=============//

    }
    public function index()
	{
		$views = array( 'orders/admin/list' );
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Sevas Listing");
	}

	public function poojas()
	{
		$views = array( 'orders/admin/list_poojas' );
		$data = array('views'=>$views);
		if(is_single_ashram_site){
			$this->session->set_userdata("ashramId",default_ashram_id);
		}
		if($this->session->userdata("ashramId"))
		{
			$data['categories'] = $this->poojas_categories_model->getCategoriesListByAshramId($this->session->userdata("ashramId"));	
			$data['poojas'] = $this->poojas_model->getByAshramCategoryId($this->session->userdata("ashramId"),$this->session->userdata("pooja_categoryId"));
		}
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Pooja Sevas Listing");
	}
	public function poojas_prasadam()
	{
		$views = array( 'orders/admin/list_poojas_prasadam' );
		$data = array('views'=>$views);
		$this->load->model("user/users_model");
		$data['countries']=$this->users_model->getCountries();
		
		if($this->session->userdata("ashramId"))
		{
			$data['poojas']=$this->poojas_model->getByAshramId($this->session->userdata("ashramId"));
		}
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Poojas prasadam report");
	}

	public function donations()
	{
		$views = array( 'orders/admin/list_donations' );
		$data = array('views'=>$views);
		if(is_single_ashram_site){
			$this->session->set_userdata("ashramId",default_ashram_id);
		}
		if($this->session->userdata("ashramId"))
		{
			$data['categories'] = $this->donations_categories_model->getCategoriesListByAshramId($this->session->userdata("ashramId"));
			$data['groups'] = $this->donations_groups_model->getGroupsListByAshramId($this->session->userdata("ashramId"));
			$data['donations'] = $this->donations_model->getByAshramCategoryId($this->session->userdata("ashramId"),$this->session->userdata("donation_categoryId"));
		}
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Donation Sevas Listing");
	}

	public function donation_sevas($ashram_id=0, $result="results", $secret_key="")
	{
		$data = array();
		$ashramchecks = [];
		$data['ashrams']=$this->ashrams_model->getList();
		$data['ashram_id']=$ashram_id;
		$data['secret_key']=$secret_key;
		$data['item_ids']=array();
		if(isset($_GET['item_ids']) && $_GET['item_ids']!='')
		{
			$data['item_ids'] = explode(',', $_GET['item_ids']);
		}
		foreach($data['ashrams'] as $thisAshram)
		{
			array_push($ashramchecks,$thisAshram->id);
		}
		$allSecretkeys = array(vishwashantipadayatra2022_public_display_secret_key,shodasha_datta_kshetra_pada_yatra_public_display_secret_key);
		if($secret_key=="" || !in_array($secret_key, $allSecretkeys) || $result!="results" || !in_array($ashram_id, $ashramchecks) || !in_array($ashram_id, public_donations_allowed_ashrams))
		{
    		$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
		}
		if($ashram_id>0)
		{
			$data['donations']=$this->donations_model->getByAshramId($ashram_id);
			$data['ashramData']=$this->ashrams_model->ashramData($ashram_id);
		}
		$this->load->view('orders/public/list_donations',$data);
		$this->logaction->log($this->service,"Public - Viewed Donation Sevas Listing with secret key");
	}

	public function list_donation_sevas($excel=0)
	{
		$allSecretkeys = array(vishwashantipadayatra2022_public_display_secret_key,shodasha_datta_kshetra_pada_yatra_public_display_secret_key);
		if(isset($_POST['secret_key']) && in_array($_POST['secret_key'], $allSecretkeys))
		{
			$list=$this->orders_model->listPublicDonations($excel);
			echo json_encode($list);
			$this->logaction->log($this->service,"Public - Viewed Donation Sevas Listing ajax request with secret key");
		}
		else
		{
			echo 'login';
		}
	}

	public function store()
	{
		$views = array( 'orders/admin/list_store' );
		$data = array('views'=>$views);
		if(is_single_ashram_site){
			$this->session->set_userdata("ashramId",default_ashram_id);
		}
		if($this->session->userdata("ashramId"))
		{
			$data['categories'] = $this->store_categories_model->getCategoriesListByAshramId($this->session->userdata("ashramId"));
			$data['items']=$this->store_model->getByAshramCategoryId($this->session->userdata("ashramId"),$this->session->userdata("store_categoryId"));
		}
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed store Orders Listing");
	}

	public function subscriptions()
	{
		$views = array( 'orders/admin/list_subscriptions' );
		$data = array('views'=>$views);
		if(is_single_ashram_site){
			$this->session->set_userdata("ashramId",default_ashram_id);
		}
		if($this->session->userdata("ashramId"))
		{
			$data['categories'] = $this->subscriptions_categories_model->getCategoriesListByAshramId($this->session->userdata("ashramId"));
			$data['subscriptions']=$this->subscriptions_model->getSubscriptionsByAshramId($this->session->userdata("ashramId"),$this->session->userdata("subscription_categoryId"));
		}
		$data['ashrams']=$this->ashrams_model->getList();
		$data['pets']=$this->pets_model->getAll();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Subscriptions Sevas Listing");
	}

	public function subscriptions_report()
	{
		$views = array( 'orders/admin/list_recurring_payments' );
		$data = array('views'=>$views);
		if($this->session->userdata("ashramId"))
		{
			$data['subscriptions']=$this->subscriptions_model->getSubscriptionsByAshramId($this->session->userdata("ashramId"));
			$data['ashramTrusts']=$this->ashrams_trust_accounts_model->getAllTrustsBasicDetailsByAshramId($this->session->userdata("ashramId"));
		}
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Recurrings report Listing");
	}

	public function refunds_replace_logs()
	{
		$views = array( 'orders/admin/list_refund_replace_items' );
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Donation Sevas Listing");
	}

	public function rrlists($excel=0)
	{
		$list=$this->refunds_history_model->listAdminRefundReplaceLogs($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Order Items Refunds Replace Listing ajax request");
	}

	public function failed_sevas()
	{
		$views = array( 'orders/admin/list_failed_sevas' );
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Failed Sevas Listing");
	}

	public function listfs($excel=0)
	{
		$this->load->model("orders/orders_temp_model");
		$list=$this->orders_temp_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Failed Sevas Listing ajax request");
	}

	public function list_rr($excel=0)
	{
		$list=$this->subscription_payments_model->listAdminRecurringPayments($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Sevas Listing ajax request");
	}

	#Author: Baji
	#Branch: bajidotwork_DPDEV-failedsubscriptionpayments
	public function failed_subscriptions()
	{
		$views = array( 'orders/admin/list_failed_subscription_payments' );
		$data = array('views'=>$views);
		if($this->session->userdata("ashramId"))
		{
			$data['subscriptions']=$this->subscriptions_model->getSubscriptionsByAshramId($this->session->userdata("ashramId"));
		}
		$data['ashrams']=$this->ashrams_model->getList();
		$data['pets']=$this->pets_model->getAll();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Failed Subscription Sevas Listing");
	}

	public function mismatch_ashram_orders()
	{
		$views = array( 'orders/admin/list_mismatch_trust_orders' );
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Trust mismatch sevas listing");
	}

	public function misc_ordersc($excel=0)
	{
		$list=$this->orders_model->listAdminMismatchOrders($this->session->userdata("ashramId"),$excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Trust mismatch sevas Listing ajax request");
	}

	/**
	 * List All One Time Failed Payments
	 * @gitBranch: bajidotwork_DPDEV-425
	 * @version   1.1
	 * @author    Baji Shaik <bajidotwork@gmail.com>
	 */
	public function failed_onetime()
	{
		$views = array( 'orders/admin/list_failed_onetime_payments' );
		$data = array('views'=>$views);
		if($this->session->userdata("ashramId"))
		{
			$data['donations']=$this->donations_model->getSubscriptionsByAshramId($this->session->userdata("ashramId"));
		}
		$data['ashrams']=$this->ashrams_model->getList();
		$data['pets']=$this->pets_model->getAll();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Failed OneTime Payments Listing");
	}

	/**
	 * List All Offline Payments
	 * @gitBranch: bajidotwork_DPDEV-425
	 * @version   1.1 [27th June 2019]
	 * @author    Baji Shaik <bajidotwork@gmail.com>
	 */
	public function offline_transactions()
	{
		$views = array( 'orders/admin/list_offline_transactions' );
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Offline Transactions Listing");
	}

	/**
	 * List All Cancelled Orders
	 * @gitBranch: bajidotwork_DPDEV-808
	 * @version   1.1 [09th Dec 2020]
	 * @author    Baji Shaik <bajidotwork@gmail.com>
	 */
	public function cancelled_orders()
	{
		$views = array( 'orders/admin/list_cancelled_orders' );
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Cancelled sevas Listing");
	}

	public function transactions()
	{
		$views = array( 'orders/admin/list_transactions' );
		$data = array('views'=>$views);
		if($this->session->userdata("ashramId"))
		{
			$data['ashramTrusts']=$this->ashrams_trust_accounts_model->getAllTrustsBasicDetailsByAshramId($this->session->userdata("ashramId"));
		}
		// echo '<pre>'; print_r($data['ashramTrusts']); die();
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed transactions Listing");
	}
	public function cart_logs()
	{
		if(isset($this->currentUser->is_currency_specific) && $this->currentUser->is_currency_specific==1)
		{
			redirect('admin');
			return;
		}
		$views = array( 'orders/admin/list_cart_log' );
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed cart log Listing");
	}

	public function listc($excel=0)
	{
		$list=$this->orders_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Sevas Listing ajax request");
	}

	public function listco($excel=0)
	{
		$list=$this->orders_model->listAdminCancelledOrders($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Cancelled Sevas Listing ajax request");
	}
	public function listp($excel=0)
	{
		$list=$this->orders_model->listAdminPoojas($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Pooja Sevas Listing ajax request");
	}
	public function listPoojasByDate($excel=0)
	{
		$list=$this->orders_model->listAdminPoojasByDate($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Pooja Sevas Listing ajax request");
	}
	public function listDonationsByDate($excel=0)
	{
		$list=$this->orders_model->listAdminDonationsByDate($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Donation Sevas by Date Listing ajax request");
	}
	public function listpreport($excel=0)
	{
		$list=$this->orders_model->listAdminPoojasPrasadam($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Poojas prasadam report ajax request");
	}
	public function listd($excel=0)
	{
		$list=$this->orders_model->listAdminDonations($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Donation Sevas Listing ajax request");
	}
	public function lists($excel=0)
	{
		$list=$this->orders_model->listAdminStore($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Store Orders Listing ajax request");
	}

	public function listsubs($excel=0)
	{
		$list=$this->orders_model->listAdminSubscriptions($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Subscriptions Sevas Listing ajax request");
	}

	#Author: Baji
	#Branch: bajidotwork_DPDEV-failedsubscriptionpayments
	public function listfailedsubs($excel=0)
	{
		$list=$this->orders_model->listAdminFailedSubscriptions($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Failed Subscriptions Sevas Listing ajax request");
	}

	/**
	 * List All One Time Failed Payments
	 * @gitBranch: bajidotwork_DPDEV-425
	 * @version   1.1
	 * @author    Baji Shaik <bajidotwork@gmail.com>
	 */
	public function listonetimefailedpayments($excel=0)
	{
		$list=$this->orders_model->listAdminonetimeFailedpayments($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Failed OneTime Payments Listing ajax request");
	}

	/**
	 * Ajax Listing for All Offline Trans
	 * @gitBranch: bajidotwork_DPDEV-425
	 * @version   1.1 [27 June 2019]
	 * @author    Baji Shaik <bajidotwork@gmail.com>
	 */
	public function listofflinetrans($excel=0)
	{
		$list=$this->transaction_model->listAdminOfflineTrans($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Donation Sevas Listing ajax request");
	}

	public function listtrans($excel=0)
	{
		$list=$this->transaction_model->listAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Donation Sevas Listing ajax request");
	}

	public function view($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$orderDataRow=$this->orders_model->orderRowById($id);
			if(empty($orderDataRow))
			{
				$this->session->set_flashdata("order_error",1);
				redirect("orders");
			}
			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderDataRow->ashram_id!=$this->session->userdata("ashramId"))
					{
						$this->session->set_flashdata("order_error",1);
						redirect("orders");
					}
				}
				else
				{
					$this->session->set_flashdata("order_error",1);
					redirect("orders");
				}
			}

			if(isset($this->currentUser->is_currency_specific) && $this->currentUser->is_currency_specific==1)
			{
				if(isset($this->currentUser->currencies) && $this->currentUser->currencies!='')
				{
					$accessableCurrencies = explode(',', $this->currentUser->currencies);
					if(!in_array($orderDataRow->currency, $accessableCurrencies))
					{
						redirect('orders');
						return;
					}
				}
			}

			$this->load->model("locations_model");
			$this->load->model("payment_model");
			$views = array( 'orders/admin/view' );
			$data = array('views'=>$views);

			$orderData['order'] = $orderDataRow;
			$orderData['order_items'] = $this->orders_model->orderItemsByOrderId($id);
			$orderData['order_items_files'] = $this->orders_model->orderFilesByOrderId($id);

			$data ['family_donors'] = [];
	      	if($orderData['order']->user_id!='')
	      	{
	      		$this->load->model("user/users_model");
				$sso_user_id = $this->users_model->getSSOUserID($orderData['order']->user_id);
				$data ['family_donors'] = $this->donors_model->getUserUnhideDonors($sso_user_id);
	      	}
			
			$data['countryData']=$this->locations_model->getCountryByCode($orderData['order']->country);

			$this->load->model("credit_cards_model");
			$data['credit_cards']=$this->credit_cards_model->getCards($orderData['order']->user_id);

			if($orderData['order']->trust_id>0)
			{
				$data['trustData']=$this->ashrams_trust_accounts_model->trustData($orderData['order']->trust_id);
			}
			else
			{
				$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($orderData['order']->ashram_id,$orderData['order']->order_type);
		    	$trustsArray=array();
		    	foreach ($trusts as $trustData)
		    	{
		    		$trustsArray[$trustData->currency]=$trustData;
		    	}
		    	if($orderData['order']->currency=='inr')
		    	{
		    		$data['trustData']=$trustsArray['inr'];
		    	}
		    	if($orderData['order']->currency=='usd')
		    	{
		    		$data['trustData']=$trustsArray['usd'];
		    	}
			}
			
	    	$data['orderData']=$orderData;
			$this->load->view(ADMIN_TEMPLATE,$data);
			$this->logaction->log($this->service,"Admin - Viewed Seva ");
		}
		else
		{
			redirect("orders");
		}
	}

	public function checkOrderExists($id=0)
	{
		$tobeReturndata = [];
		$tobeReturndata['status'] = 1;
		$tobeReturndata['error_message'] = "";
		$orderData=$this->orders_model->orderData($id);
		if(empty($orderData['order']))
		{
			$tobeReturndata['status'] = 0;
			$tobeReturndata['error_message'] = "This seva is not available";
		}
		if($this->currentUser->roles!=1)
		{
			if($this->session->userdata("ashramId"))
			{
				if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
				{
					$tobeReturndata['status'] = 0;
					$tobeReturndata['error_message'] = "You can not access other ashram sevas";
				}
			}
			else
			{
				$tobeReturndata['status'] = 0;
				$tobeReturndata['error_message'] = "You can not access other ashram sevas";
			}
		}
		
		if($tobeReturndata['status']==1)
		{
			$tobeReturndata['orderData'] = $orderData;
		}
		return $tobeReturndata;
	}

	public function order_summary($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$resultdata = $this->checkOrderExists($id);
			if($resultdata['status']==0)
			{
				echo $resultdata['error_message'];
				exit;
			}
			$this->load->model("locations_model");
			$data['id']=$id;
			$data['orderData']=$resultdata['orderData'];
			$data['countryData']=$this->locations_model->getCountryByCode($resultdata['orderData']['order']->country);
			$data['transactions']=$this->transaction_model->getTransactionsByOrderAlt($id);
			if($resultdata['orderData']['order']->trust_id>0)
			{
				$data['trustData']=$this->ashrams_trust_accounts_model->trustData($resultdata['orderData']['order']->trust_id);
			}
			else
			{
				$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($resultdata['orderData']['order']->ashram_id,$resultdata['orderData']['order']->order_type);
		    	$trustsArray=array();
		    	foreach ($trusts as $trustData)
		    	{
		    		$trustsArray[$trustData->currency]=$trustData;
		    	}
		    	$data['trustData']=$trustsArray[$resultdata['orderData']['order']->currency];
		    }
	    	$this->load->model("credit_cards_model");
			$data['credit_cards']=$this->credit_cards_model->getCards($resultdata['orderData']['order']->user_id);
			echo $this->load->view("orders/admin/_order_summary",$data,true);
		}
		else
		{
			echo "This seva is not available";
		}
	}

	public function order_payments($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$resultdata = $this->checkOrderExists($id);
			if($resultdata['status']==0)
			{
				echo $resultdata['error_message'];
				exit;
			}
			$this->load->model("locations_model");
			$data['orderData']=$resultdata['orderData'];
			$this->load->model("credit_cards_model");
			$data['countryData']=$this->locations_model->getCountryByCode($resultdata['orderData']['order']->country);
			$data['transactions']=$this->transaction_model->getTransactionsByOrderAlt($id);
			$data['credit_cards']=$this->credit_cards_model->getCards($resultdata['orderData']['order']->user_id);
			if(isset($data['orderData']['order']->trust_id) && $data['orderData']['order']->trust_id>0)
			{
				$data['trustData']=$this->ashrams_trust_accounts_model->trustData($data['orderData']['order']->trust_id);
			}
			echo $this->load->view("orders/admin/_order_payments",$data,true);
		}
		else
		{
			echo "This seva is not available";
		}
	}

	public function order_downloads($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$resultdata = $this->checkOrderExists($id);
			if($resultdata['status']==0)
			{
				echo $resultdata['error_message'];
				exit;
			}
			$this->load->model("locations_model");
			$data['orderData']=$resultdata['orderData'];
			echo $this->load->view("orders/admin/_order_downloads",$data,true);
		}
		else
		{
			echo "This seva is not available";
		}
	}

	public function order_activity_log($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$resultdata = $this->checkOrderExists($id);
			if($resultdata['status']==0)
			{
				echo $resultdata['error_message'];
				exit;
			}
			$data['orderData']=$resultdata['orderData'];
			echo $this->load->view("orders/admin/_order_activity_log",$data,true);
		}
		else
		{
			echo "This seva is not available";
		}
	}

	public function order_all_transactions($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$resultdata = $this->checkOrderExists($id);
			if($resultdata['status']==0)
			{
				echo $resultdata['error_message'];
				exit;
			}
			$this->load->model("locations_model");
			$data['orderData']=$resultdata['orderData'];
			$this->load->model("credit_cards_model");
			$data['countryData']=$this->locations_model->getCountryByCode($resultdata['orderData']['order']->country);
			$data['credit_cards']=$this->credit_cards_model->getCards($resultdata['orderData']['order']->user_id);

			$data['id']=$id;
			$data['txData']=$this->payment_model->getTransaction($resultdata['orderData']['order']->transaction_id);
			$data['transactions']=$this->transaction_model->getTransactionsByOrderAlt($id);
			echo $this->load->view("orders/admin/_order_all_transactions",$data,true);
		}
		else
		{
			echo "This seva is not available";
		}
	}

	public function order_donation_receipt($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$resultdata = $this->checkOrderExists($id);
			if($resultdata['status']==0)
			{
				echo $resultdata['error_message'];
				exit;
			}
			$this->load->model("locations_model");
			$data['orderData']=$resultdata['orderData'];
			$data['countryData']=$this->locations_model->getCountryByCode($resultdata['orderData']['order']->country);
			echo $this->load->view("orders/admin/_order_donation_receipt",$data,true);
		}
		else
		{
			echo "This seva is not available";
		}
	}

	public function updatenote($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$orderData=$this->orders_model->orderData($id);
			if(empty($orderData['order']))
			{
				echo 0;
				exit;
			}

			$this->form_validation->set_rules('value', 'Value', 'trim|min_length[6]|max_length[500]');
	    	$this->form_validation->set_rules('pk', 'ID', 'trim|required');
	    	if($this->form_validation->run() == FALSE)
			{
				echo 0;
				return;
			}
			$item=array();
			foreach ($orderData['order_items'] as $orderItem)
			{
				if($this->input->post("pk")==$orderItem->order_item_id)
				{
					$item=$orderItem;
					break;
				}
			}
			
			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
					{
						echo 0;
						return;
					}
				}
			}

			$this->orders_model->updateNote($orderData,$item,$this->input->post("value"));
			echo 1;
		}
		else
		{
			echo 0;
			return;
		}
	}
	public function updatePitruPakshaDeceasedPersonName($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$orderData=$this->orders_model->orderData($id);
			if(empty($orderData['order']))
			{
				echo 0;
				exit;
			}

			$this->form_validation->set_rules('value', 'Value', 'trim|min_length[3]|max_length[100]');
	    	$this->form_validation->set_rules('pk', 'ID', 'trim|required');
	    	if($this->form_validation->run() == FALSE)
			{
				echo 0;
				return;
			}
			$item=array();
			foreach ($orderData['order_items'] as $orderItem)
			{
				if($this->input->post("pk")==$orderItem->order_item_id)
				{
					$item=$orderItem;
					break;
				}
			}
			
			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
					{
						echo 0;
						return;
					}
				}
			}

			$this->orders_model->PitruPakshaDeceasedPersonName($orderData,$item,$this->input->post("value"));
			echo 1;
		}
		else
		{
			echo 0;
			return;
		}
	}
	public function updatePersonalnote($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$orderData=$this->orders_model->orderData($id);
			if(empty($orderData['order']))
			{
				echo 0;
				exit;
			}

			$this->form_validation->set_rules('value', 'Value', 'trim|min_length[6]|max_length[500]');
	    	$this->form_validation->set_rules('pk', 'ID', 'trim|required');
	    	if($this->form_validation->run() == FALSE)
			{
				echo 0;
				return;
			}
			$item=array();
			foreach ($orderData['order_items'] as $orderItem)
			{
				if($this->input->post("pk")==$orderItem->order_item_id)
				{
					$item=$orderItem;
					break;
				}
			}
			
			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
					{
						echo 0;
						return;
					}
				}
			}

			$this->orders_model->updatePersonalNote($orderData,$item,$this->input->post("value"));
			echo 1;
		}
		else
		{
			echo 0;
			return;
		}
	}

	public function updatePrasadamStatus($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$orderData=$this->orders_model->orderData($id);
			if(empty($orderData['order']))
			{
				echo 0;
				exit;
			}
			
			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
					{
						echo 0;
						return;
					}
				}
			}

			$this->orders_model->updatePrasadamStatus($id,$this->input->post("value"));
			echo 1;
		}
		else
		{
			echo 0;
			return;
		}
	}
	public function updateshippingaddress($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$orderData=$this->orders_model->orderData($id);
			if(empty($orderData['order']))
			{
				echo 0;
				exit;
			}

			$this->form_validation->set_rules('value[address1]', 'Address 1', 'trim|required|min_length[3]|max_length[200]');
	    	$this->form_validation->set_rules('value[address2]', 'Address 2', 'trim|min_length[3]|max_length[200]');
	    	$this->form_validation->set_rules('value[address3]', 'Address 3', 'trim|min_length[3]|max_length[200]');
	    	$this->form_validation->set_rules('value[city]', 'City', 'trim|required|min_length[2]|max_length[100]');
	    	$this->form_validation->set_rules('value[state]', 'State', 'trim|required|min_length[2]|max_length[100]');
	    	$this->form_validation->set_rules('value[country]', 'Country', 'trim|required|countryCheck');
	    	$this->form_validation->set_rules('pk', 'ID', 'trim|required');
	    	if($this->form_validation->run() == FALSE)
			{
				echo 0;
				return;
			}

			$item=array();
			foreach ($orderData['order_items'] as $orderItem)
			{
				if($this->input->post("pk")==$orderItem->id)
				{
					$item=$orderItem;
					break;
				}
			}
			
			

			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
					{
						echo 0;
						return;
					}
				}
			}

			$this->orders_model->updateShippingAddress($orderData,$item,$this->input->post("value"));
			echo 1;
		}
		else
		{
			echo 0;
			return;
		}
	}

	public function getManageCards($userId=0)
	{
		if(is_numeric($userId) && $userId)
		{
			$this->load->model("credit_cards_model");
			$data['credit_cards']=$this->credit_cards_model->getCards($userId);
			echo $this->load->view("ashrams/public/_saved_cards_template",$data,true);
		}
	}
	public function getCreditCards($userId=0)
	{
		if(is_numeric($userId) && $userId)
		{
			$this->load->model("credit_cards_model");
			$data['credit_cards']=$this->credit_cards_model->getCards($userId);
			echo $this->load->view("ashrams/public/_dynamic_cards",$data,true);
		}
	}
	public function deletecard($id)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$this->load->model("credit_cards_model");
			$creditCard=$this->credit_cards_model->getCard($id);
			if(empty($creditCard))
			{
				goto end;
			}
			$this->credit_cards_model->delete($id);
			$this->load->model("user/users_model");
	        $userData = $this->users_model->userData($creditCard->user_id);
	        $data['userData']=$userData;
	        $data['card_number']=$creditCard->card_number;
	        $body=$this->load->view("orders/public/_email_saved_card_delete",$data,true);
	        $subject='Card Delete Notification';
	        $this->email_extension->sendOrdersMail(
	                                        "card_notifications",
	                                        $userData->id,
	                                        $userData->firstname." ".$userData->lastname,
	                                        $userData->email,
	                                        $subject,
	                                        $body,
	                                        '',
	                                        1);
			$data['card_number']=$creditCard->card_number;
			$data['flag']=1;
			$data['credit_cards']=$this->credit_cards_model->getCards($creditCard->user_id);
			$data['template']=$this->load->view("ashrams/public/_saved_cards_template",$data,true);
		}
		end:
		echo json_encode($data);
	}

	public function updategiftemail($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$orderData=$this->orders_model->orderData($id);
			if(empty($orderData['order']))
			{
				echo 0;
				exit;
			}

			$this->form_validation->set_rules('value', 'Email ID','trim|required|valid_email_custom|min_length[6]|max_length[100]');
	    	$this->form_validation->set_rules('pk', 'ID', 'trim|required');
	    	if($this->form_validation->run() == FALSE)
			{
				echo 0;
				return;
			}

			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
					{
						echo 0;
						return;
					}
				}
			}

			$item=array();
			foreach ($orderData['order_items'] as $orderItem)
			{
				if($this->input->post("pk")==$orderItem->id)
				{
					$item=$orderItem;
					break;
				}
			}

			$downloads=0;

			foreach($orderData['order_items_files'] as $itemFiles)
			{
				if($this->input->post("pk")==$itemFiles->order_item_id)
				{
					$downloads+=$itemFiles->downloads;
				}
			}

			if(empty($item) || $downloads>0)
			{
				echo 2;
				return;
			}

			$this->orders_model->updateGiftEmail($orderData,$item,$this->input->post("value"));
			echo 1;
		}
		else
		{
			echo 0;
			return;
		}
	}
	public function updategiftname($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$orderData=$this->orders_model->orderData($id);
			if(empty($orderData['order']))
			{
				echo 0;
				exit;
			}
			$this->form_validation->set_rules('value', 'Name','trim|required|min_length[2]|max_length[60]');
	    	$this->form_validation->set_rules('pk', 'ID', 'trim|required');
	    	if($this->form_validation->run() == FALSE)
			{
				echo 0;
				return;
			}

			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
					{
						echo 0;
						return;
					}
				}
			}

			$item=array();
			foreach ($orderData['order_items'] as $orderItem)
			{
				if($this->input->post("pk")==$orderItem->id)
				{
					$item=$orderItem;
					break;
				}
			}

			$downloads=0;

			foreach($orderData['order_items_files'] as $itemFiles)
			{
				if($this->input->post("pk")==$itemFiles->order_item_id)
				{
					$downloads+=$itemFiles->downloads;
				}
			}

			if(empty($item) || $downloads>0)
			{
				echo 2;
				return;
			}

			$this->orders_model->updateGiftName($orderData,$item,$this->input->post("value"));
			echo 1;
		}
		else
		{
			echo 0;
			return;
		}
	}
	public function sendorderdetails($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$orderData=$this->orders_model->orderData($id);
			if(empty($orderData['order']))
				return 0;

			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
						return 0;
				}
			}

			$flag=$this->orders_model->sendOrderDetailsEmail($id);
			echo $flag;
		}
		else
			echo 0;
	}

	public function send_collect_payment_email($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$orderData=$this->orders_model->orderData($id);
			if(empty($orderData['order']))
				return 0;

			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
						return 0;
				}
			}
			if($orderData['order']->payment_status!=1)
				$pendingAmount=$orderData['order']->total_price-$orderData['order']->paid;
			else
				$pendingAmount=0;

			if($orderData['order']->payment_alt_mode=='cash' && $orderData['order']->payment_status!=1 && $pendingAmount>0 && $orderData['order']->is_manual_payment==0)
			{
				$flag=$this->orders_model->sendCollectPaymentEmail($id);
				echo $flag;
			}
			else
				echo 0;
		}
		else
			echo 0;
	}
	/*public function sendorderreceipt($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$orderData=$this->orders_model->orderData($id);
			if(empty($orderData['order']))
				return 0;

			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
						return 0;
				}
			}

			$flag=$this->orders_model->sendOrderReceiptEmail($id);
			echo $flag;
		}
		else
			echo 0;
	}*/
	public function sendtransactionreceipt($id=0,$tx='')
	{
		if(is_numeric($id) && $id && $tx!='')
		{
			$orderData=$this->orders_model->orderData($id);
			if(empty($orderData['order']))
				return 0;

			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
						return 0;
				}
			}
			$transaction=$this->transaction_model->getTransactionByTx($tx);
			if(empty($transaction))
			{
				return 0;
			}
			if($transaction->order_id!=$id)
			{
				return 0;
			}

			$flag=$this->orders_model->sendTransactionReceiptEmail($id,$tx);
			echo $flag;
		}
		else
			echo 0;
	}

	public function sendsubscriptionpayment($id=0,$order_item_id=0,$payment_id=0)
	{
		if(is_numeric($id) && $id && is_numeric($order_item_id) && $order_item_id && is_numeric($payment_id) && $payment_id)
		{
			$orderData=$this->orders_model->orderData($id);
			if(empty($orderData['order']))
				return 0;

			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
						return 0;
				}
			}

			$flag=$this->orders_model->sendSubscriptionPaymentEmail($id,$order_item_id,$payment_id);
			echo $flag;
		}
		else
			echo 0;
	}
	public function retrysubscriptionpayment($id=0,$order_item_id=0,$payment_id=0)
	{
		if(is_numeric($id) && $id && is_numeric($order_item_id) && $order_item_id && is_numeric($payment_id) && $payment_id)
		{
			$orderData=$this->orders_model->orderData($id);
			if(empty($orderData['order']))
				return 0;

			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
						return 0;
				}
			}

			$flag=$this->orders_model->retrySubscriptionPayment($id,$order_item_id,$payment_id);
			$this->load->model("paypal_model");
			$result=$this->orders_model->readSubscriptionsPaypal($id,$order_item_id);
			echo $flag;
		}
		else
			echo 0;
	}
	
	public function issuetokens($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$orderData=$this->orders_model->orderData($id);
			if(empty($orderData['order']))
				return 0;

			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
						return 0;
				}
			}
			
			$flag=$this->orders_model->tokenIssued($id);
			echo $flag;
		}
		else
			echo 0;
	}

	public function sendordergiftemail($id=0,$itemid=0)
	{
		if(is_numeric($id) && $id)
		{
			$orderData=$this->orders_model->orderData($id);
			if(empty($orderData['order']))
			{
				echo 0;
				return;
			}

			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
					{
						echo 0;
						return;
					}
				}
			}

			$item=array();
			foreach ($orderData['order_items'] as $orderItem)
			{
				if($itemid==$orderItem->id)
				{
					$item=$orderItem;
					break;
				}
			}

			$downloads=0;

			foreach($orderData['order_items_files'] as $itemFiles)
			{
				if($itemid==$itemFiles->order_item_id)
				{
					$downloads+=$itemFiles->downloads;
				}
			}

			if(empty($item) || empty($orderData['order_items_files']) || $downloads>0)
			{
				echo 2;
				return;
			}

			$this->orders_model->sendOrderGiftEmail($id,$itemid);
			echo 1;
		}
		else
			echo 0;
	}

	public function update_dispatch($order_id=0,$status=0)
	{
		$result['status']=0;
		if(is_numeric($order_id) && $order_id && is_numeric($status) && in_array($status,array(0,1,2,3)))
		{
			$orderData=$this->orders_model->orderData($order_id);
			if(empty($orderData['order']))
			{
				goto end;
			}
			/*if($orderData['order']->order_type!=3)
			{
				goto end;
			}
			if($orderData['order']->dispatched==1)
			{
				$result['status']=2;//Already dispatched
				goto end;
			}*/
			$this->form_validation->set_rules('dispatch_note', 'Shipping note','trim|required|min_length[10]|max_length[1000]');
	    	if($this->form_validation->run() == FALSE)
			{
				goto end;
			}
			$this->orders_model->update_dispatch($orderData,$status,$this->input->post("dispatch_note"));
			if($this->input->get("flag")==1)
			{
				$this->session->set_flashdata("dispatch_updated","1");
			}
			$result['status']=1;
		}
		end:
		header("Content-Type:application/json");
		echo json_encode($result);
	}

	public function updateorderCancelFlag($order_id=0,$cancel_status=0)
	{
		$result['status']=0;
		if(is_numeric($order_id) && $order_id && is_numeric($cancel_status) && in_array($cancel_status,array(0,1)))
		{
			$orderData=$this->orders_model->orderData($order_id);

			$sevaOrGift = 'Seva';
			if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
			{
				$sevaOrGift = 'Gift';
			}
			if(empty($orderData['order']))
			{
				goto end;
			}
			if($cancel_status == 1)
			{
				if($orderData['order']->is_cancelled == 1)
				{
					$result['status']=2;
					goto end;
				}
				$this->form_validation->set_rules('cancel_reason', 'Cancel Reason','trim|required|min_length[10]|max_length[1000]');
				$this->form_validation->set_rules('cancel_date', 'Cancel Date','trim|required');
		    	if($this->form_validation->run() == FALSE)
				{
					goto end;
				}
				if(($orderData["order"]->order_type == 4) || ($orderData["order"]->subscription_mixed_order == 1) && $orderData["order"]->payment_mode != "Offline")
				{
					$this->load->model("paypal_model");
					if(!$this->transaction_model->checkPaidTx($order_id))
					{
						foreach ($orderData['order_items'] as $itemData)
						{
							if($itemData->status!=2)
							{
								$this->orders_model->subscriptionCancel($orderData,$itemData);
							}
						}
					}
				}
				$success = $this->orders_model->updateOrderCancelFlag($orderData,$cancel_status,$this->input->post("cancel_reason"),$this->input->post("cancel_date"));
				$this->order_log_model->log($order_id, $sevaOrGift." cancelled on: ".date("d M Y H:i A"));

			}
			else if($cancel_status == 0)
			{
				$success = $this->orders_model->updateOrderCancelFlag($orderData,0);
				$this->order_log_model->log($order_id, $sevaOrGift." cancel removed on: ".date("d M Y H:i A"));
			}
			if($success==1)
			{
				$this->session->set_flashdata("cancel_order","1");
			}
			$result['status']=1;
		}
		end:
		header("Content-Type:application/json");
		echo json_encode($result);
	}

	public function make_payment($order_id=0)
	{
		$result['flag']=0;
		if(is_numeric($order_id) && $order_id)
		{
			$orderData=$this->orders_model->orderData($order_id);
			if(empty($orderData['order']))
			{
				$result['error']="Invalid request";
				goto end;
			}
			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
					{
						$result['error']="Invalid request";
						goto end;
					}
				}
				else
				{
					$result['error']="Invalid request";
					goto end;
				}
			}

			/*if((strtolower($orderData['order']->payment_alt_mode)!='cash' || $orderData['order']->payment_status==1 ||
				$orderData['order']->total_price==$orderData['order']->paid) || ($orderData['order']->no_paid_transactions == "Yes" && $orderData['order']->total_paid == 0 && $orderData['order']->paid == 0))
			{
				$result['error']="Invalid request";
				goto end;
			}*/

			$contains_subscription=0;
			foreach ($orderData['order_items'] as $orderItem)
			{
				if($orderItem->subscription==1)
				{
					$contains_subscription=1;
					break;
				}
			}

			if($contains_subscription)
			{
				$result['error']="Partial payments are not allowed";
				goto end;
			}
			if($orderData['order']->partially_refunded==0)
				if($orderData['order']->partial_payments_allowed==0)
				{
					if($this->input->post("charge_amount")==0 || $this->input->post("charge_amount")!=$orderData['order']->total_price)
					{
						$result['error']="Partial payments are not allowed";
						goto end;
					}
				}
			if($this->input->post("charge_amount")!='')
			{
				if($this->input->post("charge_amount")==0 || $this->input->post("charge_amount")>($orderData['order']->total_price-$orderData['order']->paid))
				{
					$result['error']="Invalid amount";
					goto end;
				}
			}

			if($orderData['order']->trust_id>0)
			{
				$customData['trustData']=$this->ashrams_trust_accounts_model->trustData($orderData['order']->trust_id);
				$customData['trustData']=$this->ashrams_trust_accounts_model->removeCredentials($customData['trustData']);
			}
			else
			{
				$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($orderData['order']->ashram_id,$orderData['order']->order_type);
		    	$trustsArray=array();
		    	foreach ($trusts as $trustData)
		    	{
		    		$trustsArray[$trustData->currency]=$trustData;
		    	}
		    	$customData['trustData']=$trustsArray[$orderData['order']->currency];
		    	$customData['trustData']=$this->ashrams_trust_accounts_model->removeCredentials($customData['trustData']);
		    }
			
			$this->form_validation->set_rules('charge_amount', 'Amount','trim|required|numeric');
			$this->form_validation->set_rules('payment_mode', 'Payment Mode','trim|required|checkCashModes');
			//No need for online payments
			if($this->input->post("payment_mode")!='online')
				$this->form_validation->set_rules('payment_note', 'Note','trim|min_length[10]|max_length[1000]');

			if($orderData['order']->currency=='usd' && $this->input->post("payment_mode")=='online' && $customData['trustData']->payment_mode=='paypal')
			{
				if($this->input->post("credit_card_id")=='')
				{
					$this->form_validation->set_rules('card_number', 'Card Number','trim|required|min_length[15]|max_length[19]');
					$this->form_validation->set_rules('card_name', 'Card Name','trim|required|min_length[2]|max_length[100]');
					$this->form_validation->set_rules('card_expiry', 'Expiry Date','trim|required|cardExpiry');
					$this->form_validation->set_rules('card_cvv', 'CVV Number','trim|required|numeric|min_length[3]|max_length[4]');
				}
				else
				{
					$this->form_validation->set_rules('credit_card_id', 'Save Card','trim|required|numeric|max_length[20]');
				}
			}

			if($this->input->post("payment_mode")!='online')
			{
				$this->form_validation->set_rules('tx_status', 'Tx Status','trim|required|checkTransactionStatus['.$this->input->post("payment_mode").']');

				if(empty($this->input->post("tx_status")) || 
				($this->input->post("payment_mode")=='cheque' && $this->input->post("tx_status")=='inprocess') ||
				($this->input->post("payment_mode")!='cheque' && ($this->input->post("tx_status")=='paid' || $this->input->post("tx_status")=='inprocess')))
				{
					if($this->input->post("is_manual_payment"))
					{
						$this->form_validation->set_rules('manual_receipt_number', 'Receipt number','trim|required|max_length[100]');
						$this->form_validation->set_rules('manual_receipt_date', 'Receipt date','trim|required|valid_date');
					}

					if($this->input->post("is_foreign_payment"))
					{
						$this->form_validation->set_rules('foreign_currency', 'Foreign currency','trim|required|valid_foreign_currency['.$orderData['order']->currency.']');
						$this->form_validation->set_rules('foreign_amount', 'Foreign amount','trim|required|numeric|max_length[20]');
						$this->form_validation->set_rules('realized_amount', 'Realized amount','trim|numeric|max_length[20]');
					}

					if($this->input->post("payment_mode")!='cash')
					{
						$this->form_validation->set_rules('offline_number', 'Number','trim|required|max_length[100]');
						if($this->input->post("payment_mode")!='cc' && $this->input->post("payment_mode")!='dc')
							$this->form_validation->set_rules('offline_date', 'Date','trim|required|valid_date');
						if($this->input->post("payment_mode")!='mo')
						{
							$this->form_validation->set_rules('offline_bank', 'Bank name','trim|required|max_length[100]');
						}
					}
				}
			}

	    	if($this->form_validation->run() == FALSE)
			{
				$result['error']="Invalid request";
				$result['error']=validation_errors();
				goto end;
			}
			if($this->input->post("payment_mode")=='online')
			{
				//Get trust accounts for Ashram and Currency defined
		    	$customData['ashramData']=$this->ashrams_model->ashramData($orderData['order']->ashram_id);

		    	//Check credit card details
		    	if($orderData['order']->currency=='usd' && $customData['trustData']->payment_mode=='paypal')
				{
					$creditCardData=array();
					if($this->input->post("credit_card_id")!='')
					{
						$this->load->model("credit_cards_model");
						$creditCardData=$this->credit_cards_model->getCard($this->input->post("credit_card_id"));
						if(empty($creditCardData))
						{
							$result['error']="Invalid credit card";
							goto end;
						}
						if($creditCardData->user_id!=$orderData['order']->user_id)
						{
							$result['error']="Invalid credit card";
							goto end;
						}
					}
				}

				$paymentMode=$customData['trustData']->payment_mode;

				$formData['firstname']=$orderData['order']->firstname;
                $formData['lastname']=$orderData['order']->lastname;
                $formData['email']=$orderData['order']->email;
                $formData['phone']=$orderData['order']->phone;
                $formData['address1']=$orderData['order']->address1;
                $formData['address2']=$orderData['order']->address2;
                $formData['zipcode']=$orderData['order']->zipcode;
                $formData['city']=$orderData['order']->city;
                $formData['state']=$orderData['order']->state;
                $formData['country']=$orderData['order']->country;
                $formData['ashram_id']=$orderData['order']->ashram_id;

                if(empty($this->input->post("credit_card_id")) &&
                	($customData['trustData']->payment_mode=='paypal' || $customData['trustData']->payment_mode=='authorize.net') &&
            		$orderData['order']->currency=='usd' && $this->input->post("payment_mode")=='online' )
                {
                	$formData['card_number']=$this->input->post("card_number");
                	$formData['card_name']=$this->input->post("card_name");
                	$formData['card_expiry']=$this->input->post("card_expiry");
                	$formData['card_cvv']=$this->input->post("card_cvv");
                }

                if(!empty($this->input->post("credit_card_id")) && $customData['trustData']->payment_mode=='paypal' && $orderData['order']->currency=='usd' && $this->input->post("payment_mode")=='online')
                {
                	$formData['credit_card_id']=$this->input->post("credit_card_id");
                }

                if($customData['trustData']->payment_mode=='paypal' && $orderData['order']->currency=='usd' && $this->input->post("payment_mode")=='online' && !empty($formData['card_number']))
                {
                	$formData['save_credit_card']=$this->input->post("save_credit_card");
                }

                $formData['declaration_type'] = 'Donation';
				$formData['selected_template'] = '';
				if(isset($orderData['order']->declaration_type) && $orderData['order']->declaration_type=='Gift')
				{
					$formData['declaration_type'] = trim($orderData['order']->declaration_type);
				}
				if(isset($orderData['order']->declaration_template) && $orderData['order']->declaration_template!='' && $formData['declaration_type']=='Gift')
				{
					$formData['selected_template'] = trim($orderData['order']->declaration_template);
				}

                $customData['formData']=$formData;
				$customData['model']="orders/orders_model";
				$customData['model_name']="orders_model";
				$customData['ip_address']=$_SERVER['REMOTE_ADDR'];
				$customData['subscription']=0;
				$customData['additional_payment']=1;
				$customData['order_id']=$order_id;
				$customData['paymentMode']=$paymentMode;
				$customData['created_by']=1;
				$customData['cart_type']=$orderData['order']->order_type;

				$this->load->model("payment_model");
				$reference=$this->payment_model->setTempInfo(
					$orderData['order']->user_id,
					$this->currentUser,
					$this->input->post("charge_amount"),
					base_url."orders/view/".$order_id,
					base_url."orders/view/".$order_id,
					$customData,
					$orderData['order']->currency
					);
				$payment_result['flag']=1;
				$payment_result['reference']=$reference;
				$payment_result['payment_mode']=$paymentMode;

				if($paymentMode=='stripe')
		        {
		        	$ref_url = base_url."orders/view/".$order_id;
		        	$this->load->model("stripe_webhook_model");
		            $str_amount = $this->input->post("charge_amount")*100;
		            $checkoutSession = $this->stripe_webhook_model->createStripeSession($orderData['order']->currency,$orderData['order']->email,$customData['trustData'],$orderData['order']->order_type,array(),$this->input->post("charge_amount"),$reference,$customData,$orderData['order']->user_id,$orderData['order']->ashram_id,1,$ref_url);
		            if($checkoutSession["status"] == "error")
		            {
		                $result['flag']=0;
		                $result['error']=$checkoutSession['status_message'];
		                goto end;
		            }
		        }
				if($orderData['order']->currency=='usd')
				{
					$payment_result['currency']="USD";
					if($paymentMode=='paypal')
					{
						$this->load->model("paypal_model");
						$paypalResponse=$this->paypal_model->processOneTimePayment($reference,$creditCardData);
						if($paypalResponse['flag']==1)
						{
							$payment_result['redirect_to']=$paypalResponse['redirect_url'];
							$payment_result['payment_status']=1;
							$this->session->set_flashdata("payment_success",1);
							$this->orders_model->calculateDue($order_id);
							$this->orders_model->update_no_transactions($order_id);
							$this->order_log_model->log($orderData['order']->id,
								"Paid amount: ".strtoupper($orderData['order']->currency)." ".
							$this->input->post("charge_amount")."\n".$paymentMode."\nTx ID:".$paypalResponse['tx']);
							//$this->cart_log_model->log("Payment success:".$paymentMode,$this->session->userdata("poojasCartAshramId"),1);
							$this->session->set_userdata("payment_success","Payment processed successfully.");
							header("Content-Type:application/json");
							echo json_encode($payment_result);
							exit;
						}
						else
						{
							$payment_result['payment_status']=0;
							$payment_result['error']=$paypalResponse['error_msg'];
							//$this->cart_model->updateReferenceId('',1);
							//$this->cart_log_model->log("Payment failure:".$paymentMode.", Reason:".$paypalResponse['error_msg'],$this->session->userdata("poojasCartAshramId"),1);
							header("Content-Type:application/json");
							echo json_encode($payment_result);
							exit;
						}
					}
					if($paymentMode=='authorize.net')
					{
						$this->load->model("authorizenet_model");
						$authnetResponse=$this->authorizenet_model->processOneTimePayment($reference);
						if($authnetResponse['flag']==1)
						{
							$payment_result['redirect_to']=$authnetResponse['redirect_url'];
							$payment_result['payment_status']=1;
							$this->session->set_flashdata("payment_success",1);
							$this->orders_model->calculateDue($order_id);
							$this->order_log_model->log($orderData['order']->id,
								"Paid amount: ".strtoupper($orderData['order']->currency)." ".
							$this->input->post("charge_amount")."\n".$paymentMode."\nTx ID:".$authnetResponse['tx']);
							//$this->cart_log_model->log("Payment success:".$paymentMode,$this->session->userdata("poojasCartAshramId"),1);
							$this->session->set_userdata("payment_success","Payment processed successfully.");
							header("Content-Type:application/json");
							echo json_encode($payment_result);
							exit;
						}
						else
						{
							$payment_result['payment_status']=0;
							$payment_result['error']=$authnetResponse['error_msg'];
							//$this->cart_model->updateReferenceId('',1);
							//$this->cart_log_model->log("Payment failure:".$paymentMode.", Reason:".$authnetResponse['error_msg'],$this->session->userdata("poojasCartAshramId"),1);
							header("Content-Type:application/json");
							echo json_encode($payment_result);
							exit;
						}
					}
					if($paymentMode=='razorpay')
					{
						$payment_result['amount']=$this->input->post("charge_amount")*100;
						$payment_result['prefill_name']=$orderData['order']->firstname." ".$orderData['order']->lastname;
						$payment_result['prefill_email']=$orderData['order']->email;
						$payment_result['prefill_contact']=$orderData['order']->phone;
						header("Content-Type:application/json");
						echo json_encode($payment_result);
						exit;
					}
					if($paymentMode=='stripe')
					{
						$payment_result['amount']=$this->input->post("charge_amount")*100;
						$payment_result["session_id"]=$checkoutSession["session"]->id;
						header("Content-Type:application/json");
						echo json_encode($payment_result);
						exit;
					}
				}
				if($orderData['order']->currency=='inr')
				{
					$payment_result['currency']="INR";
					if($paymentMode=='razorpay')
					{
						$payment_result['amount']=$this->input->post("charge_amount")*100;
						$payment_result['prefill_name']=$orderData['order']->firstname." ".$orderData['order']->lastname;
						$payment_result['prefill_email']=$orderData['order']->email;
						$payment_result['prefill_contact']=$orderData['order']->phone;
						$this->session->set_userdata("payment_success","Payment processed successfully.");
						header("Content-Type:application/json");
						echo json_encode($payment_result);
						exit;
					}
					if($paymentMode=='payu')
					{
						$result['payment_mode']="payu";
						$result['redirect_to']='/payment/direct/'.$reference;
						//$this->cart_log_model->log("Redirected to payment gateway:".$paymentMode,$this->session->userdata("poojasCartAshramId"),1);
						header("Content-Type:application/json");
						echo json_encode($payment_result);
						exit;
					}
					if($paymentMode=='stripe')
					{
						$payment_result['amount']=$this->input->post("charge_amount")*100;
						$payment_result["session_id"]=$checkoutSession["session"]->id;
						header("Content-Type:application/json");
						echo json_encode($payment_result);
						exit;
					}
				}

			}
			else //Offline payments
			{
				$this->session->set_userdata("payment_success","Payment processed successfully.");
				$this->orders_model->charge_amount(
													$orderData,
													$this->input->post("charge_amount"),
													$this->input->post("payment_mode"),
													$this->input->post("payment_note")
												);
			}
			$result['flag']=1;
		}
		end:
		header("Content-Type:application/json");
		echo json_encode($result);
	}

	public function change_card($order_id=0)
	{
		$result['flag']=0;
		if(is_numeric($order_id) && $order_id)
		{
			$orderData=$this->orders_model->orderData($order_id);
			if(empty($orderData['order']))
			{
				$result['error']="There is no seva with given data. Credit card cannot be changed.";
				goto end;
			}
		}
		$has_subscription=0;
		$cancel_item_count = 0;
		$all_sub_items = 0;
		foreach ($orderData['order_items'] as $itemData)
		{

			if(($orderData['order']->order_type==2 || $orderData['order']->order_type==4) && $itemData->subscription==1)
			{
				$all_sub_items++;
				$has_subscription=1;
				if($itemData->status == 2)
				{
					$cancel_item_count++;
				}
			}
		}
		if($has_subscription==0)
		{
			$result['error']="There is no subscription. Credit card cannot be changed.";
			goto end;
		}

		if($cancel_item_count > 0 && $all_sub_items > 0 && $has_subscription==1)
		{
			if($cancel_item_count == $all_sub_items)
			{
				$result['error']="Subscription has been cancelled. Credit card cannot be changed.";
				goto end;
			}
		}

		$this->form_validation->set_rules('card_number', 'Card Number','trim|required|min_length[15]|max_length[19]');
		$this->form_validation->set_rules('card_name', 'Card Name','trim|required|min_length[2]|max_length[100]');
		$this->form_validation->set_rules('card_expiry', 'Expiry Date','trim|required|cardExpiry');
		$this->form_validation->set_rules('card_cvv', 'CVV Number','trim|required|numeric|min_length[3]|max_length[4]');
		if($this->form_validation->run() == FALSE)
		{
			$result['error']="Invalid request";
			goto end;
		}

		$flag=$this->orders_model->changeCard($order_id);
		if(isset($flag['RESULT']) && $flag['RESULT']==12)
		{
			$result['error']="Invalid Card";
			goto end;
		}
		if($flag==1)
		{
			$result['flag']=1;
			$this->session->set_userdata("card_updated",1);
		}

		end:
		header("Content-Type:application/json");
		echo json_encode($result);
	}

	public function update_txnote()
	{
		$result['status']=0;
		if(empty($this->input->post("txid")))
		{
			goto end;
		}
		$txRecord=$this->transaction_model->getTransactionByID($this->input->post("txid"));
		if($txRecord->sub_transaction==1)
			$txRecord=$this->transaction_model->getTransactionByTx($txRecord->sub_tx);

		if(empty($txRecord) || $txRecord->status=='pending' || $txRecord->status=='cash_pending')
		{
			goto end;
		}
		$orderData=$this->orders_model->orderData($txRecord->order_id);
		if(empty($orderData['order']))
		{
			goto end;
		}
			
		if($this->currentUser->roles!=1)
		if($this->session->userdata("ashramId")!=$orderData['order']->ashram_id)
		{
			goto end;
		}
			
		$this->form_validation->set_rules('additional_tx_note', 'Note','trim|min_length[10]|max_length[1000]');
    	if($this->form_validation->run() == FALSE)
		{
			goto end;
		}
			
		$txnote=$txRecord->note."\n\n<b>".date("d M Y h:i A")."</b>\n".$this->input->post("additional_tx_note");
		$this->transaction_model->setNote(
											$txRecord->tx,
											$txnote
										);

		$this->order_log_model->log($txRecord->order_id,"Tx note Updated\nTx ID:".$txRecord->tx);
		$result['status']=1;
		$this->session->set_flashdata("tx_updated",1);
		
		end:
		header("Content-Type:application/json");
		echo json_encode($result);
	}

	public function update_tx($order_id=0)
	{
		$result['status']=0;
		if(is_numeric($order_id) && $order_id)
		{
			$orderData=$this->orders_model->orderData($order_id);
			if(empty($orderData['order']))
			{
				goto end;
			}
			$contains_subscription=0;
			foreach ($orderData['order_items'] as $orderItem)
			{
				if($orderItem->subscription==1)
				{
					$contains_subscription=1;
					break;
				}
			}

			if($this->currentUser->roles!=1)
			if($this->session->userdata("ashramId")!=$orderData['order']->ashram_id)
			{
				goto end;
			}
			if(strtolower($orderData['order']->payment_alt_mode)!='cash')
			{
				if($this->input->post("tx_status")!='refund')
				goto end;
			}

			//$this->form_validation->set_rules('payment_mode', 'Payment Mode','trim|required|checkCashModes');
			$this->form_validation->set_rules('tx_status', 'Tx Status','trim|required|checkTransactionStatus['.$this->input->post("payment_mode").']');
			$this->form_validation->set_rules('tx_id', 'Tx ID','trim|required|numeric|checkTransactionExist['.$order_id.']');
			$this->form_validation->set_rules('tx_note', 'Note','trim|min_length[10]|max_length[1000]');

			if(empty($this->input->post("tx_status")) || 
				($this->input->post("payment_mode")=='cheque' && $this->input->post("tx_status")=='inprocess') ||
				($this->input->post("payment_mode")!='cheque' && 
				(in_array($this->input->post("tx_status"),$this->payment_success_statuses) || $this->input->post("tx_status")=='inprocess')))
			{
				if($this->input->post("is_manual_payment"))
				{
					$this->form_validation->set_rules('manual_receipt_number', 'Receipt number','trim|required|max_length[100]');
					$this->form_validation->set_rules('manual_receipt_date', 'Receipt date','trim|required|valid_date');
				}

				if($this->input->post("is_foreign_payment"))
				{
					$this->form_validation->set_rules('foreign_currency', 'Foreign currency','trim|required|valid_foreign_currency['.$orderData['order']->currency.']');
					$this->form_validation->set_rules('foreign_amount', 'Foreign amount','trim|required|numeric|max_length[20]');
					$this->form_validation->set_rules('realized_amount', 'Realized amount','trim|numeric|max_length[20]');
				}

				if($this->input->post("payment_mode")!='cash')
				{
					$this->form_validation->set_rules('offline_number', 'Number','trim|required|max_length[100]');
					if($this->input->post("payment_mode")!='cc' && $this->input->post("payment_mode")!='dc')
					$this->form_validation->set_rules('offline_date', 'Date','trim|required|valid_date');
					if($this->input->post("payment_mode")!='mo')
					{
						$this->form_validation->set_rules('offline_bank', 'Bank name','trim|required|max_length[100]');
					}
				}
			}
			if($this->input->post("tx_status")=='refund')
			{
				$this->form_validation->set_rules('refund_reference', 'Refund reference','trim|required|max_length[100]');
				$this->form_validation->set_rules('refund_date', 'Refund date','trim|required|valid_date');
				$this->form_validation->set_rules('refund_mode', 'Refund modee','trim|required|checkCashModes');
			}

	    	if($this->form_validation->run() == FALSE)
			{
				echo validation_errors();
				goto end;
			}
			$txRecord=$this->transaction_model->getTransactionByID($this->input->post("tx_id"));
			//Check record exist
			if(empty($txRecord) || $txRecord->order_id!=$order_id || $txRecord->flag==1)
			{
				goto end;
			}
			//For bulk update, only update for pending or bounced state
			if($contains_subscription==1)
			{
				/*if($txRecord->status!='pending' && $txRecord->status!='cash_pending' && $txRecord->status!='bounced'))
				{
					goto end;
				}*/
			}
			else
			{
				if($txRecord->status=='bounced' || $txRecord->status=='refund')
					goto end;
			}

			/*if(($txRecord->status!='pending' && $txRecord->status!='cash_pending' && $txRecord->status!='bounced') && 
				($this->input->post("tx_status")!='paid' && $this->input->post("tx_status")!='inprocess' && $this->input->post("tx_status")!='bounced'))
			{
				goto end;
			}*/

			$this->transaction_model->update(
												$this->input->post("tx_id"),
												$this->input->post("tx_status"),
												$this->input->post("tx_note"),
												$this->input->post("payment_mode")
											);
			$this->orders_model->calculateDue($order_id);
			if($this->input->post("tx_status") == "refund")
			{
				$this->load->model("refunds_history_model");
				$this->refunds_history_model->saveHistory($txRecord,$orderData,array("message"=>"Refund From Offline"),1,1,"",$this->input->post("refund_reference"));
			}
			$this->order_log_model->log($order_id,"Tx Updated\nTx ID:".$txRecord->tx."\nStatus:".$this->input->post("tx_status").
				"\nNote:".$this->input->post("tx_note"));
			$result['status']=1;
		}
		end:
		header("Content-Type:application/json");
		echo json_encode($result);
	}

	public function update_tx_subscription($order_id=0)
	{
		$result['status']=0;
		if(is_numeric($order_id) && $order_id)
		{
			//Subscription payment ID is mandatory
			if(!$this->input->post("s_payment_id"))
			{
				goto end;
			}

			$orderData=$this->orders_model->orderData($order_id);
			if(empty($orderData['order']))
			{
				goto end;
			}

			//Valid only for offline(cash) sevas
			if(strtolower($orderData['order']->payment_alt_mode)!='cash')
			{
				if($this->input->post("s_tx_status")!='refund')
				{
					goto end;
				}
			}

			//Check super admin role
			if($this->currentUser->roles!=1)
			{
				//If not, check for ashram id in session
				if($this->session->userdata("ashramId")!=$orderData['order']->ashram_id)
				{
					goto end;
				}
			}

			$contains_subscription=0;
			foreach ($orderData['order_items'] as $orderItem)
			{
				if($orderItem->subscription==1)
				{
					$contains_subscription=1;
					break;
				}
			}

			//$this->form_validation->set_rules('s_payment_mode', 'Payment Mode','trim|required|checkCashModes');
			$this->form_validation->set_rules('s_tx_status', 'Tx Status','trim|required|checkTransactionStatus['.$this->input->post("s_payment_mode").']');
			$this->form_validation->set_rules('s_tx_note', 'Note','trim|min_length[10]|max_length[1000]');


			if(empty($this->input->post("s_tx_status")) || 
				($this->input->post("s_payment_mode")=='cheque' && $this->input->post("s_tx_status")=='inprocess') ||
				($this->input->post("s_payment_mode")!='cheque' && ($this->input->post("s_tx_status")=='paid' || $this->input->post("s_tx_status")=='inprocess')))
				
			/*if(empty($this->input->post("s_tx_status")) || 
				$this->input->post("s_tx_status")=='paid' || $this->input->post("s_tx_status")=='inprocess')*/
			{
				if($this->input->post("is_manual_payment"))
				{
					$this->form_validation->set_rules('manual_receipt_number', 'Receipt number','trim|required|max_length[100]');
					$this->form_validation->set_rules('manual_receipt_date', 'Receipt date','trim|required|valid_date');
				}

				if($this->input->post("is_foreign_payment"))
				{
					$this->form_validation->set_rules('foreign_currency', 'Foreign currency','trim|required|valid_foreign_currency['.$orderData['order']->currency.']');
					$this->form_validation->set_rules('foreign_amount', 'Foreign amount','trim|required|numeric|max_length[20]');
					$this->form_validation->set_rules('realized_amount', 'Realized amount','trim|numeric|max_length[20]');
				}

				if($this->input->post("s_payment_mode")!='cash')
				{
					$this->form_validation->set_rules('offline_number', 'Number','trim|required|max_length[100]');
					if($this->input->post("s_payment_mode")!='cc' && $this->input->post("s_payment_mode")!='dc')
						$this->form_validation->set_rules('offline_date', 'Date','trim|required|valid_date');
					if($this->input->post("s_payment_mode")!='mo')
					{
						$this->form_validation->set_rules('offline_bank', 'Bank name','trim|required|max_length[100]');
					}
				}

			}

	    	if($this->form_validation->run() == FALSE)
			{
				goto end;
			}

			$payment_ids=array_filter(explode(",",$this->input->post("s_payment_id")));

			$error=0;
			foreach ($payment_ids as $payment_id)
			{
				$subscriptionPaymentRecord=$this->subscription_payments_model->getById($payment_id);
				//Check record exist
				/*if(empty($subscriptionPaymentRecord) || $subscriptionPaymentRecord->order_id!=$order_id)
				{
					$error=1;
					break;
				}*/
				if(!empty($subscriptionPaymentRecord))
				{
					if($subscriptionPaymentRecord->order_id!=$order_id)
					{
						$error=1;
						break;
					}
				}
				else if(count($payment_ids)>1)
				{
					//Check transaction record
					$subscriptionPaymentRecord=$this->transaction_model->getTransactionByTx($payment_id);
					if(!empty($subscriptionPaymentRecord))
					{
						if($subscriptionPaymentRecord->order_id!=$order_id)
						{
							$error=1;
							break;
						}
						if($subscriptionPaymentRecord->status=='pending' || $subscriptionPaymentRecord->status=='cash_pending')
							$subscriptionPaymentRecord->status=0;
						if($subscriptionPaymentRecord->status=='bounced')
							$subscriptionPaymentRecord->status=102;
						if($subscriptionPaymentRecord->status=='refund')
							$subscriptionPaymentRecord->status=103;
					}
					else
					{
						$error=1;
						break;
					}
				}
				else
				{
					$error=1;
					break;
				}
				
				//For bulk update, only update for pending or bounced state
				if(count($payment_ids)>1 && ($subscriptionPaymentRecord->status!=0 && $subscriptionPaymentRecord->status!=102) && 
					($this->input->post("s_tx_status")!='paid' && $this->input->post("s_tx_status")!='inprocess'))
				{
					$error=1;
					break;
				}
			}

			if($error==1)
			{
				goto end;
			}
			
			if(count($payment_ids)==1)
			{
				$payment_flag=$this->subscription_payments_model->offlineUpdate(
															$this->input->post("s_payment_id"),
															$this->input->post("s_payment_mode"),
															$this->input->post("s_tx_status"),
															$this->input->post("s_tx_note")
														);
				$this->orders_model->calculateOrderItemDue($order_id,$subscriptionPaymentRecord->order_item_id);
			}
			else
			{
				$payment_flag=$this->subscription_payments_model->offlineUpdateBulk	(
															$this->input->post("s_payment_id"),
															$this->input->post("s_payment_mode"),
															$this->input->post("s_tx_status"),
															$this->input->post("s_tx_note"),
															$contains_subscription
														);
			}
			$this->orders_model->calculateDue($order_id);
			$this->session->set_flashdata("tx_updated",1);
			$result['status']=$payment_flag;
			//$this->orders_model->calculateDue($order_id);
			goto end;

			exit;
			

			$this->order_log_model->log($order_id,"Tx Updated\nTx ID:".$this->input->post("tx_id")."\nStatus:".$this->input->post("tx_status").
				"\nNote:".$this->input->post("tx_note"));
			$result['status']=1;
		}
		end:
		header("Content-Type:application/json");
		echo json_encode($result);
	}

	public function updatetx_field($order_id=0)
	{
		$result['status']=0;
		if(is_numeric($order_id) && $order_id)
		{
			$orderData=$this->orders_model->orderData($order_id);
			if(empty($orderData['order']))
			{
				goto end;
			}
			$contains_subscription=0;
			foreach ($orderData['order_items'] as $orderItem)
			{
				if($orderItem->subscription==1)
				{
					$contains_subscription=1;
					break;
				}
			}

			if($this->currentUser->roles!=1)
			if($this->session->userdata("ashramId")!=$orderData['order']->ashram_id)
			{
				goto end;
			}
			if(strtolower($orderData['order']->payment_alt_mode)!='cash')
			{
				goto end;
			}
			$txData=$this->transaction_model->getTransactionByID($this->input->post("pk"));
			if(empty($txData) || $txData->flag==1 || $txData->order_id!=$order_id)
			{
				goto end;
			}
			if(!in_array($this->input->post("name"),
					array(
							"manual_receipt_date",
							"manual_receipt_number",
							"offline_bank",
							"offline_number",
							"offline_date",
							"foreign_currency",
							"foreign_amount",
							"realized_amount",
							"is_foreign_payment",
							"is_manual_payment"
						)
				)
			)
			{
				goto end;
			}

			if($this->input->post("name")=='manual_receipt_number')
			{
				$this->form_validation->set_rules('value', 'Receipt number','trim|required|max_length[100]');
			}
			if($this->input->post("name")=='manual_receipt_date')
			{
				$this->form_validation->set_rules('value', 'Receipt date','trim|required|valid_date');
			}
			if($this->input->post("name")=='offline_number')
			{
				if($txData->payment_mode=='cheque')
					$this->form_validation->set_rules('value', 'Cheque number','trim|required|max_length[100]');
				if($txData->payment_mode=='mo')
					$this->form_validation->set_rules('value', 'MO number','trim|required|max_length[100]');
				if($txData->payment_mode=='cashiers_check')
					$this->form_validation->set_rules('value', 'CC number','trim|required|max_length[100]');
				if($txData->payment_mode=='cc' || $txData->payment_mode=='dc')
					$this->form_validation->set_rules('value', 'Card number','trim|required|max_length[100]');
			}
			if($this->input->post("name")=='offline_bank')
			{
				$this->form_validation->set_rules('value', 'Bank','trim|required|max_length[100]');
			}
			if($this->input->post("name")=='offline_date')
			{
				$this->form_validation->set_rules('value', 'Date','trim|required|valid_date');
			}

			if($this->input->post("name")=='foreign_amount' || $this->input->post("name")=='realized_amount')
			{
				$this->form_validation->set_rules('value', 'Amount','trim|required|numeric|max_length[20]');
			}
			if($this->input->post("name")=='is_foreign_payment')
			{
				$this->form_validation->set_rules('value', 'Is foreign transaction','trim|required|numeric|check_boolean');
			}
			if($this->input->post("name")=='is_manual_payment')
			{
				$this->form_validation->set_rules('value', 'Is manual transaction','trim|required|numeric|check_boolean');
			}
			if($this->input->post("name")=='foreign_currency')
			{
				$this->form_validation->set_rules('value', 'Foreign currency','trim|required|valid_foreign_currency['.$orderData['order']->currency.']');
			}

	    	if($this->form_validation->run() == FALSE)
			{
				$result['status']=2;
				$result['msg']=strip_tags(validation_errors());
				goto end;
			}
			$result['status']=1;
			$value=$this->input->post("value");
			if($this->input->post("name")=='manual_receipt_date' || $this->input->post("name")=='offline_date')
			{
				$value=date("Y:m:d H:i:s",strtotime($value));
			}

			if($this->input->post("name")=='is_foreign_payment')
			{
				$this->transaction_model->updateDetails($txData->tx,
												array(
														$this->input->post("name")=>$value,
														"foreign_currency"=>null,
														"foreign_amount"=>0,
														"realized_amount"=>0
													)
											);
			}
			else if($this->input->post("name")=='is_manual_payment')
			{
				$this->transaction_model->updateDetails($txData->tx,
												array(
														$this->input->post("name")=>$value,
														"manual_receipt_date"=>null,
														"manual_receipt_number"=>null
													)
											);
			}
			else
			{
				$this->transaction_model->updateDetails($txData->tx,
												array(
														$this->input->post("name")=>$value
													)
											);
			}
		}
		end:
		if($result['status']==2)
			echo $result['msg'];
		else if($result['status']==1)
		{

		}
		else
			echo $result['status'];
	}

	public function getsubscriptionhistory($orderId=0,$orderItemId=0)
	{
		$result['status']=0;
		if(is_numeric($order_id) && $order_id && is_numeric($orderItemId) && $orderItemId)
		{
			$orderData=$this->orders_model->orderData($order_id);
			if(empty($orderData['order']))
			{
				goto end;
			}
			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId")!=$orderData['order']->ashram_id)
				{
					goto end;
				}
			}
			$itemData=$this->orders_model->itemData($orderItemId,$orderId);
			if(empty($order_item_id))
			{
				goto end;
			}
			$result=$this->subscription_payments->getList($orderItemId);
			echo json_encode($result);
		}
		end:
		header("Content-Type:application/json");
		echo json_encode($result);
	}

	public function subscription_cancel($orderId=0,$orderItemId=0)
	{
		$result['status']=0;
		if(is_numeric($orderId) && $orderId && is_numeric($orderItemId) && $orderItemId)
		{
			$orderData=$this->orders_model->orderData($orderId);
			if(empty($orderData['order']))
			{
				goto end;
			}
			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId")!=$orderData['order']->ashram_id)
				{
					goto end;
				}
			}
			$itemData=$this->orders_model->itemData($orderItemId,$orderId);
			if(empty($itemData))
			{
				goto end;
			}
			$this->load->model("paypal_model");
			$result=$this->orders_model->subscriptionCancel($orderData,$itemData);
			$this->session->set_flashdata("subscription_item",$itemData->item_name);
			if($result==1)
			{
				$this->session->set_flashdata("subscription_cancelled",1);
				redirect("orders/view/".$orderId);
				exit;
			}
			else
			{
				$this->session->set_flashdata("subscription_error","Error cancelling subscription.");
				redirect("orders/view/".$orderId);
				exit;
			}
		}
		end:
		{
			redirect("orders");
		}
	}

	public function subscription_read_payments_paypal($orderId=0,$orderItemId=0)
	{
		$result['status']=0;
		if(is_numeric($orderId) && $orderId && is_numeric($orderItemId) && $orderItemId)
		{
			$orderData=$this->orders_model->orderData($orderId);
			if(empty($orderData['order']))
			{
				goto end;
			}
			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId")!=$orderData['order']->ashram_id)
				{
					goto end;
				}
			}
			$itemData=$this->orders_model->itemData($orderItemId,$orderId);
			if(empty($itemData) || $itemData->status==0)
			{
				goto end;
			}

			$this->load->model("paypal_model");
			$result=$this->orders_model->readSubscriptionsPaypal($orderId,$orderItemId);
			$this->session->set_flashdata("subscription_item",$itemData->item_name);
			
			$this->session->set_flashdata("subscription_payments_read_paypal",1);
			redirect("orders/view/".$orderId);
		}
		end:
		{
			redirect("orders");
		}
	}

	public function pet_assign_form($orderItemId=0)
	{
		$result['status']=0;
		if(is_numeric($orderItemId) && $orderItemId)
		{
			$itemData=$this->orders_model->itemData($orderItemId);
			if(empty($itemData))
			{
				goto end;
			}

			$orderData=$this->orders_model->orderData($itemData->order_id);
			if(empty($orderData['order']))
			{
				goto end;
			}
			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId")!=$orderData['order']->ashram_id)
				{
					goto end;
				}
			}
			$data['order_item_id']=$orderItemId;
			echo $this->load->view("orders/admin/_pet_assign_modal",$data,true);
		}
		end:
		{
			
		}
	}

	/**
	 * List All Offline Payments
	 * @gitBranch: bajidotwork_DPDEV-425
	 * @version   1.1 [27th June 2019]
	 * @author    Baji Shaik <bajidotwork@gmail.com>
	 */
	public function refund_transactions()
	{
		$views = array( 'orders/admin/list_refund_transactions' );
		$data = array('views'=>$views);
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Refund Transactions Listing");
	}

	/**
	 * Ajax Listing for All Offline Trans
	 * @gitBranch: bajidotwork_DPDEV-450
	 * @version   1.1 [17 Sep 2019]
	 * @author    Baji Shaik <bajidotwork@gmail.com>
	 */
	public function listrefundtrans($excel=0)
	{
		$this->load->model("refunds_history_model");
		$list=$this->refunds_history_model->listAdminRefundTrans($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Refund Transactions Listing ajax request");
	}

	/**
	 * Manual Refund Popup Form
	 * @gitBranch: bajidotwork_DPDEV-450
	 * @version   1.1 [17 Sep 2019]
	 * @author    Baji Shaik <bajidotwork@gmail.com>
	 */
	public function manual_refund_form($order_id=0,$tx)
	{
		if(!empty($tx))
		{
			$txData=$this->payment_model->getTransaction($tx);
			
			$orderData=$this->orders_model->orderData($order_id);
			if(!empty($txData) && !empty($orderData))
			{
				$data['orderData']=$orderData;
				$data['tx'] = $txData;
				echo $this->load->view("orders/admin/_manual_refund",$data,true);
			}
		}
	}

	/**
	 * Update Online Refund transaction if it is failed from gateway level
	 * @gitBranch: bajidotwork_DPDEV-450
	 * @version   1.1 [17 Sep 2019]
	 * @author    Baji Shaik <bajidotwork@gmail.com>
	 */
	public function update_online_tx($order_id=0)
	{
		$result['status']=0;
		if(is_numeric($order_id) && $order_id)
		{
			$orderData=$this->orders_model->orderData($order_id);
			if(empty($orderData['order']))
			{
				goto end;
			}

			if($this->currentUser->roles!=1)
			if($this->session->userdata("ashramId")!=$orderData['order']->ashram_id)
			{
				goto end;
			}
			$payment_alt_mode = strtolower($orderData['order']->payment_alt_mode);
			if($payment_alt_mode == 'Razorpay' || $payment_alt_mode == 'Paypal' || $payment_alt_mode == 'Payu' || $payment_alt_mode == 'Stripe')
			{
				if($this->input->post("tx_status")!='refund')
				goto end;
			}
			$this->form_validation->set_rules('tx_status', 'Tx Status','trim|required|checkTransactionStatus['.$this->input->post("payment_mode").']');
			$this->form_validation->set_rules('tx_id', 'Tx ID','trim|required|numeric|checkTransactionExist['.$order_id.']');
			$this->form_validation->set_rules('tx_note', 'Note','trim|min_length[10]|max_length[1000]');
			$this->form_validation->set_rules('refund_reference', 'Refund reference','trim|required|max_length[100]');
				$this->form_validation->set_rules('refund_date', 'Refund date','trim|required|valid_date');
				$this->form_validation->set_rules('refund_mode', 'Refund modee','trim|required|checkCashModes');

	    	if($this->form_validation->run() == FALSE)
			{
				echo validation_errors();
				goto end;
			}
			$txRecord=$this->transaction_model->getTransactionByID($this->input->post("tx_id"));
			//Check record exist
			if(empty($txRecord) || $txRecord->order_id!=$order_id || $txRecord->flag==1)
			{
				goto end;
			}
			if($txRecord->status=='bounced' || $txRecord->status=='refund')
				goto end;

			$subscription = $txRecord->subscription;
			$txUpdateData['refund_reference']=$this->input->post("refund_reference");
			$txUpdateData['refund_date']=date("Y-m-d",strtotime($this->input->post("refund_date")));
			$txUpdateData['refund_mode']=$this->input->post("refund_mode");
			$this->load->model("refunds_history_model");
			if(empty($subscription) || $subscription != 1)
			{
				$this->refunds_history_model->updateOnetimeTx( $this->input->post("refund_reference"),$txRecord->id, "refund",$this->input->post("tx_note"),$txRecord->payment_mode,$txRecord->tx,$txRecord,$orderData,$txUpdateData );
				$this->refunds_history_model->updateRefundsHistory($txRecord->tx,array("refund_success_flag"=>1,"refund_id"=>$this->input->post("refund_reference")));
			}
			else if($subscription == 1)
			{
				$payment_flag=$this->refunds_history_model->updateSubscriptionTx( $this->input->post("refund_reference"),"refund",$this->input->post("tx_note"),$txRecord->payment_mode,$txRecord->tx,$txRecord,$orderData,$txUpdateData );
				foreach ($orderData['order_items'] as $item)
				{
					$this->orders_model->calculateOrderItemDue($txRecord->order_id,$item->id);
				}
				$this->refunds_history_model->updateRefundsHistory($txRecord->tx,array("refund_success_flag"=>1,"refund_id"=>$this->input->post("refund_reference")));
			}
			$this->orders_model->calculateDue($order_id);
			if(empty($subscription) || $subscription != 1)
			{
				$this->refunds_history_model->updateOrderItems($orderData['order']->id);
			}
			$this->session->set_flashdata("tx_updated",1);
			$this->order_log_model->log($order_id,"Tx Updated\nTx ID:".$txRecord->tx."\nStatus:".$this->input->post("tx_status").
				"\nNote:".$this->input->post("tx_note"));
			$result['status']=1;
		}
		end:
		header("Content-Type:application/json");
		echo json_encode($result);
	}

	public function refundonlineTx($orderId,$tx)
	{
		$transaction_id = $this->input->post("txId");
		if(!empty($transaction_id))
		{
			$txData=$this->payment_model->getTransaction($tx);
			/*if($this->input->post("subscription") == "1")
			{
				if($txData->subscription_payment_id != $transaction_id)
				{
					return FALSE;
				}
				$original_transId = $txData->subscription_payment_id;
			}
			else if($this->input->post("subscription") == "0")
			{
				if($txData->id != $transaction_id)
					return FALSE;
				$original_transId = $txData->id;
			}*/
			$orderData=$this->orders_model->orderData($orderId);
			if(!empty($txData) && !empty($orderData))
			{
				if($txData->tx != $tx)
				{
					return FALSE;
				}
				else
				{
					$this->load->library("onlinerefund");
					$returnData = $this->onlinerefund->process_refund($txData->payment_mode,$txData,$orderData);
					$this->load->model("refunds_history_model");
					if($returnData['status'] == 1 && !empty($returnData['response']))
					{
						//Status 1 Indicates Refund Initiated successfully from gateway level
						$this->refunds_history_model->saveHistory($txData,$orderData,$returnData['response'],1,0,$returnData['message']);

						$subscription = $txData->subscription;
						$refundId = "";
						if(strtolower($txData->payment_mode) == "paypal")
						{
							if(!empty($returnData['response']['PNREF']))
								$refundId = $returnData['response']['PNREF'];
							else
								$refundId = substr(hash('sha256', mt_rand() . microtime()), 0, 10);
						}
						else if(strtolower($txData->payment_mode) == "payu")
						{
							$refundId 		= $returnData['response']->result;
						}
						else if(strtolower($txData->payment_mode) == "razorpay")
						{
							$refundId 		= $returnData['response']->id;
						}
						else if(strtolower($txData->payment_mode) == "stripe")
						{
							$refundId 		= $returnData['response']->id;
						}
						
						if(empty($subscription) || $subscription != 1)
						{
							//Set Custom Note for online refund
							$tx_note = "Tx Updated\nTx ID: ".$txData->tx."\nStatus: Refunded\nRefund ID: ".$refundId;
							//Update Transaction
							$this->refunds_history_model->updateOnetimeTx($refundId, $txData->id, "refund",$tx_note,$txData->payment_mode,$txData->tx,$txData,$orderData );
							//Calculate Order Due
							$this->orders_model->calculateDue($orderData['order']->id);
							$this->refunds_history_model->updateOrderItems($orderData['order']->id);
							//Order Log Data
							$this->order_log_model->log($orderData['order']->id,"Tx Updated\nTx ID:".$txData->tx."\nStatus: Refunded\nRefund ID:".$refundId);
						}
						else if(!empty($subscription) && $subscription == 1)
						{
							//Set Custom Note for online refund
							$tx_note = "Tx Updated\nTx ID: ".$txData->tx."\nStatus: Refunded\nRefund ID: ".$refundId;

							$payment_flag=$this->refunds_history_model->updateSubscriptionTx( $refundId,"refund",$tx_note,$txData->payment_mode,$txData->tx,$txData,$orderData );
							$this->orders_model->calculateOrderItemDue($orderData['order']->id,$txData->order_item_id);

							$this->order_log_model->log($orderData['order']->id,"Tx Updated\nTx ID:".$txData->tx."\nStatus: Refunded\nRefund ID:".$refundId);
						}
						$this->session->set_flashdata("tx_updated",1);
					}
					else
					{
						$this->refunds_history_model->saveHistory($txData,$orderData,$returnData['response'],0,0,$returnData['message']);
					}
					//header("Content-Type:application/json");
					echo json_encode($returnData);
				}
			}
			return false;
		}
	}

	public function pet_assign($orderItemId=0,$petId=0)
	{
		$result['flag']=0;
		if(is_numeric($orderItemId) && $orderItemId && is_numeric($petId) && $petId)
		{
			$itemData=$this->orders_model->itemData($orderItemId);
			if(empty($itemData) || $itemData->assign_pet==0)
			{
				goto end;
			}

			$orderData=$this->orders_model->orderData($itemData->order_id);
			if(empty($orderData['order']))
			{
				goto end;
			}
			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId")!=$orderData['order']->ashram_id)
				{
					goto end;
				}
			}
			$this->load->model("pets_model");
			$petData=$this->pets_model->petData($petId);
			if(empty($petData))
			{
				goto end;
			}
			$this->orders_model->assignPet($orderItemId,$petId,$orderData,$itemData);
			$result['flag']=1;
		}
		end:
		{
			header("Content-Type:application/json");
			echo json_encode($result);
		}		
	}

	public function poojas_seva_karta_pdf_report()
	{
		$reports=$this->orders_model->listAdminPoojasSevaKarta();
		$data = array('reports'=>$reports);
		$this->load->view('orders/admin/poojas_seva_karta_pdf_report',$data);
	}

	public function donation_declarations_old()
	{
		if(empty($_GET["from_date"]) || empty($_GET["to_date"]) || empty($_GET["payment_mode"]) || empty($_GET["ashram_id"]))
		{
			$this->session->set_flashdata("no_declarations",1);
			redirect('orders/transactions');
		}
		if(empty($this->ashrams_model->ashramData($_GET["ashram_id"])))
		{
			$this->session->set_flashdata("no_declarations",1);
			redirect('orders/transactions');
		}
		else if(empty($this->session->userdata("ashramId")))
		{
			if(is_numeric($_GET["ashram_id"]))
			{
				$this->session->set_userdata("ashramId",$_GET["ashram_id"]);
				redirect("orders/donation_declarations?ashram_id=".$_GET["ashram_id"]."&from_date=".$_GET["from_date"]."&to_date=".$_GET["to_date"]."&payment_mode=".$_GET["payment_mode"]);
			}
		}

		$declarations=$this->transaction_model->getDonationDeclarations();
		if(empty($declarations) || count($declarations) == 0)
		{
			$this->session->set_flashdata("no_declarations",1);
			redirect('orders/transactions');
		}
		$views = array( 'orders/admin/print_declarations');
		$data = array("views"=>$views,'declarations'=>$declarations);
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function donation_declarations($record=0)
	{
		if(empty($_GET["from_date"]) || empty($_GET["to_date"]) || empty($_GET["payment_mode"]) || empty($_GET["ashram_id"]))
		{
			$this->session->set_flashdata("no_declarations",1);
			redirect('orders/transactions');
		}
		if(empty($this->ashrams_model->ashramData($_GET["ashram_id"])))
		{
			$this->session->set_flashdata("no_declarations",1);
			redirect('orders/transactions');
		}
		else if(empty($this->session->userdata("ashramId")))
		{
			if(is_numeric($_GET["ashram_id"]))
			{
				$this->session->set_userdata("ashramId",$_GET["ashram_id"]);
				redirect("orders/donation_declarations?ashram_id=".$_GET["ashram_id"]."&from_date=".$_GET["from_date"]."&to_date=".$_GET["to_date"]."&payment_mode=".$_GET["payment_mode"]);
			}
		}
		$getData = "?";
		if(isset($_GET["ashram_id"]) && $_GET["ashram_id"]!="")
		{
			$getData .= "ashram_id=".$_GET["ashram_id"];
		}
		if(isset($_GET["from_date"]) && $_GET["from_date"]!="")
		{
			$getData .= "&from_date=".$_GET["from_date"];
		}
		if(isset($_GET["to_date"]) && $_GET["to_date"]!="")
		{
			$getData .= "&to_date=".$_GET["to_date"];
		}
		if(isset($_GET["payment_mode"]) && $_GET["payment_mode"]!="")
		{
			$getData .= "&payment_mode=".$_GET["payment_mode"];
		}
		if(isset($_GET["currency"]) && $_GET["currency"]!="")
		{
			$getData .= "&currency=".$_GET["currency"];
		}
		$page_number = 1;
		if($record>1)
		{
			$page_number = $record;
		}
		$this->load->library('pagination');
		$recordPerPage = 1000;
		if($record != 0){
			$record = ($record-1) * $recordPerPage;
		}
      	$recordCount = $this->transaction_model->getDonationDeclarations(1);
      	$_GET["length"] = $recordPerPage;
		$_GET["start"] = $record;
      	$config['base_url'] = base_url().'orders/donation_declarations';
      	$config['suffix'] = $getData;
      	$config['use_page_numbers'] = TRUE;
		$config['next_link'] = 'Next';
		$config['prev_link'] = 'Previous';
		$config['reuse_query_string'] = TRUE;
		$config['total_rows'] = $recordCount;
		$config['per_page'] = $recordPerPage;
		$this->pagination->initialize($config);
		$pagination_links = $this->pagination->create_links();
		$declarations = $this->transaction_model->getDonationDeclarations(0);
      	if(empty($declarations))
		{
			$this->session->set_flashdata("no_declarations",1);
			redirect('orders/transactions');
		}
		$views = array( 'orders/admin/print_declarations');
		$data = array("views"=>$views,'get_data'=>$getData, 'declarations'=>$declarations, 'pagination_links'=>$pagination_links, 'page_number'=>$page_number);
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function load_donation_declarations($record=0)
	{
		$getData = "?";
		if(isset($_GET["ashram_id"]) && $_GET["ashram_id"]!="")
		{
			$getData .= "ashram_id=".$_GET["ashram_id"];
		}
		if(isset($_GET["from_date"]) && $_GET["from_date"]!="")
		{
			$getData .= "&from_date=".$_GET["from_date"];
		}
		if(isset($_GET["to_date"]) && $_GET["to_date"]!="")
		{
			$getData .= "&to_date=".$_GET["to_date"];
		}
		if(isset($_GET["payment_mode"]) && $_GET["payment_mode"]!="")
		{
			$getData .= "&payment_mode=".$_GET["payment_mode"];
		}
		if(isset($_GET["currency"]) && $_GET["currency"]!="")
		{
			$getData .= "&currency=".$_GET["currency"];
		}
		$this->load->library('pagination');
		$recordPerPage = 100;
		if($record != 0){
			$record = ($record-1) * $recordPerPage;
		}      	
      	$recordCount = $this->transaction_model->getDonationDeclarations(1);
      	$_GET["length"] = $recordPerPage;
		$_GET["start"] = $record;
      	$data['declarations'] = $this->transaction_model->getDonationDeclarations(0);
      	$config['base_url'] = base_url().'orders/load_donation_declarations';
      	$config['suffix'] = $getData;
      	$config['use_page_numbers'] = TRUE;
		$config['next_link'] = 'Next';
		$config['prev_link'] = 'Previous';
		$config['total_rows'] = $recordCount;
		$config['per_page'] = $recordPerPage;
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		$declarationData = $this->load->view( 'orders/admin/print_declarations_load_more', $data);
		$data['declarationData'] = $declarationData;
		// header("Content-Type:application/json");
		echo json_encode($data);
	}

	public function donations_seva_karta_pdf_report()
	{
		$reports=$this->orders_model->listAdminDonationsSevaKarta();
		$data = array('reports'=>$reports);
		$this->load->view('orders/admin/donations_seva_karta_pdf_report',$data);
	}

	public function poojas_seva_karta_report()
	{
		$reports=$this->orders_model->listAdminPoojasSevaKarta();
		$views = array( 'orders/admin/poojas_seva_karta_report');
		$data = array('views'=>$views,'reports'=>$reports);
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function donations_seva_karta_report()
	{
		$reports=$this->orders_model->listAdminDonationsSevaKarta();
		$views = array( 'orders/admin/donations_seva_karta_report');
		$data = array('views'=>$views,'reports'=>$reports);
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function subscriptions_seva_karta_pdf_report()
	{
		$reports=$this->orders_model->listAdminSubscriptionsSevaKarta();
		$data = array('reports'=>$reports);
		$this->load->view('orders/admin/subscriptions_seva_karta_pdf_report',$data);
	}

	public function subscriptions_seva_karta_report()
	{
		$reports=$this->orders_model->listAdminSubscriptionsSevaKarta();
		$views = array( 'orders/admin/subscriptions_seva_karta_report');
		$data = array('views'=>$views,'reports'=>$reports);
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function clearcart()
	{
		if(isset($this->currentUser->is_currency_specific) && $this->currentUser->is_currency_specific==1)
		{
			redirect('admin');
			return;
		}
		if(isset($_POST["clear_cart_data"]))
		{
			$this->form_validation->set_rules('date_before', 'Clear Till Date', 'trim|required|valid_date|checkClearCartBeforeDate');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("cat_error",1);
				redirect('orders/clearcart');
				return;
			}

			$ashram_id = $_POST['ashram_id'];
			$cart_type = $_POST['cart_type'];
			$user_id = $_POST['user_id'];
			$date_before = $_POST['date_before'];
			
			$resultflag = $this->orders_model->emptyCartData($date_before,$ashram_id,$cart_type,$user_id);
			if($resultflag['flag'] == '1')
			{
				$this->session->set_flashdata("clearcart_success",1);
				if(isset($resultflag['total_removed_rows']))
				{
					$this->session->set_flashdata("total_removed_rows",$resultflag['total_removed_rows']);
				}
				if(isset($resultflag['removed_rows_message']))
				{
					$this->session->set_flashdata("removed_rows_message",$resultflag['removed_rows_message']);
				}
			}
			else
			{
				$this->session->set_flashdata("clearcart_error",1);
			}
			redirect('orders/clearcart');
		}
		else
		{
			$views = array( 'orders/admin/clearcart' );
			$data = array('views'=>$views);
			$data['ashrams']=$this->ashrams_model->getList();
			$this->load->view(ADMIN_TEMPLATE,$data);
			$this->logaction->log($this->service,"Admin - Clear Cart");
		}
	}


	public function orderChangeSchedule()
	{
		$result['flag']=0;
		if(isset($_POST['order_item_id']) && is_numeric($_POST['order_item_id']) && $_POST['order_item_id']>0 && isset($_POST['selected_date']) && $_POST['selected_date']!='')
		{
			$itemData=$this->orders_model->getOrderDataItemDataByOrderItemId($_POST['order_item_id']);
			// echo '<pre>'; print_r($itemData); die();
			if(!empty($itemData))
			{
				$result['order_type'] = $itemData['orderData']['order_type'];
				$data['itemData'] = $itemData;
				$data['selected_date'] = date('d M Y',$_POST['selected_date']);
				ob_start();
				if($itemData['orderData']['order_type'] ==1)
				{
					$this->load->view('orders/admin/_pooja_order_change_schedule',$data);
				}
				else if($itemData['orderData']['order_type'] ==2)
				{
					$this->load->view('orders/admin/_donation_order_change_schedule',$data);
				}
				$result['template']=ob_get_clean();
				$result['flag']=1;
			}
		}
		end:
		echo json_encode($result,JSON_HEX_APOS);
	}

	public function pooja_date_validate()
	{
		if(isset($_POST['order_item_id']) && is_numeric($_POST['order_item_id']) && $_POST['order_item_id'])
		{
			$itemData=$this->orders_model->getOrderDataItemDataByOrderItemId($_POST['order_item_id']);
			if(isset($itemData['orderData']['tokens']) && $itemData['orderData']['tokens']==1)
			{
				echo 'tokenIssued';
				exit;
			}
			if(!empty($itemData) && isset($itemData['poojasData']))
			{
				if(isset($itemData['schedule_dates']) && $itemData['schedule_dates']!='')
				{
					$alreadyScheduledDates = explode(',', $itemData['schedule_dates']);
					if(in_array($_POST['selected_dates'], $alreadyScheduledDates))
					{
						echo "12";
						exit;
					}
				}
				$this->load->model('cart_model');
				$dates_set=$this->cart_model->getPoojaValidDates((object) $itemData['poojasData']);
				$final=array();
				if($_POST['selected_dates']!='')
					$selected=explode(",",$_POST['selected_dates']);
				else
					$selected=array();
				
				if(!empty($selected))
				foreach($selected as $pdate)
				{
					if(in_array($pdate,$dates_set))
					$final[]=$pdate;
				}
				
				foreach($final as $key=>$tms)
				{
					$final[$key]=strtotime($tms);
				}
				
				asort($final);
				
				$store_array=array();
				
				$cnt=0;
				$first='';
				
				
				foreach($final as $key=>$tms)
				{
					if($cnt==0)
					$first=date("d M Y",$tms);
					
					$final[$key]=date("d M Y",$tms);
					$store_array[]=date("d M Y",$tms);
					$cnt++;
				}
				
				if($_POST['save']==1)
				{
					$presentdate = date('d M Y', strtotime($_POST['selected_date']));
					$changeddate = date('d M Y', strtotime($_POST['changed_date']));
					$this->orders_model->updateOrderItemDates($itemData['id'], $presentdate, $changeddate);
				}
				echo implode("<br>",$final);
			}
		}
	}

	public function donation_date_validate()
	{
		if(isset($_POST['order_item_id']) && is_numeric($_POST['order_item_id']) && $_POST['order_item_id'])
		{
			$itemData=$this->orders_model->getOrderDataItemDataByOrderItemId($_POST['order_item_id']);
			if(isset($itemData['orderData']['tokens']) && $itemData['orderData']['tokens']==1)
			{
				echo 'tokenIssued';
				exit;
			}
			if(!empty($itemData) && isset($itemData['donationsData']))
			{
				$final=array();
				if($_POST['selected_dates']!='')
					$selected=array_filter(explode(",",$_POST['selected_dates']));
				else
					$selected=array();

				$startDate=date("d M Y 00:00:00");
				$endDate=date("d M Y 23:59:00",strtotime("+5 Months"));

				if(isset($donationData->subscription) && $donationData->subscription==1)
				{
					if(count($selected)>1)
					{
						echo '10';
						exit;
					}
					$tomorrow=date("d M Y 00:00:00",strtotime("+1 day"));
					if(strtotime($selected[0])<strtotime($tomorrow))
					{
						echo "11";
						exit;
					}
				}

				if(isset($itemData['schedule_dates']) && $itemData['schedule_dates']!='')
				{
					$alreadyScheduledDates = explode(',', $itemData['schedule_dates']);
					if(in_array($_POST['selected_dates'], $alreadyScheduledDates))
					{
						echo "12";
						exit;
					}
				}
				

				$startTime=strtotime($startDate);
				$endTime=strtotime($endDate);
				if(!empty($selected))
				{
					foreach($selected as $selectedDate)
					{
						$tempTime=strtotime($selectedDate);
						if($startTime<=$tempTime && $tempTime<=$endTime)
						{
							$final[]=$selectedDate;
						}
					}
				}
				
				foreach($final as $key=>$tms)
				{
					$final[$key]=strtotime($tms);
				}
				
				asort($final);
				$store_array=array();
				$cnt=0;
				$first='';
				foreach($final as $key=>$tms)
				{
					if($cnt==0)
					$first=date("d M Y",$tms);
					
					$final[$key]=date("d M Y",$tms);
					$store_array[]=date("d M Y",$tms);
					$cnt++;
				}
				
				if($_POST['save']==1)
				{
					$presentdate = date('d M Y', strtotime($_POST['selected_date']));
					$changeddate = date('d M Y', strtotime($_POST['changed_date']));
					$this->orders_model->updateOrderItemDates($itemData['id'], $presentdate, $changeddate);
				}
				echo implode("<br>",$final);
			}
		}
	}

	public function updateUserProfileAddress()
	{
		// echo '<pre>'; print_r($_POST); die();
		$userId=0;
		$tempuser = $this->session->userdata('temp_checkout_user');
		if($this->session->userdata("loggedIn") && $this->session->userdata("user_id"))
		{
			$userId=$this->session->userdata("user_id");
		}
		else if(isset($tempuser->id) && $tempuser->id>0)
		{
			$userId=$tempuser->id;
		}

		if($userId>0)
		{
			$this->load->model("user_model");
			$userDetails=$this->user_model->userData($userId);
			if(isset($userDetails->sso_user_id) && $userDetails->sso_user_id>0)
			{
				$this->auth_check=$this->load->database("sso_auth",true);
				//Update Global user
				$countryData=$this->locations_model->getCountryByCode($_POST['country']);
				
				$updateuserdata = [];
				$updatedonordata = [];
				if(isset($_POST['address1']) && $_POST['address1']!='')
				{
					$updateuserdata['address'] = $_POST['address1'];
					$updatedonordata['donor_address'] = $_POST['address1'];
				}
				if(isset($_POST['address2']) && $_POST['address2']!='')
				{
					$updateuserdata['address1'] = $_POST['address2'];
					$updatedonordata['donor_address1'] = $_POST['address2'];
				}
				if(isset($_POST['address3']) && $_POST['address3']!='')
				{
					$updateuserdata['address2'] = $_POST['address3'];
					$updatedonordata['donor_address2'] = $_POST['address3'];
				}
				if(isset($_POST['country']) && $_POST['country']!='')
				{
					$updateuserdata['country_id'] = $_POST['country'];
					$updatedonordata['donor_address_country_id'] = $_POST['country'];
					$updatedonordata['donor_country_id'] = $_POST['country'];
				}
				if(isset($countryData->isd_code) && $countryData->isd_code!='')
				{
					$updatedonordata['donor_country_isd'] = $countryData->isd_code;
				}
				if(isset($countryData->country_name) && $countryData->country_name!='')
				{
					$updateuserdata['country'] = $countryData->country_name;
					$updatedonordata['donor_country'] = $countryData->country_name;
					$updatedonordata['donor_address_country'] = $countryData->country_name;
				}
				if(isset($_POST['state']) && $_POST['state']!='')
				{
					$updateuserdata['state'] = $_POST['state'];
					$updatedonordata['donor_state'] = $_POST['state'];
				}
				if(isset($_POST['city']) && $_POST['city']!='')
				{
					$updateuserdata['city'] = $_POST['city'];
					$updatedonordata['donor_city'] = $_POST['city'];
				}
				if(isset($_POST['zipcode']) && $_POST['zipcode']!='')
				{
					$updateuserdata['zipcode'] = $_POST['zipcode'];
					$updatedonordata['donor_zipcode'] = $_POST['zipcode'];
				}
				if(isset($_POST['phone']) && $_POST['phone']!='')
				{
					$updateuserdata['phoneno'] = $_POST['phone'];
					$updatedonordata['donor_phone'] = $_POST['phone'];
				}
				//Update Current Site User Address
				$this->db->where("id",$userId);
				$this->db->update('users',$updateuserdata);

				//Update Global User Address
				$this->auth_check->where("id",$userDetails->sso_user_id);
				$this->auth_check->update('users',$updateuserdata);

				//Update Self donor address
				$this->auth_check->where("user_id",$userDetails->sso_user_id);
				$this->auth_check->where("donor_relation","Self");
				$this->auth_check->update("donors",$updatedonordata);

				$this->load->library("dattaid_api");
        		$response = $this->dattaid_api->call($userDetails->sso_user_id);

        		//Update Current User Session with given address 
        		$userDetails=$this->user_model->userData($userId);
        		if($this->session->userdata("id"))
                {
                    if($this->session->userdata('temp_checkout_user'))
                    {
                        $this->session->set_userdata('temp_checkout_user',$userDetails);
                    }
                }
                else if($this->session->userdata("user_id"))
                {
                	$this->session->set_userdata("user_data",$userDetails);
                }
			}

			
		}
	}

	public function adminUpdatePoojaFamilyDonar()
	{
		$this->form_validation->set_rules('orderItemId', 'orderItemId', 'trim|required|numeric');
		$this->form_validation->set_rules('familyType', 'Condition', 'trim|required');
		$this->form_validation->set_rules('userId', 'User Id', 'trim|required|numeric');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$update = $this->orders_model->updateOrderFamilyMemberDonorDetails($_POST);
		if($update)
			echo 1;
		else
			echo 0;
	}

	public function updateOtherName($id=0, $othernamefor=0)
    {
    	if(is_numeric($id) && $id)
		{
	        if(!in_array($othernamefor, [1,2,3,4,5,6,7,8,9,10]))
	        {
	            echo 0;
	            return;
	        }

	        $orderData=$this->orders_model->orderData($id);
			if(empty($orderData['order']))
			{
				echo 0;
				exit;
			}

	        $this->form_validation->set_rules('value', 'Name','trim|required|min_length[2]|max_length[60]');
	        $this->form_validation->set_rules('pk', 'ID', 'trim|required');
	        if($this->form_validation->run() == FALSE)
	        {
	            echo 0;
	            return;
	        }




	        $item=array();
			foreach ($orderData['order_items'] as $orderItem)
			{
				if($this->input->post("pk")==$orderItem->order_item_id)
				{
					$item=$orderItem;
					break;
				}
			}
			
			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
					{
						echo 0;
						return;
					}
				}
			}

			$this->orders_model->updateFriendOtherFamilyDetails($orderData,$item,$othernamefor,$this->input->post("value"));
			echo 1;
        }
		else
		{
			echo 0;
			return;
		}
    }


    public function removeOtherName($id=0)
    {
    	if(is_numeric($id) && $id)
		{
	    	$rowKey = '';
	        $otherNameId = '';
	        if(isset( $_POST['rowKey']) &&  $_POST['rowKey']>0)
	        {
	            $rowKey = $_POST['rowKey'];
	        }
	        if(isset( $_POST['otherNameId']) &&  $_POST['otherNameId']>0)
	        {
	            $otherNameId = $_POST['otherNameId'];
	        }

	    	if($rowKey>0 && $otherNameId>0)
			{
		        if(!in_array($otherNameId, [1,2,3,4,5,6,7,8,9,10]))
		        {
		            echo 0;
		            return;
		        }

		        $orderData=$this->orders_model->orderData($id);
				if(empty($orderData['order']))
				{
					echo 0;
					exit;
				}
				$this->form_validation->set_rules('rowKey', 'Row Key', 'trim|required');
	        	$this->form_validation->set_rules('otherNameId', 'Other Name ID', 'trim|required');
		        if($this->form_validation->run() == FALSE)
		        {
		            echo 0;
		            return;
		        }




		        $item=array();
				foreach ($orderData['order_items'] as $orderItem)
				{
					if($rowKey==$orderItem->order_item_id)
					{
						$item=$orderItem;
						break;
					}
				}
				
				if($this->currentUser->roles!=1)
				{
					if($this->session->userdata("ashramId"))
					{
						if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
						{
							echo 0;
							return;
						}
					}
				}

				if(isset($item->friend_or_other_2) && $item->friend_or_other_2=='')
				{
					echo 3;
					return;
				}

				$this->orders_model->removeFriendOtherFamilyDetails($orderData,$item,$otherNameId);
				echo 1;
	        }
			else
			{
				echo 0;
				return;
			}
		}
		else
		{
			echo 0;
			return;
		}
    }


    public function getOrderAllItemsScheduleDatesView()
	{
		$result['flag']=0;
		if(isset($_POST['order_id']) && is_numeric($_POST['order_id']) && $_POST['order_id']>0)
		{
			$orderDataRow=$this->orders_model->orderRowById($_POST['order_id']);
			if(empty($orderDataRow))
			{
				$result['flag']=2;
			}
			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderDataRow->ashram_id!=$this->session->userdata("ashramId"))
					{
						$result['flag']=3;
					}
				}
				else
				{
					$result['flag']=3;
				}
			}

			if(isset($this->currentUser->is_currency_specific) && $this->currentUser->is_currency_specific==1)
			{
				if(isset($this->currentUser->currencies) && $this->currentUser->currencies!='')
				{
					$accessableCurrencies = explode(',', $this->currentUser->currencies);
					if(!in_array($orderDataRow->currency, $accessableCurrencies))
					{
						$result['flag']=3;
					}
				}
			}
			$data['order_id'] = $_POST['order_id'];
			$data['itemsData']=$this->orders_model->getOrderDataItemDataByOrderId($_POST['order_id']);
			ob_start();
			$this->load->view('orders/admin/order_all_items_schedule_dates_view',$data);
			$result['template']=ob_get_clean();
			$result['flag']=1;
		}
		end:
		echo json_encode($result,JSON_HEX_APOS);
	}

	public function getOrderAllItemsView()
	{
		$result['flag']=0;
		if(isset($_POST['order_id']) && is_numeric($_POST['order_id']) && $_POST['order_id']>0)
		{
			$orderDataRow=$this->orders_model->orderRowById($_POST['order_id']);
			if(empty($orderDataRow))
			{
				$result['flag']=2;
			}
			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderDataRow->ashram_id!=$this->session->userdata("ashramId"))
					{
						$result['flag']=3;
					}
				}
				else
				{
					$result['flag']=3;
				}
			}

			if(isset($this->currentUser->is_currency_specific) && $this->currentUser->is_currency_specific==1)
			{
				if(isset($this->currentUser->currencies) && $this->currentUser->currencies!='')
				{
					$accessableCurrencies = explode(',', $this->currentUser->currencies);
					if(!in_array($orderDataRow->currency, $accessableCurrencies))
					{
						$result['flag']=3;
					}
				}
			}
			$data['order_id'] = $_POST['order_id'];
			$data['orderData']=$this->orders_model->orderRowById($_POST['order_id']);
			$data['itemsData']=$this->orders_model->getOrderDataItemDataByOrderId($_POST['order_id']);
			ob_start();
			$this->load->view('orders/admin/order_all_items_view',$data);
			$result['template']=ob_get_clean();
			$result['flag']=1;
		}
		end:
		echo json_encode($result,JSON_HEX_APOS);
	}

	public function getitemsdatesprice()
	{
		$result['flag']=0;
		$order_id = $this->input->post("order_id");
		if(empty($this->input->post("itemsArray")))
		{
			$result['flag']=1;
			$result["itemPrice"] = 0;
			goto end;
		}
		if(is_numeric($order_id) && $order_id && !empty($this->input->post("itemsArray")))
		{
			$orderData=$this->orders_model->orderData($order_id);
			if(empty($orderData['order']))
			{
				$result['error']="Invalid request";
				goto end;
			}
			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
					{
						$result['error']="Invalid request";
						goto end;
					}
				}
				else
				{
					$result['error']="Invalid request";
					goto end;
				}
			}
			$result['flag']=1;
			$itemsArray = $this->input->post("itemsArray");
			$builtArray = array();
			$itemPrice = 0;
			foreach ($itemsArray as $key => $value) 
			{
				$ids_and_dates = explode("_", $value);
				$builtArray[$ids_and_dates[0]][] = $ids_and_dates[1];
			}

			foreach ($builtArray as $key1 => $value1) 
			{
				$itemPrice+= $this->getitemsdatespriceWeb($order_id,$key1,count($value1));
			}
			$result["itemPrice"] = $itemPrice;
		}
		end:
		header("Content-Type:application/json");
		echo json_encode($result);
	}

	public function getitemsdatespriceWeb($order_id,$orderitemId,$itemlength)
	{
		if(is_numeric($order_id) && $order_id)
		{
			$orderData=$this->orders_model->orderData($order_id);
			if(empty($orderData['order']))
			{
				return false;
			}
			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
					{
						return false;
					}
				}
				else
				{
					return false;
				}
			}
			$itemData=$this->orders_model->getOrderDataItemDataByOrderItemId($orderitemId);
			$itemPrice = $itemData['price'] * $itemlength;
			return $itemPrice;
		}
	}

	public function processReplaceItems($order_id=0)
	{
		$returnData["flag"] =0;
		$orderDataRow=$this->orders_model->orderRowById($order_id);
		if(empty($orderDataRow))
		{
			$returnData['flag']=2;
		}
		if(!empty($this->input->post("itemsArray")))
		{
			$itemsArray = $this->input->post("itemsArray");
			$builtArray = array();
			$itemPrice = 0;
			foreach ($itemsArray as $key => $value) 
			{
				$ids_and_dates = explode("_", $value);
				$builtArray[$ids_and_dates[0]][] = $ids_and_dates[1];
			}

			foreach ($builtArray as $key1 => $value1) 
			{
				$itemPrice+= $this->getitemsdatespriceWeb($order_id,$key1,count($value1));
			}
			$sessionData = array("orderId"=>$order_id,"total_amount"=>$itemPrice,"posted_items"=>$itemsArray,"items_and_dates"=>$builtArray,"user_id"=>$orderDataRow->user_id,"order_type"=>$orderDataRow->order_type,"currency"=>strtolower($orderDataRow->currency),"ashram_id"=>$orderDataRow->ashram_id,"refund_failed_count"=>$orderDataRow->refund_failed_count);
			if($orderDataRow->refund_failed_count >= 3)
			{
				$orderTxData = $this->transaction_model->getorderPayments($order_id,$itemPrice);
				$orderData = $this->orders_model->orderData($order_id);
				$sessionData["orderData"] = $orderData;
				$sessionData["txData"] = $orderTxData;
			}
			$this->session->set_userdata("cart_items_from_seva_details",$sessionData);

			$userData=$this->users_model->userData($orderDataRow->user_id);
			if(!empty($userData))
			{
				if($userData->status==1 && $userData->deleted==0 && $userData->email_verified==1)
				{
					unset($userData->pin);
					unset($userData->pass);
					unset($userData->conf_key);
					unset($userData->forgot_key);
					unset($userData->pin_copy);
					unset($userData->first_logged_in);
					unset($userData->security_complete);
					unset($userData->pin_set);
					unset($userData->role);
					unset($userData->roles);
					unset($userData->last_logged_in);
					$this->session->set_userdata('temp_checkout_user',$userData);
					$data['flag']=1;
					$data['userdata']=$userData;
				}
			}

			if($orderDataRow->order_type == 1)
			{
				$redirectUrl = base_url."poojas?ashram_id=".$orderDataRow->ashram_id."&currency=".strtolower($orderDataRow->currency);
			}
			if($orderDataRow->order_type == 2)
			{
				$redirectUrl = base_url."donations?ashram_id=".$orderDataRow->ashram_id."&currency=".strtolower($orderDataRow->currency);
			}
			if($orderDataRow->order_type == 3)
			{
				$redirectUrl = base_url."store?ashram_id=".$orderDataRow->ashram_id."&currency=".strtolower($orderDataRow->currency);
			}
			if($orderDataRow->order_type == 4)
			{
				$redirectUrl = base_url."subscriptions?ashram_id=".$orderDataRow->ashram_id."&currency=".strtolower($orderDataRow->currency);
			}
			$returnData['flag']=1;
			$returnData['redirectUrl']=$redirectUrl;
		}
		echo json_encode($returnData);
	}

	public function getOrderTotalPrice($orderData)
	{
		$orderTotal = 0;
		foreach ($orderData['order_items'] as $itemData)
        {
        	if($itemData->fully_refunded == 1)
        	{
        		$amount=0;
        	}
        	else
        	{
        		if($itemData->order_type == 3)
        			$amount = $itemData->quantity * $itemData->price;
        		else
        		{
        			if(!empty($itemData->schedule_dates))
        			{
        				$itemDates = explode(",", $itemData->schedule_dates);
        				$itemDates_quantity = count($itemDates);
        				$amount = $itemDates_quantity * $itemData->price;
        			}
        			else
        			{
        				$amount = $itemData->price;
        			}
        		}	
        	}
        	$orderTotal+=$amount;
        }
        return $orderTotal;
	}

	/*
	Function: To attach items to existing order (Partial replication of make_payment method in this controller)
	Param: $orderId - (Pass Order ID)
	Developer: Baji Shaik
	Created On: 25th May 2021
	*/
	public function attachItemstoOrder($orderId=0)
	{
   		//Check site settings
    	$result['flag']=0;
    	if($GLOBALS['site_settings']['enable_orders']==0)
		{
			$result['flag']=3;
			goto end;
		}
		$orderData = $this->orders_model->orderData($orderId);
		if(empty($orderData))
		{
			$result['flag']=3;
			goto end;
		}
    	if($this->session->userdata("loggedIn") && $this->currentUser->admin==0)
		{
			if($this->currentUser->email_verified==0)
			{
				$result['flag']=51;
				goto end;
			}
		}
		if($orderData["order"]->refund_failed_count >= 3)
		{
			if(empty($this->input->post("tx_status")))
			{
				$result['flag']=5123;
				goto end;
			}
			if($this->input->post("tx_status")=='refund')
			{
				$this->form_validation->set_rules('refund_reference', 'Refund reference','trim|required|max_length[100]');
				$this->form_validation->set_rules('refund_date', 'Refund date','trim|required|valid_date');
				$this->form_validation->set_rules('refund_mode', 'Refund modee','trim|required|checkCashModes');
			}
		}
		$currency = strtolower($orderData["order"]->currency);
		$ashram_id = $orderData["order"]->ashram_id;
		$order_type = $orderData["order"]->order_type;
	 	//Validate form data
	 	if(!isset($_POST["firstname"]) || !isset($_POST["lastname"]) || !isset($_POST["preferred_name"]) || !isset($_POST["email"]) || !isset($_POST["phone"]) || !isset($_POST["address1"]) || !isset($_POST["address2"]) || !isset($_POST["address3"]) || !isset($_POST["city"]) || !isset($_POST["state"]) || !isset($_POST["country"]) || !isset($_POST["donation_initials"]))
		{
	 		goto end;
		}

		//Get trust accounts for Ashram and Currency defined
		$trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($ashram_id,$order_type);
    	$trustsArray=array();
    	foreach ($trusts as $trustData)
    	{
    		$trustsArray[$trustData->currency]=$trustData;
    	}
    	$customData['trustData']=$trustsArray[strtolower($currency)];

		$this->form_validation->set_rules('firstname', 'First Name','trim|required|min_length[2]|max_length[50]|lettersonly');
		$this->form_validation->set_rules('lastname', 'Last Name','trim|required|min_length[2]|max_length[50]|lettersonly');
		$this->form_validation->set_rules('preferred_name', 'Preferred Name','trim|required|min_length[2]|max_length[50]');
		$this->form_validation->set_rules('email', 'Email ID','trim|required|no_uppercase|valid_email_custom|min_length[6]|max_length[100]');
		$this->form_validation->set_rules('phone', 'Phone Number','trim|required|numeric|min_length[8]|max_length[15]');
		$this->form_validation->set_rules('address1', 'Address Line 1','trim|required|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('address2', 'Address Line 2','trim|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('address3', 'Address Line 3','trim|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('city', 'City','trim|required|min_length[2]|max_length[100]|name_validate13');
		$this->form_validation->set_rules('state', 'State','trim|required|min_length[2]|max_length[100]|name_validate13');
		$this->form_validation->set_rules('country', 'Country','trim|required|checkCountry');
		$this->form_validation->set_rules('zipcode', 'ZIP Code','trim|required|alphabetsnumbers|min_length[3]|max_length[15]');
		$this->form_validation->set_rules('donation_initials', 'Initials','trim|required|min_length[3]|max_length[25]');
		if($this->currentUser->admin==1)
		{
			$this->form_validation->set_rules('payment_mode', 'Payment Mode','trim|required|checkAdminPaymentMode');
			$paymentMode=$this->input->post("payment_mode");
		}
		else
		{
			$paymentMode=$customData['trustData']->payment_mode;
		}

		if($this->form_validation->run() == FALSE)
		{
			$result['error']=validation_errors();
	 		goto end;
		}
		$this->load->model("cart_model");
		if($order_type == 1)
		{
			$this->load->library('poojascart');
			//Validate Cart items
			$this->cart_model->validateCart($this->poojascart);
			//Check cart items count
			$cartContents=$this->poojascart->contents();
			$amount=$this->cart_model->getTotalPrice($this->poojascart);
		}
		if($order_type == 2)
		{
			$this->load->library('donationscart');
			//Validate Cart items
			$this->cart_model->validateCart($this->donationscart);
			//Check cart items count
			$cartContents=$this->donationscart->contents();
			$amount=$this->cart_model->getTotalPrice($this->donationscart);
		}
		if($order_type == 3)
		{
			$this->load->model('ashrams/store_cover_photos_model');
			$this->load->model('ashrams/store_files_model');
			$this->load->model('ashrams/store_types_model');
			$this->load->library('storecart');
			//Validate Cart items
			$this->cart_model->validateCart($this->storecart);
			//Check cart items count
			$cartContents=$this->storecart->contents();
			$amount=$this->cart_model->getTotalPrice($this->storecart);
		}
		
		if(empty($cartContents)) //If cart is empty
		{
			$result['flag']=2;
	 		goto end;
		}

		$totalItems=count($cartContents);
		$validItems=0;
		foreach ($cartContents as $cartItem)
		{
			if($cartItem['options']['status']==1)
			{
				$validItems++;
			}
		}

		//Check all items in cart are valid
		if($validItems!=$totalItems)
		{
			$result['flag']=4;
	 		goto end;
		}

		//Capture User ID
		$userId=0;

		if($this->session->userdata("loggedIn"))
		{
			if($this->currentUser->admin==1)
			{
				if($this->session->userdata('temp_checkout_user'))
				{
					$tData=$this->session->userdata('temp_checkout_user');
					$userId=$tData->id;
				}
			}
			else
			{
				$userId=$this->currentUser->id;
			}
		}

    	$this->load->model('ashrams/ashrams_model');

    	//Define custom data before initializing transaction
    	$created_by_user_id=0;
    	$created_by=0;
		$userData=array();
		if($this->session->userdata('id'))
		{
			if($this->session->userdata('temp_checkout_user'))
			{
				$userData=$this->session->userdata('temp_checkout_user');
				$userId=$userData->id;
			}
			$created_by=1;
		}
		else if($this->session->userdata('user_id'))
		{
			$userId=$this->session->userdata('user_id');
			$userData=$this->currentUser;
			$created_by=2;
		}

		$this->cart_log_model->log("Payment initiated",$ashram_id,$order_type);

		//If payment mode not set or payment mode is default
		if(!isset($paymentMode) || $paymentMode=='default')
		{
			$paymentMode=$customData['trustData']->payment_mode;
		}

		if($this->session->userdata('loggedIn'))
			$created_by_user_id=$this->currentUser->id;

		$customData['cartData']=$cartContents;
		$customData['formData']=$_POST;
		$customData['ashramData']=$this->ashrams_model->ashramData($ashram_id);
		$customData['cart_type']=$order_type;
		$customData['paymentMode']=$paymentMode;
		$customData['created_by']=$created_by;
		$customData['created_by_user_id']=$created_by_user_id;
		$customData['model']="orders/orders_model";
		$customData['model_name']="orders_model";
		$customData['ip_address']=$_SERVER['REMOTE_ADDR'];
		$customData['formData']['ashram_id']=$ashram_id;
		$reference = random_string('alnum',12);
		$this->cart_model->updateReferenceId($reference,$order_type);

		$customData['formData']['is_manual_payment']=0;
		if($this->input->post("is_manual_payment"))
		{
			$customData['formData']['is_manual_payment']=1;
		}

		$customData['amount_in_words']=$this->general_model->amountToWords($amount);
		$result['payment_mode']=$paymentMode;
		$result['flag']=1;
		$colorstrips = array("palegoldenrod","aqua","antiquewhite","cornsilk","peachpuff","yellow","red","blue","black");
		$strip_color = $colorstrips[array_rand($colorstrips, 1)];
		if($paymentMode=='cash')
		{
			$this->load->model("refunds_history_model");
			$ref_url = base_url."orders/view/".$orderId;
			$batchId = time();
			$offlineResponse=$this->refunds_history_model->attach_items_to_order($orderData,$orderId,$customData,$reference,$batchId,$amount,$strip_color);
			$replaced_item_names = $offlineResponse["item_names"];
			$replaced_item_ids = $offlineResponse["item_ids"];

			// If Cart amount is greater than processed amount business logics implementation
			if($amount < $this->session->userdata("cart_items_from_seva_details")["total_amount"])
			{
				$totalPrice =$this->session->userdata("cart_items_from_seva_details")["total_amount"] - $amount;

				$orderTxData = $this->transaction_model->getorderPayments($orderId,$totalPrice);
				if(empty($orderTxData))
				{
					$result["flag"] =20225;
					goto end;
				}

				$txData=$this->payment_model->getTransaction($orderTxData->tx);
				$orderData=$this->orders_model->orderData($orderId);
				if(!empty($txData) && !empty($orderData))
				{
					if($orderData["order"]->refund_failed_count>=3)
					{
						$refundId = random_string('alnum',16);
						$order_latest_tx = $this->refunds_history_model->getOrderOriginalTX($orderId);
						$this->refunds_history_model->createRefundTx($refundId, $order_latest_tx,$totalPrice,$orderData["order"]->total_price,$orderData["order"]->total_refunded_amount,0);
					}
					else
					{
						$returnData = array();
						$refundId = random_string('alnum',16);
						if($orderData["order"]->payment_mode == "Offline" || $txData->payment_mode == "cash" || $txData->payment_mode == "neft" || $txData->payment_mode == "cheque" || $txData->payment_mode == "cc" || $txData->payment_mode == "dc")
						{
							$returnData['status'] = 1;
							$returnData['response'] = "success";
							$returnData['message'] = "success";
							$refundId = random_string('alnum',16);
						}
						else
						{
							$this->load->library("onlinerefund");
							$returnData = $this->onlinerefund->process_refund($txData->payment_mode,$txData,$orderData,$totalPrice);
						}
						$this->load->model("refunds_history_model");
						if($returnData['status'] == 1 && !empty($returnData['response']))
						{
							//Status 1 Indicates Refund Initiated successfully from gateway level
							$this->refunds_history_model->saveHistory($txData,$orderData,$returnData['response'],1,0,$returnData['message']);

							$subscription = $txData->subscription;
							if(strtolower($txData->payment_mode) == "paypal")
							{
								if(!empty($returnData['response']['PNREF']))
									$refundId = $returnData['response']['PNREF'];
								else
									$refundId = substr(hash('sha256', mt_rand() . microtime()), 0, 10);
							}
							else if(strtolower($txData->payment_mode) == "payu")
							{
								$refundId 		= $returnData['response']->result;
							}
							else if(strtolower($txData->payment_mode) == "razorpay")
							{
								$refundId 		= $returnData['response']->id;
							}
							else if(strtolower($txData->payment_mode) == "stripe")
							{
								$refundId 		= $returnData['response']->id;
							}
							else if(strtolower($orderData["order"]->payment_mode) == "offline")
							{
								$refundId 		= random_string('alnum',16);
							}
						}
						else
						{
							$refund_fail_count = $orderData["order"]->refund_failed_count+1;
							$update_fail_countData = array("refund_failed_count"=>$refund_fail_count,"partially_refunded"=>1);
							$this->refunds_history_model->update_order_total($orderId,$update_fail_countData);
							$returnData["flag"] =20225;
							goto end;
						}
						$this->refunds_history_model->createRefundTx($refundId, $txData,$totalPrice,$orderData["order"]->total_price,$orderData["order"]->total_refunded_amount,0);
					}
				}
				$order_latest_tx = $this->refunds_history_model->getOrderOriginalTX($orderId);
				if(!empty($order_latest_tx))
				{
					//Cart amount is lesser than processed amount
					$system_generated_tx = "charge_".random_string('alnum',16);
					$system_generated_refund_id = "refund_".random_string('alnum',16);
					$r_total_price = $amount;
					$r_total_refund = $this->session->userdata("cart_items_from_seva_details")["total_amount"] - $totalPrice;
					$this->refunds_history_model->createSystemTx($system_generated_refund_id, $order_latest_tx,$r_total_refund,"Refunded");
					$this->refunds_history_model->createSystemTx($system_generated_tx, $order_latest_tx,$r_total_price,"paid");
				}

				$totalPaid = $this->refunds_history_model->getordertotalpaid($orderId);
				$totalRefunded = $this->refunds_history_model->getordertotalrefunded($orderId);
				$totalPaid = $totalPaid - $totalRefunded;
				$total_replaced_amount = $orderData["order"]->total_replaced_amount + $amount;
				$orderTotalPrice = $orderData["order"]->order_total_price + $amount;
				$orderTotalRefunded = $orderData["order"]->total_refunded_amount + $this->session->userdata("cart_items_from_seva_details")["total_amount"];
				$totalPrice = $orderData["order"]->total_price + $amount;
				
				$updateData = array("paid"=>$totalPaid,"total_paid"=>$totalPaid,"order_total_price"=>$orderTotalPrice,"total_refunded_amount"=>$orderTotalRefunded,"partially_refunded"=>1,"total_replaced_amount"=>$total_replaced_amount);

				$this->refunds_history_model->update_order_total($orderId,$updateData);
				$itemsArray = $this->session->userdata("cart_items_from_seva_details")["posted_items"];
				$builtArray = $this->session->userdata("cart_items_from_seva_details")["items_and_dates"];
				if($orderData["order"]->order_type != 3)
				{
					foreach ($itemsArray as $key12 => $value12) 
					{
						$ids_and_dates = explode("_", $value12);

						$r_itemId = $ids_and_dates[0];
						$r_date = $ids_and_dates[1];
						$array = array("order_id"=>$orderId,"created_on"=>date("Y-m-d H:i:s"),"refund_or_replaced"=>"Replaced","date"=>date("Y-m-d",strtotime($r_date)),"order_item_id"=>$r_itemId);
						$this->refunds_history_model->order_items_dates_log($array);
						$this->refunds_history_model->remove_order_items_dates($r_itemId,$r_date);
					}
				}
				foreach ($builtArray as $key1 => $value1) 
				{
					$itemDates = implode(",", $value1);
					$itemData=$this->orders_model->getOrderDataItemDataByOrderItemId($key1);
					if($itemData['order_type'] == 3)
					{
						$itemDates = null;
					}
					$new_itemPrice= $this->getitemsdatespriceWeb($orderId,$key1,count($value1));
					$refundData = array(
						"order_id"=>$orderId,
						"order_item_id"=>$key1,
						"ashram_id"=>$orderData["order"]->ashram_id,
						"currency"=>$orderData["order"]->currency,
						"order_number"=>$orderData["order"]->order_number,
						"refund_id"=>null,
						"original_items_names"=>$itemData['item_name'],
						"original_transaction_id"=>null,
						"replaced_items"=>$replaced_item_ids,
						"replaced_items_names"=>$replaced_item_names,
						"amount"=>$new_itemPrice,
						"original_dates"=>$itemDates,
						"cart_type"=>$orderData["order"]->order_type,
						"created_on"=>date("Y-m-d H:i:s"),
						"refund_flag"=>0,
						"replace_flag"=>1,
						"batch_id"=>$batchId,
					);
					$this->refunds_history_model->order_items_refund_replace_logs($refundData);
					$itemQuantity = count($value1);
					$updatedQuantity = $itemData["quantity"] - ($itemQuantity + $itemData["updated_quantity"]);

					if($orderData["order"]->order_type == 3)
					{
						$tx_note = "Order Item Modified\nItem Name: ".$itemData['item_name']."\nItem Replaced\nProcessed Date: ".Date("d M Y H:i A");
					}
					else
					{
						$tx_note = "Order Item Modified\nItem Name: ".$itemData['item_name']."\nRefunded Dates: ".$itemDates."\nItem Replaced\nProcessed Date: ".Date("d M Y H:i A");
					}
					//Order Log Data
					$this->order_log_model->log($orderData['order']->id,$tx_note);

					$fullyRefunded = 0;
					$item_replaced = 1;
					if($orderData["order"]->order_type != 3)
					{
						if(isset($itemData['schedule_dates']) && $itemData['schedule_dates']!='')
						{
							$alreadyScheduledDates = explode(',', $itemData['schedule_dates']);
							$totalscDates = count($alreadyScheduledDates);
							$selectScDates = count($value1);
							if($totalscDates == $selectScDates)
							{
								$fullyRefunded = 1;
							}
							foreach ($value1 as $date_key => $date_value) 
							{
								foreach ($alreadyScheduledDates as $prev_date_key => $prev_date_value) 
								{
									if($prev_date_value == $date_value)
										unset($alreadyScheduledDates[$prev_date_key]);
								}
							}
						}
						if(!empty($alreadyScheduledDates))
							$alreadyScheduledDates = implode(",", $alreadyScheduledDates);
						else
							$alreadyScheduledDates = "";
					}
					else
					{
						$fullyRefunded = 1;
						$alreadyScheduledDates = "";
					}

					$refunded_item_amount = $new_itemPrice + $itemData["refunded_amount"];
					$this->refunds_history_model->update_order_item_flags($fullyRefunded,$refunded_item_amount,$key1,$alreadyScheduledDates,$batchId,$item_replaced,$updatedQuantity,$strip_color);
				}
				$orderData = $this->orders_model->orderData($orderId);
				$calculated_order_total_price = $orderData["order"]->original_total_price - $totalRefunded;
				$updateData = array("total_price"=>$calculated_order_total_price);
				$this->refunds_history_model->update_order_total($orderId,$updateData);
				$this->refunds_history_model->sendRefundItemsEmail($orderId,$batchId,0);
			}
			if($amount > $this->session->userdata("cart_items_from_seva_details")["total_amount"])
			{
				$totalPrice = $amount - $this->session->userdata("cart_items_from_seva_details")["total_amount"];
				$totalPrice = $orderData["order"]->total_price + $totalPrice;

				$order_latest_tx = $this->refunds_history_model->getOrderOriginalTX($orderId);
				if(!empty($order_latest_tx))
				{
					//Cart amount is greater than processed amount
					$system_generated_tx = "charge_".random_string('alnum',16);
					$system_generated_refund_id = "refund_".random_string('alnum',16);
					$r_total_price = $this->session->userdata("cart_items_from_seva_details")["total_amount"];
					$r_total_refund = $this->session->userdata("cart_items_from_seva_details")["total_amount"];
					$this->refunds_history_model->createSystemTx($system_generated_refund_id, $order_latest_tx,$r_total_refund,"Refunded");
					$this->refunds_history_model->createSystemTx($system_generated_tx, $order_latest_tx,$r_total_price,"paid");
				}
				
				$totalPaid = $this->refunds_history_model->getordertotalpaid($orderId);
				$totalRefunded = $this->refunds_history_model->getordertotalrefunded($orderId);
				$totalPaid = $totalPaid - $totalRefunded;
				$orderTotalPrice = $orderData["order"]->order_total_price + $amount;
				$orderTotalRefunded = $orderData["order"]->total_refunded_amount + $this->session->userdata("cart_items_from_seva_details")["total_amount"];
				$total_replaced_amount = $orderData["order"]->total_replaced_amount + $amount;
				$refundedAmount = $orderData["order"]->total_refunded_amount+$this->session->userdata("cart_items_from_seva_details")["total_amount"];
				$updateData = array("payment_status"=>2,"partial_payments_allowed"=>0,"paid"=>$totalPaid,"total_paid"=>$totalPaid,"partially_refunded"=>1,"order_total_price"=>$orderTotalPrice,"total_refunded_amount"=>$orderTotalRefunded,"total_replaced_amount"=>$total_replaced_amount);
				$this->refunds_history_model->update_order_total($orderId,$updateData);
				$itemsArray = $this->session->userdata("cart_items_from_seva_details")["posted_items"];
				$builtArray = $this->session->userdata("cart_items_from_seva_details")["items_and_dates"];
				if($orderData["order"]->order_type != 3)
				{
					foreach ($itemsArray as $key12 => $value12) 
					{
						$ids_and_dates = explode("_", $value12);

						$r_itemId = $ids_and_dates[0];
						$r_date = $ids_and_dates[1];
						$array = array("order_id"=>$orderId,"created_on"=>date("Y-m-d H:i:s"),"refund_or_replaced"=>"Replaced","date"=>date("Y-m-d",strtotime($r_date)),"order_item_id"=>$r_itemId);
						$this->refunds_history_model->order_items_dates_log($array);
						$this->refunds_history_model->remove_order_items_dates($r_itemId,$r_date);
					}
				}
				foreach ($builtArray as $key1 => $value1) 
				{
					$itemDates = implode(",", $value1);
					$itemData=$this->orders_model->getOrderDataItemDataByOrderItemId($key1);
					$new_itemPrice= $this->getitemsdatespriceWeb($orderId,$key1,count($value1));
					if($itemData['order_type'] == 3)
					{
						$itemDates = null;
					}
					$refundData = array(
						"order_id"=>$orderId,
						"order_item_id"=>$key1,
						"refund_id"=>null,
						"original_transaction_id"=>null,
						"ashram_id"=>$orderData["order"]->ashram_id,
						"currency"=>$orderData["order"]->currency,
						"replaced_items"=>$replaced_item_ids,
						"order_number"=>$orderData["order"]->order_number,
						"replaced_items_names"=>$replaced_item_names,
						"original_items_names"=>$itemData['item_name'],
						"amount"=>$new_itemPrice,
						"original_dates"=>$itemDates,
						"cart_type"=>$orderData["order"]->order_type,
						"created_on"=>date("Y-m-d H:i:s"),
						"refund_flag"=>1,
						"replace_flag"=>1,
						"batch_id"=>$batchId,
					);
					$this->refunds_history_model->order_items_refund_replace_logs($refundData);
					$itemQuantity = count($value1);
					$updatedQuantity = $itemData["quantity"] - ($itemQuantity + $itemData["updated_quantity"]);
					if($orderData["order"]->order_type == 3)
					{
						$tx_note = "Order Item Modified\nItem Name: ".$itemData['item_name']."\nItem Replaced\nProcessed Date: ".Date("d M Y H:i A");
					}
					else
					{
						$tx_note = "Order Item Modified\nItem Name: ".$itemData['item_name']."\nRefunded Dates: ".$itemDates."\nItem Replaced\nProcessed Date: ".Date("d M Y H:i A");
					}
					//Order Log Data
					$this->order_log_model->log($orderData['order']->id,$tx_note);

					$fullyRefunded = 0;
					$item_replaced = 1;
					if($orderData["order"]->order_type != 3)
					{
						if(isset($itemData['schedule_dates']) && $itemData['schedule_dates']!='')
						{
							$alreadyScheduledDates = explode(',', $itemData['schedule_dates']);
							$totalscDates = count($alreadyScheduledDates);
							$selectScDates = count($value1);
							if($totalscDates == $selectScDates)
							{
								$fullyRefunded = 1;
							}
							foreach ($value1 as $date_key => $date_value) 
							{
								foreach ($alreadyScheduledDates as $prev_date_key => $prev_date_value) 
								{
									if($prev_date_value == $date_value)
										unset($alreadyScheduledDates[$prev_date_key]);
								}
							}
						}
						if(!empty($alreadyScheduledDates))
							$alreadyScheduledDates = implode(",", $alreadyScheduledDates);
						else
							$alreadyScheduledDates = "";
					}
					else
					{
						$fullyRefunded = 1;
						$alreadyScheduledDates = "";
					}

					$refunded_item_amount = $new_itemPrice + $itemData["refunded_amount"];
					$this->refunds_history_model->update_order_item_flags($fullyRefunded,$refunded_item_amount,$key1,$alreadyScheduledDates,$batchId,$item_replaced,$updatedQuantity,$strip_color);
				}
				$orderData = $this->orders_model->orderData($orderId);
				$calculated_order_total_price = $orderData["order"]->original_total_price - $totalRefunded;
				$updateData = array("total_price"=>$calculated_order_total_price);
				$this->refunds_history_model->update_order_total($orderId,$updateData);
				$this->orders_model->sendCollectPaymentEmail($orderId);
			}
			if($amount == $this->session->userdata("cart_items_from_seva_details")["total_amount"])
			{
				$itemsArray = $this->session->userdata("cart_items_from_seva_details")["posted_items"];
				$builtArray = $this->session->userdata("cart_items_from_seva_details")["items_and_dates"];

				$order_latest_tx = $this->refunds_history_model->getOrderOriginalTX($orderId);
				if(!empty($order_latest_tx))
				{
					//Cart amount is equal to processed amount
					$system_generated_tx = "charge_".random_string('alnum',16);
					$system_generated_refund_id = "refund_".random_string('alnum',16);
					$r_total_price = $this->session->userdata("cart_items_from_seva_details")["total_amount"];
					$r_total_refund = $this->session->userdata("cart_items_from_seva_details")["total_amount"];
					$this->refunds_history_model->createSystemTx($system_generated_refund_id, $order_latest_tx,$r_total_refund,"Refunded");
					$this->refunds_history_model->createSystemTx($system_generated_tx, $order_latest_tx,$r_total_price,"paid");
				}

				$totalPrice = $orderData["order"]->total_price + $amount;
				$orderTotalPrice = $orderData["order"]->order_total_price + $amount;
				$orderTotalRefunded = $orderData["order"]->total_refunded_amount + $this->session->userdata("cart_items_from_seva_details")["total_amount"];
				$total_replaced_amount = $orderData["order"]->total_replaced_amount + $amount;
				$updateData = array("partially_refunded"=>1,"order_total_price"=>$orderTotalPrice,"total_refunded_amount"=>$orderTotalRefunded,"total_replaced_amount"=>$total_replaced_amount);
				$this->refunds_history_model->update_order_total($orderId,$updateData);
				if($orderData["order"]->order_type != 3)
				{
					foreach ($itemsArray as $key12 => $value12) 
					{
						$ids_and_dates = explode("_", $value12);

						$r_itemId = $ids_and_dates[0];
						$r_date = $ids_and_dates[1];
						$array = array("order_id"=>$orderId,"created_on"=>date("Y-m-d H:i:s"),"refund_or_replaced"=>"Replaced","date"=>date("Y-m-d",strtotime($r_date)),"order_item_id"=>$r_itemId);
						$this->refunds_history_model->order_items_dates_log($array);
						$this->refunds_history_model->remove_order_items_dates($r_itemId,$r_date);
					}
				}
				foreach ($builtArray as $key1 => $value1) 
				{
					$itemDates = implode(",", $value1);
					$new_itemPrice= $this->getitemsdatespriceWeb($orderId,$key1,count($value1));
					$itemData=$this->orders_model->getOrderDataItemDataByOrderItemId($key1);
					if($itemData['order_type'] == 3)
					{
						$itemDates = null;
					}
					$refundData = array(
						"order_id"=>$orderId,
						"order_item_id"=>$key1,
						"refund_id"=>null,
						"original_items_names"=>$itemData['item_name'],
						"original_transaction_id"=>null,
						"replaced_items"=>$replaced_item_ids,
						"order_number"=>$orderData["order"]->order_number,
						"replaced_items_names"=>$replaced_item_names,
						"amount"=>$new_itemPrice,
						"ashram_id"=>$orderData["order"]->ashram_id,
						"currency"=>$orderData["order"]->currency,
						"original_dates"=>$itemDates,
						"cart_type"=>$orderData["order"]->order_type,
						"created_on"=>date("Y-m-d H:i:s"),
						"refund_flag"=>0,
						"replace_flag"=>1,
						"batch_id"=>$batchId,
					);
					$this->refunds_history_model->order_items_refund_replace_logs($refundData);
					$itemQuantity = count($value1);
					$updatedQuantity = $itemData["quantity"] - ($itemQuantity + $itemData["updated_quantity"]);
					if($orderData["order"]->order_type == 3)
					{
						$tx_note = "Order Item Modified\nItem Name: ".$itemData['item_name']."\nItem Replaced\nProcessed Date: ".Date("d M Y H:i A");
					}
					else
					{
						$tx_note = "Order Item Modified\nItem Name: ".$itemData['item_name']."\nProcessed Dates: ".$itemDates."\nItem Replaced\nProcessed Date: ".Date("d M Y H:i A");
					}
					//Order Log Data
					$this->order_log_model->log($orderData['order']->id,$tx_note);

					$fullyRefunded = 0;
					$item_replaced = 1;
					if($orderData["order"]->order_type != 3)
					{
						if(isset($itemData['schedule_dates']) && $itemData['schedule_dates']!='')
						{
							$alreadyScheduledDates = explode(',', $itemData['schedule_dates']);
							$totalscDates = count($alreadyScheduledDates);
							$selectScDates = count($value1);
							if($totalscDates == $selectScDates)
							{
								$fullyRefunded = 1;
							}
							foreach ($value1 as $date_key => $date_value) 
							{
								foreach ($alreadyScheduledDates as $prev_date_key => $prev_date_value) 
								{
									if($prev_date_value == $date_value)
										unset($alreadyScheduledDates[$prev_date_key]);
								}
							}
						}
						if(!empty($alreadyScheduledDates))
							$alreadyScheduledDates = implode(",", $alreadyScheduledDates);
						else
							$alreadyScheduledDates = "";
					}
					else
					{
						$fullyRefunded = 1;
						$alreadyScheduledDates = "";
					}
					$refunded_item_amount = $new_itemPrice + $itemData["refunded_amount"];
					$this->refunds_history_model->update_order_item_flags($fullyRefunded,$refunded_item_amount,$key1,$alreadyScheduledDates,$batchId,$item_replaced,$updatedQuantity,$strip_color);
				}
				$orderData = $this->orders_model->orderData($orderId);
				$totalRefunded = $this->refunds_history_model->getordertotalrefunded($orderId);
				$calculated_order_total_price = $orderData["order"]->original_total_price - $totalRefunded;
				$updateData = array("total_price"=>$calculated_order_total_price);
				$this->refunds_history_model->update_order_total($orderId,$updateData);
			}
			unset($_SESSION['cart_items_from_seva_details']);
			$result['redirect_to']=$ref_url;
			$result['payment_status']=1;
			$this->session->set_flashdata("order_placed",1);
			$this->session->set_userdata("order_placed",1);
			$this->cart_log_model->log("Payment pending:".$paymentMode,$ashram_id,$order_type);
		}

		end:
		echo json_encode($result);
	}

	/*
	Function: To Do partial Refunds for Online / Offline Orders
	Param: $orderId - (Pass Order ID)
	Developer: Baji Shaik
	Created On: 25th May 2021
	*/
	public function partial_refund_online($orderId)
	{
		$returnData["flag"] =0;
		if(!empty($this->input->post("itemsArray")))
		{
			$itemsArray = $this->input->post("itemsArray");
			$builtArray = array();
			$itemPrice = 0;
			foreach ($itemsArray as $key => $value) 
			{
				$ids_and_dates = explode("_", $value);
				$builtArray[$ids_and_dates[0]][] = $ids_and_dates[1];
			}

			foreach ($builtArray as $key1 => $value1) 
			{
				$itemPrice+= $this->getitemsdatespriceWeb($orderId,$key1,count($value1));
			}
		}
		$amount = $itemPrice;
		if(!empty($itemPrice))
		{
			$orderTxData = $this->transaction_model->getorderPayments($orderId,$amount);
			if(empty($orderTxData))
			{
				$returnData["flag"] =2;
				goto end;
			}

			$txData=$this->payment_model->getTransaction($orderTxData->tx);
			$orderData=$this->orders_model->orderData($orderId);
			if(!empty($txData) && !empty($orderData))
			{
				$returnData = array();
				if($orderData["order"]->payment_mode == "Offline" || $txData->payment_mode == "cash" || $txData->payment_mode == "neft" || $txData->payment_mode == "cheque" || $txData->payment_mode == "cc" || $txData->payment_mode == "dc")
				{
					$returnData['status'] = 1;
					$returnData['response'] = "success";
					$returnData['message'] = "success";
				}
				else
				{
					$this->load->library("onlinerefund");
					$returnData = $this->onlinerefund->process_refund($txData->payment_mode,$txData,$orderData,$amount);
				}
				$this->load->model("refunds_history_model");
				if($returnData['status'] == 1 && !empty($returnData['response']))
				{
					//Status 1 Indicates Refund Initiated successfully from gateway level
					$this->refunds_history_model->saveHistory($txData,$orderData,$returnData['response'],1,0,$returnData['message']);

					$subscription = $txData->subscription;
					$refundId = random_string('alnum',16);
					if(strtolower($txData->payment_mode) == "paypal")
					{
						if(!empty($returnData['response']['PNREF']))
							$refundId = $returnData['response']['PNREF'];
						else
							$refundId = substr(hash('sha256', mt_rand() . microtime()), 0, 16);
					}
					else if(strtolower($txData->payment_mode) == "payu")
					{
						$refundId 		= $returnData['response']->result;
					}
					else if(strtolower($txData->payment_mode) == "razorpay")
					{
						$refundId 		= $returnData['response']->id;
					}
					else if(strtolower($txData->payment_mode) == "stripe")
					{
						if(!empty($returnData['response']->id))
							$refundId 		= $returnData['response']->id;
						else
							$refundId 		= random_string('alnum',16);
					}
					else if(strtolower($orderData["order"]->payment_mode) == "offline")
					{
						$refundId 		= random_string('alnum',16);
					}
					$batchId = time();
					$colorstrips = array("palegoldenrod","aqua","antiquewhite","cornsilk","peachpuff","yellow","red","blue","black");
					$strip_color = $colorstrips[array_rand($colorstrips, 1)];
					if($orderData["order"]->order_type != 3)
					{
						foreach ($itemsArray as $key12 => $value12) 
						{
							$ids_and_dates = explode("_", $value12);

							$r_itemId = $ids_and_dates[0];
							$r_date = $ids_and_dates[1];
							$array = array("order_id"=>$orderId,"created_on"=>date("Y-m-d H:i:s"),"refund_or_replaced"=>"Refund","date"=>date("Y-m-d",strtotime($r_date)),"order_item_id"=>$r_itemId);
							$this->refunds_history_model->order_items_dates_log($array);
							$this->refunds_history_model->remove_order_items_dates($r_itemId,$r_date);
						}
					}
					foreach ($builtArray as $key1 => $value1) 
					{
						$itemDates = implode(",", $value1);
						$itemData=$this->orders_model->getOrderDataItemDataByOrderItemId($key1);
						$new_itemPrice= $this->getitemsdatespriceWeb($orderId,$key1,count($value1));
						$refundData = array(
							"order_id"=>$orderId,
							"order_item_id"=>$key1,
							"refund_id"=>$refundId,
							"original_items_names"=>$itemData['item_name'],
							"original_transaction_id"=>$txData->tx,
							"order_number"=>$orderData["order"]->order_number,
							"amount"=>$new_itemPrice,
							"ashram_id"=>$orderData["order"]->ashram_id,
							"trust_id"=>$txData->trust_id,
							"currency"=>$orderData["order"]->currency,
							"original_dates"=>$itemDates,
							"cart_type"=>$orderData["order"]->order_type,
							"created_on"=>date("Y-m-d H:i:s"),
							"refund_flag"=>1,
							"replace_flag"=>0,
							"batch_id"=>$batchId,
						);
						$this->refunds_history_model->order_items_refund_replace_logs($refundData);
						$itemQuantity = count($value1);
						$updatedQuantity = $itemData["quantity"] - ($itemQuantity + $itemData["updated_quantity"]);
						$tx_note = "Order Item Modified\nItem Name: ".$itemData['item_name']."\nProcessed Dates: ".$itemDates."\nItem Refunded\nRefund ID: ".$refundId."\nProcessed Date: ".Date("d M Y H:i A");
						$this->order_log_model->log($orderData['order']->id,$tx_note);

						$fullyRefunded = 0;
						$item_replaced = 0;
						if($orderData["order"]->order_type != 3)
						{
							if(isset($itemData['schedule_dates']) && $itemData['schedule_dates']!='')
							{
								$alreadyScheduledDates = explode(',', $itemData['schedule_dates']);
								$totalscDates = count($alreadyScheduledDates);
								$selectScDates = count($value1);
								if($totalscDates == $selectScDates)
								{
									$fullyRefunded = 1;
								}
								foreach ($value1 as $date_key => $date_value) 
								{
									foreach ($alreadyScheduledDates as $prev_date_key => $prev_date_value) 
									{
										if($prev_date_value == $date_value)
											unset($alreadyScheduledDates[$prev_date_key]);
									}
								}
							}
							if(!empty($alreadyScheduledDates))
								$alreadyScheduledDates = implode(",", $alreadyScheduledDates);
							else
								$alreadyScheduledDates = "";
						}
						else
						{
							$fullyRefunded = 1;
							$alreadyScheduledDates = "";
						}
						$refunded_item_amount = $new_itemPrice + $itemData["refunded_amount"];
						$this->refunds_history_model->update_order_item_flags($fullyRefunded,$refunded_item_amount,$key1,$alreadyScheduledDates,$batchId,$item_replaced,$updatedQuantity,$strip_color);
					}
					$this->refunds_history_model->createRefundTx($refundId, $txData,$amount,$orderData["order"]->total_price,$orderData["order"]->total_refunded_amount,1 );
					$this->refunds_history_model->sendRefundItemsEmail($orderId,$batchId,0);

					if(empty($subscription) || $subscription != 1)
					{
						$this->order_log_model->log($orderData['order']->id,"Tx Updated\nTx ID:".$refundId."\nStatus: Refunded\Reference TX ID:".$txData->tx."\n Refunded Amount: ".$amount);
					}
					$totalPaid = $this->refunds_history_model->getordertotalpaid($orderId);
					$totalRefunded = $this->refunds_history_model->getordertotalrefunded($orderId);
					$totalPaid = $totalPaid - $totalRefunded;
					$calculated_order_total_price = $orderData["order"]->original_total_price - $totalRefunded;
					$updateData = array("total_paid"=>$totalPaid,"paid"=>$totalPaid,"total_price"=>$calculated_order_total_price);
					$this->refunds_history_model->update_order_total($orderId,$updateData);
					$returnData["flag"] =1;
					$this->session->set_flashdata("tx_updated",1);
				}
				else
				{
					$refund_fail_count = $orderData["order"]->refund_failed_count+1;
					$update_fail_countData = array("refund_failed_count"=>$refund_fail_count,"partially_refunded"=>1);
					$this->refunds_history_model->update_order_total($orderId,$update_fail_countData);
					$returnData["flag"] =3;
					$returnData["message"] = $returnData['message'];
					$this->refunds_history_model->saveHistory($txData,$orderData,$returnData['response'],0,0,$returnData['message']);
				}
			}
		}
		end:
		echo json_encode($returnData);
	}

	public function partial_manual_refund($orderId)
	{
		$returnData["flag"] =0;
		if(!empty($this->input->post("itemsArray")))
		{
			$itemsArray = $this->input->post("itemsArray");
			$builtArray = array();
			$itemPrice = 0;
			foreach ($itemsArray as $key => $value) 
			{
				$ids_and_dates = explode("_", $value);
				$builtArray[$ids_and_dates[0]][] = $ids_and_dates[1];
			}

			foreach ($builtArray as $key1 => $value1) 
			{
				$itemPrice+= $this->getitemsdatespriceWeb($orderId,$key1,count($value1));
			}
		}
		$amount = $itemPrice;
		if(!empty($itemPrice))
		{
			$orderTxData = $this->transaction_model->getorderPayments($orderId,$amount);
			if(empty($orderTxData))
			{
				$returnData["flag"] =2;
				goto end;
			}
			$orderData = $this->orders_model->orderData($orderId);
			$sessionData = array("orderId"=>$orderId,"total_amount"=>$itemPrice,"posted_items"=>$itemsArray,"items_and_dates"=>$builtArray,"txData"=>$orderTxData,"orderData"=>$orderData,"order_type"=>$orderData["order"]->order_type,"ashram_id"=>$orderData["order"]->ashram_id,"currency"=>$orderData["order"]->currency,"user_id"=>$orderData["order"]->user_id,"refund_failed_count"=>$orderData["order"]->refund_failed_count);
			$this->session->set_userdata("manual_cart_items_from_seva_details",$sessionData);
			$returnData["flag"] =1;
			$returnData["success_url"] =base_url."orders/manual_refund_process";
		}
		end:
		echo json_encode($returnData);
	}

	public function manual_refund_process()
	{
		if(empty($this->session->userdata("manual_cart_items_from_seva_details")))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
		}
		$views = array( 'orders/admin/orders_manual_refund' );
		$data = array('views'=>$views);
		$data['orderData']=$this->orders_model->orderData($this->session->userdata("manual_cart_items_from_seva_details")["orderId"]);
		if(empty($data['orderData']))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
		}
		$data['txData']=$this->session->userdata("manual_cart_items_from_seva_details")["txData"];
		$data['amount']=$this->session->userdata("manual_cart_items_from_seva_details")["total_amount"];
		$data['orderId']=$this->session->userdata("manual_cart_items_from_seva_details")["orderId"];
		//unset($_SESSION['manual_cart_items_from_seva_details']);
		$this->load->view(ADMIN_TEMPLATE,$data);
		return;
	}

	public function update_manual_refund($orderId)
	{
		$returnData["flag"] =0;
		if(!empty($this->session->userdata("manual_cart_items_from_seva_details")["posted_items"]))
		{
			$itemsArray = $this->session->userdata("manual_cart_items_from_seva_details")["posted_items"];
			$builtArray = array();
			$itemPrice = 0;
			foreach ($itemsArray as $key => $value) 
			{
				$ids_and_dates = explode("_", $value);
				$builtArray[$ids_and_dates[0]][] = $ids_and_dates[1];
			}

			foreach ($builtArray as $key1 => $value1) 
			{
				$itemPrice+= $this->getitemsdatespriceWeb($orderId,$key1,count($value1));
			}
		}
		$amount = $this->input->post("amount");
		if($amount != $itemPrice)
		{
			$returnData["flag"] =0;
			goto end;
		}
		if(!empty($itemPrice))
		{
			$orderTxData = $this->transaction_model->getorderPayments($orderId,$amount);
			if(empty($orderTxData))
			{
				$returnData["flag"] =2;
				goto end;
			}

			$txData=$this->payment_model->getTransaction($this->input->post("tx_id"));
			$orderData=$this->orders_model->orderData($orderId);
			if(!empty($txData) && !empty($orderData))
			{
				$refundData = array();
				$refundData["response"] = "Offline";
				$refundData["message"] = "Offline";
				$refundId = substr(hash('sha256', mt_rand() . microtime()), 0, 22);
				//Status 1 Indicates Refund Initiated successfully from gateway level
				$this->refunds_history_model->saveHistory($txData,$orderData,$refundData['response'],1,1,$refundData['message'],$refundId);
				$batchId = time();
				$colorstrips = array("palegoldenrod","aqua","antiquewhite","cornsilk","peachpuff","yellow","red","blue","black");
				$strip_color = $colorstrips[array_rand($colorstrips, 1)];
				if($orderData["order"]->order_type != 3)
				{
					foreach ($itemsArray as $key12 => $value12) 
					{
						$ids_and_dates = explode("_", $value12);

						$r_itemId = $ids_and_dates[0];
						$r_date = $ids_and_dates[1];
						$array = array("order_id"=>$orderId,"created_on"=>date("Y-m-d H:i:s"),"refund_or_replaced"=>"Refund","date"=>date("Y-m-d",strtotime($r_date)),"order_item_id"=>$r_itemId);
						$this->refunds_history_model->order_items_dates_log($array);
						$this->refunds_history_model->remove_order_items_dates($r_itemId,$r_date);
					}
				}
				foreach ($builtArray as $key1 => $value1) 
				{
					$itemDates = implode(",", $value1);
					$itemData=$this->orders_model->getOrderDataItemDataByOrderItemId($key1);
					$new_itemPrice= $this->getitemsdatespriceWeb($orderId,$key1,count($value1));
					$refundData = array(
						"order_id"=>$orderId,
						"order_item_id"=>$key1,
						"refund_id"=>$refundId,
						"original_items_names"=>$itemData['item_name'],
						"original_transaction_id"=>$txData->tx,
						"order_number"=>$orderData["order"]->order_number,
						"amount"=>$new_itemPrice,
						"ashram_id"=>$orderData["order"]->ashram_id,
						"currency"=>$orderData["order"]->currency,
						"original_dates"=>$itemDates,
						"cart_type"=>$orderData["order"]->order_type,
						"created_on"=>date("Y-m-d H:i:s"),
						"refund_flag"=>1,
						"manual_refund_replace"=>1,
						"replace_flag"=>0,
						"batch_id"=>$batchId,
					);
					$this->refunds_history_model->order_items_refund_replace_logs($refundData);
					$itemQuantity = count($value1);
					$updatedQuantity = $itemData["quantity"] - ($itemQuantity + $itemData["updated_quantity"]);
					$tx_note = "Order Item Modified\nItem Name: ".$itemData['item_name']."\nProcessed Dates: ".$itemDates."\nItem Refunded\nRefund ID: ".$refundId."\nProcessed Date: ".Date("d M Y H:i A");
					$this->order_log_model->log($orderData['order']->id,$tx_note);

					$fullyRefunded = 0;
					$item_replaced = 0;
					if($orderData["order"]->order_type != 3)
					{
						if(isset($itemData['schedule_dates']) && $itemData['schedule_dates']!='')
						{
							$alreadyScheduledDates = explode(',', $itemData['schedule_dates']);
							$totalscDates = count($alreadyScheduledDates);
							$selectScDates = count($value1);
							if($totalscDates == $selectScDates)
							{
								$fullyRefunded = 1;
							}
							foreach ($value1 as $date_key => $date_value) 
							{
								foreach ($alreadyScheduledDates as $prev_date_key => $prev_date_value) 
								{
									if($prev_date_value == $date_value)
										unset($alreadyScheduledDates[$prev_date_key]);
								}
							}
						}
						if(!empty($alreadyScheduledDates))
							$alreadyScheduledDates = implode(",", $alreadyScheduledDates);
						else
							$alreadyScheduledDates = "";
					}
					else
					{
						$fullyRefunded = 1;
						$alreadyScheduledDates = "";
					}
					$refunded_item_amount = $new_itemPrice + $itemData["refunded_amount"];
					$this->refunds_history_model->update_order_item_flags($fullyRefunded,$refunded_item_amount,$key1,$alreadyScheduledDates,$batchId,$item_replaced,$updatedQuantity,$strip_color);
				}
				$this->refunds_history_model->createManualRefundTx($refundId, $txData,$amount,$orderData["order"]->total_price,$orderData["order"]->total_refunded_amount,1);
				$this->refunds_history_model->sendRefundItemsEmail($orderId,$batchId,0);

				if(empty($subscription) || $subscription != 1)
				{
					$this->order_log_model->log($orderData['order']->id,"Tx Updated\nTx ID:".$refundId."\nStatus: Refunded\Reference TX ID:".$txData->tx."\n Refunded Amount: ".$amount);
				}
				$totalPaid = $this->refunds_history_model->getordertotalpaid($orderId);
				$totalRefunded = $this->refunds_history_model->getordertotalrefunded($orderId);
				$totalPaid = $totalPaid - $totalRefunded;
				$calculated_order_total_price = $orderData["order"]->original_total_price - $totalRefunded;
				$updateData = array("total_paid"=>$totalPaid,"paid"=>$totalPaid,"total_price"=>$calculated_order_total_price);
				$this->refunds_history_model->update_order_total($orderId,$updateData);
				$returnData["flag"] =1;
				$this->session->set_flashdata("tx_updated",1);
				unset($_SESSION['manual_cart_items_from_seva_details']);
			}
		}
		end:
		echo json_encode($returnData);
	}

	public function changeOrderAllItemsScheduleDates($order_id=0)
	{
		$result['flag']=0;
		if(is_numeric($order_id) && $order_id>0 && isset($_POST['previousDates']) && count($_POST['previousDates'])>0 && isset($_POST['changedDates']) && count($_POST['changedDates'])>0)
		{
			$orderDataRow=$this->orders_model->orderRowById($order_id);
			if(empty($orderDataRow))
			{
				$result['flag']=2;
			}
			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderDataRow->ashram_id!=$this->session->userdata("ashramId"))
					{
						$result['flag']=3;
					}
				}
				else
				{
					$result['flag']=3;
				}
			}

			if(isset($this->currentUser->is_currency_specific) && $this->currentUser->is_currency_specific==1)
			{
				if(isset($this->currentUser->currencies) && $this->currentUser->currencies!='')
				{
					$accessableCurrencies = explode(',', $this->currentUser->currencies);
					if(!in_array($orderDataRow->currency, $accessableCurrencies))
					{
						$result['flag']=3;
					}
				}
			}
			$previousDates = $_POST['previousDates'];
			$changedDates = $_POST['changedDates'];
			$actualChangingDates = [];
			if(is_array($previousDates))
			{
				foreach ($previousDates as $key => $previousDateArray)
				{
					if(is_array($previousDateArray))
					{
						foreach($previousDateArray as $innerKey => $previousDateArrayvalue)
						{
							if(isset($changedDates[$key][$innerKey]) && $changedDates[$key][$innerKey]!='' && $changedDates[$key][$innerKey]!=$previousDateArrayvalue)
							{
								$actualChangingDates[$key][$previousDateArrayvalue] = $changedDates[$key][$innerKey];
							}
						}
					}
				}
			}
			
			if(count($actualChangingDates)==0)
			{
				// no changes in Dates
				$result['flag']=4;
				goto end;
			}
			$itemsData=$this->orders_model->getOrderDataItemDataByOrderId($order_id);
			$itemsIds = array_column($itemsData, 'id');
			$changingItemsIds = array_keys($actualChangingDates);
			foreach($changingItemsIds as $changingItemId)
			{
				if(!in_array($changingItemId, $itemsIds))
				{
					// wrong item of this order, So can not modify
					$result['flag']=5;
					goto end;
				}
			}
			$this->load->model('cart_model');
			foreach ($actualChangingDates as $key => $actualChangingDateArray)
			{
				$itemData=$this->orders_model->getOrderDataItemDataByOrderItemId($key);
				if(empty($itemData))
				{
					// wrong item of this order, So can not modify
					$result['flag']=5;
					goto end;
				}
				if(is_array($actualChangingDateArray))
				{
					if($orderDataRow->order_type==1)
					{
						$poojaData = (object) $itemData['poojasData'];
						$poojaValidDates = $this->cart_model->getPoojaValidDates($poojaData);					}
					foreach($actualChangingDateArray as $innerChangingKey => $actualChangingDateArrayvalue)
					{
						if(isset($itemData['schedule_dates']) && $itemData['schedule_dates']!='')
						{
							$alreadyScheduledDates = explode(',', $itemData['schedule_dates']);
							if(in_array($actualChangingDateArrayvalue, $alreadyScheduledDates))
							{
								$result['flag']=7;
								$result['item_id']=$key;
								goto end;
							}
						}
						if( $orderDataRow->order_type==1 && (!in_array($innerChangingKey, $poojaValidDates) || !in_array($actualChangingDateArrayvalue, $poojaValidDates)) )
						{
							// wrong dates for the item, So can not modify
							$result['flag']=6;
							$result['item_id']=$key;
							goto end;
						}
					}
				}
			}
			$this->orders_model->changeBulkItemsDates($order_id,$actualChangingDates);
			$result['flag']=1;
		}
		end:
		echo json_encode($result,JSON_HEX_APOS);
	}

	public function updateStripeCard($paymentMethodId,$orderId)
	{
		$result['flag']=0;
		$orderData=$this->orders_model->orderData($orderId);
		if(empty($orderData['order']))
		{
			$result['error_msg']="something wrong, Please try again..";
			goto end;
		}
		if($orderData['stripe_card']->payment_method_id != $paymentMethodId)
		{
			$result['error_msg']="something wrong, Please try again..";
			goto end;
		}
		else
		{
			$this->load->model("stripe_webhook_model");
			$ref_url = base_url."orders/view/".$orderId;
			$currency = strtolower($orderData["order"]->currency);
			$customer_id = $orderData["stripe_card"]->customer_id;
			$subscription_id = $orderData["stripe_card"]->subscription_id;
			$ashram_id = $orderData["order"]->ashram_id;
			$order_type = $orderData["order"]->order_type;
			$checkoutSession = $this->stripe_webhook_model->createcardUpdateSession($currency,$customer_id,$subscription_id,$ashram_id,$order_type,$ref_url);
			$result['flag']=1;
			$result['session_id']=$checkoutSession["session"]->id;
		}
		end:
		echo json_encode($result,JSON_HEX_APOS);
	}


	public function updateAppjiMemberName($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$orderData=$this->orders_model->orderData($id);
			if(empty($orderData['order']))
			{
				echo 0;
				exit;
			}

			$this->form_validation->set_rules('value', 'Value', 'trim|min_length[3]|max_length[60]');
	    	$this->form_validation->set_rules('pk', 'ID', 'trim|required');
	    	if($this->form_validation->run() == FALSE)
			{
				echo 0;
				return;
			}
			$item=array();
			foreach ($orderData['order_items'] as $orderItem)
			{
				if($this->input->post("pk")==$orderItem->order_item_id)
				{
					$item=$orderItem;
					break;
				}
			}
			
			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
					{
						echo 0;
						return;
					}
				}
			}

			if(empty($item))
			{
				echo 0;
				return;
			}

			$this->orders_model->updateAppjiMemberName($orderData,$item,$this->input->post("value"));
			echo 1;
		}
		else
		{
			echo 0;
			return;
		}
	}


	public function updateAppjiMemberEmail($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$orderData=$this->orders_model->orderData($id);
			if(empty($orderData['order']))
			{
				echo 0;
				exit;
			}

			$this->form_validation->set_rules('value', 'Email ID','trim|required|valid_email_custom|min_length[6]|max_length[100]');
	    	$this->form_validation->set_rules('pk', 'ID', 'trim|required');
	    	if($this->form_validation->run() == FALSE)
			{
				echo 0;
				return;
			}

			if($this->currentUser->roles!=1)
			{
				if($this->session->userdata("ashramId"))
				{
					if($orderData['order']->ashram_id!=$this->session->userdata("ashramId"))
					{
						echo 0;
						return;
					}
				}
			}

			$item=array();
			foreach ($orderData['order_items'] as $orderItem)
			{
				if($this->input->post("pk")==$orderItem->id)
				{
					$item=$orderItem;
					break;
				}
			}

			if(empty($item))
			{
				echo 2;
				return;
			}

			$this->orders_model->updateAppjiMemberEmail($orderData,$item,$this->input->post("value"));
			echo 1;
		}
		else
		{
			echo 0;
			return;
		}
	}

	public function tx_reconciliation_report()
	{
		if(is_single_currency_site)
        { 
            $this->session->set_userdata("reconciliation_currency",default_currency);
        }
	    $reconciliation_reports=$this->orders_model->getTransactionReconciliationDataByPaymentGateWay();
	    $views = array( 'orders/admin/tx_reconciliation_report');
	    $data = array('views'=>$views,'reconciliation_reports'=>$reconciliation_reports);
	    $data['ashrams']=$this->ashrams_model->getList();
		$data['currencies'] = array();
		$data['payment_modes'] = array();
		if(!$this->session->userdata("reconciliation_tx_date"))
		{
			$this->session->set_userdata("reconciliation_tx_date",date("Y-m-d"));
		}
		if($this->session->userdata("reconciliation_tx_date") && $this->session->userdata("reconciliation_currency"))
		{
			$data['payment_modes'] = $this->transaction_model->getReconciliationReportPaymentModesByDateCurrency($this->session->userdata("reconciliation_tx_date"), $this->session->userdata("reconciliation_currency"));
		}
		if($this->session->userdata("ashramId") && $this->session->userdata("reconciliation_currency"))
		{
			$data['ashramTrusts']=$this->ashrams_trust_accounts_model->getAllTrustsBasicDetailsByAshramId($this->session->userdata("ashramId"), $this->session->userdata("reconciliation_currency"));
		}
	    $this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function listTransactionsReconciliationReport($excel=0)
	{
		$list=$this->transaction_model->listTransactionsReconciliationReportAdmin($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Transactions Reconciliation Report Listing ajax request");
	}

	public function changeReconciliationTxDate($reconciliationTxDate = "")
	{
		if($reconciliationTxDate == "")
		{
			$this->session->set_userdata("reconciliation_tx_date",date("Y-m-d"));
		}
		else
		{
			$reconciliationTxDate = urldecode($reconciliationTxDate);
			$this->session->set_userdata("reconciliation_tx_date",date("Y-m-d", strtotime($reconciliationTxDate)));
		}
	}

	public function changeReconciliationTxCurrency($reconciliationTxCurrency = "")
	{
		if($reconciliationTxCurrency == "")
		{
			$this->session->unset_userdata("reconciliation_currency");
		}
		else
		{
			$this->session->set_userdata("reconciliation_currency",$reconciliationTxCurrency);
		}
	}

	public function changeReconciliationTxPaymentMode($reconciliationTxPaymentMode = "")
	{
		if($reconciliationTxPaymentMode == "")
		{
			$this->session->unset_userdata("reconciliation_payment_mode");
		}
		else
		{
			$this->session->set_userdata("reconciliation_payment_mode",$reconciliationTxPaymentMode);
		}
	}
	
	public function clearReconciliationFIlters()
	{
		$this->session->unset_userdata("reconciliation_currency");
		$this->session->unset_userdata("reconciliation_payment_mode");
	}

	public function poorna_phala_pooja_orders()
	{
		$views = array( 'orders/admin/list_poorna_phala_pooja_orders' );
		$data = array('views'=>$views);
		
		if($this->session->userdata("ashramId"))
		{
			$data['poojas']=$this->poojas_model->getPoornaPhalaPoojasByAshramId($this->session->userdata("ashramId"));
		}
		$data['ashrams']=$this->ashrams_model->getList();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"Admin - Viewed Poojas prasadam report");
	}

	public function listPoornaPhalaReport($excel=0)
	{
		$list=$this->orders_model->listAdminPoornaPhalaPoojaOrders($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"Admin - Viewed Poorna Phala Poojas report ajax request");
	}


	public function listemails(){}
	public function email_data(){}
	public function email_resend(){}
	public function bulk_resend(){}

	public function listsms(){}
	public function sms_data(){}
	public function sms_resend(){}
	public function sms_bulk_resend(){}

	public function orderCheck($search_by="", $search_val=0)
	{
		if(in_array($search_by, ['byorderid','byordernumber','bytransactionid', '']))
		{
			$views = array( 'orders/admin/orderchecks' );
			$data = array('views'=>$views);
			$data['search_by'] = $search_by;
			$data['search_val'] = $search_val;
			$data['search_order_id'] = "";
			$data['search_order_number'] = "";
			$data['search_transaction_id'] = "";
			if($search_by == "byorderid")
			{
				$data['search_order_id'] = $search_val;
				$data['orderData']=$this->orders_model->orderData($search_val);
				$data['transactions']=$this->transaction_model->getTransactionsByOrderID($search_val);
			}
			if($search_by == "byordernumber")
			{
				$data['search_order_number'] = $search_val;
				$data['orderData']=$this->orders_model->orderDataByOrderNumber($search_val);
				if(isset($data['orderData']['order']->id) && $data['orderData']['order']->id!="")
					$data['transactions']=$this->transaction_model->getTransactionsByOrderID($data['orderData']['order']->id);
			}
			if($search_by == "bytransactionid")
			{
				$data['search_transaction_id'] = $search_val;
				$data['transactions']=$this->transaction_model->getTransactionsByTx($search_val);

				$tranOrderId = '';
				if(!empty($data['transactions']))
				{
					foreach($data['transactions'] as $thistransaction)
					{
						if($thistransaction->order_id>0)
						{
							$tranOrderId = $thistransaction->order_id;
							break;
						}
					}
				}
				if($tranOrderId!="")
					$data['orderData']=$this->orders_model->orderData($tranOrderId);
			}
			
			// echo '<pre>'; print_r($data); die();
			$data['ashrams']=$this->ashrams_model->getList();
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
		else
		{
			$data['views'] = array('common/public/error');
			$this->load->view(ADMIN_TEMPLATE,$data);
			return;
		}
	}

	public function vishwashanti_pada_yatra_all_items_report()
	{
		$secret_key="";
		if(isset($_GET['secret_key']) && $_GET['secret_key']!='')
		{
			$secret_key=$_GET['secret_key'];
		}
		if($secret_key=="" || $secret_key!=vishwashantipadayatra2022_public_display_secret_key)
		{
    		$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
		}
		$reports=$this->orders_model->listDonationsSevaKartaForVishwashantiPadaYatraAllItemsReport();
		// echo '<pre>'; print_r($reports); die();
		$data = array('reports'=>$reports);
		$this->load->view('orders/admin/vishwashanti_pada_yatra_all_items_report',$data);
		$this->logaction->log($this->service,"Public - Viewed Donation Sevakarta for Vishwashanti Pada Yatra All Items Report Listing with secret key");
	}

	public function vishwashanti_pada_yatra_all_items_report_seva_karta_pdf_report()
	{
		$secret_key="";
		if(isset($_GET['secret_key']) && $_GET['secret_key']!='')
		{
			$secret_key=$_GET['secret_key'];
		}
		if($secret_key=="" || $secret_key!=vishwashantipadayatra2022_public_display_secret_key)
		{
    		$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
		}
		$reports=$this->orders_model->listDonationsSevaKartaForVishwashantiPadaYatraAllItemsReport();
		$data = array('reports'=>$reports);
		$this->load->view('orders/admin/vishwashanti_pada_yatra_all_items_pdf_report',$data);
	}

	public function vishwashanti_pada_yatra_item_report()
	{
		$secret_key="";
		$item_id = 0;
		if(isset($_GET['secret_key']) && $_GET['secret_key']!='')
		{
			$secret_key=$_GET['secret_key'];
		}
		if(isset($_GET['item_id']) && $_GET['item_id']!='')
		{
			$item_id=$_GET['item_id'];
		}
		if($secret_key!="" && $secret_key==vishwashantipadayatra2022_public_display_secret_key && $item_id=='135')
		{
			goto reportQuery;
		}
		else if($secret_key=="" || $secret_key!=vishwashantipadayatra2022_public_display_secret_key || !in_array($item_id, vishwashantipadayatra2022_full_donation_ids))
		{
    		$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
		}
		reportQuery:
		$this->load->model("subscriptions/donors_model");
		$itemData = $this->donations_model->donationData($item_id);
		if(empty($itemData))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
		}
		if($item_id=='135')
		{
			$reports=$this->orders_model->listDonationsSevaKartaForSelectedItemReport($item_id);
		}
		else
		{
			$reports=$this->orders_model->listDonationsSevaKartaForVishwashantiPadaYatraSelectedItemReport($item_id);
		}
		// echo '<pre>'; print_r($itemData); die();
		$data = array('reports'=>$reports, 'itemData'=>$itemData);
		$this->load->view('orders/admin/vishwashanti_pada_yatra_selected_item_report',$data);
		$this->logaction->log($this->service,"Public - Viewed Donation Sevakarta for Vishwashanti Pada Yatra Selected Item Report Listing with secret key");
	}

	public function vishwashanti_pada_yatra_item_report_seva_karta_pdf_report()
	{
		$secret_key="";
		$item_id = 0;
		if(isset($_GET['secret_key']) && $_GET['secret_key']!='')
		{
			$secret_key=$_GET['secret_key'];
		}
		if(isset($_GET['item_id']) && $_GET['item_id']!='')
		{
			$item_id=$_GET['item_id'];
		}
		if($secret_key!="" && $secret_key==vishwashantipadayatra2022_public_display_secret_key && $item_id=='135')
		{
			goto reportQuery;
		}
		else if($secret_key=="" || $secret_key!=vishwashantipadayatra2022_public_display_secret_key || !in_array($item_id, vishwashantipadayatra2022_full_donation_ids))
		{
    		$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
		}
		reportQuery:
		$this->load->model("subscriptions/donors_model");
		$itemData = $this->donations_model->donationData($item_id);
		if(empty($itemData))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
		}
		if($item_id=='135')
		{
			$reports=$this->orders_model->listDonationsSevaKartaForSelectedItemReport($item_id);
		}
		else
		{
			$reports=$this->orders_model->listDonationsSevaKartaForVishwashantiPadaYatraSelectedItemReport($item_id);
		}
		$data = array('reports'=>$reports, 'itemData'=>$itemData);
		$this->load->view('orders/admin/vishwashanti_pada_yatra_selected_items_pdf_report',$data);
	}

	public function shodasha_datta_kshetra_pada_yatra_item_report()
	{
		$secret_key="";
		$item_id = 0;
		if(isset($_GET['secret_key']) && $_GET['secret_key']!='')
		{
			$secret_key=$_GET['secret_key'];
		}
		if(isset($_GET['item_id']) && $_GET['item_id']!='')
		{
			$item_id=$_GET['item_id'];
		}
		else if($secret_key=="" || $secret_key!=shodasha_datta_kshetra_pada_yatra_public_display_secret_key || !in_array($item_id, shodasha_datta_kshetra_pada_yatra_donation_ids))
		{
    		$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
		}
		reportQuery:
		$this->load->model("subscriptions/donors_model");
		$itemData = $this->donations_model->donationData($item_id);
		if(empty($itemData))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
		}
		$reports=$this->orders_model->listDonationsSevaKartaForShodashaDattaKshetraPadaYatraSelectedItemReport($item_id);
		$data = array('reports'=>$reports, 'itemData'=>$itemData);
		$this->load->view('orders/admin/shodasha_datta_kshetra_pada_yatra_selected_item_report',$data);
		$this->logaction->log($this->service,"Public - Viewed Donation Sevakarta for Shodasha Datta Kshetra Pada Yatra Selected Item Report Listing with secret key");
	}

	public function shodasha_datta_kshetra_pada_yatra_item_report_seva_karta_pdf_report()
	{
		$secret_key="";
		$item_id = 0;
		if(isset($_GET['secret_key']) && $_GET['secret_key']!='')
		{
			$secret_key=$_GET['secret_key'];
		}
		if(isset($_GET['item_id']) && $_GET['item_id']!='')
		{
			$item_id=$_GET['item_id'];
		}
		if($secret_key!="" && $secret_key==shodasha_datta_kshetra_pada_yatra_public_display_secret_key && $item_id=='135')
		{
			goto reportQuery;
		}
		else if($secret_key=="" || $secret_key!=shodasha_datta_kshetra_pada_yatra_public_display_secret_key || !in_array($item_id, shodasha_datta_kshetra_pada_yatra_donation_ids))
		{
    		$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
		}
		reportQuery:
		$this->load->model("subscriptions/donors_model");
		$itemData = $this->donations_model->donationData($item_id);
		if(empty($itemData))
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
			return;
		}
		$reports=$this->orders_model->listDonationsSevaKartaForShodashaDattaKshetraPadaYatraSelectedItemReport($item_id);
		$data = array('reports'=>$reports, 'itemData'=>$itemData);
		$this->load->view('orders/admin/shodasha_datta_kshetra_pada_yatra_selected_items_pdf_report',$data);
	}

	// setting category based on ashram
	public function switchCategory($categoryId,$cart_type){
		if(is_numeric($categoryId)) {
			if($cart_type == 1)
				$this->session->set_userdata("pooja_categoryId",$categoryId);
			if($cart_type == 2)
				$this->session->set_userdata("donation_categoryId",$categoryId);
			if($cart_type == 3)
				$this->session->set_userdata("store_categoryId",$categoryId);
			if($cart_type == 4)
				$this->session->set_userdata("subscription_categoryId",$categoryId);
		}else {
			if($cart_type == 1)
				$this->session->unset_userdata("pooja_categoryId");
			if($cart_type == 2)
				$this->session->unset_userdata("donation_categoryId");
			if($cart_type == 3)
				$this->session->unset_userdata("store_categoryId");
			if($cart_type == 4)
				$this->session->unset_userdata("subscription_categoryId");
		}
		if($this->session->userdata("groupId"))
			$this->session->unset_userdata("groupId");
	}

	// setting group id based on ashram and category
	public function switchGroup($groupId){
		if(is_numeric($groupId))
			$this->session->set_userdata("groupId",$groupId);
		else
			$this->session->unset_userdata("groupId");
	}
}
?>