<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class One_time_migrations extends CI_Controller 
{
	var $currentUser;
    function __construct()
	{
		parent::__construct();
		if(!is_cli())
		{
			if($this->session->userdata('id'))
			{
				$this->currentUser=$this->session->userdata("admin_data");
			}
			else
			{
				$this->currentUser=$this->session->userdata("user_data");
			}
		}
    }
    public function index()
    {
    	if(is_cli())
		{
			$this->logaction->log("system","One time migration index page called");
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
    }

    public function updateCreatedOnWithStartedDateIfCreatedOnHasNoData()
    {
    	if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$alter_sql = "UPDATE `transaction` SET `created_on` = `started_on` WHERE `created_on` IS NULL;";
			$this->db->query($alter_sql);
			$alter_sq2 = "UPDATE `transaction` SET `created_on` = `started_on` WHERE `created_on` = '0000-00-00 00:00:00';";
			$this->db->query($alter_sq2);
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

    public function createReconciliationReportRecordsForPreviousData()
    {
    	if(is_cli())
		{
			exit;
			ini_set('max_execution_time', 0);
			$this->logaction->log("system","Create Reconciliation Report Records For Previous Data initiated");
			$this->logaction->log("system","Getting Website Transaction Data for Reconciliation Report Started");
			// $paymentModes = ['razorpay', 'stripe'];
			$paymentModes = ['razorpay'];

			$query1=$this->db;
            $query1->select("o.ashram_id, date(o.date) as seva_date,o.id as seva_id,o.order_number as seva_number, t.created_on as transaction_date, o.transaction_id as transaction_number, o.total_price as amount, o.currency, LOWER(o.payment_mode) as payment_mode, o.total_price as seva_total_price, t.status as transaction_status, o.user_id as userid, o.username as tx_username, CONCAT(o.firstname, ' ', o.lastname) as user_fullname, o.email as user_email, o.phone as user_phone, o.isd_code as country_isd_code, '1' as is_no_transactions");
            $query1->from("orders as o");
            $query1->join("transaction as t",'o.transaction_id=t.tx');
            $query1->where_in('LOWER(o.payment_mode)',$paymentModes);
            $query1->where('o.no_paid_transactions','Yes');
            $query1->where('o.is_cancelled','0');
            $query1->order_by("o.id");
            $websiteNoTxOrders = $query1->get()->result_array();
			// echo '<pre>'; print_r($websiteNoTxOrders); die();
            $query1=$this->db;
            $query1->select("ashram_id,tx_order_date as seva_date,order_id as seva_id,tx_order_number as seva_number, created_on as transaction_date,tx as transaction_number,amount,currency,payment_mode,tx_order_total_price as seva_total_price, status as transaction_status, userid, tx_username, CONCAT(firstname, ' ', lastname) as user_fullname, email as user_email, phone as user_phone,country_isd_code");
            $query1->from("transaction");
            $query1->where_in('payment_mode',$paymentModes);
            $query1->order_by("tx");
            $websiteTransactions = $query1->get()->result_array();
			if(count($websiteNoTxOrders)>0)
			{
				foreach($websiteNoTxOrders as $websiteNoTxOrder)
				{
					$websiteTransactions[] = $websiteNoTxOrder;
				}
			}
            // echo '<pre>'; print_r($websiteTransactions); die();
			$this->logaction->log("system","Getting Website Transaction Data for Reconciliation Report Finished");
			$this->logaction->log("system","Getting Gateway Transaction Data for Reconciliation Report Started");
			$archivesDb = $this->load->database("data_archives",true,false);
			$reportsDb=$this->load->database("reports",true,false);
            $gatewayTransactions = [];
			$razorpayTables = [
								'razorpay_webhook_06Apr19_to_10Apr20',
								'razorpay_webhook_10Apr20_to_10May20',
								'razorpay_webhook_2020',
								'razorpay_webhook_2021',
								'razorpay_webhook',
							];
			foreach($razorpayTables as $razorpayTable)
			{
				if($razorpayTable !="" && $archivesDb->table_exists($razorpayTable) )
				{
					$archivesDb->select("transaction_id as gateway_transaction_number, amount as gateway_amount, created_on as gateway_created_on, status as gateway_status, 'razorpay' as gateway_name");
					$archivesDb->from($razorpayTable);
					$archivesDb->where("transaction_id!=","");
					if($archivesDb->field_exists('capture_flag', $razorpayTable))
        			{
						$archivesDb->where("capture_flag",1);
					}
					$archivesDb->where_in('status',['captured','failed']);
					$archivesDb->group_by('transaction_id');
					$resultTransactions = $archivesDb->get()->result_array();
					if(count($resultTransactions)>0)
					{
						// array_push($gatewayTransactions, $resultTransactions);
						foreach($resultTransactions as $resultTrans)
						{
							$gatewayTransactions[]=$resultTrans;
						}
					}
				}
			}

			// $stripeTables = [
			// 	'stripe_webhook_2021',
			// 	'stripe_webhook',
			// ];
			// foreach($stripeTables as $stripeTable)
			// {
			// 	if($stripeTable !="" && $archivesDb->table_exists($stripeTable) )
			// 	{
			// 		$archivesDb->select("transaction_id, amount, created_on, status, 'stripe' as gateway_name");
			// 		$archivesDb->from($stripeTable);
			// 		$archivesDb->where("transaction_id!=","");
			// 		$resultTransactions = $archivesDb->get()->result_array();
			// 		if(count($resultTransactions)>0)
			// 		{
			// 			array_push($gatewayTransactions, $resultTransactions);
			// 		}
			// 	}
			// }
			// if(count($gatewayTransactions)>0)
			// {
			// 	$gatewayTransactions = $gatewayTransactions[0];
			// }
			// echo '<pre>'; print_r($gatewayTransactions); die();
			$this->logaction->log("system","Getting Gateway Transaction Data for Reconciliation Report Finished");
			$this->logaction->log("system","Merging Website Transactions with Gateway Transaction for Reconciliation Report Started");
			$finalReconciliationDataSet=[];
			foreach ($websiteTransactions as $key1=>$data1)
			{
				foreach ($gatewayTransactions as $key2=>$data2){
					if($data1['transaction_number']==$data2['gateway_transaction_number'])
					{
						$finalReconciliationDataSet[]=$data1+$data2;
						unset($websiteTransactions[$key1]);
						unset($gatewayTransactions[$key2]);
					}
				}
			}
			if(!empty($websiteTransactions)){
				foreach ($websiteTransactions as $value)
				{
					$value['gateway_transaction_number'] = '';
					$value['gateway_amount'] = '';
					$value['gateway_created_on'] = '';
					$value['gateway_status'] = '';
					$value['gateway_name'] = '';
					$finalReconciliationDataSet[]=$value;
				}
			}
			if(!empty($gatewayTransactions)){
				foreach ($gatewayTransactions as $value)
				{
					$subValue['ashram_id'] = '';
					$subValue['seva_date'] = '';
					$subValue['seva_id'] = '';
					$subValue['seva_number'] = '';
					$subValue['transaction_number'] = '';
					$subValue['amount'] = '';
					$subValue['currency'] = '';
					$subValue['payment_mode'] = '';
					$subValue['seva_total_price'] = '';
					$subValue['transaction_status'] = '';
					$subValue['userid'] = '';
					$subValue['tx_username'] = '';
					$subValue['user_fullname'] = '';
					$subValue['user_email'] = '';
					$subValue['user_phone'] = '';
					$subValue['country_isd_code'] = '';
					$subValue['transaction_date'] = '';
					$subValue['gateway_transaction_number'] = $value['gateway_transaction_number'];
					$subValue['gateway_amount'] = $value['gateway_amount'];
					$subValue['gateway_created_on'] = $value['gateway_created_on'];
					$subValue['gateway_status'] = $value['gateway_status'];
					$subValue['gateway_name'] = $value['gateway_name'];
					$finalReconciliationDataSet[]=$subValue;
				}
			}
			// echo '<pre>'; print_r($finalReconciliationDataSet); die();
			$this->logaction->log("system","Merging Website Transactions with Gateway Transaction for Reconciliation Report Finished");
			if(count($finalReconciliationDataSet)>0)
			{
				$this->logaction->log("system","Inserting Data to Reconciliation Report Started");
				foreach ($finalReconciliationDataSet as $finalReconciliationData)
				{
					$checkTableName = "";
					$transdate  = '';
					if($finalReconciliationData['transaction_date']!='')
					{
						$transdate  = date('Y-m-d', strtotime($finalReconciliationData['transaction_date']));
					}
					else if($finalReconciliationData['gateway_created_on']!='')
					{
						$transdate  = date('Y-m-d', strtotime($finalReconciliationData['gateway_created_on']));
					}
					if(strtolower($finalReconciliationData['currency'])=='inr' && $transdate!='')
					{
						$checkTableName="tx_reconciliation_report_".strtolower($finalReconciliationData['currency'])."_";
						$monthOfCreated = date("m",strtotime($transdate));
						$yearOfCreated = date("Y",strtotime($transdate));
						if($monthOfCreated>=4)
						{
							$checkTableName .= $yearOfCreated."-".financial_year_start_month_date;
							$checkTableName .= "_to_".($yearOfCreated+1)."-".financial_year_end_month_date;
						}
						else
						{
							$checkTableName .= ($yearOfCreated-1)."-".financial_year_start_month_date;
							$checkTableName .= "_to_".$yearOfCreated."-".financial_year_end_month_date;
						}
					}
					else if(strtolower($finalReconciliationData['currency'])=='usd' && $transdate!='')
					{
						$checkTableName="tx_reconciliation_report_".strtolower($finalReconciliationData['currency'])."_".date('Y');
					}

					$checkTableName = str_replace("-","_",$checkTableName);

					if($checkTableName !="" && $reportsDb->table_exists($checkTableName) )
					{

					}
					else if($checkTableName !="")
					{
						$reportsDb->query("CREATE TABLE IF NOT EXISTS `".$checkTableName."` (
							`id` int(11) NOT NULL AUTO_INCREMENT,
							`ashram_id` int(11) DEFAULT '0',
							`seva_date` date DEFAULT NULL,
							`seva_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							`seva_number` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							`tx_date` datetime DEFAULT NULL,
							`tx_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							`tx_amount` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							`gateway_tx_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							`gateway_tx_amount` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							`gateway_tx_date` datetime DEFAULT NULL,
							`seva_total` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							`currency` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							`payment_gateway` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							`payment_mode` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							`transaction_status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							`gateway_status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							`user_id` int(10) NOT NULL DEFAULT 0,
							`username` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							`user_full_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							`user_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							`user_phone` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							`country_isd_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
							`is_no_transactions` ENUM('1','0') NOT NULL DEFAULT '0',
							PRIMARY KEY(`id`)
						  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");
					}

					$insdata = [
								'ashram_id' => $finalReconciliationData['ashram_id'],
								'seva_date' => $finalReconciliationData['seva_date'],
								'seva_id' => $finalReconciliationData['seva_id'],
								'seva_number' => $finalReconciliationData['seva_number'],
								'tx_date' => $finalReconciliationData['transaction_date'],
								'tx_id' => $finalReconciliationData['transaction_number'],
								'tx_amount' => $finalReconciliationData['amount'],
								'gateway_tx_id' => $finalReconciliationData['gateway_transaction_number'],
								'gateway_tx_amount' => $finalReconciliationData['gateway_amount'],
								'gateway_tx_date' => $finalReconciliationData['gateway_created_on'],
								'seva_total' => $finalReconciliationData['seva_total_price'],
								'currency' => $finalReconciliationData['currency'],
								'payment_gateway' => $finalReconciliationData['gateway_name'],
								'payment_mode' => $finalReconciliationData['payment_mode'],
								'transaction_status' => $finalReconciliationData['transaction_status'],
								'gateway_status' => $finalReconciliationData['gateway_status'],
								'user_id' => $finalReconciliationData['userid'],
								'username' => $finalReconciliationData['tx_username'],
								'user_full_name' => $finalReconciliationData['user_fullname'],
								'user_email' => $finalReconciliationData['user_email'],
								'user_phone' => $finalReconciliationData['user_phone'],
								'country_isd_code' => $finalReconciliationData['country_isd_code'],
							];
					if(isset($finalReconciliationData['is_no_transactions']) && $finalReconciliationData['is_no_transactions']=='1')
					{
						$insdata['is_no_transactions'] = $finalReconciliationData['is_no_transactions'];
					}

					if($checkTableName !="")
					{
						$reportsDb->insert($checkTableName,$insdata);
					}
				}
				$this->logaction->log("system","Inserting Data to Reconciliation Report Finished");
			}
			
			$this->logaction->log("system","create Reconciliation Report Records For Previous Data completed");
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
    }



    public function updateSubscriptionOrderItemsWithPaidCountAmountTxids()
    {
    	if(is_cli())
		{
			exit;
			ini_set('max_execution_time', 0);

			$this->logaction->log("system","Update Subscription OrderItems With PaidCount PaidAmount And Txids initiated");
			$query1=$this->db;
            $query1->select("oi.order_id as order_id,oi.id as order_item_id,sum(ts.amount) as total_paid_amount, count(ts.id) as paid_counts, GROUP_CONCAT(ts.tx) as transaction_ids");
            $query1->from("transaction as ts");
            $query1->join("order_items as oi",'ts.order_item_id=oi.id',"left");
            $query1->where_in('ts.status',array('completed','approved','success','paid','captured','Success','refunded','refund','Refunded','Refund'));
            $query1->where('ts.amount >',0);
            $query1->where('ts.order_id >',0);
            $query1->where('ts.order_item_id >',0);
            $query1->group_by('oi.id');
            $paidTransactions = $this->db->get()->result();

            foreach($paidTransactions as $paidTransaction)
            {
            	$this->load->model("payment_model");
            	$this->db->where("id",$paidTransaction->order_item_id);
	            $this->db->update("order_items",array("paid_amount"=>$paidTransaction->total_paid_amount,"transaction_ids"=>$paidTransaction->transaction_ids,"paid_count"=>$paidTransaction->paid_counts));

	            $this->payment_model->updateOrderItemRefundData($paidTransaction->order_item_id);
            }
    	}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
    }

    public function removeFailedDuplicateSubPayments()
    {
    	if(is_cli())
		{
			exit;
			ini_set('max_execution_time', 0);
	        $q = $this->db->query("SELECT spt.id,spt.tx, COUNT(spt.tx),spt.tx FROM subscription_payments_transaction_map as spt join subscription_payments as sp on sp.id = spt.subscription_payment_id where sp.payment_mode IN('paypal','stripe','razorpay')  GROUP BY spt.tx HAVING COUNT(spt.tx) > 1 order by id ASC");
	        $result = $q->result_array();
	        if(!empty($result))
	        {
	            foreach($result as $key=>$val)
	            {
	                $this->db->where("tx",$val["tx"]);
	                $this->db->where("id!=",$val["id"]);
	                $this->db->delete("subscription_payments_transaction_map");
	                log_message("error","Removed duplicate records for TX ".$val["tx"]);
	            }
	        }
	    }
    }

    public function updateOrdersWithPaidAmountTxids()
    {
    	if(is_cli())
		{
			ini_set('max_execution_time', 0);

			$years = ['2015','2016','2017','2018','2019','2020','2021'];
			foreach($years as $thisYear)
			{
				echo "Started updating orders table with total_paid, paid_tx_ids, cancelled_tx_ids, failed_tx_ids, refunded_tx_ids and no_paid_transactions ".$thisYear."\n";

	    		$q1 = $this->db->query("SELECT `o`.`id` as `order_id`, 
										SUM(IF(`ts`.`status` IN('completed', 'approved', 'success', 'paid', 'captured', 'Success', 'release payment', 'Release Payment'), ts.amount, 0)) as total_paid_amount,
										SUM(IF(`ts`.`status` IN('refund', 'Refund', 'Refunded', 'refunded'), ts.amount, 0)) as refund_amount,
										SUM(IF(`ts`.`status` IN('failed', 'failure'), ts.amount, 0)) as failed_amount,
										SUM(IF(`ts`.`status` IN('user cancelled'), ts.amount, 0)) as cancelled_amount,
										SUM(IF(`ts`.`status` IN('inprocess'), ts.amount, 0)) as inprocess_amount,
										SUM(IF(`ts`.`status` IN('bounced'), ts.amount, 0)) as bounced_amount,
										GROUP_CONCAT(IF(`ts`.`status` IN('completed', 'approved', 'success', 'paid', 'captured', 'Success', 'release payment', 'Release Payment') AND `ts`.`amount` >0, ts.tx, NULL) SEPARATOR ',') as paid_transaction_ids,
										GROUP_CONCAT(IF(`ts`.`status` IN('refund', 'Refund', 'Refunded', 'refunded'), ts.tx, NULL) SEPARATOR ',') as refund_transaction_ids,
										GROUP_CONCAT(IF(`ts`.`status` IN('failed', 'failure'), ts.tx, NULL) SEPARATOR ',') as failed_transaction_ids,
										GROUP_CONCAT(IF(`ts`.`status` IN('user cancelled'), ts.tx, NULL) SEPARATOR ',') as cancelled_transaction_ids,
										GROUP_CONCAT(IF(`ts`.`status` IN('inprocess'), ts.tx, NULL) SEPARATOR ',') as inprocess_transaction_ids,
										GROUP_CONCAT(IF(`ts`.`status` IN('bounced'), ts.tx, NULL) SEPARATOR ',') as bounced_transaction_ids,
										`o`.`currency`, 
										`o`.`order_type`, 
										`o`.`payment_mode` 
								FROM `orders` as `o` 
								LEFT JOIN `transaction` as `ts` ON `ts`.`order_id`=`o`.`id` 
								WHERE YEAR(o.date) = '".$thisYear."'
								GROUP BY `o`.`id`");
	            $paidTransactions = $q1->result_array();
	            if(!empty($paidTransactions))
	            {
	            	foreach($paidTransactions as $paidOrder)
	            	{
	            		$no_paid_transactions = 'No';
	            		if($paidOrder['paid_transaction_ids']=='')
	            		{
	            			$no_paid_transactions = 'Yes';
	            		}
	            		$updateData = array(
            								"total_paid"=>$paidOrder['total_paid_amount'],
            								"paid_tx_ids"=>$paidOrder['paid_transaction_ids'],
            								"refunded_tx_ids"=>$paidOrder['refund_transaction_ids'],
            								"failed_tx_ids"=>$paidOrder['failed_transaction_ids'],
            								"cancelled_tx_ids"=>$paidOrder['cancelled_transaction_ids'],
            								"inprocess_tx_ids"=>$paidOrder['inprocess_transaction_ids'],
            								"bounced_tx_ids"=>$paidOrder['bounced_transaction_ids'],
            								"no_paid_transactions"=>$no_paid_transactions
            							);
		            	$this->db->where("id",$paidOrder['order_id']);
		            	$this->db->update("orders",$updateData);

		            	$this->logaction->log("system","Updated orders table id=".$paidOrder['order_id']." with total_paid=".$paidOrder['total_paid_amount'].", paid_tx_ids=".$paidOrder['paid_transaction_ids'].", refunded_tx_ids=".$paidOrder['refund_transaction_ids'].", failed_tx_ids=".$paidOrder['failed_transaction_ids'].", cancelled_tx_ids=".$paidOrder['cancelled_transaction_ids'].", inprocess_tx_ids=".$paidOrder['inprocess_transaction_ids'].", bounced_tx_ids=".$paidOrder['bounced_transaction_ids']." and no_paid_transactions=".$no_paid_transactions);
		            	echo "completed updating Order - ".$paidOrder['order_id']."\n";
	            	}
	            }
	            echo "\n\n\n";
	        }

		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
    }


    public function updateOrdersWithPaidAmountTxidsForPerticularOrders()
    {
    	if(is_cli())
		{
			exit;
			ini_set('max_execution_time', 0);

			$orderIds = array('7266','28841','30496','38923','38965','39035','41335','49393','55004','56772');
    		$this->db->select("o.id as order_id, sum(ts.amount) as total_paid_amount, GROUP_CONCAT(ts.tx) as transaction_ids, o.currency, o.order_type, o.payment_mode");
            $this->db->from("transaction as ts");
            $this->db->join("orders as o",'ts.order_id=o.id',"left");
            $this->db->where_in('ts.status',array('completed','approved','success','paid','captured','Success','release payment','Release Payment'));
           	$this->db->where_in('o.order_type',array('1','2','3','4'));
           	$this->db->where_in('o.currency ',array('inr','usd'));
           	$this->db->where_in('o.payment_mode',array('Razorpay','PayPal', 'Stripe','Offline'));
           	$this->db->where_in('o.id',$orderIds);
            $this->db->where('ts.amount >',0);
            $this->db->group_by('o.id');
            $paidTransactions = $this->db->get()->result_array();
            if(!empty($paidTransactions))
            {
            	foreach($paidTransactions as $paidOrder)
            	{
            		$this->db->where("id",$paidOrder['order_id']);
	            	$this->db->update("orders",array("total_paid"=>$paidOrder['total_paid_amount'],"transaction_ids"=>$paidOrder['transaction_ids'],"no_paid_transactions"=>"No"));

	            	$this->logaction->log("system","Updated orders table id=".$paidOrder['order_id']." with total_paid=".$paidOrder['total_paid_amount']." and transaction_ids=".$paidOrder['transaction_ids']);
            	}
            }

		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
    }


    public function updateOrdersWithNoTransactionToYesForEmptyTxids()
    {
    	if(is_cli())
		{
			exit;
			ini_set('max_execution_time', 0);

    		$this->db->select("o.id as order_id");
            $this->db->from("orders as o");
           	$this->db->where_in('o.payment_mode',array('Razorpay','PayPal', 'Stripe'));
            $this->db->group_start();
	        $this->db->where('o.transaction_ids=',"");
	        $this->db->or_where('o.transaction_ids=',NULL);
	        $this->db->group_end();
            $emptyTxidsOrders = $this->db->get()->result_array();
            if(!empty($emptyTxidsOrders))
            {
            	foreach($emptyTxidsOrders as $emptyTxidsOrder)
            	{
            		$this->db->where("id",$emptyTxidsOrder['order_id']);
	            	$this->db->update("orders",array("no_paid_transactions"=>"Yes"));

	            	$this->logaction->log("system","Updated orders table id=".$emptyTxidsOrder['order_id']." with no_paid_transactions=Yes" );
            	}
            }

		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
    }


    public function updateOrdersWithNoTransactionToNoForPaidOrders()
    {
    	if(is_cli())
		{
			exit;
			ini_set('max_execution_time', 0);

    		$this->db->select("o.id as order_id, sum(ts.amount) as total_paid_amount, GROUP_CONCAT(ts.tx) as transaction_ids, o.currency, o.order_type, o.payment_mode");
            $this->db->from("orders as o");
            $this->db->join("transaction as ts",'ts.order_id=o.id',"left");
           	$this->db->where_in('o.payment_mode',array('Razorpay','PayPal', 'Stripe'));
           	$this->db->where_in('ts.status',array('completed','approved','success','paid','captured','Success','release payment','Release Payment'));
           	$this->db->where_in('o.order_type',array('1','2','3','4'));
           	$this->db->where_in('o.currency ',array('inr','usd'));
           	$this->db->where('ts.amount >',0);
           	$this->db->where('o.no_paid_transactions=',"Yes");

            $this->db->group_by('o.id');
            $noTxidsOrders = $this->db->get()->result_array();
            if(!empty($noTxidsOrders))
            {
            	foreach($noTxidsOrders as $noTxidsOrder)
            	{
            		$this->db->where("id",$noTxidsOrder['order_id']);
	            	$this->db->update("orders",array("total_paid"=>$noTxidsOrder['total_paid_amount'],"transaction_ids"=>$noTxidsOrder['transaction_ids'],"no_paid_transactions"=>"No"));

	            	$this->logaction->log("system","Updated orders table id=".$noTxidsOrder['order_id']." with total_paid=".$noTxidsOrder['total_paid_amount']." and transaction_ids=".$noTxidsOrder['transaction_ids']." and no_paid_transactions=No");
            	}
            }

		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
    }

    public function updateCurrencyInTransactioFromOrdersTable()
    {
    	exit;
    	if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->load->model("orders/orders_model");
			$years = ['2015','2016','2017','2018','2019','2020','2021'];
			foreach($years as $thisYear)
			{
				$this->db->select("t.order_id,t.ashram_id, o.order_number, o.date as order_date, t.tx as transaction_id, t.created_on as transaction_created_on, t.amount, o.currency, o.order_type, t.payment_mode, o.user_id, o.username, CONCAT(IFNULL(o.firstname,''),' ',IFNULL(o.middlename,''),' ',IFNULL(o.lastname,'')) as name, o.email, o.address1 as address_line_1, o.address2 as address_line_2, o.address3 as address_line_3, o.city, o.state, o.country_name as country, o.country as country_code,o.zipcode as zip, o.created_by, GROUP_CONCAT(oi.id) as item_ids, GROUP_CONCAT(oi.item_name) as item_names,t.subscription");
		        $this->db->from("transaction as t");
		        $this->db->join("orders as o",'o.id=t.order_id',"inner");
		        $this->db->join("order_items as oi",'oi.order_id=o.id',"left");
		        $this->db->where_in("t.status",array("completed",'success','release payment','approved','captured','paid','Release Payment','Success'));
		        $this->db->where("t.amount>",0);
		        $this->db->where("t.currency=",NULL);
		        $this->db->where("t.tx!=","");
		        $this->db->where("t.tx!=",NULL);
		        $this->db->where("YEAR(t.created_on)",$thisYear);
		        $this->db->group_by('t.id');
		        $this->db->order_by('t.id');
				$transactionResults = $this->db->get()->result();
				// echo $this->db->last_query(); die();
				// echo '<pre>'; print_r($transactionResults); die();
				$reports_db=$this->load->database("reports",true,false);

				$countries=$this->locations_model->getCountries(true);

				foreach ($transactionResults as $tx_record)
		        {
		        	if($tx_record->order_id)
		            {
		            	if(strtolower($tx_record->currency)=='inr')
		            	{
		            		$tableName = "tx_report_inr_";
		            		$monthOfCreated = date("m",strtotime($tx_record->transaction_created_on));
		            		$yearOfCreated = date("Y",strtotime($tx_record->transaction_created_on));
		            		if($monthOfCreated>=4)
		            		{
		            			$tableName .= $yearOfCreated."-".financial_year_start_month_date;
		                        $tableName .= "_to_".($yearOfCreated+1)."-".financial_year_end_month_date;
		            		}
		            		else
		            		{
		            			$tableName .= ($yearOfCreated-1)."-".financial_year_start_month_date;
		                        $tableName .= "_to_".$yearOfCreated."-".financial_year_end_month_date;
		            		}
		            		
		            	}
		            	else
		            	{
		            		$tableName = "tx_report_usd_".date("Y",strtotime($tx_record->transaction_created_on));
		            	}

		            	$tableName = str_replace("-","_",$tableName);
		            	if($reports_db->table_exists($tableName) )
						{
						  // table exists some code run query
						}
						else
						{
		            		$this->orders_model->createNewTransactionReportTable($tableName);
		            	}

		            	$countryName = "";
		            	if(isset($countries[$tx_record->country]->country_name))
		            	{
		            		$countryName = $countries[$tx_record->country]->country_name;
		            	}

		            	$reports_db->where("tx",$tx_record->transaction_id);
		                $record_exist=$reports_db->get($tableName)->num_rows();
		                
		                if($record_exist)
		                {
		                    continue;
		                }

		        	 	$insertData=array(
		                                    "order_id" => $tx_record->order_id,
											"ashram_id" => $tx_record->ashram_id,
											"order_item_id" => $tx_record->item_ids,
											"order_number" => $tx_record->order_number,
											"order_date" => $tx_record->order_date,
											"tx" => $tx_record->transaction_id,
											"item" => $tx_record->item_names,
											"transaction_date" => $tx_record->transaction_created_on,
											"amount" => $tx_record->amount,
											"currency" => strtolower($tx_record->currency),
											"order_type" => $tx_record->order_type,
											"payment_mode" => $tx_record->payment_mode,
											"user_id" => $tx_record->user_id,
											"username" => $tx_record->username,
											"name" => $tx_record->name,
											"email" => $tx_record->email,
											"address_line_1" => $tx_record->address_line_1,
											"address_line_2" => $tx_record->address_line_2,
											"address_line_3" => $tx_record->address_line_3,
											"city" => $tx_record->city,
											"state" => $tx_record->state,
											"country" => $countryName,
											"country_code" => $tx_record->country_code,
											"zip" => $tx_record->zip,
											"created_by" => $tx_record->created_by,
		                                    "created_on"=>date("Y:m:d H:i:s")
		                                );
		                $reports_db->insert($tableName,$insertData);


		                $this->db->select("tx, currency");
		                $this->db->where("tx",$tx_record->transaction_id);
		                $transaction_record=$this->db->get('transaction')->row();

		                if(!empty($transaction_record))
		                {
		                	if(isset($transaction_record->tx) && $transaction_record->tx==$tx_record->transaction_id && ($transaction_record->currency=="" || $transaction_record->currency=="NULL") )
		                	{
		                		$this->db->where("tx",$tx_record->transaction_id);
	            				$this->db->update("transaction",array("currency"=>strtolower($tx_record->currency)));
		                	}
		                }

		            }
		        }
		    }

		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
    }


    public function populateTransactionReportForAllYears()
    {
    	exit;
    	if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->load->model("orders/orders_model");
    		$this->logaction->log("system","Year end statement CRON initiated");
    		$this->orders_model->populateTransactionReport();
    		$this->logaction->log("system","Year end statement CRON completed");
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	public function updatePaypalRefundTransactionsYear2020()
    {
    	exit;
    	if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("t.id as transaction_table_id, rh.tx as original_tx, rh.refund_id as original_refund_id");
	        $this->db->from("transaction as t");
	        $this->db->join("refunds_history as rh",'rh.transaction_id=t.id');
	        $this->db->where("t.status","refund");
	        $this->db->where("t.created_on >=","2020-01-01 11:30:00");
	        $this->db->where("t.created_on <=","2021-01-01 11:29:59");
	        $this->db->where("t.payment_mode","paypal");
			$transactionResults = $this->db->get()->result();
			foreach ($transactionResults as $tx_record)
	        {
	        	$this->db->where("id",$tx_record->transaction_table_id);
				$this->db->update("transaction",array("refund_reference"=>$tx_record->original_tx, "tx"=>$tx_record->original_refund_id));
				echo "Updated transaction table where id=".$tx_record->transaction_table_id." with tx=".$tx_record->original_refund_id." and refund_reference=".$tx_record->original_tx."\n";
				$this->logaction->log("system","Updated transaction table where id=".$tx_record->transaction_table_id." with tx=".$tx_record->original_refund_id." and refund_reference=".$tx_record->original_tx);
	        }
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	public function generatePoornaphalaIdsAndEndDates()
    {
    	if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("*");
	        $this->db->from("order_items");
	        $this->db->where("is_poornaphala_seva",1);
			$orderItems = $this->db->get()->result();
			foreach ($orderItems as $orderItem)
			{
				$this->load->model("orders/orders_model");
				$this->orders_model->generatePoornaphalaUniqueIdByOrderItemId($orderItem->id);
				echo "Generated Poornaphala id and end dates for the order item ".$orderItem->id."\n";
				$this->logaction->log("system","Generated Poornaphala id and end dates for the order item ".$orderItem->id);
			}
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	public function updateUserTiePoornaphalaToDevoteeTiePoornaphala()
    {
    	if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("*");
	        $this->db->from("order_items");
	        $this->db->where("poornaphala_tie_by","User will tie Poornaphala");
			$orderItems = $this->db->get()->result();
			foreach ($orderItems as $orderItem)
			{
				$this->db->where("id",$orderItem->id);
				$this->db->update("order_items",array("poornaphala_tie_by"=> "Devotee will tie Poornaphala"));
				echo "Updated User will tie Poornaphala to Devotee will tie Poornaphala for the order item=".$orderItem->id."\n";
				$this->logaction->log("system","Updated User will tie Poornaphala to Devotee will tie Poornaphala for the order item=".$orderItem->id);
			}
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	public function updateTrustAccountStatusToActive()
    {
    	if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("*");
	        $this->db->from("ashrams_trust_accounts");
			$trustAccounts = $this->db->get()->result();
			foreach ($trustAccounts as $trustAccount)
			{
				$this->db->where("id",$trustAccount->id);
				$this->db->update("ashrams_trust_accounts",array("trust_status"=> "1"));
				echo "Updated trust accounts trust_ststus to active trustid=".$trustAccount->id."\n";
				$this->logaction->log("system","Updated trust accounts trust_ststus to active trustid=".$trustAccount->id);
			}
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}


	public function UpdateAdpt80g()
	{
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("*");
	        $this->db->from("ashrams_trust_accounts");
	        $this->db->where("tax_80g_501c3", "*The above donation is eligible for deduction under section 80G of the Income Tax Act, 1961, vide letter No. S-292/80G/CIT/MYS/2008-09 dated 15-04-2009 valid and is extended as per the amendment U/s 80G(5) (VI) of the Income Tax Act, 1961.");
	        $ashrams_trust_accounts = $this->db->get()->result();
			foreach ($ashrams_trust_accounts as $ashrams_trust_account)
			{
				$this->db->where("id",$ashrams_trust_account->id);
				$this->db->update("ashrams_trust_accounts",array("tax_80g_501c3"=> "*The above donation is eligible for deduction under the Income Tax Act 1961, as per the provisional approval under Clause (i) of first proviso to sub-section (5) of section 80G, vide DIN: AAATS5046GF2021401 dt. 28-05-2021 valid from AY 2022-23 to AY 2026-27. Donor must furnish PAN to get 80G benefit."));
				echo "Updated with new 80g for the ashrams_trust_accounts id=".$ashrams_trust_account->id."\n";
				$this->logaction->log("system","Updated with new 80g for the ashrams_trust_accounts id=".$ashrams_trust_account->id);
			}
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	public function UpdateSgst80g()
	{
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("*");
	        $this->db->from("ashrams_trust_accounts");
	        $this->db->where("tax_80g_501c3", "*The above donation is eligible for deduction under section 80G of the Income Tax Act, 1961, vide letter No. S-341/80G/CIT/MYS/2008-09 dated 19-06-2009 valid and is extended as per the amendment U/s 80G(5) (VI) of the Income Tax Act, 1961.");
	        $ashrams_trust_accounts = $this->db->get()->result();
			foreach ($ashrams_trust_accounts as $ashrams_trust_account)
			{
				$this->db->where("id",$ashrams_trust_account->id);
				$this->db->update("ashrams_trust_accounts",array("tax_80g_501c3"=> "*The above donation is eligible for deduction under the Income Tax Act 1961, as per the provisional approval under Clause (i) of first proviso to sub-section (5) of section 80G, vide DIN: AADTS5653GF2021401 dt. 28-05-2021 valid from AY 2022-23 to AY 2026-27. Donor must furnish PAN to get 80G benefit."));
				echo "Updated with new 80g for the ashrams_trust_accounts id=".$ashrams_trust_account->id."\n";
				$this->logaction->log("system","Updated with new 80g for the ashrams_trust_accounts id=".$ashrams_trust_account->id);
			}
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}


	public function UpdateAdpt80gFrom2021MarchOrders()
	{
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("*");
	        $this->db->from("orders");
	        $this->db->where("tax_80g_501c3", "*The above donation is eligible for deduction under section 80G of the Income Tax Act, 1961, vide letter No. S-292/80G/CIT/MYS/2008-09 dated 15-04-2009 valid and is extended as per the amendment U/s 80G(5) (VI) of the Income Tax Act, 1961.");
	        $this->db->where("date(date)>=", "2021-04-01");
			$orders = $this->db->get()->result();
			foreach ($orders as $order)
			{
				$this->db->where("id",$order->id);
				$this->db->update("orders",array("tax_80g_501c3"=> "*The above donation is eligible for deduction under the Income Tax Act 1961, as per the provisional approval under Clause (i) of first proviso to sub-section (5) of section 80G, vide DIN: AAATS5046GF2021401 dt. 28-05-2021 valid from AY 2022-23 to AY 2026-27. Donor must furnish PAN to get 80G benefit."));
				echo "Updated with new 80g for the order orderid=".$order->id."\n";
				$this->logaction->log("system","Updated with new 80g for the order orderid=".$order->id);
			}
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	public function UpdateSgst80gFrom2021MarchOrders()
	{
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("*");
	        $this->db->from("orders");
	        $this->db->where("tax_80g_501c3", "*The above donation is eligible for deduction under section 80G of the Income Tax Act, 1961, vide letter No. S-341/80G/CIT/MYS/2008-09 dated 19-06-2009 valid and is extended as per the amendment U/s 80G(5) (VI) of the Income Tax Act, 1961.");
	        $this->db->where("date(date)>=", "2021-04-01");
			$orders = $this->db->get()->result();
			foreach ($orders as $order)
			{
				$this->db->where("id",$order->id);
				$this->db->update("orders",array("tax_80g_501c3"=> "*The above donation is eligible for deduction under the Income Tax Act 1961, as per the provisional approval under Clause (i) of first proviso to sub-section (5) of section 80G, vide DIN: AADTS5653GF2021401 dt. 28-05-2021 valid from AY 2022-23 to AY 2026-27. Donor must furnish PAN to get 80G benefit."));
				echo "Updated with new 80g for the order orderid=".$order->id."\n";
				$this->logaction->log("system","Updated with new 80g for the order orderid=".$order->id);
			}
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	//To remove duplicate event types w.r.t transaction_id
	public function removeduplicateRazorpayhookevents_types()
	{
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$razorpayTables = [
								'razorpay_webhook_06Apr19_to_10Apr20',
								'razorpay_webhook_10Apr20_to_10May20',
								'razorpay_webhook_2020',
								'razorpay_webhook_2021',
								'razorpay_webhook',
							];
			$arch_db = $this->load->database("data_archives",true,false);
			foreach($razorpayTables as $razorpayTable)
			{
				if($razorpayTable !="" && $arch_db->table_exists($razorpayTable) )
				{
				    $sql_query = "SELECT count(id) as duplicate_ids,id,transaction_id,event_type,status from ".$razorpayTable." group by event_type,transaction_id having count(transaction_id) > 1 ";
				    $q = $arch_db->query($sql_query);
				    if($q->num_rows() > 0)
				    {
				        $r = $q->result_array();
				        foreach ($r as $key => $value) 
				        {
				            $arch_db->where("id!=",$value["id"]);
				            $arch_db->where("transaction_id",$value["transaction_id"]);
				            $arch_db->where("event_type",$value["event_type"]);
				            $arch_db->delete($razorpayTable);

				            echo "Deleted transaction_id=".$value["transaction_id"]." and event_type=".$value["event_type"]." and id=".$value["id"]."\n";
							$this->logaction->log("system","Deleted transaction_id=".$value["transaction_id"]." and event_type=".$value["event_type"]." and id=".$value["id"]);
				        }
				    }
				}
			}
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	//To remove duplicate event types w.r.t status
	public function removeduplicateRazorpayhookevents_status()
	{
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$razorpayTables = [
								'razorpay_webhook_06Apr19_to_10Apr20',
								'razorpay_webhook_10Apr20_to_10May20',
								'razorpay_webhook_2020',
								'razorpay_webhook_2021',
								'razorpay_webhook',
							];
			$arch_db = $this->load->database("data_archives",true,false);
			foreach($razorpayTables as $razorpayTable)
			{
				if($razorpayTable !="" && $arch_db->table_exists($razorpayTable) )
				{
				    $sql_query = "SELECT count(id) as duplicate_ids,id,transaction_id,event_type,status from ".$razorpayTable." group by status,transaction_id having count(transaction_id) > 1 ";
				    $q = $arch_db->query($sql_query);
				    if($q->num_rows() > 0)
				    {
				        $r = $q->result_array();
				        foreach ($r as $key => $value) 
				        {
				            $arch_db->where("id!=",$value["id"]);
				            $arch_db->where("transaction_id",$value["transaction_id"]);
				            $arch_db->where("status",$value["status"]);
				            $arch_db->delete($razorpayTable);

				            echo "Deleted transaction_id=".$value["transaction_id"]." and status=".$value["status"]." and id=".$value["id"]."\n";
							$this->logaction->log("system","Deleted transaction_id=".$value["transaction_id"]." and status=".$value["status"]." and id=".$value["id"]);
				        }
				    }
				}
			}
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	public function updateEmptyPoornaphalaToPriestTiePoornaphala()
    {
    	exit;
    	if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("*");
	        $this->db->from("order_items");
	        $this->db->where("poornaphala_tie_by","");
	        $this->db->where("is_poornaphala_seva",1);
			$orderItems = $this->db->get()->result();
			foreach ($orderItems as $orderItem)
			{
				$this->db->where("id",$orderItem->id);
				$this->db->update("order_items",array("poornaphala_tie_by"=> "Priest will tie Poornaphala"));
				echo "Updated empty Poornaphala tie by to Priest will tie Poornaphala for the order item=".$orderItem->id."\n";
				$this->logaction->log("system","Updated empty Poornaphala tie by to Priest will tie Poornaphala for the order item=".$orderItem->id);
			}
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}
	public function updateSamashthiChandiHomaMismatchedData($order_id=0)
    {
    	exit;
    	if($order_id>0)
    	{
			ini_set('max_execution_time', 0);
			$this->db->select("*");
	        $this->db->from("order_items");
	        $this->db->where("item_id",916);
	        // $this->db->where("order_id",$order_id);
	        $this->db->where("YEAR(start_date)","2021");
	        $this->db->where("YEAR(end_date)","2021");
	        $this->db->where("start_date !=","2021-10-14");
	        $this->db->where("end_date !=","2021-10-14");
			$orderItems = $this->db->get()->result();
			foreach($orderItems as $orderItem)
			{
				if(trim($orderItem->schedule_dates)!="")
				{
					$orderIteamDates = explode(",", $orderItem->schedule_dates);
					$orderDateSequence = $orderItem->sequence;
					$orderDatesCount = 0;
					if(!empty($orderIteamDates))
					{
						foreach($orderIteamDates as $orderIteamDate)
						{
							if(trim($orderIteamDate) !="")
							{
								$orderDatesCount++;
								if($orderDatesCount>1)
								{
									$newItemDataObj = $orderItem;
									$newItemData = (array)$newItemDataObj;
									unset($newItemData['id']);
									$newItemData['quantity'] = 1;
									$newItemData['start_date'] = "2021-10-14";
									$newItemData['end_date'] = "2021-10-14";
									$newItemData['schedule_dates'] = "14 Oct 2021";
									$this->db->insert("order_items",$newItemData);
									$newOrderItemId=$this->db->insert_id();
									echo 'Created New Order Item: '.$newOrderItemId.' for the date '.$orderIteamDate.' to 14 Oct 2021<br>';
									$this->db->select("*");
							        $this->db->from("order_items_dates");
							        $this->db->where("order_item_id",$orderItem->id);
							        $this->db->where("DATE(date)",date("Y-m-d",strtotime($orderIteamDate)));
									$orderItemsDatesOfItemDate = $this->db->get()->row();
									if(isset($orderItemsDatesOfItemDate->id) && trim($orderItemsDatesOfItemDate->id)!='')
									{
										$this->db->where("id",$orderItemsDatesOfItemDate->id);
										$this->db->update("order_items_dates",array('date'=>'2021-10-14 00:00:00', 'order_item_id'=>$newOrderItemId));
										echo 'Update Order Item date from '.$orderItemsDatesOfItemDate->date.' to 2021-10-14 00:00:00 and order_item_id from: '.$orderItemsDatesOfItemDate->order_item_id.' to '.$newOrderItemId.'  for the order_items_dates primary id:'.$orderItemsDatesOfItemDate->id.'<br>';
										$this->logaction->log("system",'Update Order Item date from '.$orderItemsDatesOfItemDate->date.' to 2021-10-14 00:00:00 and order_item_id from: '.$orderItemsDatesOfItemDate->order_item_id.' to '.$newOrderItemId.'  for the order_items_dates primary id:'.$orderItemsDatesOfItemDate->id);
									}
								}
								else
								{
									$updateItemData = [
													'quantity' => 1,
													'start_date' => "2021-10-14",
													'end_date' => "2021-10-14",
													'schedule_dates' => "14 Oct 2021",
												  ];
								  	$this->db->where("id",$orderItem->id);
									$this->db->update("order_items",$updateItemData);
								  	echo 'Update Order Item: '.$orderItem->id.' with  start_date from '.$orderItem->start_date.' to 2021-10-14, end_date from '.$orderItem->end_date.' to 2021-10-14, schedule_dates from '.$orderItem->schedule_dates.' to 14 Oct 2021<br>';
									$this->logaction->log("system",'Update Order Item: '.$orderItem->id.' with  start_date from '.$orderItem->start_date.' to 2021-10-14, end_date from '.$orderItem->end_date.' to 2021-10-14, schedule_dates from '.$orderItem->schedule_dates.' to 14 Oct 2021');
									$this->db->select("*");
							        $this->db->from("order_items_dates");
							        $this->db->where("order_item_id",$orderItem->id);
							        $this->db->where("DATE(date)",date("Y-m-d",strtotime($orderIteamDate)));
									$orderItemsDatesOfItemDate = $this->db->get()->row();
									if(isset($orderItemsDatesOfItemDate->id) && trim($orderItemsDatesOfItemDate->id)!='')
									{
										$this->db->where("id",$orderItemsDatesOfItemDate->id);
										$this->db->update("order_items_dates",array('date'=>'2021-10-14 00:00:00'));
										echo 'Update Order Item date from '.$orderItemsDatesOfItemDate->date.' to 2021-10-14 00:00:00  for the order_items_dates primary id:'.$orderItemsDatesOfItemDate->id.'<br>';
										$this->logaction->log("system",'Update Order Item date from '.$orderItemsDatesOfItemDate->date.' to 2021-10-14 00:00:00  for the order_items_dates primary id:'.$orderItemsDatesOfItemDate->id);
									}
								}
								
							}
						}
					}
				}
				
			}
		}
	}


	//Get trust 80g note from trust account and Create trust 80g note for every year from 2015 in a seperate table
	public function createTrust80gNoteByYearWise()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("id as trust_id, ashram_id, currency, tax_80g_501c3");
	        $this->db->from("ashrams_trust_accounts");
	        $this->db->where("currency","inr");
			$inrTrusts = $this->db->get()->result();
			// echo '<pre>'; print_r($inrTrusts); die();
            foreach($inrTrusts as $inrTrust)
            {
            	$this->load->model("ashrams/ashrams_trust_accounts_model");
				$this->ashrams_trust_accounts_model->createTrust80gYearNote($inrTrust->trust_id);
            }
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	//Get INR trusts and Update with current year trust 80g note and year
	public function updateTrust80gNoteYearInTrsusAccount()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);

			$yearStr = "";
			if(date('m')>=4)
            {
                $inrstartdate = date("Y")."-".financial_year_start_month_date;
                $inrenddate = (date("Y")+1)."-".financial_year_end_month_date;

                $yearStr = $inrstartdate."_to_".$inrenddate;
            }
            else
            {
                $inrstartdate = (date("Y")-1)."-".financial_year_start_month_date;
                $inrenddate = (date("Y"))."-".financial_year_end_month_date;

                $yearStr = $inrstartdate."_to_".$inrenddate;
            }

			$this->db->select("id as trust_id, ashram_id, currency, tax_80g_501c3");
	        $this->db->from("ashrams_trust_accounts");
	        $this->db->where("currency","inr");
	        $this->db->where("tax_80g_501c3 !=","");
			$inrTrusts = $this->db->get()->result();
            foreach($inrTrusts as $inrTrust)
            {
            	$this->load->model("ashrams/ashrams_trust_accounts_model");
            	$trust80gYearDetails = $this->ashrams_trust_accounts_model->getTrust80gByTrustIdAndYear($inrTrust->trust_id, $yearStr);
            	if(isset($trust80gYearDetails->id))
            	{
            		$this->db->where("id",$inrTrust->trust_id);
					$this->db->update("ashrams_trust_accounts",array('trust_80g_year_id'=>$trust80gYearDetails->id));

					echo 'Update ashrams_trust_accounts id: '.$inrTrust->trust_id.' trust_80g_year_id column with :'.$trust80gYearDetails->id.'<br>';
					$this->logaction->log("system",'Update ashrams_trust_accounts id: '.$inrTrust->trust_id.' trust_80g_year_id column with :'.$trust80gYearDetails->id);
            	}
            }
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}


	//Update Trust Id to transaction_temp table
	public function updateTrustIdToTransactionsTemp()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("id as trust_id, ashram_id, currency, account_for");
	        $this->db->from("ashrams_trust_accounts");
	        $this->db->where("trust_status", "1");
			$allTrusts = $this->db->get()->result();

			$this->db->select("id, ashram_id, currency, tx_order_type, trust_id");
	        $this->db->from("transaction_temp");
			$allTransactions = $this->db->get()->result();

			foreach($allTransactions as $thisTransaction)
			{
				foreach($allTrusts as $thisTrust)
				{
					if( ($thisTrust->ashram_id == $thisTransaction->ashram_id) && ($thisTrust->currency == $thisTransaction->currency) && ($thisTrust->account_for == $thisTransaction->tx_order_type))
					{
						$this->db->where("id",$thisTransaction->id);
						$this->db->update("transaction_temp",array('trust_id'=>$thisTrust->trust_id));

						echo 'Update transaction_temp id: '.$thisTransaction->id.' trust_id column from '.$thisTransaction->trust_id.' to :'.$thisTrust->trust_id.'<br>';
						$this->logaction->log("system",'Update transaction_temp id: '.$thisTransaction->id.' trust_id column from '.$thisTransaction->trust_id.' to :'.$thisTrust->trust_id);
					}
				}
			}

		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}


	//Update Trust Id to transaction table
	public function updateTrustIdToTransactions()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("id as trust_id, ashram_id, currency, account_for");
	        $this->db->from("ashrams_trust_accounts");
	        $this->db->where("trust_status", "1");
			$allTrusts = $this->db->get()->result();

			$this->db->select("id, ashram_id, currency, tx_order_type, trust_id");
	        $this->db->from("transaction");
			$allTransactions = $this->db->get()->result();

			foreach($allTransactions as $thisTransaction)
			{
				foreach($allTrusts as $thisTrust)
				{
					if( ($thisTrust->ashram_id == $thisTransaction->ashram_id) && ($thisTrust->currency == $thisTransaction->currency) && ($thisTrust->account_for == $thisTransaction->tx_order_type))
					{
						$this->db->where("id",$thisTransaction->id);
						$this->db->update("transaction",array('trust_id'=>$thisTrust->trust_id));

						echo 'Update transaction id: '.$thisTransaction->id.' trust_id column from '.$thisTransaction->trust_id.' to :'.$thisTrust->trust_id."\n";
						$this->logaction->log("system",'Update transaction id: '.$thisTransaction->id.' trust_id column from '.$thisTransaction->trust_id.' to :'.$thisTrust->trust_id);
					}
				}
			}

		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}


	//Update Trust Id to refunds_history table
	public function updateTrustIdTorefundsHistory()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("id as trust_id, ashram_id, currency, account_for");
	        $this->db->from("ashrams_trust_accounts");
	        $this->db->where("trust_status", "1");
			$allTrusts = $this->db->get()->result();

			$this->db->select("id, ashram_id, currency, order_type, trust_id");
	        $this->db->from("refunds_history");
			$allTransactions = $this->db->get()->result();

			foreach($allTransactions as $thisTransaction)
			{
				foreach($allTrusts as $thisTrust)
				{
					if( ($thisTrust->ashram_id == $thisTransaction->ashram_id) && ($thisTrust->currency == $thisTransaction->currency) && ($thisTrust->account_for == $thisTransaction->order_type))
					{
						$this->db->where("id",$thisTransaction->id);
						$this->db->update("refunds_history",array('trust_id'=>$thisTrust->trust_id));

						echo 'Update refunds_history id: '.$thisTransaction->id.' trust_id column from '.$thisTransaction->trust_id.' to :'.$thisTrust->trust_id."\n";
						$this->logaction->log("system",'Update refunds_history id: '.$thisTransaction->id.' trust_id column from '.$thisTransaction->trust_id.' to :'.$thisTrust->trust_id);
					}
				}
			}

		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}


	//Update Trust Id to order_items_refund_replace_logs table
	public function updateTrustIdToRefundReplaceLogs()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("id as trust_id, ashram_id, currency, account_for");
	        $this->db->from("ashrams_trust_accounts");
	        $this->db->where("trust_status", "1");
			$allTrusts = $this->db->get()->result();

			$this->db->select("id, ashram_id, currency, cart_type, trust_id");
	        $this->db->from("order_items_refund_replace_logs");
			$allTransactions = $this->db->get()->result();

			foreach($allTransactions as $thisTransaction)
			{
				foreach($allTrusts as $thisTrust)
				{
					if( ($thisTrust->ashram_id == $thisTransaction->ashram_id) && ($thisTrust->currency == $thisTransaction->currency) && ($thisTrust->account_for == $thisTransaction->cart_type))
					{
						$this->db->where("id",$thisTransaction->id);
						$this->db->update("order_items_refund_replace_logs",array('trust_id'=>$thisTrust->trust_id));

						echo 'Update order_items_refund_replace_logs id: '.$thisTransaction->id.' trust_id column from '.$thisTransaction->trust_id.' to :'.$thisTrust->trust_id."\n";
						$this->logaction->log("system",'Update order_items_refund_replace_logs id: '.$thisTransaction->id.' trust_id column from '.$thisTransaction->trust_id.' to :'.$thisTrust->trust_id);
					}
				}
			}

		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}


	//Update Trust Id to tx_reconciliation_report tables
	public function updateTrustIdToreconciliationReports()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("id as trust_id, ashram_id, currency, account_for");
	        $this->db->from("ashrams_trust_accounts");
	        $this->db->where("trust_status", "1");
			$allTrusts = $this->db->get()->result();

			$reports_db = $this->load->database("reports",true,false);
	        $a = "SHOW TABLES like '%tx_reconciliation_report_%'";
	        $q = $reports_db->query($a);
	        foreach ($q->result() as $key=>$value)
	        {
	            foreach ($value as $key1=>$tableName)
	            {
	                $reports_db->select("T1.id, T1.ashram_id, T1.currency, T2.order_type, T1.trust_id");
			        $reports_db->from($tableName." as T1");
			        $reports_db->join($this->db->database.".orders as T2",'T1.seva_id=T2.id',"left");
			        $reports_db->group_by("T1.id");
					$allTransactions = $reports_db->get()->result();
					// echo '<pre>'; print_r($allTransactions); die();
					foreach($allTransactions as $thisTransaction)
					{
						foreach($allTrusts as $thisTrust)
						{
							if( ($thisTrust->ashram_id == $thisTransaction->ashram_id) && ($thisTrust->currency == strtolower($thisTransaction->currency)) && ($thisTrust->account_for == $thisTransaction->order_type))
							{
								$reports_db->where("id",$thisTransaction->id);
								$reports_db->update($tableName,array('trust_id'=>$thisTrust->trust_id));

								echo 'Update '.$tableName.' id: '.$thisTransaction->id.' trust_id column from '.$thisTransaction->trust_id.' to :'.$thisTrust->trust_id."\n";
								$this->logaction->log("system",'Update '.$tableName.' id: '.$thisTransaction->id.' trust_id column from '.$thisTransaction->trust_id.' to :'.$thisTrust->trust_id);
							}
						}
					}
	            }
	        }

		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}



	//Update Trust Id to tx_report tables
	public function updateTrustIdTotransactionReports()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("id as trust_id, ashram_id, currency, account_for");
	        $this->db->from("ashrams_trust_accounts");
	        $this->db->where("trust_status", "1");
			$allTrusts = $this->db->get()->result();

			$reports_db = $this->load->database("reports",true,false);
	        $a = "SHOW TABLES like '%tx_report_%'";
	        $q = $reports_db->query($a);
	        foreach ($q->result() as $key=>$value)
	        {
	            foreach ($value as $key1=>$tableName)
	            {
	                $reports_db->select("T1.id, T1.ashram_id, T1.currency, T1.order_type, T1.trust_id");
			        $reports_db->from($tableName." as T1");
					$allTransactions = $reports_db->get()->result();
					foreach($allTransactions as $thisTransaction)
					{
						foreach($allTrusts as $thisTrust)
						{
							if( ($thisTrust->ashram_id == $thisTransaction->ashram_id) && ($thisTrust->currency == strtolower($thisTransaction->currency)) && ($thisTrust->account_for == $thisTransaction->order_type))
							{
								$reports_db->where("id",$thisTransaction->id);
								$reports_db->update($tableName,array('trust_id'=>$thisTrust->trust_id));

								echo 'Update '.$tableName.' id: '.$thisTransaction->id.' trust_id column from '.$thisTransaction->trust_id.' to :'.$thisTrust->trust_id."\n";
								$this->logaction->log("system",'Update '.$tableName.' id: '.$thisTransaction->id.' trust_id column from '.$thisTransaction->trust_id.' to :'.$thisTrust->trust_id);
							}
						}
					}
	            }
	        }

		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}



	//Replace content/dycs to content/dycs_images in dycs table content column
	public function replaceContentDdycsToContentDdycsImages()
	{
		exit;
		if(is_cli())
		{
			echo "Started Replace content/dycs to content/dycs_images in dycs table content column \n";
			ini_set('max_execution_time', 0);
			$this->db->select("*");
	        $this->db->from("dycs");
			$allDycs = $this->db->get()->result();
			foreach($allDycs as $thisDyc)
			{	
				$findText = aws_s3_base_url."content/dycs/";
				$replaceText = aws_s3_base_url."content/dycs_images/";
				$this->load->helper("simple_html_dom");
				$dom=new simple_html_dom();
				$tempContent=trim($thisDyc->content);
				$contentDom=$dom->load($tempContent);
				$images=$contentDom->find('img');
				if(count($images))
				{
					$tempContent=str_replace($findText,$replaceText,$tempContent);
					$this->db->where("id",$thisDyc->id);
					$this->db->update("dycs",array("content"=>$tempContent));
					$this->logaction->log("system",'Updated dycs table id: '.$thisDyc->id.' content column data from '.$thisDyc->content.' to :'.$tempContent);
				}
			}
			echo "Completed Replace content/dycs to content/dycs_images in dycs table content column \n";
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}



	//Move Pages Description Images from content/page_images/ to AWS ans update description in pages table with updated image url
	public function movePageImagesFromServerToAws()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			echo "Started Move Pages Description Images from content/page_images/ to AWS ans update description in pages table with updated image url \n";
			$this->load->model('content/page_images_model');
			$this->siteServivcesDb = $this->load->database("site_services",true,false);
			$this->siteServivcesDb->select("*");
	        $this->siteServivcesDb->from("pages");
			$allPages = $this->siteServivcesDb->get()->result();
			foreach($allPages as $thisPage)
			{	
				$this->load->helper("simple_html_dom");
				$dom=new simple_html_dom();
				$tempContent=$this->general_model->filtertext(trim($thisPage->description));
				$contentDom=$dom->load($tempContent);
				$images=$contentDom->find('img');
				if(count($images))
				{
					if($thisPage->id)
					{
						$existingImages=$this->page_images_model->getImagesByPageId($thisPage->id);
						$eArray=[];
						foreach ($existingImages as $eimage)
						{
							$eArray[$eimage->filename]=$eimage->id;
						}
						$editorImages=[];
						foreach ($images as $img_dom) 
						{
							$pathText=$img_dom->attr['src'];
							if(preg_match('/amazon/i',$pathText))
							{
								$editorImages[basename($pathText)]=basename($pathText);
							}
						}
						$diff=array_diff_key($eArray,$editorImages);

						if(count($diff))
						{
							foreach($diff as $ikey)
							$this->page_images_model->deleteImage($thisPage->id,$ikey);
						}

					}

					$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
													"secretKey"=>aws_s3_secret_key,
													"useSSL"=>false,
													"endpoint"=>"s3.amazonaws.com"));
					
					$amazonUri="content/page_images/".$thisPage->id."/";
					foreach ($images as $img_dom) 
					{
						$pathText=$img_dom->attr['src'];
						if(preg_match('/amazon/i',$pathText))
							continue;

						$path=$_SERVER['DOCUMENT_ROOT'].$pathText;
						if(file_exists($path))
						{
							$fname=basename($path);
							$extn=pathinfo ($fname,PATHINFO_EXTENSION);
							$newFileName = $thisPage->id."_".substr(md5(mt_rand() . microtime()), 0, 16).".".$extn;
							$tempContent=str_replace($pathText,aws_s3_base_url.$amazonUri.$newFileName,$tempContent);
							$this->s3->putObjectFile($path,aws_s3_bucket_name,$amazonUri.$newFileName,S3::ACL_PUBLIC_READ, array(), array());
							unlink($path);

							$imageData=array('filename' => $newFileName,
											'page_id' =>$thisPage->id
											);
							$this->page_images_model->insert($imageData);
						}
					}
					$this->siteServivcesDb->where("id",$thisPage->id);
					$this->siteServivcesDb->update("pages",array("description"=>$tempContent));
					$this->logaction->log("system",'Updated pages table id: '.$thisPage->id.' content column data from '.$thisPage->description.' to :'.$tempContent);
				}
			}
			echo "Completed Move Pages Description Images from content/page_images/ to AWS ans update description in pages table with updated image url \n";
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}



	//Move Events Description Images from content/page_images/ to AWS ans update description in events table with updated image url
	public function moveEventsImagesFromServerToAws()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			echo "Started Move Events Description Images from content/events_images/ to AWS ans update description in events table with updated image url \n";
			$this->load->model('content/events_description_images_model');
			$this->siteServivcesDb = $this->load->database("site_services",true,false);
			$this->siteServivcesDb->select("*");
	        $this->siteServivcesDb->from("events");
			$allEvents = $this->siteServivcesDb->get()->result();
			foreach($allEvents as $thisEvent)
			{	
				$this->load->helper("simple_html_dom");
				$dom=new simple_html_dom();
				$tempContent=$this->general_model->filtertext(trim($thisEvent->description));
				$contentDom=$dom->load($tempContent);
				$images=$contentDom->find('img');
				if(count($images))
				{
					if($thisEvent->id)
					{
						$existingImages=$this->events_description_images_model->getImagesByEventId($thisEvent->id);
						$eArray=[];
						foreach ($existingImages as $eimage)
						{
							$eArray[$eimage->filename]=$eimage->id;
						}
						$editorImages=[];
						foreach ($images as $img_dom) 
						{
							$pathText=$img_dom->attr['src'];
							if(preg_match('/amazon/i',$pathText))
							{
								$editorImages[basename($pathText)]=basename($pathText);
							}
						}
						$diff=array_diff_key($eArray,$editorImages);

						if(count($diff))
						{
							foreach($diff as $ikey)
							$this->events_description_images_model->deleteImage($thisEvent->id,$ikey);
						}

					}

					$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
													"secretKey"=>aws_s3_secret_key,
													"useSSL"=>false,
													"endpoint"=>"s3.amazonaws.com"));
					
					$amazonUri="content/events_images/".$thisEvent->id."/";
					foreach ($images as $img_dom) 
					{
						$pathText=$img_dom->attr['src'];
						if(preg_match('/amazon/i',$pathText))
							continue;

						$path=$_SERVER['DOCUMENT_ROOT'].$pathText;
						if(file_exists($path))
						{
							$fname=basename($path);
							$extn=pathinfo ($fname,PATHINFO_EXTENSION);
							$newFileName = $thisEvent->id."_".substr(md5(mt_rand() . microtime()), 0, 16).".".$extn;
							$tempContent=str_replace($pathText,aws_s3_base_url.$amazonUri.$newFileName,$tempContent);
							$this->s3->putObjectFile($path,aws_s3_bucket_name,$amazonUri.$newFileName,S3::ACL_PUBLIC_READ, array(), array());
							unlink($path);

							$imageData=array('filename' => $newFileName,
											'event_id' =>$thisEvent->id
											);
							$this->events_description_images_model->insert($imageData);
						}
					}
					$this->siteServivcesDb->where("id",$thisEvent->id);
					$this->siteServivcesDb->update("events",array("description"=>$tempContent));
					$this->logaction->log("system",'Updated events table id: '.$thisEvent->id.' content column data from '.$thisEvent->description.' to :'.$tempContent);
				}
			}
			echo "Completed Move Events Description Images from content/events_images/ to AWS ans update description in events table with updated image url \n";
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}


	//Update paymentGatewayConstants to respective trusts
	public function UpdatePaymentGatewayConstantsToRespectiveTrusts()
	{
		exit;
		if(is_cli())
		{
			echo "Started Update paymentGatewayConstants to respective trusts \n";
			ini_set('max_execution_time', 0);

			$constantsArr = [ 
								'payflow_url' => "https://pilot-payflowpro.paypal.com", 
								'razorpay_failed_tx_report_emails' => "bajidotwork@gmail.com,pavandotwork@gmail.com,sekhardotwork@gmail.com", 
								'razorpay_webhook_secret_key' => "z0MY1iRbbxp6QDU9", 
								'stripe_webhook_secret_key_inr' => "whsec_FTydV4GEz9Q9pBPZcsxKMYqaWre3Twkb", 
								'stripe_webhook_secret_key_usd' => "whsec_FTydV4GEz9Q9pBPZcsxKMYqaWre3Twkb", 
								'payu_url' => "https://test.payu.in", 
								'payu_get_url' => "https://test.payumoney.com", 
								'payu_auth_key' => "lwUVQfcRt3qsWST0+yXpEbeKnNB62L050/HaJYlK+54="

							];
			$this->db->select("*");
	        $this->db->from("ashrams_trust_accounts");
			$allTrusts = $this->db->get()->result();
			foreach($allTrusts as $thisTrust)
			{	
				$updatearr = [];
				if($thisTrust->payu_merchantkey!=="" || $thisTrust->payu_salt!=="" )
				{
					$updatearr['payu_url'] = $constantsArr['payu_url'];
					$updatearr['payu_get_url'] = $constantsArr['payu_get_url'];
					$updatearr['payu_auth_key'] = $constantsArr['payu_auth_key'];
				}
				if($thisTrust->stripe_public_key!=="" || $thisTrust->stripe_secret_key!=="" )
				{
					$updatearr['stripe_webhook_secret_key_inr'] = $constantsArr['stripe_webhook_secret_key_inr'];
					$updatearr['stripe_webhook_secret_key_usd'] = $constantsArr['stripe_webhook_secret_key_usd'];
				}
				if($thisTrust->razorpay_key!=="" || $thisTrust->razorpay_secret!=="" )
				{
					$updatearr['razorpay_failed_tx_report_emails'] = $constantsArr['razorpay_failed_tx_report_emails'];
					$updatearr['razorpay_webhook_secret_key'] = $constantsArr['razorpay_webhook_secret_key'];
				}
				if($thisTrust->payflow_user!=="" || $thisTrust->payflow_pwd!=="" )
				{
					$updatearr['payflow_url'] = $constantsArr['payflow_url'];
				}
				if(!empty($updatearr))
				{
					$this->db->where("id",$thisTrust->id);
					$this->db->update("ashrams_trust_accounts",$updatearr);
					$this->logaction->log("system",'Updated ashrams_trust_accounts table id: '.$thisTrust->id.' with '.$this->db->last_query());
				}
			}
			echo "Completed Update paymentGatewayConstants to respective trusts \n";
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}


	//Update Trust Id to orders table
	public function updateTrustIdToOrders()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("o.id, o.ashram_id, o.currency, o.order_type, o.trust_id, ata.id as ashram_trust_id");
			$this->db->join("ashrams_trust_accounts as ata",'ata.ashram_id=o.ashram_id AND ata.account_for=o.order_type AND ata.account_for=o.order_type', 'LEFT');
	        $this->db->from("orders as o");
	        $this->db->group_by("o.id");
			$allOrders = $this->db->get()->result();
			foreach($allOrders as $thisOrder)
			{
				$this->db->where("id",$thisOrder->id);
				$this->db->update("orders",array('trust_id'=>$thisOrder->ashram_trust_id));

				echo 'Update orders id: '.$thisOrder->id.' trust_id column from '.$thisOrder->trust_id.' to :'.$thisOrder->ashram_trust_id."\n";
				$this->logaction->log("system",'Update orders id: '.$thisOrder->id.' trust_id column from '.$thisOrder->trust_id.' to :'.$thisOrder->ashram_trust_id);
			}

		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	//Update Trust Id to orders_failed table
	public function updateTrustIdToFailedOrders()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("o.id, o.ashram_id, o.currency, o.order_type, o.trust_id, ata.id as ashram_trust_id");
			$this->db->join("ashrams_trust_accounts as ata",'ata.ashram_id=o.ashram_id AND ata.account_for=o.order_type AND ata.account_for=o.order_type', 'LEFT');
	        $this->db->from("orders_failed as o");
	        $this->db->group_by("o.id");
			$allFailedOrders = $this->db->get()->result();
			foreach($allFailedOrders as $thisOrder)
			{
				$this->db->where("id",$thisOrder->id);
				$this->db->update("orders_failed",array('trust_id'=>$thisOrder->ashram_trust_id));

				echo 'Update orders_failed id: '.$thisOrder->id.' trust_id column from '.$thisOrder->trust_id.' to :'.$thisOrder->ashram_trust_id."\n";
				$this->logaction->log("system",'Update orders_failed id: '.$thisOrder->id.' trust_id column from '.$thisOrder->trust_id.' to :'.$thisOrder->ashram_trust_id);
			}

		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	//Update Trust Id to orders_temp table
	public function updateTrustIdToTempOrders()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("o.id, o.ashram_id, o.currency, o.order_type, o.trust_id, ata.id as ashram_trust_id");
			$this->db->join("ashrams_trust_accounts as ata",'ata.ashram_id=o.ashram_id AND ata.account_for=o.order_type AND ata.account_for=o.order_type', 'LEFT');
	        $this->db->from("orders_temp as o");
	        $this->db->group_by("o.id");
			$allTempOrders = $this->db->get()->result();
			foreach($allTempOrders as $thisOrder)
			{
				$this->db->where("id",$thisOrder->id);
				$this->db->update("orders_temp",array('trust_id'=>$thisOrder->ashram_trust_id));

				echo 'Update orders_temp id: '.$thisOrder->id.' trust_id column from '.$thisOrder->trust_id.' to :'.$thisOrder->ashram_trust_id."\n";
				$this->logaction->log("system",'Update orders_temp id: '.$thisOrder->id.' trust_id column from '.$thisOrder->trust_id.' to :'.$thisOrder->ashram_trust_id);
			}

		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}


	//Update Donation Alias Name from Donation Name to donations table
	public function updateDonationAliasNameFromDonationName()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("id,donation_name");
	        $this->db->from("donations");
			$allDonations = $this->db->get()->result();
			foreach($allDonations as $thisDonation)
			{
				$this->db->where("id",$thisDonation->id);
				$this->db->update("donations",array('donation_alias_name'=>$thisDonation->donation_name));

				echo 'Update donations id: '.$thisDonation->id.' donation_alias_name column with '.$thisDonation->donation_name."\n";
				$this->logaction->log("system",'Update donations id: '.$thisDonation->id.' donation_alias_name column with '.$thisDonation->donation_name);
			}

		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	//Get ashram 80g note from ashram account and Create ashram 80g note for every year from 2015 in a seperate table
	public function createAshram80gNoteByYearWise()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("a.id as ashram_id, ata.tax_80g_501c3");
	        $this->db->from("ashrams as a");
	        $this->db->join("ashrams_trust_accounts as ata",'ata.ashram_id=a.id AND ata.tax_80g_501c3!=""', 'LEFT');
	        $this->db->group_by('a.id');
			$inrAshrams = $this->db->get()->result();
            foreach($inrAshrams as $inrAshram)
            {
            	$this->load->model("ashrams/ashrams_model");
				$this->ashrams_model->createAshram80gYearNote($inrAshram->ashram_id, $inrAshram->tax_80g_501c3);

				echo "Created 80g note years for the ashram id: ".$inrAshram->ashram_id."\n";
				$this->logaction->log("system","Created 80g note years for the ashram id: ".$inrAshram->ashram_id);
            }
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	//Update Ashram Year End Statement Text to Ashrams
	public function updateAshramYearEndStatementTextToAshrams()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$year_end_statement_text_inr = "Thank you for your continued support to <strong>".site_name_string1."</strong>. May Lord Dattatreya shower His choicest blessings upon you and your loved ones.<br/><br/>We hereby state that the donor does not receive any material goods or compensation in return for these donations, only spiritual blessings. If the below transactions don't tally with your records please raise a <a href = '".base_url."mytechsupport/createticket' target ='_blank'>Feedback / Support</a> request with details including transaction date, items purchased, amount, payment details to help reconcile the missing transactions.";

			$year_end_statement_text_usd = "";

			if(global_site_flag==4)
            {
            	$year_end_statement_text_usd = "Thank you for your continued support to Yoga Sangeeta.
                                        This letter is to confirm the total amount of your charitable donations, including pledge amounts to Yoga Sangeeta and/or its DBAs -- Yoga Tunes and SGS Birds Paradise, SGS Kamadhenu and SGS
                                        Gita Foundation, for the calendar year <span class='year-string'></span>.
                                        <div style='float: left;width: 100%; margin-top: 10px;'>
                                            Your total donation amount for the year <span class='year-string-with-to'></span> is <strong class='total-string-usd'></strong> <span class='total-string-in-words-usd'></span>.
                                        </div>
                                        <div style='float: left;width: 100%; margin-top: 10px;'>
                                            Please keep this letter for your tax records. Yoga Sangeeta is a 501 (c) (3) non-profit organization, as defined by IRS, with Tax ID: 26-1283894.
                                        </div>
                                        <div style='float: left;width: 100%; margin-top: 10px;'>
                                            The board and staff of Yoga Sangeeta sincerely express our deepest appreciation for your donations and continued support in every way. May all the efforts be blessed by Sri Swamiji and may all of us
                                            receive His choicest Blessings, Guidance and Grace!
                                        </div>
                                        <div style='float: left;width: 100%; margin-top: 10px;'>
                                            No goods or services as defined by the Internal Revenue Service have been provided by Yoga Sangeeta, in exchange for the contribution, or as a consideration for your making this gift.
                                        </div>
                                        <div style='float: left;width: 100%; margin-top: 10px;'>
                                            We encourage you to continue to support all our programs, such as Music Concerts, Satsang, Bala Datta, Yoga Sessions, etc., aimed at serving the public at large. We intend to continue to enhance
                                            and expand the spectrum of our activities with your support and participation.
                                        </div>";
            }
            else
            {
            	$year_end_statement_text_usd = "Thank you for your continued support to <strong>".site_name_string1."</strong>. May Lord Dattatreya shower His choicest blessings upon you and your loved ones. Below statement lists all TAX deductible donations for the year <span class='year-string'></span> made at ".site_name_string1." website, and are TAX deductible for USA residents ONLY.<br><br>Per IRS Regulations, we hereby state that the donor does not receive any material goods or compensation in return for these donations, only spiritual blessings. Datta Yoga Center, USA is a Non-Profit organization with TAX ID 25-1512568 and is collecting donations on behalf of ".site_name_string1." website online.<br><br>If the below transactions don't tally with your records please raise a <a href='".base_url."techsupport' target ='_blank'>Feedback / Support</a> request with details including transaction date, items purchased, amount, payment details to help reconcile the missing transactions.";
            }

            $this->db->select("a.id");
	        $this->db->from("ashrams as a");
			$allAshrams = $this->db->get()->result();
            foreach($allAshrams as $ashramData)
            {
            	$this->db->where("id",$ashramData->id);
				$this->db->update("ashrams",array('year_end_statement_text_inr'=>$year_end_statement_text_inr, 'year_end_statement_text_usd'=>$year_end_statement_text_usd));

				echo "Updated Year End Donations Statement text to ashrams id: ".$ashramData->id."\n";
				$this->logaction->log("system","Updated Year End Donations Statement text to ashrams id: ".$ashramData->id);
            }

		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	//Get ashram trust account and Create Basic Trust Details
	public function getAshramTrustAccountAndCreateTrustBasicDetails()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
	        $this->db->from("ashrams_trust_accounts");
			$ashramTrusts = $this->db->get()->result();
            foreach($ashramTrusts as $ashramTrust)
            {
            	if($ashramTrust->trust_name!=null)
            	{
	            	$this->db->from("trust_basic_details");
	            	$this->db->where("trust_name", $ashramTrust->trust_name);
	            	$this->db->where("currency", $ashramTrust->currency);
					$basicTrust = $this->db->get()->row();

					if(empty($basicTrust))
					{
						$insertData = [
										"trust_name" => $ashramTrust->trust_name,
										"contact_person" => $ashramTrust->contact_person,
										"currency" => $ashramTrust->currency,
										"description" => $ashramTrust->description,
										"address" => $ashramTrust->address,
										"trust_footer" => $ashramTrust->ashram_footer,
										"created_by" => 1,
										"created_on" => date("Y-md-d H:i:s"),
									];
						$this->db->insert('trust_basic_details',$insertData);


						echo "Created Basic Trust Details for the trust : ".$ashramTrust->trust_name." and the currency : ".$ashramTrust->currency."\n";
						$this->logaction->log("system","Created Basic Trust Details for the trust : ".$ashramTrust->trust_name." and the currency : ".$ashramTrust->currency);
					}
            	}
            }
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	//update Trust Basic Id To Ashram Trust Accounts
	public function updateTrustBasicIdToAshramTrustAccounts()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("ata.id as trust_id, ata.currency, ata.trust_name, tbd.trust_basic_id");
	        $this->db->from("ashrams_trust_accounts as ata");
	        $this->db->join("trust_basic_details as tbd",'ata.trust_name=tbd.trust_name AND ata.currency=tbd.currency');
	        $this->db->where("ata.trust_basic_id",0);
			$ashramTrusts = $this->db->get()->result();
            foreach($ashramTrusts as $ashramTrust)
            {
            	$this->db->where("id",$ashramTrust->trust_id);
				$this->db->update("ashrams_trust_accounts",array('trust_basic_id'=>$ashramTrust->trust_basic_id));

				echo "Updated ashrams_trust_accounts id: ".$ashramTrust->trust_id." with trust_basic_id: ".$ashramTrust->trust_basic_id."\n";
				$this->logaction->log("system","Updated ashrams_trust_accounts id: ".$ashramTrust->trust_id." with trust_basic_id: ".$ashramTrust->trust_basic_id);
            }
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	//Update Trust Year End Statement Text to Basic Trust Details
	public function updateTrustYearEndStatementTextToTrustBasicDetails()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$year_end_statement_text_inr = "Thank you for your continued support to <strong>".site_name_string1."</strong>. May Lord Dattatreya shower His choicest blessings upon you and your loved ones.<br/><br/>We hereby state that the donor does not receive any material goods or compensation in return for these donations, only spiritual blessings. If the below transactions don't tally with your records please raise a <a href = '".base_url."mytechsupport/createticket' target ='_blank'>Feedback / Support</a> request with details including transaction date, items purchased, amount, payment details to help reconcile the missing transactions.";

			$year_end_statement_text_usd = "";

			if(global_site_flag==4)
            {
            	$year_end_statement_text_usd = "Thank you for your continued support to Yoga Sangeeta.
                                        This letter is to confirm the total amount of your charitable donations, including pledge amounts to Yoga Sangeeta and/or its DBAs -- Yoga Tunes and SGS Birds Paradise, SGS Kamadhenu and SGS
                                        Gita Foundation, for the calendar year <span class='year-string'></span>.
                                        <div style='float: left;width: 100%; margin-top: 10px;'>
                                            Your total donation amount for the year <span class='year-string-with-to'></span> is <strong class='total-string-usd'></strong> <span class='total-string-in-words-usd'></span>.
                                        </div>
                                        <div style='float: left;width: 100%; margin-top: 10px;'>
                                            Please keep this letter for your tax records. Yoga Sangeeta is a 501 (c) (3) non-profit organization, as defined by IRS, with Tax ID: 26-1283894.
                                        </div>
                                        <div style='float: left;width: 100%; margin-top: 10px;'>
                                            The board and staff of Yoga Sangeeta sincerely express our deepest appreciation for your donations and continued support in every way. May all the efforts be blessed by Sri Swamiji and may all of us
                                            receive His choicest Blessings, Guidance and Grace!
                                        </div>
                                        <div style='float: left;width: 100%; margin-top: 10px;'>
                                            No goods or services as defined by the Internal Revenue Service have been provided by Yoga Sangeeta, in exchange for the contribution, or as a consideration for your making this gift.
                                        </div>
                                        <div style='float: left;width: 100%; margin-top: 10px;'>
                                            We encourage you to continue to support all our programs, such as Music Concerts, Satsang, Bala Datta, Yoga Sessions, etc., aimed at serving the public at large. We intend to continue to enhance
                                            and expand the spectrum of our activities with your support and participation.
                                        </div>";
            }
            else
            {
            	$year_end_statement_text_usd = "Thank you for your continued support to <strong>".site_name_string1."</strong>. May Lord Dattatreya shower His choicest blessings upon you and your loved ones. Below statement lists all TAX deductible donations for the year <span class='year-string'></span> made at ".site_name_string1." website, and are TAX deductible for USA residents ONLY.<br><br>Per IRS Regulations, we hereby state that the donor does not receive any material goods or compensation in return for these donations, only spiritual blessings. Datta Yoga Center, USA is a Non-Profit organization with TAX ID 25-1512568 and is collecting donations on behalf of ".site_name_string1." website online.<br><br>If the below transactions don't tally with your records please raise a <a href='".base_url."techsupport' target ='_blank'>Feedback / Support</a> request with details including transaction date, items purchased, amount, payment details to help reconcile the missing transactions.";
            }

            $this->db->select("trust_basic_id,currency");
	        $this->db->from("trust_basic_details");
			$allBasicTrusts = $this->db->get()->result();
            foreach($allBasicTrusts as $basicTrust)
            {
            	$updateArr = [];
            	if($basicTrust->currency=='inr')
            	{
            		$updateArr['year_end_statement_text'] = $year_end_statement_text_inr;
            	}
            	if($basicTrust->currency=='usd')
            	{
            		$updateArr['year_end_statement_text'] = $year_end_statement_text_usd;
            	}
            	if(count($updateArr)>0)
            	{
	            	$this->db->where("trust_basic_id",$basicTrust->trust_basic_id);
					$this->db->update("trust_basic_details",$updateArr);

					echo "Updated Year End Donations Statement text to trust_basic_details trust_basic_id: ".$basicTrust->trust_basic_id."\n";
					$this->logaction->log("system","Updated Year End Donations Statement text to trust_basic_details trust_basic_id: ".$basicTrust->trust_basic_id);
            	}
            }

		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	//Update Ashrams Year End Statement Address Name From Trust
	public function updateAshramsYearEndStatementAddressNameFromTrust()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("id");
	        $this->db->from("ashrams");
			$allAshrams = $this->db->get()->result();
            foreach($allAshrams as $thisAshram)
            {
            	$updateArr = [];
            	$inrTrustName = "";
				$inrTrustAddress = "";
				$usdTrustName = "";
				$usdTrustAddress = "";
            	$this->load->model("ashrams/ashrams_trust_accounts_model");

				$inrAshramSettings = $this->ashrams_trust_accounts_model->getTrustByAshramIdCurrency($thisAshram->id,'inr');
				if(isset($inrAshramSettings['trust_name']) && $inrAshramSettings['trust_name']!='')
				{
					$inrTrustName = $inrAshramSettings['trust_name'];
				}
				if(isset($inrAshramSettings['address']) && $inrAshramSettings['address']!='')
				{
					$inrTrustAddress = $inrAshramSettings['address'];
				}

				$usdAshramSettings = $this->ashrams_trust_accounts_model->getTrustByAshramIdCurrency($thisAshram->id,'usd');
				if(isset($usdAshramSettings['trust_name']) && $usdAshramSettings['trust_name']!='')
				{
					$usdTrustName = $usdAshramSettings['trust_name'];
				}
				if(isset($usdAshramSettings['address']) && $usdAshramSettings['address']!='')
				{
					$usdTrustAddress = $usdAshramSettings['address'];
				}

				
				if($inrTrustName!="")
				{
					$updateArr['trust_name_inr'] = $inrTrustName;
				}
				if($inrTrustAddress!="")
				{
					$updateArr['trust_address_inr'] = $inrTrustAddress;
				}

				if($usdTrustName!="")
				{
					$updateArr['trust_name_usd'] = $usdTrustName;
				}
				if($usdTrustAddress!="")
				{
					$updateArr['trust_address_usd'] = $usdTrustAddress;
				}
				if(count($updateArr)>0)
            	{
            		$this->db->where("id",$thisAshram->id);
					$this->db->update("ashrams",$updateArr);

					echo "Updated Trust Name and Address for Year End Donations Statement of ashrams id: ".$thisAshram->id."\n";
					$this->logaction->log("system","Updated Trust Name and Address for Year End Donations Statement of ashrams id: ".$thisAshram->id);
            	}
			}
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	//Update Ashram names to Ashrams trust accounts
	public function updateAshramNamesToAshramsTrustAccounts()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("id, name");
	        $this->db->from("ashrams");
			$allAshrams = $this->db->get()->result_array();
			$ashramIdNames = [];
			foreach($allAshrams as $thisAshram)
            {
            	$ashramIdNames[$thisAshram['id']] = $thisAshram['name'];
            }

            $this->db->select("id, ashram_id");
	        $this->db->from("ashrams_trust_accounts");
			$allAshramTrusts = $this->db->get()->result_array();

			foreach($allAshramTrusts as $thisAshramTrust)
            {
            	if(isset($ashramIdNames[$thisAshramTrust['ashram_id']]) && $ashramIdNames[$thisAshramTrust['ashram_id']]!="")
            	{
            		$this->db->where("id",$thisAshramTrust['id']);
					$this->db->update("ashrams_trust_accounts",array('ashram_name'=>$ashramIdNames[$thisAshramTrust['ashram_id']]));

					echo "Updated Ashram Name of ashramtrusts id: ".$thisAshramTrust['id']." column ashran_name with ".$ashramIdNames[$thisAshramTrust['ashram_id']]."\n";
					$this->logaction->log("system","Updated Ashram Name of ashramtrusts id: ".$thisAshramTrust['id']." column ashran_name with ".$ashramIdNames[$thisAshramTrust['ashram_id']]);
            	}
            }
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	//Update Ashram Newsletters sms_message from email_content and empty email_content if newsletter type is sms
	public function updateAshramNewslettersSmsMessageFromEmailContentIfNewsletterTypeIsSms()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("id,email_content");
	        $this->db->from("ashram_newsletters");
	        $this->db->where("type",2);
			$ashramSmsNewsletters = $this->db->get()->result();
			if(!empty($ashramSmsNewsletters))
			{
				foreach($ashramSmsNewsletters as $ashramSmsNewsletter)
	            {
            		$this->db->where("id",$ashramSmsNewsletter->id);
					$this->db->update("ashram_newsletters",array('sms_message'=>$ashramSmsNewsletter->email_content,'email_content'=>''));

					echo "Updated ashram_newsletters id: ".$ashramSmsNewsletter->id." column sms_message\n";
					$this->logaction->log("system","Updated ashram_newsletters id: ".$ashramSmsNewsletter->id." column sms_message");
	            }
			}
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	//Update Ashram Newsletters total_sms_recipients from total_email_recipients and make total_email_recipients 0 if newsletter type is sms
	public function updateAshramNewslettersTotalSmsCountFromTotalEmailCountIfNewsletterTypeIsSms()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("id,total_email_recipients");
	        $this->db->from("ashram_newsletters");
	        $this->db->where("type",2);
			$ashramSmsNewsletters = $this->db->get()->result();
			if(!empty($ashramSmsNewsletters))
			{
				foreach($ashramSmsNewsletters as $ashramSmsNewsletter)
	            {
            		$this->db->where("id",$ashramSmsNewsletter->id);
					$this->db->update("ashram_newsletters",array('total_sms_recipients'=>$ashramSmsNewsletter->total_email_recipients,'total_email_recipients'=>0));

					echo "Updated ashram_newsletters id: ".$ashramSmsNewsletter->id." column total_sms_recipients".$ashramSmsNewsletter->total_email_recipients."\n";
					$this->logaction->log("system","Updated ashram_newsletters id: ".$ashramSmsNewsletter->id." column total_sms_recipients".$ashramSmsNewsletter->total_email_recipients);
	            }
			}
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	//Create/update vishwashanti pada yatra table records for already paid orders
	public function updateVishwashantiPadaYatraTableRecordsForAlreadyPaidOrders()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->load->model("orders/orders_model");
			$this->db->select("GROUP_CONCAT(DISTINCT order_id SEPARATOR ',') as order_ids");
			$this->db->from("order_items");
			$this->db->where_in('item_id',vishwashantipadayatra2022_full_donation_ids);
			$order_items=$this->db->get()->row_array();

			$order_ids = [];
			if(isset($order_items['order_ids']) && $order_items['order_ids']!='')
			{
				$order_ids = explode(',', $order_items['order_ids']);
			}

			if(count($order_ids)>0)
			{
				$toBeInsertArray = array();
				foreach($order_ids as $thisOrderId)
				{
					$results = $this->orders_model->updateVishwashantiPadaYatraDonationOrderItems($thisOrderId);
					if(!empty($results))
					{
						foreach ($results as $key => $thisResult)
						{
							// $toBeInsertArray[] = $thisResult;
							$this->db->insert('vishwashanti_pada_yatra_orders',$thisResult);
							echo "Created vishwashanti pada yatra record for the order id: ".$thisOrderId."\n";
							$this->logaction->log("system","Created vishwashanti pada yatra record for the order id: ".$thisOrderId);
						}
					}
				}
			}
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	//Update grant access report url with only access key parameter(remove other parameters from url)
	public function updateGrantAccessReportUrlWithOnlyAccessKey()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("id,report_url");
	        $this->db->from("sevas_report_access_users");
			$grantAccessReports = $this->db->get()->result();
			if(!empty($grantAccessReports))
			{
				foreach($grantAccessReports as $grantAccessReport)
	            {
	            	$urlParts = parse_url($grantAccessReport->report_url);
					parse_str($urlParts['query'], $query);
					$reportUrl = $urlParts['scheme']. '://'. $urlParts['host'].  $urlParts['path']."?access_key=".$query['access_key'];
            		$this->db->where("id",$grantAccessReport->id);
					$this->db->update("sevas_report_access_users",array('report_url'=>$reportUrl));

					echo "Updated sevas_report_access_users id: ".$grantAccessReport->id." column report_url with: ".$reportUrl."\n";
					$this->logaction->log("system","Updated sevas_report_access_users id: ".$grantAccessReport->id." column report_url with ".$reportUrl);
	            }
			}
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	//Update Trust Id to orders table
	public function updateTrustIdToOrdersTable()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("id as trust_id, ashram_id, currency, account_for");
	        $this->db->from("ashrams_trust_accounts");
	        $this->db->where("trust_status", "1");
			$allTrusts = $this->db->get()->result();

			$this->db->select("id, ashram_id, currency, order_type, trust_id");
	        $this->db->from("orders as o");
			$allOrders = $this->db->get()->result();
			foreach($allOrders as $thisOrder)
			{
				foreach($allTrusts as $thisTrust)
				{
					if( ($thisTrust->ashram_id == $thisOrder->ashram_id) && ($thisTrust->currency == $thisOrder->currency) && ($thisTrust->account_for == $thisOrder->order_type))
					{
						$this->db->where("id",$thisOrder->id);
						$this->db->update("transaction",array('trust_id'=>$thisTrust->trust_id));

						echo 'Update Orders id: '.$thisOrder->id.' trust_id column from '.$thisOrder->trust_id.' to :'.$thisTrust->trust_id."\n";
						$this->logaction->log("system",'Update Orders id: '.$thisOrder->id.' trust_id column from '.$thisOrder->trust_id.' to :'.$thisTrust->trust_id);
					}
				}
			}

		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	public function getStripePaidSubscriptionsButTransactionNotCreated()
	{
		exit;
		ini_set('max_execution_time', 0);
		$archivesDb = $this->load->database("data_archives",true,false);
		$stripeTables = [
			'stripe_webhook_2021',
			'stripe_webhook_2022'
		];
		$gatewayTransactions = [];
		foreach($stripeTables as $stripeTable)
		{
			if($stripeTable !="" && $archivesDb->table_exists($stripeTable) )
			{
				$archivesDb->select("subscription_id, transaction_id, amount, created_on, status, 'stripe' as gateway_name");
				$archivesDb->from($stripeTable);
				$archivesDb->where("transaction_id!=","");
				$archivesDb->where('subscription_id!=',"");
				$archivesDb->where("amount>",0);
				$resultTransactions = $archivesDb->get()->result_array();
				if(count($resultTransactions)>0)
				{
					foreach($resultTransactions as $resultTransaction)
					{
						$gatewayTransactions[] = $resultTransaction;
					}
				}
			}
		}
		// echo '<pre>'; print_r($gatewayTransactions); die();
		// $gatewayTransactionIds = array_column($gatewayTransactions, 'transaction_id');
		// echo '<pre>'; print_r($gatewayTransactionIds); die();
		if(!empty($gatewayTransactions))
		{
			echo "<b>Missing Stripe Transactios</b><br><br>";
			$count = 1;
			foreach($gatewayTransactions as $gatewayTransaction)
			{
				$this->db->select("tx");
				$this->db->from("transaction");
				$this->db->where('tx',$gatewayTransaction['transaction_id']);
				$txrow=$this->db->get()->row_array();
				if(empty($txrow))
				{
					echo $count.')  Subscription_id: '.$gatewayTransaction['subscription_id'].' ----- Transaction Id: '.$gatewayTransaction['transaction_id']."<br>";
					$count++;
				}
			}
		}
	}


	//Get Appji Paid Donation but Missed update in donationlinks table
	public function appjiPaidDonationsButMissedUpdateInDonationlinksTable()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("o.id as order_id, o.order_number, o.date as order_date, o.user_id, o.username, o.transaction_id, CONCAT(o.firstname, ' ', o.lastname) as user_full_name, o.email as user_email, o.phone as user_phone, o.isd_code as country_isd_code, o.address1 as address_line_1, o.address2 as address_line_2, o.address3 as address_line_3, o.city, o.state, o.country_name as country, o.country as country_code,o.zipcode as zip, oi.id as order_item_id, adl.linkToken as donation_link_token");
	        $this->db->from("appji_donations_links as adl");
	        $this->db->join("order_items as oi",'oi.link_token=adl.linkToken');
	        $this->db->join("orders as o",'o.id=oi.order_id');
	        $this->db->where("o.payment_status", '1');
	        $this->db->where("o.is_appji_order", '0');
	        $this->db->where("adl.is_updated_in_appji", '0');
			$records = $this->db->get()->result();
			if(!empty($records))
			{
				foreach($records as $thisrecord)
				{
					if(isset($thisrecord->order_id) && $thisrecord->order_id>0)
					{
						$this->db->where("id",$thisrecord->order_id);
						$this->db->update("orders",array('is_appji_order'=>'1'));
						echo "Updated orders id: ".$thisrecord->order_id." column is_appji_order with: 1 \n";
						$this->logaction->log("system","Updated orders id: ".$thisrecord->order_id." column is_appji_order with: 1 \n");

						$this->load->model("orders/orders_model");
						$this->orders_model->updateAppjiLinkTokens($thisrecord->order_id);
						echo "Updated donation link token: ".$thisrecord->donation_link_token." updated with paid details\n";
						$this->logaction->log("system","Updated donation link token: ".$thisrecord->donation_link_token." updated with paid details\n");
					}
				}
			}
			
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	//Update ashram_alias_name with ashram_name to all orders_temp
	public function updateAshramAliasNameWithAshramNameToAllOrdersTemp()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			echo "Update ashram_alias_name with ashram_name to all orders_temp started \n";
			$this->logaction->log("system","Update ashram_alias_name with ashram_name to all orders_temp started \n");
			$updateSql = "UPDATE `orders_temp` SET `ashram_alias_name`=`ashram_name`";
            $this->db->query($updateSql);
            echo "Update ashram_alias_name with ashram_name to all orders_temp done \n";
            $this->logaction->log("system","Update ashram_alias_name with ashram_name to all orders_temp done \n");
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}
	//Update ashram_alias_name with ashram_name to all orders
	public function updateAshramAliasNameWithAshramNameToAllOrders()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			echo "Update ashram_alias_name with ashram_name to all orders started \n";
			$this->logaction->log("system","Update ashram_alias_name with ashram_name to all orders started \n");
			$updateSql = "UPDATE `orders` SET `ashram_alias_name`=`ashram_name`";
            $this->db->query($updateSql);
            echo "Update ashram_alias_name with ashram_name to all orders done \n";
            $this->logaction->log("system","Update ashram_alias_name with ashram_name to all orders done \n");
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}
	//Update ashram_alias_name with ashram_name to all orders_failed
	public function updateAshramAliasNameWithAshramNameToAllOrdersFailed()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			echo "Update ashram_alias_name with ashram_name to all orders_failed started \n";
			$this->logaction->log("system","Update ashram_alias_name with ashram_name to all orders_failed started \n");
			$updateSql = "UPDATE `orders_failed` SET `ashram_alias_name`=`ashram_name`";
            $this->db->query($updateSql);
            echo "Update ashram_alias_name with ashram_name to all orders_failed done \n";
            $this->logaction->log("system","Update ashram_alias_name with ashram_name to all orders_failed done \n");
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	//Update Shodasha Datta Kshetra Pada Yatra as ashram_alias_name with Shodasha Datta Kshetra Pada Yatra to all orders related
	public function updateAshramAliasNameWithShodashaDattaKshetraPadaYatraToAllRespectiveOrders()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$donation_ids = shodasha_datta_kshetra_pada_yatra_donation_ids;
			echo "Updated orders started \n\n";
			$this->db->select("o.id as order_id");
	        $this->db->from("orders as o");
	        $this->db->join("order_items as oi",'oi.order_id=o.id');
	        $this->db->where_in('oi.item_id',$donation_ids);
	        $this->db->group_by('o.id');
			$records = $this->db->get()->result();
			if(!empty($records))
			{
				foreach($records as $thisrecord)
				{
					if(isset($thisrecord->order_id) && $thisrecord->order_id>0)
					{
						$this->db->where("id",$thisrecord->order_id);
						$this->db->update("orders",array('ashram_alias_name'=>'Shodasha Datta Kshetra Pada Yatra - Vishwashanti Yatra'));
						echo "Updated orders id: ".$thisrecord->order_id." column ashram_alias_name with: Shodasha Datta Kshetra Pada Yatra - Vishwashanti Yatra \n";
						$this->logaction->log("system","Updated orders id: ".$thisrecord->order_id." column ashram_alias_name with: Shodasha Datta Kshetra Pada Yatra - Vishwashanti Yatra \n");
					}
				}
			}
			echo "Updated orders ends \n\n";
			echo "Updated orders_temp started \n\n";
			$this->db->select("o.id as order_id");
	        $this->db->from("orders_temp as o");
	        $this->db->join("order_items_temp as oi",'oi.order_id=o.id');
	        $this->db->where_in('oi.item_id',$donation_ids);
	        $this->db->group_by('o.id');
			$records = $this->db->get()->result();
			if(!empty($records))
			{
				foreach($records as $thisrecord)
				{
					if(isset($thisrecord->order_id) && $thisrecord->order_id>0)
					{
						$this->db->where("id",$thisrecord->order_id);
						$this->db->update("orders_temp",array('ashram_alias_name'=>'Shodasha Datta Kshetra Pada Yatra - Vishwashanti Yatra'));
						echo "Updated orders_temp id: ".$thisrecord->order_id." column ashram_alias_name with: Shodasha Datta Kshetra Pada Yatra - Vishwashanti Yatra \n";
						$this->logaction->log("system","Updated orders_temp id: ".$thisrecord->order_id." column ashram_alias_name with: Shodasha Datta Kshetra Pada Yatra - Vishwashanti Yatra \n");
					}
				}
			}
			echo "Updated orders_temp ends \n\n";
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}



	//Update 2022-2023 80g text to all orders related(orders_temp, orders, orders_failed)
	public function update2022202380GToAllRespectiveOrders()
	{
		exit;
		$ashram_ids = [4,5,7,8,10,13,15,16];
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			echo "Update orders started \n\n";
			$this->db->select("o.id");
	        $this->db->from("orders as o");
	        $this->db->where_in('o.ashram_id',$ashram_ids);
	        $this->db->where("date(o.date)>=", "2022-04-01");
	        $orders = $this->db->get()->result();
			foreach ($orders as $order)
			{
				$this->db->where("id",$order->id);
				$this->db->update("orders",array("tax_80g_501c3"=> "Deduction under section 80G of the Income Tax Act, 1961 will be available only if the donor furnishes PAN, Aadhar or other identification numbers, to the Trust."));
				echo "Updated with new 80g for the order orderid=".$order->id."\n";
				$this->logaction->log("system","Updated with new 80g for the order orderid=".$order->id);
			}
			echo "Update orders ends \n\n\n\n\n\n";

			echo "Update orders_temp started \n\n";
			$this->db->select("to.id");
	        $this->db->from("orders_temp as to");
	        $this->db->where_in('to.ashram_id',$ashram_ids);
	        $this->db->where("date(to.date)>=", "2022-04-01");
	        $tempOrders = $this->db->get()->result();
			foreach ($tempOrders as $tempOrder)
			{
				$this->db->where("id",$tempOrder->id);
				$this->db->update("orders_temp",array("tax_80g_501c3"=> "Deduction under section 80G of the Income Tax Act, 1961 will be available only if the donor furnishes PAN, Aadhar or other identification numbers, to the Trust."));
				echo "Updated with new 80g for the orders_temp d=".$tempOrder->id."\n";
				$this->logaction->log("system","Updated with new 80g for the orders_temp id=".$tempOrder->id);
			}
			echo "Update orders_temp ends \n\n\n\n\n\n";

			echo "Update orders_failed started \n\n";
			$this->db->select("fo.id");
	        $this->db->from("orders_failed as fo");
	        $this->db->where_in('fo.ashram_id',$ashram_ids);
	        $this->db->where("date(fo.date)>=", "2022-04-01");
	        $failedOrders = $this->db->get()->result();
			foreach ($failedOrders as $failedOrder)
			{
				$this->db->where("id",$failedOrder->id);
				$this->db->update("orders_failed",array("tax_80g_501c3"=> "Deduction under section 80G of the Income Tax Act, 1961 will be available only if the donor furnishes PAN, Aadhar or other identification numbers, to the Trust."));
				echo "Updated with new 80g for the orders_failed d=".$failedOrder->id."\n";
				$this->logaction->log("system","Updated with new 80g for the orders_failed id=".$failedOrder->id);
			}
			echo "Update orders_failed ends \n\n\n\n\n\n";
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}
	public function transactionResponseIntoArcheivesDB(){
		exit;
		if(is_cli()) {
			ini_set('max_execution_time', 0);
			 //loading archives database
			 $archivesDb=$this->load->database("data_archives",true);
			 echo "Started transaction data migration to archives db \n\n";
			 //get data from transaction table
			 $sql = "select id,userid,order_id,tx,payment_mode,payment_mode,status,created_on,data from transaction";
			 $result = $this->db->query($sql)->result();
			 $count = count($result);
			 if($count > 0){
				 $transaction = array();
				 for($i=0;$i<$count;$i++){
					 $transaction[] = array("tx_id"=>$result[$i]->id,
										"user_id"=>$result[$i]->userid,
										 "order_id"=>$result[$i]->order_id,
										 "payment_mode"=>$result[$i]->payment_mode,
										 "tx"=>$result[$i]->tx,
										 "payment_response"=>$result[$i]->data,
										 "payment_date"=>$result[$i]->created_on);
	 				echo "transaction table data column migration to archives db transaction table tx=".$result[$i]->tx."\n";
					$this->logaction->log("system","transaction table data column migration to archives db transaction table tx=".$result[$i]->tx);
				 }
				 if(!empty($transaction))
					 $archivesDb->insert_batch('transaction', $transaction);
				echo "Completed transaction data migration to archives db";
			 }	
		}
		else {
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}


	//Get Appji Paid and order updated Donation but Missed update in donationlinks table
	public function appjiPaidAndOrderUpdatedDonationsButMissedUpdateInDonationlinksTable()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->db->select("o.id as order_id, o.order_number, o.date as order_date, o.user_id, o.username, o.transaction_id, CONCAT(o.firstname, ' ', o.lastname) as user_full_name, o.email as user_email, o.phone as user_phone, o.isd_code as country_isd_code, o.address1 as address_line_1, o.address2 as address_line_2, o.address3 as address_line_3, o.city, o.state, o.country_name as country, o.country as country_code,o.zipcode as zip, oi.id as order_item_id, adl.linkToken as donation_link_token");
	        $this->db->from("appji_donations_links as adl");
	        $this->db->join("order_items as oi",'oi.link_token=adl.linkToken');
	        $this->db->join("orders as o",'o.id=oi.order_id');
	        $this->db->where("o.payment_status", '1');
	        $this->db->where("o.is_appji_order", '1');
	        $this->db->where("adl.is_updated_in_appji", '0');
			$records = $this->db->get()->result();
			if(!empty($records))
			{
				foreach($records as $thisrecord)
				{
					if(isset($thisrecord->order_id) && $thisrecord->order_id>0)
					{
						$this->load->model("orders/orders_model");
						$this->orders_model->updateAppjiLinkTokens($thisrecord->order_id);
						echo "Updated donation link token: ".$thisrecord->donation_link_token." updated with paid details\n";
						$this->logaction->log("system","Updated donation link token: ".$thisrecord->donation_link_token." updated with paid details\n");
					}
				}
			}
			
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	//Update 2022-2023 80g text to null for all usd orders
	public function update2022202380GToNullAllRespectiveOrders()
	{
		exit;
		$ashram_ids = [4,5,7,8,10,13,15,16];
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			echo "Update orders started \n\n";
			$this->db->select("o.id");
	        $this->db->from("orders as o");
	        $this->db->where_in('o.ashram_id',$ashram_ids);
	        $this->db->where("date(o.date)>=", "2022-04-01");
	        $this->db->where("currency", "usd");
	        $orders = $this->db->get()->result();
			foreach ($orders as $order)
			{
				$this->db->where("id",$order->id);
				$this->db->update("orders",array("tax_80g_501c3"=> ""));
				echo "Updated empty 80g for the order orderid=".$order->id."\n";
				$this->logaction->log("system","Updated empty 80g for the order orderid=".$order->id);
			}
			echo "Update orders ends \n\n\n\n\n\n";
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	// Create transactions and Orders for the Razorpay Captured but not created Order
	public function createTransactionsAndOrdersForTheRazorpayCapturedButNotCreatedOrder()
	{
		if(is_cli())
		{
			echo "Started \n\n";
			ini_set('max_execution_time', 0);
			$archivesDb = $this->load->database("data_archives",true,false);
	        $archivesDb->select('*');
	        $archivesDb->from("razorpay_webhook_2022");
	        $archivesDb->where("date(created_on)>=", "2022-11-23");
	        // $archivesDb->where("transaction_id", "pay_KnsWjWZ5Is2e4b");
	        $archivesDb->where('status','captured');
	        $archivesDb->group_start();
	        $archivesDb->or_where('capture_flag',0);
	        $archivesDb->or_where('order_id',0);
	        $archivesDb->group_end();
	        $archivesDb->group_by('transaction_id');
	        $razorpayWebhookres = $archivesDb->get()->result_array();
	        // echo '<pre>'; print_r($razorpayWebhookres); die();
	        $transactionsNotCreated = [];
	        if(!empty($razorpayWebhookres))
	        {
	        	$this->load->model("payment_model");
	        	foreach ($razorpayWebhookres as $key => $value) 
	            {
	            	$this->db->select("id");
					$this->db->from("transaction");
					$this->db->where("tx",$value["transaction_id"]);
					$this->db->where("date(created_on)>=", "2022-11-23");
					$q=$this->db->get();
					if($q->num_rows() == 0)
					{
						$transactionsNotCreated[]=$value["transaction_id"];
						// echo $value["transaction_id"]." \n\n";
					}
	            }
	        }
	        if(!empty($razorpayWebhookres))
	        {
	        	$this->load->model("temp_payments_model");
	        	$this->load->model('ashrams/ashrams_trust_accounts_model');
	        	$this->load->model("payment_model");
	        	$this->load->model("razorpay_webhook_model");
	        	$this->load->model('razorpay_subscriptions_model');
	        	$this->load->model('orders/order_log_model');
				$this->load->model('orders/orders_model');
				//Model Added by Baji To save subscription ids
				$this->load->model('orders/subscription_payments_model');
				$this->load->model("subscriptions/donors_model");
				//Done by Baji's newly Added models
				$this->load->model('orders/transaction_model');
				$this->load->model('Razorpay_customers_model','razorpaycustomers');
				$this->load->model('Razorpay_subscriptions_model','razorpaysubscriptions');
	        	foreach ($razorpayWebhookres as $key => $value) 
	            {
	                if(!empty($value["data"]) && in_array($value["transaction_id"], $transactionsNotCreated))
	                {
	                    $hookData = json_decode($value["data"]);
	                    $payment_entity = $hookData->payload->payment->entity;

	                    if(!empty($payment_entity->notes->reference))
	                        $hook_data_reference = $payment_entity->notes->reference;
	                    else
	                        $hook_data_reference = "";

	                    $temp_order = $this->temp_payments_model->getOrderDataTempRazorpay($hook_data_reference);
	                    // echo '<pre>'; print_r($temp_order); die();
	                    if(!empty($temp_order))
	                    {
	                        $payment_id = $value["transaction_id"];
	                        $tempInfo=json_decode($temp_order["temp_payment_info"]);
	                        $customData=unserialize($tempInfo->data);

	                        //Get trust data
	                        $trusts=$this->ashrams_trust_accounts_model->getTrustsByAshramId($temp_order['ashram_id'],$temp_order['order_type']);
	                        $trustsArray=array();
	                        foreach ($trusts as $trustData)
	                        {
	                            $trustsArray[$trustData->currency]=$trustData;
	                        }
	                        $trustData=$trustsArray[$tempInfo->currency];
	                        //Get trust data

	                        $api = new Api($trustData->razorpay_key, $trustData->razorpay_secret);
	                        try
	                        {
	                            $payment = $api->payment->fetch($payment_id);
	                            $application_transactionData = $this->payment_model->getTransaction($payment_id);
	                            // echo '<pre>'; print_r($payment); die();
	                            if($payment["status"] == "captured")
	                            {
	                                if(!empty($application_transactionData) && !empty($application_transactionData->order_id) && $application_transactionData->order_id != 0)
	                                {
	                                    continue;
	                                }
	                                else
	                                {
	                                    $this->razorpay_webhook_model->makeOrderForCapturedButTransactionNotCreated($payment_id,$payment,$customData,$temp_order,$tempInfo,$hook_data_reference,"captured");
	                                    echo "Order created for the missed Transaction Tx: - ".$value["transaction_id"]." \n";
	                                }
	                            }
	                        }
	                        catch(Exception $e)
	                        {
	                            exit;
	                        }
	                    }
	                    else{
	                    	echo "Order can not created as we dont have temp transaction for the missed Transaction Tx: - ".$value["transaction_id"]." \n";
	                    }
	                }
	            }
	        }
			echo "Ends \n\n\n\n\n\n";
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}


	// Check transactions are captured by Razorpay but not captured Transactions and Order
	public function checkTransactionsAreCapturedByRazorpayButNotCapturedTransactionsAndOrder($from_date="", $to_date="")
	{
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			
			if($from_date=="")
			{
				echo "From date is required \n\n";
				exit;
			}
			if(!preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$from_date))
			{
				echo "From date format should be YYYY-MM-DD format \n\n";
				exit;
			}
			if($to_date=="")
			{
				echo "To date is required \n\n";
				exit;
			}
			if(!preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$to_date))
			{
				echo "To date format should be YYYY-MM-DD format \n\n";
				exit;
			}
			$fromYear = date('Y', strtotime($from_date));
			$toYear = date('Y', strtotime($to_date));
			if($fromYear != $toYear)
			{
				echo "From date and To date should be with in the year \n\n";
				exit;
			}

			echo "Started checking From  ".$from_date." To ".$to_date." \n\n";
			$archivesDb = $this->load->database("data_archives",true,false);
			$checkTableName = "razorpay_webhook_".$fromYear;
			if(!$archivesDb->table_exists($checkTableName) )
	        {
	        	echo $checkTableName."is not exists \n\n";
	        	echo "Ends \n\n\n\n\n\n";
	        	exit;
	        }
	        $archivesDb->select('*');
	        $archivesDb->from("razorpay_webhook_".$fromYear);
	        $archivesDb->where("date(created_on)>=", $from_date);
	        $archivesDb->where("date(created_on)<=", $to_date);
	        $archivesDb->where('status','captured');
	        $archivesDb->group_start();
	        $archivesDb->or_where('capture_flag',0);
	        $archivesDb->or_where('order_id',0);
	        $archivesDb->group_end();
	        $archivesDb->group_by('transaction_id');
	        $archivesDb->order_by('created_on', 'ASC');
	        $razorpayWebhookres = $archivesDb->get()->result_array();
	        // echo '<pre>'; print_r($razorpayWebhookres); die();
	        $transactionsNotCreated = [];
	        if(!empty($razorpayWebhookres))
	        {
	        	$this->load->model("payment_model");
	        	foreach ($razorpayWebhookres as $key => $value) 
	            {
	            	$this->db->select("id");
					$this->db->from("transaction");
					$this->db->where("tx",$value["transaction_id"]);
					$this->db->where("YEAR(created_on)", $fromYear);
					$q=$this->db->get();
					if($q->num_rows() == 0)
					{
						$transactionsNotCreated[]=$value["transaction_id"];
						echo $value["transaction_id"].", ".$value["created_on"]." \n";
					}
	            }
	        }
	        if(empty($transactionsNotCreated))
	        {
	        	echo "\n\n There is no missed transactions in the given date range \n";
	        }
	        echo "\n\n Ends checking From  ".$from_date." To ".$to_date." \n\n\n\n\n\n";
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	// Downolad donation declaration by ashram id, currency and month year
	public function downoladDonationDeclarationByAshramidCurrencyMonthYear($ashram_id="", $currency="", $month="", $year="")
	{
		// if(is_cli())
		// {
			ini_set('max_execution_time', 0);
			if($ashram_id=="")
			{
				echo "Ashram Id is required \n\n";
				exit;
			}
			if($currency=="")
			{
				echo "Currency is required \n\n";
				exit;
			}
			if($month=="")
			{
				echo "Month is required \n\n";
				exit;
			}
			if($month>12 || $month<=0)
			{
				echo "Enter valid Month \n\n";
				exit;
			}
			if($year=="")
			{
				echo "Year is required \n\n";
				exit;
			}
			$_GET["ashram_id"] = $ashram_id;
			$_GET["from_date"] = $year.'-'.$month.'-01';
			$_GET["to_date"] = $year.'-'.$month.'-31';
			$_GET["currency"] = $currency;
			$this->load->model("orders/orders_model");
			$this->load->model('orders/transaction_model');
			$declarations=$this->transaction_model->getDonationDeclarations();
			// echo '<pre>'; print_r($declarations); die();
			if(empty($declarations) || count($declarations) == 0)
			{
				echo "No Declarations found \n\n";
				exit;
			}
			$views = array( 'orders/admin/print_declarations');
			$data = array("views"=>$views,'declarations'=>$declarations);
			$this->load->view(FRONTEND_TEMPLATE,$data);
			
		// }
		// else
		// {
	    // 	$data['views'] = array('common/public/error');
		// 	$this->load->view(FRONTEND_TEMPLATE,$data);
		// }
	}

	// Downolad donation declaration by ashram id, currency and date
	public function downoladDonationDeclarationByAshramidCurrencyDate($ashram_id="", $currency="", $for_date="")
	{
		// if(is_cli())
		// {
			ini_set('max_execution_time', 0);
			if($ashram_id=="")
			{
				echo "Ashram Id is required \n\n";
				exit;
			}
			if($currency=="")
			{
				echo "Currency is required \n\n";
				exit;
			}
			if($for_date=="")
			{
				echo "From date is required \n\n";
				exit;
			}
			if(!preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$for_date))
			{
				echo "From date format should be YYYY-MM-DD format \n\n";
				exit;
			}
			$_GET["ashram_id"] = $ashram_id;
			$_GET["from_date"] = $for_date;
			$_GET["to_date"] = $for_date;
			$_GET["currency"] = $currency;
			$this->load->model("orders/orders_model");
			$this->load->model('orders/transaction_model');
			$declarations=$this->transaction_model->getDonationDeclarations();
			// echo '<pre>'; print_r($declarations); die();
			if(empty($declarations) || count($declarations) == 0)
			{
				echo "No Declarations found \n\n";
				exit;
			}
			$views = array( 'orders/admin/print_declarations');
			$data = array("views"=>$views,'declarations'=>$declarations);
			$this->load->view(FRONTEND_TEMPLATE,$data);
			
		// }
		// else
		// {
	    // 	$data['views'] = array('common/public/error');
		// 	$this->load->view(FRONTEND_TEMPLATE,$data);
		// }
	}

	// Cancel all previous paypal subscriptions
	public function cancelAllPreviousPaypalSubscriptions()
	{
		exit;
		if(is_cli())
		{
			ini_set('max_execution_time', 0);
			$this->load->model("orders/orders_model");
			$this->load->model("paypal_model");
			$this->load->model("ashrams/ashrams_trust_accounts_model");
			$this->load->model('orders/payflow_logs_model');
			$this->load->model('orders/order_log_model');
			//Get paypal active subscriptions
			$this->db->select('o.id as order_id, oi.id as order_item_id, o.email, oi.item_name, oi.family_member_details, o.username');
			$this->db->from('orders as o');
			$this->db->join("order_items as oi",'o.id=oi.order_id', 'inner');
			$this->db->where('o.subscription_mixed_order', 1);
			$this->db->where_in('oi.status',array(1));
			$this->db->where('o.payment_alt_mode', 'paypal');
			$this->db->group_by('oi.id');
			$paypalActiveSubscriptionOrderItems = $this->db->get()->result();
			// echo '<pre>'; print_r($paypalActiveSubscriptionOrderItems); die();
			if(!empty($paypalActiveSubscriptionOrderItems))
			{
				foreach($paypalActiveSubscriptionOrderItems as $order_item)
				{
					$cancelStatus="ERROR";
					if(is_numeric($order_item->order_id) && $order_item->order_id && is_numeric($order_item->order_item_id) && $order_item->order_item_id)
					{
						$orderData=$this->orders_model->orderData($order_item->order_id);
						$itemData=$this->orders_model->itemData($order_item->order_item_id,$order_item->order_id);
						if(!empty($orderData['order']) && !empty($itemData))
						{
							$cancelResult=$this->orders_model->subscriptionCancel($orderData,$itemData);
							if($cancelResult==1)
							{
								$cancelStatus="Cancelled";
							}
						}
					}
					echo $order_item->order_id.",".$order_item->order_item_id.",".$order_item->username.",".$order_item->email.",".trim(preg_replace('/\s\s+/', ' ', $order_item->family_member_details)).",".$order_item->item_name.",".$cancelStatus." \n\n";
					$this->logaction->log("system",$order_item->order_id.",".$order_item->order_item_id.",".$order_item->username.",".$order_item->email.",".trim(preg_replace('/\s\s+/', ' ', $order_item->family_member_details)).",".$order_item->item_name.",".$cancelStatus);
				}
			}
			else
			{
				echo "Items not found \n\n";
			}
		}
		else
		{
	    	$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

}
?>