<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
require 'vendor/autoload.php';
use Aws\Ses\SesClient;

class newsletters_cli extends CI_Controller 
{
	var $service='websiteadmin';
	var $emailDb='';
    function __construct() 
	{
        parent::__construct();
		$this->load->model("subscriptions/newsletters_model");
		$this->load->model("subscriptions/newsletters_que_model");
		$this->load->model("email_settings_model");
		$this->load->model("email_extension_model");
		$this->load->model("user/users_model");
		$this->load->model("user/newsletters_que_model");
		$this->load->library("SES",null,"ses");

		$this->emailDb=$this->load->database("emails",true,false);
		$this->smsDb=$this->load->database("sms",true,false);
		$this->siteServicesDb = $this->load->database("site_services",true,false);
    }
    public function sendEmail($tableName,$id,$service_slug,$queue_table,$unsubscribe_link)
	{
		$this->db->where("service_slug",$service_slug);
		$settings=$this->db->get('email_settings')->row();

		$newsletterData=array();

		$this->emailDb->where("status",0);
		$this->emailDb->where("id",$id);
		$mailItem=$this->emailDb->get($queue_table)->row();

		if(empty($newsletterData) || $mailItem->newsletter_id!=$newsletterData->id)
		{
			
			if($tableName == "general_newsletters")
			{
				$this->siteServicesDb->where("id",$mailItem->newsletter_id);
				$newsletterData=$this->siteServicesDb->get($tableName)->row();
			}
			else
			{
				if($tableName == "ashram_newsletters")
					$this->db->where("is_stopped",'0');
				$this->db->where("id",$mailItem->newsletter_id);
				$newsletterData=$this->db->get($tableName)->row();
			}
			if(empty($newsletterData))
			{
				return 0;
			}
		}
		$template_data=array();
		if($tableName == "newsletters")
		{
			$mail_content=$this->load->view("common/templates/newsletter_email_template",
										array(
												"newsletterData"=>$newsletterData,
												"email_settings"=>$settings,
												"unsubscribe"=>$unsubscribe_link,
												"type"=>"General"
											),
										true
									);
		}
		else if($tableName == "satsang_newsletters")
		{
			$mail_content=$this->load->view("common/templates/newsletter_email_template",
										array(
												"newsletterData"=>$newsletterData,
												"email_settings"=>$settings,
												"unsubscribe"=>$unsubscribe_link,
												"type"=>"Satsang"
											),
										true
									);
		}
		else if($tableName == "ashram_newsletters")
		{
			$mail_content=$this->load->view("common/templates/newsletter_email_template",
										array(
												"newsletterData"=>$newsletterData,
												"email_settings"=>$settings,
												"unsubscribe"=>$unsubscribe_link."&ashram_id=".$newsletterData->ashram_id,
												"type"=>"Ashram"
											),
										true
									);
		}
		else if($tableName == "general_newsletters")
		{
			$mail_content=$this->load->view("common/templates/general_newsletter_email_template",
										array(
												"newsletterData"=>$newsletterData,
												"email_settings"=>$settings,
												"unsubscribe"=>$unsubscribe_link,
												"type"=>"General"
											),
										true
									);
		}
		else
		{
			$mail_content=$this->load->view("common/templates/newsletter_email_template",
									array(
											"newsletterData"=>$newsletterData,
											"email_settings"=>$settings,
											"unsubscribe"=>$unsubscribe_link
										),
									true
								);
		}
		
		if($mailItem->user_id>0)
		{
			$userData=$this->users_model->userData($mailItem->user_id);
			$template_data['username']=$userData->username;
			$template_data['conf_key']=$userData->conf_key;
			$template_data['email']=$userData->email;
			$template_data['name']=htmlentities($userData->firstname." ".$userData->lastname);
			$template_data['firstname']=$userData->firstname;
			$template_data['lastname']=$userData->lastname;
		}

		$this->load->library("parser");
		$mail_content=$this->parser->parse_string($mail_content,$template_data,true);

		$mailItem->mail_subject=$this->parser->parse_string($mailItem->mail_subject,$template_data,true);

		$sender = '"'.$settings->from_name.'"<'.$settings->from_email.email_domain.'>';
		$ses_bcc = "";
		$messageID='';
		$sesResult = $this->ses->SendSESMail($mailItem->id,$sender,$mailItem->mail_to,$mailItem->mail_subject,$mail_content,$ses_bcc,$queue_table);
		if($sesResult["sent_flag"] == 1111)
		{
			$this->emailDb->where("id",$mailItem->id);
			$this->emailDb->update($queue_table,
								array(
								"status"=>0,
								"sent_on"=>date("Y:m:d H:i:s"),
								"bounced"=>1
								));
			return true;
		}
		$sent = $sesResult["sent_flag"];
		$messageID = $sesResult["messageID"];
		$debug = $sesResult["debug_data"];

		$debug_success = $this->email_extension_model->newslettersdebugData($debug,$mailItem->id,$queue_table);
	
		if($debug_success)
			$debug = "";
		else
			$debug = $debug;
		
		$this->emailDb->where("id",$mailItem->id);
		$this->emailDb->update($queue_table,
							array(
							"status"=>$sent,
							"sent_on"=>date("Y:m:d H:i:s"),
							'debug'=>$debug,
							'message_id'=>$messageID
							));
	}

	public function sendSMS($tableName,$id,$service_slug,$queue_table)
	{
		$newsletterData=array();

		$this->smsDb->where("status",0);
		$this->smsDb->where("id",$id);
		$smsItem=$this->smsDb->get($queue_table)->row();

		if($tableName == "general_newsletters")
		{
			$this->siteServicesDb->where("id",$smsItem->newsletter_id);
			$newsletterData=$this->siteServicesDb->get($tableName)->row();
		}
		else
		{
			$this->db->where("id",$smsItem->newsletter_id);
			$newsletterData=$this->db->get($tableName)->row();
		}
		if(empty($newsletterData))
		{
			return 0;
		}
		if($service_slug == "newsletter_ashrams")
		{
			$this->db->where("id",$newsletterData->ashram_id);
			$ashramData=$this->db->get("ashrams")->row();
			if(empty($ashramData))
			{
				return 0;
			}
		}
		$template_data=array();
		$user_id=0;
		$country_id = "";
		if($smsItem->user_id>0)
		{
			$userData=$this->users_model->userData($smsItem->user_id);
			$user_id=$smsItem->user_id;
			$template_data['username']=$userData->username;
			$template_data['email']=$userData->email;
			$template_data['name']=htmlentities($userData->firstname." ".$userData->lastname);
			$template_data['firstname']=$userData->firstname;
			$template_data['lastname']=$userData->lastname;
			$country_id = $userData->country_id;
		}

		$this->load->library("parser");
		if($service_slug == "newsletter_ashrams")
		{
			if(isset($newsletterData->sms_message))
				$sms_content = $newsletterData->sms_message;
			else
				$sms_content=$newsletterData->content;

			$sms_content.="\n- ".$ashramData->name;
		}
		else
		{
			$sms_content=$this->parser->parse_string($sms_content,$template_data,true);
		}
		if($service_slug == "newsletter_ashrams")
		{
			$smsResponse=$this->sms->sendSMSNoTrack($smsItem->to,$sms_content,$country_id);
		}
		elseif ($tableName == "general_newsletters") 
		{
			$smsResponse=$this->sms->sendSMSWithoutUserId( 'general_newsletter_'.date('Y'), $smsItem->to, $sms_content, 1, $user_id );
		}
		else
		{
			$smsResponse=$this->sms->sendSMSNL(
											$service_slug,
											$smsItem->to,
											$sms_content,
											1,
											$user_id,
											$country_id
										);
		}
		if($smsResponse['flag']==1)
		{
			$sent=1;
			$this->logaction->log($this->service,"Users Newsletter sent to ".$smsItem->to." as SMS | ID: ".$smsItem->id);
		}
		else
		{ 
			$sent=2;
			$this->logaction->log($this->service,"Users Newsletter failed to ".$smsItem->to." as SMS | ID: ".$smsItem->id);
		}

		$updateData=array(
							"status"=>$sent,
							"sent_on"=>date("Y:m:d H:i:s")
						);
		if($smsResponse['flag']==1)
		{
			$updateData['message_id']=$smsResponse['smsid'];
		}
		else
		{
			$updateData['fail_reason']=$smsResponse['msg'];
		}

		$this->smsDb->where("id",$smsItem->id);
		$this->smsDb->update($queue_table,$updateData);
	}
}
?>