<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Myvedoktashanti extends CI_Controller 
{
	var $currentUser='';
	var $service="vedoktashanti";
	var $statusArray=array(
							1=>"Open",
							2=>"Waiting Admin",
							3=>"Waiting User",
							4=>"Closed");
	var $statusResponse=array(
								4=>array('color'=>'ruby',
										'info'=>"has been Closed"));
	var $purposeArray=array(
								1=>"Office/Billing",
								2=>"Contact",
								3=>"Abuse",
								4=>"Complaint",
								5=>"Question",
								6=>"Technical Support",
								7=>"Other"
								);
    function __construct()
    {
        parent::__construct();
		$this->load->model('vedoktashanti/vedoktashanti_model');
		$this->load->model('vedoktashanti/vedoktashanti_admin_user_replies_model');
		$this->load->model('user/users_model');
		$this->currentUser=$this->session->userdata("user_data");
		if(!$this->session->userdata('user_id'))
		{
			redirect('/vedoktashanti');
		}
    }
	public function index()
	{
		$views = array( 'vedoktashanti/user/list');
		$data = array('views'=>$views);
		$this->load->view(USER_TEMPLATE,$data);
	}

	public function capture()
    {
        $data['flag']=0;
        if($GLOBALS['site_settings']['vedoktashanti_enable']==1)
        {
            $this->load->model('vedoktashanti/vedoktashanti_model');
            if(isset($GLOBALS['site_settings']['banned_emails_vedoktashanti']) && ($GLOBALS['site_settings']['banned_emails_vedoktashanti']!=''))
            {
                $banned_emails=array_filter(explode(",",$GLOBALS['site_settings']['banned_emails_vedoktashanti']));
                if(!empty($banned_emails) && in_array($this->input->post("request_email"),$banned_emails))
                {
                    goto success;
                }
            }
            if(isset($_FILES['file1']) && $_FILES['file1']['name']!='')
            {
                if($_FILES['file1']['size']==0 || $_FILES['file1']['size']>(1*1024*1024))
                    goto end;
            }
            if(isset($_FILES['file2']) && $_FILES['file2']['name']!='')
            {
                if($_FILES['file2']['size']==0 || $_FILES['file2']['size']>(1*1024*1024))
                    goto end;
            }
            if(isset($_FILES['file3']) && $_FILES['file3']['name']!='')
            {
                if($_FILES['file3']['size']==0 || $_FILES['file3']['size']>(1*1024*1024))
                    goto end;
            }
            if(!$this->session->userdata('loggedIn'))
            {
                $this->form_validation->set_rules('request_name', 'Name', 'trim|required|min_length[3]|max_length[100]');
                $this->form_validation->set_rules('request_email', 'Email ID', 'trim|required|no_uppercase|valid_email_custom|min_length[6]|max_length[200]');
            }
            $this->form_validation->set_rules('request_phone', 'Phone', 'trim|required|min_length[8]|max_length[20]');
            $this->form_validation->set_rules('purpose', 'Purpose', 'trim|required|checkTechsupportPurpose');
            $this->form_validation->set_rules('request_msg', 'Message', 'trim|required|strip_tags|max_length[12000]');
            $this->form_validation->set_rules('country_code', 'Country', 'trim|required|countryCheck');

            if($this->form_validation->run() == FALSE)
            {
                $data['msg']="Something wrong, please refresh the page and try again.";
                $data['error_data']=validation_errors();
                echo json_encode($data);
                return;
            }
            if(!empty($this->currentUser) && $this->currentUser->admin == 1)
            {
                if($_POST["request_email"] != $this->currentUser->email)
                {
                    $this->form_validation->set_rules('request_user_id', 'Request User', 'trim|required');
                    if($_POST["request_user_name"] == "undefined")
                    {
                        $data['msg']="Something wrong, please refresh the page and try again.";
                        $data['error_data']="Please select user";
                        echo json_encode($data);
                        return;
                    }
                }
            }
            $this->vedoktashanti_model->post($_POST);
            success:
            {
                $data['flag']=1;
            }
            $this->session->set_flashdata("ticket_captured",1);
        }
        end:
        echo json_encode($data);
    }

	public function createticket()
	{
		$views = array( 'vedoktashanti/user/add_edit_vedoktashanti');
		$data = array('views'=>$views);
		$countries=$this->locations_model->getCountries();
        $data["country"]=$countries;
		$this->load->view(USER_TEMPLATE,$data);
	}

	public function listmessages($excel=0)
	{
		$list=$this->vedoktashanti_model->listMessagesAjax($this->currentUser->id,$excel);
		echo json_encode($list);
	}
	
	public function changestatus($id=0,$status=0)
	{
		$result['flag']=0;
		if(is_numeric($id) && is_numeric($status) && $id && $status)//Is ID and status are numeric value
		{
			$result['data']=array();
			$vedoktashantiData=$this->vedoktashanti_model->vedoktashantiData($id);

			if(empty($vedoktashantiData))
			{
				$this->logaction->log($this->service,"Change status - Invalid ID - ".$id);
				$result['error']='Invalid request';
				echo json_encode($result);
				return;
			}
			
			$currentStatus=$vedoktashantiData->fstatus;

			$granted=$this->checkStatus($currentStatus,$status);
			if(!$granted)
			{
				$this->logaction->log($this->service,"Change status - Invalid request - ".$vedoktashantiData->vedoktashanti_id);
				$result['error']='Invalid request';
				echo json_encode($result);
				return;
			}

			$flag=$this->vedoktashanti_model->changeStatus($id,$vedoktashantiData,$status);
			
			$result['data']=$vedoktashantiData;
			$result['flag']=1;
			$result['message']=$this->statusResponse[$status];
			echo json_encode($result);

			$this->logaction->log($this->service,"Status changed from ".$this->statusArray[$currentStatus]." -> ".$this->statusArray[$status].
				" - ".$vedoktashantiData->vedoktashanti_id);
			return;
			
		}
		else
			$this->logaction->log($this->service,"Change Status - Invalid ID - ".$id);
		
		echo json_encode($result);
	}
	private function checkStatus($currentStatus,$newStatus)
	{
		if(in_array($currentStatus,array(1,2,3))) //Close
		{
			if($newStatus==4)
			{
				return 1;
			}
		}
		return 0;
	}

	public function view($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$vedoktashantiData=$this->vedoktashanti_model->vedoktashantiData($id);
			if(empty($vedoktashantiData))
			{
				$this->logaction->log($this->service,"User View - Invalid ID - ".$id);
				redirect('myvedoktashanti');
			}
			if($vedoktashantiData->user_id!=$this->currentUser->id)
			{
				$this->logaction->log($this->service,"User View - Invalid user request - ".$id);
				$this->session->set_flashdata("vedoktashanti_error",1);
				redirect('myvedoktashanti');
			}
			$repliesData=$this->vedoktashanti_admin_user_replies_model->getReplies($id);
			$views = array( 'vedoktashanti/user/view');
			$data = array('views'=>$views,'vedoktashantiData'=>$vedoktashantiData,'id'=>$id,'repliesData'=>$repliesData);
			$this->load->view(USER_TEMPLATE,$data);
			$this->vedoktashanti_model->messageReadUser($id);
		}
		else
		{
			$this->logaction->log($this->service,"User View - Invalid ID format - ".$id);
			redirect('myvedoktashanti');
		}
	}

	public function uploadthreadattachments($id=0)
	{
		$flag=0;
		if(is_numeric($id) && $id)
		{
			$vedoktashantiData=$this->vedoktashanti_model->vedoktashantiData($id);
			if(empty($vedoktashantiData))
			{
				goto end;
			}
			if(empty($_FILES['file1']) && empty($_FILES['file2']) && empty($_FILES['file3']))
			{
				goto end;
			}
			if(isset($_FILES['file1']) && $_FILES['file1']['name']!='')
			{
				if($_FILES['file1']['size']==0 || $_FILES['file1']['size']>(1*1024*1024))
					goto end;
			}
			if(isset($_FILES['file2']) && $_FILES['file2']['name']!='')
			{
				if($_FILES['file2']['size']==0 || $_FILES['file2']['size']>(1*1024*1024))
					goto end;
			}
			if(isset($_FILES['file3']) && $_FILES['file3']['name']!='')
			{
				if($_FILES['file3']['size']==0 || $_FILES['file3']['size']>(1*1024*1024))
					goto end;
			}
			$uploaded = $this->vedoktashanti_model->uploadthreadattachments($id);
			if($uploaded == 1)
			{
				$this->session->set_flashdata("upload_success",1);
			}
			else
			{
				$this->session->set_flashdata("upload_error",1);
			}
			redirect('myvedoktashanti/view/'.$id);
			return;
		}
		end:
		if($flag==0)
		{
			$this->session->set_flashdata("upload_error",1);
			redirect('vedoktashantiadmin/view/'.$id);
		}
	}
	
	public function reply_ts($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$vedoktashantiData=$this->vedoktashanti_model->vedoktashantiData($id);
			if(empty($vedoktashantiData))
			{
				$this->logaction->log($this->service,"Tech Support Reply - Invalid ID - ".$id);
				goto end;
			}
			if($vedoktashantiData->user_id!=$this->currentUser->id || $vedoktashantiData->fstatus==4)
			{
				$this->logaction->log($this->service,"Tech Support Reply - Invalid Status - ".$id);
				goto end;
			}
			$this->form_validation->set_rules('reply', 'Reply', 'trim|max_length[10000]');
			if($this->form_validation->run() == FALSE)
			{
				goto end;
			}
			$data['date']=$this->vedoktashanti_admin_user_replies_model->captureReply($id,$_POST['reply'],$vedoktashantiData,0);
			$data['flag']=1;
		}
		end:
		echo json_encode($data);
	}
	public function attachment($id=0,$no="")
	{
		$flag=0;
		if(is_numeric($id) && $id)
		{
			$vedoktashantiData=$this->vedoktashanti_model->vedoktashantiData($id);
			if(empty($vedoktashantiData))
			{
				goto end;
			}
			if($vedoktashantiData->user_id!=$this->currentUser->id)
			{
				goto end;
			}
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
										"secretKey"=>aws_s3_secret_key,
										"useSSL"=>false,
										"endpoint"=>"s3.amazonaws.com"));
			
			$filename = $vedoktashantiData->file;
			if($no==2)
				$filename = $vedoktashantiData->file2;
			if($no==3)
				$filename = $vedoktashantiData->file3;
			$amazonUri="support/".date("Y",strtotime($vedoktashantiData->date))."/".$filename;
			header("Cache-Control: public");
	        header("Content-Disposition: attachment; filename=".$filename);
			$obj=$this->s3->getObject(aws_s3_bucket_name,$amazonUri);
			echo $obj->body;
			return;
		}
		end:
		if($flag==0)
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	public function replyattachment($id=0,$no="")
	{
		$flag=0;
		if(is_numeric($id) && $id)
		{
			$replyData=$this->vedoktashanti_admin_user_replies_model->replyData($id);
			if(empty($replyData))
			{
				goto end;
			}
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key, "secretKey"=>aws_s3_secret_key, "useSSL"=>false, "endpoint"=>"s3.amazonaws.com"));
			$filename = $replyData->file;
			if($no==2)
				$filename = $replyData->file2;
			if($no==3)
				$filename = $replyData->file3;
			$amazonUri="support_replies/".date("Y",strtotime($replyData->date))."/".$filename;
			header("Cache-Control: public");
	        header("Content-Disposition: attachment; filename=".$filename);
			$obj=$this->s3->getObject(aws_s3_bucket_name,$amazonUri);
			echo $obj->body;
			return;
		}
		end:
		if($flag==0)
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}
}
?>