<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Mytechsupport extends CI_Controller 
{
	var $currentUser='';
	var $service="techsupport";
	var $statusArray=array(
								1=>"Active",
								2=>"Waiting Admin",
								3=>"Waiting User",
								4=>"Closed");
	var $statusResponse=array(
								4=>array('color'=>'ruby',
										'info'=>"has been Closed"));
	var $purposeArray=array(
								1=>"Office/Billing",
								2=>"Contact",
								3=>"Abuse",
								4=>"Complaint",
								5=>"Question",
								6=>"Technical Support",
								7=>"Other"
								);
    function __construct()
    {
        parent::__construct();
		$this->load->model('techsupport/techsupport_model');
		$this->load->model('techsupport/techsupport_admin_user_replies_model');
		$this->load->model('user/users_model');
		$this->currentUser=$this->session->userdata("user_data");
		if(!$this->session->userdata('user_id'))
		{
			redirect('/techsupport');
		}
    }
	public function index()
	{
		$views = array( 'techsupport/user/list');
		$data = array('views'=>$views);
		$this->load->view(USER_TEMPLATE,$data);
	}

	public function createticket()
	{
		$views = array( 'techsupport/user/add_edit_techsupport');
		$data = array('views'=>$views);
		$countries=$this->locations_model->getCountries();
        $data["country"]=$countries;
		$this->load->view(USER_TEMPLATE,$data);
	}

	public function listmessages($excel=0)
	{
		$list=$this->techsupport_model->listMessagesAjax($this->currentUser->id,$excel);
		echo json_encode($list);
	}

	public function checkout_close($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$techsupportData=$this->techsupport_model->techsupportData($id);
			if(empty($techsupportData))
			{
				$this->logaction->log($this->service,"Admin Checkout - Invalid ID - ".$id);
				redirect('mytechsupport');
			}
			
			$this->techsupport_model->checkOut($id);
			ob_start();
			$this->changestatus($id,4);
			$v=ob_get_clean();
			redirect('mytechsupport');
		}
		else
		{
			$this->logaction->log($this->service,"Admin View - Invalid ID format - ".$id);
			redirect('mytechsupport');
		}
	}
	
	public function changestatus($id=0,$status=0)
	{
		$result['flag']=0;
		if(is_numeric($id) && is_numeric($status) && $id && $status)//Is ID and status are numeric value
		{
			$result['data']=array();
			$techsupportData=$this->techsupport_model->techsupportData($id);

			if(empty($techsupportData))
			{
				$this->logaction->log($this->service,"Change status - Invalid ID - ".$id);
				$result['error']='Invalid request';
				echo json_encode($result);
				return;
			}
			
			$currentStatus=$techsupportData->fstatus;

			$granted=$this->checkStatus($currentStatus,$status);
			if(!$granted)
			{
				$this->logaction->log($this->service,"Change status - Invalid request - ".$techsupportData->techsupport_id);
				$result['error']='Invalid request';
				echo json_encode($result);
				return;
			}

			$flag=$this->techsupport_model->changeStatus($id,$techsupportData,$status);
			
			$result['data']=$techsupportData;
			$result['flag']=1;
			$result['message']=$this->statusResponse[$status];
			echo json_encode($result);

			$this->logaction->log($this->service,"Status changed from ".$this->statusArray[$currentStatus]." -> ".$this->statusArray[$status].
				" - ".$techsupportData->techsupport_id);
			return;
			
		}
		else
			$this->logaction->log($this->service,"Change Status - Invalid ID - ".$id);
		
		echo json_encode($result);
	}
	private function checkStatus($currentStatus,$newStatus)
	{
		if(in_array($currentStatus,array(1,2,3))) //Close
		{
			if($newStatus==4)
			{
				return 1;
			}
		}
		return 0;
	}

	public function view($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$techsupportData=$this->techsupport_model->techsupportData($id);
			if(empty($techsupportData))
			{
				$this->logaction->log($this->service,"User View - Invalid ID - ".$id);
				redirect('mytechsupport');
			}
			if($techsupportData->user_id!=$this->currentUser->id)
			{
				$this->logaction->log($this->service,"User View - Invalid user request - ".$id);
				$this->session->set_flashdata("techsupport_error",1);
				redirect('mytechsupport');
			}
			$repliesData=$this->techsupport_admin_user_replies_model->getReplies($id);
			$views = array( 'techsupport/user/view');
			$data = array('views'=>$views,'techsupportData'=>$techsupportData,'id'=>$id,'repliesData'=>$repliesData);
			$this->load->view(USER_TEMPLATE,$data);
			$this->techsupport_model->messageReadUser($id);
		}
		else
		{
			$this->logaction->log($this->service,"User View - Invalid ID format - ".$id);
			redirect('mytechsupport');
		}
	}

	public function uploadthreadattachments($id=0)
	{
		$flag=0;
		if(is_numeric($id) && $id)
		{
			$techsupportData=$this->techsupport_model->techsupportData($id);
			if(empty($techsupportData))
			{
				goto end;
			}
			if(empty($_FILES['file1']) && empty($_FILES['file2']) && empty($_FILES['file3']))
			{
				goto end;
			}
			if(isset($_FILES['file1']) && $_FILES['file1']['name']!='')
			{
				if($_FILES['file1']['size']==0 || $_FILES['file1']['size']>(1*1024*1024))
					goto end;
			}
			if(isset($_FILES['file2']) && $_FILES['file2']['name']!='')
			{
				if($_FILES['file2']['size']==0 || $_FILES['file2']['size']>(1*1024*1024))
					goto end;
			}
			if(isset($_FILES['file3']) && $_FILES['file3']['name']!='')
			{
				if($_FILES['file3']['size']==0 || $_FILES['file3']['size']>(1*1024*1024))
					goto end;
			}
			$uploaded = $this->techsupport_model->uploadthreadattachments($id);
			if($uploaded == 1)
			{
				$this->session->set_flashdata("upload_success",1);
			}
			else
			{
				$this->session->set_flashdata("upload_error",1);
			}
			redirect('mytechsupport/view/'.$id);
			return;
		}
		end:
		if($flag==0)
		{
			$this->session->set_flashdata("upload_error",1);
			redirect('techsupportadmin/view/'.$id);
		}
	}
	
	public function reply_ts($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$techsupportData=$this->techsupport_model->techsupportData($id);
			if(empty($techsupportData))
			{
				$this->logaction->log($this->service,"Tech Support Reply - Invalid ID - ".$id);
				goto end;
			}
			if($techsupportData->user_id!=$this->currentUser->id || $techsupportData->fstatus==4)
			{
				$this->logaction->log($this->service,"Tech Support Reply - Invalid Status - ".$id);
				goto end;
			}
			$this->form_validation->set_rules('reply', 'Reply', 'trim|max_length[10000]');
			if($this->form_validation->run() == FALSE)
			{
				goto end;
			}
			$data['date']=$this->techsupport_admin_user_replies_model->captureReply($id,$_POST['reply'],$techsupportData,0);
			$data['flag']=1;
		}
		end:
		echo json_encode($data);
	}
	public function attachment($id=0,$no="")
	{
		$flag=0;
		if(is_numeric($id) && $id)
		{
			$techsupportData=$this->techsupport_model->techsupportData($id);
			if(empty($techsupportData))
			{
				goto end;
			}
			if($techsupportData->user_id!=$this->currentUser->id)
			{
				goto end;
			}
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
										"secretKey"=>aws_s3_secret_key,
										"useSSL"=>false,
										"endpoint"=>"s3.amazonaws.com"));
			
			$filename = $techsupportData->file;
			if($no==2)
				$filename = $techsupportData->file2;
			if($no==3)
				$filename = $techsupportData->file3;
			$amazonUri="support/".date("Y",strtotime($techsupportData->date))."/".$filename;
			header("Cache-Control: public");
	        header("Content-Disposition: attachment; filename=".$filename);
			$obj=$this->s3->getObject(aws_s3_bucket_name,$amazonUri);
			echo $obj->body;
			return;
		}
		end:
		if($flag==0)
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}

	public function replyattachment($id=0,$no="")
	{
		$flag=0;
		if(is_numeric($id) && $id)
		{
			$replyData=$this->techsupport_admin_user_replies_model->replyData($id);
			if(empty($replyData))
			{
				goto end;
			}
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key, "secretKey"=>aws_s3_secret_key, "useSSL"=>false, "endpoint"=>"s3.amazonaws.com"));
			$filename = $replyData->file;
			if($no==2)
				$filename = $replyData->file2;
			if($no==3)
				$filename = $replyData->file3;
			$amazonUri="support_replies/".date("Y",strtotime($replyData->date))."/".$filename;
			header("Cache-Control: public");
	        header("Content-Disposition: attachment; filename=".$filename);
			$obj=$this->s3->getObject(aws_s3_bucket_name,$amazonUri);
			echo $obj->body;
			return;
		}
		end:
		if($flag==0)
		{
			$data['views'] = array('common/public/error');
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
	}
}
?>