<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Myjapams extends CI_Controller 
{
	var $currentUser='';
	var $service='japams';
    function __construct()
	{
        parent::__construct();
		$this->load->model("japams/japams_model");
		$this->load->model("japams/mantra_japam_notes_model");
		$this->load->model("subscriptions/donors_model");
		$this->load->model("user/users_model");
		if($this->session->userdata('user_id'))
		{
			$this->currentUser=$this->session->userdata("user_data");
		}
		if($this->session->userdata("force_change_password")==1)
		{
			$this->session->set_flashdata("reset_password_force",1);
			redirect("myaccount/change_password");
		}
    }
    public function index()
	{
		if(!empty($_GET['date']) && date("Ymd",strtotime($_GET['date'])) == "19700101")
		{
			$dd = urlencode(date("d M Y"));
			redirect('myjapams?date='.$dd);
		}
		if(!empty($_GET['date']) && strtotime(date("Ymd",strtotime($_GET['date']))) > strtotime(date("Ymd")))	
		{	
			$dd = urlencode(date("d M Y"));	
			redirect('myjapams?date='.$dd);	
		}
		$views = array( 'japams/user/form' );
		$noteData=$this->mantra_japam_notes_model->noteData();
		if(empty($noteData))
		{
			$noteData=array();
		}
		$data = array('views'=>$views,"noteData"=>$noteData);
		$data ['family_donors'] = $this->donors_model->getUserUnhideDonors($this->currentUser->sso_user_id);
		$this->load->view(USER_TEMPLATE,$data);
		$this->logaction->log($this->service,"User - Viewed form page");
	}
	
	public function update_japam_count() 
	{
		if(!empty($_POST['sel_date']) && date("Ymd",strtotime($_POST['sel_date'])) == "19700101")
		{
			$dd = urlencode(date("d M Y"));
			redirect('myjapams?date='.$dd);
		}
		if(strtotime(date("Ymd",strtotime($_POST['sel_date']))) > strtotime(date("Ymd")))
		{
			$dd = urlencode(date("d M Y"));
			redirect('myjapams?date='.$dd);
		}
        if(isset($_POST['japamids']) && is_array($_POST['japamids']) && count($_POST['japamids']))
        {
	     	$this->japams_model->userCountSave();
			$this->session->set_flashdata("japam_updated",1);
			if(isset($_POST['sel_date']) && $_POST['sel_date']!='')
	        	redirect('myjapams?date='.urlencode($_POST['sel_date']));
	        else
	        	redirect('myjapams');
	    }
	    else
	    {
	    	$this->session->set_flashdata("japam_error",1);
	        redirect('myjapams');
	    }
    }

    public function update_japam_single_count() 
	{
        if(isset($_POST['mantra_id']))
        {
        	$donor_id = $_POST['donor_id'];
        	if(empty($_POST['donor_id']))
        	{
        		$family_donors = $this->donors_model->getUserDonors($this->currentUser->sso_user_id);
        		foreach ($family_donors as $key=>$donor_data)
                {
                	if($donor_data["donor_relation"] == "Self")
                	{
                		$donor_id = $donor_data["donor_id"];
                		break;
                	}
                }
        	}
	     	$this->japams_model->usersingleCountSave($_POST['mantra_id'],$_POST['date'],$donor_id);
			echo 1;
	    }
	    else
	    {
	    	echo 2;
	    }
    }

    public function deletejapacount($autoId=0)
    {
    	$data['flag']=0;
		if(is_numeric($autoId) && $autoId)
		{
			$countData = $this->japams_model->japaCountData($autoId);
			if(empty($countData))
			{
				goto end;
			}
			else
			{
				$this->session->set_flashdata("japa_count_delete",1);
				$delete = $this->japams_model->deleteJapaCount($autoId);
				$data['flag'] = 1;
			}
		}
		end:
		echo json_encode($data);
    }

    public function update_japam_family_member()
    {
    	$this->form_validation->set_rules('value', 'Donor', 'trim|min_length[1]|max_length[20]|numeric');
    	$this->form_validation->set_rules('pk', 'Primary Key', 'trim|min_length[1]|max_length[20]|numeric');
    	if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		else
		{
			$donorData = $this->donors_model->donorData($_POST['value']);
			$this->japams_model->updateDonor($_POST['pk'],$_POST['value'],$donorData);
			echo 1;
		}
    }

    public function update_japa_count()
    {
    	$this->form_validation->set_rules('value', 'Japa Count', 'trim|min_length[1]|max_length[7]|numeric');
    	$this->form_validation->set_rules('pk', 'Primary Key', 'trim|min_length[1]|max_length[20]|numeric');
    	if($this->form_validation->run() == FALSE)
		{
			echo validation_errors();
			return;
		}
		else
		{
			$this->japams_model->updateJapaCount($_POST['pk'],$_POST['value']);
			$this->session->set_flashdata("japam_count_updated",1);
			echo 1;
		}
    }

    public function report()
	{
		$views = array( 'japams/user/report' );
		$data = array('views'=>$views);
		$data['japams']= $this->japams_model->getJapams(1);
		$data ['family_donors'] = $this->donors_model->getUserDonors($this->currentUser->sso_user_id);
		$this->load->view(USER_TEMPLATE,$data);
		$this->logaction->log($this->service,"User - Viewed report page");
	}
	public function listreport($excel=0)
	{
		$list=$this->japams_model->userReport($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"User - Viewed Report ajax request");
	}


	public function mymantras() 
	{
        $data = array('views'=>array("japams/user/list"));
        $this->load->view(USER_TEMPLATE,$data);
    }
    public function listc($excel=0)
	{
		$list=$this->japams_model->listUser($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"User - Mantras listing ajax request");
		
	}
	public function add_edit_mantra($id=0)
	{
		if($id)
		{
			$mantraData=$this->japams_model->mantraData($id);
			if(empty($mantraData) || $mantraData->is_user!=1 || $mantraData->user_id!=$this->currentUser->id )
			{
				$this->session->set_flashdata("japam_error",1);
				redirect('myjapams');
			}
		}
		else
			$mantraData=array();

		if(isset($_POST["name"]))
		{
			if(isset($_FILES['mantra_image']['name']) && $_FILES['mantra_image']['name']!='')
			{
				$allowed_file_types =   array('image/jpeg','image/jpg','image/png');
				$ext=pathinfo ($_FILES['mantra_image']['name'],PATHINFO_EXTENSION);
				if($_FILES['mantra_image']['size']==0 || $ext=='' || !in_array($_FILES['mantra_image']['type'],$allowed_file_types) ||
						$_FILES['mantra_image']['size']>(1024*1024))
				{
					$this->session->set_flashdata("japam_error",1);
					redirect('myjapams/add_edit_mantra/'.$id);
				}
			}

			$this->form_validation->set_rules('name', 'Name', 'trim|required|min_length[2]|max_length[50]');
			$this->form_validation->set_rules('description', 'Description', 'trim|min_length[3]|max_length[500]');
			$this->form_validation->set_rules('mantra', 'Mantra', 'trim|required|min_length[3]|max_length[2000]');
			$this->form_validation->set_rules('start_date', 'Start Date', 'trim|valid_date');
			$this->form_validation->set_rules('end_date', 'End Date', 'trim|valid_date|checkMantraDates');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("japam_error",1);
				redirect('myjapams/add_edit_mantra/'.$id);
				return;
			}
			
			$saved=$this->japams_model->save($id,$mantraData,1);
			if($saved)
			{
				if($id)
					$this->session->set_flashdata("japam_saved",1);
				else
				{
					$this->session->set_flashdata("japam_created",1);
				}
			}
			redirect('myjapams/add_edit_mantra/'.$saved);
			
		}
		else
		{
			
		 	$views = array( 'japams/user/add_edit_mantra' );
		 	$data = array('views'=>$views,'id'=>$id);
			if($id)
			{
				$data['mantraData']=$mantraData;
			}
			$this->load->view(USER_TEMPLATE,$data);
		}
	}

	public function mantra_updateorder()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$mantraData=$this->japams_model->mantraData($this->input->post("pk"));
		if(empty($mantraData) || $mantraData->is_user!=1 || $mantraData->user_id!=$this->currentUser->id )
		{
			echo 0;
			return;
		}

		$this->japams_model->updateOrder($_POST['pk'],$_POST['value']);
		echo 1;
	}

	public function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$mantraData=$this->japams_model->mantraData($id);

			if(empty($mantraData) || $mantraData->is_user!=1 || $mantraData->user_id!=$this->currentUser->id )
			{
				goto end;
			}
			$r=$this->japams_model->delete($id,$mantraData);
			if($r)
			{
				$data['flag']=$r;
				$data['name']=$mantraData->name;
			}
		}
		end:
		echo json_encode($data);
	}

	public function changestatus($id=0,$status=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id && is_numeric($status) && in_array($status,array(0,1)))
		{
			$mantraData=$this->japams_model->mantraData($id);
			if(empty($mantraData) || $mantraData->is_user!=1 || $mantraData->user_id!=$this->currentUser->id )
			{
				goto end;
			}
			if($mantraData->status!=$status)
			{
				$r=$this->japams_model->changeStatus($id,$status);
				if($r)
				{
					$data['flag']=1;
					$data['name']=$mantraData->name;
				}
			}
		}
		end:
		echo json_encode($data);
	}

}
?>