<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Myaccount extends CI_Controller 
{
	var $currentUser='';
	var $service='users';
	var $months=array(1=>"January",2=>"February",3=>"March",4=>"April",5=>"May",6=>"June",7=>"July",8=>"August",9=>"September",10=>"October",11=>"November",12=>"December");
    function __construct()
	{
        parent::__construct();
       	
		$this->load->library("userutil");
		$this->load->model("user/users_model");
		$this->load->model("credit_cards_model");
		if($this->session->userdata('user_id'))
		{
			$this->currentUser=$this->session->userdata("user_data");
		}

		if($this->uri->segment(2)!='change_password' && $this->uri->segment(2)!='update_pass_force')
		{
			if($this->session->userdata("force_change_password")==1)
			{
				$this->session->set_flashdata("reset_password_force",1);
				redirect("myaccount/change_password");
			}
		}
		$this->load->model("subscriptions/donors_model");
    }

    public function index() 
	{
		$this->load->model("orders/subscription_payments_model");
        $this->load->view(USER_TEMPLATE);
    }
    public function editmyprofile()
	{
		$userData=$this->users_model->userData($this->currentUser->id);
		$data['user']=$userData;

        $data['wallet']= $this->userutil->getWallet($this->currentUser->id);
        $languages = $this->general_model->getLanguages();
        $countries=$this->locations_model->getCountries();

        $data['security_questions']=$this->users_model->getSecurityQuestionsGroups();

        $data['user_security_questions']=$this->users_model->getUserSecurityQuestions($this->currentUser->id);

        $data["country"]=$countries;

        $data['languages'] = $languages;
        $data['id']=$this->currentUser->id;
        $data['post_url']="/myaccount/update_profile";
		$views =array( 'users/user/editmyprofile' );
		$data['views'] = $views;
		$this->load->view(USER_TEMPLATE,$data);
    }
    public function getManageCards($userId=0)
	{
		if(is_numeric($userId) && $userId)
		{
			$this->load->model("credit_cards_model");
			$data['credit_cards']=$this->credit_cards_model->getCards($userId);
			echo $this->load->view("ashrams/public/_saved_cards_template",$data,true);
		}
	}
    public function update_profile($uid=0)
	{	
		if($this->session->userdata('id') && !$this->session->userdata('user_id'))
		{
			$adminset=1;
		}
		
        if(isset($_POST['save_profile']))
		{
			if(!isset($_POST['address']) || !isset($_POST['address1']) || !isset($_POST['address2']) || !isset($_POST['gothram']) || !isset($_POST['profession']) || !isset($_POST['star']) || !isset($_POST['raasi']) || !isset($_POST['gender']) || !isset($_POST['dob']) || !isset($_POST['phone']) || !isset($_POST['pan_number']) || !isset($_POST['country']) || !isset($_POST['state']) || !isset($_POST['city']) || !isset($_POST['zip']) || !isset($_POST['lang']))
			{
				$this->session->set_flashdata("profile_error",1);
				goto end;
			}

			$file=0;
			$userId=$this->currentUser->id;
			$this->form_validation->set_rules('user_email', 'Email ID', 'trim|required|no_uppercase|valid_email_custom|min_length[6]|max_length[200]|emailCheck['.$this->currentUser->sso_user_id.']|emailBounceCheck');
			$this->form_validation->set_rules('first_name', 'First Name', 'trim|required|min_length[2]|max_length[50]|lettersonly');
			$this->form_validation->set_rules('middlename', 'Middle Name', 'trim|max_length[50]|lettersonly');
			$this->form_validation->set_rules('last_name', 'Last Name', 'trim|required|min_length[2]|max_length[50]|lettersonly');
			$this->form_validation->set_rules('profession', 'Profession', 'trim|professionCheck');
			$this->form_validation->set_rules('star', 'Birth Star', 'trim|starCheck');
			$this->form_validation->set_rules('raasi', 'Raasi', 'trim|raasiCheck');
			$this->form_validation->set_rules('gothram', 'Gothram', 'trim|min_length[3]|max_length[50]');
			$this->form_validation->set_rules('gender', 'Gender', 'trim|genderCheck');
			$this->form_validation->set_rules('dob', 'Date of Birth', 'trim|dobCheck');
			$this->form_validation->set_rules('phone', 'Phone Number', 'trim|numeric|min_length[8]|max_length[15]|noSpaces');
			$this->form_validation->set_rules('pan_number', 'PAN Number', 'trim|min_length[10]|max_length[10]');
			$this->form_validation->set_rules('aadhaar_number', 'Aadhaar Number', 'trim|min_length[12]|max_length[12]');
			$this->form_validation->set_rules('address', 'Address Line 1', 'trim|min_length[3]|max_length[100]');
			$this->form_validation->set_rules('address1', 'Address Line 2', 'trim|min_length[3]|max_length[100]|noSpaces');
			$this->form_validation->set_rules('address2', 'Address Line 3', 'trim|min_length[3]|max_length[100]|noSpaces');
			$this->form_validation->set_rules('country', 'Country', 'trim|required|countryCheck');
			$this->form_validation->set_rules('state', 'State', 'trim|min_length[2]|max_length[100]|name_validate13');
			$this->form_validation->set_rules('city', 'City', 'trim|min_length[2]|max_length[100]|name_validate13');
			$this->form_validation->set_rules('zip', 'ZIP Code', 'trim|alphabetsnumbers|min_length[3]|max_length[15]');
			$this->form_validation->set_rules('lang', 'Language', 'trim|checkLanguage');

			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("profile_error",1);
				goto end;
			}


			if(isset($_FILES['profile_image']))
			if($_FILES['profile_image']['name']!='')
			{
				if($_FILES['profile_image']['size']==0)
				{
					$this->session->set_flashdata("profile_error",1);
					goto end;
				}
				$ext=pathinfo ($_FILES['profile_image']['name'],PATHINFO_EXTENSION);

				if($ext=='')
				{
					$this->session->set_flashdata("profile_error",1);
					goto end;	
				}
				if(!getimagesize($_FILES['profile_image']['tmp_name']))
				{
					$this->session->set_flashdata("profile_error",1);
					goto end;
				}
				$file=1;
			}
			$this->load->model('subscriptions_email_model');
			$this->users_model->updateProfile($this->currentUser->id,$_POST);
            
			$this->load->model("user/user_debit_account_model");
			if($this->session->userdata('user_id'))
			{
				$userData=$this->users_model->userData($this->currentUser->id);
				$this->session->set_userdata("user_data",$userData);
	    		$this->session->set_flashdata("profile_updated",1);	
			}
    		$this->user_debit_account_model->setAccount($this->currentUser->id);

	        end:
			if($this->session->userdata('id') && !$this->session->userdata('user_id'))
			{
				redirect('/users/add_edit_user/'.$uid."?s=1");
			}
			else
			{
            	redirect('myaccount/editmyprofile');
            }
        }
		else
			redirect('/myaccount/editmyprofile');
    }
    public function verify_email()
	{
		if(isset($_POST['email']) && trim($_POST['email'])!='')
        {
            $flag=$this->userutil->verifyEmail($_POST['email'],$this->currentUser->sso_user_id);
            if($flag==2)
            {
            	echo "boucedEmail";
            }
            else if($flag==1)
            {
                echo "false";
            }
            else
            {
                echo "true";
            }
        }
        else
            echo "false";
	}
	public function authenticate()
	{
		if(isset($_POST['pass']) && $_POST['pass']!='')
		{
			$resp=$this->users_model->verifyPassword($this->currentUser->id,$_POST['pass']);
			echo $resp;
		}
		else
		{
			echo 0;
		}
	}
	public function security_settings()
	{
		if(isset($_POST['save']))
		{
			$this->form_validation->set_rules('q1', 'Question 1', 'trim|required|numeric|checkSecurityQuestion[0]');
			$this->form_validation->set_rules('q2', 'Question 2', 'trim|required|numeric|checkSecurityQuestion[1]');
			$this->form_validation->set_rules('ans1', 'Answer 1', 'trim|required|max_length[100]');
			$this->form_validation->set_rules('ans2', 'Answer 2', 'trim|required|max_length[100]');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("profile_error",1);
				echo 0;
				return;
			}

			$resp=$this->users_model->updateSecurityQuestions($this->currentUser->id,$_POST);

			if($resp==1)
			{
				if($this->session->userdata('user_id'))
				{
					$userData=$this->users_model->userData($this->currentUser->id);
					$this->session->set_userdata("user_data",$userData);
				}
        		echo 1;
			}
			else
				echo 2;

		}
		else
			echo 0;
	}
	public function update_pass() 
	{
		$this->form_validation->set_rules('current_password', 'Current Password', 'trim|required|min_length[8]|max_length[50]');
		$this->form_validation->set_rules('new_password', 'New Password', 'trim|required|min_length[8]|max_length[50]');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		
		if(trim($_POST['new_password'])==trim($_POST['current_password']))
		{
			echo 3;
			exit(0);
		}
		$resp=$this->users_model->updatePassword($this->currentUser->id,$_POST['current_password'],$_POST['new_password']);
		echo $resp;
	}


	public function change_password()
	{
		if($this->session->userdata("force_change_password")==1)
		{
			$views =array( 'users/user/change_password');
			$data['views'] = $views;
			$this->load->view(USER_TEMPLATE,$data);
		}
		else
		{
			$views =array( 'common/public/error');
			$data['views'] = $views;
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
    }

    public function update_pass_force()
	{
		$this->form_validation->set_rules('new_password', 'New Password', 'trim|required|min_length[8]|max_length[50]');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$resp=$this->users_model->updatePasswordForced($this->currentUser->id,$_POST['new_password']);
		$this->session->unset_userdata("force_change_password");
		echo $resp;
	}

	public function getchats()
	{
		$this->load->model('chatbox_model');
		$res=$this->chatbox_model->getChatsByUser();
		$res['current_user']=$this->currentUser->id;
		echo json_encode($res);
	}
	public function postchat()
	{
		$this->load->model('chatbox_model');
		$total=$this->chatbox_model->getTotalChatsToday($this->currentUser->id);
		if($total==5)
		{
			echo json_encode(array("flag"=>2,"count"=>0));
			return;
		}
		$this->chatbox_model->postChat($this->currentUser->id);
		$res=$this->chatbox_model->getChatsByUser();
		$res['current_user']=$this->currentUser->id;
		echo json_encode($res);
	}
	public function markSpam($mid=0)
	{
		$this->load->model('chatbox_model');
		$res=$this->chatbox_model->markSpam($mid,$this->currentUser->id);
		echo json_encode($res);
	}
	public function deletemessage($mid=0)
	{
		$this->load->model('chatbox_model');
		$res=$this->chatbox_model->deleteMessage($mid,$this->currentUser->id);
		echo json_encode($res);
	}
	public function getCreditCards($userId=0)
	{
		if(is_numeric($userId) && $userId)
		{
			$this->load->model("credit_cards_model");
			$data['credit_cards']=$this->credit_cards_model->getCards($userId);
			echo $this->load->view("ashrams/public/_dynamic_cards",$data,true);
		}
	}
	public function deletecard($id)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$creditCard=$this->credit_cards_model->getCard($id);
			if(empty($creditCard))
			{
				goto end;
			}
			if($creditCard->user_id!=$this->currentUser->id)
			{
				goto end;
			}
			$this->credit_cards_model->delete($id);
			$userData = $this->users_model->userData($creditCard->user_id);
	        $data['userData']=$userData;
	        $data['card_number']=$creditCard->card_number;
	        $body=$this->load->view("orders/public/_email_saved_card_delete",$data,true);
	        $subject='Card Delete Notification';
	        $this->email_extension->sendOrdersMail(
	                                        "card_notifications",
	                                        $userData->id,
	                                        $userData->firstname." ".$userData->lastname,
	                                        $userData->email,
	                                        $subject,
	                                        $body,
	                                        '',
	                                        1);
			$data['card_number']=$creditCard->card_number;
			$data['credit_cards']=$this->credit_cards_model->getCards($creditCard->user_id);
			$data['template']=$this->load->view("ashrams/public/_saved_cards_template",$data,true);
			$data['flag']=1;
		}
		end:
		echo json_encode($data);
	}

	public function donors_list($id="")
	{
		$data['flag']=0;
		if(empty($this->currentUser->id) && empty($this->currentUser))
		{
			$udata = $this->users_model->userData($id);
			$currentUserDa = new stdClass();
			$currentUserDa = $udata;
		}
		else
		{
			$currentUserDa = $this->currentUser;
		}
		$result=$this->donors_model->getMyDonors($currentUserDa,0);
		echo json_encode($result);
	}
	public function donor_form($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$donorData=$this->donors_model->donorData($id);
			if(empty($donorData))
			{
				$id=0;
			}
			else
			{
				$data['countryData']=$this->locations_model->getCountryByCode($donorData->donor_country_id);
			}
		}
		else
		{
			$donorData=array();
		}
		$data['id']=$id;
		$data['from_checkout']=0;
		$data['donorData']=$donorData;
		$data['user']=$this->currentUser;
		echo $this->load->view("users/user/_donor_modal",$data,true);
	}
	public function edit_donor($id=0)
	{
		$result['flag']=0;
		if(is_numeric($id) && $id)
		{
			$donorData=$this->donors_model->donorData($id);
			if(empty($donorData))
			{
				$result['msg']="Invalid donor";
				goto end;
			}
			$selfDonorData=$this->donors_model->getUserSelfDonors($this->currentUser->sso_user_id);

			if(!empty($selfDonorData) && $selfDonorData == 1 && $_POST['donor_relation'] == "Self" && $donorData->id != $id)
			{
				$result['msg']="Self donor cannot be created again..!";
				goto end;
			}
		}
		else
		{
			$selfDonorData=$this->donors_model->getUserSelfDonors($this->currentUser->sso_user_id);

			if(!empty($selfDonorData) && $selfDonorData == 1 && $_POST['donor_relation'] == "Self")
			{
				$result['msg']="Self donor cannot be created again..!";
				goto end;
			}
			$donorData=array();
		}
		if(!isset($_POST['donor_dob_day']) || !isset($_POST['donor_dob_month']) || !isset($_POST['donor_email']) ||
			!isset($_POST['donor_star']) || !isset($_POST['donor_raasi']) || !isset($_POST['donor_profession']) ||
			!isset($_POST['donor_address']))
		{
			$result['msg']="Invalid request";
			goto end;
		}

		$this->form_validation->set_rules('donor_relation', 'Relation', 'trim|required');
		$this->form_validation->set_rules('donor_name', 'Name', 'trim|required|min_length[3]|max_length[200]');
		$this->form_validation->set_rules('donor_email', 'Email ID', 'trim|no_uppercase|valid_email_custom|min_length[6]|max_length[200]');
		$this->form_validation->set_rules('donor_phone', 'Phone', 'trim|required|numeric|min_length[8]|max_length[20]');
		$this->form_validation->set_rules('donor_country_code', 'Country code', 'trim|required|countryCheck');
		$this->form_validation->set_rules('donor_profession', 'Profession', 'trim|professionCheck');
		$this->form_validation->set_rules('donor_star', 'Birth Star', 'trim|starCheck');
		$this->form_validation->set_rules('donor_raasi', 'Raasi', 'trim|raasiCheck');
		$this->form_validation->set_rules('donor_dob_day', 'DOB Day', 'trim|dayCheck');
		$this->form_validation->set_rules('donor_dob_month', 'DOB Month', 'trim|monthCheck');
		$this->form_validation->set_rules('donor_address', 'Address Line 1', 'trim|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('donor_address1', 'Address Line 2', 'trim|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('donor_address2', 'Address Line 3', 'trim|min_length[3]|max_length[100]');
		$this->form_validation->set_rules('donor_address_country_id', 'Country', 'trim|required|countryCheck');
		$this->form_validation->set_rules('donor_state', 'State', 'trim|min_length[2]|max_length[100]|name_validate13');
		$this->form_validation->set_rules('donor_city', 'City', 'trim|min_length[2]|max_length[100]|name_validate13');
		$this->form_validation->set_rules('donor_zipcode', 'ZIP Code', 'trim|alphabetsnumbers|min_length[3]|max_length[15]');

		if($this->form_validation->run() == FALSE)
		{
			$result['msg']="Invalid request";
			goto end;
		}

		if(isset($_FILES['donor_profile_image']))
			if($_FILES['donor_profile_image']['name']!='')
			{
				if($_FILES['donor_profile_image']['size']==0)
				{
					$result['msg']="Invalid photo";
					goto end;
				}
				$ext=pathinfo ($_FILES['donor_profile_image']['name'],PATHINFO_EXTENSION);

				if($ext=='')
				{
					$result['msg']="Invalid photo type";
					goto end;	
				}
				if(!getimagesize($_FILES['donor_profile_image']['tmp_name']))
				{
					$result['msg']="Invalid photo";
					goto end;
				}
				$file=1;
			}

		$saved=$this->donors_model->save($id,$donorData,$this->currentUser);
		if($saved)
		{
			$result['flag']=1;
		}
		else
		{
			$result['flag']=2;
		}


		end:
		echo json_encode($result);
	}

	public function donor_delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$donorData=$this->donors_model->donorData($id);
			if(empty($donorData))
			{
				goto end;
			}
			if($this->session->userdata('id'))
			{
				$this->currentUser=$this->session->userdata("admin_data");
			} else {
				if($this->currentUser->sso_user_id!=$donorData->user_id)
				{
					goto end;
				}
			}
			if($donorData->donor_relation == "Self")
			{
				$data['flag']=3;
				$data['name']=$donorData->donor_name;
				goto end;
			}
			$this->load->model("orders/orders_model");
			$count=$this->orders_model->orderItemsCountByDonorId($id);
			if($count>0)
			{
				$data['flag']=2;
				$data['name']=$donorData->donor_name;
				goto end;
			}

			$r=$this->donors_model->delete($id,$donorData,$this->currentUser);
			if($r)
			{
				$data['flag']=1;
				$data['name']=$donorData->donor_name;
				$this->logaction->log($this->service,"MyAccount - Donor '".$donorData->donor_name."' deleted - ".$id);
			}
		}
		end:
		echo json_encode($data);
	}

	public function hideUnhideDonor($id=0,$status=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$userData=$this->users_model->userData($id);
			$donorData=$this->donors_model->donorData($id);
			if(empty($donorData))
			{
				goto end;
			}
			$this->donors_model->updateHideUnhideDonorStatus($id, $status);
			$data['flag']=1;
			$data['donor_name']=$donorData->donor_name;
		}
		end:
		echo json_encode($data);
	}

	public function deleteAllMySavedCards()
	{
		$data['flag']=0;
		$userData = $this->users_model->userData($this->currentUser->id);
		if(empty($userData))
		{
			$data['flag']=2;
			goto end;
		}
		$userCreditCards=$this->credit_cards_model->getCards($this->currentUser->id);

		if(!empty($userCreditCards))
		{
			foreach($userCreditCards as $thisCard)
			{
				$this->credit_cards_model->delete($thisCard->id);
			}
			$data['flag']=1;
		}
		else
		{
			$data['flag']=3;
		}
		end:
		echo json_encode($data);
	}
}
?>