<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Login extends CI_Controller 
{
	var $logtrack='';
	var $bagent='';
	var $service='users';
	var $currentUser='';
    function __construct() 
	{
        parent::__construct();
        if($this->session->userdata('loggedIn'))
		{
			if($this->session->userdata('id'))
				$this->currentUser=$this->session->userdata('admin_data');
			else
				$this->currentUser=$this->session->userdata('user_data');
		}
		if($this->uri->segment("2")!="logout" && $this->uri->segment("2")!="activate" && $this->uri->segment("2")!="google_login" &&
            $this->uri->segment("2")!="facebook_login" && $this->uri->segment("2")!="microsoft_login" && $this->uri->segment("2")!="unsubscribe"
            && $this->uri->segment("2")!="app_web_login")
		{
			if($this->session->userdata('loggedIn'))
			{
                if($this->input->get("redirect")!='')
                {
                    redirect($this->input->get("redirect"));
                    exit;
                }
				if($this->session->userdata('id')) //admin
				{
					if(isset($_SESSION['HTTP_REFERER']) && $_SESSION['HTTP_REFERER']!='')
					   redirect($_SESSION['HTTP_REFERER']);
					else
					   redirect("admin");
				}
				else //user
				{
					if(isset($_SESSION['HTTP_REFERER']) && $_SESSION['HTTP_REFERER']!='')
					   redirect($_SESSION['HTTP_REFERER']);
					else
					   redirect("myaccount");
				}
			}
		}

		if ($this->agent->is_browser())
		{
			$this->bagent = $this->agent->browser().' '.$this->agent->version();
		}
		elseif ($this->agent->is_robot())
		{
			$this->bagent= $this->agent->robot();
		}
		elseif ($this->agent->is_mobile())
		{
			$this->bagent= $this->agent->mobile();
		}
		else
		{
			$this->bagent= 'Unidentified User Agent';
		}
		
        $this->load->model("user/users_model");
		$this->load->model('subscriptions_email_model');
		$this->logtrack=$this->load->database("site_services",true);
    }

	public function index() 
	{
		if(isset($_POST["username"]) || $this->input->get("app_web_token")!='')
		{
            $this->load->model('login_validate','login');
            if($this->input->get("app_web_token")!='')
            {
                $this->load->model("app_web_tokens_model");
                $userId=$this->app_web_tokens_model->authenticate($this->input->get("app_web_token"));
                if($userId)
                {
                    $flag=$this->login->validate($_POST,$userId);
                }
                else
                {
                    redirect("login");
                }
            }
            else
            {
    			if(!isset($_POST["pwd"]) || !isset($_POST["username"]))
    			{
    				redirect('login');
    			}

    			$this->form_validation->set_rules('pwd', 'Password', 'trim|required');
    			$this->form_validation->set_rules('username', 'User ID','trim|required');

    			if($this->form_validation->run() == FALSE)
    			{
    				redirect('login');
    			}
                $flag=$this->login->validate($_POST);
            }
			
			if($flag==1 || $flag==2)
			{
				
                if(!$this->input->get("app_web_token"))
                {
    				if(isset($_POST['remember']))
    				{
    					
    					$cookie =array(
    						'name'   => 'username',
    						'value'  => $_POST['username'],
    						'expire' => '1209600'
    					);
    					$this->input->set_cookie($cookie);
    					 $cookie =array(
    						'name'   => 'pass',
    						'value'  => $_POST['pwd'],
    						'expire' => '1209600'
    					);
    					$this->input->set_cookie($cookie);
    					 $cookie =array(
    						'name'   => 'rememberme',
    						'value'  =>1,
    						'expire' => '1209600'
    					);
    					$this->input->set_cookie($cookie);
    					
    				}
    				else
    				{
    					delete_cookie('username');						
    					delete_cookie('pass');
    					delete_cookie('rememberme');
    				}

    				/*if($flag==2)
    				{
    				  	redirect('/login/pin'); 
    				}*/

    				if($this->session->userdata('id'))
    				{
    					if(!isset($_POST['redirect']) || $_POST['redirect']=='' || preg_match('/login/',$_POST['redirect']))
    						redirect('admin');
    					else
    						redirect($_POST['redirect']); 
    				}
    				else
    				{
    					$uData=$this->session->userdata("user_data");
    					if($uData->profile_complete==0)
                        {
    						redirect('myaccount/editmyprofile'); 
                        }
                        else if(!isset($_POST['redirect']) || $_POST['redirect']=='' || preg_match('/login/',$_POST['redirect']))
                        {
                            redirect('myaccount'); 
                        }
    					else{
    						redirect($_POST['redirect']);
                        }
    				}
                }
                else
                {
                    if($this->input->get("redirect")!='')
                    {
                        redirect($this->input->get("redirect"));
                    }
                    else
                    {
                        redirect("myaccount");
                    }
                }
			}
			else
			{
				if($flag!=5)
					$this->session->set_flashdata("invalid_login",1);
				redirect('login');
			}
		}
		else
		{
			require_once APPPATH. '/third_party/Facebook/autoload.php';
	        $fb = new \Facebook\Facebook([
	            'app_id' => fb_client_id,
	            'app_secret' => fb_client_secret,
	            'default_graph_version' => 'v3.2',
	        ]);
	        $helper = $fb->getRedirectLoginHelper();
	      
	        $data['helper']=$helper;

			$data['views'] = array('login/login');
			$data["country"]=$this->locations_model->getCountries();
			$this->load->view(FRONTEND_TEMPLATE,$data);
		}
    }

    public function google_login($app=null)
    {
    	if($this->input->get("code")!='')
        {
            $redirect_uri=base_url."login/google_login";

            if($app=="app")
            {
                $redirect_uri=base_url."login/google_login/app";
            }
            $post_fields = 'client_id='.urlencode(google_client_id).
                '&client_secret='.urlencode(google_client_secret).
                '&grant_type=authorization_code'.
                '&code='.urlencode($this->input->get("code")).
                '&redirect_uri='.urlencode($redirect_uri).
                '&response_type=json';
                
            $headers = [
                'Content-Type:application/x-www-form-urlencoded'
            ];
            $token_url='https://www.googleapis.com/oauth2/v4/token';
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $token_url);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            $token_response = curl_exec($ch);
            curl_close($ch);
            $token_response=json_decode($token_response);

            if(isset($token_response->id_token))
            {
                $url='https://www.googleapis.com/oauth2/v3/tokeninfo?id_token='.$token_response->id_token;
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                $response = curl_exec($ch);
                curl_close($ch);
                $response=json_decode($response);
                
                if(isset($response->aud) && $response->aud==google_client_id)
                {
                    if(isset($response->name) && $response->name!='')
                    {
                        $this->load->model('login_validate','login');
						$flag=$this->login->validate_external($response,"google",$app);
                        if($app=="app")
                        {
                            ?>
                            <script type="text/javascript">
                                var getsomething = function(){
                                    var jsonarr=JSON.parse('<?PHP echo $flag; ?>')
                                    var arr=new Array();
                                    arr[0]=1;
                                    arr[1]=jsonarr.access_token;
                                    return arr;
                                };
                            </script>
                            <?PHP
                            exit;
                        }
						if($flag==1 || $flag==2)
						{
							
							if($flag==2)
							{
							  	redirect('/login/pin'); 
							}

							if($this->session->userdata('id'))
							{
								if(!isset($_POST['redirect']) || $_POST['redirect']=='' || preg_match('/login/',$_POST['redirect']))
									redirect('admin');
								else
									redirect($_POST['redirect']); 
							}
							else
							{
								$uData=$this->session->userdata("user_data");
								if($uData->profile_complete==0)
									redirect('myaccount/editmyprofile');
								else
									redirect('myaccount');
							}
						}
						else
						{
							if($flag!=5)
								$this->session->set_flashdata("invalid_login",1);
							redirect('login');
						}

                    }
                }
            }
        }
        error:
        {
        	redirect("login");
        }
    }

    public function facebook_login($app=null)
    {
        if($this->input->get("code")!='')
        {
            $redirect_uri=base_url.'login/facebook_login';
            if($app=='app')
                $redirect_uri=base_url.'login/facebook_login/app';
            
            $token_url='https://graph.facebook.com/v3.2/oauth/access_token?client_id='.fb_client_id.'&client_secret='.fb_client_secret.'&redirect_uri='.$redirect_uri.'&code='.$this->input->get("code");
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $token_url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $token_response = curl_exec($ch);
            curl_close($ch);
            $token_response=json_decode($token_response);

            if(isset($token_response->error))
            {
                goto error;
            }

            $accessToken=$token_response->access_token;

            $url='https://graph.facebook.com/v3.2/me?access_token='.$accessToken.'&fields=name,email&format=json&method=get&pretty=0&suppress_http_code=1';

            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $response = curl_exec($ch);
            $response=json_decode($response);
            
            curl_close($ch);
            if(isset($response->name) && $response->name!='' && isset($response->email) && $response->email!='')
            {
                $this->load->model('login_validate','login');
                $flag=$this->login->validate_external($response,"facebook",$app);
                
                if($app=="app")
                {
                    ?>
                    <script type="text/javascript">
                        var getsomething = function(){
                            var jsonarr=JSON.parse('<?PHP echo $flag; ?>')
                            var arr=new Array();
                            arr[0]=1;
                            arr[1]=jsonarr.access_token;
                            return arr;
                        };
                    </script>
                    <?PHP
                    exit;
                }

                if($flag==1 || $flag==2)
                {
                    
                    if($flag==2)
                    {
                        redirect('/login/pin'); 
                    }

                    if($this->session->userdata('id'))
                    {
                        if(!isset($_POST['redirect']) || $_POST['redirect']=='' || preg_match('/login/',$_POST['redirect']))
                            redirect('admin');
                        else
                            redirect($_POST['redirect']); 
                    }
                    else
                    {
                    	$this->session->set_userdata("fb_access_token",$accessToken);
                        $uData=$this->session->userdata("user_data");
                        if($uData->profile_complete==0)
                            redirect('myaccount/editmyprofile'); 
                        else
                            redirect('myaccount'); 
                    }
                }
                else
                {
                    if($flag!=5)
                        $this->session->set_flashdata("invalid_login",1);
                    redirect('login');
                }
            }
            else
            {
                $this->session->set_flashdata("login_error",'Sorry for the inconvenience. We are having issues creating your account. Please try with another Facebook account.');
                redirect('login');
            }
        }
        error:
        {
            redirect("login");
        }
    }

    public function microsoft_login($app=null)
    {
    	$key='';
        if($this->input->get("code")!='')
        {
            $redirect_uri=base_url."login/microsoft_login";

            if($app=="app")
            {
                $redirect_uri=base_url."login/microsoft_login/app";
            }

            $post_fields = 'client_id='.urlencode(msdn_client_id).
                '&client_secret='.urlencode(msdn_client_secret).
                '&grant_type=authorization_code'.
                '&code='.urlencode($this->input->get("code")).
                '&redirect_uri='.urlencode($redirect_uri).
                '&response_type=json';
                
            $headers = [
                'Content-Type:application/x-www-form-urlencoded'
            ];
            $token_url='https://login.microsoftonline.com/common/oauth2/v2.0/token';
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $token_url);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            $token_response = curl_exec($ch);
            curl_close($ch);
            $token_response=json_decode($token_response);
            if(isset($token_response->id_token))
            {
                $token_parts=explode(".",$token_response->id_token);
                $response=json_decode(base64_decode($token_parts[1]));
                if(isset($response->aud) && $response->aud==msdn_client_id)
                {
                    if(isset($response->name) && $response->name!='')
                    {
                        $this->load->model('login_validate','login');
                        $flag=$this->login->validate_external($response,"microsoft",$app);
                        
                        if($app=="app")
                        {
                            ?>
                            <script type="text/javascript">
                                var getsomething = function(){
                                    var jsonarr=JSON.parse('<?PHP echo $flag; ?>')
                                    var arr=new Array();
                                    arr[0]=1;
                                    arr[1]=jsonarr.access_token;
                                    return arr;
                                };
                            </script>
                            <?PHP
                            exit;
                        }

                        if($flag==1 || $flag==2)
                        {
                            
                            if($flag==2)
                            {
                                redirect('/login/pin'); 
                            }

                            if($this->session->userdata('id'))
                            {
                                if(!isset($_POST['redirect']) || $_POST['redirect']=='' || preg_match('/login/',$_POST['redirect']))
                                    redirect('admin');
                                else
                                    redirect($_POST['redirect']); 
                            }
                            else
                            {
                                $uData=$this->session->userdata("user_data");
                                if($uData->profile_complete==0)
                                    redirect('myaccount/editmyprofile');
                                else
                                    redirect('myaccount');
                            }
                        }
                        else
                        {
                            if($flag!=5)
                                $this->session->set_flashdata("invalid_login",1);
                            redirect('login');
                        }
                    }
                    else
                    {
                    	$this->session->set_flashdata("login_error","Name not set for your Microsoft account.");
                    }
                }
            }
        }
        error:
        {
          	redirect("login");
        }
    }

    public function yahoo_login()
    {
	    if($this->input->get("code")!='')
	    {
            $url='https://api.login.yahoo.com/oauth2/get_token';

            $post_fields = 'client_id='.urlencode(yahoo_client_id).
                '&client_secret='.urlencode(yahoo_client_secret).
                '&grant_type=authorization_code'.
                '&code='.urlencode($this->input->get("code")).
                '&redirect_uri='.urlencode(base_url."login/yahoo_login");
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
            $token_response = curl_exec($ch);
            curl_close($ch);
            $token_response=json_decode($token_response);

            if(isset($token_response->access_token))
            {

	            $url='https://social.yahooapis.com/v1/user/'.$token_response->xoauth_yahoo_guid.'/profile?format=json';
	            $headers = [
	                'Authorization: Bearer '.$token_response->access_token
	            ];
	            $ch = curl_init();
	            curl_setopt($ch, CURLOPT_URL, $url);
	            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
	            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
	            $api_response = curl_exec($ch);
	            curl_close($ch);
	            $api_response=json_decode($api_response);
	            //echo '<pre>';
	            //print_r($api_response);
	            if(isset($api_response->profile) && isset($api_response->profile->emails[0]))
	            {
	            	$this->load->model('login_validate','login');
                    $flag=$this->login->validate_external($api_response,"yahoo");
                    
                    if($flag==1 || $flag==2)
                    {
                        
                        if($flag==2)
                        {
                            redirect('/login/pin'); 
                        }

                        if($this->session->userdata('id'))
                        {
                            if(!isset($_POST['redirect']) || $_POST['redirect']=='' || preg_match('/login/',$_POST['redirect']))
                                redirect('admin');
                            else
                                redirect($_POST['redirect']); 
                        }
                        else
                        {
                            $uData=$this->session->userdata("user_data");
                            if($uData->profile_complete==0)
                                redirect('myaccount/editmyprofile');
                            else
                                redirect('myaccount');
                        }
                    }
                    else
                    {
                        if($flag!=5)
                            $this->session->set_flashdata("invalid_login",1);
                        redirect('login');
                    }
	            }
	        }
	    }
	    error:
        {
          	redirect("login");
        }
    }

	public function register()
	{
		$result['status']=0;
        if($GLOBALS['site_settings']['user_signup']==0)
        {
            goto end;
        }
		if(!isset($_POST["middlename"]) || !isset($_POST["phone"]) || !isset($_POST["country"]) || !isset($_POST["zip"]))
		{
			goto end;
		}

		$this->form_validation->set_rules('firstname', 'First Name', 'trim|required|min_length[2]|max_length[50]|lettersonly');
        $this->form_validation->set_rules('middlename', 'Middle Name', 'trim|max_length[50]|lettersonly');
        $this->form_validation->set_rules('lastname', 'Last Name', 'trim|required|min_length[2]|max_length[50]|lettersonly');
        $this->form_validation->set_rules('email', 'Email ID', 'trim|required|no_uppercase|min_length[6]|max_length[100]|valid_email_custom|emailCheck[0]|emailBounceCheck');
        $this->form_validation->set_rules('username', 'User ID', 'trim|required|min_length[6]|max_length[60]|alphabetsnumbers2|usernameCheck');
        $this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[8]|max_length[50]');
        $this->form_validation->set_rules('rpassword', 'Retype Password', 'trim|required|matches[password]');
        /*$this->form_validation->set_rules('dob', 'Date of Birth', 'required|valid_date|validDob');
        $this->form_validation->set_rules('gender', 'Gender', 'required|valid_gender');*/
        $this->form_validation->set_rules('phone', 'Phone Number', 'trim|numeric|min_length[8]|max_length[15]|noSpaces');
        $this->form_validation->set_rules('country', 'Country', 'trim|countryCheck');
        $this->form_validation->set_rules('zip', 'ZIP Code', 'trim|name_validate14|min_length[3]|max_length[15]');
        $this->form_validation->set_rules('tnc', 'Terms and Conditions', 'required');

		if($this->form_validation->run() == FALSE)
		{
            $result['error_data']=validation_errors();
            goto end;
		}

		$this->load->library('userutil');
		
        $data=$this->userutil->register($_POST);
		
		if($data['flag']==1)
        {
        	$result['status']=1;
        }
	
		end:
		header('Content-Type: application/json');
        echo json_encode($result);
    }
	
    public function password($key=0)
    {
        if($key!='')
        {
        	$this->load->model('user/users_model');
            $this->load->model("user/login_record_model");
            $userData=$this->users_model->userDataByForgotKey($key);
            if(empty($userData))
            {
                $data['views'] = array('common/public/error');
                $this->load->view(FRONTEND_TEMPLATE,$data);
                return;
            }
            else
            {
                if(strtotime($userData->forgot_key_expires_on)<time())
                {
                    $this->login_record_model->insert("Password Reset link expired with key: ".$key,"password_reset_expired");
                    $this->logaction->log($this->service,"Password reset attempt with Key - ".$key," Link expired");
                    
                    $this->session->set_flashdata("link_expired",1);
                    redirect("status");
                }
            }

            $this->logaction->log($this->service,"Password reset attempt with Key - ".$key);
            $this->login_record_model->insert("Password Reset attempt with key: ".$key,"password_reset_attempt",$userData->username,$userData->email);
            $views = array( 'users/public/password_reset_form');
            $data = array('views'=>$views,'key'=>$key);
            $this->load->view(FRONTEND_TEMPLATE,$data);
        }
        else
        {
            $data['views'] = array('common/public/error');
            $this->load->view(FRONTEND_TEMPLATE,$data);
        }
    }

    public function password_update($key=0)
    {
        $data['status']=0;
        if($key!='')
        {
        	$this->load->model('user/users_model');
        	$this->load->model("user/login_record_model");
            $userData=$this->users_model->userDataByForgotKey($key);
            if(empty($userData))
            {
                goto end;
            }
            else
            {
                if(strtotime($userData->forgot_key_expires_on)<time())
                {
                    goto end;
                }
                $this->form_validation->set_rules('new_password', 'Password', 'trim|required|min_length[5]|max_length[50]');
                $this->form_validation->set_rules('confirm_password', 'Confirm Password', 'trim|required|matches[new_password]');
                if($this->form_validation->run() == FALSE)
                {
                    goto end;
                }
                
                $flag=$this->users_model->resetPassword($userData->id,$key,$_POST['new_password']);

                if($flag==1)
                {
                    $this->logaction->log($this->service,"Password reset with Key - ".$key." Reset password successfull");
                    $this->login_record_model->insert("Password Reset with key: ".$key,"password_reset",$userData->username,$userData->email);
                    $data['status']=1;
                    $this->session->set_flashdata("password_reset_success",1);
                }
                else
                    $data['status']=$flag;
            }
        }
        end:
        header('Content-Type: application/json');
        echo json_encode($data);
    }

	public function forgotcheck()
	{
		$result['status']=0;
		$this->form_validation->set_rules('forgot_username', 'User ID / Email ID', 'trim|required|min_length[6]|max_length[100]');
		if($this->form_validation->run() == FALSE)
		{
            goto end;
		}

		$this->load->model('user/users_model');
		$userData=$this->users_model->ssouserDataByEmailorUsername($_POST['forgot_username']);
		if(!empty($userData))
		{
			$this->load->model("user/login_record_model");
            $this->login_record_model->insert("Password Reset email sent","password_reset_sent",$userData->username,$userData->email);
            $this->users_model->sendSSOResetPasswordLink($userData->id);
            $result['status']=1;
            ob_start();
            $this->load->view("login/_forgot_form");
            $result['forgot_form']=ob_get_clean();
		}
		else
		{
			$result['status']=2;
		}

		end:
		header('Content-Type: application/json');
        echo json_encode($result);
	}
	public function securitycheck()
	{
		$result['status']=0;

		$this->form_validation->set_rules('username', 'User ID / Email ID', 'trim|required|min_length[6]|max_length[100]');
		$this->form_validation->set_rules('q1', 'Question 1', 'trim|required|max_length[100]');
        $this->form_validation->set_rules('q2', 'Question 2', 'trim|required|max_length[100]');
        if($this->form_validation->run() == FALSE)
        {
        	goto end;
        }
        $this->load->model('user/users_model');
        $userData=$this->users_model->userDataByEmailorUsername($_POST['username']);
		if(!empty($userData))
		{
			$questions=$this->users_model->getSecurityQuestions($userData->id);
			if(empty($questions))
			{
				goto end;
			}
			$q1_a1=$questions[0]->answer;
			$q2_a2=$questions[1]->answer;
			if($q1_a1==md5(trim($_POST['q1'])) && $q2_a2==md5(trim($_POST['q2'])))
            {
            	$this->load->model("user/login_record_model");
            	$this->login_record_model->insert("Password Reset email sent","password_reset_sent",$userData->username,$userData->email);
                $this->users_model->sendResetPasswordLink($userData->id);
                $result['status']=1;
                ob_start();
				$this->load->view("login/_forgot_form");
				$result['forgot_form']=ob_get_clean();
            }
            else
            {
                $result['status']=2;
            }
		}

		end:
		header('Content-Type: application/json');
        echo json_encode($result);
	}
	 
	public function logout()
	{
		if(!$this->session->userdata("loggedIn"))
		{
			redirect("login");
		}
		else
		{
			if($this->session->userdata("login_method")=='facebook' && !$this->session->userdata("fb_logout_init"))
			{
				if(isset($_SERVER['HTTP_REFERER']))
					$this->session->set_userdata("logout_redirect",$_SERVER['HTTP_REFERER']);
				else
					$this->session->set_userdata("logout_redirect","");

				require_once APPPATH. '/third_party/Facebook/autoload.php';
                $fb = new \Facebook\Facebook([
                    'app_id' => fb_client_id,
                    'app_secret' => fb_client_secret,
                    'default_graph_version' => 'v2.10',
                ]);
                $helper = $fb->getRedirectLoginHelper();
                $this->session->set_userdata("fb_logout_init",1);
                $fb_logout_url=$helper->getLogoutUrl($this->session->userdata("fb_access_token"),base_url."login/logout");
                redirect($fb_logout_url);
                exit;
			}
			if($this->session->userdata("login_method")=='google' && !$this->session->userdata("google_logout_init"))
            {
            	if(isset($_SERVER['HTTP_REFERER']))
					$this->session->set_userdata("logout_redirect",$_SERVER['HTTP_REFERER']);
				else
					$this->session->set_userdata("logout_redirect","");
                $this->session->set_userdata("google_logout_init",1);
                redirect('https://www.google.com/accounts/Logout?continue=https://appengine.google.com/_ah/logout?continue='.base_url."login/logout");
                exit;
            }
            if($this->session->userdata("login_method")=='microsoft' && !$this->session->userdata("microsoft_logout_init"))
            {
            	if(isset($_SERVER['HTTP_REFERER']))
					$this->session->set_userdata("logout_redirect",$_SERVER['HTTP_REFERER']);
				else
					$this->session->set_userdata("logout_redirect","");
                $this->session->set_userdata("microsoft_logout_init",1);
                redirect('https://login.microsoftonline.com/common/oauth2/v2.0/logout?post_logout_redirect_uri='.urlencode(base_url."login/logout"));
                exit;
            }
            if($this->session->userdata("login_method")=='yahoo' && !$this->session->userdata("yahoo_logout_init"))
            {
            	$this->session->set_userdata("yahoo_logout_init",1);
            	?>
            	<script type="text/javascript">
            		var wnd = window.open("https://login.yahoo.com/login?logout=1");
            		setTimeout(function() {
				      	wnd.close();
				      	window.location.reload();
			    	}, 500);
            	</script>
            	<?PHP
            	exit;
            }
		}
		if($this->session->userdata("id"))
		{
			$uid=$this->session->userdata("id");
			$uData=$this->session->userdata("admin_data");
		}
		else
		{
			$uid=$this->session->userdata("user_id");
			$uData=$this->session->userdata("user_data");
		}
		
		$qq=$this->logtrack->insert('login_track',
                    	array
						(
							'time_stamp'=>date("Y:m:d H:i:s"),
							'session_id'=>session_id(),
							'user_id'=>$uid,
							'username'=>$uData->username,
							'email'=>$uData->email,
							'ip_address'=>$_SERVER['REMOTE_ADDR'],
							'browser'=>$this->agent->browser()." ".$this->agent->version(),
							'os_type'=>$this->agent->platform(),
							'message'=>"Logged Out"
						));
		
		$this->session->sess_destroy();
		
		if(isset($_SERVER['HTTP_REFERER']))
			$ref="?redirect=".$this->session->userdata("logout_redirect");
		else
			$ref='';

   		redirect('login'.$ref);
	}

	public function activate($token='')
    {
        if($token!='')
        {
            $token=base64_decode(urldecode($token));
            $username=openssl_decrypt($token, open_ssl_encrypt_method, open_ssl_key, 0, open_ssl_iv);
            $this->load->model("user/users_model");
            $flag=$this->users_model->activateUser(trim($username));
            
            if($flag==1)
            {
                $this->session->set_flashdata("account_activated",1);
                if($this->session->userdata("loggedIn") && $this->session->userdata("user_id"))
                {
                    $userData=$this->session->userdata("user_data");
                    $userData->status=1;
                    $this->session->set_userdata("user_data",$userData);
                }
                redirect(base_url.'status');
            }
            else if($flag==2)
            {
                $this->session->set_flashdata("email_verified",1);
                if($this->session->userdata("loggedIn") && $this->session->userdata("user_id"))
                {
                    $userData=$this->session->userdata("user_data");
                    $userData->email_verified=1;
                    $this->session->set_userdata("user_data",$userData);
                }
                redirect(base_url.'status');
            }
            else if($flag==3)
            {
                $this->session->set_flashdata("email_verified",1);
                redirect(base_url.'status');
            }
            else
            {
                $data['views'] = array('common/public/error');
                $this->load->view(FRONTEND_TEMPLATE,$data);
            }
        }
        else
        {
            $data['views'] = array('common/public/error');
            $this->load->view(FRONTEND_TEMPLATE,$data);
        }

    }

    public function invalid($token='')
    {
        if($token!='')
        {
            $token=base64_decode(urldecode($token));
            $username=openssl_decrypt($token, open_ssl_encrypt_method, open_ssl_key, 0, open_ssl_iv);
            $this->load->model("user/users_model");
            $userData=$this->users_model->userDataByUsername(trim($username));
            
            if(!empty($userData))
            {
            	if($userData->status!=0 || $userData->deleted==1)
            	{
            		goto end;
            	}
            	$this->users_model->hardDeleteUser($userData);
            	$this->session->set_flashdata("account_deleted",1);
            	redirect(base_url.'status');
            }
            else
            {
            	goto end;
            }
        }
        else
        {
        	end:
            $data['views'] = array('common/public/error');
            $this->load->view(FRONTEND_TEMPLATE,$data);
        }

    }

	public function usernamecheck()
    {
        if(isset($_POST['username']) && trim($_POST['username'])!='')
        {
            $this->load->model('user/users_reserved_model');
            $restricted=$this->users_reserved_model->check_restricted_reserved($_POST['username']);
            if($restricted)
            {
                echo "false";
                return;
            }
            $this->load->library('userutil');
            $flag=$this->userutil->verifyUsername($_POST['username'],0);
            if($flag)
            {
                echo "false";
            }
            else
            {
                echo "true";
            }
        }
        else
        {
            echo "false";
        }
    }

    public function emailcheck()
    {
        if(isset($_POST['email']) && trim($_POST['email'])!='')
        {
            $flag=$this->userutil->verifyEmail($_POST['email'],0);
            if($flag==1 || $flag==2)
            {
                echo "false";
            }
            else
            {
                echo "true";
            }
        }
        else
            echo "false";
    }

    public function unsubscribe($token)
    {
        $token=base64_decode(urldecode($token));
        $email=openssl_decrypt($token, open_ssl_encrypt_method, open_ssl_key, 0, open_ssl_iv);
        if($email && isset($_GET['type']) && in_array($_GET['type'],array(1,2,3,4,5)))
        {
            $this->load->model("unsubscribe_log_model");


            if($_GET['type']==1)
            {
                $userId=$email;
                $userData=$this->users_model->userData($userId);
                if(!empty($userData) && $userData->receive_newsletters==0)
                {
                    $this->unsubscribe_log_model->add($userData->email,1);
                    $this->users_model->unsubscribe($userId);
                    $this->session->set_flashdata("status_message","You have successfully unsubscribed to the newsletters");
                    redirect("status");
                }
                else
                {
                    $this->session->set_flashdata("status_message","You have already unsubscribed");
                    redirect("status");
                }
            }
            if($_GET['type']==2) //Ashram newsletter
            {
                if(!empty($_GET['ashram_id']) && is_numeric($_GET['ashram_id']))
                {
                    $userId=$email;
                    $ashramId=$_GET['ashram_id'];
                    $this->load->model("ashrams/ashram_members_model");
                    $this->load->model("ashrams/ashrams_model");
                    $member=$this->ashram_members_model->getMember($ashramId,$userId);
                    $ashramData=$this->ashrams_model->ashramData($ashramId);
                    if(!empty($member) && !empty($ashramData))
                    {
                        $userData=$this->users_model->userData($userId);
                        $this->unsubscribe_log_model->add($userData->email,2);
                        $this->ashram_members_model->unsubscribe($ashramId,$userId);
                        $this->session->set_flashdata("status_message","Successfully unsubscribed to ashram '".htmlentities($ashramData->name)."'");
                        redirect("status");
                    }
                    else
                    {
                        $this->session->set_flashdata("status_message","You have already unsubscribed");
                        redirect("status");
                    }

                }
            }
            if($_GET['type']==3) //Satsang Newsletter
            {
                if(!empty($_GET['satsang_id']) && is_numeric($_GET['satsang_id']))
                {
                    $userId=$email;
                    $satsangId=$_GET['satsang_id'];
                    $this->load->model("satsangs/satsangs_model");
                    $this->load->model("satsangs/satsang_members_model");
                    $satsangData=$this->satsangs_model->satsangData($satsangId);
                    $member=$this->satsang_members_model->getMember($satsangId,$userId);
                    if(!empty($member) && !empty($satsangId))
                    {
                        $userData=$this->users_model->userData($userId);
                        $this->unsubscribe_log_model->add($userData->email,3);
                        $this->satsang_members_model->unsubscribe($satsangId,$userId);
                        $this->session->set_flashdata("status_message","Successfully unsubscribed to satsang '".htmlentities($satsangData->name)."'");
                        redirect("status");
                    }
                    else
                    {
                        $this->session->set_flashdata("status_message","You have already unsubscribed");
                        redirect("status");
                    }
                }
            }
            if($_GET['type']==4)
            {
                $this->load->model("subscriptions_email_model");
                $sdata=$this->subscriptions_email_model->get_by_email($email);
                if(!empty($sdata))
                {
                    $this->subscriptions_email_model->unsubscribe($email);
                    $this->session->set_flashdata("status_message","Successfully unsubscribed to subscription newsletters");
                    redirect("status");
                }
                else
                {
                    $this->session->set_flashdata("status_message","You have already unsubscribed");
                    redirect("status");
                }
            }
            if($_GET['type']==5) //General Newsletter
            {
                if(!empty($_GET['general_newsletter_id']) && is_numeric($_GET['general_newsletter_id']))
                {
                    $userId=$email;
                    $generalNewsletterId=$_GET['general_newsletter_id'];
                    $this->load->model("general_newsletters/general_newsletters_model");
                    $this->load->model("general_newsletters/general_newsletters_email_model");
                    $this->load->model("general_newsletters/general_newsletter_lists_model");
                    $newsletterData=$this->general_newsletters_model->newsletterData($generalNewsletterId);

                    if(isset($newsletterData->list_id) && $newsletterData->list_id>0)
                    {
                        $newsletterListData=$this->general_newsletter_lists_model->getListById($newsletterData->list_id);
                        if(isset($newsletterListData->email_table_name) && $newsletterListData->email_table_name>0)
                        {
                            $member=$this->general_newsletters_email_model->getListById($newsletterListData->email_table_name,$userId);
                            if(!empty($member))
                            {
                                $this->general_newsletters_email_model->updateUnsubscribeEmailStatus($newsletterListData->email_table_name, $member->id, 0);
                                $this->session->set_flashdata("status_message","Successfully unsubscribed to subject '".htmlentities($newsletterData->subject)."'");
                                redirect("status");
                            }
                            else
                            {
                                $this->session->set_flashdata("status_message","You have already unsubscribed");
                                redirect("status");
                            }
                        }
                        else
                        {
                            $this->session->set_flashdata("status_message","You have already unsubscribed");
                            redirect("status");
                        }
                    }
                    else
                    {
                        $this->session->set_flashdata("status_message","You have already unsubscribed");
                        redirect("status");
                    }
                    
                }
            }
        }
        else
        {
            $data['views'] = array('common/public/error');
            $this->load->view(FRONTEND_TEMPLATE,$data);
        }
    }

    public function resendactivationlink()
    {
        if(empty($_POST))
        {
            $data['views'] = array('login/resend_activation_link');
            $this->load->view(FRONTEND_TEMPLATE,$data);
            return true;
        }
        else
        {
            $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email_custom|min_length[3]|max_length[200]', array('required' => 'Please enter your email'));
            if($this->form_validation->run() == true) 
            {
                $this->load->model('user/users_model');
                $userdata = $this->users_model->ssouserDataByEmailorUsername($this->input->post('email'));
                if(empty($userdata))
                {
                    $this->session->set_flashdata('resend_success', 'Activation link sent to your email, Please check and activate to login');
                    redirect(base_url("/login"),'refresh');
                    return true;
                }
                elseif (!empty($userdata) && $userdata->status == 1 && $userdata->email_verified==1) 
                {
                    $this->session->set_flashdata('resend_success', 'Your email is already verified, Please login');
                    redirect(base_url("/login"),'refresh');
                }
                elseif (!empty($userdata) && ($userdata->status == 0 || $userdata->email_verified==0))
                {
                    $this->load->model('userutil_model');
                    $data = $this->userutil_model->sendRegisteredEmail($userdata->id);
                    if($data['flag'] == 1)
                    {
                        $this->session->set_flashdata('resend_success', 'Your email verification link has been sent, Please check your email to activate your account');
                        redirect(base_url("/login"),'refresh');
                    }
                    else
                    {
                        $this->session->set_flashdata('error_message', 'Something wrong, please refresh the page and try again.');
                        $data['views'] = array('login/resend_activation_link');
                        $this->load->view(FRONTEND_TEMPLATE,$data);
                        return true;
                    }
                }
            }
            else
            {
                $data['views'] = array('login/resend_activation_link');
                $this->load->view(FRONTEND_TEMPLATE,$data);
                return true;
            }
        }
    }
}
?>