<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Knowledgebaseadmin extends CI_Controller 
{
	var $currentUser='';
	var $kbTypes=array("1"=>"Admin","2"=>"User","3"=>"Guest");
	public function __construct()
	{
		parent::__construct();
		if($this->session->userdata('id'))
		{
			$this->currentUser=$this->session->userdata("admin_data");
		}
		$this->load->model("content/knowledgebase_model");
	}
	public function index()
	{
		$views = array( 'kb/admin/list_kb');
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data);
	}
	public function listentries($excel=0)
	{
		$list=$this->knowledgebase_model->listKb($excel);
		echo json_encode($list);
	}
	public function add_edit_adminkb($id=0)
	{
		$this->add_edit_kb(1,$id);
	}
	public function add_edit_userkb($id=0)
	{
		$this->add_edit_kb(2,$id);
	}
	public function add_edit_guestkb($id=0)
	{
		$this->add_edit_kb(3,$id);
	}
	private function add_edit_kb($type=1,$id=0)
	{
		if(isset($_POST['save_kb']))
		{
			$this->form_validation->set_rules('title', 'Title', 'trim|required|min_length[2]|max_length[100]');
			$this->form_validation->set_rules('source_url', 'Source URL', 'trim|required|min_length[2]|max_length[100]');
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("kb_error",1);
				if($type==1)
					redirect("knowledgebaseadmin/add_edit_adminkb/".$id);
				if($type==2)
					redirect("knowledgebaseadmin/add_edit_userkb/".$id);
				if($type==3)
					redirect("knowledgebaseadmin/add_edit_guestkb/".$id);
			}
			$kbId=$this->knowledgebase_model->saveKb($id,$type);
			if($id)
			{
				$this->session->set_flashdata("kb_saved",1);
			}
			else
				$this->session->set_flashdata("kb_created",1);

			if($type==1)
				redirect("knowledgebaseadmin/add_edit_adminkb/".$kbId);
			if($type==2)
				redirect("knowledgebaseadmin/add_edit_userkb/".$kbId);
			if($type==3)
				redirect("knowledgebaseadmin/add_edit_guestkb/".$kbId);
		}
		else
		{
			$views = array('kb/admin/add_edit_kb');
			$data = array('views'=>$views,"id"=>0,'type'=>$type);
			if(is_numeric($id) && $id)
			{
				$kbData=$this->knowledgebase_model->kbData($id);
				if(empty($kbData))
				{
					$this->session->set_flashdata("kb_error",1);
					redirect("knowledgebaseadmin");
				}
				if($kbData->type!=$type)
				{
					$this->session->set_flashdata("kb_error",1);
					redirect("knowledgebaseadmin");
				}
				$data['kbData']=$kbData;
				$data['id']=$id;
			}
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}
	public function urlcheck($id)
	{
		if(is_numeric($id) && isset($_POST['url']) && $_POST['url']!='')
		{
			$flag=$this->knowledgebase_model->checkUrl($id,$_POST['url']);
			if($flag!=0)
				echo 0;
			else echo 1;
		}
		else
			echo 0;
	}
	public function updateorder()
	{
		$this->form_validation->set_rules('value', 'Value', 'trim|required|numeric|max_length[3]');
		$this->form_validation->set_rules('pk', 'ID', 'trim|required|numeric|checkKb');
		if($this->form_validation->run() == FALSE)
		{
			echo 0;
			return;
		}
		$this->knowledgebase_model->updateOrder($_POST['pk'],$_POST['value']);
		echo 1;
	}
	function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$kbData=$this->knowledgebase_model->kbData($id);
			if(!empty($kbData))
			{
				$r=$this->knowledgebase_model->delete($id);
				if($r)
				{
					$data['flag']=1;
					$data['title']=$kbData->title;
				}
			}
		}
		echo json_encode($data);
	}
	public function bulk()
	{
		$result['flag']=0;
		if(isset($_POST['bulk_actions']) && $_POST['bulk_actions']=="delete")
		{
			$ex='';
			$count=0;
			if(isset($_POST['ids']))
			foreach($_POST['ids'] as $id)
			{
				$kbData=$this->knowledgebase_model->kbData($id);
				if(!empty($kbData))
				{
					$this->knowledgebase_model->delete($id);
					$count++;
				}
			}
			$result['flag']=1;
			$result['num']=$count;
		}
		echo json_encode($result);
	}
}