<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Knowledgebase extends CI_Controller
{
	var $currentUser='';
	public function __construct()
	{
		parent::__construct();
		if($this->session->userdata('id'))
		{
			$this->currentUser=$this->session->userdata("admin_data");
		}
		else if($this->session->userdata('user_id'))
		{
			$this->currentUser=$this->session->userdata("user_data");
		}
		$this->load->model("content/knowledgebase_model");
	}

	public function view($segment1='',$segment2='',$segment3='')
	{
		if($segment1=='')
		{
			$slug='home';
		}
		else
		{
			$slug=$segment1;
			if($segment2!='')
			{
				$slug.="/".$segment2;
				if($segment3!='')
				{
					$slug.="/".$segment3;
				}
			}
		}

		$role=3;
		if($this->session->userdata('loggedIn'))
		{
			if($this->currentUser->admin==1)
			{
				$cookie =array(
					'name'   => 'npadmin',
					'value'  => "kb",
					'expire' => '30'
				);
				$this->input->set_cookie($cookie);
				$role=1;
			}
			else
			{
				$cookie =array(
					'name'   => 'npuser',
					'value'  => "kb",
					'expire' => '30'
				);
				$this->input->set_cookie($cookie);
				$role=2;
			}
		}

		$kbId=0;
		$kbData=array();
		if($slug!='home')
		{
			$kbData=$this->knowledgebase_model->kbDataBySlug($slug);
		}
		if(empty($kbData))
		{
			$slug='home';
			$kbId=0;
		}
		else
		{
			$kbId=$kbData->id;
			if($role==2)
			{
				if($kbData->type!=2 && $kbData->type!=3)
				{
					$slug='home';
					$kbId=0;
				}
			}
			if($role==3)
			{
				if($kbData->type!=3)
				{
					$slug='home';
					$kbId=0;
				}
			}
		}

		$views=array('kb/public/kb_view');
		$data = array('views'=>$views,'id'=>$kbId,'segment1'=>$segment1);
		$data['json_kb']=json_encode($this->convertTo($kbId,$role));

		if($slug!='home')
		{
			$data['kbData']=$kbData;
		}

		$this->load->view(FRONTEND_TEMPLATE,$data);
	}

	public function kbsearch()
	{
		$role=3;
		if($this->session->userdata('loggedIn'))
		{
			if($this->currentUser->admin==1)
			{
				$cookie =array(
					'name'   => 'npadmin',
					'value'  => "kb",
					'expire' => '30'
				);
				$this->input->set_cookie($cookie);
				$role=1;
			}
			else
			{
				$cookie =array(
					'name'   => 'npuser',
					'value'  => "kb",
					'expire' => '30'
				);
				$this->input->set_cookie($cookie);
				$role=2;
			}
		}

		$searchText = trim(strtolower($this->input->get('search_text')));
		$list=array();
		if($searchText!='')
		{
			$list = $this->knowledgebase_model->searchKb($searchText,$role);
		}

		$views=array('kb/public/kb_view');
		$data = array('views'=>$views,'list'=>$list);
		$data['json_kb']=json_encode($this->convertTo(0,$role));
		$this->load->view(FRONTEND_TEMPLATE,$data);
	}

	private function convertTo($currentKbId=0,$type=3)
    {
    	$result=array();
    	$kbTypes=array();
    	if($type==1)
    	{
    		$kbTypes[]=1;
    		$kbTypes[]=2;
    	}
    	if($type==2)
    	{
    		$kbTypes[]=2;
    	}

    	$kbTypes[]=3;
    	foreach ($kbTypes as $type)
    	{
    		$parentKeys=array_keys($this->knowledgebase_model->kbList[$type]['parent_kbs']);

	    	foreach ($this->knowledgebase_model->kbList[$type]['kbs'] as $key => $kbData) 
	    	{
	    		if(is_numeric($key))
	    		{
	    			if($currentKbId && $kbData->id==$currentKbId)
	    			{
	    				$temp['state']['selected']="true".$kbData->id;
	    				$temp['state']['opened']="true".$kbData->id;
	    			}
	    			$kk=11;
	    			if(!isset($this->knowledgebase_model->kbList[$type]['parent_kbs'][$kbData->id]))
	    			{
		    			$temp['type']='file';
	    			}

		    		$temp['text']=$kbData->title;
		    		$temp['id']=$kbData->id;
		    		$temp['a_attr']['data-id']=$kbData->id;
		    		$temp['a_attr']['href']=base_url.$kbData->kb_url;
		    		$temp['a_attr']['class']="tree-element";
		    		$temp['li_attr']['class']="ele";

		    		if($kbData->parent==0)
		    			$temp['parent']="#";
		    		else
		    			$temp['parent']=$kbData->parent;

		    		$result[]=$temp;
		    		unset($temp);
		    	}
	    	}
	    }
	    
    	return $result;
    }
}
?>