<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
class Gennewslettersadmin extends CI_Controller 
{
	var $service='websiteadmin';
	var $groups = '';
	var $lists = '';
    function __construct()
    {
        parent::__construct();
		if($this->session->userdata('id'))
		{
			$this->currentUser=$this->session->userdata("admin_data");
		}
		$this->load->model("general_newsletters/general_newsletters_email_model");
		$this->load->model("general_newsletters/general_newsletters_sms_model");
		$this->load->model("general_newsletters/general_newsletter_groups_model");
		$this->load->model("general_newsletters/general_newsletter_lists_model");
		$this->load->model("general_newsletters/general_newsletters_model");
		$this->load->model("general_newsletters/general_newsletters_images_model");
		$this->load->model("general_newsletters/general_newsletters_email_que_model");
		$this->load->model("general_newsletters/general_newsletters_sms_que_model");
		$this->groups = $this->general_newsletter_groups_model->getAllGroups();
		$this->lists = $this->general_newsletter_lists_model->getAllLists();
    }
    public function index()
	{
		$views = array( 'general_newsletters/admin/list' );
		$data = array('views'=>$views);
		$data['emailLists'] = $this->general_newsletter_lists_model->getAllEmailLists();
		$this->load->view(ADMIN_TEMPLATE,$data);  
	}
	public function switchGeneralNewsletter($generalNewsletterId=0)
	{
		if(is_numeric($generalNewsletterId))
			$this->session->set_userdata("generalNewsletterId",$generalNewsletterId);
	}
	public function sms()
	{
		$views = array( 'general_newsletters/admin/list_sms' );
		$data = array('views'=>$views);
		$data['smsLists'] = $this->general_newsletter_lists_model->getAllSmsLists();
		$this->load->view(ADMIN_TEMPLATE,$data);  
	}
	public function liste($excel=0)
	{
		$list=$this->general_newsletters_email_model->getList($excel);
		echo json_encode($list);
	}
	public function lists($excel=0)
	{
		$list=$this->general_newsletters_sms_model->getList($excel);
		echo json_encode($list);
	}
	public function sms_delete($list_id=0,$id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id && is_numeric($list_id) && $list_id)
		{
			$listData = $this->general_newsletter_lists_model->getListById($list_id);
			
			if(empty($listData))
			{
				goto end;
			}
			if(!isset($listData->sms_table_name) || $listData->sms_table_name=='')
			{
				goto end;
			}
			$newsletterSmsData=$this->general_newsletters_sms_model->newsletterSmsData($listData->sms_table_name,$id);
			// echo '<pre>'; print_r($newsletterSmsData); die();
			if(empty($newsletterSmsData))
			{
				goto end;
			}
			$this->general_newsletters_sms_model->delete($listData->sms_table_name,$id);
			$data['flag']=1;
			$data['phone']='+'.$newsletterSmsData->isd_code."-".$newsletterSmsData->phone;
		}
		end:
		echo json_encode($data);
	}
	public function group_delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$groupData = $this->general_newsletter_groups_model->getGroupById($id);
			if(empty($groupData))
			{
				goto end;
			}
			$listData = $this->general_newsletter_lists_model->getListById($groupData->list_id);
			$smscheck = $this->general_newsletter_groups_model->subsmsDatabyGroupId($id, $listData->sms_table_name);
			$emailcheck = $this->general_newsletter_groups_model->subemailDatabyGroupId($id, $listData->email_table_name);
			if($smscheck || $emailcheck)
			{
				$data['flag']=2;
				$data['group']=$groupData->group_name;
			}
			else
			{
				$this->general_newsletter_groups_model->delete($id);
				$data['flag']=1;
				$data['group']=$groupData->group_name;
			}
		}
		end:
		echo json_encode($data);
	}
	public function email_delete($list_id=0,$id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id && is_numeric($list_id) && $list_id)
		{
			$listData = $this->general_newsletter_lists_model->getListById($list_id);
			if(empty($listData))
			{
				goto end;
			}
			if(!isset($listData->email_table_name) || $listData->email_table_name=='')
			{
				goto end;
			}
			$newsletterEmailData=$this->general_newsletters_email_model->newsletterEmailData($listData->email_table_name,$id);
			if(empty($newsletterEmailData))
			{
				goto end;
			}
			$this->general_newsletters_email_model->delete($listData->email_table_name,$id);
			$data['flag']=1;
			$data['email']=$newsletterEmailData->email;
		}
		end:
		echo json_encode($data);
	}
	public function newsletters()
	{
		$views = array( 'general_newsletters/admin/list_newsletters' );
		$data = array('views'=>$views);
		// $data['newsletterLists'] = $this->general_newsletter_lists_model->getAllLists();
		$data['newsletterLists'] = $this->general_newsletter_lists_model->getAllActiveLists();
		$this->load->view(ADMIN_TEMPLATE,$data);
		$this->logaction->log($this->service,"User - Viewed newsletters page");
	}
	public function listns($excel=0)
	{
		$list=$this->general_newsletters_model->listNewsletters($excel);
		echo json_encode($list);
		$this->logaction->log($this->service,"User - Viewed newsletters ajax request");
	}

	public function mail_queue($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$newsletterData=$this->general_newsletters_model->newsletterData($id);
			if(empty($newsletterData))
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect("gennewslettersadmin");
			}
			if($newsletterData->type==1)
				$views = array( 'general_newsletters/admin/list_newsletter_queue');
			if($newsletterData->type==2)
				$views = array( 'general_newsletters/admin/list_newsletter_sms_queue');
			$data = array('views'=>$views);
			$data['newsletterData']=$newsletterData;
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
		else
		{
			$this->session->set_flashdata("newsletter_error",1);
			redirect('gennewslettersadmin');
		}
	}
	public function listqueue($id=0,$excel=0)
	{
		if(is_numeric($id) && $id)
		{
			$newsletterData=$this->general_newsletters_model->newsletterData($id);
			if(empty($newsletterData))
			{
				return;
			}
			if($newsletterData->type==1)
				$list=$this->general_newsletters_email_que_model->listQueue($newsletterData,$excel);
			if($newsletterData->type==2)
				$list=$this->general_newsletters_sms_que_model->listQueue($newsletterData,$excel);

			echo json_encode($list);
		}
	}

	public function add_edit_newsletter($id=0)
	{
		if(isset($_POST["add_newsletter"]) || isset($_POST["send_newsletter"]))
		{
			if(!isset($_POST['content']))
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect('gennewslettersadmin/add_edit_newsletter/'.$id);
			}
			$this->form_validation->set_rules('nsl_list_id', 'Newsletter List', 'trim|numeric');
			$this->form_validation->set_rules('type', 'Type', 'trim|numeric|newsletterType');
			if($this->input->post("type")==1)
			{
				$this->form_validation->set_rules('subject', 'Newsletter Subject', 'trim|required|min_length[6]|max_length[200]');
			}
			else if($this->input->post("type")==2)
			{
				$this->form_validation->set_rules('message', 'Message', 'trim|required|min_length[6]|max_length[300]');
			}

			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect('gennewslettersadmin/add_edit_newsletter/'.$id);
				return;
			}
			if($id)
			{
				$newsletterData=$this->general_newsletters_model->newsletterData($id);

				if(empty($newsletterData))
				{
					$this->session->set_flashdata("newsletter_error",1);
					redirect("gennewslettersadmin");
				}
				if($newsletterData->status!=1)
				{
					$this->session->set_flashdata("newsletter_error",1);
					redirect("gennewslettersadmin");
				}
			}
			$saved=$this->general_newsletters_model->save($id);
			
			if($saved)
			{
				if($id)
				{
					$this->session->set_flashdata("newsletter_saved",1);
				}
				else
				{
					$this->session->set_flashdata("newsletter_created",1);
				}
				if(isset($_POST['send_newsletter']))
				{
					$this->general_newsletters_model->sendNewsletter($saved);
					redirect('gennewslettersadmin/view_newsletter/'.$saved);
					return;
				}
			}
			redirect('gennewslettersadmin/add_edit_newsletter/'.$saved);
		}
		else
		{
		 	$views = array( 'general_newsletters/admin/add_edit_newsletter' );
		 	$data = array('views'=>$views,'id'=>$id);
		 	$data['newsletterLists'] = $this->general_newsletter_lists_model->getAllActiveLists();
			if($id)
			{
				if($this->session->userdata("generalNewsletterId"))
	            {
	            	$data['selectedNewsletterListData'] = $this->general_newsletter_lists_model->getListById($this->session->userdata("generalNewsletterId"));
	            }
	            // echo '<pre>'; print_r($data['selectedNewsletterListData']); die();
				$data['newsletterData']=$this->general_newsletters_model->newsletterData($id);
				if($data['newsletterData']->field_userids!='')
			 	{
			 		if($data['newsletterData']->type==1)
			 		{
			 			if(isset($data['selectedNewsletterListData']->email_table_name) && $data['selectedNewsletterListData']->email_table_name!='')
			 			{
			 				$data['users']=$this->general_newsletters_email_model->getByIds(explode(",",$data['newsletterData']->field_userids), $data['selectedNewsletterListData']->email_table_name);
			 			}
			 			else
			 			{
			 				$data['users']= (object)[];
			 			}
			 		}
			 		else if($data['newsletterData']->type==2)
			 		{
			 			if(isset($data['selectedNewsletterListData']->sms_table_name) && $data['selectedNewsletterListData']->sms_table_name!='')
			 			{
			 				$data['users']=$this->general_newsletters_sms_model->getByIds(explode(",",$data['newsletterData']->field_userids), $data['selectedNewsletterListData']->sms_table_name);
			 			}
			 			else
			 			{
			 				$data['users']= (object)[];
			 			}
			 		}
			 	}
			 	if($data['newsletterData']->field_groups!='')
			 	{
			 		$data['groupids']=$this->general_newsletter_groups_model->getGroupNamesbyIds(explode(",",$data['newsletterData']->field_groups));
			 	}
			 	if($data['newsletterData']->field_country!='')
			 	{
			 		$data['countries']=$this->locations_model->getCountriesByCode(explode(",",$data['newsletterData']->field_country));
			 	}

				if(empty($data['newsletterData']))
				{
					$this->session->set_flashdata("newsletter_error",1);
					redirect("gennewslettersadmin");
				}
				if($data['newsletterData']->status==2)
				{
					redirect("gennewslettersadmin/view_newsletter/".$id);
				}
			}
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	public function view_newsletter($id=0)
	{
		if(is_numeric($id) && $id)
		{
			$newsletterData=$this->general_newsletters_model->newsletterData($id);

			if($newsletterData->list_id)
			{
				$newsletterListData = $this->general_newsletter_lists_model->getListById($newsletterData->list_id);

				$newsletterData->newsletter_list_name = $newsletterListData->list_name;
			}
			else
			{
				$newsletterData->newsletter_list_name = "";
			}

			if($newsletterData->field_groups)
				$newsletterData->field_groups = $this->general_newsletter_groups_model->getGroupNames($newsletterData->field_groups);
			else
				$newsletterData->field_groups = "";

			if(empty($newsletterData))
			{
				$this->session->set_flashdata("newsletter_error",1);
				redirect("gennewslettersadmin");
			}
			if($newsletterData->status!=2)
			{
				redirect("gennewslettersadmin/add_edit_newsletter/".$id);
			}
		 	$views = array('general_newsletters/admin/view_newsletter');
		 	$data = array('views'=>$views,'id'=>$id);
			$data['newsletterData']=$newsletterData;
			$data['countries']=$this->locations_model->getCountriesByCode(explode(",",$data['newsletterData']->field_country));

			if($data['newsletterData']->field_userids!='')
		 	{
		 		if(isset($data['newsletterData']->list_id) && $data['newsletterData']->list_id!='')
	            {
	            	$data['selectedNewsletterListData'] = $this->general_newsletter_lists_model->getListById($data['newsletterData']->list_id);
	            }
		 		if($data['newsletterData']->type==1)
		 		{
		 			if(isset($data['selectedNewsletterListData']->email_table_name) && $data['selectedNewsletterListData']->email_table_name!='')
		 			{
		 				$data['users']=$this->general_newsletters_email_model->getByIds(explode(",",$data['newsletterData']->field_userids), $data['selectedNewsletterListData']->email_table_name);
		 			}
		 			else
		 			{
		 				$data['users']= (object)[];
		 			}
		 		}
		 		else if($data['newsletterData']->type==2)
		 		{
		 			if(isset($data['selectedNewsletterListData']->sms_table_name) && $data['selectedNewsletterListData']->sms_table_name!='')
		 			{
		 				$data['users']=$this->general_newsletters_sms_model->getByIds(explode(",",$data['newsletterData']->field_userids), $data['selectedNewsletterListData']->sms_table_name);
		 			}
		 			else
		 			{
		 				$data['users']= (object)[];
		 			}
		 		}
		 	}
			$this->load->view(ADMIN_TEMPLATE,$data);
		}
		else
		{
			$this->session->set_flashdata("newsletter_error",1);
			redirect("gennewslettersadmin");
		}
	}

	public function delete($id=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id)
		{
			$newsletterData=$this->general_newsletters_model->newsletterData($id);
			if(!empty($newsletterData) && $newsletterData->status==1)
			{
				$r=$this->general_newsletters_model->delete($id,$newsletterData);
				if($r)
				{
					$data['flag']=1;
					$data['unique_id']=$newsletterData->unique_id;
				}
			}
		}
		echo json_encode($data);
	}

	public function resend($id=0,$qid=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id && is_numeric($qid) && $qid)
		{
			$newsletterData=$this->general_newsletters_model->newsletterData($id);
			if(empty($newsletterData))
			{
				goto end;
			}
			$resendTableName = '';
			if($newsletterData->type==1)
			{
				$resendTableName = $newsletterData->email_table_name;
			}
			else if($newsletterData->type==2)
			{
				$resendTableName = $newsletterData->sms_table_name;
			}
			if($resendTableName=='')
			{
				goto end;
			}

			$mailData=$this->general_newsletters_email_que_model->mailData($qid,$resendTableName);
			if(empty($mailData) || $mailData->newsletter_id!=$id || $mailData->status==0)
			{
				goto end;
			}
			$r=$this->general_newsletters_email_que_model->resend($qid,$mailData,$resendTableName);
			if($r)
			{
				$data['flag']=1;
				$data['email']=$mailData->mail_to;
			}
		}
		end:
		echo json_encode($data);
	}

	public function resendsms($id=0,$qid=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id && is_numeric($qid) && $qid)
		{
			$newsletterData=$this->general_newsletters_model->newsletterData($id);
			if(empty($newsletterData))
			{
				goto end;
			}
			$resendTableName = '';
			if($newsletterData->type==1)
			{
				$resendTableName = $newsletterData->email_table_name;
			}
			else if($newsletterData->type==2)
			{
				$resendTableName = $newsletterData->sms_table_name;
			}
			if($resendTableName=='')
			{
				goto end;
			}

			$smsData=$this->general_newsletters_sms_que_model->smsData($qid,$resendTableName);
			if(empty($smsData) || $smsData->newsletter_id!=$id || $smsData->status==0)
			{
				goto end;
			}
			$r=$this->general_newsletters_sms_que_model->resend($qid,$smsData,$resendTableName);
			if($r)
			{
				$data['flag']=1;
				$data['phone']='+'.$smsData->isd_code."-".$smsData->to;
			}
		}
		end:
		echo json_encode($data);
	}

	public function email_list_groups()
	{
		$views = array( 'general_newsletters/admin/list_groups' );
		$data = array('views'=>$views);
		$data['newsletterLists'] = $this->general_newsletter_lists_model->getAllActiveLists();
		$this->load->view(ADMIN_TEMPLATE,$data); 
	}

	public function listemailgroups($excel=0)
	{
		$list=$this->general_newsletter_groups_model->getList($excel);
		echo json_encode($list);
	}

	public function add_edit_group($id = 0)
	{
		
		if(isset($_POST["add_group"]))
		{
			$listId = $_POST["nsl_list_id"];
			$this->form_validation->set_rules('nsl_list_id', 'Newsletter List', 'trim|numeric');
			$this->form_validation->set_rules('group_name', 'Group', "trim|required|min_length[3]|max_length[100]|name_validate11|generalNewsletterGroupCheck[$id, $listId]");
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata('group_error',1);
				redirect('gennewslettersadmin/add_edit_group/'.$id);
			}
			$saved=$this->general_newsletter_groups_model->saveGroup($id);
			if($saved)
			{
				if($id)
					$this->session->set_flashdata('group_saved',1);
				else
					$this->session->set_flashdata('group_created',1);
			}
			else
				$this->session->set_flashdata('group_error',1);
			redirect('gennewslettersadmin/add_edit_group/'.$saved);
		}
		else
		{
		 	$views = array( 'general_newsletters/admin/add_edit_group' );
		 	$data = array('views'=>$views,'id'=>$id);
		 	$data['allNslLists'] = $this->general_newsletter_lists_model->getAllActiveLists();
		 	$groupData = $this->general_newsletter_groups_model->getGroupById($id);
			if($id && !empty($groupData))
			{
				$data['groupData']=$groupData;
				if(isset($groupData->list_id) && $groupData->list_id!='' && $groupData->list_id!=0)
				{
					$data['listData'] = $this->general_newsletter_lists_model->getListById($groupData->list_id);
				}
			}
			if($id && empty($groupData))
			{
				$this->session->set_flashdata('group_error',1);
				redirect('gennewslettersadmin/email_list_groups');
			}
		 	$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	public function group_exists($groupID=0, $listId=0)
	{
		if(is_numeric($groupID))
			echo $this->general_newsletter_groups_model->groupexistCheck(trim($_POST['name']),$groupID, $listId);
		else
			echo 0;
	}

	public function update($service)
	{
		$newsletterId = $this->input->post('pk'); #PrimaryKey
		$inputName = $this->input->post('name');
		$groups = $this->input->post('value');
		$list_id = $this->input->post('listid');
		if($list_id=='' || $list_id==0)
		{
			echo "List is required, please refresh page and try again";
			return false;
		}
		$listData = $this->general_newsletter_lists_model->getListById($list_id);
		if(empty($listData))
		{
			echo "Newsletter list is not found";
			return false;
		}
		$updateTableName = "";
		if($service == "sms")
		{
			if(isset($listData->sms_table_name))
			{
				$updateTableName = $listData->sms_table_name;
			}
		}
		if($service == "email")
		{
			if(isset($listData->email_table_name))
			{
				$updateTableName = $listData->email_table_name;
			}
		}
		if($updateTableName=="")
		{
			echo "Newsletter list table not found";
			return false;
		}
		if($newsletterId && $inputName && $groups && $service)
		{
			if($inputName == "name")
			{
				if (!preg_match('/^[a-zA-Z0-9 \.\-\,\"]+$/i', $this->input->post('value')))
				{
					echo "please enter valid Name";
					return false;
				}
				$updatedata = array('name'=>$groups);
			}
			if($inputName == "mobile")
			{
				if($this->form_validation->numeric($this->input->post('value'))==false)
				{
					echo "please enter valid Phone";
					return false;
				}
				$uch=$this->general_newsletters_sms_model->phoneCheck($this->input->post('value'),$newsletterId,$updateTableName);
				if($uch)
				{
					echo "Mobile Number Already Existed";
					return false;
				}
				$updatedata = array('phone'=>$groups);
			}
			if($inputName == "country")
			{
				if($this->form_validation->countryCheck($this->input->post('value'))==false)
				{
					echo "please enter valid Country";
					return false;
				}

				$updatedata = array('country_code'=>$this->input->post('value'));
				if($service == "sms" && $this->input->post('value')!='')
				{
					$countryData=$this->locations_model->getCountryByCode($this->input->post('value'));
					if(isset($countryData->isd_code) && $countryData->isd_code!='')
					{
						$updatedata['isd_code'] = $countryData->isd_code;
					}
				}
			}
			if($inputName == "email")
			{
				if($this->form_validation->valid_email_custom($this->input->post('value'))==false)
				{
					echo "please enter valid Email";
					return false;
				}
				$uch=$this->general_newsletters_email_model->emailCheck($this->input->post('value'),$newsletterId,$updateTableName);
				if($uch)
				{
					echo "Email Already Existed";
					return false;
				}
				$updatedata = array('email'=>$groups);
			}
			if($inputName == "city")
			{
				if($this->form_validation->name_validate13($this->input->post('value'))==false)
				{
					echo "please enter valid City";
					return false;
				}
				$updatedata = array('city'=>$groups);
			}
			if($service == "sms")
				$success = $this->general_newsletters_sms_model->update($updatedata,$newsletterId,0,$updateTableName);
			if($service == "email")
				$success = $this->general_newsletters_email_model->updategroups($updatedata,$newsletterId,0,$updateTableName);
			if($success)
				echo 1;
		} 
		else 
		{
			echo "Not Updated, Please try again.";
		}
		
	}

	public function updategroups($service)
	{
		$newsletterId = $this->input->post('pk'); #PrimaryKey
		$inputName = $this->input->post('name');
		$groups = $this->input->post('value');
		$list_id = $this->input->post('listid');
		if($list_id=='' || $list_id==0)
		{
			echo "List is required, please refresh page and try again";
			return false;
		}
		$listData = $this->general_newsletter_lists_model->getListById($list_id);
		if(empty($listData))
		{
			echo "Newsletter list is not found";
			return false;
		}
		$updateTableName = "";
		if($service == "sms")
		{
			if(isset($listData->sms_table_name))
			{
				$updateTableName = $listData->sms_table_name;
			}
		}
		if($service == "email")
		{
			if(isset($listData->email_table_name))
			{
				$updateTableName = $listData->email_table_name;
			}
		}
		if($updateTableName=="")
		{
			echo "Newsletter list table not found";
			return false;
		}
		if($newsletterId && $inputName && $groups && $service)
		{
			$groupsdata = $this->general_newsletter_groups_model->insertupdategroup($groups,$list_id);
			if($service == "sms")
				$this->general_newsletters_sms_model->update($groupsdata,$newsletterId,1,$updateTableName);
			if($service == "email")
				$this->general_newsletters_email_model->updategroups($groupsdata,$newsletterId,1,$updateTableName);
			$this->session->set_flashdata("groups_success",1);
			echo 1;
		} 
		else 
		{
			echo "Group Not assigned, Please try again.";
		}
	}

	public function add_bulk_sms_newsletters()
	{
		if(isset($_POST['save_nsl_sms_csv']))
		{

			if(!isset($_POST['nsl_sms_list_id']) || $_POST['nsl_sms_list_id']=='' || $_POST['nsl_sms_list_id']==0)
			{
				$this->session->set_flashdata("upload_error1","Newsletter list is required");
				redirect("gennewslettersadmin/add_bulk_sms_newsletters");
			}
			if(!isset($_FILES['nsl_sms_file']['name']) || $_FILES['nsl_sms_file']['name']=='')
			{
				$this->session->set_flashdata("upload_error1","Invalid file");
				redirect("gennewslettersadmin/add_bulk_sms_newsletters");
			}
			$listData = $this->general_newsletter_lists_model->getListById($_POST['nsl_sms_list_id']);
			// echo '<pre>'; print_r($listData); die();
			if(empty($listData))
			{
				$this->session->set_flashdata("upload_error1","Newsletter list is not found");
				redirect("gennewslettersadmin/add_bulk_sms_newsletters");
			}
			$smsTableName = '';
			if(isset($listData->sms_table_name))
			{
				$smsTableName = $listData->sms_table_name;
			}
			
			if($smsTableName=="")
			{
				$this->session->set_flashdata("upload_error1","Newsletter sms table is not found");
				redirect("gennewslettersadmin/add_bulk_sms_newsletters");
			}
			$this->load->model("user/users_reserved_model");
			
			$name=$_FILES['nsl_sms_file']['name'];
			$tmp=$_FILES['nsl_sms_file']['tmp_name'];
			move_uploaded_file($tmp,dirname($_SERVER['SCRIPT_FILENAME'])."/site_services/admin_files/".$name);
			
			$this->load->library("Excel");
			$inputFileName = dirname($_SERVER['SCRIPT_FILENAME'])."/site_services/admin_files/".$name;
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objReader->setReadDataOnly(true);//Get the area of data inserted
			$objPHPExcel = $objReader->load($inputFileName);

			$sheetData=$objPHPExcel->getActiveSheet()->toArray(null,true,true,true);

			$cols=$sheetData[1];
			if(count($cols)!=5)
			{
				$this->session->set_flashdata("upload_error1","Invalid data format.");
				redirect("gennewslettersadmin/add_bulk_sms_newsletters");
			}
			if($cols['A']!='name' || $cols['B']!='phone' || $cols['C']!='country_code' || $cols['D']!='city' || $cols['E']!='group_ids' )
			{
				$this->session->set_flashdata("upload_error1","Invalid data format");
				redirect("gennewslettersadmin/add_bulk_sms_newsletters");
			}
			unset($sheetData[1]);

			if(count($sheetData)==0)
			{
				$this->session->set_flashdata("upload_error1","File contains no data.");
				redirect("gennewslettersadmin/add_bulk_sms_newsletters");
			}
			
			$rownum=1;
			$error='';
			$skipped=0;
			$done=0;
			$e=0;
			$tempnum=0;
			foreach($sheetData as $rr)
			{
				if(trim($rr['A'])=='')
				{
					if($error!='') $error.="<br>";
					$error.="Row No:$rownum Name is required";
					$rownum++;
					$skipped++;
					continue;
				}
				if(trim($rr['B'])=='')
				{
					if($error!='') $error.="<br>";
					$error.="Row No:$rownum Phone is required";
					$rownum++;
					$skipped++;
					continue;
				}
				if(trim($rr['C'])=='')
				{
					if($error!='') $error.="<br>";
					$error.="Row No:$rownum Country code is required";
					$rownum++;
					$skipped++;
					continue;
				}
				if(trim($rr['D'])=='')
				{
					if($error!='') $error.="<br>";
					$error.="Row No:$rownum City is required";
					$rownum++;
					$skipped++;
					continue;
				}
				if(trim($rr['E'])=='')
				{
					if($error!='') $error.="<br>";
					$error.="Row No:$rownum Group ID is required";
					$rownum++;
					$skipped++;
					continue;
				}

				$e=0;
				$eName=trim($rr['A']);
				$ePhone=trim($rr['B']);
				$eCountry=trim($rr['C']);
				$eCity=trim($rr['D']);
				$eGroup_ids=trim($rr['E']);
				if(strlen(trim($rr['A']))<2)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					$e=1;
					$error.="Row No:$rownum Name must be at least 3 character";
				}
				else if(strlen(trim($rr['A']))>100)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					$e=1;
					$error.="Row No:$rownum Name must not be more than 100 characters";
				}
				else if (!preg_match('/^[a-zA-Z0-9 \.\-\,\"]+$/i', trim($rr['A'])))
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					$e=1;
					$error.="Row No:$rownum Name must contain letters and numbers only";
				}

				//Groups Validation
				if($eGroup_ids!='')
				{
					$groupcheck=$this->general_newsletter_groups_model->groupvalidationWithListId($eGroup_ids, $listData->id);
					// $groupcheck=$this->general_newsletter_groups_model->groupvalidation($eGroup_ids);
					if($groupcheck)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						if($e==0) $error.=" Row No: $rownum";
						else $error.=" | ";
						$error.=" Invalid Groups Assigned ";
						$e=1;
					}
				}
				
				//Mobile Number Validation
				if($ePhone!='')
				{
					if(strlen($ePhone)<10)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						if($e==0) $error.=" Row No: $rownum";
						else $error.=" | ";
						$error.=" Phone Number must be at least 10 characters";
						$e=1;
					}
					
					else if(strlen($ePhone)>15)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						if($e==0) $error.=" Row No: $rownum";
						else $error.=" | ";
						$error.=" Phone Number must not be more than 15 characters ";
						$e=1;
					}
					else if ($this->form_validation->numeric($ePhone)==false)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						if($e==0) $error.=" Row No: $rownum";
						else $error.=" | ";
						$error.=" Phone Number must be numeric ";
						$e=1;
					}
					else
					{
						$uch=$this->general_newsletters_sms_model->phoneCheck($ePhone,0,$smsTableName);
						if($uch)
						{
							if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
							if($e==0) $error.=" Row No: $rownum";
							else $error.=" | ";
							$error.=" Phone number already exists ";
							$e=1;
						}
					}
				}
				if($eCity != "")
				{
					if(strlen($eCity)<2)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) 
							$error.=' ,';
						$e=1;
						$error.="Row No:$rownum City must be at least 2 character";
					}
					else if ($this->form_validation->name_validate13($eCity)==false)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						if($e==0) $error.=" Row No: $rownum";
						else $error.=" | ";
						$error.=" City is invalid ";
						$e=1;
					}
				}
				

				if ($this->form_validation->countryCheck($eCountry)==false)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					if($e==0) $error.=" Row No: $rownum";
					else $error.=" | ";
					$error.=" Country is invalid ";
					$e=1;
				}
				
				$tempnum=$rownum;
				
				$rownum++;
				if($e==0)
				{
					$rInfo['subscribe_name2']=$eName;
					$rInfo['country_code']=strtoupper($eCountry);
					$rInfo['subscribe_city2']=$eCity;
					$rInfo['group_ids']=$eGroup_ids;
					$rInfo['subscribe_phone']=$ePhone;
					$rInfo['sms_table_name']=$smsTableName;
					$rInfo['list_id']=$_POST['nsl_sms_list_id'];

					$data=$this->general_newsletters_sms_model->subscribe($rInfo);
					$done++;
				}
				else $skipped++;
				
			}
			$this->session->set_flashdata("upload_error",$error);
			$this->session->set_flashdata("upload_done",1);
			$this->session->set_flashdata("skipped",$skipped);
			$this->session->set_flashdata("done",$done);
			redirect("gennewslettersadmin/add_bulk_sms_newsletters");
		}
		$views = array( 'general_newsletters/admin/bulk_sms_newsletters_upload');
		$data = array('views'=>$views);
		$data['smsLists'] = $this->general_newsletter_lists_model->getActiveSmsLists();
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	
	public function add_bulk_email_newsletters()
	{
		if(isset($_POST['save_nsl_email_csv']))
		{
			// echo '<pre>'; print_r($_POST); die();
			if(!isset($_POST['nsl_email_list_id']) || $_POST['nsl_email_list_id']=='' || $_POST['nsl_email_list_id']==0)
			{
				$this->session->set_flashdata("upload_error1","Newsletter list is required");
				redirect("gennewslettersadmin/add_bulk_email_newsletters");
			}
			if(!isset($_FILES['nsl_email_file']['name']) || $_FILES['nsl_email_file']['name']=='')
			{
				$this->session->set_flashdata("upload_error1","Invalid file");
				redirect("gennewslettersadmin/add_bulk_email_newsletters");
			}
			$listData = $this->general_newsletter_lists_model->getListById($_POST['nsl_email_list_id']);
			// echo '<pre>'; print_r($listData); die();
			if(empty($listData))
			{
				$this->session->set_flashdata("upload_error1","Newsletter list is not found");
				redirect("gennewslettersadmin/add_bulk_email_newsletters");
			}
			$emailTableName = '';
			if(isset($listData->email_table_name))
			{
				$emailTableName = $listData->email_table_name;
			}
			
			if($emailTableName=="")
			{
				$this->session->set_flashdata("upload_error1","Newsletter email table is not found");
				redirect("gennewslettersadmin/add_bulk_email_newsletters");
			}
			$this->load->model("user/users_reserved_model");
			
			$name=$_FILES['nsl_email_file']['name'];
			$tmp=$_FILES['nsl_email_file']['tmp_name'];
			move_uploaded_file($tmp,dirname($_SERVER['SCRIPT_FILENAME'])."/site_services/admin_files/".$name);
			
			$this->load->library("Excel");
			$inputFileName = dirname($_SERVER['SCRIPT_FILENAME'])."/site_services/admin_files/".$name;
			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
			$objReader->setReadDataOnly(true);//Get the area of data inserted
			$objPHPExcel = $objReader->load($inputFileName);

			$sheetData=$objPHPExcel->getActiveSheet()->toArray(null,true,true,true);

			$cols=$sheetData[1];
			if(count($cols)!=5)
			{
				$this->session->set_flashdata("upload_error1","Invalid data format.");
				redirect("gennewslettersadmin/add_bulk_email_newsletters");
			}
			if($cols['A']!='name' || $cols['B']!='email' || $cols['C']!='country_code' || $cols['D']!='city' || $cols['E']!='group_ids')
			{
				$this->session->set_flashdata("upload_error1","Invalid data format");
				redirect("gennewslettersadmin/add_bulk_email_newsletters");
			}
			unset($sheetData[1]);

			if(count($sheetData)==0)
			{
				$this->session->set_flashdata("upload_error1","File contains no data.");
				redirect("gennewslettersadmin/add_bulk_email_newsletters");
			}
			
			$rownum=1;
			$error='';
			$skipped=0;
			$done=0;
			$e=0;
			$tempnum=0;
			foreach($sheetData as $rr)
			{
				if(trim($rr['A'])=='')
				{
					if($error!='') $error.="<br>";
					$error.="Row No:$rownum Name is required";
					$rownum++;
					$skipped++;
					continue;
				}
				if(trim($rr['B'])=='')
				{
					if($error!='') $error.="<br>";
					$error.="Row No:$rownum Email is required";
					$rownum++;
					$skipped++;
					continue;
				}
				if(trim($rr['C'])=='')
				{
					if($error!='') $error.="<br>";
					$error.="Row No:$rownum Country code is required";
					$rownum++;
					$skipped++;
					continue;
				}
				if(trim($rr['D'])=='')
				{
					if($error!='') $error.="<br>";
					$error.="Row No:$rownum City is required";
					$rownum++;
					$skipped++;
					continue;
				}
				if(trim($rr['E'])=='')
				{
					if($error!='') $error.="<br>";
					$error.="Row No:$rownum Group ID is required";
					$rownum++;
					$skipped++;
					continue;
				}
				$e=0;
				$eName=trim($rr['A']);
				$eEmail=trim($rr['B']);
				$eCountry=trim($rr['C']);
				$eCity=trim($rr['D']);
				$eGroup_ids=trim($rr['E']);
				if(strlen(trim($rr['A']))<2)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					$e=1;
					$error.="Row No:$rownum Name must be at least 3 character";
				}
				else if(strlen(trim($rr['A']))>100)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					$e=1;
					$error.="Row No:$rownum Name must not be more than 100 characters";
				}
				else if (!preg_match('/^[a-zA-Z0-9 \.\-\,\"]+$/i', trim($rr['A'])))
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					$e=1;
					$error.="Row No:$rownum Name must contain letters and numbers only";
				}

				//Groups Validation
				if($eGroup_ids!='')
				{
					$groupcheck=$this->general_newsletter_groups_model->groupvalidationWithListId($eGroup_ids, $listData->id);
					if($groupcheck)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						if($e==0) $error.=" Row No: $rownum";
						else $error.=" | ";
						$error.=" Invalid Groups Assigned ";
						$e=1;
					}
				}
				
				//Email Validations				
				if(strlen($eEmail)<6)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					$e=1;
					$error.="Row No:$rownum Email ID must be at least 6 character";
				}
				else if(strlen($eEmail)>200)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					$e=1;
					$error.="Row No:$rownum Email ID must not be more than 200 characters";
				}
				else if ($this->form_validation->valid_email_custom($eEmail)==false)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					if($e==0) $error.=" Row No: $rownum";
					else $error.=" | ";
					$e=1;
					$error.="Row No:$rownum Email ID is invalid";
				}
				else
				{
					$uch=$this->general_newsletters_email_model->emailCheck($eEmail,0,$emailTableName);
					if($uch)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						if($e==0) $error.=" Row No: $rownum";
						else $error.=" | ";
						$error.=" Email ID already exists ";
						$e=1;
					}
				}
				if($eCity != "")
				{
					if(strlen($eCity)<2)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						$e=1;
						$error.="Row No:$rownum City must be at least 2 character";
					}
					else if ($this->form_validation->name_validate13($eCity)==false)
					{
						if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
						if($e==0) $error.=" Row No: $rownum";
						else $error.=" | ";
						$error.=" City is invalid ";
						$e=1;
					}
				}
				if ($this->form_validation->countryCheck($eCountry)==false)
				{
					if($tempnum && $tempnum!=$rownum && $e==0) $error.=' ,';
					if($e==0) $error.=" Row No: $rownum";
					else $error.=" | ";
					$error.=" Country is invalid ";
					$e=1;
				}
				
				$tempnum=$rownum;
				
				$rownum++;
				if($e==0)
				{
					$rInfo['subscribe_name1']=$eName;
					$rInfo['group_ids']=$eGroup_ids;
					$rInfo['country_code1']=strtoupper($eCountry);
					$rInfo['subscribe_city1']=$eCity;
					$rInfo['subscribe_email']=$eEmail;
					$rInfo['email_verify']=1;
					$rInfo['gnl_list_id']=$_POST['nsl_email_list_id'];
					$rInfo['email_table_name']=$emailTableName;
					$rInfo['list_id']=$_POST['nsl_email_list_id'];

					$data=$this->general_newsletters_email_model->subscribe($rInfo);
					$done++;
				}
				else $skipped++;
				
			}
			$this->session->set_flashdata("upload_error",$error);
			$this->session->set_flashdata("upload_done",1);
			$this->session->set_flashdata("skipped",$skipped);
			$this->session->set_flashdata("done",$done);
			redirect("gennewslettersadmin/add_bulk_email_newsletters");
		}
		$views = array( 'general_newsletters/admin/bulk_email_newsletters_upload');
		$data = array('views'=>$views);
		$data['emailLists'] = $this->general_newsletter_lists_model->getActiveEmailLists();
		$this->load->view(ADMIN_TEMPLATE,$data);
	}

	public function bulk_delete()
	{
		$result['flag']=0;
		$result['msg']="Invalid request";
		if(isset($_POST['bulk_actions']) && $_POST['bulk_actions']=="remove" && $_POST['service_slug'] && isset($_POST['listid']) && $_POST['listid']>0)
		{
			$ex='';
			$count=0;
			if(isset($_POST['ids']))
			{
				$list_id = $_POST['listid'];
				$listData = $this->general_newsletter_lists_model->getListById($list_id);
				foreach($_POST['ids'] as $id)
				{
					if($_POST['service_slug'] == "sms")
					{
						if(isset($listData->sms_table_name) || $listData->sms_table_name!='')
						{
							$newsletterSmsData=$this->general_newsletters_sms_model->newsletterSmsData($listData->sms_table_name,$id);
							$data=$this->general_newsletters_sms_model->delete($listData->sms_table_name,$id);
							$count++;
						}
					}
						
					if($_POST['service_slug'] == "email")
					{
						if(isset($listData->email_table_name) || $listData->email_table_name!='')
						{
							$newsletterSmsData=$this->general_newsletters_email_model->newsletterEmailData($listData->email_table_name,$id);
							$data=$this->general_newsletters_email_model->delete($listData->email_table_name,$id);
							$count++;
						}
					}
					
				}
			}
			$result['flag']=1;
			$result['msg']="'".$count."' General Newsletter(s) ".$_POST['service_slug']." have been deleted successfully.";
			$result['num']=$count;
		}
		echo json_encode($result);
	}

	public function bulk_group_assign()
	{
		$result['flag']=0;
		$result['msg']="Invalid request";
		if(isset($_POST['bulk_actions']) && $_POST['service_slug'] && isset($_POST['listid']) && $_POST['listid']>0)
		{
			$ex='';
			$count=0;
			if(isset($_POST['ids']))
			{
				$list_id = $_POST['listid'];
				$listData = $this->general_newsletter_lists_model->getListById($list_id);
				foreach($_POST['ids'] as $id)
				{
					if($_POST['service_slug'] == "sms")
					{
						if(isset($listData->sms_table_name) || $listData->sms_table_name!='')
						{
							$groupData = $this->general_newsletters_sms_model->checkGroups($id,$_POST['group_data'],$listData->sms_table_name);
							$data=$this->general_newsletters_sms_model->update(array("group_id"=>$groupData),$id,0,$listData->sms_table_name);
							$count++;
						}
					}
					if($_POST['service_slug'] == "email")
					{
						if(isset($listData->email_table_name) || $listData->email_table_name!='')
						{
							$groupData = $this->general_newsletters_email_model->checkGroups($id,$_POST['group_data'],$listData->email_table_name);
							$data=$this->general_newsletters_email_model->updategroups(array("group_id"=>$groupData),$id,0,$listData->email_table_name);
							$count++;
						}
					}
				}
			}
			$result['flag']=1;
			$result['msg']="'".$count."' General Newsletter group(s) have been Assigned successfully.";
			$result['num']=$count;
		}
		echo json_encode($result);
	}

	public function searchuser()
	{
		$query = (!empty($_POST['q'])) ? strtolower($_POST['q']) : null;
		 
		if (!isset($query)) {
		    die('Invalid query.');
		}
		 
		$status = true;
		$this->logaction->log($this->service,"Searched subscribers with - ".$query);
		if($this->input->post('type')==1)
			$usersData=$this->general_newsletters_email_model->searchAll($query);
		else if($this->input->post('type')==2)
			$usersData=$this->general_newsletters_sms_model->searchAll($query);

		$resultUsers = [];
		foreach ($usersData as $oneUser)
		{
			if($this->input->post("type")==1)
			{
				$resultUsers[]=array("id"=>$oneUser['id'],"text"=>$oneUser['name']." (".$oneUser['email'].")");
			}
			else if($this->input->post("type")==2)
			{
				$resultUsers[]=array("id"=>$oneUser['id'],"text"=>$oneUser['name']." (+".$oneUser['isd_code'].$oneUser['phone'].")");
			}
			else
				$resultUsers[] = $oneUser;
		}
		// Means no result were found
		if (empty($resultUsers)) 
		{
		    $status = false;
		}
		 
		header('Content-Type: application/json');
		 
		echo json_encode(array(
		    "status" => $status,
		    "error"  => null,
		    "data"   => array(
		        "user"      => $resultUsers
		    )
		));
	}
	public function searchcountries()
	{
		$query = (!empty($_POST['q'])) ? strtolower($_POST['q']) : null;
		 
		if (!isset($query)) {
		    die('Invalid query.');
		}
		 
		$status = true;
		$this->logaction->log($this->service,"Searched countries with - ".$query);
		if($this->input->post('type')==1)
			$countriesData=$this->general_newsletters_email_model->searchCountries($query);
		else if($this->input->post('type')==2)
			$countriesData=$this->general_newsletters_sms_model->searchCountries($query);

		$resultCountries = [];
		foreach ($countriesData as $country)
		{
			if($this->input->post("type")==2)
			{
				$resultCountries[]=array("id"=>$country['country_code'],"text"=>$country['country_name']." (+".$country['isd_code'].")");
			}
			else
				$resultCountries[] = array("id"=>$country['country_code'],"text"=>$country['country_name']);
		}
		// Means no result were found
		if (empty($resultCountries)) 
		{
		    $status = false;
		}
		 
		header('Content-Type: application/json');
		 
		echo json_encode(array(
		    "status" => $status,
		    "error"  => null,
		    "data"   => array(
		        "country"      => $resultCountries
		    )
		));
	}

	public function searchgroups()
	{
		$query = (!empty($_POST['q'])) ? strtolower($_POST['q']) : null;
		 
		if (!isset($query)) {
		    die('Invalid query.');
		}
		 
		$status = true;
		$this->logaction->log($this->service,"Searched general newsletter groups with - ".$query);
		if($this->input->post('type')==1)
			$usersData=$this->general_newsletters_email_model->searchbyGroupAll($query);
		else if($this->input->post('type')==2)
			$usersData=$this->general_newsletters_sms_model->searchbyGroupAll($query);

		$resultUsers = [];
		foreach ($usersData as $oneUser)
		{
			if($this->input->post("type")==1)
			{
				$resultUsers[]=array("id"=>$oneUser['id'],"text"=>$oneUser['group_name']);
			}
			else if($this->input->post("type")==2)
			{
				$resultUsers[]=array("id"=>$oneUser['id'],"text"=>$oneUser['group_name']);
			}
			else
				$resultUsers[] = $oneUser;
		}
		// Means no result were found
		if (empty($resultUsers)) 
		{
		    $status = false;
		}
		 
		header('Content-Type: application/json');
		 
		echo json_encode(array(
		    "status" => $status,
		    "error"  => null,
		    "data"   => array(
		        "groups"      => $resultUsers
		    )
		));
	}


	public function email_lists()
	{
		$views = array( 'general_newsletters/admin/list_lists' );
		$data = array('views'=>$views);
		$this->load->view(ADMIN_TEMPLATE,$data); 
	}

	public function list_email_lists($excel=0)
	{
		$list=$this->general_newsletter_lists_model->getList($excel);
		echo json_encode($list);
	}

	public function add_edit_list($id = 0)
	{
		
		if(isset($_POST["add_list"]))
		{
			$this->form_validation->set_rules('list_name', 'List', "trim|required|min_length[2]|max_length[30]|name_validate11|generalNewslaterListCheck[$id]");
			if($this->form_validation->run() == FALSE)
			{
				$this->session->set_flashdata('list_error',1);
				redirect('gennewslettersadmin/add_edit_list/'.$id);
			}
			$saved=$this->general_newsletter_lists_model->saveList($id);
			if($saved)
			{
				if($id)
					$this->session->set_flashdata('list_saved',1);
				else
					$this->session->set_flashdata('list_created',1);
			}
			else
				$this->session->set_flashdata('list_error',1);
			redirect('gennewslettersadmin/add_edit_list/'.$saved);
		}
		else
		{
		 	$views = array( 'general_newsletters/admin/add_edit_list' );
		 	$data = array('views'=>$views,'id'=>$id);
		 	$listData = $this->general_newsletter_lists_model->getListById($id);
			if($id && !empty($listData))
			{
				$data['listData']=$listData;
			}
			if($id && empty($listData))
			{
				$this->session->set_flashdata('list_error',1);
				redirect('gennewslettersadmin/email_lists');
			}
		 	$this->load->view(ADMIN_TEMPLATE,$data);
		}
	}

	public function list_exists($listID=0)
	{
		if(is_numeric($listID))
			echo $this->general_newsletter_lists_model->listexistCheck(trim($_POST['name']),$listID);
		else
			echo 0;
	}

	public function change_list_status($id=0, $status=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && is_numeric($status) && $id)
		{
			$listData = $this->general_newsletter_lists_model->getListById($id);
			if(empty($listData))
			{
				goto end;
			}
			$flag=$this->general_newsletter_lists_model->changeListStatus($id,$listData,$status);
			$data['flag']=1;
			$data['list']=$listData->list_name;
		}
		end:
		echo json_encode($data);
	}

	public function searchlists()
	{
		$query = (!empty($_POST['q'])) ? strtolower($_POST['q']) : null;
		 
		if (!isset($query)) {
		    die('Invalid query.');
		}
		 
		$status = true;
		$this->logaction->log($this->service,"Searched newslaters lists with - ".$query);
		if($this->input->post('type')==1)
			$usersData=$this->general_newsletters_email_model->searchbyGroupAll($query);
		else if($this->input->post('type')==2)
			$usersData=$this->general_newsletters_sms_model->searchbyGroupAll($query);

		$resultLists = [];
		foreach ($usersData as $thisList)
		{
			if($this->input->post("type")==1)
			{
				$resultLists[]=array("id"=>$thisList['id'],"text"=>$thisList['list_name']);
			}
			else if($this->input->post("type")==2)
			{
				$resultLists[]=array("id"=>$thisList['id'],"text"=>$thisList['list_name']);
			}
			else
				$resultLists[] = $thisList;
		}
		// Means no result were found
		if (empty($resultLists)) 
		{
		    $status = false;
		}
		 
		header('Content-Type: application/json');
		 
		echo json_encode(array(
		    "status" => $status,
		    "error"  => null,
		    "data"   => array(
		        "lists"      => $resultLists
		    )
		));
	}

	public function email_subscribe_unsubscribe($list_id=0,$id=0,$status=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id && is_numeric($list_id) && $list_id && ($status==0 || $status==1) )
		{
			$listData = $this->general_newsletter_lists_model->getListById($list_id);
			if(empty($listData))
			{
				goto end;
			}
			if(!isset($listData->email_table_name) || $listData->email_table_name=='')
			{
				goto end;
			}
			$newsletterEmailData=$this->general_newsletters_email_model->newsletterEmailData($listData->email_table_name,$id);
			if(empty($newsletterEmailData))
			{
				goto end;
			}
			$this->general_newsletters_email_model->updateUnsubscribeEmailStatus($listData->email_table_name,$id, $status);
			$data['flag']=1;
			$data['email']=$newsletterEmailData->email;
		}
		end:
		echo json_encode($data);
	}


	public function sms_subscribe_unsubscribe($list_id=0,$id=0,$status=0)
	{
		$data['flag']=0;
		if(is_numeric($id) && $id && is_numeric($list_id) && $list_id && ($status==0 || $status==1) )
		{
			$listData = $this->general_newsletter_lists_model->getListById($list_id);
			if(empty($listData))
			{
				goto end;
			}
			if(!isset($listData->sms_table_name) || $listData->sms_table_name=='')
			{
				goto end;
			}
			$newsletterSmsData=$this->general_newsletters_sms_model->newsletterSmsData($listData->sms_table_name,$id);
			if(empty($newsletterSmsData))
			{
				goto end;
			}
			$this->general_newsletters_sms_model->updateUnsubscribeSmsStatus($listData->sms_table_name,$id, $status);
			$data['flag']=1;
			$data['name']=$newsletterSmsData->name;
		}
		end:
		echo json_encode($data);
	}
	
	// public function listemails(){}
	// public function listsms(){}
	// public function email_data(){}
	// public function sms_data(){}
	// public function email_resend(){}
	// public function bulk_resend(){}
	// public function sms_resend(){}
	// public function sms_bulk_resend(){}
}
?>